/*
 * Project home: https://github.com/jaxio/celerio-angular-quickstart
 * 
 * Source code generated by Celerio, an Open Source code generator by Jaxio.
 * Documentation: http://www.jaxio.com/documentation/celerio/
 * Source code: https://github.com/jaxio/celerio/
 * Follow us on twitter: @jaxiosoft
 * This header can be customized in Celerio conf...
 * Template pack-angular:src/main/java/dto/EntityDTOService.java.e.vm
 */
package com.mycompany.myapp.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.inject.Inject;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.mycompany.myapp.domain.UseCase2;
import com.mycompany.myapp.domain.UseCase3;
import com.mycompany.myapp.domain.UseCase3Pk;
import com.mycompany.myapp.domain.UseCase3_;
import com.mycompany.myapp.dto.support.PageRequestByExample;
import com.mycompany.myapp.dto.support.PageResponse;
import com.mycompany.myapp.repository.UseCase2Repository;
import com.mycompany.myapp.repository.UseCase3Repository;

/**
 * A simple DTO Facility for UseCase3.
 */
@Service
public class UseCase3DTOService {

    @Inject
    private UseCase3Repository useCase3Repository;
    @Inject
    private UseCase2DTOService useCase2DTOService;
    @Inject
    private UseCase2Repository useCase2Repository;

    @Transactional(readOnly = true)
    public UseCase3DTO findOne(UseCase3Pk id) {
        return toDTO(useCase3Repository.findOne(id));
    }

    @Transactional(readOnly = true)
    public List<UseCase3DTO> complete(String query, int maxResults) {
        List<UseCase3> results = useCase3Repository.complete(query, maxResults);
        return results.stream().map(this::toDTO).collect(Collectors.toList());
    }

    @Transactional(readOnly = true)
    public PageResponse<UseCase3DTO> findAll(PageRequestByExample<UseCase3DTO> req) {
        Example<UseCase3> example = null;
        UseCase3 useCase3 = toEntity(req.example);

        if (useCase3 != null) {
            ExampleMatcher matcher = ExampleMatcher.matching() //
                    .withMatcher(UseCase3_.dummy.getName(), match -> match.ignoreCase().startsWith());

            example = Example.of(useCase3, matcher);
        }

        Page<UseCase3> page;
        if (example != null) {
            page = useCase3Repository.findAll(example, req.toPageable());
        } else {
            page = useCase3Repository.findAll(req.toPageable());
        }

        List<UseCase3DTO> content = page.getContent().stream().map(this::toDTO).collect(Collectors.toList());
        return new PageResponse<>(page.getTotalPages(), page.getTotalElements(), content);
    }

    /**
     * Save the passed dto as a new entity or update the corresponding entity if any.
     */
    @Transactional
    public UseCase3DTO save(UseCase3DTO dto) {
        if (dto == null) {
            return null;
        }

        final UseCase3 useCase3;

        if (dto.isIdSet()) {
            UseCase3 useCase3Tmp = useCase3Repository.findOne(dto.id);
            if (useCase3Tmp != null) {
                useCase3 = useCase3Tmp;
            } else {
                useCase3 = new UseCase3();
                useCase3.setId(dto.id);
            }
        } else {
            useCase3 = new UseCase3();
        }

        useCase3.setDummy(dto.dummy);

        if (dto.id2 == null) {
            useCase3.setId2(null);
        } else {
            UseCase2 id2 = useCase3.getId2();
            if (id2 == null || (id2.getId().compareTo(dto.id2.id) != 0)) {
                useCase3.setId2(useCase2Repository.findOne(dto.id2.id));
            }
        }

        return toDTO(useCase3Repository.save(useCase3));
    }

    /**
     * Converts the passed useCase3 to a DTO.
     */
    public UseCase3DTO toDTO(UseCase3 useCase3) {
        return toDTO(useCase3, 1);
    }

    /**
     * Converts the passed useCase3 to a DTO. The depth is used to control the
     * amount of association you want. It also prevents potential infinite serialization cycles.
     *
     * @param useCase3
     * @param depth the depth of the serialization. A depth equals to 0, means no x-to-one association will be serialized.
     *              A depth equals to 1 means that xToOne associations will be serialized. 2 means, xToOne associations of
     *              xToOne associations will be serialized, etc.
     */
    public UseCase3DTO toDTO(UseCase3 useCase3, int depth) {
        if (useCase3 == null) {
            return null;
        }

        UseCase3DTO dto = new UseCase3DTO();

        dto.id = useCase3.getId();
        dto.dummy = useCase3.getDummy();
        if (depth-- > 0) {
            dto.id2 = useCase2DTOService.toDTO(useCase3.getId2(), depth);
        }

        return dto;
    }

    /**
     * Converts the passed dto to a UseCase3.
     * Convenient for query by example.
     */
    public UseCase3 toEntity(UseCase3DTO dto) {
        return toEntity(dto, 1);
    }

    /**
     * Converts the passed dto to a UseCase3.
     * Convenient for query by example.
     */
    public UseCase3 toEntity(UseCase3DTO dto, int depth) {
        if (dto == null) {
            return null;
        }

        UseCase3 useCase3 = new UseCase3();

        useCase3.setId(dto.id);
        useCase3.setDummy(dto.dummy);
        if (depth-- > 0) {
            useCase3.setId2(useCase2DTOService.toEntity(dto.id2, depth));
        }

        return useCase3;
    }
}