/*
 * Project home: https://github.com/jaxio/celerio-angular-quickstart
 * 
 * Source code generated by Celerio, an Open Source code generator by Jaxio.
 * Documentation: http://www.jaxio.com/documentation/celerio/
 * Source code: https://github.com/jaxio/celerio/
 * Follow us on twitter: @jaxiosoft
 * This header can be customized in Celerio conf...
 * Template pack-angular:src/main/java/dto/EntityDTOService.java.e.vm
 */
package com.mycompany.myapp.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.inject.Inject;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.mycompany.myapp.domain.UseCase2;
import com.mycompany.myapp.domain.UseCase2_;
import com.mycompany.myapp.dto.support.PageRequestByExample;
import com.mycompany.myapp.dto.support.PageResponse;
import com.mycompany.myapp.repository.UseCase2Repository;

/**
 * A simple DTO Facility for UseCase2.
 */
@Service
public class UseCase2DTOService {

    @Inject
    private UseCase2Repository useCase2Repository;

    @Transactional(readOnly = true)
    public UseCase2DTO findOne(String id) {
        return toDTO(useCase2Repository.findOne(id));
    }

    @Transactional(readOnly = true)
    public List<UseCase2DTO> complete(String query, int maxResults) {
        List<UseCase2> results = useCase2Repository.complete(query, maxResults);
        return results.stream().map(this::toDTO).collect(Collectors.toList());
    }

    @Transactional(readOnly = true)
    public PageResponse<UseCase2DTO> findAll(PageRequestByExample<UseCase2DTO> req) {
        Example<UseCase2> example = null;
        UseCase2 useCase2 = toEntity(req.example);

        if (useCase2 != null) {
            ExampleMatcher matcher = ExampleMatcher.matching() //
                    .withMatcher(UseCase2_.dummy.getName(), match -> match.ignoreCase().startsWith());

            example = Example.of(useCase2, matcher);
        }

        Page<UseCase2> page;
        if (example != null) {
            page = useCase2Repository.findAll(example, req.toPageable());
        } else {
            page = useCase2Repository.findAll(req.toPageable());
        }

        List<UseCase2DTO> content = page.getContent().stream().map(this::toDTO).collect(Collectors.toList());
        return new PageResponse<>(page.getTotalPages(), page.getTotalElements(), content);
    }

    /**
     * Save the passed dto as a new entity or update the corresponding entity if any.
     */
    @Transactional
    public UseCase2DTO save(UseCase2DTO dto) {
        if (dto == null) {
            return null;
        }

        final UseCase2 useCase2;

        if (dto.isIdSet()) {
            UseCase2 useCase2Tmp = useCase2Repository.findOne(dto.id);
            if (useCase2Tmp != null) {
                useCase2 = useCase2Tmp;
            } else {
                useCase2 = new UseCase2();
                useCase2.setId(dto.id);
            }
        } else {
            useCase2 = new UseCase2();
        }

        useCase2.setDummy(dto.dummy);

        return toDTO(useCase2Repository.save(useCase2));
    }

    /**
     * Converts the passed useCase2 to a DTO.
     */
    public UseCase2DTO toDTO(UseCase2 useCase2) {
        return toDTO(useCase2, 1);
    }

    /**
     * Converts the passed useCase2 to a DTO. The depth is used to control the
     * amount of association you want. It also prevents potential infinite serialization cycles.
     *
     * @param useCase2
     * @param depth the depth of the serialization. A depth equals to 0, means no x-to-one association will be serialized.
     *              A depth equals to 1 means that xToOne associations will be serialized. 2 means, xToOne associations of
     *              xToOne associations will be serialized, etc.
     */
    public UseCase2DTO toDTO(UseCase2 useCase2, int depth) {
        if (useCase2 == null) {
            return null;
        }

        UseCase2DTO dto = new UseCase2DTO();

        dto.id = useCase2.getId();
        dto.dummy = useCase2.getDummy();
        if (depth-- > 0) {
        }

        return dto;
    }

    /**
     * Converts the passed dto to a UseCase2.
     * Convenient for query by example.
     */
    public UseCase2 toEntity(UseCase2DTO dto) {
        return toEntity(dto, 1);
    }

    /**
     * Converts the passed dto to a UseCase2.
     * Convenient for query by example.
     */
    public UseCase2 toEntity(UseCase2DTO dto, int depth) {
        if (dto == null) {
            return null;
        }

        UseCase2 useCase2 = new UseCase2();

        useCase2.setId(dto.id);
        useCase2.setDummy(dto.dummy);
        if (depth-- > 0) {
        }

        return useCase2;
    }
}