/*
 * Project home: https://github.com/jaxio/celerio-angular-quickstart
 * 
 * Source code generated by Celerio, an Open Source code generator by Jaxio.
 * Documentation: http://www.jaxio.com/documentation/celerio/
 * Source code: https://github.com/jaxio/celerio/
 * Follow us on twitter: @jaxiosoft
 * This header can be customized in Celerio conf...
 * Template pack-angular:src/main/java/dto/EntityDTOService.java.e.vm
 */
package com.mycompany.myapp.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.inject.Inject;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.mycompany.myapp.domain.Author;
import com.mycompany.myapp.domain.Project;
import com.mycompany.myapp.domain.Project_;
import com.mycompany.myapp.dto.support.PageRequestByExample;
import com.mycompany.myapp.dto.support.PageResponse;
import com.mycompany.myapp.repository.AuthorRepository;
import com.mycompany.myapp.repository.ProjectRepository;

/**
 * A simple DTO Facility for Project.
 */
@Service
public class ProjectDTOService {

    @Inject
    private ProjectRepository projectRepository;
    @Inject
    private AuthorDTOService authorDTOService;
    @Inject
    private AuthorRepository authorRepository;

    @Transactional(readOnly = true)
    public ProjectDTO findOne(Integer id) {
        return toDTO(projectRepository.findOne(id));
    }

    @Transactional(readOnly = true)
    public List<ProjectDTO> complete(String query, int maxResults) {
        List<Project> results = projectRepository.complete(query, maxResults);
        return results.stream().map(this::toDTO).collect(Collectors.toList());
    }

    @Transactional(readOnly = true)
    public PageResponse<ProjectDTO> findAll(PageRequestByExample<ProjectDTO> req) {
        Example<Project> example = null;
        Project project = toEntity(req.example);

        if (project != null) {
            ExampleMatcher matcher = ExampleMatcher.matching() //
                    .withMatcher(Project_.name.getName(), match -> match.ignoreCase().startsWith())
                    .withMatcher(Project_.url.getName(), match -> match.ignoreCase().startsWith());

            example = Example.of(project, matcher);
        }

        Page<Project> page;
        if (example != null) {
            page = projectRepository.findAll(example, req.toPageable());
        } else {
            page = projectRepository.findAll(req.toPageable());
        }

        List<ProjectDTO> content = page.getContent().stream().map(this::toDTO).collect(Collectors.toList());
        return new PageResponse<>(page.getTotalPages(), page.getTotalElements(), content);
    }

    /**
     * Save the passed dto as a new entity or update the corresponding entity if any.
     */
    @Transactional
    public ProjectDTO save(ProjectDTO dto) {
        if (dto == null) {
            return null;
        }

        final Project project;

        if (dto.isIdSet()) {
            Project projectTmp = projectRepository.findOne(dto.id);
            if (projectTmp != null) {
                project = projectTmp;
            } else {
                project = new Project();
                project.setId(dto.id);
            }
        } else {
            project = new Project();
        }

        project.setName(dto.name);

        project.setUrl(dto.url);

        project.setOpenSource(dto.openSource);

        if (dto.author == null) {
            project.setAuthor(null);
        } else {
            Author author = project.getAuthor();
            if (author == null || (author.getId().compareTo(dto.author.id) != 0)) {
                project.setAuthor(authorRepository.findOne(dto.author.id));
            }
        }

        return toDTO(projectRepository.save(project));
    }

    /**
     * Converts the passed project to a DTO.
     */
    public ProjectDTO toDTO(Project project) {
        return toDTO(project, 1);
    }

    /**
     * Converts the passed project to a DTO. The depth is used to control the
     * amount of association you want. It also prevents potential infinite serialization cycles.
     *
     * @param project
     * @param depth the depth of the serialization. A depth equals to 0, means no x-to-one association will be serialized.
     *              A depth equals to 1 means that xToOne associations will be serialized. 2 means, xToOne associations of
     *              xToOne associations will be serialized, etc.
     */
    public ProjectDTO toDTO(Project project, int depth) {
        if (project == null) {
            return null;
        }

        ProjectDTO dto = new ProjectDTO();

        dto.id = project.getId();
        dto.name = project.getName();
        dto.url = project.getUrl();
        dto.openSource = project.getOpenSource();
        if (depth-- > 0) {
            dto.author = authorDTOService.toDTO(project.getAuthor(), depth);
        }

        return dto;
    }

    /**
     * Converts the passed dto to a Project.
     * Convenient for query by example.
     */
    public Project toEntity(ProjectDTO dto) {
        return toEntity(dto, 1);
    }

    /**
     * Converts the passed dto to a Project.
     * Convenient for query by example.
     */
    public Project toEntity(ProjectDTO dto, int depth) {
        if (dto == null) {
            return null;
        }

        Project project = new Project();

        project.setId(dto.id);
        project.setName(dto.name);
        project.setUrl(dto.url);
        project.setOpenSource(dto.openSource);
        if (depth-- > 0) {
            project.setAuthor(authorDTOService.toEntity(dto.author, depth));
        }

        return project;
    }
}