/*
 * Project home: https://github.com/jaxio/celerio-angular-quickstart
 * 
 * Source code generated by Celerio, an Open Source code generator by Jaxio.
 * Documentation: http://www.jaxio.com/documentation/celerio/
 * Source code: https://github.com/jaxio/celerio/
 * Follow us on twitter: @jaxiosoft
 * This header can be customized in Celerio conf...
 * Template pack-angular:src/main/java/domain/Entity.java.e.vm
 */
package com.mycompany.myapp.domain;

import static javax.persistence.FetchType.LAZY;
import static javax.persistence.GenerationType.IDENTITY;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.logging.Logger;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import org.hibernate.validator.constraints.NotEmpty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

/**
 * BOOK supports file upload/download for demo
 */
@Entity
@Table(name = "BOOK")
public class Book implements Identifiable<Integer>, Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Book.class.getName());

    // Raw attributes
    private Integer id;
    private String title;
    private String summary;
    private byte[] extractBinary;
    private String extractFileName;
    private String extractContentType;
    private Long extractSize;
    private LocalDate publicationDate;
    private Boolean bestSeller;
    private BigDecimal price;

    // Many to one
    private Author author;
    private Author coAuthor;

    @Override
    public String entityClassName() {
        return Book.class.getSimpleName();
    }

    // -- [id] ------------------------

    @Override
    @Column(name = "ID", precision = 10)
    @GeneratedValue(strategy = IDENTITY)
    @Id
    public Integer getId() {
        return id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Book id(Integer id) {
        setId(id);
        return this;
    }

    @Override
    @Transient
    public boolean isIdSet() {
        return id != null;
    }
    // -- [title] ------------------------

    @NotEmpty
    @Size(max = 100)
    @Column(name = "TITLE", nullable = false, length = 100)
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Book title(String title) {
        setTitle(title);
        return this;
    }
    // -- [summary] ------------------------

    @Size(max = 255)
    @Column(name = "SUMMARY")
    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Book summary(String summary) {
        setSummary(summary);
        return this;
    }
    // -- [extractBinary] ------------------------

    @Basic(fetch = LAZY)
    @Column(name = "EXTRACT_BINARY")
    @Lob
    public byte[] getExtractBinary() {
        return extractBinary;
    }

    public void setExtractBinary(byte[] extractBinary) {
        this.extractBinary = extractBinary;
    }

    public Book extractBinary(byte[] extractBinary) {
        setExtractBinary(extractBinary);
        return this;
    }
    // -- [extractFileName] ------------------------

    @Size(max = 100)
    @Column(name = "EXTRACT_FILE_NAME", length = 100)
    public String getExtractFileName() {
        return extractFileName;
    }

    public void setExtractFileName(String extractFileName) {
        this.extractFileName = extractFileName;
    }

    public Book extractFileName(String extractFileName) {
        setExtractFileName(extractFileName);
        return this;
    }
    // -- [extractContentType] ------------------------

    @Size(max = 100)
    @Column(name = "EXTRACT_CONTENT_TYPE", length = 100)
    public String getExtractContentType() {
        return extractContentType;
    }

    public void setExtractContentType(String extractContentType) {
        this.extractContentType = extractContentType;
    }

    public Book extractContentType(String extractContentType) {
        setExtractContentType(extractContentType);
        return this;
    }
    // -- [extractSize] ------------------------

    @Digits(integer = 11, fraction = 0)
    @Column(name = "EXTRACT_SIZE", precision = 11)
    public Long getExtractSize() {
        return extractSize;
    }

    public void setExtractSize(Long extractSize) {
        this.extractSize = extractSize;
    }

    public Book extractSize(Long extractSize) {
        setExtractSize(extractSize);
        return this;
    }
    // -- [publicationDate] ------------------------

    @Column(name = "PUBLICATION_DATE", length = 8)
    public LocalDate getPublicationDate() {
        return publicationDate;
    }

    public void setPublicationDate(LocalDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    public Book publicationDate(LocalDate publicationDate) {
        setPublicationDate(publicationDate);
        return this;
    }
    // -- [bestSeller] ------------------------

    @Column(name = "BEST_SELLER", length = 1)
    public Boolean getBestSeller() {
        return bestSeller;
    }

    public void setBestSeller(Boolean bestSeller) {
        this.bestSeller = bestSeller;
    }

    public Book bestSeller(Boolean bestSeller) {
        setBestSeller(bestSeller);
        return this;
    }
    // -- [price] ------------------------

    @Digits(integer = 18, fraction = 2)
    @NotNull
    @Column(name = "PRICE", nullable = false, precision = 20, scale = 2)
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Book price(BigDecimal price) {
        setPrice(price);
        return this;
    }

    // -----------------------------------------------------------------
    // Many to One support
    // -----------------------------------------------------------------

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // many-to-one: Book.author ==> Author.id
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    @JoinColumn(name = "AUTHOR_ID", nullable = false)
    @ManyToOne
    public Author getAuthor() {
        return author;
    }

    /**
     * Set the {@link #author} without adding this Book instance on the passed {@link #author}
     * If you want to preserve referential integrity we recommend to use
     * instead the corresponding adder method provided by {@link Author}
     */
    public void setAuthor(Author author) {
        this.author = author;
    }

    public Book author(Author author) {
        setAuthor(author);
        return this;
    }

    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // many-to-one: Book.coAuthor ==> Author.id
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    @JoinColumn(name = "CO_AUTHOR_ID")
    @ManyToOne
    public Author getCoAuthor() {
        return coAuthor;
    }

    /**
     * Set the {@link #coAuthor} without adding this Book instance on the passed {@link #coAuthor}
     */
    public void setCoAuthor(Author coAuthor) {
        this.coAuthor = coAuthor;
    }

    public Book coAuthor(Author coAuthor) {
        setCoAuthor(coAuthor);
        return this;
    }

    /**
     * Apply the default values.
     */
    public Book withDefaults() {
        setBestSeller(false);
        return this;
    }

    /**
     * Equals implementation using a business key.
     */
    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof Book && hashCode() == other.hashCode());
    }

    private IdentifiableHashBuilder identifiableHashBuilder = new IdentifiableHashBuilder();

    @Override
    public int hashCode() {
        return identifiableHashBuilder.hash(log, this);
    }

    /**
     * Construct a readable string representation for this Book instance.
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this) //
                .add("id", getId()) //
                .add("title", getTitle()) //
                .add("summary", getSummary()) //
                .add("extractBinary", getExtractBinary()) //
                .add("extractFileName", getExtractFileName()) //
                .add("extractContentType", getExtractContentType()) //
                .add("extractSize", getExtractSize()) //
                .add("publicationDate", getPublicationDate()) //
                .add("bestSeller", getBestSeller()) //
                .add("price", getPrice()) //
                .toString();
    }
}