/*
 * GPLv3 License
 *
 * Copyright (c) 2023-2025 4ra1n (Jar Analyzer Team)
 *
 * This project is distributed under the GPLv3 license.
 *
 * https://github.com/jar-analyzer/jar-analyzer/blob/master/LICENSE
 */

package me.n1ar4.security;


import org.objectweb.asm.*;

@SuppressWarnings("all")
public class JarAnalyzerInputFilter9Dump implements Opcodes {
    public static String getClassName() {
        return "me.n1ar4.security.JarAnalyzerInputFilterForJava9";
    }

    public static byte[] makeJava9() {
        ClassWriter classWriter = new ClassWriter(0);
        FieldVisitor fieldVisitor;
        MethodVisitor methodVisitor;
        classWriter.visit(V1_8, ACC_PUBLIC | ACC_SUPER, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", null, "java/lang/Object", new String[]{"java/io/ObjectInputFilter"});
        classWriter.visitInnerClass("java/io/ObjectInputFilter$FilterInfo", "java/io/ObjectInputFilter", "FilterInfo", ACC_PUBLIC | ACC_STATIC | ACC_ABSTRACT | ACC_INTERFACE);
        classWriter.visitInnerClass("java/io/ObjectInputFilter$Status", "java/io/ObjectInputFilter", "Status", ACC_PUBLIC | ACC_FINAL | ACC_STATIC | ACC_ENUM);
        {
            fieldVisitor = classWriter.visitField(ACC_PRIVATE | ACC_FINAL, "maxLength", "I", null, null);
            fieldVisitor.visitEnd();
        }
        {
            fieldVisitor = classWriter.visitField(ACC_PRIVATE | ACC_FINAL, "maxBytes", "I", null, null);
            fieldVisitor.visitEnd();
        }
        {
            fieldVisitor = classWriter.visitField(ACC_PRIVATE | ACC_FINAL, "maxDepth", "I", null, null);
            fieldVisitor.visitEnd();
        }
        {
            fieldVisitor = classWriter.visitField(ACC_PRIVATE | ACC_FINAL, "maxRefs", "I", null, null);
            fieldVisitor.visitEnd();
        }
        {
            fieldVisitor = classWriter.visitField(ACC_PRIVATE | ACC_FINAL | ACC_STATIC, "BLACK_LIST", "[Ljava/lang/String;", null, null);
            fieldVisitor.visitEnd();
        }
        {
            methodVisitor = classWriter.visitMethod(ACC_PUBLIC, "<init>", "(IIII)V", null, null);
            methodVisitor.visitCode();
            Label label0 = new Label();
            methodVisitor.visitLabel(label0);
            methodVisitor.visitLineNumber(323, label0);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitMethodInsn(INVOKESPECIAL, "java/lang/Object", "<init>", "()V", false);
            Label label1 = new Label();
            methodVisitor.visitLabel(label1);
            methodVisitor.visitLineNumber(324, label1);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitVarInsn(ILOAD, 1);
            methodVisitor.visitFieldInsn(PUTFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxLength", "I");
            Label label2 = new Label();
            methodVisitor.visitLabel(label2);
            methodVisitor.visitLineNumber(325, label2);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitVarInsn(ILOAD, 2);
            methodVisitor.visitFieldInsn(PUTFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxDepth", "I");
            Label label3 = new Label();
            methodVisitor.visitLabel(label3);
            methodVisitor.visitLineNumber(326, label3);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitVarInsn(ILOAD, 3);
            methodVisitor.visitFieldInsn(PUTFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxRefs", "I");
            Label label4 = new Label();
            methodVisitor.visitLabel(label4);
            methodVisitor.visitLineNumber(327, label4);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitVarInsn(ILOAD, 4);
            methodVisitor.visitFieldInsn(PUTFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxBytes", "I");
            Label label5 = new Label();
            methodVisitor.visitLabel(label5);
            methodVisitor.visitLineNumber(328, label5);
            methodVisitor.visitInsn(RETURN);
            Label label6 = new Label();
            methodVisitor.visitLabel(label6);
            methodVisitor.visitLocalVariable("this", "Lme/n1ar4/security/JarAnalyzerInputFilterForJava9;", null, label0, label6, 0);
            methodVisitor.visitLocalVariable("maxLength", "I", null, label0, label6, 1);
            methodVisitor.visitLocalVariable("maxDepth", "I", null, label0, label6, 2);
            methodVisitor.visitLocalVariable("maxRefs", "I", null, label0, label6, 3);
            methodVisitor.visitLocalVariable("maxBytes", "I", null, label0, label6, 4);
            methodVisitor.visitMaxs(2, 5);
            methodVisitor.visitEnd();
        }
        {
            methodVisitor = classWriter.visitMethod(ACC_PUBLIC, "checkInput", "(Ljava/io/ObjectInputFilter$FilterInfo;)Ljava/io/ObjectInputFilter$Status;", null, null);
            methodVisitor.visitCode();
            Label label0 = new Label();
            methodVisitor.visitLabel(label0);
            methodVisitor.visitLineNumber(332, label0);
            methodVisitor.visitVarInsn(ALOAD, 1);
            Label label1 = new Label();
            methodVisitor.visitJumpInsn(IFNONNULL, label1);
            Label label2 = new Label();
            methodVisitor.visitLabel(label2);
            methodVisitor.visitLineNumber(333, label2);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "ALLOWED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            methodVisitor.visitLabel(label1);
            methodVisitor.visitLineNumber(335, label1);
            methodVisitor.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
            methodVisitor.visitVarInsn(ALOAD, 1);
            methodVisitor.visitMethodInsn(INVOKEINTERFACE, "java/io/ObjectInputFilter$FilterInfo", "depth", "()J", true);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitFieldInsn(GETFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxDepth", "I");
            methodVisitor.visitInsn(I2L);
            methodVisitor.visitInsn(LCMP);
            Label label3 = new Label();
            methodVisitor.visitJumpInsn(IFLE, label3);
            Label label4 = new Label();
            methodVisitor.visitLabel(label4);
            methodVisitor.visitLineNumber(336, label4);
            methodVisitor.visitLdcInsn("DESERIALIZE DEPTH TOO LARGE");
            methodVisitor.visitMethodInsn(INVOKESTATIC, "me/n1ar4/security/SecurityLog", "log", "(Ljava/lang/String;)V", false);
            Label label5 = new Label();
            methodVisitor.visitLabel(label5);
            methodVisitor.visitLineNumber(337, label5);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "REJECTED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            methodVisitor.visitLabel(label3);
            methodVisitor.visitLineNumber(339, label3);
            methodVisitor.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
            methodVisitor.visitVarInsn(ALOAD, 1);
            methodVisitor.visitMethodInsn(INVOKEINTERFACE, "java/io/ObjectInputFilter$FilterInfo", "references", "()J", true);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitFieldInsn(GETFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxRefs", "I");
            methodVisitor.visitInsn(I2L);
            methodVisitor.visitInsn(LCMP);
            Label label6 = new Label();
            methodVisitor.visitJumpInsn(IFLE, label6);
            Label label7 = new Label();
            methodVisitor.visitLabel(label7);
            methodVisitor.visitLineNumber(340, label7);
            methodVisitor.visitLdcInsn("DESERIALIZE REFS TOO LARGE");
            methodVisitor.visitMethodInsn(INVOKESTATIC, "me/n1ar4/security/SecurityLog", "log", "(Ljava/lang/String;)V", false);
            Label label8 = new Label();
            methodVisitor.visitLabel(label8);
            methodVisitor.visitLineNumber(341, label8);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "REJECTED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            methodVisitor.visitLabel(label6);
            methodVisitor.visitLineNumber(343, label6);
            methodVisitor.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
            methodVisitor.visitVarInsn(ALOAD, 1);
            methodVisitor.visitMethodInsn(INVOKEINTERFACE, "java/io/ObjectInputFilter$FilterInfo", "arrayLength", "()J", true);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitFieldInsn(GETFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxLength", "I");
            methodVisitor.visitInsn(I2L);
            methodVisitor.visitInsn(LCMP);
            Label label9 = new Label();
            methodVisitor.visitJumpInsn(IFLE, label9);
            Label label10 = new Label();
            methodVisitor.visitLabel(label10);
            methodVisitor.visitLineNumber(344, label10);
            methodVisitor.visitLdcInsn("DESERIALIZE LENGTH TOO LARGE");
            methodVisitor.visitMethodInsn(INVOKESTATIC, "me/n1ar4/security/SecurityLog", "log", "(Ljava/lang/String;)V", false);
            Label label11 = new Label();
            methodVisitor.visitLabel(label11);
            methodVisitor.visitLineNumber(345, label11);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "REJECTED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            methodVisitor.visitLabel(label9);
            methodVisitor.visitLineNumber(347, label9);
            methodVisitor.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
            methodVisitor.visitVarInsn(ALOAD, 1);
            methodVisitor.visitMethodInsn(INVOKEINTERFACE, "java/io/ObjectInputFilter$FilterInfo", "streamBytes", "()J", true);
            methodVisitor.visitVarInsn(ALOAD, 0);
            methodVisitor.visitFieldInsn(GETFIELD, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "maxBytes", "I");
            methodVisitor.visitInsn(I2L);
            methodVisitor.visitInsn(LCMP);
            Label label12 = new Label();
            methodVisitor.visitJumpInsn(IFLE, label12);
            Label label13 = new Label();
            methodVisitor.visitLabel(label13);
            methodVisitor.visitLineNumber(348, label13);
            methodVisitor.visitLdcInsn("DESERIALIZE BYTES TOO LARGE");
            methodVisitor.visitMethodInsn(INVOKESTATIC, "me/n1ar4/security/SecurityLog", "log", "(Ljava/lang/String;)V", false);
            Label label14 = new Label();
            methodVisitor.visitLabel(label14);
            methodVisitor.visitLineNumber(349, label14);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "REJECTED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            methodVisitor.visitLabel(label12);
            methodVisitor.visitLineNumber(351, label12);
            methodVisitor.visitFrame(Opcodes.F_SAME, 0, null, 0, null);
            methodVisitor.visitFieldInsn(GETSTATIC, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "BLACK_LIST", "[Ljava/lang/String;");
            methodVisitor.visitVarInsn(ASTORE, 2);
            methodVisitor.visitVarInsn(ALOAD, 2);
            methodVisitor.visitInsn(ARRAYLENGTH);
            methodVisitor.visitVarInsn(ISTORE, 3);
            methodVisitor.visitInsn(ICONST_0);
            methodVisitor.visitVarInsn(ISTORE, 4);
            Label label15 = new Label();
            methodVisitor.visitLabel(label15);
            methodVisitor.visitFrame(Opcodes.F_APPEND, 3, new Object[]{"[Ljava/lang/String;", Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
            methodVisitor.visitVarInsn(ILOAD, 4);
            methodVisitor.visitVarInsn(ILOAD, 3);
            Label label16 = new Label();
            methodVisitor.visitJumpInsn(IF_ICMPGE, label16);
            methodVisitor.visitVarInsn(ALOAD, 2);
            methodVisitor.visitVarInsn(ILOAD, 4);
            methodVisitor.visitInsn(AALOAD);
            methodVisitor.visitVarInsn(ASTORE, 5);
            Label label17 = new Label();
            methodVisitor.visitLabel(label17);
            methodVisitor.visitLineNumber(352, label17);
            methodVisitor.visitVarInsn(ALOAD, 1);
            methodVisitor.visitMethodInsn(INVOKEINTERFACE, "java/io/ObjectInputFilter$FilterInfo", "serialClass", "()Ljava/lang/Class;", true);
            Label label18 = new Label();
            methodVisitor.visitJumpInsn(IFNONNULL, label18);
            Label label19 = new Label();
            methodVisitor.visitLabel(label19);
            methodVisitor.visitLineNumber(353, label19);
            Label label20 = new Label();
            methodVisitor.visitJumpInsn(GOTO, label20);
            methodVisitor.visitLabel(label18);
            methodVisitor.visitLineNumber(355, label18);
            methodVisitor.visitFrame(Opcodes.F_APPEND, 1, new Object[]{"java/lang/String"}, 0, null);
            methodVisitor.visitVarInsn(ALOAD, 1);
            methodVisitor.visitMethodInsn(INVOKEINTERFACE, "java/io/ObjectInputFilter$FilterInfo", "serialClass", "()Ljava/lang/Class;", true);
            methodVisitor.visitMethodInsn(INVOKEVIRTUAL, "java/lang/Class", "getName", "()Ljava/lang/String;", false);
            methodVisitor.visitVarInsn(ALOAD, 5);
            methodVisitor.visitMethodInsn(INVOKEVIRTUAL, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            methodVisitor.visitJumpInsn(IFEQ, label20);
            Label label21 = new Label();
            methodVisitor.visitLabel(label21);
            methodVisitor.visitLineNumber(356, label21);
            methodVisitor.visitTypeInsn(NEW, "java/lang/StringBuilder");
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitMethodInsn(INVOKESPECIAL, "java/lang/StringBuilder", "<init>", "()V", false);
            methodVisitor.visitLdcInsn("REJECT: ");
            methodVisitor.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            methodVisitor.visitVarInsn(ALOAD, 5);
            methodVisitor.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            methodVisitor.visitMethodInsn(INVOKEVIRTUAL, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            methodVisitor.visitMethodInsn(INVOKESTATIC, "me/n1ar4/security/SecurityLog", "log", "(Ljava/lang/String;)V", false);
            Label label22 = new Label();
            methodVisitor.visitLabel(label22);
            methodVisitor.visitLineNumber(357, label22);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "REJECTED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            methodVisitor.visitLabel(label20);
            methodVisitor.visitLineNumber(351, label20);
            methodVisitor.visitFrame(Opcodes.F_CHOP, 1, null, 0, null);
            methodVisitor.visitIincInsn(4, 1);
            methodVisitor.visitJumpInsn(GOTO, label15);
            methodVisitor.visitLabel(label16);
            methodVisitor.visitLineNumber(360, label16);
            methodVisitor.visitFrame(Opcodes.F_CHOP, 3, null, 0, null);
            methodVisitor.visitFieldInsn(GETSTATIC, "java/io/ObjectInputFilter$Status", "ALLOWED", "Ljava/io/ObjectInputFilter$Status;");
            methodVisitor.visitInsn(ARETURN);
            Label label23 = new Label();
            methodVisitor.visitLabel(label23);
            methodVisitor.visitLocalVariable("s", "Ljava/lang/String;", null, label17, label20, 5);
            methodVisitor.visitLocalVariable("this", "Lme/n1ar4/security/JarAnalyzerInputFilterForJava9;", null, label0, label23, 0);
            methodVisitor.visitLocalVariable("filterInfo", "Ljava/io/ObjectInputFilter$FilterInfo;", null, label0, label23, 1);
            methodVisitor.visitMaxs(4, 6);
            methodVisitor.visitEnd();
        }
        {
            methodVisitor = classWriter.visitMethod(ACC_STATIC, "<clinit>", "()V", null, null);
            methodVisitor.visitCode();
            Label label0 = new Label();
            methodVisitor.visitLabel(label0);
            methodVisitor.visitLineNumber(12, label0);
            methodVisitor.visitIntInsn(SIPUSH, 308);
            methodVisitor.visitTypeInsn(ANEWARRAY, "java/lang/String");
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitInsn(ICONST_0);
            methodVisitor.visitLdcInsn("br.com.anteros.dbcp.AnterosDBCPConfig");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitInsn(ICONST_1);
            methodVisitor.visitLdcInsn("br.com.anteros.dbcp.AnterosDBCPDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitInsn(ICONST_2);
            methodVisitor.visitLdcInsn("bsh.Interpreter");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitInsn(ICONST_3);
            methodVisitor.visitLdcInsn("bsh.XThis");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitInsn(ICONST_4);
            methodVisitor.visitLdcInsn("ch.qos.logback.core.db.DriverManagerConnectionSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitInsn(ICONST_5);
            methodVisitor.visitLdcInsn("ch.qos.logback.core.db.JNDIConnectionSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 6);
            methodVisitor.visitLdcInsn("clojure.inspector.proxy$javax.swing.table.AbstractTableModel$ff19274a");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 7);
            methodVisitor.visitLdcInsn("clojure.lang.PersistentArrayMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 8);
            methodVisitor.visitLdcInsn("com.alibaba.fastjson.JSONArray");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 9);
            methodVisitor.visitLdcInsn("com.alibaba.fastjson.TypeReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 10);
            methodVisitor.visitLdcInsn("com.alibaba.fastjson2.JSONArray");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 11);
            methodVisitor.visitLdcInsn("com.caucho.config.types.ResourceRef");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 12);
            methodVisitor.visitLdcInsn("com.fasterxml.jackson.databind.node.POJONode");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 13);
            methodVisitor.visitLdcInsn("com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 14);
            methodVisitor.visitLdcInsn("com.mchange.v2.c3p0.ComboPooledDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 15);
            methodVisitor.visitLdcInsn("com.mchange.v2.c3p0.JndiRefForwardingDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 16);
            methodVisitor.visitLdcInsn("com.mchange.v2.c3p0.PoolBackedDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 17);
            methodVisitor.visitLdcInsn("com.mchange.v2.c3p0.debug.AfterCloseLoggingComboPooledDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 18);
            methodVisitor.visitLdcInsn("com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 19);
            methodVisitor.visitLdcInsn("com.mysql.cj.jdbc.MysqlConnectionPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 20);
            methodVisitor.visitLdcInsn("com.mysql.cj.jdbc.MysqlXADataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 21);
            methodVisitor.visitLdcInsn("com.mysql.cj.jdbc.admin.MiniAdmin");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 22);
            methodVisitor.visitLdcInsn("com.newrelic.agent.deps.ch.qos.logback.core.db.DriverManagerConnectionSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 23);
            methodVisitor.visitLdcInsn("com.newrelic.agent.deps.ch.qos.logback.core.db.JNDIConnectionSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 24);
            methodVisitor.visitLdcInsn("com.nqadmin.rowset.JdbcRowSetImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 25);
            methodVisitor.visitLdcInsn("com.oracle.wls.shaded.org.apache.xalan.lib.sql.JNDIConnectionPool");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 26);
            methodVisitor.visitLdcInsn("com.p6spy.engine.spy.P6DataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 27);
            methodVisitor.visitLdcInsn("com.pastdev.httpcomponents.configuration.JndiConfiguration");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 28);
            methodVisitor.visitLdcInsn("com.sun.deploy.security.ruleset.DRSHelper");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 29);
            methodVisitor.visitLdcInsn("com.sun.jmx.interceptor.DefaultMBeanServerInterceptor");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 30);
            methodVisitor.visitLdcInsn("com.sun.jmx.mbeanserver.JmxMBeanServer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 31);
            methodVisitor.visitLdcInsn("com.sun.jmx.mbeanserver.NamedObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 32);
            methodVisitor.visitLdcInsn("com.sun.jmx.mbeanserver.Repository");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 33);
            methodVisitor.visitLdcInsn("com.sun.org.apache.bcel.internal.util.ClassLoader");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 34);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.lib.sql.JNDIConnectionPool");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 35);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xslt.ObjectFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 36);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xslt.Process");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 37);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xsltc.DOM");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 38);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xsltc.TransletException");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 39);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 40);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 41);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 42);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xml.internal.dtm.DTMAxisIterator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 43);
            methodVisitor.visitLdcInsn("com.sun.org.apache.xml.internal.serializer.SerializationHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 44);
            methodVisitor.visitLdcInsn("com.sun.rowset.JdbcRowSetImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 45);
            methodVisitor.visitLdcInsn("com.sun.syndication.feed.impl.ObjectBean");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 46);
            methodVisitor.visitLdcInsn("com.vaadin.data.Property");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 47);
            methodVisitor.visitLdcInsn("com.vaadin.data.util.NestedMethodProperty");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 48);
            methodVisitor.visitLdcInsn("com.vaadin.data.util.PropertysetItem");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 49);
            methodVisitor.visitLdcInsn("com.zaxxer.hikari.HikariConfig");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 50);
            methodVisitor.visitLdcInsn("com.zaxxer.hikari.HikariDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 51);
            methodVisitor.visitLdcInsn("flex.messaging.util.concurrent.AsynchBeansWorkManagerExecutor");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 52);
            methodVisitor.visitLdcInsn("groovy.lang.Closure");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 53);
            methodVisitor.visitLdcInsn("jodd.db.connection.DataSourceConnectionProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 54);
            methodVisitor.visitLdcInsn("net.sf.ehcache.hibernate.EhcacheJtaTransactionManagerLookup");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 55);
            methodVisitor.visitLdcInsn("net.sf.ehcache.transaction.manager.DefaultTransactionManagerLookup");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 56);
            methodVisitor.visitLdcInsn("net.sf.ehcache.transaction.manager.selector.GenericJndiSelector");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 57);
            methodVisitor.visitLdcInsn("net.sf.ehcache.transaction.manager.selector.GlassfishSelector");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 58);
            methodVisitor.visitLdcInsn("net.sf.json.JSONObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 59);
            methodVisitor.visitLdcInsn("oadd.org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 60);
            methodVisitor.visitLdcInsn("oadd.org.apache.commons.dbcp.datasources.PerUserPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 61);
            methodVisitor.visitLdcInsn("oadd.org.apache.commons.dbcp.datasources.SharedPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 62);
            methodVisitor.visitLdcInsn("oadd.org.apache.xalan.lib.sql.JNDIConnectionPool");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 63);
            methodVisitor.visitLdcInsn("om.mchange.v2.c3p0.WrapperConnectionPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 64);
            methodVisitor.visitLdcInsn("om.sun.corba.se.spi.orbutil.proxy.CompositeInvocationHandlerImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 65);
            methodVisitor.visitLdcInsn("oracle.jdbc.connector.OracleManagedConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 66);
            methodVisitor.visitLdcInsn("oracle.jdbc.pool.OraclePooledConnection");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 67);
            methodVisitor.visitLdcInsn("oracle.jdbc.rowset.OracleJDBCRowSet");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 68);
            methodVisitor.visitLdcInsn("oracle.jms.AQjmsQueueConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 69);
            methodVisitor.visitLdcInsn("oracle.jms.AQjmsTopicConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 70);
            methodVisitor.visitLdcInsn("oracle.jms.AQjmsXAConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 71);
            methodVisitor.visitLdcInsn("oracle.jms.AQjmsXAQueueConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 72);
            methodVisitor.visitLdcInsn("oracle.jms.AQjmsXATopicConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 73);
            methodVisitor.visitLdcInsn("org..springframework.transaction.jta.JtaTransactionManager");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 74);
            methodVisitor.visitLdcInsn("org.aoju.bus.proxy.provider.RmiProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 75);
            methodVisitor.visitLdcInsn("org.aoju.bus.proxy.provider.remoting.RmiProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 76);
            methodVisitor.visitLdcInsn("org.apache.activemq.ActiveMQConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 77);
            methodVisitor.visitLdcInsn("org.apache.activemq.ActiveMQXAConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 78);
            methodVisitor.visitLdcInsn("org.apache.activemq.jms.pool.JcaPooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 79);
            methodVisitor.visitLdcInsn("org.apache.activemq.jms.pool.XaPooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 80);
            methodVisitor.visitLdcInsn("org.apache.activemq.pool.JcaPooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 81);
            methodVisitor.visitLdcInsn("org.apache.activemq.pool.PooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 82);
            methodVisitor.visitLdcInsn("org.apache.activemq.pool.XaPooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 83);
            methodVisitor.visitLdcInsn("org.apache.activemq.spring.ActiveMQConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 84);
            methodVisitor.visitLdcInsn("org.apache.activemq.spring.ActiveMQXAConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 85);
            methodVisitor.visitLdcInsn("org.apache.aries.transaction.jms.RecoverablePooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 86);
            methodVisitor.visitLdcInsn("org.apache.aries.transaction.jms.internal.XaPooledConnectionFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 87);
            methodVisitor.visitLdcInsn("org.apache.axis2.jaxws.spi.handler.HandlerResolverImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 88);
            methodVisitor.visitLdcInsn("org.apache.axis2.transport.jms.JMSOutTransportInfo");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 89);
            methodVisitor.visitLdcInsn("org.apache.bcel.internal.util.ClassLoader");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 90);
            methodVisitor.visitLdcInsn("org.apache.catalina.authenticator.AuthenticatorBase");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 91);
            methodVisitor.visitLdcInsn("org.apache.catalina.connector.Request");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 92);
            methodVisitor.visitLdcInsn("org.apache.catalina.connector.RequestFacade");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 93);
            methodVisitor.visitLdcInsn("org.apache.catalina.connector.Response");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 94);
            methodVisitor.visitLdcInsn("org.apache.catalina.core.ApplicationFilterConfig");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 95);
            methodVisitor.visitLdcInsn("org.apache.catalina.core.ApplicationServletRegistration");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 96);
            methodVisitor.visitLdcInsn("org.apache.catalina.core.StandardContext");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 97);
            methodVisitor.visitLdcInsn("org.apache.catalina.core.StandardService");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 98);
            methodVisitor.visitLdcInsn("org.apache.catalina.core.StandardWrapperValue.invoke");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 99);
            methodVisitor.visitLdcInsn("org.apache.catalina.deploy.FilterDef");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 100);
            methodVisitor.visitLdcInsn("org.apache.catalina.deploy.FilterMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 101);
            methodVisitor.visitLdcInsn("org.apache.catalina.loader.ParallelWebappClassLoader");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 102);
            methodVisitor.visitLdcInsn("org.apache.catalina.loader.WebappClassLoaderBase");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 103);
            methodVisitor.visitLdcInsn("org.apache.click.control.Column");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 104);
            methodVisitor.visitLdcInsn("org.apache.click.control.Column$ColumnComparator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 105);
            methodVisitor.visitLdcInsn("org.apache.click.control.Table");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 106);
            methodVisitor.visitLdcInsn("org.apache.commons.beanutils.BeanComparator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 107);
            methodVisitor.visitLdcInsn("org.apache.commons.codec.binary.Base64");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 108);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.Transformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 109);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.comparators.TransformingComparator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 110);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.functors.ChainedTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 111);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.functors.ConstantTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 112);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.functors.InstantiateTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 113);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.functors.InvokerTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 114);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.functors.MapTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 115);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.keyvalue.TiedMapEntry");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 116);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.map.LazyMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 117);
            methodVisitor.visitLdcInsn("org.apache.commons.collections.map.TransformedMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 118);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.Transformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 119);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.comparators.TransformingComparator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 120);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.functors.ChainedTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 121);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.functors.ConstantTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 122);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.functors.InstantiateTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 123);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.functors.InvokerTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 124);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.functors.MapTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 125);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.keyvalue.TiedMapEntry");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 126);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.map.LazyMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(BIPUSH, 127);
            methodVisitor.visitLdcInsn("org.apache.commons.collections4.map.TransformedMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 128);
            methodVisitor.visitLdcInsn("org.apache.commons.configuration.JNDIConfiguration");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 129);
            methodVisitor.visitLdcInsn("org.apache.commons.configuration2.JNDIConfiguration");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 130);
            methodVisitor.visitLdcInsn("org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 131);
            methodVisitor.visitLdcInsn("org.apache.commons.dbcp.datasources.PerUserPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 132);
            methodVisitor.visitLdcInsn("org.apache.commons.dbcp.datasources.SharedPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 133);
            methodVisitor.visitLdcInsn("org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 134);
            methodVisitor.visitLdcInsn("org.apache.commons.dbcp2.datasources.PerUserPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 135);
            methodVisitor.visitLdcInsn("org.apache.commons.dbcp2.datasources.SharedPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 136);
            methodVisitor.visitLdcInsn("org.apache.commons.fileupload.disk.DiskFileItem");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 137);
            methodVisitor.visitLdcInsn("org.apache.commons.io.FileUtils");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 138);
            methodVisitor.visitLdcInsn("org.apache.commons.io.output.DeferredFileOutputStream");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 139);
            methodVisitor.visitLdcInsn("org.apache.commons.io.output.ThresholdingOutputStream");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 140);
            methodVisitor.visitLdcInsn("org.apache.commons.jelly.impl.Embedded");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 141);
            methodVisitor.visitLdcInsn("org.apache.commons.proxy.provider.remoting.RmiProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 142);
            methodVisitor.visitLdcInsn("org.apache.coyote.AbstractProtocol;");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 143);
            methodVisitor.visitLdcInsn("org.apache.coyote.ProtocolHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 144);
            methodVisitor.visitLdcInsn("org.apache.coyote.Request");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 145);
            methodVisitor.visitLdcInsn("org.apache.coyote.Response");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 146);
            methodVisitor.visitLdcInsn("org.apache.cxf.jaxrs.provider.XSLTJaxbProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 147);
            methodVisitor.visitLdcInsn("org.apache.hadoop.shaded.com.zaxxer.hikari.HikariConfig");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 148);
            methodVisitor.visitLdcInsn("org.apache.ibatis.datasource.jndi.JndiDataSourceFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 149);
            methodVisitor.visitLdcInsn("org.apache.ibatis.parsing.XPathParser");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 150);
            methodVisitor.visitLdcInsn("org.apache.ignite.cache.jta.jndi.CacheJndiTmFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 151);
            methodVisitor.visitLdcInsn("org.apache.ignite.cache.jta.jndi.CacheJndiTmLookup");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 152);
            methodVisitor.visitLdcInsn("org.apache.log4j.receivers.db.DriverManagerConnectionSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 153);
            methodVisitor.visitLdcInsn("org.apache.log4j.receivers.db.JNDIConnectionSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 154);
            methodVisitor.visitLdcInsn("org.apache.myfaces.context.servlet.FacesContextImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 155);
            methodVisitor.visitLdcInsn("org.apache.myfaces.context.servlet.FacesContextImplBase");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 156);
            methodVisitor.visitLdcInsn("org.apache.myfaces.el.CompositeELResolver");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 157);
            methodVisitor.visitLdcInsn("org.apache.myfaces.el.unified.FacesELContext");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 158);
            methodVisitor.visitLdcInsn("org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 159);
            methodVisitor.visitLdcInsn("org.apache.openjpa.ee.JNDIManagedRuntime");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 160);
            methodVisitor.visitLdcInsn("org.apache.openjpa.ee.RegistryManagedRuntime");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 161);
            methodVisitor.visitLdcInsn("org.apache.openjpa.ee.WASRegistryManagedRuntime");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 162);
            methodVisitor.visitLdcInsn("org.apache.shiro.codec.Base64");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 163);
            methodVisitor.visitLdcInsn("org.apache.shiro.codec.CodecSupport");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 164);
            methodVisitor.visitLdcInsn("org.apache.shiro.crypto.AesCipherService");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 165);
            methodVisitor.visitLdcInsn("org.apache.shiro.io.DefaultSerializer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 166);
            methodVisitor.visitLdcInsn("org.apache.shiro.jndi.JndiObjectFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 167);
            methodVisitor.visitLdcInsn("org.apache.shiro.realm.jndi.JndiRealmFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 168);
            methodVisitor.visitLdcInsn("org.apache.shiro.util.ByteSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 169);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp.cpdsadapter.DriverAdapterCPDS");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 170);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp.datasources.PerUserPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 171);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 172);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp2.BasicDataSourc");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 173);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp2.cpdsadapter.DriverAdapterCPDS");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 174);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 175);
            methodVisitor.visitLdcInsn("org.apache.tomcat.dbcp.dbcp2.datasources.SharedPoolDataSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 176);
            methodVisitor.visitLdcInsn("org.apache.tomcat.util.buf.ByteChunk");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 177);
            methodVisitor.visitLdcInsn("org.apache.tomcat.util.descriptor.web.FilterDef");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 178);
            methodVisitor.visitLdcInsn("org.apache.tomcat.util.descriptor.web.FilterMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 179);
            methodVisitor.visitLdcInsn("org.apache.tomcat.util.modeler.BaseModelMBean");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 180);
            methodVisitor.visitLdcInsn("org.apache.tomcat.util.modeler.Registry");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 181);
            methodVisitor.visitLdcInsn("org.apache.wicket.util.file.Files");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 182);
            methodVisitor.visitLdcInsn("org.apache.wicket.util.io.DeferredFileOutputStream");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 183);
            methodVisitor.visitLdcInsn("org.apache.wicket.util.io.ThresholdingOutputStream");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 184);
            methodVisitor.visitLdcInsn("org.apache.wicket.util.upload.DiskFileItem");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 185);
            methodVisitor.visitLdcInsn("org.apache.xalan.lib.sql.JNDIConnectionPool");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 186);
            methodVisitor.visitLdcInsn("org.apache.xalan.xslt.ObjectFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 187);
            methodVisitor.visitLdcInsn("org.apache.xalan.xslt.Process");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 188);
            methodVisitor.visitLdcInsn("org.apache.xalan.xsltc.DOM");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 189);
            methodVisitor.visitLdcInsn("org.apache.xalan.xsltc.TransletException");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 190);
            methodVisitor.visitLdcInsn("org.apache.xalan.xsltc.runtime.AbstractTranslet");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 191);
            methodVisitor.visitLdcInsn("org.apache.xalan.xsltc.trax.TemplatesImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 192);
            methodVisitor.visitLdcInsn("org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 193);
            methodVisitor.visitLdcInsn("org.apache.xbean.propertyeditor.JndiConverter");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 194);
            methodVisitor.visitLdcInsn("org.apache.xml.dtm.DTMAxisIterator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 195);
            methodVisitor.visitLdcInsn("org.apache.xml.serializer.SerializationHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 196);
            methodVisitor.visitLdcInsn("org.arrah.framework.rdbms.UpdatableJdbcRowsetImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 197);
            methodVisitor.visitLdcInsn("org.aspectj.weaver.tools.cache.SimpleCache$StoreableCachingMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 198);
            methodVisitor.visitLdcInsn("org.codehaus.groovy.runtime.ConvertedClosure");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 199);
            methodVisitor.visitLdcInsn("org.codehaus.groovy.runtime.MethodClosure");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 200);
            methodVisitor.visitLdcInsn("org.docx4j.org.apache.xalan.lib.sql.JNDIConnectionPool");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 201);
            methodVisitor.visitLdcInsn("org.hibernate.EntityMode");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 202);
            methodVisitor.visitLdcInsn("org.hibernate.engine.TypedValue");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 203);
            methodVisitor.visitLdcInsn("org.hibernate.engine.spi.TypedValue");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 204);
            methodVisitor.visitLdcInsn("org.hibernate.engine.spi.TypedValue$1");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 205);
            methodVisitor.visitLdcInsn("org.hibernate.jmx.StatisticsService");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 206);
            methodVisitor.visitLdcInsn("org.hibernate.property.BasicPropertyAccessor$BasicGetter");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 207);
            methodVisitor.visitLdcInsn("org.hibernate.property.Getter");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 208);
            methodVisitor.visitLdcInsn("org.hibernate.property.access.spi.Getter");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 209);
            methodVisitor.visitLdcInsn("org.hibernate.property.access.spi.GetterMethodImpl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 210);
            methodVisitor.visitLdcInsn("org.hibernate.tuple.EntityModeToTuplizerMapping");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 211);
            methodVisitor.visitLdcInsn("org.hibernate.tuple.component.AbstractComponentTuplizer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 212);
            methodVisitor.visitLdcInsn("org.hibernate.tuple.component.PojoComponentTuplizer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 213);
            methodVisitor.visitLdcInsn("org.hibernate.tuple.entity.EntityEntityModeToTuplizerMapping");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 214);
            methodVisitor.visitLdcInsn("org.hibernate.type.AbstractType");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 215);
            methodVisitor.visitLdcInsn("org.hibernate.type.ComponentType");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 216);
            methodVisitor.visitLdcInsn("org.hibernate.type.Type");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 217);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.builder.InterceptionModelBuilder");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 218);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.builder.MethodReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 219);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.proxy.DefaultInvocationContextFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 220);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.proxy.InterceptorMethodHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 221);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.reader.ClassMetadataInterceptorReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 222);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.reader.DefaultMethodMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 223);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.reader.ReflectiveClassMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 224);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.reader.SimpleInterceptorMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 225);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.context.InvocationContextFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 226);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.instance.InterceptorInstantiator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 227);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.metadata.ClassMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 228);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.metadata.InterceptorReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 229);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.metadata.MethodMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 230);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.model.InterceptionModel");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 231);
            methodVisitor.visitLdcInsn("org.jboss.interceptor.spi.model.InterceptionType");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 232);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.Channel");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 233);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.Connection");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 234);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.Endpoint");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 235);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.OpenListener");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 236);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.Remoting");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 237);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 238);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.spi.ConnectionHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 239);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.spi.ConnectionHandlerContext");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 240);
            methodVisitor.visitLdcInsn("org.jboss.remoting3.spi.ConnectionHandlerFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 241);
            methodVisitor.visitLdcInsn("org.jboss.util.propertyeditor.DocumentEditor");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 242);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.builder.InterceptionModelBuilder");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 243);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.builder.MethodReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 244);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.proxy.DefaultInvocationContextFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 245);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.proxy.InterceptorMethodHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 246);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.reader.ClassMetadataInterceptorReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 247);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.reader.DefaultMethodMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 248);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.reader.ReflectiveClassMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 249);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.reader.SimpleInterceptorMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 250);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.context.InvocationContextFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 251);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.instance.InterceptorInstantiator");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 252);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.metadata.ClassMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 253);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.metadata.InterceptorReference");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 254);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.metadata.MethodMetadata");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 255);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.model.InterceptionModel");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 256);
            methodVisitor.visitLdcInsn("org.jboss.weld.interceptor.spi.model.InterceptionType");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 257);
            methodVisitor.visitLdcInsn("org.jdom.Document");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 258);
            methodVisitor.visitLdcInsn("org.jdom.Element");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 259);
            methodVisitor.visitLdcInsn("org.jdom.input.SAXBuilder");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 260);
            methodVisitor.visitLdcInsn("org.jdom.transform.XSLTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 261);
            methodVisitor.visitLdcInsn("org.jdom2.transform.XSLTransformer");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 262);
            methodVisitor.visitLdcInsn("org.jsecurity.realm.jndi.JndiRealmFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 263);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.**");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 264);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.Callable");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 265);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.ClassCache");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 266);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.Context");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 267);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.IdScriptableObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 268);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.MemberBox");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 269);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.NativeError");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 270);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.NativeJavaArray");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 271);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.NativeJavaMethod");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 272);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.NativeJavaObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 273);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.NativeObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 274);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.Scriptable");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 275);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.ScriptableObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 276);
            methodVisitor.visitLdcInsn("org.mozilla.javascript.tools.shell.Environment");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 277);
            methodVisitor.visitLdcInsn("org.python.core.PyBytecode");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 278);
            methodVisitor.visitLdcInsn("org.python.core.PyFunction");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 279);
            methodVisitor.visitLdcInsn("org.python.core.PyObject");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 280);
            methodVisitor.visitLdcInsn("org.python.core.PyString");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 281);
            methodVisitor.visitLdcInsn("org.python.core.PyStringMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 282);
            methodVisitor.visitLdcInsn("org.quartz.utils.JNDIConnectionProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 283);
            methodVisitor.visitLdcInsn("org.reflections.Reflections");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 284);
            methodVisitor.visitLdcInsn("org.slf4j.ext.EventData");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 285);
            methodVisitor.visitLdcInsn("org.springframework.aop.TargetSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 286);
            methodVisitor.visitLdcInsn("org.springframework.aop.config.MethodLocatingFactoryBean");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 287);
            methodVisitor.visitLdcInsn("org.springframework.aop.framework.AdvisedSupport");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 288);
            methodVisitor.visitLdcInsn("org.springframework.aop.framework.JdkDynamicAopProxy");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 289);
            methodVisitor.visitLdcInsn("org.springframework.aop.support.AbstractBeanFactoryPointcutAdvisor");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 290);
            methodVisitor.visitLdcInsn("org.springframework.aop.target.SingletonTargetSource");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 291);
            methodVisitor.visitLdcInsn("org.springframework.beans.factory.ObjectFactory");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 292);
            methodVisitor.visitLdcInsn("org.springframework.beans.factory.config.BeanReferenceFactoryBean");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 293);
            methodVisitor.visitLdcInsn("org.springframework.beans.factory.config.PropertyPathFactoryBean");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 294);
            methodVisitor.visitLdcInsn("org.springframework.beans.factory.support.AutowireUtils$ObjectFactoryDelegatingInvocationHandler");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 295);
            methodVisitor.visitLdcInsn("org.springframework.core.SerializableTypeWrapper.$MethodInvokeTypeProvider");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 296);
            methodVisitor.visitLdcInsn("org.springframework.web.servlet.handler.HandlerInterceptorAdapter");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 297);
            methodVisitor.visitLdcInsn("org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 298);
            methodVisitor.visitLdcInsn("org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 299);
            methodVisitor.visitLdcInsn("org.springframework.web.servlet.support.RequestContextUtils");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 300);
            methodVisitor.visitLdcInsn("org.xnio.FutureResult");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 301);
            methodVisitor.visitLdcInsn("org.xnio.IoFuture");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 302);
            methodVisitor.visitLdcInsn("org.xnio.OptionMap");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 303);
            methodVisitor.visitLdcInsn("org.xnio.Options");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 304);
            methodVisitor.visitLdcInsn("org.xnio.Result");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 305);
            methodVisitor.visitLdcInsn("org.xnio.Xnio");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 306);
            methodVisitor.visitLdcInsn("org.xnio.XnioWorker");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitInsn(DUP);
            methodVisitor.visitIntInsn(SIPUSH, 307);
            methodVisitor.visitLdcInsn("org.xnio.ssl.JsseXnioSsl");
            methodVisitor.visitInsn(AASTORE);
            methodVisitor.visitFieldInsn(PUTSTATIC, "me/n1ar4/security/JarAnalyzerInputFilterForJava9", "BLACK_LIST", "[Ljava/lang/String;");
            methodVisitor.visitInsn(RETURN);
            methodVisitor.visitMaxs(4, 0);
            methodVisitor.visitEnd();
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }
}
