/*
 * GPLv3 License
 *
 * Copyright (c) 2023-2025 4ra1n (Jar Analyzer Team)
 *
 * This project is distributed under the GPLv3 license.
 *
 * https://github.com/jar-analyzer/jar-analyzer/blob/master/LICENSE
 */

package me.n1ar4.jar.analyzer.plugins.obfuscate;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import me.n1ar4.jar.analyzer.gui.MainForm;

import javax.swing.*;
import java.awt.*;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.util.Base64;

public class ObfuscateForm {
    private JPanel mainPanel;
    private JButton clearBtn;
    private JButton executeBtn;
    private JTextArea inputArea;
    private JTextArea outputArea;
    private JScrollPane inputScroll;
    private JScrollPane outputScroll;

    public ObfuscateForm() {
        inputArea.setText("rO0ABXNyABFqYXZhLnV0aWwuSGFzaE1hcAUH2sHD" +
                "FmDRAwACRgAKbG9hZEZhY3RvckkACXRocmVzaG9sZHhwP0AAAA" +
                "AAAAB3CAAAABAAAAAAeA==");
        this.clearBtn.addActionListener(e -> {
            inputArea.setText(null);
            outputArea.setText(null);
        });
        this.executeBtn.addActionListener(e -> {
            String input = inputArea.getText().trim();
            if (input.isEmpty()) {
                JOptionPane.showMessageDialog(mainPanel, "input is null");
                return;
            }
            byte[] res;
            try {
                res = Base64.getDecoder().decode(input);
            } catch (Exception ignored) {
                JOptionPane.showMessageDialog(mainPanel, "must use base64");
                return;
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(res));
                Object obj = ois.readObject();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                CustomObjectOutputStream oos = new CustomObjectOutputStream(bao);
                oos.writeObject(obj);
                oos.flush();
                oos.close();
                byte[] serializedData = bao.toByteArray();
                outputArea.setText(Base64.getEncoder().encodeToString(serializedData));
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(mainPanel, "obfuscate error: " + ex);
            }
        });
    }

    public static void start() {
        JFrame frame = new JFrame("ObfuscateForm");
        frame.setContentPane(new ObfuscateForm().mainPanel);

        frame.pack();

        frame.setLocationRelativeTo(MainForm.getInstance().getMasterPanel());

        frame.setVisible(true);
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        mainPanel.add(panel1, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        inputScroll = new JScrollPane();
        panel1.add(inputScroll, new GridConstraints(0, 0, 1, 3, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, new Dimension(500, 200), null, null, 0, false));
        inputArea = new JTextArea();
        inputArea.setLineWrap(true);
        inputScroll.setViewportView(inputArea);
        final Spacer spacer1 = new Spacer();
        panel1.add(spacer1, new GridConstraints(1, 2, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_VERTICAL, 1, GridConstraints.SIZEPOLICY_WANT_GROW, null, null, null, 0, false));
        clearBtn = new JButton();
        clearBtn.setText("clean");
        panel1.add(clearBtn, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        executeBtn = new JButton();
        executeBtn.setText("execute");
        panel1.add(executeBtn, new GridConstraints(1, 1, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        outputScroll = new JScrollPane();
        panel1.add(outputScroll, new GridConstraints(2, 0, 1, 3, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_WANT_GROW, new Dimension(500, 200), null, null, 0, false));
        outputArea = new JTextArea();
        outputArea.setLineWrap(true);
        outputScroll.setViewportView(outputArea);
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return mainPanel;
    }

}
