/*
 * GPLv3 License
 *
 * Copyright (c) 2023-2025 4ra1n (Jar Analyzer Team)
 *
 * This project is distributed under the GPLv3 license.
 *
 * https://github.com/jar-analyzer/jar-analyzer/blob/master/LICENSE
 */

package me.n1ar4.jar.analyzer.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import me.n1ar4.jar.analyzer.core.Proxy;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;

public class ProxyForm {
    private JPanel rootPanel;
    private JPanel proxyPanel;
    private JPanel opPanel;
    private JTextField socksHostText;
    private JTextField socksPortText;
    private JButton socksBtn;
    private JTextField httpHostText;
    private JTextField httpPortText;
    private JButton httpBtn;
    private JCheckBox httpCheckBox;
    private JCheckBox httpsCheckBox;
    private JCheckBox systemCheckBox;
    private JPanel socksPanel;
    private JLabel socksHostLabel;
    private JLabel socksPortLabel;
    private JPanel socksBtnPanel;
    private JPanel httpPanel;
    private JLabel httpHostPanel;
    private JLabel httpPortPanel;
    private JPanel httpBtnPanel;
    private JPanel httpOrHttpsPanel;
    private JButton systemBtn;
    private static ProxyForm instance;

    public static ProxyForm getInstance() {
        return instance;
    }

    public static void start() {
        JFrame frame = new JFrame("proxy config");
        instance = new ProxyForm();
        frame.setContentPane(instance.rootPanel);
        instance.init();
        frame.setAlwaysOnTop(true);

        frame.pack();

        frame.setLocationRelativeTo(MainForm.getInstance().getMasterPanel());

        frame.setResizable(false);
        frame.setVisible(true);
    }

    private void init() {
        if (Proxy.isSystemProxyOpen()) {
            systemCheckBox.setSelected(true);
        }
        httpHostText.setText(Proxy.getHttpHost());
        httpPortText.setText(Proxy.getHttpPort());
        socksHostText.setText(Proxy.getSocksProxyHost());
        socksPortText.setText(Proxy.getSocksProxyPort());
        httpCheckBox.setSelected(true);
        httpsCheckBox.setSelected(true);

        String text = socksHostText.getText();
        if (text == null || text.isEmpty()) {
            socksHostText.setText("127.0.0.1");
            socksPortText.setText("10808");
        }

        httpBtn.addActionListener(e -> {
            Proxy.setHttpProxy(
                    httpHostText.getText(), httpPortText.getText(), httpsCheckBox.isSelected());
            show("SET HTTP PROXY SUCCESS", instance.proxyPanel);
        });

        socksBtn.addActionListener(e -> {
            Proxy.setSocks(
                    socksHostText.getText(), socksPortText.getText());
            show("SET SOCKS PROXY SUCCESS", instance.proxyPanel);
        });

        systemBtn.addActionListener(e -> {
            if (systemCheckBox.isSelected()) {
                Proxy.setSystemProxy();
                show("SET SYSTEM PROXY SUCCESS", instance.proxyPanel);
            }
        });
    }

    private static void show(String msg, JPanel panel) {
        JOptionPane.showMessageDialog(panel, msg);
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        rootPanel = new JPanel();
        rootPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        proxyPanel = new JPanel();
        proxyPanel.setLayout(new GridLayoutManager(2, 3, new Insets(3, 3, 3, 3), -1, -1));
        proxyPanel.setBackground(new Color(-1120293));
        rootPanel.add(proxyPanel, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, new Dimension(360, -1), null, null, 0, false));
        opPanel = new JPanel();
        opPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        opPanel.setBackground(new Color(-1120293));
        proxyPanel.add(opPanel, new GridConstraints(1, 0, 1, 3, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        socksPanel = new JPanel();
        socksPanel.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        socksPanel.setBackground(new Color(-1120293));
        opPanel.add(socksPanel, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        socksPanel.setBorder(BorderFactory.createTitledBorder(null, "SOCKS PROXY", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, null));
        socksHostLabel = new JLabel();
        socksHostLabel.setText("HOST");
        socksPanel.add(socksHostLabel, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        socksPortLabel = new JLabel();
        socksPortLabel.setText("PORT");
        socksPanel.add(socksPortLabel, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        socksHostText = new JTextField();
        socksPanel.add(socksHostText, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        socksPortText = new JTextField();
        socksPanel.add(socksPortText, new GridConstraints(1, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        socksBtnPanel = new JPanel();
        socksBtnPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        socksBtnPanel.setBackground(new Color(-1120293));
        socksPanel.add(socksBtnPanel, new GridConstraints(2, 0, 1, 2, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        socksBtn = new JButton();
        socksBtn.setText("CONFIRM");
        socksBtnPanel.add(socksBtn, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        final Spacer spacer1 = new Spacer();
        socksBtnPanel.add(spacer1, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, 1, null, null, null, 0, false));
        httpPanel = new JPanel();
        httpPanel.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        httpPanel.setBackground(new Color(-1120293));
        httpPanel.setEnabled(true);
        opPanel.add(httpPanel, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        httpPanel.setBorder(BorderFactory.createTitledBorder(null, "HTTP PROXY", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, null, null));
        httpHostPanel = new JLabel();
        httpHostPanel.setText("HOST");
        httpPanel.add(httpHostPanel, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        httpPortPanel = new JLabel();
        httpPortPanel.setText("PORT");
        httpPanel.add(httpPortPanel, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        httpHostText = new JTextField();
        httpPanel.add(httpHostText, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        httpPortText = new JTextField();
        httpPanel.add(httpPortText, new GridConstraints(1, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        httpBtnPanel = new JPanel();
        httpBtnPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        httpBtnPanel.setBackground(new Color(-1120293));
        httpPanel.add(httpBtnPanel, new GridConstraints(3, 0, 1, 2, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        httpBtn = new JButton();
        httpBtn.setText("CONFIRM");
        httpBtnPanel.add(httpBtn, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        final Spacer spacer2 = new Spacer();
        httpBtnPanel.add(spacer2, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, 1, null, null, null, 0, false));
        httpOrHttpsPanel = new JPanel();
        httpOrHttpsPanel.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        httpOrHttpsPanel.setBackground(new Color(-1120293));
        httpPanel.add(httpOrHttpsPanel, new GridConstraints(2, 0, 1, 2, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        httpCheckBox = new JCheckBox();
        httpCheckBox.setBackground(new Color(-1120293));
        httpCheckBox.setText("HTTP");
        httpOrHttpsPanel.add(httpCheckBox, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        httpsCheckBox = new JCheckBox();
        httpsCheckBox.setBackground(new Color(-1120293));
        httpsCheckBox.setText("HTTPS");
        httpOrHttpsPanel.add(httpsCheckBox, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        systemCheckBox = new JCheckBox();
        systemCheckBox.setBackground(new Color(-1120293));
        systemCheckBox.setText("USE SYSTEM PROXY");
        proxyPanel.add(systemCheckBox, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        systemBtn = new JButton();
        systemBtn.setText("CONFIRM");
        proxyPanel.add(systemBtn, new GridConstraints(0, 1, 1, 2, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return rootPanel;
    }

}
