/*
 * Decompiled with CFR 0.152.
 */
package com.n1ar4.agent.vmtools;

import arthas.VmTool;
import com.n1ar4.agent.Agent;
import com.n1ar4.agent.vmtools.OSUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class VmToolUtils {
    private static String libName = null;
    public static String fileSeparator;
    public static String tmpDir;

    public static String detectLibName() {
        return libName;
    }

    public static String getlibFullTempPath() {
        return tmpDir + fileSeparator + libName;
    }

    public static VmTool getVmToolInstances() {
        String libname = VmToolUtils.detectLibName();
        String libpath = VmToolUtils.getlibFullTempPath();
        File libFile = new File(libpath);
        try {
            InputStream in = Agent.class.getResourceAsStream(String.format("/%s", libname));
            if (in == null) {
                return null;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(libpath);
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
            fileOutputStream.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!libFile.exists()) {
            return null;
        }
        VmTool instance = VmTool.getInstance(libFile.getAbsolutePath());
        return instance;
    }

    static {
        if (OSUtils.isMac()) {
            libName = "libArthasJniLibrary.dylib";
        }
        if (OSUtils.isLinux()) {
            libName = OSUtils.isArm32() ? "libArthasJniLibrary-arm.so" : (OSUtils.isArm64() ? "libArthasJniLibrary-aarch64.so" : (OSUtils.isX86_64() ? "libArthasJniLibrary-x64.so" : "libArthasJniLibrary-" + OSUtils.arch() + ".so"));
        }
        if (OSUtils.isWindows()) {
            libName = "libArthasJniLibrary-x64.dll";
            if (OSUtils.isX86()) {
                libName = "libArthasJniLibrary-x86.dll";
            }
        }
        fileSeparator = System.getProperty("file.separator");
        tmpDir = System.getProperty("java.io.tmpdir");
    }
}

