/*
 * Decompiled with CFR 0.152.
 */
package com.n1ar4.agent.util;

import com.n1ar4.agent.util.FieldUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Field field, Object value, Object target) throws IllegalArgumentException, IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static Object getDeclaredField(Object obj, String fieldName) {
        Field targetField = null;
        for (Class<?> targetClass = obj.getClass(); targetClass != null && (targetField = FieldUtils.getDeclaredField(targetClass, fieldName, true)) == null; targetClass = targetClass.getSuperclass()) {
        }
        if (targetField == null) {
            return null;
        }
        try {
            return FieldUtils.readField(targetField, obj, true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static <T> Method getTargetMethod(Class objClass, String methodName, Class[] classes, T ... args) {
        Class[] argclass = null;
        if (classes == null) {
            argclass = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argclass[i] = args[i].getClass();
            }
        } else {
            argclass = classes;
        }
        Method targetMethod = null;
        for (Class targetClass = objClass; targetClass != null; targetClass = targetClass.getSuperclass()) {
            try {
                targetMethod = targetClass.getDeclaredMethod(methodName, argclass);
                targetMethod.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return targetMethod;
    }

    public static <T> Object callMethod(Object obj, String methodName, T ... args) {
        return ReflectUtils.callMethod(obj, methodName, null, args);
    }

    public static <T> Object callMethod(Object obj, String methodName, Class[] classes, T ... args) {
        Object result = null;
        if (obj == null) {
            return null;
        }
        Method method = ReflectUtils.getTargetMethod(obj.getClass(), methodName, classes, args);
        if (method == null) {
            return null;
        }
        try {
            result = method.invoke(obj, (Object[])args);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }
}

