/*
 * Decompiled with CFR 0.152.
 */
package com.n1ar4.agent.service.tomcat;

import com.n1ar4.agent.dto.SourceResult;
import com.n1ar4.agent.dto.UrlInfo;
import com.n1ar4.agent.service.tomcat.TomcatContextDiscovery;
import com.n1ar4.agent.service.tomcat.info.HostInfo;
import com.n1ar4.agent.service.tomcat.info.ServiceInfo;
import com.n1ar4.agent.util.ReflectUtils;
import java.util.ArrayList;

public class TomcatServiceDiscovery {
    private final ServiceInfo serviceUrlInfo = new ServiceInfo();
    private Object engine;

    public TomcatServiceDiscovery(Object service) {
        Object[] connectors = (Object[])ReflectUtils.getDeclaredField(service, "connectors");
        if (connectors != null) {
            for (Object connector : connectors) {
                String protocol = (String)ReflectUtils.callMethod(connector, "getProtocol", new Object[0]);
                if (protocol.contains("AJP")) {
                    System.out.println("[*] SERVER CONTAINS AJP PROTOCOL");
                }
                if (protocol.equals("AJP/1.3")) continue;
                Object oName = ReflectUtils.callMethod(connector, "getObjectName", new Object[0]);
                String onameString = oName.toString();
                String[] properties = onameString.split(",");
                String host = "0.0.0.0";
                String port = "";
                for (String property : properties) {
                    if (property.startsWith("port=")) {
                        port = property.split("port=")[1];
                    }
                    if (!property.startsWith("address=")) continue;
                    host = property.split("address=")[1];
                    if (host.startsWith("\"")) {
                        host = host.substring(1);
                    }
                    host = host.replaceAll("[\"']", "");
                }
                String schemaPrefix = port.contains("443") || port.contains("8443") ? "https://" : "http://";
                String connectorInfo = port.isEmpty() ? String.format("%s%s", schemaPrefix, host) : String.format("%s%s:%s", schemaPrefix, host, port);
                String connectorDesc = String.format("protocol: %s", protocol);
                this.serviceUrlInfo.connectorList.add(new UrlInfo(connectorInfo, connectorDesc));
            }
        }
        this.engine = ReflectUtils.getDeclaredField(service, "engine");
        if (this.engine == null) {
            this.engine = ReflectUtils.getDeclaredField(service, "container");
        }
    }

    public ArrayList<SourceResult> getSourceResults() {
        ArrayList<SourceResult> sourceResults = new ArrayList<SourceResult>();
        if (this.engine != null) {
            this.serviceUrlInfo.defaultHost = (String)ReflectUtils.getDeclaredField(this.engine, "defaultHost");
            Object[] hosts = (Object[])ReflectUtils.callMethod(this.engine, "findChildren", new Object[0]);
            if (hosts != null) {
                for (Object host : hosts) {
                    String hostName = (String)ReflectUtils.callMethod(host, "getName", new Object[0]);
                    Object[] contexts = (Object[])ReflectUtils.callMethod(host, "findChildren", new Object[0]);
                    HostInfo tomcatHostUrlInfo = new HostInfo(this.serviceUrlInfo, hostName);
                    if (contexts == null) continue;
                    for (Object context : contexts) {
                        TomcatContextDiscovery tomcatContextSourceDiscovery = new TomcatContextDiscovery(context, tomcatHostUrlInfo);
                        sourceResults.addAll(tomcatContextSourceDiscovery.getSourceResults());
                    }
                }
            }
        }
        return sourceResults;
    }
}

