/*
 * Decompiled with CFR 0.152.
 */
package com.n1ar4.agent.service.tomcat;

import com.n1ar4.agent.dto.SourceResult;
import com.n1ar4.agent.dto.SourceResultType;
import com.n1ar4.agent.service.tomcat.info.ContextInfo;
import com.n1ar4.agent.service.tomcat.info.EndPointUrlInfo;
import com.n1ar4.agent.service.tomcat.info.HostInfo;
import com.n1ar4.agent.util.ReflectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class TomcatContextDiscovery {
    private final Object context;
    ArrayList<SourceResult> sourceList;
    private final ContextInfo contextUrlInfo;
    HashMap<String, EndPointUrlInfo> servletUrlInfoMap;

    public TomcatContextDiscovery(Object contextInstance, HostInfo hostUrlInfo) {
        this.context = contextInstance;
        this.contextUrlInfo = new ContextInfo(hostUrlInfo);
        try {
            this.contextUrlInfo.ContextUrlBase = (String)ReflectUtils.callMethod(this.context, "getPath", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.servletUrlInfoMap = new HashMap();
        this.sourceList = new ArrayList();
    }

    void getAllListener() {
        CopyOnWriteArrayList listeners = (CopyOnWriteArrayList)ReflectUtils.getDeclaredField(this.context, "applicationEventListenersList");
        if (listeners != null) {
            for (Object listener : listeners.toArray()) {
                Class<?> listenerClass = listener.getClass();
                EndPointUrlInfo endPointUrlInfo = new EndPointUrlInfo(this.contextUrlInfo);
                endPointUrlInfo.urlPatterns.add("");
                this.sourceList.add(new SourceResult(SourceResultType.TomcatListener, listenerClass.getSimpleName(), listenerClass.getName(), endPointUrlInfo.toUrlInfos()));
            }
            return;
        }
        Object[] applicationEventListeners = (Object[])ReflectUtils.callMethod(this.context, "getApplicationEventListeners", new Object[0]);
        if (applicationEventListeners != null) {
            for (Object listener : applicationEventListeners) {
                Class<?> listenerClass = listener.getClass();
                EndPointUrlInfo endPointUrlInfo = new EndPointUrlInfo(this.contextUrlInfo);
                endPointUrlInfo.urlPatterns.add("");
                this.sourceList.add(new SourceResult(SourceResultType.TomcatListener, listenerClass.getSimpleName(), listenerClass.getName(), endPointUrlInfo.toUrlInfos()));
            }
            return;
        }
        Object[] applicationListeners = (Object[])ReflectUtils.getDeclaredField(this.context, "applicationListeners");
        if (applicationListeners != null) {
            for (Object applicationListener : applicationListeners) {
                if (applicationListener.getClass().getName().equals("".getClass().getName())) {
                    EndPointUrlInfo endPointUrlInfo = new EndPointUrlInfo(this.contextUrlInfo);
                    endPointUrlInfo.urlPatterns.add("");
                    this.sourceList.add(new SourceResult(SourceResultType.TomcatListener, (String)applicationListener, (String)applicationListener, endPointUrlInfo.toUrlInfos()));
                    continue;
                }
                String listenerClassName = (String)ReflectUtils.getDeclaredField(applicationListener, "className");
                EndPointUrlInfo endPointUrlInfo = new EndPointUrlInfo(this.contextUrlInfo);
                endPointUrlInfo.urlPatterns.add("");
                this.sourceList.add(new SourceResult(SourceResultType.TomcatListener, listenerClassName, listenerClassName, endPointUrlInfo.toUrlInfos()));
            }
        }
    }

    void getFilters() {
        Object FilterMaps = ReflectUtils.getDeclaredField(this.context, "filterMaps");
        if (FilterMaps == null) {
            return;
        }
        Object[] filterMapArray = (Object[])ReflectUtils.getDeclaredField(FilterMaps, "array");
        if (filterMapArray != null && filterMapArray.length > 0) {
            HashMap filterDefs = (HashMap)ReflectUtils.getDeclaredField(this.context, "filterDefs");
            if (filterDefs == null) {
                return;
            }
            for (Object filterMap : filterMapArray) {
                String filterName = (String)ReflectUtils.getDeclaredField(filterMap, "filterName");
                String[] urlPatterns = (String[])ReflectUtils.getDeclaredField(filterMap, "urlPatterns");
                String[] ServletNames = (String[])ReflectUtils.getDeclaredField(filterMap, "servletNames");
                Object FilterDef = filterDefs.get(filterName);
                String filterClass = (String)ReflectUtils.getDeclaredField(FilterDef, "filterClass");
                ArrayList<String> filterDesc = new ArrayList<String>();
                HashMap parameters = (HashMap)ReflectUtils.getDeclaredField(FilterDef, "parameters");
                if (parameters != null && !parameters.isEmpty()) {
                    filterDesc.add("parameters : ");
                    for (Map.Entry parameter : parameters.entrySet()) {
                        String parameterKey = (String)parameter.getKey();
                        String parameterValue = (String)parameter.getValue();
                        filterDesc.add(String.format("\t %s => %s", parameterKey, parameterValue));
                    }
                }
                EndPointUrlInfo nowFilterEndPointUrlInfo = new EndPointUrlInfo(this.contextUrlInfo);
                Collections.addAll(nowFilterEndPointUrlInfo.urlPatterns, (Object[])Objects.requireNonNull(urlPatterns));
                for (String servletName : Objects.requireNonNull(ServletNames)) {
                    nowFilterEndPointUrlInfo.urlPatterns.addAll(this.servletUrlInfoMap.get((Object)servletName).urlPatterns);
                }
                this.sourceList.add(new SourceResult(SourceResultType.TomcatFilter, filterName, filterClass, nowFilterEndPointUrlInfo.toUrlInfos(), filterDesc));
            }
        }
    }

    void getAllServlets() {
        Object[] wrappers = (Object[])ReflectUtils.callMethod(this.context, "findChildren", new Object[0]);
        if (wrappers == null) {
            return;
        }
        int servletNumber = wrappers.length;
        if (servletNumber > 0) {
            HashMap servletMappings = (HashMap)ReflectUtils.getDeclaredField(this.context, "servletMappings");
            if (servletMappings == null) {
                return;
            }
            for (Map.Entry entry : servletMappings.entrySet()) {
                String servletName = (String)entry.getValue();
                String servletMapping = (String)entry.getKey();
                if (!this.servletUrlInfoMap.containsKey(servletName)) {
                    this.servletUrlInfoMap.put(servletName, new EndPointUrlInfo(this.contextUrlInfo));
                }
                this.servletUrlInfoMap.get((Object)servletName).urlPatterns.add(servletMapping);
            }
            for (Object wrapper : wrappers) {
                String servletName = (String)ReflectUtils.callMethod(wrapper, "getServletName", new Object[0]);
                String servletClass = (String)ReflectUtils.callMethod(wrapper, "getServletClass", new Object[0]);
                EndPointUrlInfo nowTomcatEndPointUrlInfo = this.servletUrlInfoMap.get(servletName);
                if (nowTomcatEndPointUrlInfo == null) continue;
                ArrayList<String> servletDesc = new ArrayList<String>();
                HashMap parameters = (HashMap)ReflectUtils.getDeclaredField(wrapper, "parameters");
                if (parameters != null && !parameters.isEmpty()) {
                    servletDesc.add("parameters : ");
                    for (Map.Entry parameter : parameters.entrySet()) {
                        String parameterKey = (String)parameter.getKey();
                        String parameterValue = (String)parameter.getValue();
                        servletDesc.add(String.format("\t %s => %s", parameterKey, parameterValue));
                    }
                }
                if (this.isNeedGetWebService(servletName)) {
                    this.getAllWebService();
                    continue;
                }
                this.sourceList.add(new SourceResult(SourceResultType.TomcatServlet, servletName, servletClass, nowTomcatEndPointUrlInfo.toUrlInfos(), servletDesc));
            }
        }
    }

    boolean isNeedGetWebService(String servletName) {
        return servletName.equals("Dynamic JAXWS Servlet");
    }

    void getAllWebService() {
        int adapterSize;
        Object applicationContext = ReflectUtils.getDeclaredField(this.context, "context");
        Object wsServletDelegate = ReflectUtils.callMethod(applicationContext, "getAttribute", "com.sun.xml.ws.server.http.servletDelegate");
        ArrayList servletAdapters = (ArrayList)ReflectUtils.getDeclaredField(wsServletDelegate, "adapters");
        if (servletAdapters != null && (adapterSize = servletAdapters.size()) > 0) {
            for (Object servletAdapter : servletAdapters) {
                String adapterName = (String)ReflectUtils.callMethod(servletAdapter, "getName", new Object[0]);
                String adapterUrlPattern = (String)ReflectUtils.getDeclaredField(servletAdapter, "urlPattern");
                Object endPoint = ReflectUtils.callMethod(servletAdapter, "getEndpoint", new Object[0]);
                Class implementationClass = (Class)ReflectUtils.getDeclaredField(endPoint, "implementationClass");
                EndPointUrlInfo webserviceEndPointUrlInfo = new EndPointUrlInfo(this.contextUrlInfo);
                webserviceEndPointUrlInfo.urlPatterns.add(adapterUrlPattern);
                this.sourceList.add(new SourceResult(SourceResultType.TomcatWebService, adapterName, Objects.requireNonNull(implementationClass).getName(), webserviceEndPointUrlInfo.toUrlInfos()));
            }
        }
    }

    public ArrayList<SourceResult> getSourceResults() {
        this.getAllListener();
        this.getAllServlets();
        this.getFilters();
        return this.sourceList;
    }
}

