/*
 * Decompiled with CFR 0.152.
 */
package com.n1ar4.agent.dto;

import com.n1ar4.agent.dto.SourceResultType;
import com.n1ar4.agent.dto.UrlInfo;
import com.n1ar4.agent.dto.UrlInfoAndDescMapValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class SourceResult
implements Serializable,
Comparable<SourceResult> {
    public SourceResultType type;
    public String name;
    public String sourceClass;
    public String methodInfo;
    public ArrayList<UrlInfo> urlInfos = null;
    public ArrayList<String> description = null;
    public static String SourceResultTag = "sourceTag:";
    private int hashResult = -1;

    public SourceResult() {
    }

    public SourceResult(SourceResultType type, String name, String sourceClass, ArrayList<UrlInfo> urlInfos) {
        this.type = type;
        this.name = name;
        this.sourceClass = sourceClass;
        this.urlInfos = urlInfos;
        this.methodInfo = null;
        this.description = null;
    }

    public SourceResult(SourceResultType type, String name, String sourceClass, String methodInfo, ArrayList<UrlInfo> urlInfos) {
        this(type, name, sourceClass, urlInfos);
        this.methodInfo = methodInfo;
    }

    public SourceResult(SourceResultType type, String name, String sourceClass, ArrayList<UrlInfo> urlInfos, ArrayList<String> description) {
        this(type, name, sourceClass, urlInfos);
        if (description != null && !description.isEmpty()) {
            this.description = description;
        }
    }

    public SourceResult(SourceResultType type, String name, String sourceClass, String methodInfo, ArrayList<UrlInfo> urlInfos, ArrayList<String> description) {
        this(type, name, sourceClass, urlInfos, description);
        this.methodInfo = methodInfo;
    }

    public SourceResultType getType() {
        return this.type;
    }

    public void setType(SourceResultType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(String sourceClass) {
        this.sourceClass = sourceClass;
    }

    public String getMethodInfo() {
        return this.methodInfo;
    }

    public void setMethodInfo(String methodInfo) {
        this.methodInfo = methodInfo;
    }

    public ArrayList<UrlInfo> getUrlInfos() {
        return this.urlInfos;
    }

    public void setUrlInfos(ArrayList<UrlInfo> urlInfos) {
        this.urlInfos = urlInfos;
    }

    public ArrayList<String> getDescription() {
        return this.description;
    }

    public void setDescription(ArrayList<String> description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceResult targetSourceResult = (SourceResult)o;
        if (!targetSourceResult.type.equals((Object)this.type)) {
            return false;
        }
        if (targetSourceResult.name == null ? this.name != null : !targetSourceResult.name.equals(this.name)) {
            return false;
        }
        if (!targetSourceResult.sourceClass.equals(this.sourceClass)) {
            return false;
        }
        if (targetSourceResult.methodInfo != null ? !targetSourceResult.methodInfo.equals(this.methodInfo) : this.methodInfo != null) {
            return false;
        }
        return targetSourceResult.getUrlInfos().toString().equals(this.getUrlInfos().toString());
    }

    private int typeHash(Object data) {
        if (data == null) {
            return 0;
        }
        return data.hashCode();
    }

    public int hashCode() {
        if (this.hashResult == -1) {
            this.hashResult = 1;
            this.hashResult = 31 * this.hashResult + this.typeHash((Object)this.type);
            this.hashResult = 31 * this.hashResult + this.typeHash(this.name);
            this.hashResult = 31 * this.hashResult + this.typeHash(this.sourceClass);
            this.hashResult = 31 * this.hashResult + (this.methodInfo == null ? "".hashCode() : this.methodInfo.hashCode());
            this.hashResult = 31 * this.hashResult + (this.urlInfos == null ? 0 : Arrays.hashCode(this.getUrlInfos().toArray()));
            this.hashResult = 31 * this.hashResult + (this.description == null ? 0 : Arrays.hashCode(this.getDescription().toArray()));
        }
        return this.hashResult;
    }

    @Override
    public int compareTo(SourceResult o) {
        if (this.type.ordinal() != o.type.ordinal()) {
            return this.type.ordinal() - o.type.ordinal();
        }
        return Arrays.toString(new ArrayList[]{this.urlInfos}).compareTo(Arrays.toString(new ArrayList[]{o.getUrlInfos()}));
    }

    public HashMap<String, UrlInfoAndDescMapValue> getSourceTagMapForUrlInfosAndDesc() {
        HashMap<String, UrlInfoAndDescMapValue> tagHashMap = new HashMap<String, UrlInfoAndDescMapValue>();
        ArrayList<String> descList = this.getDescription();
        String nowTag = "";
        for (String oneLineDesc : descList) {
            if (oneLineDesc.startsWith(SourceResultTag)) {
                String tag = oneLineDesc.split(SourceResultTag)[1];
                tagHashMap.put(tag, new UrlInfoAndDescMapValue(tag));
                nowTag = tag;
                continue;
            }
            UrlInfoAndDescMapValue urlInfoAndDescMapValue = tagHashMap.get(nowTag);
            if (urlInfoAndDescMapValue == null) {
                System.out.println("[-] error out : not found target tag : " + nowTag);
                continue;
            }
            urlInfoAndDescMapValue.desc.add(oneLineDesc);
        }
        for (UrlInfo urlInfo : this.getUrlInfos()) {
            String[] descriptionList = urlInfo.getDescriptionList();
            String lastUrlDesc = descriptionList[descriptionList.length - 1];
            if (!lastUrlDesc.startsWith(SourceResultTag)) {
                System.out.println("[-] not found tag in url : " + urlInfo.getUrl());
                continue;
            }
            String tag = lastUrlDesc.split(SourceResultTag)[1];
            UrlInfoAndDescMapValue urlInfoAndDescMapValue = tagHashMap.get(tag);
            if (urlInfoAndDescMapValue == null) {
                System.out.println("[-] error out : not found target tag in url list: " + nowTag);
                continue;
            }
            urlInfoAndDescMapValue.urlInfos.add(urlInfo);
        }
        return tagHashMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Source Type : ").append(this.getType().toString()).append("\n");
        sb.append("\t Source Name : ").append(this.getName()).append("\n");
        sb.append("\t Source Class : ").append(this.getSourceClass()).append("\n");
        HashMap<String, UrlInfoAndDescMapValue> sourceTagMapForUrlInfosAndDesc = this.getSourceTagMapForUrlInfosAndDesc();
        Collection<UrlInfoAndDescMapValue> values = sourceTagMapForUrlInfosAndDesc.values();
        for (UrlInfoAndDescMapValue value : values) {
            ArrayList<String> description;
            sb.append("\t Source Result Tag : ").append(value.tag).append("\n");
            if (value.urlInfos != null && !value.urlInfos.isEmpty()) {
                sb.append("\t\t Source UrlInfo : \n");
                for (UrlInfo urlInfo : value.urlInfos) {
                    sb.append("\t\t\t Url : ").append(urlInfo.getUrl()).append("\n");
                    if (urlInfo.getDescription().isEmpty()) continue;
                    for (String oneLineDesc : urlInfo.getDescriptionList()) {
                        if (oneLineDesc.startsWith(SourceResultTag)) continue;
                        sb.append("\t\t\t\t desc : ").append(oneLineDesc.trim()).append("\n");
                    }
                }
            }
            if ((description = value.desc) == null || description.isEmpty()) continue;
            sb.append("\t\t Source Description : \n");
            for (String desc : description) {
                sb.append("\t\t\t ").append(desc).append("\n");
            }
        }
        return sb.toString();
    }

    public String generateUrlInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.urlInfos != null && !this.urlInfos.isEmpty()) {
            for (UrlInfo urlInfo : this.urlInfos) {
                sb.append(urlInfo.getUrl());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

