/*
 * Decompiled with CFR 0.152.
 */
package com.n1ar4.agent.core;

import arthas.VmTool;
import com.n1ar4.agent.Agent;
import com.n1ar4.agent.dto.ResultReturn;
import com.n1ar4.agent.dto.SourceResult;
import com.n1ar4.agent.dto.UrlInfo;
import com.n1ar4.agent.service.ServerDiscovery;
import com.n1ar4.agent.service.ServerDiscoveryType;
import com.n1ar4.agent.transform.CoreTransformer;
import com.n1ar4.agent.util.Base64Util;
import com.n1ar4.agent.util.CustomOutputStream;
import com.n1ar4.agent.util.FilterObjectInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class Task
implements Runnable {
    private final Socket socket;
    private final VmTool vmTool;
    private final Instrumentation instLocal;
    private static final HashSet<ClassLoader> loaders = new HashSet();

    public Task(Socket socket, VmTool vmTool, Instrumentation instLocal) {
        Class[] allLoadedClasses;
        this.socket = socket;
        this.vmTool = vmTool;
        this.instLocal = instLocal;
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (Class loadedClass : allLoadedClasses = Agent.staticIns.getAllLoadedClasses()) {
            ClassLoader classLoader = loadedClass.getClassLoader();
            if (classLoader == null) continue;
            classLoaders.add(classLoader);
        }
        loaders.addAll(classLoaders);
    }

    @Override
    public void run() {
        try {
            this.handleSocket();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ArrayList<SourceResult> mergeSourceResults(HashSet<SourceResult> results) {
        ArrayList<SourceResult> newResult = new ArrayList<SourceResult>();
        HashMap SourceCollectList = new HashMap();
        for (SourceResult resultItem : results) {
            String index = String.format("%s|%s+%s", resultItem.getType().toString(), resultItem.getSourceClass(), resultItem.getMethodInfo());
            if (!SourceCollectList.containsKey(index)) {
                SourceCollectList.put(index, new ArrayList());
            }
            ((ArrayList)SourceCollectList.get(index)).add(resultItem);
        }
        for (ArrayList sourceResults : SourceCollectList.values()) {
            SourceResult originalSourceResult = (SourceResult)sourceResults.get(0);
            ArrayList<UrlInfo> urlInfos = new ArrayList<UrlInfo>();
            ArrayList<String> descriptions = new ArrayList<String>();
            for (SourceResult sourceResult : sourceResults) {
                ArrayList<UrlInfo> nowUrlInfos = sourceResult.getUrlInfos();
                if (nowUrlInfos != null) {
                    for (UrlInfo s : nowUrlInfos) {
                        s.appendDescription(SourceResult.SourceResultTag + sourceResult.hashCode());
                        urlInfos.add(s);
                    }
                }
                descriptions.add(SourceResult.SourceResultTag + sourceResult.hashCode());
                ArrayList<String> description = sourceResult.getDescription();
                ArrayList<String> value = description;
                if (value == null) continue;
                for (String s : value) {
                    descriptions.add("\t" + s);
                }
            }
            newResult.add(new SourceResult(originalSourceResult.getType(), originalSourceResult.getName(), originalSourceResult.getSourceClass(), originalSourceResult.getMethodInfo(), urlInfos, descriptions));
        }
        return newResult;
    }

    private void handleSocket() throws Exception {
        FilterObjectInputStream ois;
        try {
            ois = new FilterObjectInputStream(this.socket.getInputStream());
        }
        catch (Exception ex) {
            return;
        }
        String targetClass = (String)ois.readObject();
        if (targetClass.startsWith("<ALL>")) {
            Agent.refreshClass();
            String PASS = targetClass.split("<ALL>")[1];
            if (!PASS.equals(Agent.PASSWORD)) {
                System.out.println("[-] ERROR PASSWORD");
                return;
            }
            ArrayList<String> classNameList = new ArrayList<String>();
            for (Class<?> c : Agent.staticClasses) {
                if (c.getName().startsWith("[") || c.getName().contains("$$Lambda")) continue;
                classNameList.add(c.getName());
            }
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(classNameList);
            System.out.printf("[*] WRITE TOTAL CLASS %d\n", classNameList.size());
            this.socket.getOutputStream().write(bao.toByteArray());
            return;
        }
        if (targetClass.startsWith("<GET-ALL>")) {
            Agent.refreshClass();
            ResultReturn resultReturn = new ResultReturn("", "");
            try {
                String PASS = targetClass.split("<GET-ALL>")[1];
                if (!PASS.equals(Agent.PASSWORD)) {
                    System.out.println("[-] ERROR PASSWORD");
                    return;
                }
                ArrayList<SourceResult> sourceResults = new ArrayList<SourceResult>();
                for (ServerDiscoveryType serverDiscoveryType : ServerDiscoveryType.values()) {
                    ServerDiscovery serverDiscovery = serverDiscoveryType.getServerDiscovery();
                    if (!serverDiscovery.CanLoad(this.vmTool, this.instLocal)) continue;
                    sourceResults.addAll(serverDiscovery.getServerSources(this.vmTool, this.instLocal));
                }
                ArrayList<SourceResult> sourceResultsFinal = Task.mergeSourceResults(new HashSet<SourceResult>(sourceResults));
                Collections.sort(sourceResultsFinal);
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bao);
                oos.writeObject(sourceResultsFinal);
                oos.close();
                resultReturn.setObjectString(Base64Util.encode(bao.toByteArray()));
            }
            catch (Exception e) {
                CustomOutputStream customOutputStream = new CustomOutputStream();
                PrintStream printStream = new PrintStream(customOutputStream);
                e.printStackTrace(printStream);
                resultReturn.setConsoleOutput(customOutputStream.getResult());
            }
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(resultReturn);
            oos.close();
            System.out.printf("[*] WRITE OBJECT LENGTH %d\n", resultReturn.getObjectString().length());
            this.socket.getOutputStream().write(bao.toByteArray());
            return;
        }
        if (targetClass.startsWith("<VALVES>")) {
            Agent.refreshClass();
            String PASS = targetClass.split("<VALVES>")[1];
            if (!PASS.equals(Agent.PASSWORD)) {
                System.out.println("[-] ERROR PASSWORD");
                return;
            }
            ArrayList<String> classList = new ArrayList<String>();
            for (Class<?> c : Agent.staticClasses) {
                try {
                    ClassLoader classLoader = c.getClassLoader() != null ? c.getClassLoader() : Thread.currentThread().getContextClassLoader();
                    Class<?> clsFilter = null;
                    try {
                        clsFilter = classLoader.loadClass("org.apache.catalina.Valve");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clsFilter == null || !clsFilter.isAssignableFrom(c)) continue;
                    classList.add(c.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(classList);
            System.out.printf("[*] WRITE TOTAL CLASS %d\n", classList.size());
            this.socket.getOutputStream().write(bao.toByteArray());
            return;
        }
        if (!targetClass.split("\\|")[0].equals(Agent.PASSWORD)) {
            return;
        }
        targetClass = targetClass.split("\\|")[1];
        Agent.refreshClass();
        try {
            Class<?> c = Task.loadClassUsingAllClassLoaders(targetClass);
            if (c == null) {
                throw new RuntimeException("CLASS NOT FOUND");
            }
            CoreTransformer coreTransformer = new CoreTransformer(targetClass);
            Agent.staticIns.addTransformer(coreTransformer, true);
            Agent.staticIns.retransformClasses(c);
            if (coreTransformer.data != null && coreTransformer.data.length != 0) {
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bao);
                oos.writeObject(coreTransformer.data);
                System.out.printf("[*] WRITE BYTECODE LENGTH %d\n", coreTransformer.data.length);
                this.socket.getOutputStream().write(bao.toByteArray());
            }
            Agent.staticIns.removeTransformer(coreTransformer);
        }
        catch (Exception ignored) {
            System.out.println("[-] CLASS NOT FOUND: " + targetClass);
        }
    }

    public static Class<?> loadClassUsingAllClassLoaders(String className) {
        for (ClassLoader classLoader : loaders) {
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        Agent.refreshClass();
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        Class[] allLoadedClasses = Agent.staticIns.getAllLoadedClasses();
        for (Class loadedClass : allLoadedClasses) {
            ClassLoader classLoader = loadedClass.getClassLoader();
            if (classLoader == null) continue;
            classLoaders.add(classLoader);
        }
        loaders.clear();
        loaders.addAll(classLoaders);
        for (ClassLoader classLoader : classLoaders) {
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

