# Contributing
We love pull requests from everyone. By participating in this project, you agree to abide by the JanusVR [code of conduct](#code-of-conduct) found below.

## Process
We use the [GitHub Flow](https://guides.github.com/introduction/flow/index.html) workflow.

1. Before writing any code, first open an issue in the [issue tracker](https://github.com/janusvr/janus-server/issues).
2. Fork, then clone this repo. If you're an official contributor, you can create a branch instead of forking.
 * Branch names should follow this pattern:
   * [#issue-number]_[short-desc-of-issue]
3. Push to your fork or branch and then send a pull request to this project.

At this point you're waiting on us. We like to at least comment on pull requests within three business days (and, typically, one business day). We may suggest some changes or improvements or alternatives.

Some things that will increase the chance that your pull request is accepted:

* Write a [good commit message](https://gist.github.com/sukima/8115d0eb3c10b82cdd2b).
* Write testing instructions in your pull request (if necessary).
* Read and follow this [GitHub Guide](https://guides.github.com/activities/contributing-to-open-source/).

The JanusVR Presence Server uses [Semantic Versioning 2.0.0](http://semver.org/).


# Code Of Conduct

## Summary
Harassment in code and discussion or violation of physical boundaries is completely unacceptable anywhere in JanusVR's project codebases, issue trackers, chatrooms, mailing lists, meetups, and other events. Violators will be warned by the core team. Repeat violations will result in being blocked or banned by the core team at or before the 3rd violation.

## In detail
Harassment includes offensive verbal comments related to gender identity, gender expression, sexual orientation, disability, physical appearance, body size, race, religion, sexual images, deliberate intimidation, stalking, sustained disruption, and unwelcome sexual attention.

Individuals asked to stop any harassing behavior are expected to comply immediately.

Maintainers are also subject to the anti-harassment policy.

If anyone engages in harassing behavior, including maintainers, we may take appropriate action, up to and including warning the offender, deletion of comments, removal from the project’s codebase and communication systems, and escalation to GitHub support.

If you are being harassed, notice that someone else is being harassed, or have any other concerns, please contact a member of the core team immediately.

We expect everyone to follow these rules anywhere in JanusVR's project codebases, issue trackers, chatrooms, and mailing lists.

Finally, don't forget that it is human to make mistakes! We all do. Let’s work together to help each other, resolve issues, and learn from the mistakes that we will all inevitably make from time to time.