/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Transaction
    /// </summary>
    [DataContract]
    public partial class Transaction :  IEquatable<Transaction>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Transaction" /> class.
        /// </summary>
        /// <param name="transactionDateTime">Date and time the comment was updated. String, YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="currencyCode">ISO-4217 currency code (3-letter alphabetic currency code)..</param>
        /// <param name="transactionAmount">Amount of the transaction formatted with decimal places..</param>
        /// <param name="transactionTypeCode">Type of transaction. Valid values:&lt;br /&gt;    \&quot;PURCH\&quot; &#x3D; Purchase&lt;br /&gt;    \&quot;PURCB\&quot; &#x3D; Purchase with Cashback&lt;br /&gt;    \&quot;REFND\&quot; &#x3D; Refund&lt;br /&gt;    \&quot;AFD\&quot; &#x3D; Purchase Pre-Auth AFD&lt;br /&gt;    \&quot;CLRRF\&quot; &#x3D; Clearing Refund&lt;br /&gt;    \&quot;NAFD\&quot; &#x3D; Purchase Pre-Auth Non-AFD&lt;br /&gt;    \&quot;ATMWD” &#x3D; ATM Cash Withdrawal&lt;br /&gt;    \&quot;ATMDP\&quot; &#x3D; ATM Deposit&lt;br /&gt;    \&quot;CASHD\&quot; &#x3D; Cash Disbursement&lt;br /&gt;    \&quot;ATMTR\&quot; &#x3D; ATM Account Transfer..</param>
        /// <param name="transactionTypeDescription">Description of the transaction type..</param>
        /// <param name="transactionStatusCode">Transaction status. Valid values:&lt;br /&gt;    \&quot;AUTH\&quot; &#x3D; Authorized&lt;br /&gt;    \&quot;COMP\&quot; &#x3D; Completed&lt;br /&gt;    \&quot;DCLN\&quot; &#x3D; Declined&lt;br /&gt;    \&quot;PAUTH\&quot; &#x3D; Pre-Authorized&lt;br /&gt;    \&quot;PAUTC\&quot; &#x3D; Pre-Authorization Completed&lt;br /&gt;    \&quot;PAUTD\&quot; &#x3D; Pre-Authorization Declined&lt;br /&gt;    \&quot;REFND\&quot; &#x3D; Refunded.</param>
        /// <param name="merchantName">Name of the merchant. Conditional field. When available, it must be included in the response. Note: For Contactless ATM transactions the system will add ‘ATM-’ prefix to the merchant name if it was not populated by the acquirer initially..</param>
        /// <param name="merchantCategoryCode">Merchant category of the merchant. Conditional field. When available, it must be included in the response..</param>
        /// <param name="merchantCategoryDescription">Description of the merchant category..</param>
        /// <param name="pOSEntryMode">Indicates the mode by which transaction data was collected at the merchant. Conditional field. When available, it must be included in the response.  Valid values:&lt;br /&gt;    \&quot;07\&quot; - Contactless M/Chip transaction&lt;br /&gt;    \&quot;09\&quot; - Digital Secure Remote Payment containing EMV data&lt;br /&gt;    \&quot;81\&quot; - Digital Secure Remote Payment containing UCAF data or CoF&lt;br /&gt;    \&quot;82\&quot; - CoF - PAN auto entry via server&lt;br /&gt;    \&quot;90\&quot; - Dynamic Magnetic Strip Data&lt;br /&gt;    \&quot;91\&quot; - Contactless magnetic stripe.</param>
        public Transaction(string transactionDateTime = default(string), string currencyCode = default(string), string transactionAmount = default(string), string transactionTypeCode = default(string), string transactionTypeDescription = default(string), string transactionStatusCode = default(string), string merchantName = default(string), string merchantCategoryCode = default(string), string merchantCategoryDescription = default(string), string pOSEntryMode = default(string))
        {
            this.TransactionDateTime = transactionDateTime;
            this.CurrencyCode = currencyCode;
            this.TransactionAmount = transactionAmount;
            this.TransactionTypeCode = transactionTypeCode;
            this.TransactionTypeDescription = transactionTypeDescription;
            this.TransactionStatusCode = transactionStatusCode;
            this.MerchantName = merchantName;
            this.MerchantCategoryCode = merchantCategoryCode;
            this.MerchantCategoryDescription = merchantCategoryDescription;
            this.POSEntryMode = pOSEntryMode;
        }
        
        /// <summary>
        /// Date and time the comment was updated. String, YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time the comment was updated. String, YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="TransactionDateTime", EmitDefaultValue=false)]
        public string TransactionDateTime { get; set; }

        /// <summary>
        /// ISO-4217 currency code (3-letter alphabetic currency code).
        /// </summary>
        /// <value>ISO-4217 currency code (3-letter alphabetic currency code).</value>
        [DataMember(Name="CurrencyCode", EmitDefaultValue=false)]
        public string CurrencyCode { get; set; }

        /// <summary>
        /// Amount of the transaction formatted with decimal places.
        /// </summary>
        /// <value>Amount of the transaction formatted with decimal places.</value>
        [DataMember(Name="TransactionAmount", EmitDefaultValue=false)]
        public string TransactionAmount { get; set; }

        /// <summary>
        /// Type of transaction. Valid values:&lt;br /&gt;    \&quot;PURCH\&quot; &#x3D; Purchase&lt;br /&gt;    \&quot;PURCB\&quot; &#x3D; Purchase with Cashback&lt;br /&gt;    \&quot;REFND\&quot; &#x3D; Refund&lt;br /&gt;    \&quot;AFD\&quot; &#x3D; Purchase Pre-Auth AFD&lt;br /&gt;    \&quot;CLRRF\&quot; &#x3D; Clearing Refund&lt;br /&gt;    \&quot;NAFD\&quot; &#x3D; Purchase Pre-Auth Non-AFD&lt;br /&gt;    \&quot;ATMWD” &#x3D; ATM Cash Withdrawal&lt;br /&gt;    \&quot;ATMDP\&quot; &#x3D; ATM Deposit&lt;br /&gt;    \&quot;CASHD\&quot; &#x3D; Cash Disbursement&lt;br /&gt;    \&quot;ATMTR\&quot; &#x3D; ATM Account Transfer.
        /// </summary>
        /// <value>Type of transaction. Valid values:&lt;br /&gt;    \&quot;PURCH\&quot; &#x3D; Purchase&lt;br /&gt;    \&quot;PURCB\&quot; &#x3D; Purchase with Cashback&lt;br /&gt;    \&quot;REFND\&quot; &#x3D; Refund&lt;br /&gt;    \&quot;AFD\&quot; &#x3D; Purchase Pre-Auth AFD&lt;br /&gt;    \&quot;CLRRF\&quot; &#x3D; Clearing Refund&lt;br /&gt;    \&quot;NAFD\&quot; &#x3D; Purchase Pre-Auth Non-AFD&lt;br /&gt;    \&quot;ATMWD” &#x3D; ATM Cash Withdrawal&lt;br /&gt;    \&quot;ATMDP\&quot; &#x3D; ATM Deposit&lt;br /&gt;    \&quot;CASHD\&quot; &#x3D; Cash Disbursement&lt;br /&gt;    \&quot;ATMTR\&quot; &#x3D; ATM Account Transfer.</value>
        [DataMember(Name="TransactionTypeCode", EmitDefaultValue=false)]
        public string TransactionTypeCode { get; set; }

        /// <summary>
        /// Description of the transaction type.
        /// </summary>
        /// <value>Description of the transaction type.</value>
        [DataMember(Name="TransactionTypeDescription", EmitDefaultValue=false)]
        public string TransactionTypeDescription { get; set; }

        /// <summary>
        /// Transaction status. Valid values:&lt;br /&gt;    \&quot;AUTH\&quot; &#x3D; Authorized&lt;br /&gt;    \&quot;COMP\&quot; &#x3D; Completed&lt;br /&gt;    \&quot;DCLN\&quot; &#x3D; Declined&lt;br /&gt;    \&quot;PAUTH\&quot; &#x3D; Pre-Authorized&lt;br /&gt;    \&quot;PAUTC\&quot; &#x3D; Pre-Authorization Completed&lt;br /&gt;    \&quot;PAUTD\&quot; &#x3D; Pre-Authorization Declined&lt;br /&gt;    \&quot;REFND\&quot; &#x3D; Refunded
        /// </summary>
        /// <value>Transaction status. Valid values:&lt;br /&gt;    \&quot;AUTH\&quot; &#x3D; Authorized&lt;br /&gt;    \&quot;COMP\&quot; &#x3D; Completed&lt;br /&gt;    \&quot;DCLN\&quot; &#x3D; Declined&lt;br /&gt;    \&quot;PAUTH\&quot; &#x3D; Pre-Authorized&lt;br /&gt;    \&quot;PAUTC\&quot; &#x3D; Pre-Authorization Completed&lt;br /&gt;    \&quot;PAUTD\&quot; &#x3D; Pre-Authorization Declined&lt;br /&gt;    \&quot;REFND\&quot; &#x3D; Refunded</value>
        [DataMember(Name="TransactionStatusCode", EmitDefaultValue=false)]
        public string TransactionStatusCode { get; set; }

        /// <summary>
        /// Name of the merchant. Conditional field. When available, it must be included in the response. Note: For Contactless ATM transactions the system will add ‘ATM-’ prefix to the merchant name if it was not populated by the acquirer initially.
        /// </summary>
        /// <value>Name of the merchant. Conditional field. When available, it must be included in the response. Note: For Contactless ATM transactions the system will add ‘ATM-’ prefix to the merchant name if it was not populated by the acquirer initially.</value>
        [DataMember(Name="MerchantName", EmitDefaultValue=false)]
        public string MerchantName { get; set; }

        /// <summary>
        /// Merchant category of the merchant. Conditional field. When available, it must be included in the response.
        /// </summary>
        /// <value>Merchant category of the merchant. Conditional field. When available, it must be included in the response.</value>
        [DataMember(Name="MerchantCategoryCode", EmitDefaultValue=false)]
        public string MerchantCategoryCode { get; set; }

        /// <summary>
        /// Description of the merchant category.
        /// </summary>
        /// <value>Description of the merchant category.</value>
        [DataMember(Name="MerchantCategoryDescription", EmitDefaultValue=false)]
        public string MerchantCategoryDescription { get; set; }

        /// <summary>
        /// Indicates the mode by which transaction data was collected at the merchant. Conditional field. When available, it must be included in the response.  Valid values:&lt;br /&gt;    \&quot;07\&quot; - Contactless M/Chip transaction&lt;br /&gt;    \&quot;09\&quot; - Digital Secure Remote Payment containing EMV data&lt;br /&gt;    \&quot;81\&quot; - Digital Secure Remote Payment containing UCAF data or CoF&lt;br /&gt;    \&quot;82\&quot; - CoF - PAN auto entry via server&lt;br /&gt;    \&quot;90\&quot; - Dynamic Magnetic Strip Data&lt;br /&gt;    \&quot;91\&quot; - Contactless magnetic stripe
        /// </summary>
        /// <value>Indicates the mode by which transaction data was collected at the merchant. Conditional field. When available, it must be included in the response.  Valid values:&lt;br /&gt;    \&quot;07\&quot; - Contactless M/Chip transaction&lt;br /&gt;    \&quot;09\&quot; - Digital Secure Remote Payment containing EMV data&lt;br /&gt;    \&quot;81\&quot; - Digital Secure Remote Payment containing UCAF data or CoF&lt;br /&gt;    \&quot;82\&quot; - CoF - PAN auto entry via server&lt;br /&gt;    \&quot;90\&quot; - Dynamic Magnetic Strip Data&lt;br /&gt;    \&quot;91\&quot; - Contactless magnetic stripe</value>
        [DataMember(Name="POSEntryMode", EmitDefaultValue=false)]
        public string POSEntryMode { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Transaction {\n");
            sb.Append("  TransactionDateTime: ").Append(TransactionDateTime).Append("\n");
            sb.Append("  CurrencyCode: ").Append(CurrencyCode).Append("\n");
            sb.Append("  TransactionAmount: ").Append(TransactionAmount).Append("\n");
            sb.Append("  TransactionTypeCode: ").Append(TransactionTypeCode).Append("\n");
            sb.Append("  TransactionTypeDescription: ").Append(TransactionTypeDescription).Append("\n");
            sb.Append("  TransactionStatusCode: ").Append(TransactionStatusCode).Append("\n");
            sb.Append("  MerchantName: ").Append(MerchantName).Append("\n");
            sb.Append("  MerchantCategoryCode: ").Append(MerchantCategoryCode).Append("\n");
            sb.Append("  MerchantCategoryDescription: ").Append(MerchantCategoryDescription).Append("\n");
            sb.Append("  POSEntryMode: ").Append(POSEntryMode).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Transaction);
        }

        /// <summary>
        /// Returns true if Transaction instances are equal
        /// </summary>
        /// <param name="input">Instance of Transaction to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Transaction input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.TransactionDateTime == input.TransactionDateTime ||
                    (this.TransactionDateTime != null &&
                    this.TransactionDateTime.Equals(input.TransactionDateTime))
                ) && 
                (
                    this.CurrencyCode == input.CurrencyCode ||
                    (this.CurrencyCode != null &&
                    this.CurrencyCode.Equals(input.CurrencyCode))
                ) && 
                (
                    this.TransactionAmount == input.TransactionAmount ||
                    (this.TransactionAmount != null &&
                    this.TransactionAmount.Equals(input.TransactionAmount))
                ) && 
                (
                    this.TransactionTypeCode == input.TransactionTypeCode ||
                    (this.TransactionTypeCode != null &&
                    this.TransactionTypeCode.Equals(input.TransactionTypeCode))
                ) && 
                (
                    this.TransactionTypeDescription == input.TransactionTypeDescription ||
                    (this.TransactionTypeDescription != null &&
                    this.TransactionTypeDescription.Equals(input.TransactionTypeDescription))
                ) && 
                (
                    this.TransactionStatusCode == input.TransactionStatusCode ||
                    (this.TransactionStatusCode != null &&
                    this.TransactionStatusCode.Equals(input.TransactionStatusCode))
                ) && 
                (
                    this.MerchantName == input.MerchantName ||
                    (this.MerchantName != null &&
                    this.MerchantName.Equals(input.MerchantName))
                ) && 
                (
                    this.MerchantCategoryCode == input.MerchantCategoryCode ||
                    (this.MerchantCategoryCode != null &&
                    this.MerchantCategoryCode.Equals(input.MerchantCategoryCode))
                ) && 
                (
                    this.MerchantCategoryDescription == input.MerchantCategoryDescription ||
                    (this.MerchantCategoryDescription != null &&
                    this.MerchantCategoryDescription.Equals(input.MerchantCategoryDescription))
                ) && 
                (
                    this.POSEntryMode == input.POSEntryMode ||
                    (this.POSEntryMode != null &&
                    this.POSEntryMode.Equals(input.POSEntryMode))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.TransactionDateTime != null)
                    hashCode = hashCode * 59 + this.TransactionDateTime.GetHashCode();
                if (this.CurrencyCode != null)
                    hashCode = hashCode * 59 + this.CurrencyCode.GetHashCode();
                if (this.TransactionAmount != null)
                    hashCode = hashCode * 59 + this.TransactionAmount.GetHashCode();
                if (this.TransactionTypeCode != null)
                    hashCode = hashCode * 59 + this.TransactionTypeCode.GetHashCode();
                if (this.TransactionTypeDescription != null)
                    hashCode = hashCode * 59 + this.TransactionTypeDescription.GetHashCode();
                if (this.TransactionStatusCode != null)
                    hashCode = hashCode * 59 + this.TransactionStatusCode.GetHashCode();
                if (this.MerchantName != null)
                    hashCode = hashCode * 59 + this.MerchantName.GetHashCode();
                if (this.MerchantCategoryCode != null)
                    hashCode = hashCode * 59 + this.MerchantCategoryCode.GetHashCode();
                if (this.MerchantCategoryDescription != null)
                    hashCode = hashCode * 59 + this.MerchantCategoryDescription.GetHashCode();
                if (this.POSEntryMode != null)
                    hashCode = hashCode * 59 + this.POSEntryMode.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
