/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// TokenUpdateRequest
    /// </summary>
    [DataContract]
    public partial class TokenUpdateRequest :  IEquatable<TokenUpdateRequest>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TokenUpdateRequest" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TokenUpdateRequest() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TokenUpdateRequest" /> class.
        /// </summary>
        /// <param name="tokenUniqueReference">A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Conditional field, used for updating a single token and not used when CurrentAccountPan is present. Length 48 characters..</param>
        /// <param name="currentAccountPan">Current Account PAN of the token(s) to be updated. Conditional field, used for updating all tokens mapped to a single Account PAN and must not be present when TokenUniqueReference is present. Length 9 - 19 characters..</param>
        /// <param name="newAccountPan">New Account PAN to be applied to the updated token(s) if there is in fact a new Account PAN. Optional if updating Expiration Date or PAN Sequence Number. Length 9 - 19 characters..</param>
        /// <param name="currentFinancialAccountInformation">currentFinancialAccountInformation.</param>
        /// <param name="newFinancialAccountId">New Financial Account Identifier to be applied to the updated token(s)  if there is in fact new Financial Account Identifier. Conditional field,  must be present if CurrentFinancialAccountInformation fields are present..</param>
        /// <param name="expirationDate">New expiration date to be applied to the updated token(s). Conditional field, must not be present when IssuerProductConfigurationId is present. Optional if updating PAN mapping or PAN Sequence Number. Maximum length 4 characters..</param>
        /// <param name="accountPanSequenceNumber">New PAN sequence number to be applied to the updated token(s). Conditional field, must not be present when IssuerProductConfigurationId is present. Optional if updating PAN mapping or Expiration Date. Maximum length 3 characters..</param>
        /// <param name="issuerProductConfigurationId">New product configuration ID to be applied to the updated token(s). Conditional field, must not be present if any of the following are present - NewAccountPan, ExpirationDate, AccountPanSequenceNumber. Maximum length 10 characters..</param>
        /// <param name="updateWalletProviderIndicator">Indicates whether the updated token information should be provided to the Wallet Provider. Valid values:&lt;br /&gt;    \&quot;0\&quot; - Pass the updated information to the Wallet Provider&lt;br /&gt;    \&quot;1\&quot; - Do not pass the updated information to the Wallet Provider.&lt;br /&gt;Optional parameter. The default is 1 if not present..</param>
        /// <param name="commentText">Comment related to the updated token(s). Maximum length 500 characters..</param>
        /// <param name="reasonCode">The reason for the update. Required..</param>
        /// <param name="auditInfo">auditInfo (required).</param>
        public TokenUpdateRequest(string tokenUniqueReference = default(string), string currentAccountPan = default(string), string newAccountPan = default(string), FinancialAccountInformationSchema currentFinancialAccountInformation = default(FinancialAccountInformationSchema), string newFinancialAccountId = default(string), string expirationDate = default(string), string accountPanSequenceNumber = default(string), string issuerProductConfigurationId = default(string), string updateWalletProviderIndicator = default(string), string commentText = default(string), string reasonCode = default(string), AuditInfo auditInfo = default(AuditInfo))
        {
            // to ensure "auditInfo" is required (not null)
            if (auditInfo == null)
            {
                throw new InvalidDataException("auditInfo is a required property for TokenUpdateRequest and cannot be null");
            }
            else
            {
                this.AuditInfo = auditInfo;
            }
            this.TokenUniqueReference = tokenUniqueReference;
            this.CurrentAccountPan = currentAccountPan;
            this.NewAccountPan = newAccountPan;
            this.CurrentFinancialAccountInformation = currentFinancialAccountInformation;
            this.NewFinancialAccountId = newFinancialAccountId;
            this.ExpirationDate = expirationDate;
            this.AccountPanSequenceNumber = accountPanSequenceNumber;
            this.IssuerProductConfigurationId = issuerProductConfigurationId;
            this.UpdateWalletProviderIndicator = updateWalletProviderIndicator;
            this.CommentText = commentText;
            this.ReasonCode = reasonCode;
        }
        
        /// <summary>
        /// A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Conditional field, used for updating a single token and not used when CurrentAccountPan is present. Length 48 characters.
        /// </summary>
        /// <value>A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Conditional field, used for updating a single token and not used when CurrentAccountPan is present. Length 48 characters.</value>
        [DataMember(Name="TokenUniqueReference", EmitDefaultValue=false)]
        public string TokenUniqueReference { get; set; }

        /// <summary>
        /// Current Account PAN of the token(s) to be updated. Conditional field, used for updating all tokens mapped to a single Account PAN and must not be present when TokenUniqueReference is present. Length 9 - 19 characters.
        /// </summary>
        /// <value>Current Account PAN of the token(s) to be updated. Conditional field, used for updating all tokens mapped to a single Account PAN and must not be present when TokenUniqueReference is present. Length 9 - 19 characters.</value>
        [DataMember(Name="CurrentAccountPan", EmitDefaultValue=false)]
        public string CurrentAccountPan { get; set; }

        /// <summary>
        /// New Account PAN to be applied to the updated token(s) if there is in fact a new Account PAN. Optional if updating Expiration Date or PAN Sequence Number. Length 9 - 19 characters.
        /// </summary>
        /// <value>New Account PAN to be applied to the updated token(s) if there is in fact a new Account PAN. Optional if updating Expiration Date or PAN Sequence Number. Length 9 - 19 characters.</value>
        [DataMember(Name="NewAccountPan", EmitDefaultValue=false)]
        public string NewAccountPan { get; set; }

        /// <summary>
        /// Gets or Sets CurrentFinancialAccountInformation
        /// </summary>
        [DataMember(Name="CurrentFinancialAccountInformation", EmitDefaultValue=false)]
        public FinancialAccountInformationSchema CurrentFinancialAccountInformation { get; set; }

        /// <summary>
        /// New Financial Account Identifier to be applied to the updated token(s)  if there is in fact new Financial Account Identifier. Conditional field,  must be present if CurrentFinancialAccountInformation fields are present.
        /// </summary>
        /// <value>New Financial Account Identifier to be applied to the updated token(s)  if there is in fact new Financial Account Identifier. Conditional field,  must be present if CurrentFinancialAccountInformation fields are present.</value>
        [DataMember(Name="NewFinancialAccountId", EmitDefaultValue=false)]
        public string NewFinancialAccountId { get; set; }

        /// <summary>
        /// New expiration date to be applied to the updated token(s). Conditional field, must not be present when IssuerProductConfigurationId is present. Optional if updating PAN mapping or PAN Sequence Number. Maximum length 4 characters.
        /// </summary>
        /// <value>New expiration date to be applied to the updated token(s). Conditional field, must not be present when IssuerProductConfigurationId is present. Optional if updating PAN mapping or PAN Sequence Number. Maximum length 4 characters.</value>
        [DataMember(Name="ExpirationDate", EmitDefaultValue=false)]
        public string ExpirationDate { get; set; }

        /// <summary>
        /// New PAN sequence number to be applied to the updated token(s). Conditional field, must not be present when IssuerProductConfigurationId is present. Optional if updating PAN mapping or Expiration Date. Maximum length 3 characters.
        /// </summary>
        /// <value>New PAN sequence number to be applied to the updated token(s). Conditional field, must not be present when IssuerProductConfigurationId is present. Optional if updating PAN mapping or Expiration Date. Maximum length 3 characters.</value>
        [DataMember(Name="AccountPanSequenceNumber", EmitDefaultValue=false)]
        public string AccountPanSequenceNumber { get; set; }

        /// <summary>
        /// New product configuration ID to be applied to the updated token(s). Conditional field, must not be present if any of the following are present - NewAccountPan, ExpirationDate, AccountPanSequenceNumber. Maximum length 10 characters.
        /// </summary>
        /// <value>New product configuration ID to be applied to the updated token(s). Conditional field, must not be present if any of the following are present - NewAccountPan, ExpirationDate, AccountPanSequenceNumber. Maximum length 10 characters.</value>
        [DataMember(Name="IssuerProductConfigurationId", EmitDefaultValue=false)]
        public string IssuerProductConfigurationId { get; set; }

        /// <summary>
        /// Indicates whether the updated token information should be provided to the Wallet Provider. Valid values:&lt;br /&gt;    \&quot;0\&quot; - Pass the updated information to the Wallet Provider&lt;br /&gt;    \&quot;1\&quot; - Do not pass the updated information to the Wallet Provider.&lt;br /&gt;Optional parameter. The default is 1 if not present.
        /// </summary>
        /// <value>Indicates whether the updated token information should be provided to the Wallet Provider. Valid values:&lt;br /&gt;    \&quot;0\&quot; - Pass the updated information to the Wallet Provider&lt;br /&gt;    \&quot;1\&quot; - Do not pass the updated information to the Wallet Provider.&lt;br /&gt;Optional parameter. The default is 1 if not present.</value>
        [DataMember(Name="UpdateWalletProviderIndicator", EmitDefaultValue=false)]
        public string UpdateWalletProviderIndicator { get; set; }

        /// <summary>
        /// Comment related to the updated token(s). Maximum length 500 characters.
        /// </summary>
        /// <value>Comment related to the updated token(s). Maximum length 500 characters.</value>
        [DataMember(Name="CommentText", EmitDefaultValue=false)]
        public string CommentText { get; set; }

        /// <summary>
        /// The reason for the update. Required.
        /// </summary>
        /// <value>The reason for the update. Required.</value>
        [DataMember(Name="ReasonCode", EmitDefaultValue=false)]
        public string ReasonCode { get; set; }

        /// <summary>
        /// Gets or Sets AuditInfo
        /// </summary>
        [DataMember(Name="AuditInfo", EmitDefaultValue=false)]
        public AuditInfo AuditInfo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TokenUpdateRequest {\n");
            sb.Append("  TokenUniqueReference: ").Append(TokenUniqueReference).Append("\n");
            sb.Append("  CurrentAccountPan: ").Append(CurrentAccountPan).Append("\n");
            sb.Append("  NewAccountPan: ").Append(NewAccountPan).Append("\n");
            sb.Append("  CurrentFinancialAccountInformation: ").Append(CurrentFinancialAccountInformation).Append("\n");
            sb.Append("  NewFinancialAccountId: ").Append(NewFinancialAccountId).Append("\n");
            sb.Append("  ExpirationDate: ").Append(ExpirationDate).Append("\n");
            sb.Append("  AccountPanSequenceNumber: ").Append(AccountPanSequenceNumber).Append("\n");
            sb.Append("  IssuerProductConfigurationId: ").Append(IssuerProductConfigurationId).Append("\n");
            sb.Append("  UpdateWalletProviderIndicator: ").Append(UpdateWalletProviderIndicator).Append("\n");
            sb.Append("  CommentText: ").Append(CommentText).Append("\n");
            sb.Append("  ReasonCode: ").Append(ReasonCode).Append("\n");
            sb.Append("  AuditInfo: ").Append(AuditInfo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as TokenUpdateRequest);
        }

        /// <summary>
        /// Returns true if TokenUpdateRequest instances are equal
        /// </summary>
        /// <param name="input">Instance of TokenUpdateRequest to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TokenUpdateRequest input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.TokenUniqueReference == input.TokenUniqueReference ||
                    (this.TokenUniqueReference != null &&
                    this.TokenUniqueReference.Equals(input.TokenUniqueReference))
                ) && 
                (
                    this.CurrentAccountPan == input.CurrentAccountPan ||
                    (this.CurrentAccountPan != null &&
                    this.CurrentAccountPan.Equals(input.CurrentAccountPan))
                ) && 
                (
                    this.NewAccountPan == input.NewAccountPan ||
                    (this.NewAccountPan != null &&
                    this.NewAccountPan.Equals(input.NewAccountPan))
                ) && 
                (
                    this.CurrentFinancialAccountInformation == input.CurrentFinancialAccountInformation ||
                    (this.CurrentFinancialAccountInformation != null &&
                    this.CurrentFinancialAccountInformation.Equals(input.CurrentFinancialAccountInformation))
                ) && 
                (
                    this.NewFinancialAccountId == input.NewFinancialAccountId ||
                    (this.NewFinancialAccountId != null &&
                    this.NewFinancialAccountId.Equals(input.NewFinancialAccountId))
                ) && 
                (
                    this.ExpirationDate == input.ExpirationDate ||
                    (this.ExpirationDate != null &&
                    this.ExpirationDate.Equals(input.ExpirationDate))
                ) && 
                (
                    this.AccountPanSequenceNumber == input.AccountPanSequenceNumber ||
                    (this.AccountPanSequenceNumber != null &&
                    this.AccountPanSequenceNumber.Equals(input.AccountPanSequenceNumber))
                ) && 
                (
                    this.IssuerProductConfigurationId == input.IssuerProductConfigurationId ||
                    (this.IssuerProductConfigurationId != null &&
                    this.IssuerProductConfigurationId.Equals(input.IssuerProductConfigurationId))
                ) && 
                (
                    this.UpdateWalletProviderIndicator == input.UpdateWalletProviderIndicator ||
                    (this.UpdateWalletProviderIndicator != null &&
                    this.UpdateWalletProviderIndicator.Equals(input.UpdateWalletProviderIndicator))
                ) && 
                (
                    this.CommentText == input.CommentText ||
                    (this.CommentText != null &&
                    this.CommentText.Equals(input.CommentText))
                ) && 
                (
                    this.ReasonCode == input.ReasonCode ||
                    (this.ReasonCode != null &&
                    this.ReasonCode.Equals(input.ReasonCode))
                ) && 
                (
                    this.AuditInfo == input.AuditInfo ||
                    (this.AuditInfo != null &&
                    this.AuditInfo.Equals(input.AuditInfo))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.TokenUniqueReference != null)
                    hashCode = hashCode * 59 + this.TokenUniqueReference.GetHashCode();
                if (this.CurrentAccountPan != null)
                    hashCode = hashCode * 59 + this.CurrentAccountPan.GetHashCode();
                if (this.NewAccountPan != null)
                    hashCode = hashCode * 59 + this.NewAccountPan.GetHashCode();
                if (this.CurrentFinancialAccountInformation != null)
                    hashCode = hashCode * 59 + this.CurrentFinancialAccountInformation.GetHashCode();
                if (this.NewFinancialAccountId != null)
                    hashCode = hashCode * 59 + this.NewFinancialAccountId.GetHashCode();
                if (this.ExpirationDate != null)
                    hashCode = hashCode * 59 + this.ExpirationDate.GetHashCode();
                if (this.AccountPanSequenceNumber != null)
                    hashCode = hashCode * 59 + this.AccountPanSequenceNumber.GetHashCode();
                if (this.IssuerProductConfigurationId != null)
                    hashCode = hashCode * 59 + this.IssuerProductConfigurationId.GetHashCode();
                if (this.UpdateWalletProviderIndicator != null)
                    hashCode = hashCode * 59 + this.UpdateWalletProviderIndicator.GetHashCode();
                if (this.CommentText != null)
                    hashCode = hashCode * 59 + this.CommentText.GetHashCode();
                if (this.ReasonCode != null)
                    hashCode = hashCode * 59 + this.ReasonCode.GetHashCode();
                if (this.AuditInfo != null)
                    hashCode = hashCode * 59 + this.AuditInfo.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
