/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// TokenActivateRequest
    /// </summary>
    [DataContract]
    public partial class TokenActivateRequest :  IEquatable<TokenActivateRequest>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TokenActivateRequest" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TokenActivateRequest() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TokenActivateRequest" /> class.
        /// </summary>
        /// <param name="tokenUniqueReference">A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Length - 48 characters. Conditional field, present when AccountPan and PaymentAppInstanceId are not present..</param>
        /// <param name="accountPan">The Account PAN of the token to be activated. Conditional field, must be present when PaymentAppInstanceId is present. Must not be present when TokenUniqueReference is present. PAN will be minimum 9, maximum 19 digits..</param>
        /// <param name="paymentAppInstanceId">Identifier of the Payment App instance within a device that will be provisioned with a token. NOTE - This may contain the identifier of the Secure Element or a mobile device for some programs. Conditional field, must be present when AccountPan is present. Must not be present when TokenUniqueReference is present.  48 characters string..</param>
        /// <param name="commentText">Comment related to activating this token. Maximum length of 500..</param>
        /// <param name="reasonCode">Reason for the activation. Valid values:&lt;br /&gt;    \&quot;A\&quot; &#x3D; Cardholder successfully authenticated prior to activation.&lt;br /&gt;    \&quot;C\&quot; &#x3D; Cardholder successfully authenticated with a customer service agent prior to activation. (required).</param>
        /// <param name="auditInfo">auditInfo (required).</param>
        public TokenActivateRequest(string tokenUniqueReference = default(string), string accountPan = default(string), string paymentAppInstanceId = default(string), string commentText = default(string), string reasonCode = default(string), AuditInfo auditInfo = default(AuditInfo))
        {
            // to ensure "reasonCode" is required (not null)
            if (reasonCode == null)
            {
                throw new InvalidDataException("reasonCode is a required property for TokenActivateRequest and cannot be null");
            }
            else
            {
                this.ReasonCode = reasonCode;
            }
            // to ensure "auditInfo" is required (not null)
            if (auditInfo == null)
            {
                throw new InvalidDataException("auditInfo is a required property for TokenActivateRequest and cannot be null");
            }
            else
            {
                this.AuditInfo = auditInfo;
            }
            this.TokenUniqueReference = tokenUniqueReference;
            this.AccountPan = accountPan;
            this.PaymentAppInstanceId = paymentAppInstanceId;
            this.CommentText = commentText;
        }
        
        /// <summary>
        /// A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Length - 48 characters. Conditional field, present when AccountPan and PaymentAppInstanceId are not present.
        /// </summary>
        /// <value>A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Length - 48 characters. Conditional field, present when AccountPan and PaymentAppInstanceId are not present.</value>
        [DataMember(Name="TokenUniqueReference", EmitDefaultValue=false)]
        public string TokenUniqueReference { get; set; }

        /// <summary>
        /// The Account PAN of the token to be activated. Conditional field, must be present when PaymentAppInstanceId is present. Must not be present when TokenUniqueReference is present. PAN will be minimum 9, maximum 19 digits.
        /// </summary>
        /// <value>The Account PAN of the token to be activated. Conditional field, must be present when PaymentAppInstanceId is present. Must not be present when TokenUniqueReference is present. PAN will be minimum 9, maximum 19 digits.</value>
        [DataMember(Name="AccountPan", EmitDefaultValue=false)]
        public string AccountPan { get; set; }

        /// <summary>
        /// Identifier of the Payment App instance within a device that will be provisioned with a token. NOTE - This may contain the identifier of the Secure Element or a mobile device for some programs. Conditional field, must be present when AccountPan is present. Must not be present when TokenUniqueReference is present.  48 characters string.
        /// </summary>
        /// <value>Identifier of the Payment App instance within a device that will be provisioned with a token. NOTE - This may contain the identifier of the Secure Element or a mobile device for some programs. Conditional field, must be present when AccountPan is present. Must not be present when TokenUniqueReference is present.  48 characters string.</value>
        [DataMember(Name="PaymentAppInstanceId", EmitDefaultValue=false)]
        public string PaymentAppInstanceId { get; set; }

        /// <summary>
        /// Comment related to activating this token. Maximum length of 500.
        /// </summary>
        /// <value>Comment related to activating this token. Maximum length of 500.</value>
        [DataMember(Name="CommentText", EmitDefaultValue=false)]
        public string CommentText { get; set; }

        /// <summary>
        /// Reason for the activation. Valid values:&lt;br /&gt;    \&quot;A\&quot; &#x3D; Cardholder successfully authenticated prior to activation.&lt;br /&gt;    \&quot;C\&quot; &#x3D; Cardholder successfully authenticated with a customer service agent prior to activation.
        /// </summary>
        /// <value>Reason for the activation. Valid values:&lt;br /&gt;    \&quot;A\&quot; &#x3D; Cardholder successfully authenticated prior to activation.&lt;br /&gt;    \&quot;C\&quot; &#x3D; Cardholder successfully authenticated with a customer service agent prior to activation.</value>
        [DataMember(Name="ReasonCode", EmitDefaultValue=false)]
        public string ReasonCode { get; set; }

        /// <summary>
        /// Gets or Sets AuditInfo
        /// </summary>
        [DataMember(Name="AuditInfo", EmitDefaultValue=false)]
        public AuditInfo AuditInfo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class TokenActivateRequest {\n");
            sb.Append("  TokenUniqueReference: ").Append(TokenUniqueReference).Append("\n");
            sb.Append("  AccountPan: ").Append(AccountPan).Append("\n");
            sb.Append("  PaymentAppInstanceId: ").Append(PaymentAppInstanceId).Append("\n");
            sb.Append("  CommentText: ").Append(CommentText).Append("\n");
            sb.Append("  ReasonCode: ").Append(ReasonCode).Append("\n");
            sb.Append("  AuditInfo: ").Append(AuditInfo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as TokenActivateRequest);
        }

        /// <summary>
        /// Returns true if TokenActivateRequest instances are equal
        /// </summary>
        /// <param name="input">Instance of TokenActivateRequest to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(TokenActivateRequest input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.TokenUniqueReference == input.TokenUniqueReference ||
                    (this.TokenUniqueReference != null &&
                    this.TokenUniqueReference.Equals(input.TokenUniqueReference))
                ) && 
                (
                    this.AccountPan == input.AccountPan ||
                    (this.AccountPan != null &&
                    this.AccountPan.Equals(input.AccountPan))
                ) && 
                (
                    this.PaymentAppInstanceId == input.PaymentAppInstanceId ||
                    (this.PaymentAppInstanceId != null &&
                    this.PaymentAppInstanceId.Equals(input.PaymentAppInstanceId))
                ) && 
                (
                    this.CommentText == input.CommentText ||
                    (this.CommentText != null &&
                    this.CommentText.Equals(input.CommentText))
                ) && 
                (
                    this.ReasonCode == input.ReasonCode ||
                    (this.ReasonCode != null &&
                    this.ReasonCode.Equals(input.ReasonCode))
                ) && 
                (
                    this.AuditInfo == input.AuditInfo ||
                    (this.AuditInfo != null &&
                    this.AuditInfo.Equals(input.AuditInfo))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.TokenUniqueReference != null)
                    hashCode = hashCode * 59 + this.TokenUniqueReference.GetHashCode();
                if (this.AccountPan != null)
                    hashCode = hashCode * 59 + this.AccountPan.GetHashCode();
                if (this.PaymentAppInstanceId != null)
                    hashCode = hashCode * 59 + this.PaymentAppInstanceId.GetHashCode();
                if (this.CommentText != null)
                    hashCode = hashCode * 59 + this.CommentText.GetHashCode();
                if (this.ReasonCode != null)
                    hashCode = hashCode * 59 + this.ReasonCode.GetHashCode();
                if (this.AuditInfo != null)
                    hashCode = hashCode * 59 + this.AuditInfo.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
