/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Token
    /// </summary>
    [DataContract]
    public partial class Token :  IEquatable<Token>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Token" /> class.
        /// </summary>
        /// <param name="tokenUniqueReference">A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Conditional  field, present when successfully assigned. 48 character string..</param>
        /// <param name="primaryAccountNumberUniqueReference">Unique reference to the Account PAN originally digitized. Conditional field, present when successfully assigned..</param>
        /// <param name="tokenSuffix">Last 4 digits of token in a 4 character string. Conditional field, present once the token has been designated for the digitization..</param>
        /// <param name="expirationDate">Expiration date of token. Conditional field, present once the token has been designated for the digitization. Four digit string. Format \&quot;mmyy\&quot;..</param>
        /// <param name="accountPanSequenceNumber">The Account PAN Sequence Number associated with a specific token, as provided to MDES previously by the issuer. It may be used to distinguish between multiple cardholders for a single Account PAN, to represent an issuance number of a specific card, or to distinguish between different card products, such as debit or credit, that share the same Account PAN. Conditional field, present when successfully assigned. 3 characters in length, max. Supported values - 000 to 099..</param>
        /// <param name="activationCodeExpirationDateTime">Date and time when an Activation Code will expire. Conditional field, not present for CoF tokens, and only present when an Activation Code has been generated and activation has not yet occurred. The date and time may be in the future or past. string in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="correlationId">Value linking pre-digitization messages generated during provisioning. Conditional field, not present for CoF tokens. 14 char string..</param>
        /// <param name="currentStatusCode">Current status of the Token. Valid values:&lt;br /&gt;    \&quot;U\&quot; - Unmapped. The token has not yet been linked to the Account PAN. The process of tokenization is ‘In Progress.&#39;&lt;br /&gt;    \&quot;A\&quot; - Active. The token is linked to the Account PAN and may initiate new transactions to be authorized.&lt;br /&gt;    \&quot;S\&quot; - Suspended. The token is linked to the Account PAN but may not perform transactions at the request of one or more suspenders.&lt;br /&gt;    \&quot;D\&quot; - Deleted. The token is logically deleted but is still linked to the Account PAN for the purposes of post-authorization transaction processing..</param>
        /// <param name="currentStatusDescription">Description of the current status..</param>
        /// <param name="currentStatusDateTime">Date and time the status was updated.  string, ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="digitizationRequestDateTime">Date and time of the initial request for digitization of the Account PAN for this token. Conditional field, not present for CoF tokens. string, in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="finalTokenizationDecision">Final decision related to the digitization of the Account PAN for this token. One character string. Valid values:&lt;br /&gt;    \&quot;D\&quot; - Digitization was declined&lt;br /&gt;    \&quot;A\&quot; - Digitization was approved&lt;br /&gt;    \&quot;R\&quot; - Digitization was approved but required authentication prior to activation.&lt;br /&gt;Conditional field, not present for CoF tokens.  NOTE - this information is currently subject to archival processes and will be present for only 1 year following digitization..</param>
        /// <param name="lastCommentId">Identifier of the last comment associated with the token..</param>
        /// <param name="paymentAppInstanceId">Identifier of the Payment App instance within a device that will be provisioned with a token. NOTE - This may contain the identifier of the Secure Element or a mobile device for some programs. Optional, not present for CoF tokens, and only present when supplied by the Payment App Provider.  48 characters string..</param>
        /// <param name="provisioningStatusCode">Current provisioning status of the token. Valid values:&lt;br /&gt;    \&quot;P\&quot; - Token being prepared&lt;br /&gt;    \&quot;T\&quot; - Awaiting cardholder acceptance of Terms and Conditions&lt;br /&gt;    \&quot;D\&quot; - Token being delivered to Wallet Provider or Device&lt;br /&gt;    \&quot;A\&quot; - Awaiting Activation&lt;br /&gt;    \&quot;S\&quot; - Provisioning successful&lt;br /&gt;    \&quot;F\&quot; - Provisioning failed.&lt;br /&gt;NOTE - The order of the statuses above does not indicate any order of status transitions. Conditional field, not present for CoF tokens..</param>
        /// <param name="provisioningStatusDescription">Description of the provisioning status. Conditional field, not present for CoF tokens..</param>
        /// <param name="storageTechnology">The architecture or technology used for token storage. Valid values:&lt;br /&gt;    \&quot;D\&quot; - Device memory&lt;br /&gt;    \&quot;P\&quot; - Device memory protected by Trusted Platform Module (TPM)&lt;br /&gt;    \&quot;H\&quot; - Server&lt;br /&gt;    \&quot;E\&quot; - Trusted Execution Environment (TEE)&lt;br /&gt;    \&quot;S\&quot; - Secure Element (SE)&lt;br /&gt;    \&quot;V\&quot; - Virtual Execution Environment (VEE).</param>
        /// <param name="suspenders">suspenders.</param>
        /// <param name="tokenActivatedDateTime">Date and time that the token was activated. Conditional field, present only once the Token has been activated. string in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="tokenAssuranceLevel">Indicates the level of Identification and Verification performed to validate the Cardholder and the Cardholder&#39;s account at the time the Token was issued (or at any subsquent time post-issuance).  Only present when a token has a Token Assurance Level assigned.  Supported values are 0 (Not Authenticated) and non-zero (Authenticated)..</param>
        /// <param name="tokenRequestorId">Per EMV Co, the entity uniquely recognized by Mastercard as the Token Service Provider.  String, up to 11 characters..</param>
        /// <param name="tokenRequestorName">The legal name of the token requestor. There can be more than one Token Requestor Id per Token Requester Name (legal name). So it is important to use both parameters to uniquely identify a token requestor.  String, up to 100 characters..</param>
        /// <param name="tokenType">Type of token. Valid values:&lt;br /&gt;    \&quot;S\&quot; - Embedded Secure Element Token&lt;br /&gt;    \&quot;C\&quot; - Mastercard Cloud-Based Payments token&lt;br /&gt;    \&quot;F\&quot; - Cof token..</param>
        /// <param name="walletId">Identifier of the Wallet Provider who requested the digitization or tokenization. Conditional field, not present for CoF tokens, and only present when supplied by the Payment App Provider..</param>
        /// <param name="device">device.</param>
        /// <param name="tokenDeletedFromConsumerApp">Indicates whether or not a token has been deleted from the consumer app by the token requestor. Note - This is a \&quot;soft delete\&quot; that does not affect the actual Token Status. The token may still be active in the system. Supported values - true, false.</param>
        /// <param name="tokenRequestorConsumerFacingEntityName">The Token Service Provider name to be displayed to the consumer (consumer-facing name)..</param>
        public Token(string tokenUniqueReference = default(string), string primaryAccountNumberUniqueReference = default(string), string tokenSuffix = default(string), string expirationDate = default(string), string accountPanSequenceNumber = default(string), string activationCodeExpirationDateTime = default(string), string correlationId = default(string), string currentStatusCode = default(string), string currentStatusDescription = default(string), string currentStatusDateTime = default(string), string digitizationRequestDateTime = default(string), string finalTokenizationDecision = default(string), string lastCommentId = default(string), string paymentAppInstanceId = default(string), string provisioningStatusCode = default(string), string provisioningStatusDescription = default(string), string storageTechnology = default(string), Suspenders suspenders = default(Suspenders), string tokenActivatedDateTime = default(string), string tokenAssuranceLevel = default(string), string tokenRequestorId = default(string), string tokenRequestorName = default(string), string tokenType = default(string), string walletId = default(string), Device device = default(Device), string tokenDeletedFromConsumerApp = default(string), string tokenRequestorConsumerFacingEntityName = default(string))
        {
            this.TokenUniqueReference = tokenUniqueReference;
            this.PrimaryAccountNumberUniqueReference = primaryAccountNumberUniqueReference;
            this.TokenSuffix = tokenSuffix;
            this.ExpirationDate = expirationDate;
            this.AccountPanSequenceNumber = accountPanSequenceNumber;
            this.ActivationCodeExpirationDateTime = activationCodeExpirationDateTime;
            this.CorrelationId = correlationId;
            this.CurrentStatusCode = currentStatusCode;
            this.CurrentStatusDescription = currentStatusDescription;
            this.CurrentStatusDateTime = currentStatusDateTime;
            this.DigitizationRequestDateTime = digitizationRequestDateTime;
            this.FinalTokenizationDecision = finalTokenizationDecision;
            this.LastCommentId = lastCommentId;
            this.PaymentAppInstanceId = paymentAppInstanceId;
            this.ProvisioningStatusCode = provisioningStatusCode;
            this.ProvisioningStatusDescription = provisioningStatusDescription;
            this.StorageTechnology = storageTechnology;
            this.Suspenders = suspenders;
            this.TokenActivatedDateTime = tokenActivatedDateTime;
            this.TokenAssuranceLevel = tokenAssuranceLevel;
            this.TokenRequestorId = tokenRequestorId;
            this.TokenRequestorName = tokenRequestorName;
            this.TokenType = tokenType;
            this.WalletId = walletId;
            this.Device = device;
            this.TokenDeletedFromConsumerApp = tokenDeletedFromConsumerApp;
            this.TokenRequestorConsumerFacingEntityName = tokenRequestorConsumerFacingEntityName;
        }
        
        /// <summary>
        /// A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Conditional  field, present when successfully assigned. 48 character string.
        /// </summary>
        /// <value>A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. Conditional  field, present when successfully assigned. 48 character string.</value>
        [DataMember(Name="TokenUniqueReference", EmitDefaultValue=false)]
        public string TokenUniqueReference { get; set; }

        /// <summary>
        /// Unique reference to the Account PAN originally digitized. Conditional field, present when successfully assigned.
        /// </summary>
        /// <value>Unique reference to the Account PAN originally digitized. Conditional field, present when successfully assigned.</value>
        [DataMember(Name="PrimaryAccountNumberUniqueReference", EmitDefaultValue=false)]
        public string PrimaryAccountNumberUniqueReference { get; set; }

        /// <summary>
        /// Last 4 digits of token in a 4 character string. Conditional field, present once the token has been designated for the digitization.
        /// </summary>
        /// <value>Last 4 digits of token in a 4 character string. Conditional field, present once the token has been designated for the digitization.</value>
        [DataMember(Name="TokenSuffix", EmitDefaultValue=false)]
        public string TokenSuffix { get; set; }

        /// <summary>
        /// Expiration date of token. Conditional field, present once the token has been designated for the digitization. Four digit string. Format \&quot;mmyy\&quot;.
        /// </summary>
        /// <value>Expiration date of token. Conditional field, present once the token has been designated for the digitization. Four digit string. Format \&quot;mmyy\&quot;.</value>
        [DataMember(Name="ExpirationDate", EmitDefaultValue=false)]
        public string ExpirationDate { get; set; }

        /// <summary>
        /// The Account PAN Sequence Number associated with a specific token, as provided to MDES previously by the issuer. It may be used to distinguish between multiple cardholders for a single Account PAN, to represent an issuance number of a specific card, or to distinguish between different card products, such as debit or credit, that share the same Account PAN. Conditional field, present when successfully assigned. 3 characters in length, max. Supported values - 000 to 099.
        /// </summary>
        /// <value>The Account PAN Sequence Number associated with a specific token, as provided to MDES previously by the issuer. It may be used to distinguish between multiple cardholders for a single Account PAN, to represent an issuance number of a specific card, or to distinguish between different card products, such as debit or credit, that share the same Account PAN. Conditional field, present when successfully assigned. 3 characters in length, max. Supported values - 000 to 099.</value>
        [DataMember(Name="AccountPanSequenceNumber", EmitDefaultValue=false)]
        public string AccountPanSequenceNumber { get; set; }

        /// <summary>
        /// Date and time when an Activation Code will expire. Conditional field, not present for CoF tokens, and only present when an Activation Code has been generated and activation has not yet occurred. The date and time may be in the future or past. string in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time when an Activation Code will expire. Conditional field, not present for CoF tokens, and only present when an Activation Code has been generated and activation has not yet occurred. The date and time may be in the future or past. string in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="ActivationCodeExpirationDateTime", EmitDefaultValue=false)]
        public string ActivationCodeExpirationDateTime { get; set; }

        /// <summary>
        /// Value linking pre-digitization messages generated during provisioning. Conditional field, not present for CoF tokens. 14 char string.
        /// </summary>
        /// <value>Value linking pre-digitization messages generated during provisioning. Conditional field, not present for CoF tokens. 14 char string.</value>
        [DataMember(Name="CorrelationId", EmitDefaultValue=false)]
        public string CorrelationId { get; set; }

        /// <summary>
        /// Current status of the Token. Valid values:&lt;br /&gt;    \&quot;U\&quot; - Unmapped. The token has not yet been linked to the Account PAN. The process of tokenization is ‘In Progress.&#39;&lt;br /&gt;    \&quot;A\&quot; - Active. The token is linked to the Account PAN and may initiate new transactions to be authorized.&lt;br /&gt;    \&quot;S\&quot; - Suspended. The token is linked to the Account PAN but may not perform transactions at the request of one or more suspenders.&lt;br /&gt;    \&quot;D\&quot; - Deleted. The token is logically deleted but is still linked to the Account PAN for the purposes of post-authorization transaction processing.
        /// </summary>
        /// <value>Current status of the Token. Valid values:&lt;br /&gt;    \&quot;U\&quot; - Unmapped. The token has not yet been linked to the Account PAN. The process of tokenization is ‘In Progress.&#39;&lt;br /&gt;    \&quot;A\&quot; - Active. The token is linked to the Account PAN and may initiate new transactions to be authorized.&lt;br /&gt;    \&quot;S\&quot; - Suspended. The token is linked to the Account PAN but may not perform transactions at the request of one or more suspenders.&lt;br /&gt;    \&quot;D\&quot; - Deleted. The token is logically deleted but is still linked to the Account PAN for the purposes of post-authorization transaction processing.</value>
        [DataMember(Name="CurrentStatusCode", EmitDefaultValue=false)]
        public string CurrentStatusCode { get; set; }

        /// <summary>
        /// Description of the current status.
        /// </summary>
        /// <value>Description of the current status.</value>
        [DataMember(Name="CurrentStatusDescription", EmitDefaultValue=false)]
        public string CurrentStatusDescription { get; set; }

        /// <summary>
        /// Date and time the status was updated.  string, ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time the status was updated.  string, ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="CurrentStatusDateTime", EmitDefaultValue=false)]
        public string CurrentStatusDateTime { get; set; }

        /// <summary>
        /// Date and time of the initial request for digitization of the Account PAN for this token. Conditional field, not present for CoF tokens. string, in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time of the initial request for digitization of the Account PAN for this token. Conditional field, not present for CoF tokens. string, in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="DigitizationRequestDateTime", EmitDefaultValue=false)]
        public string DigitizationRequestDateTime { get; set; }

        /// <summary>
        /// Final decision related to the digitization of the Account PAN for this token. One character string. Valid values:&lt;br /&gt;    \&quot;D\&quot; - Digitization was declined&lt;br /&gt;    \&quot;A\&quot; - Digitization was approved&lt;br /&gt;    \&quot;R\&quot; - Digitization was approved but required authentication prior to activation.&lt;br /&gt;Conditional field, not present for CoF tokens.  NOTE - this information is currently subject to archival processes and will be present for only 1 year following digitization.
        /// </summary>
        /// <value>Final decision related to the digitization of the Account PAN for this token. One character string. Valid values:&lt;br /&gt;    \&quot;D\&quot; - Digitization was declined&lt;br /&gt;    \&quot;A\&quot; - Digitization was approved&lt;br /&gt;    \&quot;R\&quot; - Digitization was approved but required authentication prior to activation.&lt;br /&gt;Conditional field, not present for CoF tokens.  NOTE - this information is currently subject to archival processes and will be present for only 1 year following digitization.</value>
        [DataMember(Name="FinalTokenizationDecision", EmitDefaultValue=false)]
        public string FinalTokenizationDecision { get; set; }

        /// <summary>
        /// Identifier of the last comment associated with the token.
        /// </summary>
        /// <value>Identifier of the last comment associated with the token.</value>
        [DataMember(Name="LastCommentId", EmitDefaultValue=false)]
        public string LastCommentId { get; set; }

        /// <summary>
        /// Identifier of the Payment App instance within a device that will be provisioned with a token. NOTE - This may contain the identifier of the Secure Element or a mobile device for some programs. Optional, not present for CoF tokens, and only present when supplied by the Payment App Provider.  48 characters string.
        /// </summary>
        /// <value>Identifier of the Payment App instance within a device that will be provisioned with a token. NOTE - This may contain the identifier of the Secure Element or a mobile device for some programs. Optional, not present for CoF tokens, and only present when supplied by the Payment App Provider.  48 characters string.</value>
        [DataMember(Name="PaymentAppInstanceId", EmitDefaultValue=false)]
        public string PaymentAppInstanceId { get; set; }

        /// <summary>
        /// Current provisioning status of the token. Valid values:&lt;br /&gt;    \&quot;P\&quot; - Token being prepared&lt;br /&gt;    \&quot;T\&quot; - Awaiting cardholder acceptance of Terms and Conditions&lt;br /&gt;    \&quot;D\&quot; - Token being delivered to Wallet Provider or Device&lt;br /&gt;    \&quot;A\&quot; - Awaiting Activation&lt;br /&gt;    \&quot;S\&quot; - Provisioning successful&lt;br /&gt;    \&quot;F\&quot; - Provisioning failed.&lt;br /&gt;NOTE - The order of the statuses above does not indicate any order of status transitions. Conditional field, not present for CoF tokens.
        /// </summary>
        /// <value>Current provisioning status of the token. Valid values:&lt;br /&gt;    \&quot;P\&quot; - Token being prepared&lt;br /&gt;    \&quot;T\&quot; - Awaiting cardholder acceptance of Terms and Conditions&lt;br /&gt;    \&quot;D\&quot; - Token being delivered to Wallet Provider or Device&lt;br /&gt;    \&quot;A\&quot; - Awaiting Activation&lt;br /&gt;    \&quot;S\&quot; - Provisioning successful&lt;br /&gt;    \&quot;F\&quot; - Provisioning failed.&lt;br /&gt;NOTE - The order of the statuses above does not indicate any order of status transitions. Conditional field, not present for CoF tokens.</value>
        [DataMember(Name="ProvisioningStatusCode", EmitDefaultValue=false)]
        public string ProvisioningStatusCode { get; set; }

        /// <summary>
        /// Description of the provisioning status. Conditional field, not present for CoF tokens.
        /// </summary>
        /// <value>Description of the provisioning status. Conditional field, not present for CoF tokens.</value>
        [DataMember(Name="ProvisioningStatusDescription", EmitDefaultValue=false)]
        public string ProvisioningStatusDescription { get; set; }

        /// <summary>
        /// The architecture or technology used for token storage. Valid values:&lt;br /&gt;    \&quot;D\&quot; - Device memory&lt;br /&gt;    \&quot;P\&quot; - Device memory protected by Trusted Platform Module (TPM)&lt;br /&gt;    \&quot;H\&quot; - Server&lt;br /&gt;    \&quot;E\&quot; - Trusted Execution Environment (TEE)&lt;br /&gt;    \&quot;S\&quot; - Secure Element (SE)&lt;br /&gt;    \&quot;V\&quot; - Virtual Execution Environment (VEE)
        /// </summary>
        /// <value>The architecture or technology used for token storage. Valid values:&lt;br /&gt;    \&quot;D\&quot; - Device memory&lt;br /&gt;    \&quot;P\&quot; - Device memory protected by Trusted Platform Module (TPM)&lt;br /&gt;    \&quot;H\&quot; - Server&lt;br /&gt;    \&quot;E\&quot; - Trusted Execution Environment (TEE)&lt;br /&gt;    \&quot;S\&quot; - Secure Element (SE)&lt;br /&gt;    \&quot;V\&quot; - Virtual Execution Environment (VEE)</value>
        [DataMember(Name="StorageTechnology", EmitDefaultValue=false)]
        public string StorageTechnology { get; set; }

        /// <summary>
        /// Gets or Sets Suspenders
        /// </summary>
        [DataMember(Name="Suspenders", EmitDefaultValue=false)]
        public Suspenders Suspenders { get; set; }

        /// <summary>
        /// Date and time that the token was activated. Conditional field, present only once the Token has been activated. string in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time that the token was activated. Conditional field, present only once the Token has been activated. string in ISO 8601 format – YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="TokenActivatedDateTime", EmitDefaultValue=false)]
        public string TokenActivatedDateTime { get; set; }

        /// <summary>
        /// Indicates the level of Identification and Verification performed to validate the Cardholder and the Cardholder&#39;s account at the time the Token was issued (or at any subsquent time post-issuance).  Only present when a token has a Token Assurance Level assigned.  Supported values are 0 (Not Authenticated) and non-zero (Authenticated).
        /// </summary>
        /// <value>Indicates the level of Identification and Verification performed to validate the Cardholder and the Cardholder&#39;s account at the time the Token was issued (or at any subsquent time post-issuance).  Only present when a token has a Token Assurance Level assigned.  Supported values are 0 (Not Authenticated) and non-zero (Authenticated).</value>
        [DataMember(Name="TokenAssuranceLevel", EmitDefaultValue=false)]
        public string TokenAssuranceLevel { get; set; }

        /// <summary>
        /// Per EMV Co, the entity uniquely recognized by Mastercard as the Token Service Provider.  String, up to 11 characters.
        /// </summary>
        /// <value>Per EMV Co, the entity uniquely recognized by Mastercard as the Token Service Provider.  String, up to 11 characters.</value>
        [DataMember(Name="TokenRequestorId", EmitDefaultValue=false)]
        public string TokenRequestorId { get; set; }

        /// <summary>
        /// The legal name of the token requestor. There can be more than one Token Requestor Id per Token Requester Name (legal name). So it is important to use both parameters to uniquely identify a token requestor.  String, up to 100 characters.
        /// </summary>
        /// <value>The legal name of the token requestor. There can be more than one Token Requestor Id per Token Requester Name (legal name). So it is important to use both parameters to uniquely identify a token requestor.  String, up to 100 characters.</value>
        [DataMember(Name="TokenRequestorName", EmitDefaultValue=false)]
        public string TokenRequestorName { get; set; }

        /// <summary>
        /// Type of token. Valid values:&lt;br /&gt;    \&quot;S\&quot; - Embedded Secure Element Token&lt;br /&gt;    \&quot;C\&quot; - Mastercard Cloud-Based Payments token&lt;br /&gt;    \&quot;F\&quot; - Cof token.
        /// </summary>
        /// <value>Type of token. Valid values:&lt;br /&gt;    \&quot;S\&quot; - Embedded Secure Element Token&lt;br /&gt;    \&quot;C\&quot; - Mastercard Cloud-Based Payments token&lt;br /&gt;    \&quot;F\&quot; - Cof token.</value>
        [DataMember(Name="TokenType", EmitDefaultValue=false)]
        public string TokenType { get; set; }

        /// <summary>
        /// Identifier of the Wallet Provider who requested the digitization or tokenization. Conditional field, not present for CoF tokens, and only present when supplied by the Payment App Provider.
        /// </summary>
        /// <value>Identifier of the Wallet Provider who requested the digitization or tokenization. Conditional field, not present for CoF tokens, and only present when supplied by the Payment App Provider.</value>
        [DataMember(Name="WalletId", EmitDefaultValue=false)]
        public string WalletId { get; set; }

        /// <summary>
        /// Gets or Sets Device
        /// </summary>
        [DataMember(Name="Device", EmitDefaultValue=false)]
        public Device Device { get; set; }

        /// <summary>
        /// Indicates whether or not a token has been deleted from the consumer app by the token requestor. Note - This is a \&quot;soft delete\&quot; that does not affect the actual Token Status. The token may still be active in the system. Supported values - true, false
        /// </summary>
        /// <value>Indicates whether or not a token has been deleted from the consumer app by the token requestor. Note - This is a \&quot;soft delete\&quot; that does not affect the actual Token Status. The token may still be active in the system. Supported values - true, false</value>
        [DataMember(Name="TokenDeletedFromConsumerApp", EmitDefaultValue=false)]
        public string TokenDeletedFromConsumerApp { get; set; }

        /// <summary>
        /// The Token Service Provider name to be displayed to the consumer (consumer-facing name).
        /// </summary>
        /// <value>The Token Service Provider name to be displayed to the consumer (consumer-facing name).</value>
        [DataMember(Name="TokenRequestorConsumerFacingEntityName", EmitDefaultValue=false)]
        public string TokenRequestorConsumerFacingEntityName { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Token {\n");
            sb.Append("  TokenUniqueReference: ").Append(TokenUniqueReference).Append("\n");
            sb.Append("  PrimaryAccountNumberUniqueReference: ").Append(PrimaryAccountNumberUniqueReference).Append("\n");
            sb.Append("  TokenSuffix: ").Append(TokenSuffix).Append("\n");
            sb.Append("  ExpirationDate: ").Append(ExpirationDate).Append("\n");
            sb.Append("  AccountPanSequenceNumber: ").Append(AccountPanSequenceNumber).Append("\n");
            sb.Append("  ActivationCodeExpirationDateTime: ").Append(ActivationCodeExpirationDateTime).Append("\n");
            sb.Append("  CorrelationId: ").Append(CorrelationId).Append("\n");
            sb.Append("  CurrentStatusCode: ").Append(CurrentStatusCode).Append("\n");
            sb.Append("  CurrentStatusDescription: ").Append(CurrentStatusDescription).Append("\n");
            sb.Append("  CurrentStatusDateTime: ").Append(CurrentStatusDateTime).Append("\n");
            sb.Append("  DigitizationRequestDateTime: ").Append(DigitizationRequestDateTime).Append("\n");
            sb.Append("  FinalTokenizationDecision: ").Append(FinalTokenizationDecision).Append("\n");
            sb.Append("  LastCommentId: ").Append(LastCommentId).Append("\n");
            sb.Append("  PaymentAppInstanceId: ").Append(PaymentAppInstanceId).Append("\n");
            sb.Append("  ProvisioningStatusCode: ").Append(ProvisioningStatusCode).Append("\n");
            sb.Append("  ProvisioningStatusDescription: ").Append(ProvisioningStatusDescription).Append("\n");
            sb.Append("  StorageTechnology: ").Append(StorageTechnology).Append("\n");
            sb.Append("  Suspenders: ").Append(Suspenders).Append("\n");
            sb.Append("  TokenActivatedDateTime: ").Append(TokenActivatedDateTime).Append("\n");
            sb.Append("  TokenAssuranceLevel: ").Append(TokenAssuranceLevel).Append("\n");
            sb.Append("  TokenRequestorId: ").Append(TokenRequestorId).Append("\n");
            sb.Append("  TokenRequestorName: ").Append(TokenRequestorName).Append("\n");
            sb.Append("  TokenType: ").Append(TokenType).Append("\n");
            sb.Append("  WalletId: ").Append(WalletId).Append("\n");
            sb.Append("  Device: ").Append(Device).Append("\n");
            sb.Append("  TokenDeletedFromConsumerApp: ").Append(TokenDeletedFromConsumerApp).Append("\n");
            sb.Append("  TokenRequestorConsumerFacingEntityName: ").Append(TokenRequestorConsumerFacingEntityName).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Token);
        }

        /// <summary>
        /// Returns true if Token instances are equal
        /// </summary>
        /// <param name="input">Instance of Token to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Token input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.TokenUniqueReference == input.TokenUniqueReference ||
                    (this.TokenUniqueReference != null &&
                    this.TokenUniqueReference.Equals(input.TokenUniqueReference))
                ) && 
                (
                    this.PrimaryAccountNumberUniqueReference == input.PrimaryAccountNumberUniqueReference ||
                    (this.PrimaryAccountNumberUniqueReference != null &&
                    this.PrimaryAccountNumberUniqueReference.Equals(input.PrimaryAccountNumberUniqueReference))
                ) && 
                (
                    this.TokenSuffix == input.TokenSuffix ||
                    (this.TokenSuffix != null &&
                    this.TokenSuffix.Equals(input.TokenSuffix))
                ) && 
                (
                    this.ExpirationDate == input.ExpirationDate ||
                    (this.ExpirationDate != null &&
                    this.ExpirationDate.Equals(input.ExpirationDate))
                ) && 
                (
                    this.AccountPanSequenceNumber == input.AccountPanSequenceNumber ||
                    (this.AccountPanSequenceNumber != null &&
                    this.AccountPanSequenceNumber.Equals(input.AccountPanSequenceNumber))
                ) && 
                (
                    this.ActivationCodeExpirationDateTime == input.ActivationCodeExpirationDateTime ||
                    (this.ActivationCodeExpirationDateTime != null &&
                    this.ActivationCodeExpirationDateTime.Equals(input.ActivationCodeExpirationDateTime))
                ) && 
                (
                    this.CorrelationId == input.CorrelationId ||
                    (this.CorrelationId != null &&
                    this.CorrelationId.Equals(input.CorrelationId))
                ) && 
                (
                    this.CurrentStatusCode == input.CurrentStatusCode ||
                    (this.CurrentStatusCode != null &&
                    this.CurrentStatusCode.Equals(input.CurrentStatusCode))
                ) && 
                (
                    this.CurrentStatusDescription == input.CurrentStatusDescription ||
                    (this.CurrentStatusDescription != null &&
                    this.CurrentStatusDescription.Equals(input.CurrentStatusDescription))
                ) && 
                (
                    this.CurrentStatusDateTime == input.CurrentStatusDateTime ||
                    (this.CurrentStatusDateTime != null &&
                    this.CurrentStatusDateTime.Equals(input.CurrentStatusDateTime))
                ) && 
                (
                    this.DigitizationRequestDateTime == input.DigitizationRequestDateTime ||
                    (this.DigitizationRequestDateTime != null &&
                    this.DigitizationRequestDateTime.Equals(input.DigitizationRequestDateTime))
                ) && 
                (
                    this.FinalTokenizationDecision == input.FinalTokenizationDecision ||
                    (this.FinalTokenizationDecision != null &&
                    this.FinalTokenizationDecision.Equals(input.FinalTokenizationDecision))
                ) && 
                (
                    this.LastCommentId == input.LastCommentId ||
                    (this.LastCommentId != null &&
                    this.LastCommentId.Equals(input.LastCommentId))
                ) && 
                (
                    this.PaymentAppInstanceId == input.PaymentAppInstanceId ||
                    (this.PaymentAppInstanceId != null &&
                    this.PaymentAppInstanceId.Equals(input.PaymentAppInstanceId))
                ) && 
                (
                    this.ProvisioningStatusCode == input.ProvisioningStatusCode ||
                    (this.ProvisioningStatusCode != null &&
                    this.ProvisioningStatusCode.Equals(input.ProvisioningStatusCode))
                ) && 
                (
                    this.ProvisioningStatusDescription == input.ProvisioningStatusDescription ||
                    (this.ProvisioningStatusDescription != null &&
                    this.ProvisioningStatusDescription.Equals(input.ProvisioningStatusDescription))
                ) && 
                (
                    this.StorageTechnology == input.StorageTechnology ||
                    (this.StorageTechnology != null &&
                    this.StorageTechnology.Equals(input.StorageTechnology))
                ) && 
                (
                    this.Suspenders == input.Suspenders ||
                    (this.Suspenders != null &&
                    this.Suspenders.Equals(input.Suspenders))
                ) && 
                (
                    this.TokenActivatedDateTime == input.TokenActivatedDateTime ||
                    (this.TokenActivatedDateTime != null &&
                    this.TokenActivatedDateTime.Equals(input.TokenActivatedDateTime))
                ) && 
                (
                    this.TokenAssuranceLevel == input.TokenAssuranceLevel ||
                    (this.TokenAssuranceLevel != null &&
                    this.TokenAssuranceLevel.Equals(input.TokenAssuranceLevel))
                ) && 
                (
                    this.TokenRequestorId == input.TokenRequestorId ||
                    (this.TokenRequestorId != null &&
                    this.TokenRequestorId.Equals(input.TokenRequestorId))
                ) && 
                (
                    this.TokenRequestorName == input.TokenRequestorName ||
                    (this.TokenRequestorName != null &&
                    this.TokenRequestorName.Equals(input.TokenRequestorName))
                ) && 
                (
                    this.TokenType == input.TokenType ||
                    (this.TokenType != null &&
                    this.TokenType.Equals(input.TokenType))
                ) && 
                (
                    this.WalletId == input.WalletId ||
                    (this.WalletId != null &&
                    this.WalletId.Equals(input.WalletId))
                ) && 
                (
                    this.Device == input.Device ||
                    (this.Device != null &&
                    this.Device.Equals(input.Device))
                ) && 
                (
                    this.TokenDeletedFromConsumerApp == input.TokenDeletedFromConsumerApp ||
                    (this.TokenDeletedFromConsumerApp != null &&
                    this.TokenDeletedFromConsumerApp.Equals(input.TokenDeletedFromConsumerApp))
                ) && 
                (
                    this.TokenRequestorConsumerFacingEntityName == input.TokenRequestorConsumerFacingEntityName ||
                    (this.TokenRequestorConsumerFacingEntityName != null &&
                    this.TokenRequestorConsumerFacingEntityName.Equals(input.TokenRequestorConsumerFacingEntityName))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.TokenUniqueReference != null)
                    hashCode = hashCode * 59 + this.TokenUniqueReference.GetHashCode();
                if (this.PrimaryAccountNumberUniqueReference != null)
                    hashCode = hashCode * 59 + this.PrimaryAccountNumberUniqueReference.GetHashCode();
                if (this.TokenSuffix != null)
                    hashCode = hashCode * 59 + this.TokenSuffix.GetHashCode();
                if (this.ExpirationDate != null)
                    hashCode = hashCode * 59 + this.ExpirationDate.GetHashCode();
                if (this.AccountPanSequenceNumber != null)
                    hashCode = hashCode * 59 + this.AccountPanSequenceNumber.GetHashCode();
                if (this.ActivationCodeExpirationDateTime != null)
                    hashCode = hashCode * 59 + this.ActivationCodeExpirationDateTime.GetHashCode();
                if (this.CorrelationId != null)
                    hashCode = hashCode * 59 + this.CorrelationId.GetHashCode();
                if (this.CurrentStatusCode != null)
                    hashCode = hashCode * 59 + this.CurrentStatusCode.GetHashCode();
                if (this.CurrentStatusDescription != null)
                    hashCode = hashCode * 59 + this.CurrentStatusDescription.GetHashCode();
                if (this.CurrentStatusDateTime != null)
                    hashCode = hashCode * 59 + this.CurrentStatusDateTime.GetHashCode();
                if (this.DigitizationRequestDateTime != null)
                    hashCode = hashCode * 59 + this.DigitizationRequestDateTime.GetHashCode();
                if (this.FinalTokenizationDecision != null)
                    hashCode = hashCode * 59 + this.FinalTokenizationDecision.GetHashCode();
                if (this.LastCommentId != null)
                    hashCode = hashCode * 59 + this.LastCommentId.GetHashCode();
                if (this.PaymentAppInstanceId != null)
                    hashCode = hashCode * 59 + this.PaymentAppInstanceId.GetHashCode();
                if (this.ProvisioningStatusCode != null)
                    hashCode = hashCode * 59 + this.ProvisioningStatusCode.GetHashCode();
                if (this.ProvisioningStatusDescription != null)
                    hashCode = hashCode * 59 + this.ProvisioningStatusDescription.GetHashCode();
                if (this.StorageTechnology != null)
                    hashCode = hashCode * 59 + this.StorageTechnology.GetHashCode();
                if (this.Suspenders != null)
                    hashCode = hashCode * 59 + this.Suspenders.GetHashCode();
                if (this.TokenActivatedDateTime != null)
                    hashCode = hashCode * 59 + this.TokenActivatedDateTime.GetHashCode();
                if (this.TokenAssuranceLevel != null)
                    hashCode = hashCode * 59 + this.TokenAssuranceLevel.GetHashCode();
                if (this.TokenRequestorId != null)
                    hashCode = hashCode * 59 + this.TokenRequestorId.GetHashCode();
                if (this.TokenRequestorName != null)
                    hashCode = hashCode * 59 + this.TokenRequestorName.GetHashCode();
                if (this.TokenType != null)
                    hashCode = hashCode * 59 + this.TokenType.GetHashCode();
                if (this.WalletId != null)
                    hashCode = hashCode * 59 + this.WalletId.GetHashCode();
                if (this.Device != null)
                    hashCode = hashCode * 59 + this.Device.GetHashCode();
                if (this.TokenDeletedFromConsumerApp != null)
                    hashCode = hashCode * 59 + this.TokenDeletedFromConsumerApp.GetHashCode();
                if (this.TokenRequestorConsumerFacingEntityName != null)
                    hashCode = hashCode * 59 + this.TokenRequestorConsumerFacingEntityName.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
