/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// SystemStatusResponse
    /// </summary>
    [DataContract]
    public partial class SystemStatusResponse :  IEquatable<SystemStatusResponse>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SystemStatusResponse" /> class.
        /// </summary>
        /// <param name="commentText">Comment regarding the status of the system..</param>
        /// <param name="lastStatusDateTime">Date and time the status of the system was last updated. Format - YYYY-MM-DDThh:mm:ssTZD ..</param>
        public SystemStatusResponse(string commentText = default(string), string lastStatusDateTime = default(string))
        {
            this.CommentText = commentText;
            this.LastStatusDateTime = lastStatusDateTime;
        }
        
        /// <summary>
        /// Comment regarding the status of the system.
        /// </summary>
        /// <value>Comment regarding the status of the system.</value>
        [DataMember(Name="CommentText", EmitDefaultValue=false)]
        public string CommentText { get; set; }

        /// <summary>
        /// Date and time the status of the system was last updated. Format - YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time the status of the system was last updated. Format - YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="LastStatusDateTime", EmitDefaultValue=false)]
        public string LastStatusDateTime { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class SystemStatusResponse {\n");
            sb.Append("  CommentText: ").Append(CommentText).Append("\n");
            sb.Append("  LastStatusDateTime: ").Append(LastStatusDateTime).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as SystemStatusResponse);
        }

        /// <summary>
        /// Returns true if SystemStatusResponse instances are equal
        /// </summary>
        /// <param name="input">Instance of SystemStatusResponse to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(SystemStatusResponse input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.CommentText == input.CommentText ||
                    (this.CommentText != null &&
                    this.CommentText.Equals(input.CommentText))
                ) && 
                (
                    this.LastStatusDateTime == input.LastStatusDateTime ||
                    (this.LastStatusDateTime != null &&
                    this.LastStatusDateTime.Equals(input.LastStatusDateTime))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.CommentText != null)
                    hashCode = hashCode * 59 + this.CommentText.GetHashCode();
                if (this.LastStatusDateTime != null)
                    hashCode = hashCode * 59 + this.LastStatusDateTime.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
