/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Status
    /// </summary>
    [DataContract]
    public partial class Status :  IEquatable<Status>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Status" /> class.
        /// </summary>
        /// <param name="statusCode">The status of the Token. Valid values:&lt;br /&gt;    \&quot;U\&quot; - Unmapped. The token has not yet been linked to the Account PAN. The process of tokenization is ‘In Progress’.&lt;br /&gt;    \&quot;A\&quot; - Active. The token is linked to the Account PAN and may initiate new transactions to be authorized.&lt;br /&gt;    \&quot;S\&quot; - Suspended. The token is linked to the Account PAN but may not perform transactions at the request of one or more suspenders.&lt;br /&gt;    \&quot;D\&quot; - Deleted. The token is logically deleted but is still linked to the Account PAN for the purposes of post-authorization transaction processing..</param>
        /// <param name="statusDescription">Description of the current status..</param>
        /// <param name="statusDateTime">Date and time the status was updated. String, ISO 8691 format - YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="initiator">Party that initiated the status update. Valid values:&lt;br /&gt;    \&quot;I\&quot; - Issuer.&lt;br /&gt;    \&quot;W\&quot; - Token Requestor (including Wallet Provider).&lt;br /&gt;    \&quot;C\&quot; - Cardholder.&lt;br /&gt;    \&quot;P\&quot; - Mobile PIN Validation service.&lt;br /&gt;    \&quot;M\&quot; - Mobile PIN Change Validation service..</param>
        /// <param name="commentId">Identifier of the comment added.  Conditional field, only present when comment text was provided in the request..</param>
        /// <param name="reasonCode">Reason for the status update.  Valid values:&lt;br /&gt;    \&quot;A\&quot; – Cardholder successfully authenticated using a mobile App prior to activation.&lt;br /&gt;    \&quot;C\&quot; – Cardholder successfully authenticated with a customer service agent prior to activation. (For &#39;Token Activate&#39;).&lt;br /&gt;    \&quot;C\&quot; – Account closed. (For &#39;Token Delete&#39;).&lt;br /&gt;    \&quot;F\&quot; – Cardholder reported token device found or not stolen.&lt;br /&gt;    \&quot;L\&quot; – Cardholder reported/confirmed token device lost.&lt;br /&gt;    \&quot;S\&quot; – Cardholder reported/confirmed token device stolen.&lt;br /&gt;    \&quot;T\&quot; – Issuer or cardholder reported fraudulent/then confirmed no fraudulent token transactions.&lt;br /&gt;    \&quot;Z\&quot; – Other..</param>
        /// <param name="auditInfo">auditInfo.</param>
        public Status(string statusCode = default(string), string statusDescription = default(string), string statusDateTime = default(string), string initiator = default(string), string commentId = default(string), string reasonCode = default(string), AuditInfo auditInfo = default(AuditInfo))
        {
            this.StatusCode = statusCode;
            this.StatusDescription = statusDescription;
            this.StatusDateTime = statusDateTime;
            this.Initiator = initiator;
            this.CommentId = commentId;
            this.ReasonCode = reasonCode;
            this.AuditInfo = auditInfo;
        }
        
        /// <summary>
        /// The status of the Token. Valid values:&lt;br /&gt;    \&quot;U\&quot; - Unmapped. The token has not yet been linked to the Account PAN. The process of tokenization is ‘In Progress’.&lt;br /&gt;    \&quot;A\&quot; - Active. The token is linked to the Account PAN and may initiate new transactions to be authorized.&lt;br /&gt;    \&quot;S\&quot; - Suspended. The token is linked to the Account PAN but may not perform transactions at the request of one or more suspenders.&lt;br /&gt;    \&quot;D\&quot; - Deleted. The token is logically deleted but is still linked to the Account PAN for the purposes of post-authorization transaction processing.
        /// </summary>
        /// <value>The status of the Token. Valid values:&lt;br /&gt;    \&quot;U\&quot; - Unmapped. The token has not yet been linked to the Account PAN. The process of tokenization is ‘In Progress’.&lt;br /&gt;    \&quot;A\&quot; - Active. The token is linked to the Account PAN and may initiate new transactions to be authorized.&lt;br /&gt;    \&quot;S\&quot; - Suspended. The token is linked to the Account PAN but may not perform transactions at the request of one or more suspenders.&lt;br /&gt;    \&quot;D\&quot; - Deleted. The token is logically deleted but is still linked to the Account PAN for the purposes of post-authorization transaction processing.</value>
        [DataMember(Name="StatusCode", EmitDefaultValue=false)]
        public string StatusCode { get; set; }

        /// <summary>
        /// Description of the current status.
        /// </summary>
        /// <value>Description of the current status.</value>
        [DataMember(Name="StatusDescription", EmitDefaultValue=false)]
        public string StatusDescription { get; set; }

        /// <summary>
        /// Date and time the status was updated. String, ISO 8691 format - YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time the status was updated. String, ISO 8691 format - YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="StatusDateTime", EmitDefaultValue=false)]
        public string StatusDateTime { get; set; }

        /// <summary>
        /// Party that initiated the status update. Valid values:&lt;br /&gt;    \&quot;I\&quot; - Issuer.&lt;br /&gt;    \&quot;W\&quot; - Token Requestor (including Wallet Provider).&lt;br /&gt;    \&quot;C\&quot; - Cardholder.&lt;br /&gt;    \&quot;P\&quot; - Mobile PIN Validation service.&lt;br /&gt;    \&quot;M\&quot; - Mobile PIN Change Validation service.
        /// </summary>
        /// <value>Party that initiated the status update. Valid values:&lt;br /&gt;    \&quot;I\&quot; - Issuer.&lt;br /&gt;    \&quot;W\&quot; - Token Requestor (including Wallet Provider).&lt;br /&gt;    \&quot;C\&quot; - Cardholder.&lt;br /&gt;    \&quot;P\&quot; - Mobile PIN Validation service.&lt;br /&gt;    \&quot;M\&quot; - Mobile PIN Change Validation service.</value>
        [DataMember(Name="Initiator", EmitDefaultValue=false)]
        public string Initiator { get; set; }

        /// <summary>
        /// Identifier of the comment added.  Conditional field, only present when comment text was provided in the request.
        /// </summary>
        /// <value>Identifier of the comment added.  Conditional field, only present when comment text was provided in the request.</value>
        [DataMember(Name="CommentId", EmitDefaultValue=false)]
        public string CommentId { get; set; }

        /// <summary>
        /// Reason for the status update.  Valid values:&lt;br /&gt;    \&quot;A\&quot; – Cardholder successfully authenticated using a mobile App prior to activation.&lt;br /&gt;    \&quot;C\&quot; – Cardholder successfully authenticated with a customer service agent prior to activation. (For &#39;Token Activate&#39;).&lt;br /&gt;    \&quot;C\&quot; – Account closed. (For &#39;Token Delete&#39;).&lt;br /&gt;    \&quot;F\&quot; – Cardholder reported token device found or not stolen.&lt;br /&gt;    \&quot;L\&quot; – Cardholder reported/confirmed token device lost.&lt;br /&gt;    \&quot;S\&quot; – Cardholder reported/confirmed token device stolen.&lt;br /&gt;    \&quot;T\&quot; – Issuer or cardholder reported fraudulent/then confirmed no fraudulent token transactions.&lt;br /&gt;    \&quot;Z\&quot; – Other.
        /// </summary>
        /// <value>Reason for the status update.  Valid values:&lt;br /&gt;    \&quot;A\&quot; – Cardholder successfully authenticated using a mobile App prior to activation.&lt;br /&gt;    \&quot;C\&quot; – Cardholder successfully authenticated with a customer service agent prior to activation. (For &#39;Token Activate&#39;).&lt;br /&gt;    \&quot;C\&quot; – Account closed. (For &#39;Token Delete&#39;).&lt;br /&gt;    \&quot;F\&quot; – Cardholder reported token device found or not stolen.&lt;br /&gt;    \&quot;L\&quot; – Cardholder reported/confirmed token device lost.&lt;br /&gt;    \&quot;S\&quot; – Cardholder reported/confirmed token device stolen.&lt;br /&gt;    \&quot;T\&quot; – Issuer or cardholder reported fraudulent/then confirmed no fraudulent token transactions.&lt;br /&gt;    \&quot;Z\&quot; – Other.</value>
        [DataMember(Name="ReasonCode", EmitDefaultValue=false)]
        public string ReasonCode { get; set; }

        /// <summary>
        /// Gets or Sets AuditInfo
        /// </summary>
        [DataMember(Name="AuditInfo", EmitDefaultValue=false)]
        public AuditInfo AuditInfo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Status {\n");
            sb.Append("  StatusCode: ").Append(StatusCode).Append("\n");
            sb.Append("  StatusDescription: ").Append(StatusDescription).Append("\n");
            sb.Append("  StatusDateTime: ").Append(StatusDateTime).Append("\n");
            sb.Append("  Initiator: ").Append(Initiator).Append("\n");
            sb.Append("  CommentId: ").Append(CommentId).Append("\n");
            sb.Append("  ReasonCode: ").Append(ReasonCode).Append("\n");
            sb.Append("  AuditInfo: ").Append(AuditInfo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Status);
        }

        /// <summary>
        /// Returns true if Status instances are equal
        /// </summary>
        /// <param name="input">Instance of Status to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Status input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.StatusCode == input.StatusCode ||
                    (this.StatusCode != null &&
                    this.StatusCode.Equals(input.StatusCode))
                ) && 
                (
                    this.StatusDescription == input.StatusDescription ||
                    (this.StatusDescription != null &&
                    this.StatusDescription.Equals(input.StatusDescription))
                ) && 
                (
                    this.StatusDateTime == input.StatusDateTime ||
                    (this.StatusDateTime != null &&
                    this.StatusDateTime.Equals(input.StatusDateTime))
                ) && 
                (
                    this.Initiator == input.Initiator ||
                    (this.Initiator != null &&
                    this.Initiator.Equals(input.Initiator))
                ) && 
                (
                    this.CommentId == input.CommentId ||
                    (this.CommentId != null &&
                    this.CommentId.Equals(input.CommentId))
                ) && 
                (
                    this.ReasonCode == input.ReasonCode ||
                    (this.ReasonCode != null &&
                    this.ReasonCode.Equals(input.ReasonCode))
                ) && 
                (
                    this.AuditInfo == input.AuditInfo ||
                    (this.AuditInfo != null &&
                    this.AuditInfo.Equals(input.AuditInfo))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.StatusCode != null)
                    hashCode = hashCode * 59 + this.StatusCode.GetHashCode();
                if (this.StatusDescription != null)
                    hashCode = hashCode * 59 + this.StatusDescription.GetHashCode();
                if (this.StatusDateTime != null)
                    hashCode = hashCode * 59 + this.StatusDateTime.GetHashCode();
                if (this.Initiator != null)
                    hashCode = hashCode * 59 + this.Initiator.GetHashCode();
                if (this.CommentId != null)
                    hashCode = hashCode * 59 + this.CommentId.GetHashCode();
                if (this.ReasonCode != null)
                    hashCode = hashCode * 59 + this.ReasonCode.GetHashCode();
                if (this.AuditInfo != null)
                    hashCode = hashCode * 59 + this.AuditInfo.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
