/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// SearchRequest
    /// </summary>
    [DataContract]
    public partial class SearchRequest :  IEquatable<SearchRequest>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SearchRequest" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SearchRequest() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SearchRequest" /> class.
        /// </summary>
        /// <param name="accountPan">When present, the search will return tokens for the Account matching this Primary Account Number (PAN), for any Wallet Provider or device. PAN will be minimum 9 digits and maximum 19 digits. Cannot be used together with any of the following search request parameters:TokenUniqueReference, Token, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier..</param>
        /// <param name="tokenUniqueReference">A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. When present,  the search will return one specific matching token. The TUR field will be a 48 char string. Cannot be used together with any of the following search request parameters: AccountPan, Token, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier..</param>
        /// <param name="token">When present, the search will return one specific token. Token will be minimum 9 digits and maximum 19 digits. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier..</param>
        /// <param name="paymentAppInstanceId">When present, the search will return tokens already present or to be provisioned to the specified Payment App instance. Note - This may contain the identifier of the Secure Element or a mobile device for some programs. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, CommentId, or AlternateAccountIdentifier..</param>
        /// <param name="commentId">When present, the search will return one specific token linked to the comment. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, PaymentAppInstanceId, or AlternateAccountIdentifier..</param>
        /// <param name="alternateAccountIdentifier">When present, the search will return tokens matching this Alternate Account Identifier, for any Wallet Provider or device. Alternate Account Identifier will be minimum 9 and maximum 64 characters. Space characters are not allowed. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, PaymentAppInstanceId, or CommentId..</param>
        /// <param name="financialAccountInformation">When present, return tokens for the Account matching this Financial  Account Information, for any Wallet Provider or device..</param>
        /// <param name="excludeDeletedIndicator">Indicates whether deleted tokens should be excluded from the search results. When omitted, deleted tokens are included in the results. \&quot;true\&quot; indicates deleted tokens are excluded from the search results. \&quot;false\&quot; means deleted tokens are included in the search results. 5 characters in length, max..</param>
        /// <param name="auditInfo">auditInfo (required).</param>
        public SearchRequest(string accountPan = default(string), string tokenUniqueReference = default(string), string token = default(string), string paymentAppInstanceId = default(string), string commentId = default(string), string alternateAccountIdentifier = default(string), string financialAccountInformation = default(string), string excludeDeletedIndicator = default(string), AuditInfo auditInfo = default(AuditInfo))
        {
            // to ensure "auditInfo" is required (not null)
            if (auditInfo == null)
            {
                throw new InvalidDataException("auditInfo is a required property for SearchRequest and cannot be null");
            }
            else
            {
                this.AuditInfo = auditInfo;
            }
            this.AccountPan = accountPan;
            this.TokenUniqueReference = tokenUniqueReference;
            this.Token = token;
            this.PaymentAppInstanceId = paymentAppInstanceId;
            this.CommentId = commentId;
            this.AlternateAccountIdentifier = alternateAccountIdentifier;
            this.FinancialAccountInformation = financialAccountInformation;
            this.ExcludeDeletedIndicator = excludeDeletedIndicator;
        }
        
        /// <summary>
        /// When present, the search will return tokens for the Account matching this Primary Account Number (PAN), for any Wallet Provider or device. PAN will be minimum 9 digits and maximum 19 digits. Cannot be used together with any of the following search request parameters:TokenUniqueReference, Token, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier.
        /// </summary>
        /// <value>When present, the search will return tokens for the Account matching this Primary Account Number (PAN), for any Wallet Provider or device. PAN will be minimum 9 digits and maximum 19 digits. Cannot be used together with any of the following search request parameters:TokenUniqueReference, Token, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier.</value>
        [DataMember(Name="AccountPan", EmitDefaultValue=false)]
        public string AccountPan { get; set; }

        /// <summary>
        /// A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. When present,  the search will return one specific matching token. The TUR field will be a 48 char string. Cannot be used together with any of the following search request parameters: AccountPan, Token, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier.
        /// </summary>
        /// <value>A unique reference assigned following the allocation of a token used  to identify the token for the duration of its lifetime. When present,  the search will return one specific matching token. The TUR field will be a 48 char string. Cannot be used together with any of the following search request parameters: AccountPan, Token, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier.</value>
        [DataMember(Name="TokenUniqueReference", EmitDefaultValue=false)]
        public string TokenUniqueReference { get; set; }

        /// <summary>
        /// When present, the search will return one specific token. Token will be minimum 9 digits and maximum 19 digits. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier.
        /// </summary>
        /// <value>When present, the search will return one specific token. Token will be minimum 9 digits and maximum 19 digits. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, PaymentAppInstanceId, CommentId, or AlternateAccountIdentifier.</value>
        [DataMember(Name="Token", EmitDefaultValue=false)]
        public string Token { get; set; }

        /// <summary>
        /// When present, the search will return tokens already present or to be provisioned to the specified Payment App instance. Note - This may contain the identifier of the Secure Element or a mobile device for some programs. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, CommentId, or AlternateAccountIdentifier.
        /// </summary>
        /// <value>When present, the search will return tokens already present or to be provisioned to the specified Payment App instance. Note - This may contain the identifier of the Secure Element or a mobile device for some programs. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, CommentId, or AlternateAccountIdentifier.</value>
        [DataMember(Name="PaymentAppInstanceId", EmitDefaultValue=false)]
        public string PaymentAppInstanceId { get; set; }

        /// <summary>
        /// When present, the search will return one specific token linked to the comment. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, PaymentAppInstanceId, or AlternateAccountIdentifier.
        /// </summary>
        /// <value>When present, the search will return one specific token linked to the comment. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, PaymentAppInstanceId, or AlternateAccountIdentifier.</value>
        [DataMember(Name="CommentId", EmitDefaultValue=false)]
        public string CommentId { get; set; }

        /// <summary>
        /// When present, the search will return tokens matching this Alternate Account Identifier, for any Wallet Provider or device. Alternate Account Identifier will be minimum 9 and maximum 64 characters. Space characters are not allowed. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, PaymentAppInstanceId, or CommentId.
        /// </summary>
        /// <value>When present, the search will return tokens matching this Alternate Account Identifier, for any Wallet Provider or device. Alternate Account Identifier will be minimum 9 and maximum 64 characters. Space characters are not allowed. Cannot be used together with any of the following search request parameters: AccountPan, TokenUniqueReference, Token, PaymentAppInstanceId, or CommentId.</value>
        [DataMember(Name="AlternateAccountIdentifier", EmitDefaultValue=false)]
        public string AlternateAccountIdentifier { get; set; }

        /// <summary>
        /// When present, return tokens for the Account matching this Financial  Account Information, for any Wallet Provider or device.
        /// </summary>
        /// <value>When present, return tokens for the Account matching this Financial  Account Information, for any Wallet Provider or device.</value>
        [DataMember(Name="FinancialAccountInformation", EmitDefaultValue=false)]
        public string FinancialAccountInformation { get; set; }

        /// <summary>
        /// Indicates whether deleted tokens should be excluded from the search results. When omitted, deleted tokens are included in the results. \&quot;true\&quot; indicates deleted tokens are excluded from the search results. \&quot;false\&quot; means deleted tokens are included in the search results. 5 characters in length, max.
        /// </summary>
        /// <value>Indicates whether deleted tokens should be excluded from the search results. When omitted, deleted tokens are included in the results. \&quot;true\&quot; indicates deleted tokens are excluded from the search results. \&quot;false\&quot; means deleted tokens are included in the search results. 5 characters in length, max.</value>
        [DataMember(Name="ExcludeDeletedIndicator", EmitDefaultValue=false)]
        public string ExcludeDeletedIndicator { get; set; }

        /// <summary>
        /// Gets or Sets AuditInfo
        /// </summary>
        [DataMember(Name="AuditInfo", EmitDefaultValue=false)]
        public AuditInfo AuditInfo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class SearchRequest {\n");
            sb.Append("  AccountPan: ").Append(AccountPan).Append("\n");
            sb.Append("  TokenUniqueReference: ").Append(TokenUniqueReference).Append("\n");
            sb.Append("  Token: ").Append(Token).Append("\n");
            sb.Append("  PaymentAppInstanceId: ").Append(PaymentAppInstanceId).Append("\n");
            sb.Append("  CommentId: ").Append(CommentId).Append("\n");
            sb.Append("  AlternateAccountIdentifier: ").Append(AlternateAccountIdentifier).Append("\n");
            sb.Append("  FinancialAccountInformation: ").Append(FinancialAccountInformation).Append("\n");
            sb.Append("  ExcludeDeletedIndicator: ").Append(ExcludeDeletedIndicator).Append("\n");
            sb.Append("  AuditInfo: ").Append(AuditInfo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as SearchRequest);
        }

        /// <summary>
        /// Returns true if SearchRequest instances are equal
        /// </summary>
        /// <param name="input">Instance of SearchRequest to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(SearchRequest input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.AccountPan == input.AccountPan ||
                    (this.AccountPan != null &&
                    this.AccountPan.Equals(input.AccountPan))
                ) && 
                (
                    this.TokenUniqueReference == input.TokenUniqueReference ||
                    (this.TokenUniqueReference != null &&
                    this.TokenUniqueReference.Equals(input.TokenUniqueReference))
                ) && 
                (
                    this.Token == input.Token ||
                    (this.Token != null &&
                    this.Token.Equals(input.Token))
                ) && 
                (
                    this.PaymentAppInstanceId == input.PaymentAppInstanceId ||
                    (this.PaymentAppInstanceId != null &&
                    this.PaymentAppInstanceId.Equals(input.PaymentAppInstanceId))
                ) && 
                (
                    this.CommentId == input.CommentId ||
                    (this.CommentId != null &&
                    this.CommentId.Equals(input.CommentId))
                ) && 
                (
                    this.AlternateAccountIdentifier == input.AlternateAccountIdentifier ||
                    (this.AlternateAccountIdentifier != null &&
                    this.AlternateAccountIdentifier.Equals(input.AlternateAccountIdentifier))
                ) && 
                (
                    this.FinancialAccountInformation == input.FinancialAccountInformation ||
                    (this.FinancialAccountInformation != null &&
                    this.FinancialAccountInformation.Equals(input.FinancialAccountInformation))
                ) && 
                (
                    this.ExcludeDeletedIndicator == input.ExcludeDeletedIndicator ||
                    (this.ExcludeDeletedIndicator != null &&
                    this.ExcludeDeletedIndicator.Equals(input.ExcludeDeletedIndicator))
                ) && 
                (
                    this.AuditInfo == input.AuditInfo ||
                    (this.AuditInfo != null &&
                    this.AuditInfo.Equals(input.AuditInfo))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.AccountPan != null)
                    hashCode = hashCode * 59 + this.AccountPan.GetHashCode();
                if (this.TokenUniqueReference != null)
                    hashCode = hashCode * 59 + this.TokenUniqueReference.GetHashCode();
                if (this.Token != null)
                    hashCode = hashCode * 59 + this.Token.GetHashCode();
                if (this.PaymentAppInstanceId != null)
                    hashCode = hashCode * 59 + this.PaymentAppInstanceId.GetHashCode();
                if (this.CommentId != null)
                    hashCode = hashCode * 59 + this.CommentId.GetHashCode();
                if (this.AlternateAccountIdentifier != null)
                    hashCode = hashCode * 59 + this.AlternateAccountIdentifier.GetHashCode();
                if (this.FinancialAccountInformation != null)
                    hashCode = hashCode * 59 + this.FinancialAccountInformation.GetHashCode();
                if (this.ExcludeDeletedIndicator != null)
                    hashCode = hashCode * 59 + this.ExcludeDeletedIndicator.GetHashCode();
                if (this.AuditInfo != null)
                    hashCode = hashCode * 59 + this.AuditInfo.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
