/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// FinancialAccountInformationSchema
    /// </summary>
    [DataContract]
    public partial class FinancialAccountInformationSchema :  IEquatable<FinancialAccountInformationSchema>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="FinancialAccountInformationSchema" /> class.
        /// </summary>
        /// <param name="financialAccountId">Current Financial Account Identifier of the token(s) to be updated. Conditional field, used for updating all tokens mapped to a single Financial Account and must not be present when TokenUniqueReference or CurrentAccountPan is present..</param>
        /// <param name="interbankCardAssociationId">Current ICA associated with the Financial of the token(s) to be updated.Conditional field, used for updating all tokens mapped to a single Financial Account and must be present when CurrentFinancialAccountInformation.FinancialAccountId is present. Length 3 - 11 numbers..</param>
        /// <param name="countryCode">Current Country code associated with the Financial of the token(s) to be updated. Expressed as a 3-letter (alpha-3) country code as defined in ISO 3166-1. Conditional field, used for updating all tokens mapped to a single Financial Account and must be present when CurrentFinancialAccountInformation.FinancialAccountId is present..</param>
        public FinancialAccountInformationSchema(string financialAccountId = default(string), string interbankCardAssociationId = default(string), string countryCode = default(string))
        {
            this.FinancialAccountId = financialAccountId;
            this.InterbankCardAssociationId = interbankCardAssociationId;
            this.CountryCode = countryCode;
        }
        
        /// <summary>
        /// Current Financial Account Identifier of the token(s) to be updated. Conditional field, used for updating all tokens mapped to a single Financial Account and must not be present when TokenUniqueReference or CurrentAccountPan is present.
        /// </summary>
        /// <value>Current Financial Account Identifier of the token(s) to be updated. Conditional field, used for updating all tokens mapped to a single Financial Account and must not be present when TokenUniqueReference or CurrentAccountPan is present.</value>
        [DataMember(Name="FinancialAccountId", EmitDefaultValue=false)]
        public string FinancialAccountId { get; set; }

        /// <summary>
        /// Current ICA associated with the Financial of the token(s) to be updated.Conditional field, used for updating all tokens mapped to a single Financial Account and must be present when CurrentFinancialAccountInformation.FinancialAccountId is present. Length 3 - 11 numbers.
        /// </summary>
        /// <value>Current ICA associated with the Financial of the token(s) to be updated.Conditional field, used for updating all tokens mapped to a single Financial Account and must be present when CurrentFinancialAccountInformation.FinancialAccountId is present. Length 3 - 11 numbers.</value>
        [DataMember(Name="InterbankCardAssociationId", EmitDefaultValue=false)]
        public string InterbankCardAssociationId { get; set; }

        /// <summary>
        /// Current Country code associated with the Financial of the token(s) to be updated. Expressed as a 3-letter (alpha-3) country code as defined in ISO 3166-1. Conditional field, used for updating all tokens mapped to a single Financial Account and must be present when CurrentFinancialAccountInformation.FinancialAccountId is present.
        /// </summary>
        /// <value>Current Country code associated with the Financial of the token(s) to be updated. Expressed as a 3-letter (alpha-3) country code as defined in ISO 3166-1. Conditional field, used for updating all tokens mapped to a single Financial Account and must be present when CurrentFinancialAccountInformation.FinancialAccountId is present.</value>
        [DataMember(Name="CountryCode", EmitDefaultValue=false)]
        public string CountryCode { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class FinancialAccountInformationSchema {\n");
            sb.Append("  FinancialAccountId: ").Append(FinancialAccountId).Append("\n");
            sb.Append("  InterbankCardAssociationId: ").Append(InterbankCardAssociationId).Append("\n");
            sb.Append("  CountryCode: ").Append(CountryCode).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as FinancialAccountInformationSchema);
        }

        /// <summary>
        /// Returns true if FinancialAccountInformationSchema instances are equal
        /// </summary>
        /// <param name="input">Instance of FinancialAccountInformationSchema to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(FinancialAccountInformationSchema input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.FinancialAccountId == input.FinancialAccountId ||
                    (this.FinancialAccountId != null &&
                    this.FinancialAccountId.Equals(input.FinancialAccountId))
                ) && 
                (
                    this.InterbankCardAssociationId == input.InterbankCardAssociationId ||
                    (this.InterbankCardAssociationId != null &&
                    this.InterbankCardAssociationId.Equals(input.InterbankCardAssociationId))
                ) && 
                (
                    this.CountryCode == input.CountryCode ||
                    (this.CountryCode != null &&
                    this.CountryCode.Equals(input.CountryCode))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.FinancialAccountId != null)
                    hashCode = hashCode * 59 + this.FinancialAccountId.GetHashCode();
                if (this.InterbankCardAssociationId != null)
                    hashCode = hashCode * 59 + this.InterbankCardAssociationId.GetHashCode();
                if (this.CountryCode != null)
                    hashCode = hashCode * 59 + this.CountryCode.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
