/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Device
    /// </summary>
    [DataContract]
    public partial class Device :  IEquatable<Device>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Device" /> class.
        /// </summary>
        /// <param name="deviceId">Serial number of the device provisioned with the token. May be masked. Conditional field, not present for CoF tokens, and only present when provided by a Wallet Provider. May be masked (by the Wallet Provider).&lt;br /&gt;Example (unmasked) \&quot;C2ZBY14310005664\&quot;. Example (masked) \&quot;xxxxY1431xxxxxxx\&quot;..</param>
        /// <param name="deviceName">Nickname of the device provisioned with the token. Conditional field, not present for CoF tokens, and only present when the Payment App Provider has implemented the &#39;Get Device Info&#39; MDES API..</param>
        /// <param name="deviceType">Type of the device provisioned with the token.  Note: Issuers should be aware that new values may be introduced at  any time and Issuers must program to expect new values in the Search  API response without causing impact. Also note the presence of an  ‘Undefined’ value, “99”, which is a device type that is not yet defined.  It is used for allowing Token Requestors to introduce a new device type  that is not yet public knowledge.  Valid values:&lt;br /&gt;    \&quot;03\&quot; - Watch&lt;br /&gt;    \&quot;09\&quot; - Mobile Phone or Smartphone with a fixed (non-removable) secure element not controlled by the mobile network operator&lt;br /&gt;    \&quot;13\&quot; - Tablet or e-reader with a fixed (non-removable) secure element not controlled by the mobile network operator&lt;br /&gt;    \&quot;14\&quot; - Mobile phone or Smartphone with a payment application running in a host processor&lt;br /&gt;    \&quot;15\&quot; - Tablet or E-Book with a payment application running in a host processor&lt;br /&gt;    \&quot;16\&quot; – Mobile Phone or Smartphone with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;17\&quot; – Tablet or E-Book with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;18\&quot; – Watch with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;19\&quot; – Watch with a payment application running in a host processor&lt;br /&gt;    \&quot;21\&quot; - Phone&lt;br /&gt;    \&quot;22\&quot; - Tablet&lt;br /&gt;     \&quot;23\&quot; - Watch&lt;br /&gt;    \&quot;24\&quot; - Sticker&lt;br /&gt;    \&quot;25\&quot; - Personal Computer&lt;br /&gt;     \&quot;26\&quot; - Device Peripheral&lt;br /&gt;    \&quot;27\&quot; - Tag&lt;br /&gt;    \&quot;28\&quot; - Jewelry&lt;br /&gt;    “29” – Fashion Accessory&lt;br /&gt;    \&quot;30\&quot; - Garment&lt;br /&gt;     \&quot;31\&quot; - Domestic Appliance&lt;br /&gt;    \&quot;32\&quot; - Vehicle&lt;br /&gt;     \&quot;33\&quot; - Media or Gaming Device&lt;br /&gt;    \&quot;99\&quot; - Undefined &lt;br /&gt;Conditional  field, not present for CoF tokens, and only present when supplied by the  Payment App Provider..</param>
        /// <param name="secureElementId">Identifier of the secure element provisioned with the token. Conditional field, not present for CoF tokens, and only present when the token is provisioned to a secure element..</param>
        public Device(string deviceId = default(string), string deviceName = default(string), string deviceType = default(string), string secureElementId = default(string))
        {
            this.DeviceId = deviceId;
            this.DeviceName = deviceName;
            this.DeviceType = deviceType;
            this.SecureElementId = secureElementId;
        }
        
        /// <summary>
        /// Serial number of the device provisioned with the token. May be masked. Conditional field, not present for CoF tokens, and only present when provided by a Wallet Provider. May be masked (by the Wallet Provider).&lt;br /&gt;Example (unmasked) \&quot;C2ZBY14310005664\&quot;. Example (masked) \&quot;xxxxY1431xxxxxxx\&quot;.
        /// </summary>
        /// <value>Serial number of the device provisioned with the token. May be masked. Conditional field, not present for CoF tokens, and only present when provided by a Wallet Provider. May be masked (by the Wallet Provider).&lt;br /&gt;Example (unmasked) \&quot;C2ZBY14310005664\&quot;. Example (masked) \&quot;xxxxY1431xxxxxxx\&quot;.</value>
        [DataMember(Name="DeviceId", EmitDefaultValue=false)]
        public string DeviceId { get; set; }

        /// <summary>
        /// Nickname of the device provisioned with the token. Conditional field, not present for CoF tokens, and only present when the Payment App Provider has implemented the &#39;Get Device Info&#39; MDES API.
        /// </summary>
        /// <value>Nickname of the device provisioned with the token. Conditional field, not present for CoF tokens, and only present when the Payment App Provider has implemented the &#39;Get Device Info&#39; MDES API.</value>
        [DataMember(Name="DeviceName", EmitDefaultValue=false)]
        public string DeviceName { get; set; }

        /// <summary>
        /// Type of the device provisioned with the token.  Note: Issuers should be aware that new values may be introduced at  any time and Issuers must program to expect new values in the Search  API response without causing impact. Also note the presence of an  ‘Undefined’ value, “99”, which is a device type that is not yet defined.  It is used for allowing Token Requestors to introduce a new device type  that is not yet public knowledge.  Valid values:&lt;br /&gt;    \&quot;03\&quot; - Watch&lt;br /&gt;    \&quot;09\&quot; - Mobile Phone or Smartphone with a fixed (non-removable) secure element not controlled by the mobile network operator&lt;br /&gt;    \&quot;13\&quot; - Tablet or e-reader with a fixed (non-removable) secure element not controlled by the mobile network operator&lt;br /&gt;    \&quot;14\&quot; - Mobile phone or Smartphone with a payment application running in a host processor&lt;br /&gt;    \&quot;15\&quot; - Tablet or E-Book with a payment application running in a host processor&lt;br /&gt;    \&quot;16\&quot; – Mobile Phone or Smartphone with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;17\&quot; – Tablet or E-Book with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;18\&quot; – Watch with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;19\&quot; – Watch with a payment application running in a host processor&lt;br /&gt;    \&quot;21\&quot; - Phone&lt;br /&gt;    \&quot;22\&quot; - Tablet&lt;br /&gt;     \&quot;23\&quot; - Watch&lt;br /&gt;    \&quot;24\&quot; - Sticker&lt;br /&gt;    \&quot;25\&quot; - Personal Computer&lt;br /&gt;     \&quot;26\&quot; - Device Peripheral&lt;br /&gt;    \&quot;27\&quot; - Tag&lt;br /&gt;    \&quot;28\&quot; - Jewelry&lt;br /&gt;    “29” – Fashion Accessory&lt;br /&gt;    \&quot;30\&quot; - Garment&lt;br /&gt;     \&quot;31\&quot; - Domestic Appliance&lt;br /&gt;    \&quot;32\&quot; - Vehicle&lt;br /&gt;     \&quot;33\&quot; - Media or Gaming Device&lt;br /&gt;    \&quot;99\&quot; - Undefined &lt;br /&gt;Conditional  field, not present for CoF tokens, and only present when supplied by the  Payment App Provider.
        /// </summary>
        /// <value>Type of the device provisioned with the token.  Note: Issuers should be aware that new values may be introduced at  any time and Issuers must program to expect new values in the Search  API response without causing impact. Also note the presence of an  ‘Undefined’ value, “99”, which is a device type that is not yet defined.  It is used for allowing Token Requestors to introduce a new device type  that is not yet public knowledge.  Valid values:&lt;br /&gt;    \&quot;03\&quot; - Watch&lt;br /&gt;    \&quot;09\&quot; - Mobile Phone or Smartphone with a fixed (non-removable) secure element not controlled by the mobile network operator&lt;br /&gt;    \&quot;13\&quot; - Tablet or e-reader with a fixed (non-removable) secure element not controlled by the mobile network operator&lt;br /&gt;    \&quot;14\&quot; - Mobile phone or Smartphone with a payment application running in a host processor&lt;br /&gt;    \&quot;15\&quot; - Tablet or E-Book with a payment application running in a host processor&lt;br /&gt;    \&quot;16\&quot; – Mobile Phone or Smartphone with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;17\&quot; – Tablet or E-Book with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;18\&quot; – Watch with a payment application running in the TEE of a host processor&lt;br /&gt;    \&quot;19\&quot; – Watch with a payment application running in a host processor&lt;br /&gt;    \&quot;21\&quot; - Phone&lt;br /&gt;    \&quot;22\&quot; - Tablet&lt;br /&gt;     \&quot;23\&quot; - Watch&lt;br /&gt;    \&quot;24\&quot; - Sticker&lt;br /&gt;    \&quot;25\&quot; - Personal Computer&lt;br /&gt;     \&quot;26\&quot; - Device Peripheral&lt;br /&gt;    \&quot;27\&quot; - Tag&lt;br /&gt;    \&quot;28\&quot; - Jewelry&lt;br /&gt;    “29” – Fashion Accessory&lt;br /&gt;    \&quot;30\&quot; - Garment&lt;br /&gt;     \&quot;31\&quot; - Domestic Appliance&lt;br /&gt;    \&quot;32\&quot; - Vehicle&lt;br /&gt;     \&quot;33\&quot; - Media or Gaming Device&lt;br /&gt;    \&quot;99\&quot; - Undefined &lt;br /&gt;Conditional  field, not present for CoF tokens, and only present when supplied by the  Payment App Provider.</value>
        [DataMember(Name="DeviceType", EmitDefaultValue=false)]
        public string DeviceType { get; set; }

        /// <summary>
        /// Identifier of the secure element provisioned with the token. Conditional field, not present for CoF tokens, and only present when the token is provisioned to a secure element.
        /// </summary>
        /// <value>Identifier of the secure element provisioned with the token. Conditional field, not present for CoF tokens, and only present when the token is provisioned to a secure element.</value>
        [DataMember(Name="SecureElementId", EmitDefaultValue=false)]
        public string SecureElementId { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Device {\n");
            sb.Append("  DeviceId: ").Append(DeviceId).Append("\n");
            sb.Append("  DeviceName: ").Append(DeviceName).Append("\n");
            sb.Append("  DeviceType: ").Append(DeviceType).Append("\n");
            sb.Append("  SecureElementId: ").Append(SecureElementId).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Device);
        }

        /// <summary>
        /// Returns true if Device instances are equal
        /// </summary>
        /// <param name="input">Instance of Device to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Device input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.DeviceId == input.DeviceId ||
                    (this.DeviceId != null &&
                    this.DeviceId.Equals(input.DeviceId))
                ) && 
                (
                    this.DeviceName == input.DeviceName ||
                    (this.DeviceName != null &&
                    this.DeviceName.Equals(input.DeviceName))
                ) && 
                (
                    this.DeviceType == input.DeviceType ||
                    (this.DeviceType != null &&
                    this.DeviceType.Equals(input.DeviceType))
                ) && 
                (
                    this.SecureElementId == input.SecureElementId ||
                    (this.SecureElementId != null &&
                    this.SecureElementId.Equals(input.SecureElementId))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.DeviceId != null)
                    hashCode = hashCode * 59 + this.DeviceId.GetHashCode();
                if (this.DeviceName != null)
                    hashCode = hashCode * 59 + this.DeviceName.GetHashCode();
                if (this.DeviceType != null)
                    hashCode = hashCode * 59 + this.DeviceType.GetHashCode();
                if (this.SecureElementId != null)
                    hashCode = hashCode * 59 + this.SecureElementId.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
