/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Comment
    /// </summary>
    [DataContract]
    public partial class Comment :  IEquatable<Comment>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Comment" /> class.
        /// </summary>
        /// <param name="commentId">Identifier for the comment..</param>
        /// <param name="commentText">Comment text..</param>
        /// <param name="commentDateTime">Date and time that the comment was updated. Format - YYYY-MM-DDThh:mm:ssTZD ..</param>
        /// <param name="auditInfo">auditInfo.</param>
        public Comment(string commentId = default(string), string commentText = default(string), string commentDateTime = default(string), AuditInfo auditInfo = default(AuditInfo))
        {
            this.CommentId = commentId;
            this.CommentText = commentText;
            this.CommentDateTime = commentDateTime;
            this.AuditInfo = auditInfo;
        }
        
        /// <summary>
        /// Identifier for the comment.
        /// </summary>
        /// <value>Identifier for the comment.</value>
        [DataMember(Name="CommentId", EmitDefaultValue=false)]
        public string CommentId { get; set; }

        /// <summary>
        /// Comment text.
        /// </summary>
        /// <value>Comment text.</value>
        [DataMember(Name="CommentText", EmitDefaultValue=false)]
        public string CommentText { get; set; }

        /// <summary>
        /// Date and time that the comment was updated. Format - YYYY-MM-DDThh:mm:ssTZD .
        /// </summary>
        /// <value>Date and time that the comment was updated. Format - YYYY-MM-DDThh:mm:ssTZD .</value>
        [DataMember(Name="CommentDateTime", EmitDefaultValue=false)]
        public string CommentDateTime { get; set; }

        /// <summary>
        /// Gets or Sets AuditInfo
        /// </summary>
        [DataMember(Name="AuditInfo", EmitDefaultValue=false)]
        public AuditInfo AuditInfo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Comment {\n");
            sb.Append("  CommentId: ").Append(CommentId).Append("\n");
            sb.Append("  CommentText: ").Append(CommentText).Append("\n");
            sb.Append("  CommentDateTime: ").Append(CommentDateTime).Append("\n");
            sb.Append("  AuditInfo: ").Append(AuditInfo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Comment);
        }

        /// <summary>
        /// Returns true if Comment instances are equal
        /// </summary>
        /// <param name="input">Instance of Comment to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Comment input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.CommentId == input.CommentId ||
                    (this.CommentId != null &&
                    this.CommentId.Equals(input.CommentId))
                ) && 
                (
                    this.CommentText == input.CommentText ||
                    (this.CommentText != null &&
                    this.CommentText.Equals(input.CommentText))
                ) && 
                (
                    this.CommentDateTime == input.CommentDateTime ||
                    (this.CommentDateTime != null &&
                    this.CommentDateTime.Equals(input.CommentDateTime))
                ) && 
                (
                    this.AuditInfo == input.AuditInfo ||
                    (this.AuditInfo != null &&
                    this.AuditInfo.Equals(input.AuditInfo))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.CommentId != null)
                    hashCode = hashCode * 59 + this.CommentId.GetHashCode();
                if (this.CommentText != null)
                    hashCode = hashCode * 59 + this.CommentText.GetHashCode();
                if (this.CommentDateTime != null)
                    hashCode = hashCode * 59 + this.CommentDateTime.GetHashCode();
                if (this.AuditInfo != null)
                    hashCode = hashCode * 59 + this.AuditInfo.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
