/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// AuditInfo
    /// </summary>
    [DataContract]
    public partial class AuditInfo :  IEquatable<AuditInfo>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="AuditInfo" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected AuditInfo() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="AuditInfo" /> class.
        /// </summary>
        /// <param name="userId">User ID (as assigned by the Issuer/Processor) of the Customer Service Representative who triggered the API request. String of up to 50 characters. (required).</param>
        /// <param name="userName">User Name of the Customer Service Representative who triggered the API request. String of up to 200 characters. (required).</param>
        /// <param name="organization">Name of the Issuer or Processor to which the Customer Service Representative who triggered the API request belongs. String of up to 200 characters. (required).</param>
        /// <param name="phone">Phone Number of the Customer Service Representative who triggered the API request. String of up to 20 characters..</param>
        public AuditInfo(string userId = default(string), string userName = default(string), string organization = default(string), string phone = default(string))
        {
            // to ensure "userId" is required (not null)
            if (userId == null)
            {
                throw new InvalidDataException("userId is a required property for AuditInfo and cannot be null");
            }
            else
            {
                this.UserId = userId;
            }
            // to ensure "userName" is required (not null)
            if (userName == null)
            {
                throw new InvalidDataException("userName is a required property for AuditInfo and cannot be null");
            }
            else
            {
                this.UserName = userName;
            }
            // to ensure "organization" is required (not null)
            if (organization == null)
            {
                throw new InvalidDataException("organization is a required property for AuditInfo and cannot be null");
            }
            else
            {
                this.Organization = organization;
            }
            this.Phone = phone;
        }
        
        /// <summary>
        /// User ID (as assigned by the Issuer/Processor) of the Customer Service Representative who triggered the API request. String of up to 50 characters.
        /// </summary>
        /// <value>User ID (as assigned by the Issuer/Processor) of the Customer Service Representative who triggered the API request. String of up to 50 characters.</value>
        [DataMember(Name="UserId", EmitDefaultValue=false)]
        public string UserId { get; set; }

        /// <summary>
        /// User Name of the Customer Service Representative who triggered the API request. String of up to 200 characters.
        /// </summary>
        /// <value>User Name of the Customer Service Representative who triggered the API request. String of up to 200 characters.</value>
        [DataMember(Name="UserName", EmitDefaultValue=false)]
        public string UserName { get; set; }

        /// <summary>
        /// Name of the Issuer or Processor to which the Customer Service Representative who triggered the API request belongs. String of up to 200 characters.
        /// </summary>
        /// <value>Name of the Issuer or Processor to which the Customer Service Representative who triggered the API request belongs. String of up to 200 characters.</value>
        [DataMember(Name="Organization", EmitDefaultValue=false)]
        public string Organization { get; set; }

        /// <summary>
        /// Phone Number of the Customer Service Representative who triggered the API request. String of up to 20 characters.
        /// </summary>
        /// <value>Phone Number of the Customer Service Representative who triggered the API request. String of up to 20 characters.</value>
        [DataMember(Name="Phone", EmitDefaultValue=false)]
        public string Phone { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class AuditInfo {\n");
            sb.Append("  UserId: ").Append(UserId).Append("\n");
            sb.Append("  UserName: ").Append(UserName).Append("\n");
            sb.Append("  Organization: ").Append(Organization).Append("\n");
            sb.Append("  Phone: ").Append(Phone).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as AuditInfo);
        }

        /// <summary>
        /// Returns true if AuditInfo instances are equal
        /// </summary>
        /// <param name="input">Instance of AuditInfo to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(AuditInfo input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.UserId == input.UserId ||
                    (this.UserId != null &&
                    this.UserId.Equals(input.UserId))
                ) && 
                (
                    this.UserName == input.UserName ||
                    (this.UserName != null &&
                    this.UserName.Equals(input.UserName))
                ) && 
                (
                    this.Organization == input.Organization ||
                    (this.Organization != null &&
                    this.Organization.Equals(input.Organization))
                ) && 
                (
                    this.Phone == input.Phone ||
                    (this.Phone != null &&
                    this.Phone.Equals(input.Phone))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.UserId != null)
                    hashCode = hashCode * 59 + this.UserId.GetHashCode();
                if (this.UserName != null)
                    hashCode = hashCode * 59 + this.UserName.GetHashCode();
                if (this.Organization != null)
                    hashCode = hashCode * 59 + this.Organization.GetHashCode();
                if (this.Phone != null)
                    hashCode = hashCode * 59 + this.Phone.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
