/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// ActivationMethod
    /// </summary>
    [DataContract]
    public partial class ActivationMethod :  IEquatable<ActivationMethod>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ActivationMethod" /> class.
        /// </summary>
        /// <param name="activationMethodType">Type of activation method. Valid values:&lt;br /&gt;    \&quot;SMS\&quot; – Activation code sent in text message to masked mobile phone number&lt;br /&gt;    \&quot;EMA\&quot; – Activation code sent in email to masked email address&lt;br /&gt;    \&quot;ACC\&quot; – Cardholder to call automated call center phone number&lt;br /&gt;    \&quot;CLC\&quot; – Cardholder to call Call Center phone number&lt;br /&gt;    \&quot;WEB\&quot; – Website&lt;br /&gt;    \&quot;BAP\&quot; – Mobile application&lt;br /&gt;    \&quot;OBC\&quot; – Activation code spoken via call to cardholder on masked voice call phone number..</param>
        /// <param name="activationMethodValue">Activation method details value..</param>
        /// <param name="activationMethodId">Unique identifier of the activation method..</param>
        /// <param name="resendIndicator">Whether the activation method can be used to re-send an activation code. Valid values are TRUE and FALSE..</param>
        public ActivationMethod(string activationMethodType = default(string), string activationMethodValue = default(string), string activationMethodId = default(string), string resendIndicator = default(string))
        {
            this.ActivationMethodType = activationMethodType;
            this.ActivationMethodValue = activationMethodValue;
            this.ActivationMethodId = activationMethodId;
            this.ResendIndicator = resendIndicator;
        }
        
        /// <summary>
        /// Type of activation method. Valid values:&lt;br /&gt;    \&quot;SMS\&quot; – Activation code sent in text message to masked mobile phone number&lt;br /&gt;    \&quot;EMA\&quot; – Activation code sent in email to masked email address&lt;br /&gt;    \&quot;ACC\&quot; – Cardholder to call automated call center phone number&lt;br /&gt;    \&quot;CLC\&quot; – Cardholder to call Call Center phone number&lt;br /&gt;    \&quot;WEB\&quot; – Website&lt;br /&gt;    \&quot;BAP\&quot; – Mobile application&lt;br /&gt;    \&quot;OBC\&quot; – Activation code spoken via call to cardholder on masked voice call phone number.
        /// </summary>
        /// <value>Type of activation method. Valid values:&lt;br /&gt;    \&quot;SMS\&quot; – Activation code sent in text message to masked mobile phone number&lt;br /&gt;    \&quot;EMA\&quot; – Activation code sent in email to masked email address&lt;br /&gt;    \&quot;ACC\&quot; – Cardholder to call automated call center phone number&lt;br /&gt;    \&quot;CLC\&quot; – Cardholder to call Call Center phone number&lt;br /&gt;    \&quot;WEB\&quot; – Website&lt;br /&gt;    \&quot;BAP\&quot; – Mobile application&lt;br /&gt;    \&quot;OBC\&quot; – Activation code spoken via call to cardholder on masked voice call phone number.</value>
        [DataMember(Name="ActivationMethodType", EmitDefaultValue=false)]
        public string ActivationMethodType { get; set; }

        /// <summary>
        /// Activation method details value.
        /// </summary>
        /// <value>Activation method details value.</value>
        [DataMember(Name="ActivationMethodValue", EmitDefaultValue=false)]
        public string ActivationMethodValue { get; set; }

        /// <summary>
        /// Unique identifier of the activation method.
        /// </summary>
        /// <value>Unique identifier of the activation method.</value>
        [DataMember(Name="ActivationMethodId", EmitDefaultValue=false)]
        public string ActivationMethodId { get; set; }

        /// <summary>
        /// Whether the activation method can be used to re-send an activation code. Valid values are TRUE and FALSE.
        /// </summary>
        /// <value>Whether the activation method can be used to re-send an activation code. Valid values are TRUE and FALSE.</value>
        [DataMember(Name="ResendIndicator", EmitDefaultValue=false)]
        public string ResendIndicator { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class ActivationMethod {\n");
            sb.Append("  ActivationMethodType: ").Append(ActivationMethodType).Append("\n");
            sb.Append("  ActivationMethodValue: ").Append(ActivationMethodValue).Append("\n");
            sb.Append("  ActivationMethodId: ").Append(ActivationMethodId).Append("\n");
            sb.Append("  ResendIndicator: ").Append(ResendIndicator).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as ActivationMethod);
        }

        /// <summary>
        /// Returns true if ActivationMethod instances are equal
        /// </summary>
        /// <param name="input">Instance of ActivationMethod to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(ActivationMethod input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.ActivationMethodType == input.ActivationMethodType ||
                    (this.ActivationMethodType != null &&
                    this.ActivationMethodType.Equals(input.ActivationMethodType))
                ) && 
                (
                    this.ActivationMethodValue == input.ActivationMethodValue ||
                    (this.ActivationMethodValue != null &&
                    this.ActivationMethodValue.Equals(input.ActivationMethodValue))
                ) && 
                (
                    this.ActivationMethodId == input.ActivationMethodId ||
                    (this.ActivationMethodId != null &&
                    this.ActivationMethodId.Equals(input.ActivationMethodId))
                ) && 
                (
                    this.ResendIndicator == input.ResendIndicator ||
                    (this.ResendIndicator != null &&
                    this.ResendIndicator.Equals(input.ResendIndicator))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.ActivationMethodType != null)
                    hashCode = hashCode * 59 + this.ActivationMethodType.GetHashCode();
                if (this.ActivationMethodValue != null)
                    hashCode = hashCode * 59 + this.ActivationMethodValue.GetHashCode();
                if (this.ActivationMethodId != null)
                    hashCode = hashCode * 59 + this.ActivationMethodId.GetHashCode();
                if (this.ResendIndicator != null)
                    hashCode = hashCode * 59 + this.ResendIndicator.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
