/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Accounts
    /// </summary>
    [DataContract]
    public partial class Accounts :  IEquatable<Accounts>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Accounts" /> class.
        /// </summary>
        /// <param name="account">When searching by Account PAN or by Payment App Instance Id, the search response may contain more than one token. Each individual token can be updated during its lifetime and associated to a different Account PAN, or given a new Expiration Date. Different tokens within a single search response may therefore have different Account PANs and/or Expiration Dates. Account objects are used to group tokens that have exactly the same Account PAN and Account PAN Expiration Date..</param>
        public Accounts(List<Account> account = default(List<Account>))
        {
            this.Account = account;
        }
        
        /// <summary>
        /// When searching by Account PAN or by Payment App Instance Id, the search response may contain more than one token. Each individual token can be updated during its lifetime and associated to a different Account PAN, or given a new Expiration Date. Different tokens within a single search response may therefore have different Account PANs and/or Expiration Dates. Account objects are used to group tokens that have exactly the same Account PAN and Account PAN Expiration Date.
        /// </summary>
        /// <value>When searching by Account PAN or by Payment App Instance Id, the search response may contain more than one token. Each individual token can be updated during its lifetime and associated to a different Account PAN, or given a new Expiration Date. Different tokens within a single search response may therefore have different Account PANs and/or Expiration Dates. Account objects are used to group tokens that have exactly the same Account PAN and Account PAN Expiration Date.</value>
        [DataMember(Name="Account", EmitDefaultValue=false)]
        public List<Account> Account { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Accounts {\n");
            sb.Append("  Account: ").Append(Account).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Accounts);
        }

        /// <summary>
        /// Returns true if Accounts instances are equal
        /// </summary>
        /// <param name="input">Instance of Accounts to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Accounts input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.Account == input.Account ||
                    this.Account != null &&
                    this.Account.SequenceEqual(input.Account)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Account != null)
                    hashCode = hashCode * 59 + this.Account.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
