/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = YourApp.MdesCustomerClient.Client.OpenAPIDateConverter;

namespace YourApp.MdesCustomerClient.Model
{
    /// <summary>
    /// Account
    /// </summary>
    [DataContract]
    public partial class Account :  IEquatable<Account>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Account" /> class.
        /// </summary>
        /// <param name="accountPanSuffix">Last 4 digits of Account PAN mapped (or to be mapped) to Token(s). String has 4 characters..</param>
        /// <param name="financialAccountSuffix">Last 4 digits of the financial account information mapped (or to be mapped)  to Token(s). Conditional field. Present when mapping is tied to a financial account..</param>
        /// <param name="countryCode">The country of the financial account. Expressed as a 3-letter (alpha-3) country code  as defined in ISO 3166-1. Conditional field. Present when mapping is tied to a financial account..</param>
        /// <param name="interbankCardAssociationId">The id assigned by Mastercard to the financial institution. Conditional field. Present when  mapping is tied to a financial account. Length 3 - 11 numbers..</param>
        /// <param name="institutionName">The name of the financial institution associated with the account. Conditional field. Present when  mapping is tied to a financial account..</param>
        /// <param name="expirationDate">Expiration date of Account PAN mapped (or to be mapped) to Token(s). MMYY format..</param>
        /// <param name="alternateAccountIdentifierSuffix">Alternate Account Identifier is a cardholder friendly reference to a bank account. It is typically used to identify associated tokens when the cardholder is unaware of their Account PAN. The Alternate Account Identifier Suffix exposes just the last few characters of the full identifier, in order to protect the full identifier from possible fraud. The suffix may be up to 8 characters long..</param>
        /// <param name="tokens">tokens.</param>
        public Account(string accountPanSuffix = default(string), string financialAccountSuffix = default(string), string countryCode = default(string), string interbankCardAssociationId = default(string), string institutionName = default(string), string expirationDate = default(string), string alternateAccountIdentifierSuffix = default(string), Tokens tokens = default(Tokens))
        {
            this.AccountPanSuffix = accountPanSuffix;
            this.FinancialAccountSuffix = financialAccountSuffix;
            this.CountryCode = countryCode;
            this.InterbankCardAssociationId = interbankCardAssociationId;
            this.InstitutionName = institutionName;
            this.ExpirationDate = expirationDate;
            this.AlternateAccountIdentifierSuffix = alternateAccountIdentifierSuffix;
            this.Tokens = tokens;
        }
        
        /// <summary>
        /// Last 4 digits of Account PAN mapped (or to be mapped) to Token(s). String has 4 characters.
        /// </summary>
        /// <value>Last 4 digits of Account PAN mapped (or to be mapped) to Token(s). String has 4 characters.</value>
        [DataMember(Name="AccountPanSuffix", EmitDefaultValue=false)]
        public string AccountPanSuffix { get; set; }

        /// <summary>
        /// Last 4 digits of the financial account information mapped (or to be mapped)  to Token(s). Conditional field. Present when mapping is tied to a financial account.
        /// </summary>
        /// <value>Last 4 digits of the financial account information mapped (or to be mapped)  to Token(s). Conditional field. Present when mapping is tied to a financial account.</value>
        [DataMember(Name="FinancialAccountSuffix", EmitDefaultValue=false)]
        public string FinancialAccountSuffix { get; set; }

        /// <summary>
        /// The country of the financial account. Expressed as a 3-letter (alpha-3) country code  as defined in ISO 3166-1. Conditional field. Present when mapping is tied to a financial account.
        /// </summary>
        /// <value>The country of the financial account. Expressed as a 3-letter (alpha-3) country code  as defined in ISO 3166-1. Conditional field. Present when mapping is tied to a financial account.</value>
        [DataMember(Name="CountryCode", EmitDefaultValue=false)]
        public string CountryCode { get; set; }

        /// <summary>
        /// The id assigned by Mastercard to the financial institution. Conditional field. Present when  mapping is tied to a financial account. Length 3 - 11 numbers.
        /// </summary>
        /// <value>The id assigned by Mastercard to the financial institution. Conditional field. Present when  mapping is tied to a financial account. Length 3 - 11 numbers.</value>
        [DataMember(Name="InterbankCardAssociationId", EmitDefaultValue=false)]
        public string InterbankCardAssociationId { get; set; }

        /// <summary>
        /// The name of the financial institution associated with the account. Conditional field. Present when  mapping is tied to a financial account.
        /// </summary>
        /// <value>The name of the financial institution associated with the account. Conditional field. Present when  mapping is tied to a financial account.</value>
        [DataMember(Name="InstitutionName", EmitDefaultValue=false)]
        public string InstitutionName { get; set; }

        /// <summary>
        /// Expiration date of Account PAN mapped (or to be mapped) to Token(s). MMYY format.
        /// </summary>
        /// <value>Expiration date of Account PAN mapped (or to be mapped) to Token(s). MMYY format.</value>
        [DataMember(Name="ExpirationDate", EmitDefaultValue=false)]
        public string ExpirationDate { get; set; }

        /// <summary>
        /// Alternate Account Identifier is a cardholder friendly reference to a bank account. It is typically used to identify associated tokens when the cardholder is unaware of their Account PAN. The Alternate Account Identifier Suffix exposes just the last few characters of the full identifier, in order to protect the full identifier from possible fraud. The suffix may be up to 8 characters long.
        /// </summary>
        /// <value>Alternate Account Identifier is a cardholder friendly reference to a bank account. It is typically used to identify associated tokens when the cardholder is unaware of their Account PAN. The Alternate Account Identifier Suffix exposes just the last few characters of the full identifier, in order to protect the full identifier from possible fraud. The suffix may be up to 8 characters long.</value>
        [DataMember(Name="AlternateAccountIdentifierSuffix", EmitDefaultValue=false)]
        public string AlternateAccountIdentifierSuffix { get; set; }

        /// <summary>
        /// Gets or Sets Tokens
        /// </summary>
        [DataMember(Name="Tokens", EmitDefaultValue=false)]
        public Tokens Tokens { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class Account {\n");
            sb.Append("  AccountPanSuffix: ").Append(AccountPanSuffix).Append("\n");
            sb.Append("  FinancialAccountSuffix: ").Append(FinancialAccountSuffix).Append("\n");
            sb.Append("  CountryCode: ").Append(CountryCode).Append("\n");
            sb.Append("  InterbankCardAssociationId: ").Append(InterbankCardAssociationId).Append("\n");
            sb.Append("  InstitutionName: ").Append(InstitutionName).Append("\n");
            sb.Append("  ExpirationDate: ").Append(ExpirationDate).Append("\n");
            sb.Append("  AlternateAccountIdentifierSuffix: ").Append(AlternateAccountIdentifierSuffix).Append("\n");
            sb.Append("  Tokens: ").Append(Tokens).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Account);
        }

        /// <summary>
        /// Returns true if Account instances are equal
        /// </summary>
        /// <param name="input">Instance of Account to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Account input)
        {
            if (input == null)
                return false;

            return 
                (
                    this.AccountPanSuffix == input.AccountPanSuffix ||
                    (this.AccountPanSuffix != null &&
                    this.AccountPanSuffix.Equals(input.AccountPanSuffix))
                ) && 
                (
                    this.FinancialAccountSuffix == input.FinancialAccountSuffix ||
                    (this.FinancialAccountSuffix != null &&
                    this.FinancialAccountSuffix.Equals(input.FinancialAccountSuffix))
                ) && 
                (
                    this.CountryCode == input.CountryCode ||
                    (this.CountryCode != null &&
                    this.CountryCode.Equals(input.CountryCode))
                ) && 
                (
                    this.InterbankCardAssociationId == input.InterbankCardAssociationId ||
                    (this.InterbankCardAssociationId != null &&
                    this.InterbankCardAssociationId.Equals(input.InterbankCardAssociationId))
                ) && 
                (
                    this.InstitutionName == input.InstitutionName ||
                    (this.InstitutionName != null &&
                    this.InstitutionName.Equals(input.InstitutionName))
                ) && 
                (
                    this.ExpirationDate == input.ExpirationDate ||
                    (this.ExpirationDate != null &&
                    this.ExpirationDate.Equals(input.ExpirationDate))
                ) && 
                (
                    this.AlternateAccountIdentifierSuffix == input.AlternateAccountIdentifierSuffix ||
                    (this.AlternateAccountIdentifierSuffix != null &&
                    this.AlternateAccountIdentifierSuffix.Equals(input.AlternateAccountIdentifierSuffix))
                ) && 
                (
                    this.Tokens == input.Tokens ||
                    (this.Tokens != null &&
                    this.Tokens.Equals(input.Tokens))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.AccountPanSuffix != null)
                    hashCode = hashCode * 59 + this.AccountPanSuffix.GetHashCode();
                if (this.FinancialAccountSuffix != null)
                    hashCode = hashCode * 59 + this.FinancialAccountSuffix.GetHashCode();
                if (this.CountryCode != null)
                    hashCode = hashCode * 59 + this.CountryCode.GetHashCode();
                if (this.InterbankCardAssociationId != null)
                    hashCode = hashCode * 59 + this.InterbankCardAssociationId.GetHashCode();
                if (this.InstitutionName != null)
                    hashCode = hashCode * 59 + this.InstitutionName.GetHashCode();
                if (this.ExpirationDate != null)
                    hashCode = hashCode * 59 + this.ExpirationDate.GetHashCode();
                if (this.AlternateAccountIdentifierSuffix != null)
                    hashCode = hashCode * 59 + this.AlternateAccountIdentifierSuffix.GetHashCode();
                if (this.Tokens != null)
                    hashCode = hashCode * 59 + this.Tokens.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            yield break;
        }
    }

}
