/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using YourApp.MdesCustomerClient.Client;
using YourApp.MdesCustomerClient.Model;

namespace YourApp.MdesCustomerClient.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface ITokenResendActivationCodeApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>TokenResendActivationCodeResponseSchema</returns>
        TokenResendActivationCodeResponseSchema TokenResendactivationcodePost (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null);

        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>ApiResponse of TokenResendActivationCodeResponseSchema</returns>
        ApiResponse<TokenResendActivationCodeResponseSchema> TokenResendactivationcodePostWithHttpInfo (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null);
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>Task of TokenResendActivationCodeResponseSchema</returns>
        System.Threading.Tasks.Task<TokenResendActivationCodeResponseSchema> TokenResendactivationcodePostAsync (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null);

        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>Task of ApiResponse (TokenResendActivationCodeResponseSchema)</returns>
        System.Threading.Tasks.Task<ApiResponse<TokenResendActivationCodeResponseSchema>> TokenResendactivationcodePostAsyncWithHttpInfo (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class TokenResendActivationCodeApi : ITokenResendActivationCodeApi
    {
        private YourApp.MdesCustomerClient.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="TokenResendActivationCodeApi"/> class.
        /// </summary>
        /// <returns></returns>
        public TokenResendActivationCodeApi(String basePath)
        {
            this.Configuration = new YourApp.MdesCustomerClient.Client.Configuration { BasePath = basePath };

            ExceptionFactory = YourApp.MdesCustomerClient.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TokenResendActivationCodeApi"/> class
        /// </summary>
        /// <returns></returns>
        public TokenResendActivationCodeApi()
        {
            this.Configuration = YourApp.MdesCustomerClient.Client.Configuration.Default;

            ExceptionFactory = YourApp.MdesCustomerClient.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="TokenResendActivationCodeApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public TokenResendActivationCodeApi(YourApp.MdesCustomerClient.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = YourApp.MdesCustomerClient.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = YourApp.MdesCustomerClient.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public YourApp.MdesCustomerClient.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public YourApp.MdesCustomerClient.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        ///  Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>TokenResendActivationCodeResponseSchema</returns>
        public TokenResendActivationCodeResponseSchema TokenResendactivationcodePost (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null)
        {
             ApiResponse<TokenResendActivationCodeResponseSchema> localVarResponse = TokenResendactivationcodePostWithHttpInfo(tokenResendActivationCodeRequestSchema);
             return localVarResponse.Data;
        }

        /// <summary>
        ///  Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>ApiResponse of TokenResendActivationCodeResponseSchema</returns>
        public ApiResponse< TokenResendActivationCodeResponseSchema > TokenResendactivationcodePostWithHttpInfo (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null)
        {

            var localVarPath = "/token/resendactivationcode";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (tokenResendActivationCodeRequestSchema != null && tokenResendActivationCodeRequestSchema.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(tokenResendActivationCodeRequestSchema); // http body (model) parameter
            }
            else
            {
                localVarPostBody = tokenResendActivationCodeRequestSchema; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("TokenResendactivationcodePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TokenResendActivationCodeResponseSchema>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (TokenResendActivationCodeResponseSchema) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TokenResendActivationCodeResponseSchema)));
        }

        /// <summary>
        ///  Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>Task of TokenResendActivationCodeResponseSchema</returns>
        public async System.Threading.Tasks.Task<TokenResendActivationCodeResponseSchema> TokenResendactivationcodePostAsync (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null)
        {
             ApiResponse<TokenResendActivationCodeResponseSchema> localVarResponse = await TokenResendactivationcodePostAsyncWithHttpInfo(tokenResendActivationCodeRequestSchema);
             return localVarResponse.Data;

        }

        /// <summary>
        ///  Used to trigger the process of generating and sending a new Activation Code (for a specific token) to the cardholder via the requested Activation Method. When successful, a new Activation Code Expiration Date Time period will begin, and a new Activation Code will be sent to the issuer using the Activation Code Notification (ACN) pre-digitization network message. It can only be used to do this for Activation Methods that involve the external distribution of an Activation Code to the cardholder. For example, via email or SMS. It cannot be used to send a new activation code via the \&quot;Mobile Application\&quot; activation method, for instance. A new Activation Code can be sent even if the previous code has not expired. A new Activation Code can also be sent even after the previous code has expired; however, it can only be done up to 30 days after the token was created  (the number of days is subject to change at the discretion of Mastercard). 
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="tokenResendActivationCodeRequestSchema">Contains the details of the request message. (optional)</param>
        /// <returns>Task of ApiResponse (TokenResendActivationCodeResponseSchema)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<TokenResendActivationCodeResponseSchema>> TokenResendactivationcodePostAsyncWithHttpInfo (TokenResendActivationCodeRequestSchema tokenResendActivationCodeRequestSchema = null)
        {

            var localVarPath = "/token/resendactivationcode";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
                "application/json"
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);

            if (tokenResendActivationCodeRequestSchema != null && tokenResendActivationCodeRequestSchema.GetType() != typeof(byte[]))
            {
                localVarPostBody = this.Configuration.ApiClient.Serialize(tokenResendActivationCodeRequestSchema); // http body (model) parameter
            }
            else
            {
                localVarPostBody = tokenResendActivationCodeRequestSchema; // byte array
            }


            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.POST, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("TokenResendactivationcodePost", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<TokenResendActivationCodeResponseSchema>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (TokenResendActivationCodeResponseSchema) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(TokenResendActivationCodeResponseSchema)));
        }

    }
}
