/* 
 * MDES Customer Service
 *
 * This API provides our Issuer partners with resources to help resolve consumer queries about payment accounts enabled through our digitization platform.
 *
 * OpenAPI spec version: 2.0.4
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using RestSharp;
using YourApp.MdesCustomerClient.Client;
using YourApp.MdesCustomerClient.Model;

namespace YourApp.MdesCustomerClient.Api
{
    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface ISystemStatusApi : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>SystemStatusResponseSchema</returns>
        SystemStatusResponseSchema SystemstatusGet ();

        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>ApiResponse of SystemStatusResponseSchema</returns>
        ApiResponse<SystemStatusResponseSchema> SystemstatusGetWithHttpInfo ();
        #endregion Synchronous Operations
        #region Asynchronous Operations
        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>Task of SystemStatusResponseSchema</returns>
        System.Threading.Tasks.Task<SystemStatusResponseSchema> SystemstatusGetAsync ();

        /// <summary>
        /// 
        /// </summary>
        /// <remarks>
        /// Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </remarks>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>Task of ApiResponse (SystemStatusResponseSchema)</returns>
        System.Threading.Tasks.Task<ApiResponse<SystemStatusResponseSchema>> SystemstatusGetAsyncWithHttpInfo ();
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class SystemStatusApi : ISystemStatusApi
    {
        private YourApp.MdesCustomerClient.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="SystemStatusApi"/> class.
        /// </summary>
        /// <returns></returns>
        public SystemStatusApi(String basePath)
        {
            this.Configuration = new YourApp.MdesCustomerClient.Client.Configuration { BasePath = basePath };

            ExceptionFactory = YourApp.MdesCustomerClient.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SystemStatusApi"/> class
        /// </summary>
        /// <returns></returns>
        public SystemStatusApi()
        {
            this.Configuration = YourApp.MdesCustomerClient.Client.Configuration.Default;

            ExceptionFactory = YourApp.MdesCustomerClient.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SystemStatusApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public SystemStatusApi(YourApp.MdesCustomerClient.Client.Configuration configuration = null)
        {
            if (configuration == null) // use the default one in Configuration
                this.Configuration = YourApp.MdesCustomerClient.Client.Configuration.Default;
            else
                this.Configuration = configuration;

            ExceptionFactory = YourApp.MdesCustomerClient.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public String GetBasePath()
        {
            return this.Configuration.ApiClient.RestClient.BaseUrl.ToString();
        }

        /// <summary>
        /// Sets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        [Obsolete("SetBasePath is deprecated, please do 'Configuration.ApiClient = new ApiClient(\"http://new-path\")' instead.")]
        public void SetBasePath(String basePath)
        {
            // do nothing
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public YourApp.MdesCustomerClient.Client.Configuration Configuration {get; set;}

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public YourApp.MdesCustomerClient.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Gets the default header.
        /// </summary>
        /// <returns>Dictionary of HTTP header</returns>
        [Obsolete("DefaultHeader is deprecated, please use Configuration.DefaultHeader instead.")]
        public IDictionary<String, String> DefaultHeader()
        {
            return new ReadOnlyDictionary<string, string>(this.Configuration.DefaultHeader);
        }

        /// <summary>
        /// Add default header.
        /// </summary>
        /// <param name="key">Header field name.</param>
        /// <param name="value">Header field value.</param>
        /// <returns></returns>
        [Obsolete("AddDefaultHeader is deprecated, please use Configuration.AddDefaultHeader instead.")]
        public void AddDefaultHeader(string key, string value)
        {
            this.Configuration.AddDefaultHeader(key, value);
        }

        /// <summary>
        ///  Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>SystemStatusResponseSchema</returns>
        public SystemStatusResponseSchema SystemstatusGet ()
        {
             ApiResponse<SystemStatusResponseSchema> localVarResponse = SystemstatusGetWithHttpInfo();
             return localVarResponse.Data;
        }

        /// <summary>
        ///  Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>ApiResponse of SystemStatusResponseSchema</returns>
        public ApiResponse< SystemStatusResponseSchema > SystemstatusGetWithHttpInfo ()
        {

            var localVarPath = "/systemstatus";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);



            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) this.Configuration.ApiClient.CallApi(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SystemstatusGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<SystemStatusResponseSchema>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (SystemStatusResponseSchema) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(SystemStatusResponseSchema)));
        }

        /// <summary>
        ///  Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>Task of SystemStatusResponseSchema</returns>
        public async System.Threading.Tasks.Task<SystemStatusResponseSchema> SystemstatusGetAsync ()
        {
             ApiResponse<SystemStatusResponseSchema> localVarResponse = await SystemstatusGetAsyncWithHttpInfo();
             return localVarResponse.Data;

        }

        /// <summary>
        ///  Returns the overall system status of the Mastercard Digital Enablement Service.
        /// </summary>
        /// <exception cref="YourApp.MdesCustomerClient.Client.ApiException">Thrown when fails to make API call</exception>
        /// <returns>Task of ApiResponse (SystemStatusResponseSchema)</returns>
        public async System.Threading.Tasks.Task<ApiResponse<SystemStatusResponseSchema>> SystemstatusGetAsyncWithHttpInfo ()
        {

            var localVarPath = "/systemstatus";
            var localVarPathParams = new Dictionary<String, String>();
            var localVarQueryParams = new List<KeyValuePair<String, String>>();
            var localVarHeaderParams = new Dictionary<String, String>(this.Configuration.DefaultHeader);
            var localVarFormParams = new Dictionary<String, String>();
            var localVarFileParams = new Dictionary<String, FileParameter>();
            Object localVarPostBody = null;

            // to determine the Content-Type header
            String[] localVarHttpContentTypes = new String[] {
            };
            String localVarHttpContentType = this.Configuration.ApiClient.SelectHeaderContentType(localVarHttpContentTypes);

            // to determine the Accept header
            String[] localVarHttpHeaderAccepts = new String[] {
                "application/json"
            };
            String localVarHttpHeaderAccept = this.Configuration.ApiClient.SelectHeaderAccept(localVarHttpHeaderAccepts);
            if (localVarHttpHeaderAccept != null)
                localVarHeaderParams.Add("Accept", localVarHttpHeaderAccept);



            // make the HTTP request
            IRestResponse localVarResponse = (IRestResponse) await this.Configuration.ApiClient.CallApiAsync(localVarPath,
                Method.GET, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarFileParams,
                localVarPathParams, localVarHttpContentType);

            int localVarStatusCode = (int) localVarResponse.StatusCode;

            if (ExceptionFactory != null)
            {
                Exception exception = ExceptionFactory("SystemstatusGet", localVarResponse);
                if (exception != null) throw exception;
            }

            return new ApiResponse<SystemStatusResponseSchema>(localVarStatusCode,
                localVarResponse.Headers.ToDictionary(x => x.Name, x => x.Value.ToString()),
                (SystemStatusResponseSchema) this.Configuration.ApiClient.Deserialize(localVarResponse, typeof(SystemStatusResponseSchema)));
        }

    }
}
