/**
 * @file process/RouterInitializer.cpp
 * @date Created <2014-03-22 00:40:06>
 *
 * This file is generated by generators/router_initializer.rb from config file
 * generators/router_initializer.yml. Do not edit this file directly. Please read
 * the config file, update options there and re-run the ruby script to
 * update this file.
 */

#include "RouterInitializer.h"
#include <util/driver/ActionHandler.h>

#include <memory> // for std::auto_ptr

#include "controllers/CommandsController.h"
#include "controllers/DocumentsController.h"
#include "controllers/StatusController.h"
#include "controllers/CollectionController.h"

namespace sf1r
{

void initializeDriverRouter(::izenelib::driver::Router& router, IService* service, bool enableTest)
{
    {
        CommandsController commands;
        const std::string controllerName("commands");
        typedef ::izenelib::driver::ActionHandler<CommandsController> handler_type;
        typedef std::auto_ptr<handler_type> handler_ptr;

        handler_ptr indexHandler(
            new handler_type(
                commands,
                &CommandsController::index
            )
        );

        router.map(
            controllerName,
            "index",
            indexHandler.get()
        );
        indexHandler.release();

        handler_ptr miningHandler(
            new handler_type(
                commands,
                &CommandsController::mining
            )
        );

        router.map(
            controllerName,
            "mining",
            miningHandler.get()
        );
        miningHandler.release();

        handler_ptr optimize_indexHandler(
            new handler_type(
                commands,
                &CommandsController::optimize_index
            )
        );

        router.map(
            controllerName,
            "optimize_index",
            optimize_indexHandler.get()
        );
        optimize_indexHandler.release();

        handler_ptr train_ctr_modelHandler(
            new handler_type(
                commands,
                &CommandsController::train_ctr_model
            )
        );

        router.map(
            controllerName,
            "train_ctr_model",
            train_ctr_modelHandler.get()
        );
        train_ctr_modelHandler.release();
    }

    {
        DocumentsController documents;
        const std::string controllerName("documents");
        typedef ::izenelib::driver::ActionHandler<DocumentsController> handler_type;
        typedef std::auto_ptr<handler_type> handler_ptr;

        handler_ptr createHandler(
            new handler_type(
                documents,
                &DocumentsController::create
            )
        );

        router.map(
            controllerName,
            "create",
            createHandler.get()
        );
        createHandler.release();

        handler_ptr destroyHandler(
            new handler_type(
                documents,
                &DocumentsController::destroy
            )
        );

        router.map(
            controllerName,
            "destroy",
            destroyHandler.get()
        );
        destroyHandler.release();

        handler_ptr getHandler(
            new handler_type(
                documents,
                &DocumentsController::get
            )
        );

        router.map(
            controllerName,
            "get",
            getHandler.get()
        );
        getHandler.release();

        handler_ptr get_doc_countHandler(
            new handler_type(
                documents,
                &DocumentsController::get_doc_count
            )
        );

        router.map(
            controllerName,
            "get_doc_count",
            get_doc_countHandler.get()
        );
        get_doc_countHandler.release();

        handler_ptr get_freq_group_labelsHandler(
            new handler_type(
                documents,
                &DocumentsController::get_freq_group_labels
            )
        );

        router.map(
            controllerName,
            "get_freq_group_labels",
            get_freq_group_labelsHandler.get()
        );
        get_freq_group_labelsHandler.release();

        handler_ptr get_key_countHandler(
            new handler_type(
                documents,
                &DocumentsController::get_key_count
            )
        );

        router.map(
            controllerName,
            "get_key_count",
            get_key_countHandler.get()
        );
        get_key_countHandler.release();

        handler_ptr indexHandler(
            new handler_type(
                documents,
                &DocumentsController::index
            )
        );

        router.map(
            controllerName,
            "index",
            indexHandler.get()
        );
        indexHandler.release();

        handler_ptr log_group_labelHandler(
            new handler_type(
                documents,
                &DocumentsController::log_group_label
            )
        );

        router.map(
            controllerName,
            "log_group_label",
            log_group_labelHandler.get()
        );
        log_group_labelHandler.release();

        handler_ptr searchHandler(
            new handler_type(
                documents,
                &DocumentsController::search
            )
        );

        router.map(
            controllerName,
            "search",
            searchHandler.get()
        );
        searchHandler.release();

        handler_ptr set_top_group_labelHandler(
            new handler_type(
                documents,
                &DocumentsController::set_top_group_label
            )
        );

        router.map(
            controllerName,
            "set_top_group_label",
            set_top_group_labelHandler.get()
        );
        set_top_group_labelHandler.release();

        handler_ptr updateHandler(
            new handler_type(
                documents,
                &DocumentsController::update
            )
        );

        router.map(
            controllerName,
            "update",
            updateHandler.get()
        );
        updateHandler.release();

        handler_ptr update_inplaceHandler(
            new handler_type(
                documents,
                &DocumentsController::update_inplace
            )
        );

        router.map(
            controllerName,
            "update_inplace",
            update_inplaceHandler.get()
        );
        update_inplaceHandler.release();

        handler_ptr visitHandler(
            new handler_type(
                documents,
                &DocumentsController::visit
            )
        );

        router.map(
            controllerName,
            "visit",
            visitHandler.get()
        );
        visitHandler.release();
    }

    {
        StatusController status;
        const std::string controllerName("status");
        typedef ::izenelib::driver::ActionHandler<StatusController> handler_type;
        typedef std::auto_ptr<handler_type> handler_ptr;

        handler_ptr get_distribute_statusHandler(
            new handler_type(
                status,
                &StatusController::get_distribute_status
            )
        );

        router.map(
            controllerName,
            "get_distribute_status",
            get_distribute_statusHandler.get()
        );
        get_distribute_statusHandler.release();

        handler_ptr indexHandler(
            new handler_type(
                status,
                &StatusController::index
            )
        );

        router.map(
            controllerName,
            "index",
            indexHandler.get()
        );
        indexHandler.release();
    }

    {
        CollectionController collection;
        const std::string controllerName("collection");
        typedef ::izenelib::driver::ActionHandler<CollectionController> handler_type;
        typedef std::auto_ptr<handler_type> handler_ptr;

        handler_ptr add_sharding_nodesHandler(
            new handler_type(
                collection,
                &CollectionController::add_sharding_nodes
            )
        );

        router.map(
            controllerName,
            "add_sharding_nodes",
            add_sharding_nodesHandler.get()
        );
        add_sharding_nodesHandler.release();

        handler_ptr backup_allHandler(
            new handler_type(
                collection,
                &CollectionController::backup_all
            )
        );

        router.map(
            controllerName,
            "backup_all",
            backup_allHandler.get()
        );
        backup_allHandler.release();

        handler_ptr check_collectionHandler(
            new handler_type(
                collection,
                &CollectionController::check_collection
            )
        );

        router.map(
            controllerName,
            "check_collection",
            check_collectionHandler.get()
        );
        check_collectionHandler.release();

        handler_ptr create_collectionHandler(
            new handler_type(
                collection,
                &CollectionController::create_collection
            )
        );

        router.map(
            controllerName,
            "create_collection",
            create_collectionHandler.get()
        );
        create_collectionHandler.release();

        handler_ptr delete_collectionHandler(
            new handler_type(
                collection,
                &CollectionController::delete_collection
            )
        );

        router.map(
            controllerName,
            "delete_collection",
            delete_collectionHandler.get()
        );
        delete_collectionHandler.release();

        handler_ptr rebuild_collectionHandler(
            new handler_type(
                collection,
                &CollectionController::rebuild_collection
            )
        );

        router.map(
            controllerName,
            "rebuild_collection",
            rebuild_collectionHandler.get()
        );
        rebuild_collectionHandler.release();

        handler_ptr rebuild_from_scdHandler(
            new handler_type(
                collection,
                &CollectionController::rebuild_from_scd
            )
        );

        router.map(
            controllerName,
            "rebuild_from_scd",
            rebuild_from_scdHandler.get()
        );
        rebuild_from_scdHandler.release();

        handler_ptr start_collectionHandler(
            new handler_type(
                collection,
                &CollectionController::start_collection
            )
        );

        router.map(
            controllerName,
            "start_collection",
            start_collectionHandler.get()
        );
        start_collectionHandler.release();

        handler_ptr stop_collectionHandler(
            new handler_type(
                collection,
                &CollectionController::stop_collection
            )
        );

        router.map(
            controllerName,
            "stop_collection",
            stop_collectionHandler.get()
        );
        stop_collectionHandler.release();

        handler_ptr update_collection_confHandler(
            new handler_type(
                collection,
                &CollectionController::update_collection_conf
            )
        );

        router.map(
            controllerName,
            "update_collection_conf",
            update_collection_confHandler.get()
        );
        update_collection_confHandler.release();

        handler_ptr update_sharding_confHandler(
            new handler_type(
                collection,
                &CollectionController::update_sharding_conf
            )
        );

        router.map(
            controllerName,
            "update_sharding_conf",
            update_sharding_confHandler.get()
        );
        update_sharding_confHandler.release();
    }

}

} // namespace sf1r

