---
layout: post
title: "Progettare API interoperabili conformi alle linee guida AgID"
subtitle: "Guarda la registrazione del Community lab del 25 maggio e scopri uno strumento indispensabile per i servizi pubblici digitali"
date: 2022-05-30 10:00:00 +0200
tags: developers designers api interoperabilita
categories: news
author: Francesco Pognante
image: /assets/icons/logo-it.png
locale: it
---

API interoperabili e dove trovarle. Anzi, come progettarle. Lo ha spiegato bene **Roberto Polli**, *API Expert* del Dipartimento per la trasformazione digitale, durante il **Community lab del 25 maggio**. In questo articolo, una breve sintesi di com’è andata per chi non ha potuto partecipare o vuole rinfrescarsi la memoria.

Roberto ha strutturato il suo laboratorio come un vero e proprio workshop pratico, su come progettare **API interoperabili** e usare [API OAS Checker](https://italia.github.io/api-oas-checker/) per adeguarle alle Linee Guida AgID su [API](https://docs.italia.it/italia/piano-triennale-ict/lg-modellointeroperabilita-docs/) e [Sicurezza](https://docs.italia.it/AgID/documenti-in-consultazione/lg-sicurezza-interoperabilita-docs). Ha creato ad hoc un **caso di studio ipotetico**: una API che permette alle persone di **localizzare i defibrillatori** sul territorio nazionale e agli enti di gestirne l'elenco.

Tra i principali punti toccati: il processo e gli strumenti di progettazione, le modalità di documentazione.

Progettare API, ha spiegato il relatore, consiste in una **mappatura** su chi, che cosa, come e perché, effettuata tramite degli appositi *canvas* che definiscono il servizio e i suoi casi d'uso, individuano risorse e azioni secondo un approccio REST e descrivendo risorse ed azioni in OpenAPI.
Roberto si è soffermato su ognuno dei singoli aspetti sopra citati e ha poi illustrato come **descrivere API** nel dettaglio, usando i **metadati**: l’uso dei #/tags per raggruppare le varie operazioni e l’associazione con i "Goal" presenti nel canvas. Si è poi passati all’**autenticazione**, vedendo insieme esempi di schemi delle risorse, fino ad arrivare alle **API Operations**, per testare il funzionamento del servizio. E infine… i compiti a casa!

Se vuoi rivedere il laboratorio o hai perso la diretta, **[guarda la registrazione](https://www.youtube.com/watch?v=D-3t8h1E9yE)**.

Per accedere a tutti i materiali visti insieme, **[scarica la presentazione (PDF)](/assets/images/posts/2022-05-30/CommunityLab-2022-05-25.pdf)**.

Ti è piaciuto questo community lab? Resta in contatto su [Slack Developers](https://slack.developers.italia.it/) nel canale #api, iscriviti alla nostra [mailing list](https://developers.italia.it/it/contatti#mailing-list) e continua a seguirci sugli account Twitter di [Developers Italia](https://twitter.com/developersITA) e [Designers Italia](https://twitter.com/DesignersITA).
