---
layout: post
title: "Guida allo sviluppo e gestione di software libero"
subtitle: "Pubblicato il documento che insegna come utilizzare, sviluppare e gestire correttamente il software libero nella sfera pubblica"
date: 2022-04-05 10:00:00 +0200
tags: developers opensource 
categories: news
author: Francesco Pognante
image: /assets/icons/logo-it.png
locale: it
---
Con l’ultimo aggiornamento, Developers Italia ha [pubblicato su Docs Italia](https://docs.italia.it/italia/developers-italia/guida-sviluppo-gestione-software-libero/it/stabile/index.html) la versione completa della **Guida allo sviluppo e gestione di software libero**. 

La guida, realizzata da Developers Italia in collaborazione con la community, è una raccolta di buone pratiche utili a supportare le amministrazioni pubbliche nello sviluppo e gestione del software e delle politiche a esso connesse. È suddivisa in **tre capitoli**, dedicati alle specifiche categorie professionali che lavorano con il software della PA: i responsabili e le responsabili politiche, le amministratrici e gli amministratori pubblici, gli sviluppatori e le sviluppatrici. Ciascun capitolo contiene indicazioni e consigli pratici su **come gestire e sviluppare correttamente il software in modo aperto**, come adottarlo seguendo le buone pratiche e quali sono gli accorgimenti più importanti per il mondo pubblico.

## Perché una guida per il software libero

Il [Codice dell'Amministrazione Digitale](https://docs.italia.it/italia/piano-triennale-ict/codice-amministrazione-digitale-docs/it/v2021-07-30/index.html) (CAD) impone alle pubbliche amministrazioni di **adottare software libero ogni qual volta sia possibile**. L’eventuale non adozione deve essere adeguatamente motivata da un atto formale depositato e protocollato all’interno della «[valutazione comparativa](https://docs.italia.it/italia/developers-italia/lg-acquisizione-e-riuso-software-per-pa-docs/it/stabile/acquisizione-software/valutazione-comparativa.html)».
Lo scopo di questa guida è quindi aiutare le Pubbliche Amministrazioni italiane a rispettare questo requisito offrendo soluzioni pratiche apprese sul campo.

## Per le responsabili politiche e i responsabili politici

I soggetti coinvolti nella definizione delle politiche e delle regole applicate nello sviluppo di servizi e soluzioni software per la PA hanno la necessità di essere al corrente dei vantaggi e caratteristiche del software libero. Il [capitolo](https://docs.italia.it/italia/developers-italia/guida-sviluppo-gestione-software-libero/it/stabile/per-le-responsabili-politiche-e-i-responsabili-politici.html) dedicato illustra come gestire correttamente il software libero, quali sono i suoi requisiti di trasparenza, responsabilità e verificabilità e come metterli in pratica. 

## Per le amministratrici e gli amministratori

I referenti delle amministrazioni pubbliche per la gestione dei progetti  garantiscono l’esecuzione nel rispetto dei tempi e costi previsti, si relazionano con gli *stakeholder* e sono responsabili dei servizi pubblici una volta rilasciati. In questo [capitolo](https://docs.italia.it/italia/developers-italia/guida-sviluppo-gestione-software-libero/it/stabile/per-gli-amministratori-pubblici.html), la guida mostra  i vantaggi del modello open source per migliorare la qualità e la sicurezza dei prodotti finali e per ridurre costi e rischi. Questa sezione definisce le fasi di rilascio di un software open source, inclusa la scelta della piattaforma, e contiene indicazioni e modelli su come progettare l’interazione tra i vari *stakeholder*.

## Per le sviluppatrici e gli sviluppatori

Il lavoro di chi sviluppa software per la Pubblica Amministrazione ha un impatto diretto sulla qualità dei servizi offerti alla cittadinanza. La [sezione](https://docs.italia.it/italia/developers-italia/guida-sviluppo-gestione-software-libero/it/stabile/per-chi-sviluppa-il-software.html) della guida dedicata a queste figure professionali mostra come preparare il codice a contributi esterni, come aiutare a diminuire il debito tecnico e come imparare a mantenere il codice sotto controllo di versione grazie a degli strumenti di test automatizzati, la nota [Continuous Integration](https://medium.com/@Developers_Italia/come-e-perch%C3%A9-automatizzare-il-controllo-qualit%C3%A0-nello-sviluppo-software-aab21cf72751).

## Per contribuire

La guida è disponibile e consultabile liberamente su [Docs Italia](https://docs.italia.it/italia/developers-italia/guida-sviluppo-gestione-software-libero/it/stabile/index.html): qualsiasi contributo è benvenuto! Se vuoi parlarne, unisciti alla conversazione su [Forum Italia](https://forum.italia.it/c/software-open-source-per-la-pa/49) o invia i tuoi suggerimenti direttamente su [GitHub](https://github.com/italia/guida-sviluppo-gestione-software-libero).


Il Team di Developers Italia

