---
layout: post
title: "Progettare servizi pubblici basati su API"
subtitle: Il racconto della Community call del 27 ottobre e le esperienze dei partecipanti
date: 2021-11-03 13:00:00 +0200
tags: developers designers api
categories: news
author: Francesco Pognante
image: /assets/icons/logo-it.png
locale: it
---
**Mercoledì 27 ottobre** si è tenuta la community call di Developers Italia e
Designers Italia, l’appuntamento mensile volto a condividere conoscenze, risorse
ed esperienze nella progettazione e realizzazione di servizi pubblici e privati.

Al centro dell'incontro, che questa volta ha visto la partecipazione di **oltre
100 sviluppatori e designers**, l’esperienza di chi, nel settore pubblico, ha
sviluppato servizi significativi basati su API.

Tra i protagonisti che sono intervenuti Roberto Polli, che segue il tema API e
interoperabilità fin dagli albori del Team Digitale. Roberto ci ha presentato il
[Verificatore per le API
REST](https://medium.com/@Developers_Italia/openapi-checker-il-verificatore-delle-interfacce-digitali-api-1d50b978c8c5){:target="_blank"},
uno strumento che supporta gli enti pubblici nell'adozione delle [Linee guida
sull’interoperabilità
tecnica](https://docs.italia.it/italia/piano-triennale-ict/lg-modellointeroperabilita-docs/it/bozza/index.html){:target="_blank"},
elaborate da Agid in collaborazione con il Dipartimento per la trasformazione
digitale e Developers Italia.

È poi intervenuto Emiliano Verga di Cefriel, coordinatore scientifico
dell’Ecosistema Digitale E015 della **Regione Lombardia**. Si tratta di un
ambiente digitale, originariamente nato in occasione di Expo 2015, basato su un
insieme di regole e processi che favoriscono l’incontro tra domanda e offerta di
API tra soggetti pubblici e privati in diversi settori: turismo, mobilità
sostenibile, ambiente, sicurezza e sanità.

A seguire Walter Manni, Celestina Paglia (Dipartimento di Web Strategies,
Research & Innovation dell’Azienda Promozione Turismo della Regione
**Emilia-Romagna**) e Stefano Vena (Altrama s.r.l.) ci hanno parlato della
realizzazione del servizio di condivisione di informazioni contenuto nel
**portale turistico della Regione** tramite API. Uno strumento che ha consentito
di semplificare la gestione e il trasferimento delle informazioni ai vari punti
di pubblicazione locali.

Chiara Veninata (Ministero della Cultura), e Luigi Asprino (UniBo), hanno poi
descritto il progetto ArCo, una API che permette di accedere a una base di
conoscenza contenente informazioni su 2.6M di opere del Catalogo generale dei
beni culturali Italiani.

Tra gli speaker anche Francesco Azzola, Technical Project Manager in Umbria
Digitale, società in house della **Regione Umbria**, che ha realizzato una
**dashboard regionale per monitorare i casi Covid** e le vaccinazioni
somministrate. Ha inoltre elaborato una API pubblica per l’esposizione dei dati
sulle infezioni registrate.

Sono infine intervenuti Valentino Lauciani, tecnico informatico all’INGV -
Istituto Nazionale di Geofisica e Vulcanologia, che ha implementato il servizio
per l’accesso ai dati degli **eventi sismici in Italia** e nel mondo e Maurizio
Ambrosanio (Agenzia delle entrate) e Umberto Principi, (Sogei), autore del
servizio di consultazione della **cartografia catastale**.

In conclusione, come di consueto, uno spazio per le domande dei partecipanti
ricco di spunti e riflessioni.

Se vuoi approfondire, [scarica la presentazione condivisa](/assets/images/posts/2021-11-03/27102021_Community_Call_Developers_Italia.pdf)
e [guarda il video](https://www.youtube.com/watch?v=aTBPk56SK3I){:target="_blank"}
dell’incontro sul canale YouTube del Dipartimento per la trasformazione
digitale.

**Resta in contatto con la community**: raccontaci su
[slack](https://app.slack.com/client/T6C27AXE0/CDKBYTG74){:target="_blank"}
(#api), via mail ([contatti@developers.italia.it](mailto:contatti@developers.italia.it))
o su [Forum Italia (Piano Triennale - Interoperabilità)](https://forum.italia.it/c/piano-triennale/interoperabilita/12){:target="_blank"}
altre API sviluppate secondo il modello di interoperabilità, per arricchire il
catalogo di Developers Italia a beneficio di tutti!
Oppure, segnalaci servizi basati su API che ritieni ad alto impatto per
il numero di enti o casi d’uso che potrebbero beneficiarne.

È già il momento di annunciare la prossima data: **le community call tornano il
24 novembre**. Ti aspettiamo!

Il team di Developers Italia e Designers Italia
