---
layout: post
title: "Community lab: a che punto siamo con UI kit e design token?"
subtitle: "Nell’appuntamento del 20 aprile, gli esperti di Designers Italia hanno mostrato gli sviluppi sulla migrazione dello UI kit a Figma e l’implementazione dei design token"
date: 2022-05-03 10:00:00 +0200
tags: developers designers designsystem opensource
categories: news
author: Michela Gabrieli
image: /assets/icons/logo-it.png
locale: it
---
Continuano i lavori per il *design system* del Paese, lo strumento che raggruppa i principi e le risorse per semplificare e rendere più facile, economica ed efficace la progettazione e lo sviluppo di servizi più semplici, accessibili, equi e inclusivi.

Nell’ultimo Community lab, il nostro appuntamento rivolto alle figure tecniche si occupano di trasformazione digitale della PA, Stefania Guerra, Francesco Improta e Daniele Tabellini, esperti di UI/UX design nel Dipartimento per la trasformazione digitale, hanno mostrato lo stato dei lavori su due fronti molto importanti: la **migrazione a Figma dello UI kit**, la raccolta di componenti riutilizzabili per progettare interfacce, e l’**implementazione dei design token**, uno strumento che facilita la collaborazione fra chi progetta e chi sviluppa.

Partiamo dalla prima novità. Secondo il [Design Tools Survey 2021](https://uxtools.co/survey-2021/), Figma è oggi lo strumento più utilizzato dai designer nel mondo. Negli ultimi anni, Figma è diventato uno strumento indispensabile nel flusso di lavoro di designer e sviluppatori, grazie alle sue funzionalità avanzate di progettazione e collaborazione in tempo reale. Stefania Guerra ha raccontato quindi la necessità di **migrare da Sketch a Figma** lo UI kit, riprogettando i componenti per sfruttare tutte le funzionalità native come *auto layout e variant*. Mantenendo  l’approccio aperto alla progettazione che ha sempre contraddistinto Designers Italia, lo UI kit sarà utilizzabile anche su Sketch e Adobe XD, grazie a un’esportazione dedicata disponibile su GitHub.

Nella seconda parte dell’incontro, Francesco Improta si è soffermato sull'implementazione dei design token. I **design token** sono *variabili che contengono tutte le informazioni alla base del *design system**, come colori, tipografia, spaziature, stili e animazioni. Provando a immaginarli, i *design token* possono essere considerati come dei veri e propri mattoncini alla base delle interfacce. Il loro beneficio principale è quindi assicurare una maggiore coerenza nella progettazione e sviluppo di interfacce digitali. Oltre a migliorare la progettazione delle interfacce, i *design token* hanno anche un impatto positivo per chi lavora al codice: permettono, infatti, di *sincronizzare lo UI kit con i componenti sviluppati* favorendo la collaborazione fra le persone impegnate nella progettazione e nello sviluppo, creando un *linguaggio comune condiviso*.

Come in ogni progetto di Designers Italia e Developers Italia, aspettiamo il fondamentale contributo della community.
Se vuoi contribuire, puoi farlo seguendo e commentando pubblicamente i lavori in corso sul nuovo UI kit (attualmente alla versione 3.0.0-alpha.1), direttamente nello spazio in basso nella [pagina dedicata](https://www.figma.com/community/file/1098285931334972883) o in un punto esatto nel file. Oppure puoi [duplicare il file](https://www.figma.com/community/file/1098285931334972883) per provarlo e poi scriverci nel canale [#design-ui-kit](https://developersitalia.slack.com/archives/C9N62GX8E) di Slack.

Ti ricordiamo che puoi rivedere il [video completo del community lab](https://www.youtube.com/watch?v=1UKjfSyox-k)
sul canale YouTube del Dipartimento per la trasformazione digitale e [scaricare la presentazione](/assets/images/posts/2022-05-03/200422_Community_lab.pdf).

Per saperne di più resta in contatto su [Slack](https://slack.developers.italia.it/), continua a seguirci sui canali Twitter di [Designers Italia](https://twitter.com/DesignersITA) e [Developers Italia](https://twitter.com/developersITA).
