---
layout: post
title:  Risultati della ricerca condotta con sviluppatori e progettisti di servizi pubblici digitali
subtitle: Gli utenti di Forum Italia e dei canali Slack di Developers Italia e Designers Italia al centro della nostra indagine.
date: 2021-03-01 10:00:00 +0100
tags: community sviluppatori developers opensource software designers
categories: news
author: Michela Gabrieli
image: /assets/icons/logo-it.png
locale: it
ref:
  en:
redirect_from:
   -
---

Presentati i risultati della ricerca quali-quantitativa condotta con gli utenti
di [Forum Italia](https://forum.italia.it) e dei [canali Slack](https://slack.developers.italia.it) dedicati a progettisti e sviluppatori dei
servizi pubblici digitali del sistema Paese. Lo avevamo anticipato qualche
settimana fa [proprio su questo
sito](https://developers.italia.it/it/news/2020/12/15/al-via-survey-community)
e oggi condividiamo quanto emerso dal questionario anonimo, parte di
un’[iniziativa di
ricerca](https://medium.com/designers-italia/lavori-in-corso-designers-italia-si-mette-in-gioco-e-riparte-dalla-ricerca-f52884752bd)
più ampia.
Si tratta di un’analisi realizzata insieme al team di [Designers
Italia](https://designers.italia.it/) al fine di confermare l’efficacia delle
iniziative messe in campo per intercettare, con uno sguardo rivolto al futuro,
le necessità delle PA di fronte alle sfide della **transizione digitale**.
In particolare ci interessava delineare la **tipologia dei partecipanti** delle
community di Designers Italia e Developers Italia ed elaborare le informazioni
sulla **percezione attuale delle piattaforme e dei servizi offerti** al loro
interno. Non solo: valutare l’attuale **utilizzo e l’efficacia dei canali di
comunicazione** e partecipazione, **comprendere i bisogni degli utenti** per
indirizzare al meglio investimenti e progettualità future e infine raccogliere
informazioni sull’uso degli strumenti come i kit di Designers Italia, le Linee
Guida, il [Catalogo del riuso](https://developers.italia.it/it/software)
e i [software development kit
(SDK)](https://developers.italia.it/it/piattaforme). L’occasione è stata utile
anche per raccogliere la disponibilità e i contatti per ulteriori interviste
qualitative che proprio in questi giorni stiamo avviando.
In totale, nonostante il questionario fosse disponibile dal 15 al 29 dicembre,
e quindi nel pieno delle festività natalizie, sono state raccolte 329 risposte.

Riportiamo di seguiti i principali risultati emersi dalla ricerca e rimandiamo
per maggiori approfondimenti all’[esaustivo articolo](https://medium.com/designers-italia/il-valore-della-community-per-designers-italia-e-developers-italia-bd486dff2a6d) di Designers Italia (da cui
abbiamo tratto quanto segue), che ringraziamo per il prezioso aiuto e sostegno
in questa attività di ricerca.

### I protagonisti della community

L’analisi dei dati anagrafici ha restituito un’immagine abbastanza eterogenea
dei partecipanti, senza evidenziare particolari polarizzazioni. Rispetto
all’età media, ad esempio, in generale l’intervallo degli utenti rimane
compreso tra 16 e 80 anni, con una presenza più marcata di persone appartenenti
alla fascia racchiusa tra 36 e 60 anni (più del 60%).
Dal punto di vista del genere, i risultati del questionario rivelano una netta
prevalenza del maschile (80%) rispetto a quello femminile (16%), oltre a quello
di chi ha preferito non rispondere o ha indicato un genere non binario (4%). Il
dato sul titolo di studio conferma, inoltre, per l’intero campione un tasso di
scolarizzazione molto elevato: il 60% dichiara infatti di possedere almeno una
laurea, e il 37% almeno una licenza superiore.
Dal punto di vista professionale, i risultati attestano una community composta
in prevalenza da tecnici che si occupano di sviluppo (33%), seguiti dagli
occupati nell’ambito della progettazione di servizi digitali (16%). Una
discreta quota di figure professionali rimane in ogni caso ancorata al settore
della programmazione, con un decimo dell’intera community che dichiara di
occuparsi di amministrazione, e con due fasce, sensibilmente più ristrette, che
operano nei settori della comunicazione (4%) e della ricerca (3%). I dati
relativi alla localizzazione geografica dei partecipanti rileva una copertura
totale del territorio nazionale, con risposte provenienti da ogni regione
d’Italia.
Il questionario ha rilevato che circa la metà dei rispondenti lavora per la PA,
suddivisi principalmente tra dipendenti (uno su tre) e consulenti (uno su
cinque). Il 25% di chi dichiara di essere dipendente di una Pubblica
Amministrazione specifica di lavorare per un Comune, mentre si attestano
intorno al 15% i dipendenti di PA centrali, Università, enti di ricerca, scuole
e Regioni o Province autonome. Inoltre circa la metà dei consulenti che
collabora con una PA specifica di lavorare nel ruolo di fornitore tecnologico,
mentre uno su quattro dichiara di fornire supporto strategico. La rimanente
quota di partecipanti sottolinea, infine, di lavorare per una società in-house
oppure, in piccola parte, come freelance.

### Percezione delle piattaforme e dei servizi offerti alla community

Grazie a tecniche di analisi e di clustering, è stato possibile individuare una
serie di parole chiave utilizzate dai partecipanti per descrivere Designers
Italia e Developers Italia, sia in termini progettuali sia qualitativi. Ad
esempio le finalità di Developers Italia sono state indicate dai partecipanti
in maniera molto precisa, e rispondono agli obiettivi di:

* diffondere buone pratiche di progettazione/sviluppo di servizi;
* promuovere lo sviluppo e l’adozione di software open source all’interno della PA;
* promuovere la trasformazione culturale delle Pubbliche Amministrazioni;
* far risparmiare e migliorare la qualità complessiva del software;
* fornire soluzioni pronte all’uso per rispondere ai bisogni della PA;
* incrementare la trasparenza dell’azione amministrativa.

Developers Italia è descritto inoltre come “un progetto ambizioso”, che
favorisce le sinergie di più figure professionali, come la **collaborazione tra
designer e sviluppatori**. “Trasparenza”, “innovazione”, “apertura” e “qualità”
sono le parole utilizzate maggiormente per delineare le sue peculiarità
positive, mentre “confuso”, “ancora non consolidato” e “difficile da capire”
sono gli attributi che ne denotano le aree dove migliorare.
Si tratta di elementi rilevanti che ci aiutano a definire verso quale direzione
intraprendere azioni migliorative.

Le informazioni rilevate sono ancora tante e di sicuro interesse, per questo,
vi consigliamo nuovamente di approfondire leggendo l’[articolo di Designers
Italia](https://medium.com/designers-italia/il-valore-della-community-per-designers-italia-e-developers-italia-bd486dff2a6d).

Cogliamo questa occasione per ringraziare quanti hanno collaborato
all’indagine, offrendo il loro tempo e la loro disponibilità e speriamo, grazie
a quanto appreso, di poter concretizzare presto nuove attività a supporto della
community.

Non fai ancora parte della community di Developers Italia? Scopri [come partecipare](https://developers.italia.it/it/come-partecipo)!

Il Team Developers Italia
