---
layout: post
title: Disponibile la prima parte della “Guida allo sviluppo e gestione di software libero”
subtitle: Un documento di supporto per guidare in modo semplice e pratico l’adozione e il mantenimento di soluzioni open source
date: 2020-12-29 10:00:00 +0100
tags: community sviluppatori developers riuso opensource software
categories: news
author: Leonardo Favario
image: /assets/icons/logo-it.png
locale: it
ref:
  en:
redirect_from:
   -
---

Developers Italia continua a impegnarsi per mettere a disposizione della community sempre nuovi strumenti e risorse che supportino il lavoro delle Pubbliche Amministrazioni e rendano più semplice il processo di adozione e mantenimento di soluzioni open source. Proprio con questo spirito oggi rilasciamo il primo capitolo della **Guida allo sviluppo e gestione di software libero**. Con questo documento, rivolto a tecnici, amministratori, e decisori pubblici vogliamo aiutare tutti gli attori che ruotano intorno al software libero a comprendere e a realizzare appieno i vantaggi in termini di gestione, riduzione dei costi e miglioramento dei servizi di un corretto approccio open source. Tutto ciò accompagnato da indicazioni e consigli pratici per gestire e sviluppare correttamente il software in modo aperto. La guida contiene inoltre una raccolta di buone pratiche e riferimenti a risorse esterne utili per lo sviluppo di software più sicuro e di facile manutenzione.
 
A differenza delle Linee Guida ufficiali questa pubblicazione è scritta in forma di pillole operative per guidare le amministrazioni in modo semplice e pratico, e non ha carattere normativo.
 
La versione che pubblichiamo oggi, seppur revisionata e corretta, è solo una prima parte in forma di bozza: in perfetto stile “open source” la continueremo a sviluppare e migliorare collaborativamente e costantemente con i lettori e con tutti coloro che in futuro desidereranno offrire il loro contributo.

### Chi l’ha scritta?

La guida è frutto del lavoro di un anno delle esperienze del team di Developers Italia, del [Dipartimento della Trasformazione Digitale](https://innovazione.gov.it/it/chi-siamo/dipartimento/), per cristallizzare la conoscenza generata durante il lavoro di supporto alle Pubbliche Amministrazioni sia centrali che locali.

### Chi sono i protagonisti?

I protagonisti sono le Pubbliche Amministrazioni, e le buone pratiche che abbiamo imparato insieme attraverso le nostre attività di supporto. Per questo motivo la guida è strutturata secondo capitoli specifici dedicati proprio ai diversi profili professionali che potrebbero averne bisogno: decisori pubblici, funzionari pubblici e sviluppatori di servizi pubblici. È proprio a questi ultimi che si rivolge il primo capitolo che pubblichiamo oggi.

### Perché riteniamo sia utile?

Il [Codice dell’Amministrazione Digitale](https://docs.italia.it/italia/piano-triennale-ict/codice-amministrazione-digitale-docs/it/v2018-09-28/index.html) (CAD) impone l’utilizzo e lo sviluppo quasi esclusivo di software open source, e le [Linee Guida](https://docs.italia.it/italia/developers-italia/lg-acquisizione-e-riuso-software-per-pa-docs/it/stabile/index.html) pubblicate da AGID dettagliano ulteriormente questi requisiti, traducendoli in indicazioni normative che cercano di essere quanto più possibili concrete.

Tuttavia, tra le tante soluzioni presenti nel [Catalogo](https://developers.italia.it/it/software) che abbiamo analizzato in questi mesi, ve ne sono alcune che presentano caratteristiche degne di nota, permettendo di semplificare la manutenzione delle soluzioni, diminuire i costi di gestione e di sviluppo, e migliorare la qualità del software. Sviluppare un software in open source è di per sé un vantaggio, ma siamo convinti che farlo correttamente permetta di ottenere dei benefici più importanti in termini di resilienza, risparmio, e velocità di risoluzione dei problemi.

Siamo consci del fatto che i temi legati allo sviluppo e alla manutenzione del software possono risultare complessi e alle volte anche oscuri a chi non si occupa di programmazione. Allo stesso modo, lavorare con soggetti pubblici in un contesto composto di adempimenti normativi e stringenti regole tecniche può risultare sfidante per uno sviluppatore (o per un fornitore) abituato al mondo del privato.

Questo elaborato vuole dunque essere un supporto operativo sia per l’amministratore pubblico che per il tecnico, offrendo a entrambi uno sguardo più ampio per evidenziare i vantaggi di costruire un ecosistema open source vitale.

### Con quale spirito è stata stesa?

Lo abbiamo già detto, ma ci piace sottolinearlo nuovamente: il nostro intento è quello di supportare concretamente e operativamente le Pubbliche Amministrazioni a districarsi in un contesto nuovo e complesso, offrendo soluzioni pratiche apprese sul campo invece che liste di norme e adempimenti. Queste soluzioni sono studiate, appunto, per massimizzare la semplicità e l’efficacia in termini di creazione di ecosistemi aperti.

In altre parole, in questa guida abbiamo provato a fondere la nostra conoscenza in termini di open source con l’importante esperienza e i bisogni di un amministratore pubblico.

### Prossimi passi?

Oggi pubblichiamo il capitolo dedicato agli sviluppatori, a cui seguiranno gli altri capitoli nei prossimi mesi.
Ti chiediamo di leggere e aiutarci a evolvere il documento, solo così otterremo un risultato finale di sicura utilità. Se vorrai aiutarci ti ringraziamo fin da ora per il tuo tempo e i tuoi preziosi contributi.
[Scopri la guida su Docs Italia](https://docs.italia.it/italia/developers-italia/guida-sviluppo-gestione-software-libero/it/stabile/index.html), discutine con la community sul [Forum](https://forum.italia.it/c/software-open-source-per-la-pa/49) o proponi direttamente miglioramenti su [GitHub](https://github.com/italia/guida-sviluppo-gestione-software-libero).

Il Team Developers Italia
