---
layout: post
title: "Developers Italia: pioneering initiative for an independent and competitive digital Europe"
subtitle: European Commission study highlights the impact of open source software and hardware on the EU economy
date: 2021-09-29 10:00:00 +0200
tags: developers designers opensource riuso
categories: news
author: Francesco Pognante
image: /assets/icons/logo-it.png
ref:
  it: /it/news/2021/09/29/developers-italia-pioniera-europa-competitiva
locale: en
---

**Developers Italia** is one of the strategic initiatives for the promotion of open source public policies in Europe. A [European Commission study](https://digital-strategy.ec.europa.eu/en/library/study-about-impact-open-source-software-and-hardware-technological-independence-competitiveness-and), published by [DG CONNECT](https://ec.europa.eu/info/departments/communications-networks-content-and-technology_en), shows that open source plays a key role in European development. Using only open source software instead of proprietary software can foster the independence of the public sector in the EU, reducing costs and limiting the lock-in. Therefore, according to the Commission, **open source is the key to a more autonomous and technologically sovereign European Union**.

The figures speak volumes: according to the study, in 2018, companies located in the EU area invested around €1 billion in open source software (OSS), resulting in an impact on the eurozone economy estimated at between €65 and 95 billion. In addition, a 10% increase in OSS investment could contribute to the creation of more than 600 new start-ups in the EU, generating a GDP increase of €100 billion.

Moreover, due to the generation of know-how and increased competitiveness in general, the study estimates that every euro invested in open source development generates a GDP benefit of at least four euros.

In light of these data, the study contains recommendations for European countries to further promote open source both at a political and economic level. Italy has not stood idle: in our country, **the point of reference for Public Administration software is Developers Italia**, thanks to which the provisions of the [Digital Administration Code](https://www.agid.gov.it/it/agenzia/strategia-quadro-normativo/codice-amministrazione-digitale) on open source find concrete support.

Developers Italia's role as a strategic control room for Public Administration software will be central to ensuring quality and compliance with European best practices, including investment in open source, during the software selection or creation phases of projects under the PNRR.

We are proud of what we have done so far and look forward to an increasingly "Open" future.

Read [the full article](https://innovazione.gov.it/notizie/articoli/il-valore-dell-open-source-per-un-europa-digitale-indipendente-e-competitiva/) on the Department for digital transformation website.
