---
title: Designers Italia
subtitle: Il design system della Pubblica Amministrazione italiana
logo: /assets/images/logo-design@2x.png
external_website: https://designers.italia.it
payoff: Per semplificare la vita delle persone
description: "Designers Italia è il punto di riferimento per la progettazione dei servizi pubblici digitali: guide, strumenti, un design system e una community per facilitare processi di design centrati sui bisogni delle persone"
lang: it
ref:
  en: /en/designers
order: 4
highlight: false
comingsoon: false
layout: platform
github_team: design
socials:
  -
    name: twitter
    icon: twitter
    link: //twitter.com/DesignersITA
  -
    name: medium
    icon: medium
    link: //medium.com/designers-italia
resources:
  - Il design system del paese:
    - title: Il design system del Paese
      desc: L’insieme di indicazioni e risorse per realizzare siti e servizi pubblici di qualità, efficienti e accessibili
      url: https://designers.italia.it/design-system/
      icon: designers-italia
    - title: Come iniziare
      desc: "Dai primi passi da compiere per progettare con il design system e lo UI kit in Figma e Sketch, alle librerie di sviluppo"
      icon: designers-italia
      url: https://designers.italia.it/design-system/come-iniziare/
    - title: UI kit
      url: https://github.com/italia/design-ui-kit
      desc: "È disponibile la libreria Figma e la conversione in Sketch"
      icon: github
    - title: Anteprima UI Kit su Figma
      desc: Se vuoi vedere tutti i componenti prima di usarli
      url: https://www.figma.com/community/file/1105848677422572920/ui-kit-italia-v3-2-0
      icon: pencil
    - title: Repository Bootstrap Italia
      desc: "La libreria Bootstrap Italia è il modo più semplice e sicuro per costruire interfacce web moderne, inclusive e semplici da mantenere."
      url: https://github.com/italia/bootstrap-italia/
      icon: github
    - title: Repository React Design Kit
      desc: "Un set di componenti open-source per React, costruito sulle basi dello UI Kit e della libreria Bootstrap Italia"
      url: https://github.com/italia/design-react-kit
      icon: github
    - title: Repository Angular Design Kit
      desc: "Un set di componenti open-source per Angular, costruito sulle basi dello UI Kit e della libreria Bootstrap Italia"
      url: https://github.com/italia/design-angular-kit
      icon: github
  - Modello di sito e servizi comunali:
    - title: Modello di sito di un Comune su Designers Italia
      desc: "Modello di sito web, l'architettura dell'informazione, i template grafici e HTML, i CMS gratis e a disposizione di tutti"
      url: https://designers.italia.it/modelli/comuni/
      icon: designers-italia
    - title: Template HTML per il sito del Comune
      url: https://github.com/italia/design-comuni-pagine-statiche
      icon: github
    - title: Repository completa del progetto sito web per i Comuni
      url: https://github.com/italia/design-comuni-prototipi
      icon: github
    - title: Documentazione del progetto sito web per i Comuni
      url: https://docs.italia.it/italia/designers-italia/design-comuni-docs/
      icon: file
  - Il sito web di una scuola:
    - title: Il sito web di una scuola su Designers Italia
      desc: "Modello di sito web e template CMS per i siti scolastici, gratis e a disposizione di tutti"
      url: https://designers.italia.it/kit/scuole/
      icon: designers-italia
    - title: Tema Wordpress per il sito web della scuola
      url: https://github.com/italia/design-scuole-wordpress-theme
      icon: github
    - title: Template HTML per il sito web della scuola
      url: https://github.com/italia/design-scuole-pagine-statiche/
      icon: github
    - title: Documentazione del progetto sito web per le scuole
      url: https://docs.italia.it/italia/designers-italia/design-scuole-docs/
      icon: file

redirect_from:
  - /it/design
---

## Intro

In questa pagina presentiamo il *design system* realizzato per la Pubblica Amministrazione italiana e gli strumenti di Designers Italia a disposizione degli sviluppatori.

L’obiettivo è aiutare la Pubblica Amministrazione a risparmiare tempo e risorse, grazie a una **serie di strumenti per la progettazione e lo sviluppo di siti e servizi pubblici digitali** a misura di cittadino, che possano essere allo stesso tempo moderni, efficaci, inclusivi e facilmente manutenibili. Alcuni di questi progetti sono già attivi, altri sono visionabili nel [piano attività](https://designers.italia.it/community/piano-attivita/){:target="_blank"}. Per rimanere aggiornato con l'evoluzione dei progetti e gli eventi della community, ti raccomandiamo di registrarti alla newsletter di [Designers Italia](https://designers.italia.it/#iscrivitiNewsletter){:target="_blank"}

Il sito [designers.italia.it](https://designers.italia.it/){:target="_blank"} contiene:

* i riferimenti alla versione corrente delle [Linee Guida di Design](https://designers.italia.it/guide/){:target="_blank"}.
* i [modelli di sito e dei servizi per alcuni enti pubblici](https://designers.italia.it/modelli/){:target="_blank"}, come comuni, scuole, aziende sanitarie locali e musei civici.
* il [design system del Paese](https://designers.italia.it/design-system/), che include i fondamenti, le componenti, i pattern e la loro anteprima per la progettazione e lo sviluppo.
* una serie di [risorse per la progettazione dei servizi pubblici digitali della Pubblica Amministrazione](https://designers.italia.it/risorse-per-progettare/){:target="_blank"}.
* il collegamento al blog [Medium di Designers Italia](https://designers.italia.it/blog/){:target="_blank"} che ospita casi d'uso e applicazioni di successo del *design system* per la Pubblica Amministrazione.
* il [piano attività aggiornato al 2022](https://designers.italia.it/piano-attivita/), contenente una roadmap delle attività e i principali risultati raggiunti dal progetto Designers Italia negli ultimi anni, con uno sguardo rivolto ad azioni e obiettivi futuri.

Il codice sorgente del sito si trova in un [repository GitHub](https://github.com/italia/designers.italia.it){:target="_blank"}
aperto a ogni tipo di contributo.

# Design system

A partire dal 2022, un design sistem unitario e coerente è stato stabilito, costruendo sulle librerie esistenti ed evolvendo i seguenti kit:
* [Introduzione al Design System](https://designers.italia.it/design-system/){:target="_blank"}.
* Guida a [come iniziare](https://designers.italia.it/){:target="_blank"}.
* [Modello di contribuzione](https://designers.italia.it/design-system/come-contribuire/){:target="_blank"}.
* [Fondamenti](https://designers.italia.it/design-system/fondamenti/){:target="_blank"};
* [Componenti](https://designers.italia.it/design-system/componenti/){:target="_blank"}.

## UI kit

Lo UI kit è fatto di **componenti visive già pronte** per assemblare l’interfaccia di un sito o di un app, seguendo le linee guida per i servizi digitali della Pubblica Amministrazione e le migliori buone pratiche di design più diffuse nel panorama nazionale e internazionale.

Il kit è costruito con Figma e **definito in maniera aperta e collaborativa su GitHub** insieme alla *community* dei designer. Le release dello UI kit sono esportate in Sketch per mantenere la compatibilità con formati aperti. Lo UI kit è il punto di riferimento per i componenti e i *pattern* di interfaccia utente destinati ad essere implementati con l'utilizzo dei kit di sviluppo web (Web Development Kit), mostrati di seguito.

* [Introduzione allo UI Kit](https://designers.italia.it/kit/ui-kit/){:target="_blank"};
* [tutti i componenti e i pattern dello UI Kit](https://invis.io/RJFGS2UC3HS){:target="_blank"};
* [repository GitHub](https://github.com/italia/design-ui-kit){:target="_blank"}.

Sono sempre più in crescita le Pubblica Amministrazioni che stanno utilizzando lo UI kit per definire le proprie interfacce. In partiocolare, il design system del Paese è utilizzato nei modelli per i [siti e servizi dei Comuni](https://designers.italia.it/modelli/comuni/){:target="_blank"} e per i [siti delle scuole](https://designers.italia.it/modelli/scuole/){:target="_blank"}, delle [aziende sanitarie locali (ASL)](https://designers.italia.it/modelli/aziende-sanitarie-locali/){:target="_blank"} e dei [musei civici](https://designers.italia.it/modelli/musei-civici/){:target="_blank"}.

Per domande e discussioni sullo UI Kit, sullo [Slack di Developers Italia](https://slack.developers.italia.it/){:target="_blank"} è disponibile e aperto a tutti il canale #design-system-ui-kit.

## Web Development Kit

I [Web Development Kit](https://designers.italia.it/kit/web-development-kit/){:target="_blank"} sono un insieme di strumenti per lo sviluppo front end di siti e applicazioni web. Sono librerie HTML, CSS e Javascript che permettono di **realizzare siti conformi alle Linee Guida di Design** e realizzano in codice quanto previsto dallo UI kit. Allo stato attuale, il kit per lo sviluppo web più stabile, aggiornato e maturo è Bootstrap Italia, basato sulla libreria *open source* Bootstrap 5. Tutte le librerie sono state incluse come parte del design system del paese a partire dal 2022.

### Bootstrap Italia

Il kit basato su Bootstrap 5 è il punto di riferimento per lo sviluppo dei progetti della Pubblica Amministrazione. Lo scopo principale è **mettere a disposizione della comunità di sviluppatori**, in coerenza con le [Linee guida di design per i siti internet e i servizi digitali della PA emanate, ex art.53 del CAD](https://docs.italia.it/italia/design/lg-design-servizi-web/it/versione-corrente/index.html){:target="_blank"}, la sintassi, gli strumenti, il parco di plugin e le convenzioni tipiche di uno strumento già conosciuto e utilizzato, quale appunto [Bootstrap 5](https://getbootstrap.com/){:target="_blank"}.

* [Documentazione di Bootstrap Italia](https://italia.github.io/bootstrap-italia/){:target="_blank"};
* [repository GitHub](https://github.com/italia/bootstrap-italia){:target="_blank"};
* [Bootstrap Italia Playground per iniziare ad usare Bootstrap Italia](https://github.com/italia/bootstrap-italia-playground){:target="_blank"};
* [esempio di template base da cui partire](https://italia.github.io/bootstrap-italia/docs/esempi/template-vuoto/){:target="_blank"}.

**Contribuisci alla crescita del design system del Paese:** per segnalare un sito, una app o un tema realizzato con Bootstrap Italia, [puoi aprire una issue](https://github.com/italia/bootstrap-italia/issues){:target="_blank"} sul repository di Bootstrap Italia o [scrivere un post sul forum](https://forum.italia.it/c/design/esempi-linee-guida){:target="_blank"}!

### Design React Kit

Il progetto ha come obiettivo quello di costruire un set di componenti ed un layer di presentazione comune basato su [React](https://github.com/facebook/react/){:target="_blank"}. Il focus del progetto, almeno in questa fase iniziale, sono le web app e/o le applicazioni mobile ibride basate su [React Native](https://facebook.github.io/react-native/){:target="_blank"}. Il React Kit è a guida community, e non è completo in quanto alcuni dei componenti presenti su Bootstrap Italia non sono ancora stati implementati.

* [Documentazione del Design React Kit](https://italia.github.io/design-react-kit/){:target="_blank"};
* [repository GitHub](https://github.com/italia/design-react-kit){:target="_blank"}.

### Design Angular Kit

il progetto ha come obiettivo quello di costruire un set di componenti ed un layer di presentazione comune basato su [Angular](https://angular.io/){:target="_blank"}. Il kit è sviluppato dalla community.

* [Design Angular Kit Documentation](https://italia.github.io/design-angular-kit/){:target="_blank"}
* [GitHub Repository](https://github.com/italia/design-angular-kit){:target="_blank"}

Ogni contributo a questi kit è benvenuto ed importante, anche se piccolo. [Scopri come contribuire](https://designers.italia.it/design-system/come-contribuire/) {:target="_blank"}con feedback, informazioni utili, segnalazioni di bug. 

## Kit deprecati

Il Web Toolkit è stato il primo progetto volto a supportare la creazione di siti della PA: diversi siti di ministeri lo stanno utilizzando. I feedback ricevuti sull'utilizzo di questo toolkit da enti e fornitori sono stati alla base della definzione tanto delle evoluzioni di Bootstrap Italia, quando del design system del Paese.

Per questa ragione non è più aggiornato dal 2017.

* [Web Toolkit Documentation](https://italia.github.io/design-web-toolkit/){:target="_blank"}
* [GitHub Repository](https://github.com/italia/design-web-toolkit){:target="_blank"}

## Altri kit utili

La realizzazione dell'interfaccia e dello sviluppo web sono soltanto una parte del processo di definizione di un servizio digitale. Designers Italia mette a disposizione **kit e strumenti che coprono tutte le fasi di progettazione di un servizio**, dall'organizzazione del progetto alla comprensione del contesto, dalla progettazione alla realizzazione e validazione delle soluzioni con gli utenti.

Per maggiori informazioni, puoi iniziare dalla pagina dei [kit sul sito di Designers Italia](https://designers.italia.it/kit/){:target="_blank"}.

# Canali

<a class="btn btn-primary" href="https://forum.italia.it/c/design" target="_blank"><svg class="icon icon-white p-1 mr-1"><use xlink:href="/assets/svg/sprite.svg#it-horn"></use></svg>
  Entra nel forum
</a>

Dialoga sullo [Slack di Developers Italia](https://slack.developers.italia.it/){:target="_blank"}:
sono disponibili diversi canali che iniziano con "#design-", in particolare
segnaliamo: [#design-service](https://developersitalia.slack.com/messages/C9HKFKU9J/){:target="_blank"},
[#design-ui-kit](https://developersitalia.slack.com/archives/C9N62GX8E),
[#design-dev](https://developersitalia.slack.com/archives/C7VPAUVB3),
[#design-siti-dei-comuni](https://developersitalia.slack.com/archives/CME9AD8NN)
e [#design-siti-scuole](https://developersitalia.slack.com/archives/CQ7J0KANT).
