---
title: dati.gov.it
subtitle: I dati aperti della pubblica amministrazione
logo: /assets/images/logo-dati.gov.it@2x.png
external_website: https://www.dati.gov.it
payoff: I dati aperti della pubblica amministrazione
description: >
  Dati.gov.it e’ il catalogo nazionale dei dati aperti delle pubbliche amministrazioni italiane. Nasce con l’obiettivo di aggregare in un unico portale la maggior parte dei dati aperti esposti dalle varie amministrazioni sia locali che nazionali.
lang: it
ref:
  en: /en/datigov
order: 4
highlight: false
comingsoon: false
layout: platform
github_team: datigov
socials:
  -
    name: twitter
    icon: twitter
    link: //twitter.com/datigovit
  -
    name: youtube
    icon: youtube
    link: //www.youtube.com/channel/UCHsqR2YhxeKgFT4rAKVcAAQ
---

## Intro
Trasparenza, riutilizzo, partecipazione sono alcune delle parole cardine che guidano il processo di apertura del dato e vengono ereditate dalla  comunità del software libero, che produce da anni un modello di sviluppo di codice software di alta qualità basato su principi di condivisione ed apertura.

Il nostro obiettivo è quello di **evolvere l’attuale portale online** da catalogo dei dati aperti ad un sistema che offra strumenti e servizi sviluppati in condivisione con la comunità che quindi ne estenda le potenzialità.

Come per tutti i progetti di Developers Italia, il portale dei dati aperti segue un modello di sviluppo basato su un **processo collaborativo** tipico delle comunità degli sviluppatori. Gli strumenti che vogliamo utilizzare per strutturare il processo di sviluppo sono:

 * Una roadmap di sviluppo agile e pubblica
 * Codice sorgente aperto fin dall’inizio
 * Un sistema di tracciamento degli errori pubblico
 * Documentazione del codice e delle API chiaro


## Documentazione

Qui puoi trovare la documentazione tecnica attualmente disponibile sia sul documento architetturale, sia sulle linee guida tecniche per i cataloghi dati che includono la specifica DCAT-AP_IT:

[Documento d'architettura dell'evoluzione di dati.gov.it](/assets/files/Architettura-Opendata.gov.it.odt){:target="_blank"}

[Le linee guida tecniche per i cataloghi dati](https://docs.italia.it/italia/daf/linee-guida-cataloghi-dati-dcat-ap-it/){:target="_blank"}


## Codice sorgente

Qui puoi trovare l'attuale codice sorgente basato su DKAN (Drupal), e a breve pubblicheremo un documento per aiutarti a
creare l'ambiente di sviluppo per contribuire:

[Repo GitHub attuale dati.gov.it](https://github.com/FormezPA/dkan){:target="_blank"}


Qui invece trovi i repositori relativi all'evoluzione di dati.gov.it come da documento architetturale:

[Repo GitHub evoluzione dati.gov.it](https://github.com/italia/dati.gov.it){:target="_blank"}

[Nuovo frontend server](https://github.com/italia/dati-frontendserver){:target="_blank"}


## Collaborazione

Abbiamo aperto già da tempo una mailing-list per trattare i temi di dati e opendata, per cui puoi trovare là
l'archivio delle precedenti discussioni e iscriverti per partecipare. Inoltre, abbiamo anche predisposto
un tracker pubblico su GitHub:

[Mailing-list OpenData & Analytics](https://groups.google.com/a/teamdigitale.governo.it/forum/#!forum/data){:target="_blank"}

[Issue tracking del progetto](https://github.com/italia/dati.gov.it/issues){:target="_blank"}

[Pianificazione dello sviluppo](https://github.com/italia/dati.gov.it/projects){:target="_blank"}
