---
title: IndicePA
subtitle: Index of the Public Administration (IPA)
logo: /assets/images/logo-indicepa.png
payoff: Index of addresses of public administrations and managers of public services
description: Database of national interest pursuant to Article 57-bis paragraph 1 of the Codice dell'Amministrazione Digitale.
lang: en
ref:
  it: /it/indicepa
order: 4
highlight: true
comingsoon: false
layout: platform
resources:
  - Documentation:
    - title: Home page
      url: https://indicepa.gov.it
      icon: file
      desc: Index page of the platform
    - title: Documentation
      url: https://indicepa.gov.it/documentale/n-documentazione.php
      icon: file
      desc: Platform documentation. The documentation includes both documents for end users and technical documentation of web services to build an integration with the platform.
  - Consult the data:
    - title: Open Data
      url: https://www.indicepa.gov.it/documentale/n-opendata.php
      icon: file
      desc: Access to platform data in Open Data format. The iPA adheres to the philosophy of open data and initiates a path based on access to public data without restrictions. The data is accessible from here and is saved using open formats.
    - title: Web Services
      url: https://www.indicepa.gov.it/documentale/n-webservices.php
      icon: file
      desc: Access data via web services. The web services published on iPA allow you to fetch some contents from the site. Here you can find the documentation and procedures for accessing the platform's web services.
    - title: LDAP Protocol
      url: https://www.indicepa.gov.it/documentale/n-gestioneutenti-ldap.php
      icon: file
      desc: Access to data via LDAP protocol. Here you will find the guides and processes to get access to platform data via LDAP.
---

## Intro
The Index of Public Administrations (IPA) is a public database of information provided by Public Administrations and by
Public Service Managers and aimed at disclosing:
* the certified email address of the Public Service Managers and Homogeneous Organizational Areas (protocol offices)
  of Public Administrations, to facilitate the exchange of electronic documents through official channels;
* the unique code that identifies the offices of the Public Administrations needed to send electronic invoices.

The IPA therefore represents a census of Public Administrations and Public Service Managers, accessible to
anyone, containing in addition to the aforementioned data (mandatory by law) also summary information on the entity
(address, tax code, legal representative, website, social channels, classification ...), on its organizational
structure (organization chart, offices, managers, addresses, telephone, email ...) and on the services provided
(description, delivery web channel, contact email ...).

IPA information is used for example as a reference by the Ministry of Economy and Finance for
the identification of the Public Administrations required to apply the split payment mechanism
referred to in article 17-ter of the d.P.R. 26 October 1972, n. 633 (Split-payment) and to feed the database
of Public Administrations (BDAP) for the monitoring of public finance trends.
