---
title: dati.gov.it
subtitle: The open data of the Public Administration
logo: /assets/images/logo-dati.gov.it@2x.png
external_website: https://www.dati.gov.it
payoff: The open data of the Public Administration
description: >
    Dati.gov.it is the national list of the open data of the Italian Public Administrations.  It has been created with the aim to aggregate in a single portal most of the open data displayed by the various administrations both local and national.
lang: en
ref:
  it: /it/datigov
order: 2
highlight: false
comingsoon: false
layout: platform
socials:
  -
    name: twitter
    icon: twitter
    link: //twitter.com/datigovit
  -
    name: youtube
    icon: youtube
    link: //www.youtube.com/channel/UCHsqR2YhxeKgFT4rAKVcAAQ
---

## Intro
Transparency, reuse and participation are some of the key words that guide the process of the opening of the data and they are inherited from the free software community, which produces for years a high quality software code development model based on the principles of sharing and openness.
Our aim is to evolve the current online portal of open data to a system that provides developed tools and services shared with the community to extend the potentialities.

As with all the projects of Developers Italia, the portal of open data follows a development model based on a collaborative process  which is typical of the community of developers. The tools that we want to use to structure the development process are:

  * A public development roadmap
  * Source code open from the start
  * A public tracking system of the errors
  * Clear documentation of the code and the API

## Documentation

Waiting for a publication of a further documentation concerning the project, in the meantime here you can find the architectural document:

[Architectural document for evolution of dati.gov.it (ITA)](/assets/files/Architettura-Opendata.gov.it.odt){:target="_blank"}


## Source code

Here you can find the actual source code based on DKAN (Drupal), and soon we will publish a document to help you to create the development environment to contribute:

[Repo GitHub for current dati.gov.it](https://github.com/FormezPA/dkan){:target="_blank"}

While here you can find the repositories related to the evolution of dati.gov.it according to the architectural document:

[Repo GitHub for evoution of dati.gov.it](https://github.com/italia/dati.gov.it){:target="_blank"}

[New frontend server](https://github.com/italia/dati-frontendserver){:target="_blank"}


## Collaboration

We have already open a mailing list to debate about data and open data, so there you can find the archive of previous discussions and you can sign up to participate. In addition, we have also arranged a public tracker on GitHub:

[Mailing-list OpenData & Analytics (ITA)](https://groups.google.com/a/teamdigitale.governo.it/forum/#!forum/data){:target="_blank"}

[Issue tracking](https://github.com/italia/dati.gov.it/issues){:target="_blank"}

[Development roadmap](https://github.com/italia/dati.gov.it/projects){:target="_blank"}
