# Contributing
When contributing to this repository, please first discuss the change you wish to make via issue before making a change.

You should also read up on this project's [code of conduct](https://github.com/is-a-dev/register/blob/main/CODE_OF_CONDUCT.md).

## Pull requests
- Adding, changing or removing a domain file you own.
- Fixing a bug in the scripts or CI.
- Fix an error in the documentation.

#### Domains
- Your pull request will be reviewed and merged into `main` branch.
- The records will be published as soon as the PR is merged.
- The changes should reflect soon after publishing.

## Issues
- **Report an abusive domain** - Create a new issue with the label `report-abuse`.
- **Report a problem with your domain** - Create a new issue with the label `support`.
- **Suggestions** - Create a new issue with the label `suggestion`.
- **For any questions** - Create a new issue with the label `question`.
- **Report any other issues related to this repository** - Create a new issue with any label that fits.
