# python script for loading auto generated by sample documents into
# ArangoDB database. Uses python-arango driver https://github.com/Joowani/python-arango
# By script loads json documents incrementing counter in id field. Document template is 
# loaded from specified file.
# Collection should be already created. DB server should be set up to run without authorization and
# on localhost:8529
import sys
import json  
from arango import ArangoClient

def main():
  if len(sys.argv) < 6:
    print("Usage: host database collection template_file number_of_copies\n Example: python BySampleLoader.py 'http://localhost:8529' _system persons person.json 10000000")
    return

  client = ArangoClient(hosts=sys.argv[1])
  db = client.db(sys.argv[2])
  collection = db.collection(sys.argv[3])
  line_limit = int(sys.argv[5]) # how many documents to upload
  batch_size = 20000    # batch size for inserting into Arango
  data = []
  total = 0
  template = ''
  with open(sys.argv[4]) as json_file:
    template = json.load(json_file);
  id_template = template['id']
  while total < line_limit:
    record = template.copy() 
    record['id'] = id_template + str(total)
    record['_key'] = record['id']
    data.append(record)
    if len(data) > batch_size:
      collection.insert_many(data)
      data.clear()
      print('Loaded ' + str(total) + ' ' + str( round((total/line_limit) * 100, 2)) +  '% \n')
    total = total + 1
  if len(data) > 0:
    collection.insert_many(data)
if __name__== "__main__":
  main()
  