// Copyright (C) 2019 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
#ifndef NORM2_NFKD_DATA_H_
#define NORM2_NFKD_DATA_H_

#include <boost/text/detail/normalization_table_data.hpp>


namespace boost { namespace text { namespace detail {

static const int32_t norm2_nfkc_data_indexes[normalization_table_data::total_indices]={
0x50,0x6980,0xd104,0xd204,0xd204,0xd204,0xd204,0xd204,0xa0,0xa0,0xaac,0x2958,0x6782,0xfc00,0x1252,0x6000,
0x65dc,0x6782,0x300,0
};

static const uint16_t norm2_nfkc_data_trieIndex[1839]={
0,0x40,0x7b,0xbb,0xfb,0x13b,0x17b,0x1b7,0x1f7,0x22b,0x259,0x292,0x2d2,0x312,0x351,0x391,
0x3d1,0x410,0x44d,0x48c,0x22b,0x22b,0x4c6,0x506,0x536,0x56e,0x22b,0x5ae,0x5dd,0x61c,0x22b,0x631,
0x66f,0x69d,0x22b,0x6ca,0x70a,0x747,0x767,0x7a6,0x7e5,0x822,0x841,0x87e,0x767,0x8b7,0x8e5,0x924,
0x22b,0x95e,0x975,0x9b5,0x9cc,0xa0b,0x22b,0xa41,0xa61,0xa9c,0xaa9,0xae3,0xb17,0xb54,0xb94,0xbce,
0xbe9,0x22b,0xc24,0xc32,0xc72,0xc91,0xcc7,0xd04,0x22b,0x22b,0x22b,0x22b,0x22b,0xd27,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0xd53,0x22b,0x22b,0xd88,
0x22b,0x22b,0xda6,0x22b,0xdd0,0x22b,0x22b,0x22b,0xe0c,0xe2c,0xe6c,0x22b,0xeaa,0xeea,0xf1e,0xf4a,
0x846,0x22b,0x22b,0xf7e,0xfb8,0xff8,0x1031,0x1071,0x10b1,0x10f1,0x1131,0x1171,0x11b1,0x11f1,0x1231,0x1271,
0x12b1,0x12f0,0x1330,0x1360,0x13a0,0x13e0,0x1420,0x1453,0x1490,0x14cf,0x150f,0x1545,0x1573,0x22b,0x22b,0x22b,
0x22b,0x159e,0x15de,0x161e,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x1652,0x165f,0x22b,0x1696,0x22b,0x22b,0x22b,0x22b,
0x22b,0x16b3,0x22b,0xd15,0x22b,0x16f1,0x22b,0x1731,0x22b,0x22b,0x1771,0x1791,0x17d1,0x1811,0x1851,0x1891,
0x18d1,0x190c,0x194a,0x198a,0x19ca,0x1a0a,0x1a4a,0x22b,0x1a8a,0x1aca,0x1b0a,0x1b4a,0x1b8a,0x1bca,0x1c0a,0x1c4a,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x1c8a,0x1cc8,0x1ce8,0x22b,0x1d1a,0x22b,0x1d4b,
0x1d85,0x22b,0x22b,0x1dc1,0x1df3,0x1e21,0x84a,0x1e34,0x22b,0x22b,0x1e44,0x1e84,0x22b,0x1ebb,0x22b,0x1d98,
0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,
0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,
0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,
0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,
0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,
0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,
0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,
0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,
0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,
0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,
0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f0f,0x1efb,0x1f03,0x1f0b,0x1f13,0x1eff,0x1f07,0x1f47,0x22b,
0x1f87,0x1fc4,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x2004,0x2044,0x2084,0x20c4,0x2104,0x2144,0x2184,0x21c4,0x2204,0x2244,0x2282,0x22b4,
0x22f4,0x2334,0x2374,0x23b4,0x23f4,0x2432,0x2472,0x24b2,0x24ef,0x252f,0x256f,0x25ae,0x25ed,0x262d,0x266d,0x26ac,
0x6af,0x6be,0x6d4,0x6f3,0x70d,0x70d,0x70d,0x711,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0xc24,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x58d,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x44a,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x26df,0x22b,0x22b,0x26ef,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0xe1e,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x26ff,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x2709,0x58d,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x829,0x22b,0x22b,0x9f8,0x22b,0x2719,
0x2726,0x2732,0x22b,0x22b,0x22b,0x22b,0x452,0x22b,0x273d,0x274d,0x22b,0x22b,0x22b,0x81e,0x22b,0x22b,
0x22b,0x22b,0x275d,0x22b,0x22b,0x22b,0x2768,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x276f,0x22b,0x22b,0x22b,0x22b,0x277a,0x2789,0x934,0x2797,0x450,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x27a5,0x7d6,0x22b,0x22b,0x22b,0x22b,0x22b,0x27b5,0x27c4,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x914,0x27cc,0x27dc,0x22b,0x22b,0x22b,0x9f8,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x27e6,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x824,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x27e3,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x82b,0x828,0x22b,0x22b,0x22b,0x22b,0x826,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x9f8,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0xc1e,0x22b,0x22b,0x22b,0x22b,0x828,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x27f6,0x22b,0x22b,0x22b,
0xf17,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x27fb,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x280a,0x281a,0x2828,0x2835,0x22b,0x2841,0x284f,0x285f,0x22b,0x22b,0x22b,0x22b,
0xd42,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x1614,0x1624,0x1634,0x286f,
0x1620,0x287f,0x288f,0x161c,0x162c,0x289f,0x28af,0x28bf,0x28cf,0x1614,0x1624,0x1634,0x28db,0x28eb,0x1630,0x28d7,
0x28fb,0x290b,0x288b,0x1618,0x1628,0x1638,0x1614,0x1624,0x1634,0x286f,0x1620,0x1630,0x288f,0x161c,0x162c,0x288b,
0x1618,0x1628,0x1638,0x1614,0x1624,0x1634,0x291b,0x292b,0x293b,0x294b,0x295b,0x2931,0x2941,0x2951,0x2927,0x2937,
0x2947,0x2957,0x292d,0x293d,0x294d,0x2923,0x2933,0x2943,0x296b,0x297b,0x2981,0x297d,0x2991,0x2999,0x29a7,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x29b7,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x29c3,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x29d3,
0x29e3,0x29f3,0x2a03,0x2a11,0x2a21,0x2a31,0x2a41,0x2a51,0x2a61,0x2a70,0x2a61,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x2a80,
0x2a90,0x2aa0,0x1614,0x2ab0,0x22b,0x2ac0,0x22b,0x22b,0x2ad0,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x2ae0,
0x2af0,0x2b00,0x2b10,0x2b20,0x2b30,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x2b40,
0x2b50,0x2b60,0x2b70,0x2b80,0x2b90,0x2ba0,0x2bb0,0x2bc0,0x2bd0,0x2be0,0x2bf0,0x2c00,0x2c10,0x2c20,0x2c30,0x2c40,
0x2c50,0x2c60,0x2c70,0x2c80,0x2c90,0x2ca0,0x2cb0,0x2cc0,0x2cd0,0x2ce0,0x2cf0,0x2d00,0x2d10,0x2d20,0x2d30,0x2d40,
0x2d50,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,
0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x22b,0x408,
0x428,0xd0,0xd0,0xd0,0x448,0x457,0x46a,0x486,0x4a3,0x4bf,0x4dc,0x4f9,0x516,0x533,0xd0,0xd0,
0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,
0xd0,0xd0,0xd0,0x54d,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,
0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,
0xd0,0xd0,0x564,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0x56f,0x58c,0x5ac,0x5cc,0xd0,
0xd0,0xd0,0xd0,0x5ec,0xd0,0xd0,0xd0,0x5ff,0xd0,0xd0,0x61f,0x62f,0x64f,0xd0,0xd0,0xd0,
0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,
0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0x66f,0x68f
};

static const uint16_t norm2_nfkc_data_trieData[11617]={
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,4,8,0xc,1,
1,0x10,0x50,0x5c,0x70,0x88,0xcc,0xd0,0xec,0x108,0x144,0x148,0x15c,0x174,0x180,0x1a4,
0x1e4,1,0x1ec,0x20c,0x228,0x244,0x290,0x298,0x2b0,0x2b8,0x2dc,1,1,1,1,1,
1,0x2f4,0x334,0x340,0x354,0x36c,0x3b0,0x3b4,0x3d0,0x3f0,0x428,0x430,0x444,0x45c,0x468,0x48c,
0x4cc,1,0x4d4,0x4f4,0x510,0x530,0x57c,0x584,0x5a0,0x5a8,0x5d0,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0x2959,1,1,1,1,
1,1,1,0x295c,1,0x2962,1,1,1,1,0x2966,1,1,0x296d,0x2971,0x2974,
0x297b,1,1,0x297e,0x2985,0x2988,1,0x298d,0x2995,0x299d,1,0x1254,0x125a,0xaae,0x1260,0xac4,
0xace,0x5e8,0xad8,0x1266,0x126c,0xae2,0x1272,0x1278,0x127e,0x1284,0xaf8,1,0x128a,0x1290,0x1296,0xb02,
0xb18,0xb2a,1,0x5f0,0x129c,0x12a2,0x12a8,0xb34,0x12ae,1,1,0x12b4,0x12ba,0xb4a,0x12c0,0xb60,
0xb6a,0x5f4,0xb74,0x12c6,0x12cc,0xb7e,0x12d2,0x12d8,0x12de,0x12e4,0xb94,1,0x12ea,0x12f0,0x12f6,0xb9e,
0xbb4,0xbc6,1,0x5fc,0x12fc,0x1302,0x1308,0xbd0,0x130e,1,0x1314,0x131a,0x1320,0xbe6,0xbfc,0x1327,
0x132d,0x1332,0x1338,0x133e,0x1344,0x134a,0x1350,0x1356,0x135c,0x1362,0x1368,1,1,0xc12,0xc20,0x136e,
0x1374,0x137a,0x1380,0x1387,0x138d,0x1392,0x1398,0x139e,0x13a4,0x13aa,0x13b0,0x13b6,0x13bc,0x13c3,0x13c9,0x13ce,
0x13d4,1,1,0x13da,0x13e0,0x13e6,0x13ec,0x13f2,0x13f8,0x13ff,0x1405,0x140a,1,0x29a4,0x29aa,0x1411,
0x1417,0x141d,0x1423,1,0x1428,0x142e,0x1435,0x143b,0x1440,0x1446,0x29b1,0x29b7,1,1,0x144c,0x1452,
0x1459,0x145f,0x1464,0x146a,0x29bc,1,1,0xc2e,0xc3c,0x1470,0x1476,0x147c,0x1482,1,1,0x1488,
0x148e,0x1495,0x149b,0x14a0,0x14a6,0xc4a,0xc54,0x14ac,0x14b2,0x14b9,0x14bf,0xc5e,0xc68,0x14c5,0x14cb,0x14d0,
0x14d6,1,1,0xc72,0xc7c,0xc86,0xc90,0x14dc,0x14e2,0x14e8,0x14ee,0x14f4,0x14fa,0x1501,0x1507,0x150c,
0x1512,0x1518,0x151e,0x1524,0x152a,0x1530,0x1536,0x153c,0x1542,0x1548,0x29c2,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0xc9a,0xcb4,1,1,1,
1,1,1,1,1,1,1,1,1,1,0xcce,0xce8,1,1,1,1,
1,1,0x600,1,1,1,1,1,1,1,1,0x6006,0x6014,0x6022,0x29c6,0x29cc,
0x29d2,0x29d8,0x29de,0x29e4,0x154e,0x1554,0x155a,0x1560,0x1566,0x156c,0x1572,0x1578,0x1580,0x158a,0x1594,0x159e,
0x15a8,0x15b2,0x15bc,0x15c6,1,0x15d0,0x15da,0x15e4,0x15ee,0x15f7,0x15fd,1,1,0x1602,0x1608,0x160e,
0x1614,0xd02,0xd0c,0x161d,0x1627,0x162f,0x1635,0x163b,0x29ea,0x29f0,0x29f6,0x1640,0x1646,1,1,0x164c,
0x1652,0x165a,0x1664,0x166d,0x1673,0x1679,0x167f,0x1684,0x168a,0x1690,0x1696,0x169c,0x16a2,0x16a8,0x16ae,0x16b4,
0x16ba,0x16c0,0x16c6,0x16cc,0x16d2,0x16d8,0x16de,0x16e4,0x16ea,0x16f0,0x16f6,0x16fc,0x1702,0x1708,0x170e,0x1714,
0x171a,0x1720,0x1726,1,1,0x172c,0x1732,1,1,1,1,1,1,0xd16,0xd20,0xd2a,
0xd34,0x173a,0x1744,0x174e,0x1758,0xd3e,0xd48,0x1762,0x176c,0x1774,0x177a,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0x604,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0x29fc,0x2a01,0x2a04,0x2a08,0xf821,0xf829,0xf851,
0x2a0c,0x2a10,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0x2a14,0x2a1a,0x2a20,0x2a26,0x2a2c,0x2a32,
1,1,0x2a39,0x2a3c,0x29c2,0x2a40,0x2a45,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0xfdcc,0xfdcc,0xfdcc,0xfdcc,0xfdcc,0xffcc,0xfdcc,0xfdcc,0xfdcc,0xfdcc,0xfdcc,0xfdcc,0xfdcc,0xffcc,
0xffcc,0xfdcc,0xffcc,0xfdcc,0xffcc,0xfdcc,0xfdcc,0xffd0,0xffb8,0xffb8,0xffb8,0xffb8,0xffd0,0xfdb0,0xffb8,0xffb8,
0xffb8,0xffb8,0xffb8,0xff94,0xff94,0xfdb8,0xfdb8,0xfdb8,0xfdb8,0xfd94,0xfd94,0xffb8,0xffb8,0xffb8,0xffb8,0xfdb8,
0xfdb8,0xffb8,0xfdb8,0xfdb8,0xffb8,0xffb8,0xfe02,0xfe02,0xfe02,0xfe02,0xfc02,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,
0xffcc,0xffcc,0x65de,0x65e4,0xfdcc,0x65ea,0x65f0,0xfde0,0xffcc,0xffb8,0xffb8,0xffb8,0xffcc,0xffcc,0xffcc,0xffb8,
0xffb8,1,0xffcc,0xffcc,0xffcc,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,0xffd0,0xffb8,0xffb8,0xffcc,0xffd2,0xffd4,
0xffd4,0xffd2,0xffd4,0xffd4,0xffd2,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,1,1,1,1,0x2a49,1,1,1,1,1,0x2a4c,1,1,1,
0x2a53,1,1,1,1,0x2974,0x2a58,0x1781,0x2a61,0x1787,0x178d,0x1793,1,0x1799,1,0x179f,
0x17a5,0x17ad,0x608,1,1,1,0x624,1,0x634,1,0x648,1,1,1,1,1,
0x664,1,0x674,1,1,1,0x678,1,1,1,0x690,0x17b5,0x17bb,0xd52,0x17c1,0xd5c,
0x17c7,0x17cf,0x6a4,1,1,1,0x6c4,1,0x6d4,1,0x6ec,1,1,1,1,1,
0x70c,1,0x71c,1,1,1,0x724,1,1,1,0x744,0xd66,0xd78,0x17d7,0x17dd,0xd8a,
1,0xf909,0xf931,0xf890,0x6030,0x603c,0xf981,0xf949,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0xf849,0xf878,0xf879,1,0x2a65,0xf7f8,1,1,1,0x2a69,1,1,1,1,1,
1,0x17e3,0x17e9,1,0x17ef,1,1,0x75c,0x17f5,1,1,1,1,0x17fb,0x1801,0x1807,
1,0x760,1,1,0x768,1,0x76c,0x778,0x780,0x784,0x180d,0x794,1,1,1,0x798,
1,1,1,1,0x79c,1,1,1,0x7ac,1,1,1,0x7b0,1,0x7b4,1,
1,0x7b8,1,1,0x7c0,1,0x7c4,0x7d0,0x7d8,0x7dc,0x1813,0x7ec,1,1,1,0x7f0,
1,1,1,0x7f4,1,1,1,0x804,1,1,1,0x808,1,0x80c,1,1,
0x1819,0x181f,1,0x1825,1,1,0x810,0x182b,1,1,1,1,0x1831,0x1837,0x183d,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x814,0x818,0x1843,0x1849,1,1,1,1,1,1,1,1,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,0x184f,0x1855,1,
1,1,1,1,1,1,1,1,1,1,1,1,0x185b,0x1861,0x1867,0x186d,
1,1,0x1873,0x1879,0x81c,0x820,0x187f,0x1885,0x188b,0x1891,0x1897,0x189d,1,1,0x18a3,0x18a9,
0x18af,0x18b5,0x18bb,0x18c1,0x824,0x828,0x18c7,0x18cd,0x18d3,0x18d9,0x18df,0x18e5,0x18eb,0x18f1,0x18f7,0x18fd,
0x1903,0x1909,1,1,0x190f,0x1915,1,1,1,1,1,1,1,0x2a6d,1,1,
1,1,1,1,1,1,1,0xffb8,0xffcc,0xffcc,0xffcc,0xffcc,0xffb8,0xffcc,0xffcc,0xffcc,
0xffbc,0xffb8,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,0xffcc,
0xffb8,0xffcc,0xffcc,0xffbc,0xffc8,0xffcc,0xfe14,0xfe16,0xfe18,0xfe1a,0xfe1c,0xfe1e,0xfe20,0xfe22,0xfe24,0xfe26,
0xfe26,0xfe28,0xfe2a,0xfe2c,1,0xfe2e,1,0xfe30,0xfe32,1,0xffcc,0xffb8,1,0xfe24,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xfe3c,0xfe3e,
0xfe40,1,1,1,1,1,1,1,0x191a,0x1920,0x1927,0x192d,0x1933,0x82c,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0x838,1,0x83c,0xfe36,0xfe38,0xfe3a,0xfe3c,0xfe3e,0xfe40,0xfe42,
0xfe44,0xfdcc,0xfdcc,0xfdb8,0xffb8,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffb8,0xffcc,0xffcc,0xffb8,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xfe46,1,
1,1,1,0x2a73,0x2a79,0x2a7f,0x2a85,1,1,1,1,1,1,1,0x1939,0x840,
0x193f,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x844,0x1945,1,0x848,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,0xffcc,0xffcc,0xffcc,
0xffcc,0xffb8,0xffcc,1,1,0xffcc,0xffcc,1,0xffb8,0xffcc,0xffcc,0xffb8,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xfe48,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,0xffcc,0xffb8,0xffcc,
0xffcc,0xffb8,0xffcc,0xffcc,0xffb8,0xffb8,0xffb8,0xffcc,0xffb8,0xffb8,0xffcc,0xffb8,0xffcc,0xffcc,0xffb8,0xffcc,
0xffb8,0xffcc,0xffb8,0xffcc,0xffb8,0xffcc,0xffcc,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffb8,0xffcc,1,1,1,1,1,1,1,1,1,0xffb8,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,1,0xffcc,0xffcc,0xffcc,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0xffb8,0xffb8,0xffb8,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,0xffb8,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,0xffb8,0xffcc,0xffcc,
0xffb8,0xffcc,0xffcc,0xffb8,0xffcc,0xffcc,0xffcc,0xffb8,0xffb8,0xffb8,0xfe36,0xfe38,0xfe3a,0xffcc,0xffcc,0xffcc,
0xffb8,0xffcc,0xffcc,0xffb8,0xffb8,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0x84c,0x194b,1,1,1,1,1,1,0x850,0x1951,1,0x854,0x1957,1,
1,1,1,1,1,1,0xfc0e,1,1,1,1,1,1,1,1,1,
1,1,1,1,0xfe12,1,1,1,0xffcc,0xffb8,0xffcc,0xffcc,1,1,1,0x2a8a,
0x2a90,0x2a96,0x2a9c,0x2aa2,0x2aa8,0x2aae,0x2ab4,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0xfe0e,1,0xfc00,1,1,1,1,1,1,1,0x858,1,1,
1,0x195d,0x1963,0xfe12,1,1,1,1,1,1,1,1,1,0xfc00,1,1,
1,1,0x2aba,0x2ac0,1,0x2ac6,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0xffcc,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0x2acc,1,1,0x2ad2,1,1,1,1,
1,0xfe0e,1,1,1,1,1,1,1,1,1,1,1,1,1,0xfe12,
1,1,1,1,1,1,1,1,1,1,1,0x2ad8,0x2ade,0x2ae4,1,1,
0x2aea,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,0xfe0e,1,1,
1,1,1,1,1,1,1,1,1,1,1,0xfe12,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x860,0x1969,
1,1,0x196f,0x1975,0xfe12,1,1,1,1,1,1,1,1,0xfc00,0xfc00,1,
1,1,1,0x2af0,0x2af6,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0x86c,1,0x197b,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0xfc00,1,1,1,1,1,1,0x870,0x878,1,1,0x1981,0x1987,
0x198d,0xfe12,1,1,1,1,1,1,1,1,1,0xfc00,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x87c,1,0x1993,1,1,1,1,0xfe12,1,1,1,1,
1,1,1,0xfea8,0xfcb6,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0xfe0e,1,1,0x880,0x1999,1,0xfc00,1,1,1,0x884,0x199f,0x19a5,1,0xd94,
0x19ad,1,0xfe12,1,1,1,1,1,1,1,0xfc00,0xfc00,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0xfe12,0xfe12,1,0xfc00,1,1,1,1,1,
1,0x890,0x898,1,1,0x19b5,0x19bb,0x19c1,0xfe12,1,1,1,1,1,1,1,
1,1,0xfc00,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0xfc12,1,1,1,1,
0xfc00,1,1,1,1,1,1,1,1,1,0x89c,0x19c7,1,0xd9e,0x19cf,0x19d7,
0xfc00,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x2afd,1,1,1,1,0xfece,0xfece,0xfe12,1,1,1,1,
1,1,1,1,0xfed6,0xfed6,0xfed6,0xfed6,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0x2b03,1,1,1,
1,0xfeec,0xfeec,1,1,1,1,1,1,1,1,0xfef4,0xfef4,0xfef4,0xfef4,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x2b09,
0x2b0f,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0xf9f1,1,1,1,1,1,1,1,1,1,1,1,0xffb8,
0xffb8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0xffb8,1,0xffb8,1,
0xffb0,1,1,1,1,1,1,0x2b15,1,1,1,1,1,1,1,1,
1,0x2b1b,1,1,1,1,0x2b21,1,1,1,1,0x2b27,1,1,1,1,
0x2b2d,1,1,1,1,1,1,1,1,1,1,1,1,0x2b33,1,1,
1,1,1,1,1,0xff02,0xff04,0x65f8,0xff08,0x6600,0x2b38,0x2b44,0x2b4c,0x2b58,0xff04,0xff04,
0xff04,0xff04,1,1,0xff04,0x6608,0xffcc,0xffcc,0xfe12,1,0xffcc,0xffcc,1,1,1,1,
1,1,1,1,1,1,1,0x2b61,1,1,1,1,1,1,1,1,
1,0x2b67,1,1,1,1,0x2b6d,1,1,1,1,0x2b73,1,1,1,1,
0x2b79,1,1,1,1,1,1,1,1,1,1,1,1,0x2b7f,1,1,
1,1,1,1,0xffb8,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x8a8,0x19dd,
1,1,1,1,1,1,1,0xfc00,1,1,1,1,1,1,1,1,
0xfe0e,1,0xfe12,0xfe12,1,1,1,1,1,1,1,1,1,1,1,1,
1,0xffb8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xf8f9,1,
1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,
0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xfe00,
0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,
0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,0xfe00,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0xffcc,0xffcc,0xffcc,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0xfe12,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0xfe12,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0xfe12,1,1,1,1,1,
1,1,1,1,1,0xffcc,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xffc8,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0xffbc,0xffcc,0xffb8,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0xffcc,0xffb8,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0xfe12,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,0xffb8,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,0xffcc,0xffb8,1,1,1,1,1,0x8ac,
0x19e3,0x8b0,0x19e9,0x8b4,0x19ef,0x8b8,0x19f5,0x8bc,0x19fb,1,1,0x8c0,0x1a01,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xfe0e,0xfc00,
1,1,1,1,0x8c4,0x1a07,0x8c8,0x1a0d,0x8cc,0x8d0,0x1a13,0x1a19,0x8d4,0x1a1f,0xfe12,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,0xffcc,0xffb8,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0xfe12,0xfe12,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0xfe0e,1,1,1,1,1,1,1,1,1,1,1,0xfe12,0xfe12,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xffcc,0xffcc,
0xffcc,1,0xfe02,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,0xffcc,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,1,
0xfe02,0xfe02,0xfe02,0xfe02,0xfe02,0xfe02,0xfe02,1,1,1,1,0xffb8,1,1,1,1,
1,1,0xffcc,1,1,1,0xffcc,0xffcc,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x2b84,0x2b88,0x2b8c,1,0x2b90,0x2b94,0x2b99,0x2b9c,0x2ba0,0x2ba4,0x2ba8,0x2bac,
0x2bb0,0x2bb4,0x2bb8,1,0x2bbc,0x2bc1,0x2bc4,0x2bc8,0x2bcc,0x2bd0,0x2bd4,0x2962,0x2bd9,0x2bdd,0x2be1,0x2be4,
0x2be8,0x2bec,0x2bf1,0x2bf5,0x2bf9,0x2bfc,1,0x2c00,0x2c04,0x2c09,0x2988,0x2c0d,0xf809,0xf809,0x2c10,0x2c14,
0x2c18,0xf819,0x2c1d,0x2c20,0xf841,0x2c25,0x2c29,0x2c2d,0x2c31,0x2c35,0x2c38,0x2a08,0x2c18,0x2c20,0x2c25,0x2c29,
0x2c3c,0x2c31,0x2c35,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x2c41,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0x2c45,0x2c48,0x2c4d,0x2c51,
0x2bf9,0x2c54,0x2c59,0x2c5d,0x2c61,0x2c65,0x2c69,0x2c6d,0xf899,0x2c71,0x2c75,0xf8d1,0x2c79,0x2c7d,0x2c81,0x2c85,
0x2c89,0x2c8d,0x2c91,0x2c95,0x2c99,0x2c9d,0x2ca1,0x2ca5,0x2ca9,0x2cad,0x2cb1,0x2cb5,0x2cb8,0x2cbd,0x2cc1,0x2cc4,
0x2cc9,0xffcc,0xffcc,0xffb8,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffb8,0xffcc,0xffcc,0xffd4,0xffac,
0xffb8,0xff94,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffd0,0xffc8,0xffc8,0xffb8,1,0xffcc,0xffd2,0xffb8,0xffcc,
0xffb8,0x1a24,0x1a2a,0x1a30,0x1a36,0x1a3d,0x1a43,0x1a49,0x1a4f,0x1a57,0x1a61,0x1a68,0x1a6e,0x1a74,0x1a7a,0x1a80,
0x1a86,0x1a8d,0x1a93,0x1a98,0x1a9e,0x1aa6,0x1ab0,0x1aba,0x1ac4,0x1acc,0x1ad2,0x1ad8,0x1ade,0x1ae7,0x1af1,0x1af9,
0x1aff,0x1b04,0x1b0a,0x1b10,0x1b16,0x1b1c,0x1b22,0x1b28,0x1b2e,0x1b35,0x1b3b,0x1b40,0x1b46,0x1b4c,0x1b52,0x1b5a,
0x1b64,0x1b6c,0x1b72,0x1b78,0x1b7e,0x1b84,0x1b8a,0xda8,0xdb2,0x1b92,0x1b9c,0x1ba4,0x1baa,0x1bb0,0x1bb6,0x1bbc,
0x1bc2,0x1bc8,0x1bce,0x1bd5,0x1bdb,0x1be0,0x1be6,0x1bec,0x1bf2,0x1bf8,0x1bfe,0x1c04,0x1c0a,0x1c12,0x1c1c,0x1c26,
0x1c30,0x1c3a,0x1c44,0x1c4e,0x1c58,0x1c61,0x1c67,0x1c6d,0x1c73,0x1c78,0x1c7e,0xdbc,0xdc6,0x1c86,0x1c90,0x1c98,
0x1c9e,0x1ca4,0x1caa,0xdd0,0xdda,0x1cb2,0x1cbc,0x1cc6,0x1cd0,0x1cda,0x1ce4,0x1cec,0x1cf2,0x1cf8,0x1cfe,0x1d04,
0x1d0a,0x1d10,0x1d16,0x1d1c,0x1d22,0x1d28,0x1d2e,0x1d34,0x1d3a,0x1d42,0x1d4c,0x1d56,0x1d60,0x1d68,0x1d6e,0x1d75,
0x1d7b,0x1d80,0x1d86,0x1d8c,0x1d92,0x1d98,0x1d9e,0x1da4,0x1daa,0x1db1,0x1db7,0x1dbd,0x1dc3,0x1dc9,0x1dcf,0x1dd4,
0x1dda,0x1de0,0x1de6,0x1ded,0x1df3,0x1df9,0x1dff,0x1e04,0x1e0a,0x1e10,0x1e16,0x2ccd,0x6048,1,1,1,
1,0xde4,0xdf2,0x1e1c,0x1e22,0x1e2a,0x1e34,0x1e3e,0x1e48,0x1e52,0x1e5c,0x1e66,0x1e70,0x1e7a,0x1e84,0x1e8e,
0x1e98,0x1ea2,0x1eac,0x1eb6,0x1ec0,0x1eca,0x1ed4,0x1ede,0x1ee8,0xe00,0xe0a,0x1ef0,0x1ef6,0x1efc,0x1f02,0x1f0a,
0x1f14,0x1f1e,0x1f28,0x1f32,0x1f3c,0x1f46,0x1f50,0x1f5a,0x1f64,0x1f6c,0x1f72,0x1f78,0x1f7e,0xe14,0xe1e,0x1f84,
0x1f8a,0x1f92,0x1f9c,0x1fa6,0x1fb0,0x1fba,0x1fc4,0x1fce,0x1fd8,0x1fe2,0x1fec,0x1ff6,0x2000,0x200a,0x2014,0x201e,
0x2028,0x2032,0x203c,0x2046,0x2050,0x2058,0x205e,0x2064,0x206a,0x2072,0x207c,0x2086,0x2090,0x209a,0x20a4,0x20ae,
0x20b8,0x20c2,0x20cc,0x20d4,0x20da,0x20e1,0x20e7,0x20ec,0x20f2,0x20f8,0x20fe,1,1,1,1,1,
1,0xe28,0xe3e,0xe56,0xe64,0xe72,0xe80,0xe8e,0xe9c,0xea8,0xebe,0xed6,0xee4,0xef2,0xf00,0xf0e,
0xf1c,0xf28,0xf36,0x2107,0x2111,0x211b,0x2125,1,1,0xf44,0xf52,0x212f,0x2139,0x2143,0x214d,1,
1,0xf60,0xf76,0xf8e,0xf9c,0xfaa,0xfb8,0xfc6,0xfd4,0xfe0,0xff6,0x100e,0x101c,0x102a,0x1038,0x1046,
0x1054,0x1060,0x1072,0x2157,0x2161,0x216b,0x2175,0x217f,0x2189,0x1084,0x1096,0x2193,0x219d,0x21a7,0x21b1,0x21bb,
0x21c5,0x10a8,0x10b6,0x21cf,0x21d9,0x21e3,0x21ed,1,1,0x10c4,0x10d2,0x21f7,0x2201,0x220b,0x2215,1,
1,0x10e0,0x10f2,0x221f,0x2229,0x2233,0x223d,0x2247,0x2251,1,0x1104,1,0x225b,1,0x2265,1,
0x226f,0x1116,0x112c,0x1144,0x1152,0x1160,0x116e,0x117c,0x118a,0x1196,0x11ac,0x11c4,0x11d2,0x11e0,0x11ee,0x11fc,
0x120a,0x1216,0x6050,0x2277,0x6058,0x1220,0x6060,0x227d,0x6068,0x2283,0x6070,0x2289,0x6078,0x122a,0x6080,1,
1,0x2290,0x229a,0x22a9,0x22b9,0x22c9,0x22d9,0x22e9,0x22f9,0x2304,0x230e,0x231d,0x232d,0x233d,0x234d,0x235d,
0x236d,0x2378,0x2382,0x2391,0x23a1,0x23b1,0x23c1,0x23d1,0x23e1,0x23ec,0x23f6,0x2405,0x2415,0x2425,0x2435,0x2445,
0x2455,0x2460,0x246a,0x2479,0x2489,0x2499,0x24a9,0x24b9,0x24c9,0x24d4,0x24de,0x24ed,0x24fd,0x250d,0x251d,0x252d,
0x253d,0x2547,0x254d,0x2555,0x255c,0x2565,1,0x1234,0x256f,0x2577,0x257d,0x2583,0x6088,0x2588,0x2cd2,0x2cd8,
0x2cd2,0x2cdc,0x2ce4,0x2591,0x2598,0x25a1,1,0x123e,0x25ab,0x25b3,0x6090,0x25b9,0x6098,0x25be,0x2cee,0x2cf8,
0x2d02,0x25c5,0x25cb,0x25d3,0x60a2,1,1,0x25db,0x25e3,0x25eb,0x25f1,0x25f7,0x60ac,1,0x2d0c,0x2d16,
0x2d20,0x25fd,0x2603,0x260b,0x60b6,0x2613,0x2619,0x261f,0x2627,0x262f,0x2635,0x263b,0x60c0,0x2641,0x2d2a,0x2d36,
0x2d3f,1,1,0x2649,0x2650,0x2659,1,0x1248,0x2663,0x266b,0x60c8,0x2671,0x60d0,0x2676,0x2d44,0x2d4a,
1,0x2d55,0x2d5d,0x2959,0x2959,0x2959,0x2959,0x2959,0x2959,0x2959,0x2959,0x2959,1,1,1,1,
1,1,0xf9f1,1,1,1,1,1,0x2d60,1,1,1,1,1,1,1,
1,1,1,1,1,0x2d67,0x2d6b,0x2d71,1,1,1,1,1,1,1,1,
0x2959,1,1,1,0x2d79,0x2d7f,1,0x2d87,0x2d8d,1,1,1,1,0x2d95,1,0x2d9a,
1,1,1,1,1,1,1,0x2da1,0x2da7,0x2dad,1,1,1,1,1,1,
1,1,1,1,1,1,1,0x2db3,1,1,1,1,1,1,1,0x2959,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x2dbd,0x2c38,1,1,0x2dc1,0x2dc5,0x2dc9,0x2dcd,0x2dd1,0x2dd5,0x2dd9,0x2ddd,0x2de0,0x2de5,0x2de9,0x2dec,
0x2dbd,0x2985,0x296d,0x2971,0x2dc1,0x2dc5,0x2dc9,0x2dcd,0x2dd1,0x2dd5,0x2dd9,0x2ddd,0x2de0,0x2de5,0x2de9,1,
0x2962,0x2bec,0x2988,0x2a40,0x2bf1,0x29fc,0x2c00,0x2a3c,0x2c04,0x2dec,0x2c10,0x29c2,0x2c14,1,1,1,
1,1,1,1,1,1,1,1,0x2df0,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0xffcc,0xffcc,0xfe02,0xfe02,0xffcc,0xffcc,0xffcc,0xffcc,0xfe02,0xfe02,0xfe02,0xffcc,0xffcc,1,1,1,
1,0xffcc,1,1,1,0xfe02,0xfe02,0xffcc,0xffb8,0xffcc,0xfe02,0xfe02,0xffb8,0xffb8,0xffb8,0xffb8,
0xffcc,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x2df6,0x2dfe,0x2e06,0x2e0a,1,0x2e10,0x2e18,0x2e21,1,0x2e24,0x2bfc,0x2ba0,0x2ba0,0x2ba0,0x29fc,0x2e2b,
0x2ba4,0x2ba4,0x2bb0,0x2a3c,1,0x2bb8,0x2e2e,1,1,0x2bc4,0x2e35,0x2bc8,0x2bc8,0x2bc8,1,1,
0x2e38,0x2e3e,0x2e46,1,0x2e4c,1,0x2e50,1,0x2e4c,1,0x2bac,0x60d8,0x2b8c,0x2e06,1,0x2bec,
0x2b94,0x2e54,1,0x2bb4,0x2988,0x2e59,0x2e5d,0x2e61,0x2e65,0x2c38,1,0x2e68,0x2e71,0x2c29,0x2e75,0x2e79,
0x2e7d,1,1,1,1,0x2b90,0x2be8,0x2bec,0x2c38,0x2a04,1,1,1,1,1,1,
0x2e81,0x2e89,0x2e91,0x2e9b,0x2ea3,0x2eab,0x2eb3,0x2ebb,0x2ec3,0x2ecb,0x2ed3,0x2edb,0x2ee3,0x2eeb,0x2ef3,0x2efb,
0x2ba4,0x2f00,0x2f06,0x2f0e,0x2f14,0x2f18,0x2f1e,0x2f26,0x2f30,0x2f36,0x2f3a,0x2f40,0x2bb0,0x2e06,0x2b90,0x2bb4,
0x2c38,0x2f48,0x2f4e,0x2f56,0x2c20,0x2f5c,0x2f62,0x2f6a,0x2f74,0x2a40,0x2f7a,0x2f80,0x2a3c,0x2c48,0x2be8,0x2c04,
1,1,1,1,1,1,1,1,1,0x2f89,1,1,1,1,1,1,
0x8d8,1,0x8dc,1,0x8e0,1,1,1,1,1,0x267d,0x2683,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x2689,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x268f,0x2695,0x269b,0x8e4,1,0x8e8,1,0x8ec,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0x8f0,0x26a1,1,1,1,0x8f4,0x26a7,1,0x8f8,0x26ad,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0x8fc,0x26b3,0x900,0x26b9,1,1,1,1,1,0x2f91,0x2f97,1,0x2f9f,
0x2fa5,1,1,1,1,1,1,1,1,1,1,1,0x904,1,1,1,
0x26bf,1,0x908,0x26c5,0x90c,1,0x26cb,0x910,0x26d1,1,1,1,0x914,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x26d7,
0x918,0x26dd,1,0x91c,0x920,1,1,1,1,1,1,1,0x26e3,0x26e9,0x26ef,0x26f5,
0x26fb,0x924,0x928,0x2701,0x2707,0x92c,0x930,0x270d,0x2713,0x934,0x938,0x93c,0x940,1,1,0x2719,
0x271f,0x944,0x948,0x2725,0x272b,0x94c,0x950,0x2731,0x2737,1,1,1,1,1,1,1,
0x954,0x958,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0x95c,1,1,1,1,1,0x960,0x964,1,0x968,0x273d,0x2743,0x2749,0x274f,1,
1,0x96c,0x970,0x974,0x978,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,0x2755,0x275b,0x2761,0x2767,1,1,1,1,1,1,0x276d,
0x2773,0x2779,0x277f,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0x2fad,0x2fb1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x2985,0x296d,
0x2971,0x2dc1,0x2dc5,0x2dc9,0x2dcd,0x2dd1,0x2dd5,0x2fb5,0x2fbb,0x2fc1,0x2fc7,0x2fcd,0x2fd3,0x2fd9,0x2fdf,0x2fe5,
0x2feb,0x2ff1,0x2ff7,0x2fff,0x3007,0x300f,0x3017,0x301f,0x3027,0x302f,0x3037,0x303f,0x3049,0x3053,0x305d,0x3067,
0x3071,0x307b,0x3085,0x308f,0x3099,0x30a3,0x30ad,0x30b3,0x30b9,0x30bf,0x30c5,0x30cb,0x30d1,0x30d7,0x30dd,0x30e3,
0x30eb,0x30f3,0x30fb,0x3103,0x310b,0x3113,0x311b,0x3123,0x312b,0x3133,0x313b,0x3143,0x314b,0x3153,0x315b,0x3163,
0x316b,0x3173,0x317b,0x3183,0x318b,0x3193,0x319b,0x31a3,0x31ab,0x31b3,0x31bb,0x31c3,0x31cb,0x31d3,0x31db,0x31e3,
0x31eb,0x31f3,0x31fb,0x3203,0x2b84,0x2b8c,0x2e06,0x2b90,0x2b94,0x2e54,0x2b9c,0x2ba0,0x2ba4,0x2ba8,0x2bac,0x2bb0,
0x2bb4,0x2bb8,0x2bbc,0x2bc4,0x2e35,0x2bc8,0x320a,0x2bcc,0x2bd0,0x2f14,0x2bd4,0x2f36,0x320e,0x2e4c,0x2962,0x2be4,
0x2c48,0x2be8,0x2bec,0x2c54,0x2bfc,0x29fc,0x2c38,0x2a04,0x2c00,0x2a3c,0x2c04,0x2dec,0x2988,0x2c10,0x3213,0x2a08,
0x29c2,0x2c14,0x2c18,0x2c20,0x2a0c,0x2a40,0x2a10,0x2cb8,0x2dbd,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x3217,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0x3220,0x3228,0x322e,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0x3237,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x2a04,
0x2f14,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0xf989,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0xfe12,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x323d,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x3241,1,1,1,1,1,1,1,1,1,1,1,
1,0x3245,0x3249,0x324d,0x3251,0x3255,0x3259,0x325d,0x3261,0x3265,0x3269,0x326d,0x3271,0x3275,0x3279,0x327d,
0x3281,0x3285,0x3289,0x328d,0x3291,0x3295,0x3299,0x329d,0x32a1,0x32a5,0x32a9,0x32ad,0x32b1,0x32b5,0x32b9,0x32bd,
0x32c1,0x32c5,0x32c9,0x32cd,0x32d1,0x32d5,0x32d9,0x32dd,0x32e1,0x32e5,0x32e9,0x32ed,0x32f1,0x32f5,0x32f9,0x32fd,
0x3301,0x3305,0x3309,0x330d,0x3311,0x3315,0x3319,0x331d,0x3321,0x3325,0x3329,0x332d,0x3331,0x3335,0x3339,0x333d,
0x3341,0x3345,0x3349,0x334d,0x3351,0x3355,0x3359,0x335d,0x3361,0x3365,0x3369,0x336d,0x3371,0x3375,0x3379,0x337d,
0x3381,0x3385,0x3389,0x338d,0x3391,0x3395,0x3399,0x339d,0x33a1,0x33a5,0x33a9,0x33ad,0x33b1,0x33b5,0x33b9,0x33bd,
0x33c1,0x33c5,0x33c9,0x33cd,0x33d1,0x33d5,0x33d9,0x33dd,0x33e1,0x33e5,0x33e9,0x33ed,0x33f1,0x33f5,0x33f9,0x33fd,
0x3401,0x3405,0x3409,0x340d,0x3411,0x3415,0x3419,0x341d,0x3421,0x3425,0x3429,0x342d,0x3431,0x3435,0x3439,0x343d,
0x3441,0x3445,0x3449,0x344d,0x3451,0x3455,0x3459,0x345d,0x3461,0x3465,0x3469,0x346d,0x3471,0x3475,0x3479,0x347d,
0x3481,0x3485,0x3489,0x348d,0x3491,0x3495,0x3499,0x349d,0x34a1,0x34a5,0x34a9,0x34ad,0x34b1,0x34b5,0x34b9,0x34bd,
0x34c1,0x34c5,0x34c9,0x34cd,0x34d1,0x34d5,0x34d9,0x34dd,0x34e1,0x34e5,0x34e9,0x34ed,0x34f1,0x34f5,0x34f9,0x34fd,
0x3501,0x3505,0x3509,0x350d,0x3511,0x3515,0x3519,0x351d,0x3521,0x3525,0x3529,0x352d,0x3531,0x3535,0x3539,0x353d,
0x3541,0x3545,0x3549,0x354d,0x3551,0x3555,0x3559,0x355d,0x3561,0x3565,0x3569,0x356d,0x3571,0x3575,0x3579,0x357d,
0x3581,0x3585,0x3589,0x358d,0x3591,0x3595,0x3599,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0x2959,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0xffb4,0xffc8,0xffd0,0xffbc,0xffc0,
0xffc0,1,1,1,1,1,1,0xf8d9,1,0x32a1,0x359d,0x35a1,1,1,1,1,
1,1,0x97c,1,1,1,1,0x980,0x2785,0x984,0x278b,0x988,0x2791,0x98c,0x2797,0x990,
0x279d,0x994,0x27a3,0x998,0x27a9,0x99c,0x27af,0x9a0,0x27b5,0x9a4,0x27bb,0x9a8,0x27c1,0x9ac,0x27c7,1,
0x9b0,0x27cd,0x9b4,0x27d3,0x9b8,0x27d9,1,1,1,1,1,0x9bc,0x27df,0x27e5,0x9c4,0x27eb,
0x27f1,0x9cc,0x27f7,0x27fd,0x9d4,0x2803,0x2809,0x9dc,0x280f,0x2815,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x281b,1,
1,1,1,0xfc10,0xfc10,0x35a4,0x35aa,0x9e4,0x2821,0x35b1,1,1,1,1,1,1,
0x9e8,1,1,1,1,0x9ec,0x2827,0x9f0,0x282d,0x9f4,0x2833,0x9f8,0x2839,0x9fc,0x283f,0xa00,
0x2845,0xa04,0x284b,0xa08,0x2851,0xa0c,0x2857,0xa10,0x285d,0xa14,0x2863,0xa18,0x2869,1,0xa1c,0x286f,
0xa20,0x2875,0xa24,0x287b,1,1,1,1,1,0xa28,0x2881,0x2887,0xa30,0x288d,0x2893,0xa38,
0x2899,0x289f,0xa40,0x28a5,0x28ab,0xa48,0x28b1,0x28b7,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0xa50,0xa54,0xa58,0xa5c,1,0x28bd,1,
1,0x28c3,0x28c9,0x28cf,0x28d5,1,1,0xa60,0x28db,0x35b6,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0x35bc,0x35c0,0x660e,0x35c4,0x6612,
0x6616,0x35c8,0x35cc,0x35d0,0x661a,0x661e,0x6622,0x6626,0x662a,0x662e,0x35d5,0x35d8,0x35dc,0x35e0,0x35e5,0x35e8,
0x35ec,0x35f0,0x35f4,0x35f8,0x35fc,0x3600,0x3604,0x3608,0x360c,0x6632,0x6636,0x663a,0x663e,0x6642,0x6646,0x664a,
0x664e,0x6652,0x6656,0x665a,0x665e,0x6662,0x6666,0x666a,0x666e,0x6672,0x6676,0x667a,0x667e,0x6682,0x3611,0x3615,
0x3619,0x361d,0x3621,0x3625,0x3629,0x362d,0x3631,0x3635,0x3639,0x363d,0x3641,0x3645,0x3649,0x364d,0x3651,0x3655,
0x3659,0x365d,0x3661,0x3665,0x3669,0x366d,0x3671,0x3675,0x3679,0x367d,0x3681,0x3685,0x3689,0x368d,0x3691,0x3695,
0x3699,0x369d,0x36a1,0x36a5,0x36a9,0x36ad,0x36b1,0x36b5,0x36b9,1,1,1,0x3245,0x325d,0x36bd,0x36c1,
0x36c5,0x36c9,0x36cd,0x36d1,0x3255,0x36d5,0x36d9,0x36dd,0x36e1,0x3265,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0x36e5,0x36ed,0x36f5,0x36fd,0x3705,0x370d,
0x3715,0x371d,0x3725,0x372d,0x3735,0x373d,0x3745,0x374d,0x60df,0x60e9,0x60f3,0x60fd,0x6107,0x6111,0x611b,0x6125,
0x612f,0x6139,0x6143,0x614d,0x6157,0x6161,0x616b,0x6175,0x6185,1,0x3755,0x375d,0x3765,0x376d,0x3775,0x377d,
0x3785,0x378d,0x3795,0x379d,0x37a5,0x37ad,0x37b5,0x37bd,0x37c5,0x37cd,0x37d5,0x37dd,0x37e5,0x37ed,0x37f5,0x37fd,
0x3805,0x380d,0x3815,0x381d,0x3825,0x382d,0x3835,0x383d,0x3845,0x384d,0x3855,0x385d,0x3865,0x386d,0x3875,0x3879,
0x334d,0x387d,1,1,1,1,1,1,1,1,0x3880,0x3889,0x388f,0x3895,0x389b,0x38a1,
0x38a7,0x38ad,0x38b3,0x38b9,0x38bf,0x38c5,0x38cb,0x38d1,0x38d7,0x38dd,0x35bc,0x35c4,0x35c8,0x35d0,0x35d8,0x35dc,
0x35e8,0x35f0,0x35f4,0x35fc,0x3600,0x3604,0x3608,0x360c,0x6192,0x6198,0x619e,0x61a4,0x61aa,0x61b0,0x61b6,0x61bc,
0x61c2,0x61c8,0x61ce,0x61d4,0x61da,0x61e0,0x61e6,0x61f2,0x61fc,1,0x3245,0x325d,0x36bd,0x36c1,0x38e3,0x38e7,
0x38eb,0x3271,0x38ef,0x32a1,0x3369,0x3399,0x3395,0x336d,0x34dd,0x32c1,0x3361,0x38f3,0x38f7,0x38fb,0x38ff,0x3903,
0x3907,0x390b,0x390f,0x3913,0x3917,0x32d9,0x391b,0x391f,0x3923,0x3927,0x392b,0x392f,0x3933,0x3937,0x36c5,0x36c9,
0x36cd,0x393b,0x393f,0x3943,0x3947,0x394b,0x394f,0x3953,0x3957,0x395b,0x395f,0x3963,0x3969,0x396f,0x3975,0x397b,
0x3981,0x3987,0x398d,0x3993,0x3999,0x399f,0x39a5,0x39ab,0x39b1,0x39b7,0x39bd,0x39c3,0x39c9,0x39cf,0x39d5,0x39db,
0x39e1,0x39e7,0x39ed,0x39f3,0x39fb,0x3a03,0x3a0a,0x3a10,0x3a18,0x3a1e,0x3a27,0x3a2b,0x3a2e,0x3a33,0x3a37,0x3a3a,
0x3a3e,0x3a42,0x3a46,0x3a4a,0x3a4e,0x3a52,0x3a56,0x3a5a,0x3a5e,0x3a62,0x3a66,0x3a6a,0x3a6e,0x3a72,0x3a77,0x3a7b,
0x3a7f,0x3a83,0x3a87,0x3a8a,0x3a8e,0x3a92,0x3a96,0x3a9a,0x3a9f,0x3aa3,0x3aa7,0x3aab,0x3aaf,0x3ab3,0x3ab7,0x3abb,
0x3abf,0x3ac3,0x3ac7,0x3acb,0x3acf,0x3ad2,0x3ad6,0x3ada,0x3ade,1,0x620c,0x3ae3,0x6223,0x3aed,0x6238,0x3af4,
0x3afd,0x6250,0x3b05,0x3b0e,0x3b17,0x3b1f,0x3b26,0x3b31,0x6261,0x626d,0x627c,0x6289,0x3b3b,0x629d,0x3b45,0x62b7,
0x3b4b,0x3b58,0x62c7,0x62d3,0x62ed,0x3b65,0x3b6e,0x3b77,0x6302,0x3b7f,0x3b89,0x6316,0x3b94,0x3b9c,0x6324,0x6330,
0x633b,0x3ba5,0x3bab,0x3bb0,0x3bb8,0x6344,0x6354,0x6361,0x636f,0x637f,0x638a,0x6395,0x63a8,0x3bc0,0x63b9,0x3bcb,
0x3bd3,0x63c8,0x63d2,0x3bde,0x63de,0x63f0,0x63fe,0x640a,0x6418,0x3be7,0x642a,0x3bed,0x3bf5,0x3bfd,0x3c07,0x3c0e,
0x3c16,0x3c1f,0x3c2b,0x3c35,0x6443,0x6456,0x6469,0x3c3b,0x647c,0x3c45,0x3c4d,0x3c55,0x3c5f,0x648f,0x64a3,0x3c65,
0x64bb,0x3c6a,0x3c73,0x3c79,0x3c7f,0x3c85,0x3c8b,0x3c91,0x3c97,0x3c9d,0x3ca3,0x3ca9,0x3caf,0x3cb7,0x3cbf,0x3cc7,
0x3ccf,0x3cd7,0x3cdf,0x3ce7,0x3cef,0x3cf7,0x3cff,0x3d07,0x3d0f,0x3d17,0x3d1f,0x3d26,0x3d2e,0x3d34,0x3d3a,0x3d42,
0x3d48,0x3d4e,0x3d5d,0x3d6d,0x3d74,0x3d7b,0x3d81,0x3d87,0x3d8d,0x3d93,0x3d9c,0x3da2,0x3da8,0x3dae,0x3db4,0x3dba,
0x3dc0,0x3dc6,0x3dcc,0x3dd4,0x3dde,0x3de4,0x3dea,0x3df0,0x3df6,0x3dfc,0x3e02,0x3e08,0x3e10,0x3e18,0x3e20,0x3e2e,
0x3e3a,0x3e46,0x3e52,0x3e58,0x3e5e,0x3e64,0x3e6a,0x3e70,0x3e76,0x3e85,0x3e95,0x3ea3,0x3eb1,0x3ec1,0x3ed1,0x3edf,
0x3eed,0x3ef4,0x3f07,0x3f10,0x3f16,0x3f1e,0x3f26,0x3f2e,0x3f36,0x3f51,0x3f5e,0x3f64,0x3f6a,0x3f70,0x3f76,0x3f7c,
0x3f82,0x3f88,0x3f8e,0x3f94,0x3f9a,0x3fa0,0x3fa6,0x3fac,0x3fb2,0x3fb8,0x3fbe,0x3fc4,0x3fcb,0x3fd5,0x3fda,0x3fe0,
0x3fe6,0x3ff1,0x3ff8,0x3ffe,0x4004,0x400a,0x4010,0x4016,0x401c,0x4022,0x4028,0x402e,0x4034,0x403c,0x4042,0x4048,
0x4050,0x4058,0x405f,0x4068,0x4070,0x4076,0x407c,0x4082,0x4088,0x4090,0x4099,0x409f,0x40a5,0x40ab,0x40b1,0x40b7,
0x40bd,0x40c3,0x40c9,0x40cf,0x40d7,0x40df,0x40e7,0x40ef,0x40f7,0x40ff,0x4107,0x410f,0x4117,0x411f,0x4127,0x412f,
0x4137,0x413f,0x4147,0x414f,0x4157,0x415f,0x4167,0x416f,0x4177,0x417e,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0xffcc,1,1,1,1,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x4187,0x418b,0xffcc,0xffcc,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0xffcc,0xffcc,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0xf9f1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0x418f,0x4193,1,1,1,1,1,1,0xfe12,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,0xfe12,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xffb8,0xffb8,
0xffb8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0xfe12,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0xffcc,1,0xffcc,0xffcc,0xffb8,1,1,0xffcc,0xffcc,1,1,1,
1,1,0xffcc,0xffcc,1,0xffcc,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0xfe12,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0x4197,0xf8c9,0x419b,0xf991,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0xaac,0x1253,0x1253,0x1253,0x1253,
0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,
0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0xaac,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,
0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,
0x1253,0x1253,0x1253,0xaac,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,
0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0xaac,
0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,
0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,0x1253,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0x6782,1,0x6782,0x6782,0x6782,0x6782,0x6782,0x6782,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0x6782,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0x6782,1,1,1,1,0x6782,0x55ae,1,1,0x6782,
1,0x6782,0x55ba,0x65d6,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0x5ffb,1,0x419f,0x41a3,0x34bd,0x41a7,0x41ab,0x41af,0x41b3,0x3595,0x3595,0x41b7,0x34dd,0x41bb,
0x41bf,0x41c3,0x41c7,0x41cb,0x41cf,0x41d3,0x41d7,0x41db,0x41df,0x41e3,0x41e7,0x41eb,0x41ef,0x41f3,0x41f7,0x41fb,
0x41ff,0x4203,0x4207,0x420b,0x420f,0x4213,0x4217,0x421b,0x421f,0x4223,0x4227,0x422b,0x422f,0x4233,0x4237,0x423b,
0x423f,0x4243,0x4247,0x424b,0x424f,0x4253,0x4257,0x425b,0x3435,0x425f,0x4263,0x4267,0x426b,0x426f,0x4273,0x4277,
0x427b,0x427f,0x4283,0x4287,0x3559,0x428b,0x428f,0x4293,0x4297,0x429b,0x429f,0x42a3,0x42a7,0x42ab,0x42af,0x42b3,
0x42b7,0x42bb,0x42bf,0x42c3,0x42c7,0x42cb,0x42cf,0x42d3,0x42d7,0x42db,0x42df,0x42e3,0x42e7,0x42eb,0x42ef,0x42f3,
0x41df,0x42f7,0x42fb,0x42ff,0x4303,0x4307,0x430b,0x430f,0x4313,0x4317,0x431b,0x431f,0x4323,0x4327,0x432b,0x432f,
0x4333,0x4337,0x433b,0x433f,0x4343,0x34c5,0x4347,0x434b,0x434f,0x4353,0x4357,0x435b,0x435f,0x4363,0x4367,0x436b,
0x436f,0x4373,0x4377,0x437b,0x437f,0x32d9,0x4383,0x4387,0x438b,0x438f,0x4393,0x4397,0x439b,0x439f,0x328d,0x43a3,
0x43a7,0x43ab,0x43af,0x43b3,0x43b7,0x43bb,0x43bf,0x43c3,0x43c7,0x43cb,0x43cf,0x43d3,0x43d7,0x43db,0x43df,0x43e3,
0x43e7,0x43eb,0x43ef,0x43f3,0x43f7,0x433f,0x43fb,0x43ff,0x4403,0x4407,0x440b,0x440f,0x4413,0x4417,0x42ff,0x441b,
0x441f,0x4423,0x4427,0x442b,0x442f,0x4433,0x4437,0x443b,0x443f,0x4443,0x4447,0x444b,0x444f,0x4453,0x4457,0x445b,
0x445f,0x4463,0x4467,0x41df,0x446b,0x446f,0x4473,0x4477,0x3591,0x447b,0x447f,0x4483,0x4487,0x448b,0x448f,0x4493,
0x4497,0x449b,0x449f,0x44a3,0x44a7,0x38e7,0x44ab,0x44af,0x44b3,0x44b7,0x44bb,0x44bf,0x44c3,0x44c7,0x44cb,0x4307,
0x44cf,0x44d3,0x44d7,0x44db,0x44df,0x44e3,0x44e7,0x44eb,0x44ef,0x44f3,0x44f7,0x44fb,0x44ff,0x34d9,0x4503,0x4507,
0x450b,0x450f,0x4513,0x4517,0x451b,0x451f,0x4523,0x4527,0x452b,0x452f,0x4533,0x3415,0x4537,0x453b,0x453f,0x4543,
0x4547,0x454b,0x454f,0x4553,0x4557,0x455b,0x455f,0x4563,0x4567,0x456b,0x456f,0x4573,0x3481,0x4577,0x348d,0x457b,
0x457f,0x4583,1,1,0x4587,1,0x458b,1,1,0x458f,0x4593,0x4597,0x459b,0x459f,0x45a3,0x45a7,
0x45ab,0x45af,0x3431,1,0x45b3,1,0x45b7,1,1,0x45bb,0x45bf,1,1,1,0x45c3,0x45c7,
0x45cb,0x45cf,0x45d3,0x45d7,0x45db,0x45df,0x45e3,0x45e7,0x45eb,0x45ef,0x45f3,0x45f7,0x45fb,0x45ff,0x4603,0x4607,
0x32f5,0x460b,0x460f,0x4613,0x4617,0x461b,0x461f,0x4623,0x4627,0x462b,0x462f,0x4633,0x4637,0x463b,0x463f,0x4643,
0x38fb,0x4647,0x464b,0x464f,0x4653,0x390b,0x4657,0x465b,0x465f,0x4663,0x4667,0x43cf,0x466b,0x466f,0x4673,0x4677,
0x467b,0x467f,0x467f,0x4683,0x4687,0x468b,0x468f,0x4693,0x4697,0x469b,0x469f,0x45bb,0x46a3,0x46a7,0x46ab,0x46af,
0x46b3,0x46b9,1,1,0x46bd,0x46c1,0x46c5,0x46c9,0x46cd,0x46d1,0x46d5,0x46d9,0x45f3,0x46dd,0x46e1,0x46e5,
0x4587,0x46e9,0x46ed,0x46f1,0x46f5,0x46f9,0x46fd,0x4701,0x4705,0x4709,0x470d,0x4711,0x4715,0x4613,0x4719,0x4617,
0x471d,0x4721,0x4725,0x4729,0x472d,0x458b,0x4233,0x4731,0x4735,0x3379,0x4343,0x448f,0x4739,0x473d,0x4633,0x4741,
0x4637,0x4745,0x4749,0x474d,0x4593,0x4751,0x4755,0x4759,0x475d,0x4761,0x4597,0x4765,0x4769,0x476d,0x4771,0x4775,
0x4779,0x4667,0x477d,0x4781,0x43cf,0x4785,0x4677,0x4789,0x478d,0x4791,0x4795,0x4799,0x468b,0x479d,0x45b7,0x47a1,
0x468f,0x42f7,0x47a5,0x4693,0x47a9,0x469b,0x47ad,0x47b1,0x47b5,0x47b9,0x47bd,0x46a3,0x45ab,0x47c1,0x46a7,0x47c5,
0x46ab,0x47c9,0x3595,0x47cd,0x47d3,0x47d9,0x47df,0x47e3,0x47e7,0x47eb,0x47f1,0x47f7,0x47fd,0x4801,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0x4804,0x480a,0x4810,0x4816,0x481e,0x482c,0x4832,1,1,1,1,1,
1,1,1,1,1,1,1,0x4839,0x483f,0x4845,0x484b,0x4851,1,1,1,1,
1,0x4856,0xfe34,0x485c,0x4863,0x2e59,0x2e65,0x4867,0x486b,0x486f,0x4873,0x4877,0x487b,0x2dd9,0x487e,0x4884,
0x488c,0x4896,0x489e,0x48a4,0x48aa,0x48b0,0x48b6,0x48bc,0x48c2,0x48c8,0x48ce,1,0x48d4,0x48da,0x48e0,0x48e6,
0x48ec,1,0x48f2,1,0x48f8,0x48fe,1,0x4904,0x490a,1,0x4910,0x4916,0x491c,0x4922,0x4928,0x492e,
0x4934,0x493a,0x4940,0x4947,0x494d,0x494d,0x4951,0x4951,0x4951,0x4951,0x4955,0x4955,0x4955,0x4955,0x4959,0x4959,
0x4959,0x4959,0x495d,0x495d,0x495d,0x495d,0x4961,0x4961,0x4961,0x4961,0x4965,0x4965,0x4965,0x4965,0x4969,0x4969,
0x4969,0x4969,0x496d,0x496d,0x496d,0x496d,0x4971,0x4971,0x4971,0x4971,0x4975,0x4975,0x4975,0x4975,0x4979,0x4979,
0x4979,0x4979,0x497d,0x497d,0x4981,0x4981,0x4985,0x4985,0x4989,0x4989,0x498d,0x498d,0x4991,0x4991,0x4995,0x4995,
0x4999,0x4999,0x4999,0x4999,0x499d,0x499d,0x499d,0x499d,0x49a1,0x49a1,0x49a1,0x49a1,0x49a5,0x49a5,0x49a5,0x49a5,
0x49a9,0x49a9,0x49ad,0x49ad,0x49ad,0x49ad,0x64ca,0x64ca,0x49b0,0x49b0,0x49b0,0x49b0,0x49b5,0x49b5,0x49b5,0x49b5,
0x49b8,0x49b8,0x64d2,0x64d2,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0x49bd,0x49bd,0x49bd,0x49bd,0x49c1,0x49c1,0x49c5,0x49c5,0x49c9,
0x49c9,0x49cf,0x49d5,0x49d5,0x49d9,0x49d9,0x49dd,0x49dd,0x49e1,0x49e1,0x49e1,0x49e1,0x49e5,0x49e5,0x64da,0x64da,
0x64e4,0x64e4,0x64ee,0x64ee,0x64f9,0x64f9,0x6503,0x6503,0x650d,0x650d,0x6517,0x6517,0x6517,0x6521,0x6521,0x6521,
0x49e9,0x49e9,0x49e9,0x49e9,0x652b,0x6535,0x653f,0x6521,0x6548,0x49ed,0x49f3,0x49f9,0x49ff,0x4a05,0x4a0a,0x4a11,
0x4a17,0x4a1d,0x4a23,0x4a29,0x4a2e,0x4a35,0x4a3b,0x4a41,0x4a46,0x4a4d,0x4a53,0x4a59,0x4a5f,0x4a65,0x4a6b,0x4a71,
0x4a77,0x4a7d,0x4a83,0x4a89,0x4a8f,0x4a95,0x4a9b,0x4aa1,0x4aa7,0x4aad,0x4ab3,0x4ab9,0x4abf,0x4ac5,0x4acb,0x4ad1,
0x4ad7,0x4add,0x4ae3,0x4ae9,0x4aef,0x4af5,0x4afa,0x4b01,0x4b07,0x4b0d,0x4b12,0x4b18,0x4b1f,0x4b25,0x4b2b,0x4b31,
0x4b37,0x4b3d,0x4b42,0x4b49,0x4b4f,0x4b55,0x4b5b,0x4b61,0x4b66,0x4b6d,0x4b73,0x4b79,0x4b7f,0x4b85,0x4b8a,0x4b91,
0x4b97,0x4b9d,0x4ba3,0x4ba9,0x4bae,0x4bb5,0x4bbb,0x4bc1,0x4bc6,0x4bcd,0x4bd3,0x4bd9,0x4bdf,0x4be5,0x4bea,0x4bf0,
0x4bf6,0x4bfc,0x4c02,0x4c0a,0x4c12,0x4c1a,0x4c22,0x4c2a,0x6553,0x655d,0x653f,0x6567,0x6521,0x6548,0x4c33,0x4c39,
0x49ff,0x4c3f,0x4a05,0x4a0a,0x4c45,0x4c4b,0x4a23,0x4c51,0x4a29,0x4a2e,0x4c57,0x4c5d,0x4a3b,0x4c63,0x4a41,0x4a46,
0x4af5,0x4afa,0x4b0d,0x4b12,0x4b18,0x4b31,0x4b37,0x4b3d,0x4b42,0x4b5b,0x4b61,0x4b66,0x4c68,0x4b7f,0x4c6f,0x4c75,
0x4ba3,0x4c7b,0x4ba9,0x4bae,0x4bfc,0x4c81,0x4c87,0x4bdf,0x4c8d,0x4be5,0x4bea,0x652b,0x6535,0x6571,0x653f,0x657b,
0x49ed,0x49f3,0x49f9,0x49ff,0x4c93,0x4a11,0x4a17,0x4a1d,0x4a23,0x4c99,0x4a3b,0x4a4d,0x4a53,0x4a59,0x4a5f,0x4a65,
0x4a71,0x4a77,0x4a7d,0x4a83,0x4a89,0x4a8f,0x4c9f,0x4a95,0x4a9b,0x4aa1,0x4aa7,0x4aad,0x4ab3,0x4abf,0x4ac5,0x4acb,
0x4ad1,0x4ad7,0x4add,0x4ae3,0x4ae9,0x4aef,0x4b01,0x4b07,0x4b1f,0x4b25,0x4b2b,0x4b31,0x4b37,0x4b49,0x4b4f,0x4b55,
0x4b5b,0x4ca5,0x4b6d,0x4b73,0x4b79,0x4b7f,0x4b91,0x4b97,0x4b9d,0x4ba3,0x4cab,0x4bb5,0x4bbb,0x4cb0,0x4bcd,0x4bd3,
0x4bd9,0x4bdf,0x4cb7,0x653f,0x657b,0x49ff,0x4c93,0x4a23,0x4c99,0x4a3b,0x4cbd,0x4a89,0x4cc3,0x4cc9,0x4ccf,0x4b31,
0x4b37,0x4b5b,0x4ba3,0x4cab,0x4bdf,0x4cb7,0x4cd4,0x4cdc,0x4ce4,0x4ced,0x4cf2,0x4cf9,0x4cfe,0x4d05,0x4d0a,0x4d11,
0x4d16,0x4d1d,0x4d22,0x4d29,0x4d2e,0x4d35,0x4d3a,0x4d41,0x4d46,0x4d4d,0x4d52,0x4d59,0x4d5e,0x4d65,0x4d6b,0x4d71,
0x4cc9,0x4d77,0x4d7d,0x4d83,0x4d89,0x4ced,0x4cf2,0x4cf9,0x4cfe,0x4d05,0x4d0a,0x4d11,0x4d16,0x4d1d,0x4d22,0x4d29,
0x4d2e,0x4d35,0x4d3a,0x4d41,0x4d46,0x4d4d,0x4d52,0x4d59,0x4d5e,0x4d65,0x4d6b,0x4d71,0x4cc9,0x4d77,0x4d7d,0x4d83,
0x4d89,0x4d65,0x4d6b,0x4d71,0x4cc9,0x4cc3,0x4ccf,0x4ab9,0x4a77,0x4a7d,0x4a83,0x4d65,0x4d6b,0x4d71,0x4ab9,0x4abf,
0x4d8e,0x4d8e,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0x4d95,0x4d9d,0x4d9d,0x4da5,0x4dad,0x4db5,0x4dbd,0x4dc5,0x4dcd,0x4dcd,0x4dd4,0x4ddd,0x4de5,0x4ded,
0x4df5,0x4dfd,0x4dfd,0x4e05,0x4e0d,0x4e0d,0x4e15,0x4e15,0x4e1d,0x4e25,0x4e25,0x4e2c,0x4e35,0x4e35,0x4e3d,0x4e3d,
0x4e45,0x4e4d,0x4e4d,0x4e55,0x4e55,0x4e5d,0x4e64,0x4e6d,0x4e75,0x4e75,0x4e7d,0x4e85,0x4e8c,0x4e95,0x4e9d,0x4e9d,
0x4ea5,0x4ead,0x4eb5,0x4ebc,0x4ec5,0x4ecd,0x4ecd,0x4ed5,0x4ed5,0x4edd,0x4edd,0x4ee5,0x4eed,0x4ef4,0x4efd,0x4f05,
0x4f0d,0x4f15,1,1,0x4f1d,0x4f25,0x4f2d,0x4f35,0x4f3d,0x4f45,0x4f45,0x4f4d,0x4f54,0x4f5d,0x4f65,0x4f65,
0x4f6c,0x4f74,0x4f7d,0x4f84,0x4f8d,0x4f94,0x4f9d,0x4fa4,0x4fad,0x4fb5,0x4fbd,0x4fc4,0x4fcc,0x4fd4,0x4fdc,0x4fe4,
0x4fec,0x4ff4,0x4ffc,0x5004,0x500c,0x5014,0x4ea5,0x4eb5,0x501c,0x5024,0x502d,0x5034,0x503d,0x5045,0x503d,0x502d,
0x504c,0x5054,0x505c,0x5064,0x506c,0x5045,0x4e6d,0x4e1d,0x5074,0x507c,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0x5084,0x508c,0x5095,0x509f,0x50a9,0x50b3,0x50bd,0x50c7,0x50d1,0x50db,0x50e3,0x5109,0x511b,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x5125,
0x5129,0x512d,0x5131,0x2a53,0x5135,0x5139,0x513d,0x5141,0x5149,1,1,1,1,1,1,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffcc,0xffcc,0x5153,
0x5159,0x515d,0x5161,0x5161,0x2de5,0x2de9,0x5165,0x5169,0x516d,0x5171,0x5175,0x5179,0x517d,0x5181,0x2fad,0x2fb1,
0x5185,0x5189,0x518d,0x5191,1,1,0x5195,0x5199,0x519e,0x519e,0x519e,0x519e,0x5161,0x5161,0x5161,0x5125,
0x5129,0x2d67,1,0x2a53,0x5131,0x5139,0x5135,0x5159,0x2de5,0x2de9,0x5165,0x5169,0x516d,0x5171,0x51a5,0x51a9,
0x51ad,0x2dd9,0x51b1,0x51b4,0x51b8,0x2de0,1,0x51bd,0x51c1,0x51c5,0x51c9,1,1,1,1,0x51cc,
0x51d2,0x51d8,1,0x51de,1,0x51e4,0x51ea,0x51f0,0x51f6,0x51fc,0x5202,0x5208,0x520e,0x5214,0x521a,0x5221,
0x6584,0x6584,0x658c,0x658c,0x6594,0x6594,0x659c,0x659c,0x65a4,0x65a4,0x65a4,0x65a4,0x5224,0x5224,0x5229,0x5229,
0x5229,0x5229,0x522d,0x522d,0x5231,0x5231,0x5231,0x5231,0x5235,0x5235,0x5235,0x5235,0x5239,0x5239,0x5239,0x5239,
0x523d,0x523d,0x523d,0x523d,0x5241,0x5241,0x5241,0x5241,0x5245,0x5245,0x5249,0x5249,0x524d,0x524d,0x5251,0x5251,
0x5255,0x5255,0x5255,0x5255,0x5259,0x5259,0x5259,0x5259,0x525d,0x525d,0x525d,0x525d,0x5261,0x5261,0x5261,0x5265,
0x5265,0x5265,0x5265,0x5269,0x5269,0x5269,0x5269,0x526d,0x526d,0x526d,0x526d,0x5271,0x5271,0x5271,0x5271,0x5275,
0x5275,0x5275,0x5275,0x5279,0x5279,0x5279,0x5279,0x527d,0x527d,0x527d,0x527d,0x5281,0x5281,0x5281,0x5281,0x5285,
0x5285,0x5285,0x5285,0x5289,0x5289,0x5289,0x5289,0x528d,0x528d,0x528d,0x528d,0x5290,0x5290,0x49e5,0x49e5,0x5294,
0x5294,0x5294,0x5294,0x65b0,0x65b0,0x65be,0x65be,0x65cc,0x65cc,0x5298,0x5298,1,1,1,0x5135,0x529f,
0x51a5,0x51c1,0x51c5,0x51a9,0x52a3,0x2de5,0x2de9,0x51ad,0x2dd9,0x5125,0x51b1,0x2d67,0x52a7,0x2dbd,0x2985,0x296d,
0x2971,0x2dc1,0x2dc5,0x2dc9,0x2dcd,0x2dd1,0x2dd5,0x5131,0x2a53,0x51b4,0x2de0,0x51b8,0x5139,0x51c9,0x2b84,0x2b8c,
0x2e06,0x2b90,0x2b94,0x2e54,0x2b9c,0x2ba0,0x2ba4,0x2ba8,0x2bac,0x2bb0,0x2bb4,0x2bb8,0x2bbc,0x2bc4,0x2e35,0x2bc8,
0x320a,0x2bcc,0x2bd0,0x2f14,0x2bd4,0x2f36,0x320e,0x2e4c,0x5195,0x51bd,0x5199,0x52ab,0x5161,0x2d3f,0x2962,0x2be4,
0x2c48,0x2be8,0x2bec,0x2c54,0x2bfc,0x29fc,0x2c38,0x2a04,0x2c00,0x2a3c,0x2c04,0x2dec,0x2988,0x2c10,0x3213,0x2a08,
0x29c2,0x2c14,0x2c18,0x2c20,0x2a0c,0x2a40,0x2a10,0x2cb8,0x5165,0x52af,0x5169,0x52b3,0x52b7,0x52bb,0x512d,0x5185,
0x5189,0x5129,0x52bf,0x3ade,0x52c3,0x52c7,0x52cb,0x52cf,0x52d3,0x52d7,0x52db,0x52df,0x52e3,0x52e7,0x3a27,0x3a2b,
0x3a2e,0x3a33,0x3a37,0x3a3a,0x3a3e,0x3a42,0x3a46,0x3a4a,0x3a4e,0x3a52,0x3a56,0x3a5a,0x3a5e,0x3a62,0x3a66,0x3a6a,
0x3a6e,0x3a72,0x3a77,0x3a7b,0x3a7f,0x3a83,0x3a87,0x3a8a,0x3a8e,0x3a92,0x3a96,0x3a9a,0x3a9f,0x3aa3,0x3aa7,0x3aab,
0x3aaf,0x3ab3,0x3ab7,0x3abb,0x3abf,0x3ac3,0x3ac7,0x3acb,0x3acf,0x3ad2,0x52eb,0x6688,0x668e,0x52f3,0x52fa,0x5302,
0x6696,0x530a,0x669e,0x66a6,0x5312,0x531a,0x5322,0x66ae,0x66b6,0x66be,0x66c6,0x66ce,0x66d6,0x532b,0x5332,0x533a,
0x5342,0x534b,0x5352,0x535a,0x5362,0x536a,0x5372,0x537a,0x5382,0x538a,0x5392,0x539a,1,1,0x66de,0x66e6,
0x66ee,0x66f6,0x66fe,0x6706,1,1,0x670e,0x6716,0x671e,0x6726,0x672e,0x6736,1,1,0x673e,0x6746,
0x674e,0x6756,0x675e,0x6766,1,1,0x676e,0x6776,0x677e,1,1,1,0x539f,0x53a3,0x53a7,0x53ac,
0x53b3,0x53b7,0x53bb,1,0x53bf,0x53c2,0x53c7,0x53ca,0x53cf,0x53d3,0x53d7,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0xffb8,1,0xffcc,1,
1,1,1,1,1,1,1,0xffcc,0xfe02,0xffb8,1,1,1,1,0xfe12,1,
1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,1,1,1,1,1,1,1,1,0xffb8,
0xffb8,0xffcc,0xffcc,0xffcc,0xffb8,0xffcc,0xffb8,0xffb8,0xffb8,1,1,1,1,1,1,1,
1,1,0xa64,0x28e1,0xa6a,0x28eb,1,1,1,1,1,0xa70,1,1,1,1,
1,0x28f5,1,1,1,1,1,1,1,1,1,0xfe12,0xfc0e,1,1,1,
1,1,1,1,0xfc00,1,1,1,1,1,1,0x28ff,0x2909,1,0xa76,0xa7c,
0xfe12,0xfe12,1,1,1,1,1,1,1,1,1,1,1,0xfe12,1,1,
1,1,1,1,1,1,1,0xfe0e,1,1,1,1,1,0xfe12,0xfe0e,1,
1,1,1,1,1,1,1,1,0xfe0e,0xfe12,1,1,1,1,1,1,
1,1,1,1,1,0xfe0e,0xfe0e,1,0xfc00,1,1,1,1,1,1,1,
0xa82,1,1,1,0x2913,0x291d,0xfe12,1,1,1,1,1,1,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,0xffcc,0xffcc,1,1,1,0xfe12,1,1,1,0xfe0e,1,1,1,1,
1,1,1,1,1,0xfc00,1,1,1,1,1,1,1,1,0xa8e,0xfc00,
0x2927,0x2931,0xfc00,0x293b,1,1,0xfe12,0xfe0e,1,1,1,1,1,1,1,1,
1,1,1,1,0xaa0,0xaa6,0x2945,0x294f,1,1,1,0xfe12,0xfe0e,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0xfe12,0xfe0e,1,1,
1,1,1,1,1,1,0xfe02,0xfe02,0xfe02,0xfe02,0xfe02,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0xfe02,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0x53da,0x53e4,0x53f8,0x5410,0x5428,0x5440,0x5458,0xffb0,
0xffb0,0xfe02,0xfe02,0xfe02,1,1,1,0xffc4,0xffb0,0xffb0,0xffb0,1,1,1,1,1,
1,1,1,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,1,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffb8,
0xffb8,1,1,1,1,1,1,1,1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,1,
1,1,1,1,1,1,1,1,1,1,0x5466,0x5470,0x5484,0x549c,0x54b4,0x54cc,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0x2a0c,
0x2a40,0x2a10,0x2cb8,0x2b84,0x2b8c,0x2e06,0x2b90,0x2b94,0x2e54,0x2b9c,0x2ba0,0x2ba4,0x2ba8,0x2bac,0x2bb0,0x2c48,
0x2be8,0x2bec,0x2c54,0x2bfc,1,0x2c38,0x2a04,0x2c00,0x2a3c,0x2c04,0x2dec,0x2988,0x2c10,0x3213,0x2a08,0x29c2,
0x2c14,0x2c18,0x2c20,0x2a0c,0x2a40,0x2a10,0x2cb8,0x2b84,0x2b8c,0x2e06,0x2b90,0x2b94,0x2e54,0x2b9c,0x2ba0,0x2988,
0x2c10,0x3213,0x2a08,0x29c2,0x2c14,0x2c18,0x2c20,0x2a0c,0x2a40,0x2a10,0x2cb8,0x2b84,1,0x2e06,0x2b90,1,
1,0x2b9c,1,1,0x2ba8,0x2bac,1,1,0x2bb8,0x2bbc,0x2bc4,0x2e35,1,0x320a,0x2bcc,0x2bd0,
0x2f14,0x2bd4,0x2f36,0x320e,0x2e4c,0x2962,0x2be4,0x2c48,0x2be8,1,0x2c54,1,0x29fc,0x2c38,0x2a04,0x2c00,
0x2a3c,0x2c04,0x2dec,1,0x2c10,0x3213,0x2a08,0x29c2,0x2c14,0x2c18,0x2c20,0x2a0c,0x2a40,0x2a10,0x2cb8,0x2b84,
0x2b8c,1,0x2b90,0x2b94,0x2e54,0x2b9c,1,1,0x2ba8,0x2bac,0x2bb0,0x2bb4,0x2bb8,0x2bbc,0x2bc4,0x2e35,
1,0x320a,0x2bcc,0x2bd0,0x2f14,0x2bd4,0x2f36,0x320e,1,0x2962,0x2be4,0x2ba4,0x2ba8,0x2bac,0x2bb0,0x2bb4,
1,0x2bbc,1,1,1,0x320a,0x2bcc,0x2bd0,0x2f14,0x2bd4,0x2f36,0x320e,1,0x2962,0x2be4,0x2c48,
0x2be8,0x2bec,0x2c54,0x2bfc,0x29fc,0x2c38,0x2a04,0x2c00,0x2a3c,0x2c04,0x2dec,0x2a0c,0x2a40,0x2a10,0x2cb8,0x54db,
0x54df,1,1,0x54e2,0x54e7,0x2e75,0x54eb,0x54ee,0x54f3,0x54f6,0x2a65,0x54fa,0x54ff,0x5503,0x5507,0x550b,
0x550f,0x5512,0x2e79,0x5516,0x551f,0x2a69,0x5523,0x5526,0x552b,0x552f,0x5533,0x2e50,0x5537,0x553a,0x2c25,0x2c29,
0x2c2d,0x553e,0x5543,0x5546,0x2cc9,0x2cd8,0x554b,0x554f,0x297b,0x5553,0x5557,0x555a,0x2e71,0x2c3c,0x555f,0x5563,
0x5567,0x556a,0x2c31,0x2c35,0x556f,0x5572,0x5577,0x557e,0x5587,0x558f,0x5597,0x559e,0x55a7,0x54e2,0x54e7,0x2e75,
0x54eb,0x54ee,0x54f3,0x54f6,0x2a65,0x54fa,0x54ff,0x5503,0x5507,0x550b,0x550f,0x2c35,0x556f,0x5572,0x5577,0x557e,
0x5587,0x558f,0x5597,0x559e,0x55a7,0x55ab,0x55af,1,1,0x2dbd,0x2985,0x296d,0x2971,0x2dc1,0x2dc5,0x2dc9,
0x2dcd,0x2dd1,0x2dd5,0x2dbd,0x2985,0x296d,0x2971,0x2dc1,0x2dc5,0x2dc9,0x2dcd,0x2dd1,0x2dd5,0x2dbd,0x2985,0x296d,
0x2971,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,1,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,1,0xffcc,0xffcc,1,0xffcc,0xffcc,0xffcc,
0xffcc,0xffcc,1,1,1,1,1,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,0xffb8,1,1,
1,1,1,1,1,1,1,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xffcc,0xfe0e,1,1,
1,1,1,0x5224,0x5229,0x5239,0x5245,1,0x5290,0x5251,0x523d,0x5265,0x5294,0x527d,0x5281,0x5285,
0x5289,0x5255,0x526d,0x5275,0x525d,0x5279,0x524d,0x5259,0x5231,0x5235,0x5241,0x5249,0x5261,0x5269,0x5271,0x55b3,
0x49a9,0x55b7,0x55bb,1,0x5229,0x5239,1,0x528d,1,1,0x523d,1,0x5294,0x527d,0x5281,0x5285,
0x5289,0x5255,0x526d,0x5275,0x525d,0x5279,1,0x5259,0x5231,0x5235,0x5241,1,0x5261,1,0x5271,1,
1,1,1,0x5239,1,1,1,1,0x523d,1,0x5294,1,0x5281,1,0x5289,0x5255,
0x526d,1,0x525d,0x5279,1,0x5259,1,1,0x5241,1,0x5261,1,0x5271,1,0x49a9,1,
0x55bb,1,0x5229,0x5239,1,0x528d,1,1,0x523d,0x5265,0x5294,0x527d,1,0x5285,0x5289,0x5255,
0x526d,0x5275,0x525d,0x5279,1,0x5259,0x5231,0x5235,0x5241,1,0x5261,0x5269,0x5271,0x55b3,1,0x55b7,
1,0x5224,0x5229,0x5239,0x5245,0x528d,0x5290,0x5251,0x523d,0x5265,0x5294,1,0x5281,0x5285,0x5289,0x5255,
0x526d,0x5275,0x525d,0x5279,0x524d,0x5259,0x5231,0x5235,0x5241,0x5249,0x5261,0x5269,0x5271,1,1,1,
1,0x5229,0x5239,0x5245,1,0x5290,0x5251,0x523d,0x5265,0x5294,1,0x5281,0x5285,0x5289,0x5255,0x526d,
0x55bf,0x55c5,0x55cb,0x55d1,0x55d7,0x55dd,0x55e3,0x55e9,0x55ef,0x55f5,0x55fb,1,1,1,1,1,
0x5601,0x5609,0x5611,0x5619,0x5621,0x5629,0x5631,0x5639,0x5641,0x5649,0x5651,0x5659,0x5661,0x5669,0x5671,0x5679,
0x5681,0x5689,0x5691,0x5699,0x56a1,0x56a9,0x56b1,0x56b9,0x56c1,0x56c9,0x56d1,0x2e06,0x2bc8,0x56d8,0x56de,1,
0x2e35,0x2bc8,0x320a,0x2bcc,0x2bd0,0x2f14,0x2bd4,0x2f36,0x320e,0x2e4c,0x56e4,0x3f94,0x56ea,0x56f0,0x56f6,0x56fe,
1,1,1,1,1,1,1,1,1,1,0x5704,0x570a,1,1,1,1,
0x5710,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x5716,0x571c,0x3a4e,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x3341,0x5723,0x5727,0x65d6,0x325d,0x572b,0x572f,0x36dd,0x5733,0x5737,0x573b,0x4467,0x573f,0x5743,0x5747,0x574b,
0x574f,0x5753,0x33d1,0x5757,0x575b,0x575f,0x5763,0x5767,0x576b,0x3245,0x36bd,0x576f,0x393b,0x36c9,0x393f,0x5773,
0x34b1,0x5777,0x577b,0x577f,0x5783,0x5787,0x38f7,0x3369,0x578b,0x578f,0x5793,0x5797,1,1,1,1,
0x579b,0x57a3,0x57ab,0x57b3,0x57bb,0x57c3,0x57cb,0x57d3,0x57db,1,1,1,1,1,1,1,
0x57e3,0x57e7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
0x57eb,0x57ef,0x57f3,0x57f7,0x57fd,0x45db,0x5801,0x5805,0x5809,0x580d,0x45df,0x5811,0x5815,0x5819,0x45e3,0x581f,
0x5823,0x5827,0x582b,0x5831,0x5835,0x5747,0x5839,0x583f,0x5843,0x5847,0x584b,0x46c1,0x584f,0x3285,0x5855,0x5859,
0x585d,0x5861,0x578f,0x5865,0x5869,0x46d5,0x45e7,0x45eb,0x46d9,0x586d,0x5871,0x430f,0x5875,0x45ef,0x5879,0x587d,
0x5881,0x5885,0x5885,0x5885,0x5889,0x588f,0x5893,0x5897,0x589b,0x58a1,0x58a5,0x58a9,0x58ad,0x58b1,0x58b5,0x58b9,
0x58bd,0x58c1,0x58c5,0x58c9,0x58cd,0x58d1,0x58d1,0x46e1,0x58d5,0x58d9,0x58dd,0x58e1,0x45f7,0x58e5,0x58e9,0x58ed,
0x4557,0x58f1,0x58f5,0x58f9,0x58fd,0x5901,0x5905,0x5909,0x590d,0x5911,0x5917,0x591b,0x591f,0x572b,0x5923,0x5927,
0x592b,0x5931,0x5937,0x593b,0x593f,0x5943,0x5947,0x594b,0x594f,0x5953,0x5957,0x5957,0x595b,0x5961,0x5965,0x42ff,
0x5969,0x596d,0x5973,0x5977,0x597b,0x32ed,0x597f,0x5983,0x32f5,0x5987,0x598b,0x598f,0x5995,0x5999,0x599f,0x59a3,
0x59a7,0x59ab,0x59af,0x59b3,0x59b7,0x59bb,0x59bf,0x59c3,0x59c7,0x59cb,0x59d1,0x59d5,0x59d9,0x59dd,0x422f,0x59e1,
0x331d,0x59e7,0x59e7,0x59ed,0x59f1,0x59f1,0x59f5,0x59f9,0x59ff,0x5a05,0x5a09,0x5a0d,0x5a11,0x5a15,0x5a19,0x5a1d,
0x5a21,0x5a25,0x5a29,0x460b,0x5a2d,0x5a33,0x5a37,0x5a3b,0x4711,0x5a3b,0x5a3f,0x4613,0x5a43,0x5a47,0x5a4b,0x5a4f,
0x4617,0x41c3,0x5a53,0x5a57,0x5a5b,0x5a5f,0x5a63,0x5a67,0x5a6b,0x5a71,0x5a75,0x5a79,0x5a7d,0x5a81,0x5a85,0x5a8b,
0x5a8f,0x5a93,0x5a97,0x5a9b,0x5a9f,0x5aa3,0x5aa7,0x5aab,0x461b,0x5aaf,0x5ab3,0x5ab9,0x5abd,0x5ac1,0x5ac5,0x4623,
0x5ac9,0x5acd,0x5ad1,0x5ad5,0x5ad9,0x5add,0x5ae1,0x5ae5,0x4233,0x4731,0x5ae9,0x5aed,0x5af1,0x5af5,0x5afb,0x5aff,
0x5b03,0x5b07,0x4627,0x5b0b,0x5b11,0x5b15,0x5b19,0x47df,0x5b1d,0x5b21,0x5b25,0x5b29,0x5b2d,0x5b33,0x5b37,0x5b3b,
0x5b3f,0x5b45,0x5b49,0x5b4d,0x5b51,0x4343,0x5b55,0x5b59,0x5b5f,0x5b65,0x5b6b,0x5b6f,0x5b75,0x5b79,0x5b7d,0x5b81,
0x5b85,0x462b,0x448f,0x5b89,0x5b8d,0x5b91,0x5b95,0x5b9b,0x5b9f,0x5ba3,0x5ba7,0x473d,0x5bab,0x5baf,0x5bb5,0x5bb9,
0x5bbd,0x5bc3,0x5bc9,0x5bcd,0x4741,0x5bd1,0x5bd5,0x5bd9,0x5bdd,0x5be1,0x5be5,0x5be9,0x5bef,0x5bf3,0x5bf9,0x5bfd,
0x5c03,0x4749,0x5c07,0x5c0b,0x5c11,0x5c15,0x5c19,0x5c1f,0x5c25,0x5c29,0x5c2d,0x5c31,0x5c35,0x5c35,0x5c39,0x5c3d,
0x4751,0x5c41,0x5c45,0x5c49,0x5c4d,0x5c51,0x5c57,0x5c5b,0x430b,0x5c61,0x5c67,0x5c6b,0x5c71,0x5c77,0x5c7d,0x5c81,
0x4769,0x5c85,0x5c8b,0x5c91,0x5c97,0x5c9d,0x5ca1,0x5ca1,0x476d,0x47e7,0x5ca5,0x5ca9,0x5cad,0x5cb1,0x5cb7,0x4277,
0x4775,0x5cbb,0x5cbf,0x4653,0x5cc5,0x5ccb,0x45a7,0x5cd1,0x5cd5,0x465f,0x5cd9,0x5cdd,0x5ce1,0x5ce7,0x5ce7,0x5ced,
0x5cf1,0x5cf5,0x5cfb,0x5cff,0x5d03,0x5d07,0x5d0d,0x5d11,0x5d15,0x5d19,0x5d1d,0x5d21,0x5d27,0x5d2b,0x5d2f,0x5d33,
0x5d37,0x5d3b,0x5d3f,0x5d45,0x5d4b,0x5d4f,0x5d55,0x5d59,0x5d5f,0x5d63,0x4677,0x5d67,0x5d6d,0x5d73,0x5d77,0x5d7d,
0x5d81,0x5d87,0x5d8b,0x5d8f,0x5d93,0x5d97,0x5d9b,0x5d9f,0x5da5,0x5dab,0x5db1,0x59ed,0x5db7,0x5dbb,0x5dbf,0x5dc3,
0x5dc7,0x5dcb,0x5dcf,0x5dd3,0x5dd7,0x5ddb,0x5ddf,0x5de3,0x434f,0x5de9,0x5ded,0x5df1,0x5df5,0x5df9,0x5dfd,0x4683,
0x5e01,0x5e05,0x5e09,0x5e0d,0x5e11,0x5e17,0x5e1d,0x5e23,0x5e27,0x5e2b,0x5e2f,0x5e33,0x5e39,0x5e3d,0x5e43,0x5e47,
0x5e4b,0x5e51,0x5e57,0x5e5b,0x4263,0x5e5f,0x5e63,0x5e67,0x5e6b,0x5e6f,0x5e73,0x4791,0x5e77,0x5e7b,0x5e7f,0x5e83,
0x5e87,0x5e8b,0x5e8f,0x5e93,0x3485,0x5e97,0x5e9d,0x5ea1,0x5ea5,0x5ea9,0x5ead,0x5eb1,0x5eb7,0x5ebd,0x5ec1,0x5ec5,
0x47a5,0x47a9,0x34a1,0x5ec9,0x5ecf,0x5ed3,0x5ed7,0x5edb,0x5edf,0x5ee5,0x5eeb,0x5eef,0x5ef3,0x5ef7,0x5efd,0x47ad,
0x5f01,0x5f07,0x5f0d,0x5f11,0x5f15,0x5f19,0x5f1f,0x5f23,0x5f27,0x5f2b,0x5f2f,0x5f33,0x5f37,0x5f3b,0x5f41,0x5f45,
0x5f49,0x5f4d,0x5f53,0x5f57,0x5f5b,0x5f5f,0x5f63,0x5f69,0x5f6f,0x5f73,0x5f77,0x5f7b,0x5f81,0x5f85,0x47c5,0x47c5,
0x5f8b,0x5f8f,0x5f95,0x5f99,0x5f9d,0x5fa1,0x5fa5,0x5fa9,0x5fad,0x5fb1,0x47c9,0x5fb7,0x5fbb,0x5fbf,0x5fc3,0x5fc7,
0x5fcb,0x5fd1,0x5fd5,0x5fdb,0x5fe1,0x3561,0x5fe7,0x3571,0x5feb,0x5fef,0x5ff3,0x5ff7,0x3585,0x5ffb,1,1,
1
};

static const normalization_trie norm2_nfkc_data_trie={
    norm2_nfkc_data_trieIndex,
    norm2_nfkc_data_trieData,
    1839, 11617,
    0x2fc00, 0x30,
    0, 0,
    0, 0,
    0xd0, 0x22b,
    0x1,
};

static const uint16_t norm2_nfkc_data_extraData[13250]={
0xffff,0xffff,0x8670,0x44dc,0x8670,0x44c0,0x8670,0x44de,0x600,0x180,0x602,0x182,0x604,0x185,0x606,0x186,
0x608,0x200,0x60c,0x205,0x60e,0x44d,0x610,0x189,0x612,0x3d44,0x614,0x18b,0x618,0x39a,0x61e,0x400,
0x622,0x404,0x646,0x3d41,0x64a,0x3c00,0x8650,0x208,0x60e,0x3c04,0x646,0x3c08,0x8662,0x3c0c,0x602,0x20c,
0x604,0x210,0x60e,0x214,0x618,0x218,0x864e,0x18f,0x60e,0x3c14,0x618,0x21c,0x646,0x3c18,0x64e,0x3c20,
0x65a,0x3c24,0x8662,0x3c1c,0x600,0x190,0x602,0x192,0x604,0x195,0x606,0x3d78,0x608,0x225,0x60c,0x228,
0x60e,0x22c,0x610,0x196,0x612,0x3d74,0x618,0x234,0x61e,0x408,0x622,0x40c,0x646,0x3d71,0x64e,0x451,
0x650,0x230,0x65a,0x3c30,0x8660,0x3c34,0x860e,0x3c3c,0x602,0x3e8,0x604,0x238,0x608,0x3c40,0x60c,0x23c,
0x60e,0x240,0x618,0x3cc,0x864e,0x244,0x604,0x248,0x60e,0x3c44,0x610,0x3c4c,0x618,0x43c,0x646,0x3c48,
0x64e,0x3c50,0x865c,0x3c54,0x600,0x198,0x602,0x19a,0x604,0x19c,0x606,0x250,0x608,0x254,0x60c,0x258,
0x60e,0x260,0x610,0x19f,0x612,0x3d90,0x618,0x39e,0x61e,0x410,0x622,0x414,0x646,0x3d94,0x650,0x25c,
0x8660,0x3c58,0x8604,0x268,0x602,0x3c60,0x618,0x3d0,0x646,0x3c64,0x64e,0x26c,0x8662,0x3c68,0x602,0x272,
0x618,0x27a,0x646,0x3c6d,0x64e,0x276,0x65a,0x3c78,0x8662,0x3c74,0x602,0x3c7c,0x60e,0x3c80,0x8646,0x3c84,
0x600,0x3f0,0x602,0x286,0x606,0x1a2,0x60e,0x3c88,0x618,0x28e,0x646,0x3c8c,0x64e,0x28a,0x65a,0x3c94,
0x8662,0x3c90,0x600,0x1a4,0x602,0x1a6,0x604,0x1a9,0x606,0x1ab,0x608,0x299,0x60c,0x29c,0x60e,0x45d,
0x610,0x1ad,0x612,0x3d9c,0x616,0x2a0,0x618,0x3a2,0x61e,0x418,0x622,0x41c,0x636,0x341,0x646,0x3d99,
0x8650,0x3d5,0x602,0x3ca8,0x860e,0x3cac,0x602,0x2a8,0x60e,0x3cb0,0x618,0x2b0,0x61e,0x420,0x622,0x424,
0x646,0x3cb5,0x64e,0x2ac,0x8662,0x3cbc,0x602,0x2b5,0x604,0x2b8,0x60e,0x3cc0,0x618,0x2c1,0x646,0x3cc5,
0x64c,0x430,0x864e,0x2bc,0x60e,0x3cd4,0x618,0x2c8,0x646,0x3cd8,0x64c,0x434,0x64e,0x2c4,0x65a,0x3ce0,
0x8662,0x3cdc,0x600,0x1b2,0x602,0x1b4,0x604,0x1b6,0x606,0x2d1,0x608,0x2d5,0x60c,0x2d8,0x610,0x1b9,
0x612,0x3dcc,0x614,0x2dc,0x616,0x2e0,0x618,0x3a6,0x61e,0x428,0x622,0x42c,0x636,0x35f,0x646,0x3dc8,
0x648,0x3ce4,0x650,0x2e4,0x65a,0x3cec,0x8660,0x3ce8,0x606,0x3cf8,0x8646,0x3cfc,0x600,0x3d00,0x602,0x3d04,
0x604,0x2e8,0x60e,0x3d0c,0x610,0x3d08,0x8646,0x3d10,0x60e,0x3d14,0x8610,0x3d18,0x600,0x3de4,0x602,0x1ba,
0x604,0x2ec,0x606,0x3df0,0x608,0x464,0x60e,0x3d1c,0x610,0x2f0,0x612,0x3dec,0x8646,0x3de8,0x602,0x2f2,
0x604,0x3d20,0x60e,0x2f6,0x618,0x2fa,0x646,0x3d24,0x8662,0x3d28,0x600,0x1c0,0x602,0x1c2,0x604,0x1c5,
0x606,0x1c6,0x608,0x202,0x60c,0x207,0x60e,0x44f,0x610,0x1c9,0x612,0x3d46,0x614,0x1cb,0x618,0x39c,
0x61e,0x402,0x622,0x406,0x646,0x3d43,0x64a,0x3c02,0x8650,0x20a,0x60e,0x3c06,0x646,0x3c0a,0x8662,0x3c0e,
0x602,0x20e,0x604,0x212,0x60e,0x216,0x618,0x21a,0x864e,0x1cf,0x60e,0x3c16,0x618,0x21e,0x646,0x3c1a,
0x64e,0x3c22,0x65a,0x3c26,0x8662,0x3c1e,0x600,0x1d0,0x602,0x1d2,0x604,0x1d5,0x606,0x3d7a,0x608,0x227,
0x60c,0x22a,0x60e,0x22e,0x610,0x1d6,0x612,0x3d76,0x618,0x236,0x61e,0x40a,0x622,0x40e,0x646,0x3d73,
0x64e,0x453,0x650,0x232,0x65a,0x3c32,0x8660,0x3c36,0x860e,0x3c3e,0x602,0x3ea,0x604,0x23a,0x608,0x3c42,
0x60c,0x23e,0x60e,0x242,0x618,0x3ce,0x864e,0x246,0x604,0x24a,0x60e,0x3c46,0x610,0x3c4e,0x618,0x43e,
0x646,0x3c4a,0x64e,0x3c52,0x65c,0x3c56,0x8662,0x3d2c,0x600,0x1d8,0x602,0x1da,0x604,0x1dc,0x606,0x252,
0x608,0x256,0x60c,0x25a,0x610,0x1df,0x612,0x3d92,0x618,0x3a0,0x61e,0x412,0x622,0x416,0x646,0x3d96,
0x650,0x25e,0x8660,0x3c5a,0x604,0x26a,0x8618,0x3e0,0x602,0x3c62,0x618,0x3d2,0x646,0x3c66,0x64e,0x26e,
0x8662,0x3c6a,0x602,0x274,0x618,0x27c,0x646,0x3c6f,0x64e,0x278,0x65a,0x3c7a,0x8662,0x3c76,0x602,0x3c7e,
0x60e,0x3c82,0x8646,0x3c86,0x600,0x3f2,0x602,0x288,0x606,0x1e2,0x60e,0x3c8a,0x618,0x290,0x646,0x3c8e,
0x64e,0x28c,0x65a,0x3c96,0x8662,0x3c92,0x600,0x1e4,0x602,0x1e6,0x604,0x1e9,0x606,0x1eb,0x608,0x29b,
0x60c,0x29e,0x60e,0x45f,0x610,0x1ed,0x612,0x3d9e,0x616,0x2a2,0x618,0x3a4,0x61e,0x41a,0x622,0x41e,
0x636,0x343,0x646,0x3d9b,0x8650,0x3d7,0x602,0x3caa,0x860e,0x3cae,0x602,0x2aa,0x60e,0x3cb2,0x618,0x2b2,
0x61e,0x422,0x622,0x426,0x646,0x3cb7,0x64e,0x2ae,0x8662,0x3cbe,0x602,0x2b7,0x604,0x2ba,0x60e,0x3cc2,
0x618,0x2c3,0x646,0x3cc7,0x64c,0x432,0x864e,0x2be,0x60e,0x3cd6,0x610,0x3d2e,0x618,0x2ca,0x646,0x3cda,
0x64c,0x436,0x64e,0x2c6,0x65a,0x3ce2,0x8662,0x3cde,0x600,0x1f2,0x602,0x1f4,0x604,0x1f6,0x606,0x2d3,
0x608,0x2d7,0x60c,0x2da,0x610,0x1f9,0x612,0x3dce,0x614,0x2de,0x616,0x2e2,0x618,0x3a8,0x61e,0x42a,
0x622,0x42e,0x636,0x361,0x646,0x3dca,0x648,0x3ce6,0x650,0x2e6,0x65a,0x3cee,0x8660,0x3cea,0x606,0x3cfa,
0x8646,0x3cfe,0x600,0x3d02,0x602,0x3d06,0x604,0x2ea,0x60e,0x3d0e,0x610,0x3d0a,0x614,0x3d30,0x8646,0x3d12,
0x60e,0x3d16,0x8610,0x3d1a,0x600,0x3de6,0x602,0x1fa,0x604,0x2ee,0x606,0x3df2,0x608,0x466,0x60e,0x3d1e,
0x610,0x1fe,0x612,0x3dee,0x614,0x3d32,0x8646,0x3dea,0x602,0x2f4,0x604,0x3d22,0x60e,0x2f8,0x618,0x2fc,
0x646,0x3d26,0x8662,0x3d2a,0x602,0x3f8,0x8608,0x3c4,0x8602,0x3fc,0x602,0x3fa,0x8608,0x3c6,0x8602,0x3fe,
0x8618,0x3dc,0x8618,0x3de,0x600,0x3f74,0x602,0x70c,0x608,0x3f72,0x60c,0x3f70,0x626,0x3e11,0x628,0x3e13,
0x868a,0x3f78,0x600,0x3f90,0x602,0x710,0x626,0x3e31,0x8628,0x3e33,0x600,0x3f94,0x602,0x712,0x626,0x3e51,
0x628,0x3e53,0x868a,0x3f98,0x600,0x3fb4,0x602,0x714,0x608,0x3fb2,0x60c,0x3fb0,0x610,0x754,0x626,0x3e71,
0x8628,0x3e73,0x600,0x3ff0,0x602,0x718,0x626,0x3e91,0x8628,0x3e93,0x8628,0x3fd8,0x600,0x3fd4,0x602,0x71c,
0x608,0x3fd2,0x60c,0x3fd0,0x610,0x756,0x8628,0x3eb3,0x600,0x3ff4,0x602,0x71e,0x626,0x3ed1,0x628,0x3ed3,
0x868a,0x3ff8,0x600,0x3ee1,0x602,0x759,0x608,0x3f62,0x60c,0x3f60,0x626,0x3e01,0x628,0x3e03,0x684,0x3f6d,
0x868a,0x3f66,0x600,0x3ee4,0x602,0x75a,0x626,0x3e21,0x8628,0x3e23,0x600,0x3ee9,0x602,0x75d,0x626,0x3e41,
0x628,0x3e43,0x684,0x3f8d,0x868a,0x3f86,0x600,0x3eec,0x602,0x75e,0x608,0x3fa2,0x60c,0x3fa0,0x610,0x795,
0x626,0x3e61,0x628,0x3e63,0x8684,0x3fac,0x600,0x3ef0,0x602,0x798,0x626,0x3e81,0x8628,0x3e83,0x626,0x3fc8,
0x8628,0x3fca,0x600,0x3ef4,0x602,0x79a,0x608,0x3fc2,0x60c,0x3fc0,0x610,0x797,0x626,0x3ea1,0x628,0x3ea3,
0x8684,0x3fcc,0x600,0x3ef9,0x602,0x79d,0x626,0x3ec1,0x628,0x3ec3,0x684,0x3fed,0x868a,0x3fe6,0x8610,0x80e,
0x60c,0x9a0,0x8610,0x9a4,0x8602,0x806,0x600,0x800,0x60c,0x9ac,0x8610,0x802,0x60c,0x982,0x8610,0x9b8,
0x8610,0x9bc,0x600,0x81a,0x608,0x9c4,0x60c,0x832,0x8610,0x9c8,0x8602,0x818,0x8610,0x9cc,0x608,0x9dc,
0x60c,0x81c,0x610,0x9e0,0x8616,0x9e4,0x8610,0x9e8,0x8610,0x9f0,0x8610,0x9d8,0x60c,0x9a2,0x8610,0x9a6,
0x8602,0x8a6,0x600,0x8a0,0x60c,0x9ae,0x8610,0x8a2,0x60c,0x984,0x8610,0x9ba,0x8610,0x9be,0x600,0x8ba,
0x608,0x9c6,0x60c,0x872,0x8610,0x9ca,0x8602,0x8b8,0x8610,0x9ce,0x608,0x9de,0x60c,0x8bc,0x610,0x9e2,
0x8616,0x9e6,0x8610,0x9ea,0x8610,0x9f2,0x8610,0x9da,0x8610,0x8ae,0x861e,0x8ec,0x861e,0x8ee,0x8610,0x9b4,
0x8610,0x9b6,0x8610,0x9d4,0x8610,0x9d6,0xca6,0xc44,0xca8,0xc46,0x8caa,0xc4a,0x8ca8,0xc48,0x8ca8,0xc4c,
0x8ca8,0xd84,0x8ca8,0xda6,0x8ca8,0xd80,0x9278,0x1252,0x9278,0x1262,0x9278,0x1268,0x137c,0x1396,0x93ae,0x1398,
0x167c,0x1696,0x16ac,0x1690,0x96ae,0x1698,0x97ae,0x1728,0x177c,0x1794,0x97ae,0x1798,0x977c,0x1796,0x98ac,0x1890,
0x99aa,0x1980,0x1984,0x1995,0x19aa,0x198e,0x99ac,0x1990,0x1a7c,0x1a94,0x9aae,0x1a98,0x9a7c,0x1a96,0x1b94,0x1bb4,
0x1b9e,0x1bb9,0x9bbe,0x1bbc,0xa05c,0x204c,0xb66a,0x360c,0xb66a,0x3610,0xb66a,0x3614,0xb66a,0x3618,0xb66a,0x361c,
0xb66a,0x3624,0xb66a,0x3676,0xb66a,0x367a,0xb66a,0x3680,0xb66a,0x3682,0xb66a,0x3686,0x8670,0x4334,0x8670,0x4336,
0x8670,0x435c,0x8670,0x439a,0x8670,0x439e,0x8670,0x439c,0x8670,0x4408,0x8670,0x4412,0x8670,0x4418,0x8670,0x4448,
0x8670,0x444c,0x8670,0x4482,0x8670,0x4488,0x8670,0x448e,0x8670,0x4492,0x8670,0x44da,0x8670,0x44c4,0x8670,0x44e0,
0x8670,0x44e2,0x8670,0x44e8,0x8670,0x44ea,0x8670,0x44f0,0x8670,0x44f2,0x8670,0x4500,0x8670,0x4502,0x8670,0x45c0,
0x8670,0x45c2,0x8670,0x4508,0x8670,0x450a,0x8670,0x4510,0x8670,0x4512,0x8670,0x45c4,0x8670,0x45c6,0x8670,0x4558,
0x8670,0x455a,0x8670,0x455c,0x8670,0x455e,0x8670,0x45d4,0x8670,0x45d6,0x8670,0x45d8,0x8670,0x45da,0xe132,0x6128,
0xe132,0x6098,0xe132,0x609c,0xe132,0x60a0,0xe132,0x60a4,0xe132,0x60a8,0xe132,0x60ac,0xe132,0x60b0,0xe132,0x60b4,
0xe132,0x60b8,0xe132,0x60bc,0xe132,0x60c0,0xe132,0x60c4,0xe132,0x60ca,0xe132,0x60ce,0xe132,0x60d2,0x6132,0x60e0,
0xe134,0x60e2,0x6132,0x60e6,0xe134,0x60e8,0x6132,0x60ec,0xe134,0x60ee,0x6132,0x60f2,0xe134,0x60f4,0x6132,0x60f8,
0xe134,0x60fa,0xe132,0x613c,0xe132,0x61e8,0xe132,0x6158,0xe132,0x615c,0xe132,0x6160,0xe132,0x6164,0xe132,0x6168,
0xe132,0x616c,0xe132,0x6170,0xe132,0x6174,0xe132,0x6178,0xe132,0x617c,0xe132,0x6180,0xe132,0x6184,0xe132,0x618a,
0xe132,0x618e,0xe132,0x6192,0x6132,0x61a0,0xe134,0x61a2,0x6132,0x61a6,0xe134,0x61a8,0x6132,0x61ac,0xe134,0x61ae,
0x6132,0x61b2,0xe134,0x61b4,0x6132,0x61b8,0xe134,0x61ba,0xe132,0x61ee,0xe132,0x61f0,0xe132,0x61f2,0xe132,0x61f4,
0xe132,0x61fc,0xb489,0x2e82,0x2134,0xb489,0x2e82,0x2138,0xb489,0x2e82,0x2156,0xb489,0x49c2,0x225c,0xb489,0x49c2,
0x225e,0x3489,0xcf82,0x2696,0xb489,0xd5c2,0x2698,0x348b,0x2c02,0x2978,0x348b,0x2e82,0x2976,0xb48b,0x2f42,0x297c,
0xb48b,0x6bc2,0x2b74,0xb48b,0x6bc2,0x2b76,2,0xe602,0x41,0x302,0x600,0x3d4c,0x602,0x3d48,0x606,0x3d54,
0x8612,0x3d50,0xe602,0x41,0x308,0x8608,0x3bc,0xe602,0x41,0x30a,0x8602,0x3f4,0xca02,0x43,0x327,0x8602,
0x3c10,0xe602,0x45,0x302,0x600,0x3d80,0x602,0x3d7c,0x606,0x3d88,0x8612,0x3d84,0xe602,0x49,0x308,0x8602,
0x3c5c,0xe602,0x4f,0x302,0x600,0x3da4,0x602,0x3da0,0x606,0x3dac,0x8612,0x3da8,0xe602,0x4f,0x303,0x602,
0x3c98,0x608,0x458,0x8610,0x3c9c,0xe602,0x4f,0x308,0x8608,0x454,0xe602,0x55,0x308,0x600,0x3b6,0x602,
0x3ae,0x608,0x3aa,0x8618,0x3b2,0xe602,0x61,0x302,0x600,0x3d4e,0x602,0x3d4a,0x606,0x3d56,0x8612,0x3d52,
0xe602,0x61,0x308,0x8608,0x3be,0xe602,0x61,0x30a,0x8602,0x3f6,0xca02,0x63,0x327,0x8602,0x3c12,0xe602,
0x65,0x302,0x600,0x3d82,0x602,0x3d7e,0x606,0x3d8a,0x8612,0x3d86,0xe602,0x69,0x308,0x8602,0x3c5e,0xe602,
0x6f,0x302,0x600,0x3da6,0x602,0x3da2,0x606,0x3dae,0x8612,0x3daa,0xe602,0x6f,0x303,0x602,0x3c9a,0x608,
0x45a,0x8610,0x3c9e,0xe602,0x6f,0x308,0x8608,0x456,0xe602,0x75,0x308,0x600,0x3b8,0x602,0x3b0,0x608,
0x3ac,0x8618,0x3b4,0xe602,0x41,0x306,0x600,0x3d60,0x602,0x3d5c,0x606,0x3d68,0x8612,0x3d64,0xe602,0x61,
0x306,0x600,0x3d62,0x602,0x3d5e,0x606,0x3d6a,0x8612,0x3d66,0xe602,0x45,0x304,0x600,0x3c28,0x8602,0x3c2c,
0xe602,0x65,0x304,0x600,0x3c2a,0x8602,0x3c2e,0xe602,0x4f,0x304,0x600,0x3ca0,0x8602,0x3ca4,0xe602,0x6f,
0x304,0x600,0x3ca2,0x8602,0x3ca6,0xe602,0x53,0x301,0x860e,0x3cc8,0xe602,0x73,0x301,0x860e,0x3cca,0xe602,
0x53,0x30c,0x860e,0x3ccc,0xe602,0x73,0x30c,0x860e,0x3cce,0xe602,0x55,0x303,0x8602,0x3cf0,0xe602,0x75,
0x303,0x8602,0x3cf2,0xe602,0x55,0x304,0x8610,0x3cf4,0xe602,0x75,0x304,0x8610,0x3cf6,0xd802,0x4f,0x31b,
0x600,0x3db8,0x602,0x3db4,0x606,0x3dc0,0x612,0x3dbc,0x8646,0x3dc4,0xd802,0x6f,0x31b,0x600,0x3dba,0x602,
0x3db6,0x606,0x3dc2,0x612,0x3dbe,0x8646,0x3dc6,0xd802,0x55,0x31b,0x600,0x3dd4,0x602,0x3dd0,0x606,0x3ddc,
0x612,0x3dd8,0x8646,0x3de0,0xd802,0x75,0x31b,0x600,0x3dd6,0x602,0x3dd2,0x606,0x3dde,0x612,0x3dda,0x8646,
0x3de2,0xca02,0x4f,0x328,0x8608,0x3d8,0xca02,0x6f,0x328,0x8608,0x3da,0xe602,0x41,0x307,0x8608,0x3c0,
0xe602,0x61,0x307,0x8608,0x3c2,0xca02,0x45,0x327,0x860c,0x3c38,0xca02,0x65,0x327,0x860c,0x3c3a,0xe602,
0x4f,0x307,0x8608,0x460,0xe602,0x6f,0x307,0x8608,0x462,0xe602,0x3b1,0x301,0x868a,0x3f68,0xe602,0x3b7,
0x301,0x868a,0x3f88,0xe602,0x3b9,0x308,0x600,0x3fa4,0x602,0x720,0x8684,0x3fae,0xe602,0x3c5,0x308,0x600,
0x3fc4,0x602,0x760,0x8684,0x3fce,0xe602,0x3c9,0x301,0x868a,0x3fe8,2,0xcc6,0xcc2,0x99aa,0x1996,2,
0xdd9,0xdcf,0x9b94,0x1bba,0xdc02,0x4c,0x323,0x8608,0x3c70,0xdc02,0x6c,0x323,0x8608,0x3c72,0xdc02,0x52,
0x323,0x8608,0x3cb8,0xdc02,0x72,0x323,0x8608,0x3cba,0xdc02,0x53,0x323,0x860e,0x3cd0,0xdc02,0x73,0x323,
0x860e,0x3cd2,0xdc02,0x41,0x323,0x604,0x3d58,0x860c,0x3d6c,0xdc02,0x61,0x323,0x604,0x3d5a,0x860c,0x3d6e,
0xdc02,0x45,0x323,0x8604,0x3d8c,0xdc02,0x65,0x323,0x8604,0x3d8e,0xdc02,0x4f,0x323,0x8604,0x3db0,0xdc02,
0x6f,0x323,0x8604,0x3db2,0xe602,0x3b1,0x313,0x600,0x3e05,0x602,0x3e09,0x684,0x3e0d,0x868a,0x3f00,0xe602,
0x3b1,0x314,0x600,0x3e07,0x602,0x3e0b,0x684,0x3e0f,0x868a,0x3f02,0x1f00,0xe643,0x3b1,0x313,0x300,0x868a,
0x3f04,0x1f01,0xe643,0x3b1,0x314,0x300,0x868a,0x3f06,0x1f00,0xe643,0x3b1,0x313,0x301,0x868a,0x3f08,0x1f01,
0xe643,0x3b1,0x314,0x301,0x868a,0x3f0a,0x1f00,0xe643,0x3b1,0x313,0x342,0x868a,0x3f0c,0x1f01,0xe643,0x3b1,
0x314,0x342,0x868a,0x3f0e,0xe602,0x391,0x313,0x600,0x3e15,0x602,0x3e19,0x684,0x3e1d,0x868a,0x3f10,0xe602,
0x391,0x314,0x600,0x3e17,0x602,0x3e1b,0x684,0x3e1f,0x868a,0x3f12,0x1f08,0xe643,0x391,0x313,0x300,0x868a,
0x3f14,0x1f09,0xe643,0x391,0x314,0x300,0x868a,0x3f16,0x1f08,0xe643,0x391,0x313,0x301,0x868a,0x3f18,0x1f09,
0xe643,0x391,0x314,0x301,0x868a,0x3f1a,0x1f08,0xe643,0x391,0x313,0x342,0x868a,0x3f1c,0x1f09,0xe643,0x391,
0x314,0x342,0x868a,0x3f1e,0xe602,0x3b5,0x313,0x600,0x3e24,0x8602,0x3e28,0xe602,0x3b5,0x314,0x600,0x3e26,
0x8602,0x3e2a,0xe602,0x395,0x313,0x600,0x3e34,0x8602,0x3e38,0xe602,0x395,0x314,0x600,0x3e36,0x8602,0x3e3a,
0xe602,0x3b7,0x313,0x600,0x3e45,0x602,0x3e49,0x684,0x3e4d,0x868a,0x3f20,0xe602,0x3b7,0x314,0x600,0x3e47,
0x602,0x3e4b,0x684,0x3e4f,0x868a,0x3f22,0x1f20,0xe643,0x3b7,0x313,0x300,0x868a,0x3f24,0x1f21,0xe643,0x3b7,
0x314,0x300,0x868a,0x3f26,0x1f20,0xe643,0x3b7,0x313,0x301,0x868a,0x3f28,0x1f21,0xe643,0x3b7,0x314,0x301,
0x868a,0x3f2a,0x1f20,0xe643,0x3b7,0x313,0x342,0x868a,0x3f2c,0x1f21,0xe643,0x3b7,0x314,0x342,0x868a,0x3f2e,
0xe602,0x397,0x313,0x600,0x3e55,0x602,0x3e59,0x684,0x3e5d,0x868a,0x3f30,0xe602,0x397,0x314,0x600,0x3e57,
0x602,0x3e5b,0x684,0x3e5f,0x868a,0x3f32,0x1f28,0xe643,0x397,0x313,0x300,0x868a,0x3f34,0x1f29,0xe643,0x397,
0x314,0x300,0x868a,0x3f36,0x1f28,0xe643,0x397,0x313,0x301,0x868a,0x3f38,0x1f29,0xe643,0x397,0x314,0x301,
0x868a,0x3f3a,0x1f28,0xe643,0x397,0x313,0x342,0x868a,0x3f3c,0x1f29,0xe643,0x397,0x314,0x342,0x868a,0x3f3e,
0xe602,0x3b9,0x313,0x600,0x3e64,0x602,0x3e68,0x8684,0x3e6c,0xe602,0x3b9,0x314,0x600,0x3e66,0x602,0x3e6a,
0x8684,0x3e6e,0xe602,0x399,0x313,0x600,0x3e74,0x602,0x3e78,0x8684,0x3e7c,0xe602,0x399,0x314,0x600,0x3e76,
0x602,0x3e7a,0x8684,0x3e7e,0xe602,0x3bf,0x313,0x600,0x3e84,0x8602,0x3e88,0xe602,0x3bf,0x314,0x600,0x3e86,
0x8602,0x3e8a,0xe602,0x39f,0x313,0x600,0x3e94,0x8602,0x3e98,0xe602,0x39f,0x314,0x600,0x3e96,0x8602,0x3e9a,
0xe602,0x3c5,0x313,0x600,0x3ea4,0x602,0x3ea8,0x8684,0x3eac,0xe602,0x3c5,0x314,0x600,0x3ea6,0x602,0x3eaa,
0x8684,0x3eae,0xe602,0x3a5,0x314,0x600,0x3eb6,0x602,0x3eba,0x8684,0x3ebe,0xe602,0x3c9,0x313,0x600,0x3ec5,
0x602,0x3ec9,0x684,0x3ecd,0x868a,0x3f40,0xe602,0x3c9,0x314,0x600,0x3ec7,0x602,0x3ecb,0x684,0x3ecf,0x868a,
0x3f42,0x1f60,0xe643,0x3c9,0x313,0x300,0x868a,0x3f44,0x1f61,0xe643,0x3c9,0x314,0x300,0x868a,0x3f46,0x1f60,
0xe643,0x3c9,0x313,0x301,0x868a,0x3f48,0x1f61,0xe643,0x3c9,0x314,0x301,0x868a,0x3f4a,0x1f60,0xe643,0x3c9,
0x313,0x342,0x868a,0x3f4c,0x1f61,0xe643,0x3c9,0x314,0x342,0x868a,0x3f4e,0xe602,0x3a9,0x313,0x600,0x3ed5,
0x602,0x3ed9,0x684,0x3edd,0x868a,0x3f50,0xe602,0x3a9,0x314,0x600,0x3ed7,0x602,0x3edb,0x684,0x3edf,0x868a,
0x3f52,0x1f68,0xe643,0x3a9,0x313,0x300,0x868a,0x3f54,0x1f69,0xe643,0x3a9,0x314,0x300,0x868a,0x3f56,0x1f68,
0xe643,0x3a9,0x313,0x301,0x868a,0x3f58,0x1f69,0xe643,0x3a9,0x314,0x301,0x868a,0x3f5a,0x1f68,0xe643,0x3a9,
0x313,0x342,0x868a,0x3f5c,0x1f69,0xe643,0x3a9,0x314,0x342,0x868a,0x3f5e,0xe602,0x3b1,0x300,0x868a,0x3f64,
0xe602,0x3b7,0x300,0x868a,0x3f84,0xe602,0x3c9,0x300,0x868a,0x3fe4,0xe602,0x3b1,0x342,0x868a,0x3f6e,0xe602,
0x3b7,0x342,0x868a,0x3f8e,0xe602,0x3c9,0x342,0x868a,0x3fee,3,0xe602,0x41,0x300,0xe602,0x41,0x301,
0xe602,0x41,0x303,0xe602,0x45,0x300,0xe602,0x45,0x301,0xe602,0x45,0x308,0xe602,0x49,0x300,0xe602,
0x49,0x301,0xe602,0x49,0x302,0xe602,0x4e,0x303,0xe602,0x4f,0x300,0xe602,0x4f,0x301,0xe602,0x55,
0x300,0xe602,0x55,0x301,0xe602,0x55,0x302,0xe602,0x59,0x301,0xe602,0x61,0x300,0xe602,0x61,0x301,
0xe602,0x61,0x303,0xe602,0x65,0x300,0xe602,0x65,0x301,0xe602,0x65,0x308,0xe602,0x69,0x300,0xe602,
0x69,0x301,0xe602,0x69,0x302,0xe602,0x6e,0x303,0xe602,0x6f,0x300,0xe602,0x6f,0x301,0xe602,0x75,
0x300,0xe602,0x75,0x301,0xe602,0x75,0x302,0xe602,0x79,0x301,0xe602,0x79,0x308,0xe602,0x41,0x304,
0xe602,0x61,0x304,0xca02,0x41,0x328,0xca02,0x61,0x328,0xe602,0x43,0x301,0xe602,0x63,0x301,0xe602,
0x43,0x302,0xe602,0x63,0x302,0xe602,0x43,0x307,0xe602,0x63,0x307,0xe602,0x43,0x30c,0xe602,0x63,
0x30c,0xe602,0x44,0x30c,0xe602,0x64,0x30c,0xe602,0x45,0x306,0xe602,0x65,0x306,0xe602,0x45,0x307,
0xe602,0x65,0x307,0xca02,0x45,0x328,0xca02,0x65,0x328,0xe602,0x45,0x30c,0xe602,0x65,0x30c,0xe602,
0x47,0x302,0xe602,0x67,0x302,0xe602,0x47,0x306,0xe602,0x67,0x306,0xe602,0x47,0x307,0xe602,0x67,
0x307,0xca02,0x47,0x327,0xca02,0x67,0x327,0xe602,0x48,0x302,0xe602,0x68,0x302,0xe602,0x49,0x303,
0xe602,0x69,0x303,0xe602,0x49,0x304,0xe602,0x69,0x304,0xe602,0x49,0x306,0xe602,0x69,0x306,0xca02,
0x49,0x328,0xca02,0x69,0x328,0xe602,0x49,0x307,0xe602,0x4a,0x302,0xe602,0x6a,0x302,0xca02,0x4b,
0x327,0xca02,0x6b,0x327,0xe602,0x4c,0x301,0xe602,0x6c,0x301,0xca02,0x4c,0x327,0xca02,0x6c,0x327,
0xe602,0x4c,0x30c,0xe602,0x6c,0x30c,0xe602,0x4e,0x301,0xe602,0x6e,0x301,0xca02,0x4e,0x327,0xca02,
0x6e,0x327,0xe602,0x4e,0x30c,0xe602,0x6e,0x30c,0xe602,0x4f,0x306,0xe602,0x6f,0x306,0xe602,0x4f,
0x30b,0xe602,0x6f,0x30b,0xe602,0x52,0x301,0xe602,0x72,0x301,0xca02,0x52,0x327,0xca02,0x72,0x327,
0xe602,0x52,0x30c,0xe602,0x72,0x30c,0xe602,0x53,0x302,0xe602,0x73,0x302,0xca02,0x53,0x327,0xca02,
0x73,0x327,0xca02,0x54,0x327,0xca02,0x74,0x327,0xe602,0x54,0x30c,0xe602,0x74,0x30c,0xe602,0x55,
0x306,0xe602,0x75,0x306,0xe602,0x55,0x30a,0xe602,0x75,0x30a,0xe602,0x55,0x30b,0xe602,0x75,0x30b,
0xca02,0x55,0x328,0xca02,0x75,0x328,0xe602,0x57,0x302,0xe602,0x77,0x302,0xe602,0x59,0x302,0xe602,
0x79,0x302,0xe602,0x59,0x308,0xe602,0x5a,0x301,0xe602,0x7a,0x301,0xe602,0x5a,0x307,0xe602,0x7a,
0x307,0xe602,0x5a,0x30c,0xe602,0x7a,0x30c,0xe602,0x41,0x30c,0xe602,0x61,0x30c,0xe602,0x49,0x30c,
0xe602,0x69,0x30c,0xe602,0x4f,0x30c,0xe602,0x6f,0x30c,0xe602,0x55,0x30c,0xe602,0x75,0x30c,0xdc,
0xe643,0x55,0x308,0x304,0xfc,0xe643,0x75,0x308,0x304,0xdc,0xe643,0x55,0x308,0x301,0xfc,0xe643,
0x75,0x308,0x301,0xdc,0xe643,0x55,0x308,0x30c,0xfc,0xe643,0x75,0x308,0x30c,0xdc,0xe643,0x55,
0x308,0x300,0xfc,0xe643,0x75,0x308,0x300,0xc4,0xe643,0x41,0x308,0x304,0xe4,0xe643,0x61,0x308,
0x304,0x226,0xe643,0x41,0x307,0x304,0x227,0xe643,0x61,0x307,0x304,0xe602,0xc6,0x304,0xe602,0xe6,
0x304,0xe602,0x47,0x30c,0xe602,0x67,0x30c,0xe602,0x4b,0x30c,0xe602,0x6b,0x30c,0x1ea,0xe643,0x4f,
0x328,0x304,0x1eb,0xe643,0x6f,0x328,0x304,0xe602,0x1b7,0x30c,0xe602,0x292,0x30c,0xe602,0x6a,0x30c,
0xe602,0x47,0x301,0xe602,0x67,0x301,0xe602,0x4e,0x300,0xe602,0x6e,0x300,0xc5,0xe643,0x41,0x30a,
0x301,0xe5,0xe643,0x61,0x30a,0x301,0xe602,0xc6,0x301,0xe602,0xe6,0x301,0xe602,0xd8,0x301,0xe602,
0xf8,0x301,0xe602,0x41,0x30f,0xe602,0x61,0x30f,0xe602,0x41,0x311,0xe602,0x61,0x311,0xe602,0x45,
0x30f,0xe602,0x65,0x30f,0xe602,0x45,0x311,0xe602,0x65,0x311,0xe602,0x49,0x30f,0xe602,0x69,0x30f,
0xe602,0x49,0x311,0xe602,0x69,0x311,0xe602,0x4f,0x30f,0xe602,0x6f,0x30f,0xe602,0x4f,0x311,0xe602,
0x6f,0x311,0xe602,0x52,0x30f,0xe602,0x72,0x30f,0xe602,0x52,0x311,0xe602,0x72,0x311,0xe602,0x55,
0x30f,0xe602,0x75,0x30f,0xe602,0x55,0x311,0xe602,0x75,0x311,0xdc02,0x53,0x326,0xdc02,0x73,0x326,
0xdc02,0x54,0x326,0xdc02,0x74,0x326,0xe602,0x48,0x30c,0xe602,0x68,0x30c,0xd6,0xe643,0x4f,0x308,
0x304,0xf6,0xe643,0x6f,0x308,0x304,0xd5,0xe643,0x4f,0x303,0x304,0xf5,0xe643,0x6f,0x303,0x304,
0x22e,0xe643,0x4f,0x307,0x304,0x22f,0xe643,0x6f,0x307,0x304,0xe602,0x59,0x304,0xe602,0x79,0x304,
0xe602,0x391,0x301,0xe602,0x395,0x301,0xe602,0x397,0x301,0xe602,0x399,0x301,0xe602,0x39f,0x301,0xe602,
0x3a5,0x301,0xe602,0x3a9,0x301,0x3ca,0xe643,0x3b9,0x308,0x301,0xe602,0x399,0x308,0xe602,0x3a5,0x308,
0xe602,0x3b5,0x301,0xe602,0x3b9,0x301,0x3cb,0xe643,0x3c5,0x308,0x301,0xe602,0x3bf,0x301,0xe602,0x3c5,
0x301,0xe602,0x415,0x300,0xe602,0x415,0x308,0xe602,0x413,0x301,0xe602,0x406,0x308,0xe602,0x41a,0x301,
0xe602,0x418,0x300,0xe602,0x423,0x306,0xe602,0x418,0x306,0xe602,0x438,0x306,0xe602,0x435,0x300,0xe602,
0x435,0x308,0xe602,0x433,0x301,0xe602,0x456,0x308,0xe602,0x43a,0x301,0xe602,0x438,0x300,0xe602,0x443,
0x306,0xe602,0x474,0x30f,0xe602,0x475,0x30f,0xe602,0x416,0x306,0xe602,0x436,0x306,0xe602,0x410,0x306,
0xe602,0x430,0x306,0xe602,0x410,0x308,0xe602,0x430,0x308,0xe602,0x415,0x306,0xe602,0x435,0x306,0xe602,
0x4d8,0x308,0xe602,0x4d9,0x308,0xe602,0x416,0x308,0xe602,0x436,0x308,0xe602,0x417,0x308,0xe602,0x437,
0x308,0xe602,0x418,0x304,0xe602,0x438,0x304,0xe602,0x418,0x308,0xe602,0x438,0x308,0xe602,0x41e,0x308,
0xe602,0x43e,0x308,0xe602,0x4e8,0x308,0xe602,0x4e9,0x308,0xe602,0x42d,0x308,0xe602,0x44d,0x308,0xe602,
0x423,0x304,0xe602,0x443,0x304,0xe602,0x423,0x308,0xe602,0x443,0x308,0xe602,0x423,0x30b,0xe602,0x443,
0x30b,0xe602,0x427,0x308,0xe602,0x447,0x308,0xe602,0x42b,0x308,0xe602,0x44b,0x308,0xe602,0x627,0x653,
0xe602,0x627,0x654,0xe602,0x648,0x654,0xdc02,0x627,0x655,0xe602,0x64a,0x654,0xe602,0x6d5,0x654,0xe602,
0x6c1,0x654,0xe602,0x6d2,0x654,0x702,0x928,0x93c,0x702,0x930,0x93c,0x702,0x933,0x93c,2,0x9c7,
0x9be,2,0x9c7,0x9d7,2,0xb47,0xb56,2,0xb47,0xb3e,2,0xb47,0xb57,2,0xb92,0xbd7,
2,0xbc6,0xbbe,2,0xbc7,0xbbe,2,0xbc6,0xbd7,0x5b02,0xc46,0xc56,2,0xcbf,0xcd5,2,
0xcc6,0xcd5,2,0xcc6,0xcd6,0xcca,0x43,0xcc6,0xcc2,0xcd5,2,0xd46,0xd3e,2,0xd47,0xd3e,
2,0xd46,0xd57,0x902,0xdd9,0xdca,0xddc,0x943,0xdd9,0xdcf,0xdca,2,0xdd9,0xddf,2,0x1025,
0x102e,2,0x1b05,0x1b35,2,0x1b07,0x1b35,2,0x1b09,0x1b35,2,0x1b0b,0x1b35,2,0x1b0d,0x1b35,
2,0x1b11,0x1b35,2,0x1b3a,0x1b35,2,0x1b3c,0x1b35,2,0x1b3e,0x1b35,2,0x1b3f,0x1b35,2,
0x1b42,0x1b35,0xdc02,0x41,0x325,0xdc02,0x61,0x325,0xe602,0x42,0x307,0xe602,0x62,0x307,0xdc02,0x42,
0x323,0xdc02,0x62,0x323,0xdc02,0x42,0x331,0xdc02,0x62,0x331,0xc7,0xe643,0x43,0x327,0x301,0xe7,
0xe643,0x63,0x327,0x301,0xe602,0x44,0x307,0xe602,0x64,0x307,0xdc02,0x44,0x323,0xdc02,0x64,0x323,
0xdc02,0x44,0x331,0xdc02,0x64,0x331,0xca02,0x44,0x327,0xca02,0x64,0x327,0xdc02,0x44,0x32d,0xdc02,
0x64,0x32d,0x112,0xe643,0x45,0x304,0x300,0x113,0xe643,0x65,0x304,0x300,0x112,0xe643,0x45,0x304,
0x301,0x113,0xe643,0x65,0x304,0x301,0xdc02,0x45,0x32d,0xdc02,0x65,0x32d,0xdc02,0x45,0x330,0xdc02,
0x65,0x330,0x228,0xe643,0x45,0x327,0x306,0x229,0xe643,0x65,0x327,0x306,0xe602,0x46,0x307,0xe602,
0x66,0x307,0xe602,0x47,0x304,0xe602,0x67,0x304,0xe602,0x48,0x307,0xe602,0x68,0x307,0xdc02,0x48,
0x323,0xdc02,0x68,0x323,0xe602,0x48,0x308,0xe602,0x68,0x308,0xca02,0x48,0x327,0xca02,0x68,0x327,
0xdc02,0x48,0x32e,0xdc02,0x68,0x32e,0xdc02,0x49,0x330,0xdc02,0x69,0x330,0xcf,0xe643,0x49,0x308,
0x301,0xef,0xe643,0x69,0x308,0x301,0xe602,0x4b,0x301,0xe602,0x6b,0x301,0xdc02,0x4b,0x323,0xdc02,
0x6b,0x323,0xdc02,0x4b,0x331,0xdc02,0x6b,0x331,0x1e36,0xe643,0x4c,0x323,0x304,0x1e37,0xe643,0x6c,
0x323,0x304,0xdc02,0x4c,0x331,0xdc02,0x6c,0x331,0xdc02,0x4c,0x32d,0xdc02,0x6c,0x32d,0xe602,0x4d,
0x301,0xe602,0x6d,0x301,0xe602,0x4d,0x307,0xe602,0x6d,0x307,0xdc02,0x4d,0x323,0xdc02,0x6d,0x323,
0xe602,0x4e,0x307,0xe602,0x6e,0x307,0xdc02,0x4e,0x323,0xdc02,0x6e,0x323,0xdc02,0x4e,0x331,0xdc02,
0x6e,0x331,0xdc02,0x4e,0x32d,0xdc02,0x6e,0x32d,0xd5,0xe643,0x4f,0x303,0x301,0xf5,0xe643,0x6f,
0x303,0x301,0xd5,0xe643,0x4f,0x303,0x308,0xf5,0xe643,0x6f,0x303,0x308,0x14c,0xe643,0x4f,0x304,
0x300,0x14d,0xe643,0x6f,0x304,0x300,0x14c,0xe643,0x4f,0x304,0x301,0x14d,0xe643,0x6f,0x304,0x301,
0xe602,0x50,0x301,0xe602,0x70,0x301,0xe602,0x50,0x307,0xe602,0x70,0x307,0xe602,0x52,0x307,0xe602,
0x72,0x307,0x1e5a,0xe643,0x52,0x323,0x304,0x1e5b,0xe643,0x72,0x323,0x304,0xdc02,0x52,0x331,0xdc02,
0x72,0x331,0xe602,0x53,0x307,0xe602,0x73,0x307,0x15a,0xe643,0x53,0x301,0x307,0x15b,0xe643,0x73,
0x301,0x307,0x160,0xe643,0x53,0x30c,0x307,0x161,0xe643,0x73,0x30c,0x307,0x1e62,0xe643,0x53,0x323,
0x307,0x1e63,0xe643,0x73,0x323,0x307,0xe602,0x54,0x307,0xe602,0x74,0x307,0xdc02,0x54,0x323,0xdc02,
0x74,0x323,0xdc02,0x54,0x331,0xdc02,0x74,0x331,0xdc02,0x54,0x32d,0xdc02,0x74,0x32d,0xdc02,0x55,
0x324,0xdc02,0x75,0x324,0xdc02,0x55,0x330,0xdc02,0x75,0x330,0xdc02,0x55,0x32d,0xdc02,0x75,0x32d,
0x168,0xe643,0x55,0x303,0x301,0x169,0xe643,0x75,0x303,0x301,0x16a,0xe643,0x55,0x304,0x308,0x16b,
0xe643,0x75,0x304,0x308,0xe602,0x56,0x303,0xe602,0x76,0x303,0xdc02,0x56,0x323,0xdc02,0x76,0x323,
0xe602,0x57,0x300,0xe602,0x77,0x300,0xe602,0x57,0x301,0xe602,0x77,0x301,0xe602,0x57,0x308,0xe602,
0x77,0x308,0xe602,0x57,0x307,0xe602,0x77,0x307,0xdc02,0x57,0x323,0xdc02,0x77,0x323,0xe602,0x58,
0x307,0xe602,0x78,0x307,0xe602,0x58,0x308,0xe602,0x78,0x308,0xe602,0x59,0x307,0xe602,0x79,0x307,
0xe602,0x5a,0x302,0xe602,0x7a,0x302,0xdc02,0x5a,0x323,0xdc02,0x7a,0x323,0xdc02,0x5a,0x331,0xdc02,
0x7a,0x331,0xdc02,0x68,0x331,0xe602,0x74,0x308,0xe602,0x77,0x30a,0xe602,0x79,0x30a,0xe602,0x41,
0x309,0xe602,0x61,0x309,0xc2,0xe643,0x41,0x302,0x301,0xe2,0xe643,0x61,0x302,0x301,0xc2,0xe643,
0x41,0x302,0x300,0xe2,0xe643,0x61,0x302,0x300,0xc2,0xe643,0x41,0x302,0x309,0xe2,0xe643,0x61,
0x302,0x309,0xc2,0xe643,0x41,0x302,0x303,0xe2,0xe643,0x61,0x302,0x303,0x1ea0,0xe643,0x41,0x323,
0x302,0x1ea1,0xe643,0x61,0x323,0x302,0x102,0xe643,0x41,0x306,0x301,0x103,0xe643,0x61,0x306,0x301,
0x102,0xe643,0x41,0x306,0x300,0x103,0xe643,0x61,0x306,0x300,0x102,0xe643,0x41,0x306,0x309,0x103,
0xe643,0x61,0x306,0x309,0x102,0xe643,0x41,0x306,0x303,0x103,0xe643,0x61,0x306,0x303,0x1ea0,0xe643,
0x41,0x323,0x306,0x1ea1,0xe643,0x61,0x323,0x306,0xe602,0x45,0x309,0xe602,0x65,0x309,0xe602,0x45,
0x303,0xe602,0x65,0x303,0xca,0xe643,0x45,0x302,0x301,0xea,0xe643,0x65,0x302,0x301,0xca,0xe643,
0x45,0x302,0x300,0xea,0xe643,0x65,0x302,0x300,0xca,0xe643,0x45,0x302,0x309,0xea,0xe643,0x65,
0x302,0x309,0xca,0xe643,0x45,0x302,0x303,0xea,0xe643,0x65,0x302,0x303,0x1eb8,0xe643,0x45,0x323,
0x302,0x1eb9,0xe643,0x65,0x323,0x302,0xe602,0x49,0x309,0xe602,0x69,0x309,0xdc02,0x49,0x323,0xdc02,
0x69,0x323,0xe602,0x4f,0x309,0xe602,0x6f,0x309,0xd4,0xe643,0x4f,0x302,0x301,0xf4,0xe643,0x6f,
0x302,0x301,0xd4,0xe643,0x4f,0x302,0x300,0xf4,0xe643,0x6f,0x302,0x300,0xd4,0xe643,0x4f,0x302,
0x309,0xf4,0xe643,0x6f,0x302,0x309,0xd4,0xe643,0x4f,0x302,0x303,0xf4,0xe643,0x6f,0x302,0x303,
0x1ecc,0xe643,0x4f,0x323,0x302,0x1ecd,0xe643,0x6f,0x323,0x302,0x1a0,0xe643,0x4f,0x31b,0x301,0x1a1,
0xe643,0x6f,0x31b,0x301,0x1a0,0xe643,0x4f,0x31b,0x300,0x1a1,0xe643,0x6f,0x31b,0x300,0x1a0,0xe643,
0x4f,0x31b,0x309,0x1a1,0xe643,0x6f,0x31b,0x309,0x1a0,0xe643,0x4f,0x31b,0x303,0x1a1,0xe643,0x6f,
0x31b,0x303,0x1a0,0xdc43,0x4f,0x31b,0x323,0x1a1,0xdc43,0x6f,0x31b,0x323,0xdc02,0x55,0x323,0xdc02,
0x75,0x323,0xe602,0x55,0x309,0xe602,0x75,0x309,0x1af,0xe643,0x55,0x31b,0x301,0x1b0,0xe643,0x75,
0x31b,0x301,0x1af,0xe643,0x55,0x31b,0x300,0x1b0,0xe643,0x75,0x31b,0x300,0x1af,0xe643,0x55,0x31b,
0x309,0x1b0,0xe643,0x75,0x31b,0x309,0x1af,0xe643,0x55,0x31b,0x303,0x1b0,0xe643,0x75,0x31b,0x303,
0x1af,0xdc43,0x55,0x31b,0x323,0x1b0,0xdc43,0x75,0x31b,0x323,0xe602,0x59,0x300,0xe602,0x79,0x300,
0xdc02,0x59,0x323,0xdc02,0x79,0x323,0xe602,0x59,0x309,0xe602,0x79,0x309,0xe602,0x59,0x303,0xe602,
0x79,0x303,0x1f10,0xe643,0x3b5,0x313,0x300,0x1f11,0xe643,0x3b5,0x314,0x300,0x1f10,0xe643,0x3b5,0x313,
0x301,0x1f11,0xe643,0x3b5,0x314,0x301,0x1f18,0xe643,0x395,0x313,0x300,0x1f19,0xe643,0x395,0x314,0x300,
0x1f18,0xe643,0x395,0x313,0x301,0x1f19,0xe643,0x395,0x314,0x301,0x1f30,0xe643,0x3b9,0x313,0x300,0x1f31,
0xe643,0x3b9,0x314,0x300,0x1f30,0xe643,0x3b9,0x313,0x301,0x1f31,0xe643,0x3b9,0x314,0x301,0x1f30,0xe643,
0x3b9,0x313,0x342,0x1f31,0xe643,0x3b9,0x314,0x342,0x1f38,0xe643,0x399,0x313,0x300,0x1f39,0xe643,0x399,
0x314,0x300,0x1f38,0xe643,0x399,0x313,0x301,0x1f39,0xe643,0x399,0x314,0x301,0x1f38,0xe643,0x399,0x313,
0x342,0x1f39,0xe643,0x399,0x314,0x342,0x1f40,0xe643,0x3bf,0x313,0x300,0x1f41,0xe643,0x3bf,0x314,0x300,
0x1f40,0xe643,0x3bf,0x313,0x301,0x1f41,0xe643,0x3bf,0x314,0x301,0x1f48,0xe643,0x39f,0x313,0x300,0x1f49,
0xe643,0x39f,0x314,0x300,0x1f48,0xe643,0x39f,0x313,0x301,0x1f49,0xe643,0x39f,0x314,0x301,0x1f50,0xe643,
0x3c5,0x313,0x300,0x1f51,0xe643,0x3c5,0x314,0x300,0x1f50,0xe643,0x3c5,0x313,0x301,0x1f51,0xe643,0x3c5,
0x314,0x301,0x1f50,0xe643,0x3c5,0x313,0x342,0x1f51,0xe643,0x3c5,0x314,0x342,0x1f59,0xe643,0x3a5,0x314,
0x300,0x1f59,0xe643,0x3a5,0x314,0x301,0x1f59,0xe643,0x3a5,0x314,0x342,0xe602,0x3b5,0x300,0xe602,0x3b9,
0x300,0xe602,0x3bf,0x300,0xe602,0x3c5,0x300,0x1f00,0xf043,0x3b1,0x313,0x345,0x1f01,0xf043,0x3b1,0x314,
0x345,0x1f02,0x345,2,0xf044,0x3b1,0x313,0x300,0x345,0x1f03,0x345,2,0xf044,0x3b1,0x314,0x300,
0x345,0x1f04,0x345,2,0xf044,0x3b1,0x313,0x301,0x345,0x1f05,0x345,2,0xf044,0x3b1,0x314,0x301,
0x345,0x1f06,0x345,2,0xf044,0x3b1,0x313,0x342,0x345,0x1f07,0x345,2,0xf044,0x3b1,0x314,0x342,
0x345,0x1f08,0xf043,0x391,0x313,0x345,0x1f09,0xf043,0x391,0x314,0x345,0x1f0a,0x345,2,0xf044,0x391,
0x313,0x300,0x345,0x1f0b,0x345,2,0xf044,0x391,0x314,0x300,0x345,0x1f0c,0x345,2,0xf044,0x391,
0x313,0x301,0x345,0x1f0d,0x345,2,0xf044,0x391,0x314,0x301,0x345,0x1f0e,0x345,2,0xf044,0x391,
0x313,0x342,0x345,0x1f0f,0x345,2,0xf044,0x391,0x314,0x342,0x345,0x1f20,0xf043,0x3b7,0x313,0x345,
0x1f21,0xf043,0x3b7,0x314,0x345,0x1f22,0x345,2,0xf044,0x3b7,0x313,0x300,0x345,0x1f23,0x345,2,
0xf044,0x3b7,0x314,0x300,0x345,0x1f24,0x345,2,0xf044,0x3b7,0x313,0x301,0x345,0x1f25,0x345,2,
0xf044,0x3b7,0x314,0x301,0x345,0x1f26,0x345,2,0xf044,0x3b7,0x313,0x342,0x345,0x1f27,0x345,2,
0xf044,0x3b7,0x314,0x342,0x345,0x1f28,0xf043,0x397,0x313,0x345,0x1f29,0xf043,0x397,0x314,0x345,0x1f2a,
0x345,2,0xf044,0x397,0x313,0x300,0x345,0x1f2b,0x345,2,0xf044,0x397,0x314,0x300,0x345,0x1f2c,
0x345,2,0xf044,0x397,0x313,0x301,0x345,0x1f2d,0x345,2,0xf044,0x397,0x314,0x301,0x345,0x1f2e,
0x345,2,0xf044,0x397,0x313,0x342,0x345,0x1f2f,0x345,2,0xf044,0x397,0x314,0x342,0x345,0x1f60,
0xf043,0x3c9,0x313,0x345,0x1f61,0xf043,0x3c9,0x314,0x345,0x1f62,0x345,2,0xf044,0x3c9,0x313,0x300,
0x345,0x1f63,0x345,2,0xf044,0x3c9,0x314,0x300,0x345,0x1f64,0x345,2,0xf044,0x3c9,0x313,0x301,
0x345,0x1f65,0x345,2,0xf044,0x3c9,0x314,0x301,0x345,0x1f66,0x345,2,0xf044,0x3c9,0x313,0x342,
0x345,0x1f67,0x345,2,0xf044,0x3c9,0x314,0x342,0x345,0x1f68,0xf043,0x3a9,0x313,0x345,0x1f69,0xf043,
0x3a9,0x314,0x345,0x1f6a,0x345,2,0xf044,0x3a9,0x313,0x300,0x345,0x1f6b,0x345,2,0xf044,0x3a9,
0x314,0x300,0x345,0x1f6c,0x345,2,0xf044,0x3a9,0x313,0x301,0x345,0x1f6d,0x345,2,0xf044,0x3a9,
0x314,0x301,0x345,0x1f6e,0x345,2,0xf044,0x3a9,0x313,0x342,0x345,0x1f6f,0x345,2,0xf044,0x3a9,
0x314,0x342,0x345,0xe602,0x3b1,0x306,0xe602,0x3b1,0x304,0x1f70,0xf043,0x3b1,0x300,0x345,0xf002,0x3b1,
0x345,0x3ac,0xf043,0x3b1,0x301,0x345,0x1fb6,0xf043,0x3b1,0x342,0x345,0xe602,0x391,0x306,0xe602,0x391,
0x304,0xe602,0x391,0x300,0xf002,0x391,0x345,0x1f74,0xf043,0x3b7,0x300,0x345,0xf002,0x3b7,0x345,0x3ae,
0xf043,0x3b7,0x301,0x345,0x1fc6,0xf043,0x3b7,0x342,0x345,0xe602,0x395,0x300,0xe602,0x397,0x300,0xf002,
0x397,0x345,0xe602,0x3b9,0x306,0xe602,0x3b9,0x304,0x3ca,0xe643,0x3b9,0x308,0x300,0xe602,0x3b9,0x342,
0x3ca,0xe643,0x3b9,0x308,0x342,0xe602,0x399,0x306,0xe602,0x399,0x304,0xe602,0x399,0x300,0xe602,0x3c5,
0x306,0xe602,0x3c5,0x304,0x3cb,0xe643,0x3c5,0x308,0x300,0xe602,0x3c1,0x313,0xe602,0x3c1,0x314,0xe602,
0x3c5,0x342,0x3cb,0xe643,0x3c5,0x308,0x342,0xe602,0x3a5,0x306,0xe602,0x3a5,0x304,0xe602,0x3a5,0x300,
0xe602,0x3a1,0x314,0x1f7c,0xf043,0x3c9,0x300,0x345,0xf002,0x3c9,0x345,0x3ce,0xf043,0x3c9,0x301,0x345,
0x1ff6,0xf043,0x3c9,0x342,0x345,0xe602,0x39f,0x300,0xe602,0x3a9,0x300,0xf002,0x3a9,0x345,0x102,0x2190,
0x338,0x102,0x2192,0x338,0x102,0x2194,0x338,0x102,0x21d0,0x338,0x102,0x21d4,0x338,0x102,0x21d2,0x338,
0x102,0x2203,0x338,0x102,0x2208,0x338,0x102,0x220b,0x338,0x102,0x2223,0x338,0x102,0x2225,0x338,0x102,
0x223c,0x338,0x102,0x2243,0x338,0x102,0x2245,0x338,0x102,0x2248,0x338,0x102,0x3d,0x338,0x102,0x2261,
0x338,0x102,0x224d,0x338,0x102,0x3c,0x338,0x102,0x3e,0x338,0x102,0x2264,0x338,0x102,0x2265,0x338,
0x102,0x2272,0x338,0x102,0x2273,0x338,0x102,0x2276,0x338,0x102,0x2277,0x338,0x102,0x227a,0x338,0x102,
0x227b,0x338,0x102,0x2282,0x338,0x102,0x2283,0x338,0x102,0x2286,0x338,0x102,0x2287,0x338,0x102,0x22a2,
0x338,0x102,0x22a8,0x338,0x102,0x22a9,0x338,0x102,0x22ab,0x338,0x102,0x227c,0x338,0x102,0x227d,0x338,
0x102,0x2291,0x338,0x102,0x2292,0x338,0x102,0x22b2,0x338,0x102,0x22b3,0x338,0x102,0x22b4,0x338,0x102,
0x22b5,0x338,0x802,0x304b,0x3099,0x802,0x304d,0x3099,0x802,0x304f,0x3099,0x802,0x3051,0x3099,0x802,0x3053,
0x3099,0x802,0x3055,0x3099,0x802,0x3057,0x3099,0x802,0x3059,0x3099,0x802,0x305b,0x3099,0x802,0x305d,0x3099,
0x802,0x305f,0x3099,0x802,0x3061,0x3099,0x802,0x3064,0x3099,0x802,0x3066,0x3099,0x802,0x3068,0x3099,0x802,
0x306f,0x3099,0x802,0x306f,0x309a,0x802,0x3072,0x3099,0x802,0x3072,0x309a,0x802,0x3075,0x3099,0x802,0x3075,
0x309a,0x802,0x3078,0x3099,0x802,0x3078,0x309a,0x802,0x307b,0x3099,0x802,0x307b,0x309a,0x802,0x3046,0x3099,
0x802,0x309d,0x3099,0x802,0x30ab,0x3099,0x802,0x30ad,0x3099,0x802,0x30af,0x3099,0x802,0x30b1,0x3099,0x802,
0x30b3,0x3099,0x802,0x30b5,0x3099,0x802,0x30b7,0x3099,0x802,0x30b9,0x3099,0x802,0x30bb,0x3099,0x802,0x30bd,
0x3099,0x802,0x30bf,0x3099,0x802,0x30c1,0x3099,0x802,0x30c4,0x3099,0x802,0x30c6,0x3099,0x802,0x30c8,0x3099,
0x802,0x30cf,0x3099,0x802,0x30cf,0x309a,0x802,0x30d2,0x3099,0x802,0x30d2,0x309a,0x802,0x30d5,0x3099,0x802,
0x30d5,0x309a,0x802,0x30d8,0x3099,0x802,0x30d8,0x309a,0x802,0x30db,0x3099,0x802,0x30db,0x309a,0x802,0x30a6,
0x3099,0x802,0x30ef,0x3099,0x802,0x30f0,0x3099,0x802,0x30f1,0x3099,0x802,0x30f2,0x3099,0x802,0x30fd,0x3099,
0x704,0xd804,0xdc99,0xd804,0xdcba,0x704,0xd804,0xdc9b,0xd804,0xdcba,0x704,0xd804,0xdca5,0xd804,0xdcba,4,
0xd804,0xdd31,0xd804,0xdd27,4,0xd804,0xdd32,0xd804,0xdd27,4,0xd804,0xdf47,0xd804,0xdf3e,4,0xd804,
0xdf47,0xd804,0xdf57,4,0xd805,0xdcb9,0xd805,0xdcba,4,0xd805,0xdcb9,0xd805,0xdcb0,4,0xd805,0xdcb9,
0xd805,0xdcbd,4,0xd805,0xddb8,0xd805,0xddaf,4,0xd805,0xddb9,0xd805,0xddaf,1,0x20,0xe602,0x20,
0x308,1,0x61,0xe602,0x20,0x304,1,0x32,1,0x33,0xe602,0x20,0x301,1,0x3bc,0xca02,
0x20,0x327,1,0x31,1,0x6f,3,0x31,0x2044,0x34,3,0x31,0x2044,0x32,3,0x33,
0x2044,0x34,2,0x49,0x4a,2,0x69,0x6a,2,0x4c,0xb7,2,0x6c,0xb7,2,0x2bc,
0x6e,1,0x73,2,0x4c,0x4a,2,0x4c,0x6a,2,0x6c,0x6a,2,0x4e,0x4a,2,
0x4e,0x6a,2,0x6e,0x6a,2,0x44,0x5a,2,0x44,0x7a,2,0x64,0x7a,1,0x68,
1,0x266,1,0x6a,1,0x72,1,0x77,1,0x79,0xe602,0x20,0x306,0xe602,0x20,0x307,
0xe602,0x20,0x30a,0xca02,0x20,0x328,0xe602,0x20,0x303,0xe602,0x20,0x30b,1,0x263,1,0x6c,
1,0x78,1,0x295,1,0x2b9,0xf002,0x20,0x345,1,0x3b,0xa8,0xe643,0x20,0x308,0x301,
1,0xb7,1,0x398,1,0x3a3,2,0x565,0x582,2,0x627,0x674,2,0x648,0x674,2,
0x6c7,0x674,2,0x64a,0x674,0x702,0x915,0x93c,0x702,0x916,0x93c,0x702,0x917,0x93c,0x702,0x91c,
0x93c,0x702,0x921,0x93c,0x702,0x922,0x93c,0x702,0x92b,0x93c,0x702,0x92f,0x93c,0x702,0x9a1,0x9bc,
0x702,0x9a2,0x9bc,0x702,0x9af,0x9bc,0x702,0xa32,0xa3c,0x702,0xa38,0xa3c,0x702,0xa16,0xa3c,0x702,
0xa17,0xa3c,0x702,0xa1c,0xa3c,0x702,0xa2b,0xa3c,0x702,0xb21,0xb3c,0x702,0xb22,0xb3c,2,0xe4d,
0xe32,2,0xecd,0xeb2,2,0xeab,0xe99,2,0xeab,0xea1,2,0xf42,0xfb7,2,0xf4c,0xfb7,
2,0xf51,0xfb7,2,0xf56,0xfb7,2,0xf5b,0xfb7,2,0xf40,0xfb5,0x8202,0xfb2,0xf80,0xfb2,
0xf81,2,0x8243,0xfb2,0xf71,0xf80,0x8202,0xfb3,0xf80,0xfb3,0xf81,2,0x8243,0xfb3,0xf71,0xf80,
2,0xf92,0xfb7,2,0xf9c,0xfb7,2,0xfa1,0xfb7,2,0xfa6,0xfb7,2,0xfab,0xfb7,2,
0xf90,0xfb5,1,0x41,1,0xc6,1,0x42,1,0x44,1,0x45,1,0x18e,1,0x47,
1,0x48,1,0x49,1,0x4a,1,0x4b,1,0x4c,1,0x4d,1,0x4e,1,0x4f,
1,0x222,1,0x50,1,0x52,1,0x54,1,0x55,1,0x57,1,0x250,1,0x251,
1,0x1d02,1,0x62,1,0x64,1,0x65,1,0x259,1,0x25b,1,0x25c,1,0x67,
1,0x6b,1,0x6d,1,0x14b,1,0x254,1,0x70,1,0x74,1,0x75,1,0x26f,
1,0x76,1,0x3b2,1,0x3b3,1,0x3b4,1,0x3c6,1,0x3c7,1,0x69,1,0x3c1,
1,0x43d,1,0x252,1,0x63,1,0x255,1,0xf0,1,0x66,1,0x25f,1,0x261,
1,0x265,1,0x268,1,0x269,1,0x26a,1,0x29d,1,0x26d,1,0x29f,1,0x271,
1,0x270,1,0x272,1,0x273,1,0x274,1,0x275,1,0x278,1,0x282,1,0x283,
1,0x1ab,1,0x289,1,0x28a,1,0x1d1c,1,0x28b,1,0x28c,1,0x7a,1,0x290,
1,0x291,1,0x292,1,0x3b8,2,0x61,0x2be,0xe602,0x20,0x313,1,0x3b9,0xe602,0x20,
0x342,0xa8,0xe643,0x20,0x308,0x342,0x1fbf,0xe643,0x20,0x313,0x300,0x1fbf,0xe643,0x20,0x313,0x301,
0x1fbf,0xe643,0x20,0x313,0x342,0x1ffe,0xe643,0x20,0x314,0x300,0x1ffe,0xe643,0x20,0x314,0x301,0x1ffe,
0xe643,0x20,0x314,0x342,0xa8,0xe643,0x20,0x308,0x300,0x385,1,0xe643,0x20,0x308,0x301,1,
0x60,0xb4,0xe642,0x20,0x301,0xe602,0x20,0x314,0x2002,1,0x41,0x20,0x2003,1,0x41,0x20,
0xdc02,0x20,0x333,1,0x2e,2,0x2e,0x2e,3,0x2e,0x2e,0x2e,2,0x2032,0x2032,3,
0x2032,0x2032,0x2032,2,0x2035,0x2035,3,0x2035,0x2035,0x2035,2,0x21,0x21,0xe602,0x20,0x305,
2,0x3f,0x3f,2,0x3f,0x21,2,0x21,0x3f,4,0x2032,0x2032,0x2032,0x2032,1,0x30,
1,0x34,1,0x35,1,0x36,1,0x37,1,0x38,1,0x39,1,0x2b,1,0x2212,
1,0x3d,1,0x28,1,0x29,1,0x6e,2,0x52,0x73,3,0x61,0x2f,0x63,3,
0x61,0x2f,0x73,1,0x43,2,0xb0,0x43,3,0x63,0x2f,0x6f,3,0x63,0x2f,0x75,
1,0x190,2,0xb0,0x46,1,0x127,2,0x4e,0x6f,1,0x51,2,0x53,0x4d,3,
0x54,0x45,0x4c,2,0x54,0x4d,1,0x5a,1,0x3a9,1,0x46,1,0x5d0,1,0x5d1,
1,0x5d2,1,0x5d3,3,0x46,0x41,0x58,1,0x3c0,1,0x393,1,0x3a0,1,0x2211,
3,0x31,0x2044,0x37,3,0x31,0x2044,0x39,4,0x31,0x2044,0x31,0x30,3,0x31,0x2044,
0x33,3,0x32,0x2044,0x33,3,0x31,0x2044,0x35,3,0x32,0x2044,0x35,3,0x33,0x2044,
0x35,3,0x34,0x2044,0x35,3,0x31,0x2044,0x36,3,0x35,0x2044,0x36,3,0x31,0x2044,
0x38,3,0x33,0x2044,0x38,3,0x35,0x2044,0x38,3,0x37,0x2044,0x38,2,0x31,0x2044,
2,0x49,0x49,3,0x49,0x49,0x49,2,0x49,0x56,1,0x56,2,0x56,0x49,3,
0x56,0x49,0x49,4,0x56,0x49,0x49,0x49,2,0x49,0x58,1,0x58,2,0x58,0x49,
3,0x58,0x49,0x49,2,0x69,0x69,3,0x69,0x69,0x69,2,0x69,0x76,2,0x76,
0x69,3,0x76,0x69,0x69,4,0x76,0x69,0x69,0x69,2,0x69,0x78,2,0x78,0x69,
3,0x78,0x69,0x69,3,0x30,0x2044,0x33,2,0x222b,0x222b,3,0x222b,0x222b,0x222b,2,
0x222e,0x222e,3,0x222e,0x222e,0x222e,1,0x3008,1,0x3009,2,0x31,0x30,2,0x31,0x31,
2,0x31,0x32,2,0x31,0x33,2,0x31,0x34,2,0x31,0x35,2,0x31,0x36,2,
0x31,0x37,2,0x31,0x38,2,0x31,0x39,2,0x32,0x30,3,0x28,0x31,0x29,3,
0x28,0x32,0x29,3,0x28,0x33,0x29,3,0x28,0x34,0x29,3,0x28,0x35,0x29,3,
0x28,0x36,0x29,3,0x28,0x37,0x29,3,0x28,0x38,0x29,3,0x28,0x39,0x29,4,
0x28,0x31,0x30,0x29,4,0x28,0x31,0x31,0x29,4,0x28,0x31,0x32,0x29,4,0x28,
0x31,0x33,0x29,4,0x28,0x31,0x34,0x29,4,0x28,0x31,0x35,0x29,4,0x28,0x31,
0x36,0x29,4,0x28,0x31,0x37,0x29,4,0x28,0x31,0x38,0x29,4,0x28,0x31,0x39,
0x29,4,0x28,0x32,0x30,0x29,2,0x31,0x2e,2,0x32,0x2e,2,0x33,0x2e,2,
0x34,0x2e,2,0x35,0x2e,2,0x36,0x2e,2,0x37,0x2e,2,0x38,0x2e,2,0x39,
0x2e,3,0x31,0x30,0x2e,3,0x31,0x31,0x2e,3,0x31,0x32,0x2e,3,0x31,0x33,
0x2e,3,0x31,0x34,0x2e,3,0x31,0x35,0x2e,3,0x31,0x36,0x2e,3,0x31,0x37,
0x2e,3,0x31,0x38,0x2e,3,0x31,0x39,0x2e,3,0x32,0x30,0x2e,3,0x28,0x61,
0x29,3,0x28,0x62,0x29,3,0x28,0x63,0x29,3,0x28,0x64,0x29,3,0x28,0x65,
0x29,3,0x28,0x66,0x29,3,0x28,0x67,0x29,3,0x28,0x68,0x29,3,0x28,0x69,
0x29,3,0x28,0x6a,0x29,3,0x28,0x6b,0x29,3,0x28,0x6c,0x29,3,0x28,0x6d,
0x29,3,0x28,0x6e,0x29,3,0x28,0x6f,0x29,3,0x28,0x70,0x29,3,0x28,0x71,
0x29,3,0x28,0x72,0x29,3,0x28,0x73,0x29,3,0x28,0x74,0x29,3,0x28,0x75,
0x29,3,0x28,0x76,0x29,3,0x28,0x77,0x29,3,0x28,0x78,0x29,3,0x28,0x79,
0x29,3,0x28,0x7a,0x29,1,0x53,1,0x59,1,0x71,4,0x222b,0x222b,0x222b,0x222b,
3,0x3a,0x3a,0x3d,2,0x3d,0x3d,3,0x3d,0x3d,0x3d,0x102,0x2add,0x338,1,0x6bcd,
1,0x9f9f,1,0x4e00,1,0x4e28,1,0x4e36,1,0x4e3f,1,0x4e59,1,0x4e85,1,0x4e8c,
1,0x4ea0,1,0x4eba,1,0x513f,1,0x5165,1,0x516b,1,0x5182,1,0x5196,1,0x51ab,
1,0x51e0,1,0x51f5,1,0x5200,1,0x529b,1,0x52f9,1,0x5315,1,0x531a,1,0x5338,
1,0x5341,1,0x535c,1,0x5369,1,0x5382,1,0x53b6,1,0x53c8,1,0x53e3,1,0x56d7,
1,0x571f,1,0x58eb,1,0x5902,1,0x590a,1,0x5915,1,0x5927,1,0x5973,1,0x5b50,
1,0x5b80,1,0x5bf8,1,0x5c0f,1,0x5c22,1,0x5c38,1,0x5c6e,1,0x5c71,1,0x5ddb,
1,0x5de5,1,0x5df1,1,0x5dfe,1,0x5e72,1,0x5e7a,1,0x5e7f,1,0x5ef4,1,0x5efe,
1,0x5f0b,1,0x5f13,1,0x5f50,1,0x5f61,1,0x5f73,1,0x5fc3,1,0x6208,1,0x6236,
1,0x624b,1,0x652f,1,0x6534,1,0x6587,1,0x6597,1,0x65a4,1,0x65b9,1,0x65e0,
1,0x65e5,1,0x66f0,1,0x6708,1,0x6728,1,0x6b20,1,0x6b62,1,0x6b79,1,0x6bb3,
1,0x6bcb,1,0x6bd4,1,0x6bdb,1,0x6c0f,1,0x6c14,1,0x6c34,1,0x706b,1,0x722a,
1,0x7236,1,0x723b,1,0x723f,1,0x7247,1,0x7259,1,0x725b,1,0x72ac,1,0x7384,
1,0x7389,1,0x74dc,1,0x74e6,1,0x7518,1,0x751f,1,0x7528,1,0x7530,1,0x758b,
1,0x7592,1,0x7676,1,0x767d,1,0x76ae,1,0x76bf,1,0x76ee,1,0x77db,1,0x77e2,
1,0x77f3,1,0x793a,1,0x79b8,1,0x79be,1,0x7a74,1,0x7acb,1,0x7af9,1,0x7c73,
1,0x7cf8,1,0x7f36,1,0x7f51,1,0x7f8a,1,0x7fbd,1,0x8001,1,0x800c,1,0x8012,
1,0x8033,1,0x807f,1,0x8089,1,0x81e3,1,0x81ea,1,0x81f3,1,0x81fc,1,0x820c,
1,0x821b,1,0x821f,1,0x826e,1,0x8272,1,0x8278,1,0x864d,1,0x866b,1,0x8840,
1,0x884c,1,0x8863,1,0x897e,1,0x898b,1,0x89d2,1,0x8a00,1,0x8c37,1,0x8c46,
1,0x8c55,1,0x8c78,1,0x8c9d,1,0x8d64,1,0x8d70,1,0x8db3,1,0x8eab,1,0x8eca,
1,0x8f9b,1,0x8fb0,1,0x8fb5,1,0x9091,1,0x9149,1,0x91c6,1,0x91cc,1,0x91d1,
1,0x9577,1,0x9580,1,0x961c,1,0x96b6,1,0x96b9,1,0x96e8,1,0x9751,1,0x975e,
1,0x9762,1,0x9769,1,0x97cb,1,0x97ed,1,0x97f3,1,0x9801,1,0x98a8,1,0x98db,
1,0x98df,1,0x9996,1,0x9999,1,0x99ac,1,0x9aa8,1,0x9ad8,1,0x9adf,1,0x9b25,
1,0x9b2f,1,0x9b32,1,0x9b3c,1,0x9b5a,1,0x9ce5,1,0x9e75,1,0x9e7f,1,0x9ea5,
1,0x9ebb,1,0x9ec3,1,0x9ecd,1,0x9ed1,1,0x9ef9,1,0x9efd,1,0x9f0e,1,0x9f13,
1,0x9f20,1,0x9f3b,1,0x9f4a,1,0x9f52,1,0x9f8d,1,0x9f9c,1,0x9fa0,1,0x5344,
1,0x5345,0x802,0x20,0x3099,0x802,0x20,0x309a,2,0x3088,0x308a,2,0x30b3,0x30c8,1,0x1100,
1,0x1101,1,0x1102,1,0x1103,1,0x1104,1,0x1105,1,0x111a,1,0x1106,1,0x1107,
1,0x1108,1,0x1121,1,0x1109,1,0x110a,1,0x110b,1,0x110c,1,0x110d,1,0x110e,
1,0x110f,1,0x1110,1,0x1111,1,0x1112,1,0x1160,1,0x1114,1,0x1115,1,0x11c7,
1,0x11c8,1,0x11cc,1,0x11ce,1,0x11d3,1,0x11d7,1,0x11d9,1,0x111c,1,0x11dd,
1,0x11df,1,0x111d,1,0x111e,1,0x1120,1,0x1122,1,0x1123,1,0x1127,1,0x1129,
1,0x112b,1,0x112c,1,0x112d,1,0x112e,1,0x112f,1,0x1132,1,0x1136,1,0x1140,
1,0x1147,1,0x114c,1,0x11f1,1,0x11f2,1,0x1157,1,0x1158,1,0x1159,1,0x1184,
1,0x1185,1,0x1188,1,0x1191,1,0x1192,1,0x1194,1,0x119e,1,0x11a1,1,0x4e09,
1,0x56db,1,0x4e0a,1,0x4e2d,1,0x4e0b,1,0x7532,1,0x4e19,1,0x4e01,1,0x5929,
1,0x5730,3,0x28,0x1100,0x29,3,0x28,0x1102,0x29,3,0x28,0x1103,0x29,3,0x28,
0x1105,0x29,3,0x28,0x1106,0x29,3,0x28,0x1107,0x29,3,0x28,0x1109,0x29,3,0x28,
0x110b,0x29,3,0x28,0x110c,0x29,3,0x28,0x110e,0x29,3,0x28,0x110f,0x29,3,0x28,
0x1110,0x29,3,0x28,0x1111,0x29,3,0x28,0x1112,0x29,3,0x28,0x4e00,0x29,3,0x28,
0x4e8c,0x29,3,0x28,0x4e09,0x29,3,0x28,0x56db,0x29,3,0x28,0x4e94,0x29,3,0x28,
0x516d,0x29,3,0x28,0x4e03,0x29,3,0x28,0x516b,0x29,3,0x28,0x4e5d,0x29,3,0x28,
0x5341,0x29,3,0x28,0x6708,0x29,3,0x28,0x706b,0x29,3,0x28,0x6c34,0x29,3,0x28,
0x6728,0x29,3,0x28,0x91d1,0x29,3,0x28,0x571f,0x29,3,0x28,0x65e5,0x29,3,0x28,
0x682a,0x29,3,0x28,0x6709,0x29,3,0x28,0x793e,0x29,3,0x28,0x540d,0x29,3,0x28,
0x7279,0x29,3,0x28,0x8ca1,0x29,3,0x28,0x795d,0x29,3,0x28,0x52b4,0x29,3,0x28,
0x4ee3,0x29,3,0x28,0x547c,0x29,3,0x28,0x5b66,0x29,3,0x28,0x76e3,0x29,3,0x28,
0x4f01,0x29,3,0x28,0x8cc7,0x29,3,0x28,0x5354,0x29,3,0x28,0x796d,0x29,3,0x28,
0x4f11,0x29,3,0x28,0x81ea,0x29,3,0x28,0x81f3,0x29,1,0x554f,1,0x5e7c,1,0x7b8f,
3,0x50,0x54,0x45,2,0x32,0x31,2,0x32,0x32,2,0x32,0x33,2,0x32,0x34,
2,0x32,0x35,2,0x32,0x36,2,0x32,0x37,2,0x32,0x38,2,0x32,0x39,2,
0x33,0x30,2,0x33,0x31,2,0x33,0x32,2,0x33,0x33,2,0x33,0x34,2,0x33,
0x35,1,0x4e94,1,0x516d,1,0x4e03,1,0x4e5d,1,0x682a,1,0x6709,1,0x793e,1,
0x540d,1,0x7279,1,0x8ca1,1,0x795d,1,0x52b4,1,0x79d8,1,0x7537,1,0x9069,1,
0x512a,1,0x5370,1,0x6ce8,1,0x9805,1,0x4f11,1,0x5199,1,0x6b63,1,0x5de6,1,
0x53f3,1,0x533b,1,0x5b97,1,0x5b66,1,0x76e3,1,0x4f01,1,0x8cc7,1,0x5354,1,
0x591c,2,0x33,0x36,2,0x33,0x37,2,0x33,0x38,2,0x33,0x39,2,0x34,0x30,
2,0x34,0x31,2,0x34,0x32,2,0x34,0x33,2,0x34,0x34,2,0x34,0x35,2,
0x34,0x36,2,0x34,0x37,2,0x34,0x38,2,0x34,0x39,2,0x35,0x30,2,0x31,
0x6708,2,0x32,0x6708,2,0x33,0x6708,2,0x34,0x6708,2,0x35,0x6708,2,0x36,0x6708,
2,0x37,0x6708,2,0x38,0x6708,2,0x39,0x6708,3,0x31,0x30,0x6708,3,0x31,0x31,
0x6708,3,0x31,0x32,0x6708,2,0x48,0x67,3,0x65,0x72,0x67,2,0x65,0x56,3,
0x4c,0x54,0x44,1,0x30a2,1,0x30a4,1,0x30a6,1,0x30a8,1,0x30aa,1,0x30ab,1,
0x30ad,1,0x30af,1,0x30b1,1,0x30b3,1,0x30b5,1,0x30b7,1,0x30b9,1,0x30bb,1,
0x30bd,1,0x30bf,1,0x30c1,1,0x30c4,1,0x30c6,1,0x30c8,1,0x30ca,1,0x30cb,1,
0x30cc,1,0x30cd,1,0x30ce,1,0x30cf,1,0x30d2,1,0x30d5,1,0x30d8,1,0x30db,1,
0x30de,1,0x30df,1,0x30e0,1,0x30e1,1,0x30e2,1,0x30e4,1,0x30e6,1,0x30e8,1,
0x30e9,1,0x30ea,1,0x30eb,1,0x30ec,1,0x30ed,1,0x30ef,1,0x30f0,1,0x30f1,1,
0x30f2,4,0x30a2,0x30eb,0x30d5,0x30a1,3,0x30a2,0x30fc,0x30eb,3,0x30a4,0x30f3,0x30c1,3,0x30a6,
0x30a9,0x30f3,4,0x30a8,0x30fc,0x30ab,0x30fc,3,0x30aa,0x30f3,0x30b9,3,0x30aa,0x30fc,0x30e0,3,
0x30ab,0x30a4,0x30ea,4,0x30ab,0x30e9,0x30c3,0x30c8,4,0x30ab,0x30ed,0x30ea,0x30fc,4,0x30ad,0x30e5,
0x30ea,0x30fc,2,0x30ad,0x30ed,6,0x30ad,0x30ed,0x30e1,0x30fc,0x30c8,0x30eb,5,0x30ad,0x30ed,0x30ef,
0x30c3,0x30c8,4,0x30af,0x30ed,0x30fc,0x30cd,3,0x30b1,0x30fc,0x30b9,3,0x30b3,0x30eb,0x30ca,4,
0x30b5,0x30a4,0x30af,0x30eb,5,0x30b5,0x30f3,0x30c1,0x30fc,0x30e0,3,0x30bb,0x30f3,0x30c1,3,0x30bb,
0x30f3,0x30c8,2,0x30c8,0x30f3,2,0x30ca,0x30ce,3,0x30ce,0x30c3,0x30c8,3,0x30cf,0x30a4,0x30c4,
4,0x30d5,0x30a3,0x30fc,0x30c8,3,0x30d5,0x30e9,0x30f3,5,0x30d8,0x30af,0x30bf,0x30fc,0x30eb,3,
0x30d8,0x30eb,0x30c4,2,0x30db,0x30f3,3,0x30db,0x30fc,0x30eb,3,0x30db,0x30fc,0x30f3,4,0x30de,
0x30a4,0x30af,0x30ed,3,0x30de,0x30a4,0x30eb,3,0x30de,0x30c3,0x30cf,3,0x30de,0x30eb,0x30af,5,
0x30de,0x30f3,0x30b7,0x30e7,0x30f3,4,0x30df,0x30af,0x30ed,0x30f3,2,0x30df,0x30ea,4,0x30e1,0x30fc,
0x30c8,0x30eb,3,0x30e4,0x30fc,0x30eb,3,0x30e6,0x30a2,0x30f3,4,0x30ea,0x30c3,0x30c8,0x30eb,2,
0x30ea,0x30e9,2,0x30ec,0x30e0,3,0x30ef,0x30c3,0x30c8,2,0x30,0x70b9,2,0x31,0x70b9,2,
0x32,0x70b9,2,0x33,0x70b9,2,0x34,0x70b9,2,0x35,0x70b9,2,0x36,0x70b9,2,0x37,
0x70b9,2,0x38,0x70b9,2,0x39,0x70b9,3,0x31,0x30,0x70b9,3,0x31,0x31,0x70b9,3,
0x31,0x32,0x70b9,3,0x31,0x33,0x70b9,3,0x31,0x34,0x70b9,3,0x31,0x35,0x70b9,3,
0x31,0x36,0x70b9,3,0x31,0x37,0x70b9,3,0x31,0x38,0x70b9,3,0x31,0x39,0x70b9,3,
0x32,0x30,0x70b9,3,0x32,0x31,0x70b9,3,0x32,0x32,0x70b9,3,0x32,0x33,0x70b9,3,
0x32,0x34,0x70b9,3,0x68,0x50,0x61,2,0x64,0x61,2,0x41,0x55,3,0x62,0x61,
0x72,2,0x6f,0x56,2,0x70,0x63,2,0x64,0x6d,0x64,0x6d,0xb2,3,0x43,0x64,
0x6d,0x32,0x64,0x6d,0xb3,3,0x43,0x64,0x6d,0x33,2,0x49,0x55,2,0x5e73,0x6210,
2,0x662d,0x548c,2,0x5927,0x6b63,2,0x660e,0x6cbb,4,0x682a,0x5f0f,0x4f1a,0x793e,2,0x70,
0x41,2,0x6e,0x41,2,0x3bc,0x41,2,0x6d,0x41,2,0x6b,0x41,2,0x4b,0x42,
2,0x4d,0x42,2,0x47,0x42,3,0x63,0x61,0x6c,4,0x6b,0x63,0x61,0x6c,2,
0x70,0x46,2,0x6e,0x46,2,0x3bc,0x46,2,0x3bc,0x67,2,0x6d,0x67,2,0x6b,
0x67,2,0x48,0x7a,3,0x6b,0x48,0x7a,3,0x4d,0x48,0x7a,3,0x47,0x48,0x7a,
3,0x54,0x48,0x7a,0x3bc,0x2113,2,0x42,0x3bc,0x6c,0x6d,0x2113,2,0x42,0x6d,0x6c,
0x64,0x2113,2,0x42,0x64,0x6c,0x6b,0x2113,2,0x42,0x6b,0x6c,2,0x66,0x6d,2,
0x6e,0x6d,2,0x3bc,0x6d,2,0x6d,0x6d,2,0x63,0x6d,2,0x6b,0x6d,0x6d,0x6d,
0xb2,3,0x43,0x6d,0x6d,0x32,0x63,0x6d,0xb2,3,0x43,0x63,0x6d,0x32,0x6d,0xb2,
2,0x42,0x6d,0x32,0x6b,0x6d,0xb2,3,0x43,0x6b,0x6d,0x32,0x6d,0x6d,0xb3,3,
0x43,0x6d,0x6d,0x33,0x63,0x6d,0xb3,3,0x43,0x63,0x6d,0x33,0x6d,0xb3,2,0x42,
0x6d,0x33,0x6b,0x6d,0xb3,3,0x43,0x6b,0x6d,0x33,3,0x6d,0x2215,0x73,0x6d,0x2215,
0x73,0xb2,4,0x44,0x6d,0x2215,0x73,0x32,2,0x50,0x61,3,0x6b,0x50,0x61,3,
0x4d,0x50,0x61,3,0x47,0x50,0x61,3,0x72,0x61,0x64,5,0x72,0x61,0x64,0x2215,
0x73,0x72,0x61,0x64,0x2215,0x73,0xb2,6,0x46,0x72,0x61,0x64,0x2215,0x73,0x32,2,
0x70,0x73,2,0x6e,0x73,2,0x3bc,0x73,2,0x6d,0x73,2,0x70,0x56,2,0x6e,
0x56,2,0x3bc,0x56,2,0x6d,0x56,2,0x6b,0x56,2,0x4d,0x56,2,0x70,0x57,
2,0x6e,0x57,2,0x3bc,0x57,2,0x6d,0x57,2,0x6b,0x57,2,0x4d,0x57,2,
0x6b,0x3a9,2,0x4d,0x3a9,4,0x61,0x2e,0x6d,0x2e,2,0x42,0x71,2,0x63,0x63,
2,0x63,0x64,4,0x43,0x2215,0x6b,0x67,3,0x43,0x6f,0x2e,2,0x64,0x42,2,
0x47,0x79,2,0x68,0x61,2,0x48,0x50,2,0x69,0x6e,2,0x4b,0x4b,2,0x4b,
0x4d,2,0x6b,0x74,2,0x6c,0x6d,2,0x6c,0x6e,3,0x6c,0x6f,0x67,2,0x6c,
0x78,2,0x6d,0x62,3,0x6d,0x69,0x6c,3,0x6d,0x6f,0x6c,2,0x50,0x48,4,
0x70,0x2e,0x6d,0x2e,3,0x50,0x50,0x4d,2,0x50,0x52,2,0x73,0x72,2,0x53,
0x76,2,0x57,0x62,3,0x56,0x2215,0x6d,3,0x41,0x2215,0x6d,2,0x31,0x65e5,2,
0x32,0x65e5,2,0x33,0x65e5,2,0x34,0x65e5,2,0x35,0x65e5,2,0x36,0x65e5,2,0x37,
0x65e5,2,0x38,0x65e5,2,0x39,0x65e5,3,0x31,0x30,0x65e5,3,0x31,0x31,0x65e5,3,
0x31,0x32,0x65e5,3,0x31,0x33,0x65e5,3,0x31,0x34,0x65e5,3,0x31,0x35,0x65e5,3,
0x31,0x36,0x65e5,3,0x31,0x37,0x65e5,3,0x31,0x38,0x65e5,3,0x31,0x39,0x65e5,3,
0x32,0x30,0x65e5,3,0x32,0x31,0x65e5,3,0x32,0x32,0x65e5,3,0x32,0x33,0x65e5,3,
0x32,0x34,0x65e5,3,0x32,0x35,0x65e5,3,0x32,0x36,0x65e5,3,0x32,0x37,0x65e5,3,
0x32,0x38,0x65e5,3,0x32,0x39,0x65e5,3,0x33,0x30,0x65e5,3,0x33,0x31,0x65e5,3,
0x67,0x61,0x6c,1,0x44a,1,0x44c,1,0x126,1,0x153,1,0xa727,1,0x26b,1,
0x8c48,1,0x66f4,1,0x8cc8,1,0x6ed1,1,0x4e32,1,0x53e5,1,0x5951,1,0x5587,1,
0x5948,1,0x61f6,1,0x7669,1,0x7f85,1,0x863f,1,0x87ba,1,0x88f8,1,0x908f,1,
0x6a02,1,0x6d1b,1,0x70d9,1,0x73de,1,0x843d,1,0x916a,1,0x99f1,1,0x4e82,1,
0x5375,1,0x6b04,1,0x721b,1,0x862d,1,0x9e1e,1,0x5d50,1,0x6feb,1,0x85cd,1,
0x8964,1,0x62c9,1,0x81d8,1,0x881f,1,0x5eca,1,0x6717,1,0x6d6a,1,0x72fc,1,
0x90ce,1,0x4f86,1,0x51b7,1,0x52de,1,0x64c4,1,0x6ad3,1,0x7210,1,0x76e7,1,
0x8606,1,0x865c,1,0x8def,1,0x9732,1,0x9b6f,1,0x9dfa,1,0x788c,1,0x797f,1,
0x7da0,1,0x83c9,1,0x9304,1,0x8ad6,1,0x58df,1,0x5f04,1,0x7c60,1,0x807e,1,
0x7262,1,0x78ca,1,0x8cc2,1,0x96f7,1,0x58d8,1,0x5c62,1,0x6a13,1,0x6dda,1,
0x6f0f,1,0x7d2f,1,0x7e37,1,0x964b,1,0x52d2,1,0x808b,1,0x51dc,1,0x51cc,1,
0x7a1c,1,0x7dbe,1,0x83f1,1,0x9675,1,0x8b80,1,0x62cf,1,0x8afe,1,0x4e39,1,
0x5be7,1,0x6012,1,0x7387,1,0x7570,1,0x5317,1,0x78fb,1,0x4fbf,1,0x5fa9,1,
0x4e0d,1,0x6ccc,1,0x6578,1,0x7d22,1,0x53c3,1,0x585e,1,0x7701,1,0x8449,1,
0x8aaa,1,0x6bba,1,0x6c88,1,0x62fe,1,0x82e5,1,0x63a0,1,0x7565,1,0x4eae,1,
0x5169,1,0x51c9,1,0x6881,1,0x7ce7,1,0x826f,1,0x8ad2,1,0x91cf,1,0x52f5,1,
0x5442,1,0x5eec,1,0x65c5,1,0x6ffe,1,0x792a,1,0x95ad,1,0x9a6a,1,0x9e97,1,
0x9ece,1,0x66c6,1,0x6b77,1,0x8f62,1,0x5e74,1,0x6190,1,0x6200,1,0x649a,1,
0x6f23,1,0x7149,1,0x7489,1,0x79ca,1,0x7df4,1,0x806f,1,0x8f26,1,0x84ee,1,
0x9023,1,0x934a,1,0x5217,1,0x52a3,1,0x54bd,1,0x70c8,1,0x88c2,1,0x5ec9,1,
0x5ff5,1,0x637b,1,0x6bae,1,0x7c3e,1,0x7375,1,0x4ee4,1,0x56f9,1,0x5dba,1,
0x601c,1,0x73b2,1,0x7469,1,0x7f9a,1,0x8046,1,0x9234,1,0x96f6,1,0x9748,1,
0x9818,1,0x4f8b,1,0x79ae,1,0x91b4,1,0x96b8,1,0x60e1,1,0x4e86,1,0x50da,1,
0x5bee,1,0x5c3f,1,0x6599,1,0x71ce,1,0x7642,1,0x84fc,1,0x907c,1,0x6688,1,
0x962e,1,0x5289,1,0x677b,1,0x67f3,1,0x6d41,1,0x6e9c,1,0x7409,1,0x7559,1,
0x786b,1,0x7d10,1,0x985e,1,0x622e,1,0x9678,1,0x502b,1,0x5d19,1,0x6dea,1,
0x8f2a,1,0x5f8b,1,0x6144,1,0x6817,1,0x9686,1,0x5229,1,0x540f,1,0x5c65,1,
0x6613,1,0x674e,1,0x68a8,1,0x6ce5,1,0x7406,1,0x75e2,1,0x7f79,1,0x88cf,1,
0x88e1,1,0x96e2,1,0x533f,1,0x6eba,1,0x541d,1,0x71d0,1,0x7498,1,0x85fa,1,
0x96a3,1,0x9c57,1,0x9e9f,1,0x6797,1,0x6dcb,1,0x81e8,1,0x7b20,1,0x7c92,1,
0x72c0,1,0x7099,1,0x8b58,1,0x4ec0,1,0x8336,1,0x523a,1,0x5207,1,0x5ea6,1,
0x62d3,1,0x7cd6,1,0x5b85,1,0x6d1e,1,0x66b4,1,0x8f3b,1,0x964d,1,0x5ed3,1,
0x5140,1,0x55c0,1,0x585a,1,0x6674,1,0x51de,1,0x732a,1,0x76ca,1,0x793c,1,
0x795e,1,0x7965,1,0x798f,1,0x9756,1,0x7cbe,1,0x8612,1,0x8af8,1,0x9038,1,
0x90fd,1,0x98ef,1,0x98fc,1,0x9928,1,0x9db4,1,0x90de,1,0x96b7,1,0x4fae,1,
0x50e7,1,0x514d,1,0x52c9,1,0x52e4,1,0x5351,1,0x559d,1,0x5606,1,0x5668,1,
0x5840,1,0x58a8,1,0x5c64,1,0x6094,1,0x6168,1,0x618e,1,0x61f2,1,0x654f,1,
0x65e2,1,0x6691,1,0x6885,1,0x6d77,1,0x6e1a,1,0x6f22,1,0x716e,1,0x722b,1,
0x7422,1,0x7891,1,0x7949,1,0x7948,1,0x7950,1,0x7956,1,0x798d,1,0x798e,1,
0x7a40,1,0x7a81,1,0x7bc0,1,0x7e09,1,0x7e41,1,0x7f72,1,0x8005,1,0x81ed,1,
0x8279,1,0x8457,1,0x8910,1,0x8996,1,0x8b01,1,0x8b39,1,0x8cd3,1,0x8d08,1,
0x8fb6,1,0x96e3,1,0x97ff,1,0x983b,1,0x6075,2,0xd850,0xdeee,1,0x8218,1,0x4e26,
1,0x51b5,1,0x5168,1,0x4f80,1,0x5145,1,0x5180,1,0x52c7,1,0x52fa,1,0x5555,
1,0x5599,1,0x55e2,1,0x58b3,1,0x5944,1,0x5954,1,0x5a62,1,0x5b28,1,0x5ed2,
1,0x5ed9,1,0x5f69,1,0x5fad,1,0x60d8,1,0x614e,1,0x6108,1,0x6160,1,0x6234,
1,0x63c4,1,0x641c,1,0x6452,1,0x6556,1,0x671b,1,0x6756,1,0x6edb,1,0x6ecb,
1,0x701e,1,0x77a7,1,0x7235,1,0x72af,1,0x7471,1,0x7506,1,0x753b,1,0x761d,
1,0x761f,1,0x76db,1,0x76f4,1,0x774a,1,0x7740,1,0x78cc,1,0x7ab1,1,0x7c7b,
1,0x7d5b,1,0x7f3e,1,0x8352,1,0x83ef,1,0x8779,1,0x8941,1,0x8986,1,0x8abf,
1,0x8acb,1,0x8aed,1,0x8b8a,1,0x8f38,1,0x9072,1,0x9199,1,0x9276,1,0x967c,
1,0x97db,1,0x980b,1,0x9b12,2,0xd84a,0xdc4a,2,0xd84a,0xdc44,2,0xd84c,0xdfd5,1,
0x3b9d,1,0x4018,1,0x4039,2,0xd854,0xde49,2,0xd857,0xdcd0,2,0xd85f,0xded3,1,0x9f43,
1,0x9f8e,2,0x66,0x66,2,0x66,0x69,2,0x66,0x6c,3,0x66,0x66,0x69,3,
0x66,0x66,0x6c,0x17f,0x74,2,0x42,0x73,0x74,2,0x73,0x74,2,0x574,0x576,2,
0x574,0x565,2,0x574,0x56b,2,0x57e,0x576,2,0x574,0x56d,0xe02,0x5d9,0x5b4,0x1102,0x5f2,
0x5b7,1,0x5e2,1,0x5d4,1,0x5db,1,0x5dc,1,0x5dd,1,0x5e8,1,0x5ea,0x1802,
0x5e9,0x5c1,0x1902,0x5e9,0x5c2,0xfb49,0x1843,0x5e9,0x5bc,0x5c1,0xfb49,0x1943,0x5e9,0x5bc,0x5c2,0x1102,
0x5d0,0x5b7,0x1202,0x5d0,0x5b8,0x1502,0x5d0,0x5bc,0x1502,0x5d1,0x5bc,0x1502,0x5d2,0x5bc,0x1502,0x5d3,
0x5bc,0x1502,0x5d4,0x5bc,0x1502,0x5d5,0x5bc,0x1502,0x5d6,0x5bc,0x1502,0x5d8,0x5bc,0x1502,0x5d9,0x5bc,
0x1502,0x5da,0x5bc,0x1502,0x5db,0x5bc,0x1502,0x5dc,0x5bc,0x1502,0x5de,0x5bc,0x1502,0x5e0,0x5bc,0x1502,
0x5e1,0x5bc,0x1502,0x5e3,0x5bc,0x1502,0x5e4,0x5bc,0x1502,0x5e6,0x5bc,0x1502,0x5e7,0x5bc,0x1502,0x5e8,
0x5bc,0x1502,0x5e9,0x5bc,0x1502,0x5ea,0x5bc,0x1302,0x5d5,0x5b9,0x1702,0x5d1,0x5bf,0x1702,0x5db,0x5bf,
0x1702,0x5e4,0x5bf,2,0x5d0,0x5dc,1,0x671,1,0x67b,1,0x67e,1,0x680,1,0x67a,
1,0x67f,1,0x679,1,0x6a4,1,0x6a6,1,0x684,1,0x683,1,0x686,1,0x687,
1,0x68d,1,0x68c,1,0x68e,1,0x688,1,0x698,1,0x691,1,0x6a9,1,0x6af,
1,0x6b3,1,0x6b1,1,0x6ba,1,0x6bb,1,0x6c1,1,0x6be,1,0x6d2,1,0x6ad,
1,0x6c7,1,0x6c6,1,0x6c8,0x677,0x42,0x6c7,0x674,1,0x6cb,1,0x6c5,1,0x6c9,
1,0x6d0,1,0x649,1,0x6cc,2,0x628,0x62c,2,0x628,0x62d,2,0x628,0x62e,2,
0x628,0x645,2,0x628,0x649,2,0x628,0x64a,2,0x62a,0x62c,2,0x62a,0x62d,2,0x62a,
0x62e,2,0x62a,0x645,2,0x62a,0x649,2,0x62a,0x64a,2,0x62b,0x62c,2,0x62b,0x645,
2,0x62b,0x649,2,0x62b,0x64a,2,0x62c,0x62d,2,0x62c,0x645,2,0x62d,0x62c,2,
0x62d,0x645,2,0x62e,0x62c,2,0x62e,0x62d,2,0x62e,0x645,2,0x633,0x62c,2,0x633,
0x62d,2,0x633,0x62e,2,0x633,0x645,2,0x635,0x62d,2,0x635,0x645,2,0x636,0x62c,
2,0x636,0x62d,2,0x636,0x62e,2,0x636,0x645,2,0x637,0x62d,2,0x637,0x645,2,
0x638,0x645,2,0x639,0x62c,2,0x639,0x645,2,0x63a,0x62c,2,0x63a,0x645,2,0x641,
0x62c,2,0x641,0x62d,2,0x641,0x62e,2,0x641,0x645,2,0x641,0x649,2,0x641,0x64a,
2,0x642,0x62d,2,0x642,0x645,2,0x642,0x649,2,0x642,0x64a,2,0x643,0x627,2,
0x643,0x62c,2,0x643,0x62d,2,0x643,0x62e,2,0x643,0x644,2,0x643,0x645,2,0x643,
0x649,2,0x643,0x64a,2,0x644,0x62c,2,0x644,0x62d,2,0x644,0x62e,2,0x644,0x645,
2,0x644,0x649,2,0x644,0x64a,2,0x645,0x62c,2,0x645,0x62d,2,0x645,0x62e,2,
0x645,0x645,2,0x645,0x649,2,0x645,0x64a,2,0x646,0x62c,2,0x646,0x62d,2,0x646,
0x62e,2,0x646,0x645,2,0x646,0x649,2,0x646,0x64a,2,0x647,0x62c,2,0x647,0x645,
2,0x647,0x649,2,0x647,0x64a,2,0x64a,0x62c,2,0x64a,0x62d,2,0x64a,0x62e,2,
0x64a,0x645,2,0x64a,0x649,2,0x64a,0x64a,0x2302,0x630,0x670,0x2302,0x631,0x670,0x2302,0x649,
0x670,0x2103,0x20,0x64c,0x651,0x2103,0x20,0x64d,0x651,0x2103,0x20,0x64e,0x651,0x2103,0x20,0x64f,
0x651,0x2103,0x20,0x650,0x651,0x2303,0x20,0x651,0x670,2,0x628,0x631,2,0x628,0x632,2,
0x628,0x646,2,0x62a,0x631,2,0x62a,0x632,2,0x62a,0x646,2,0x62b,0x631,2,0x62b,
0x632,2,0x62b,0x646,2,0x645,0x627,2,0x646,0x631,2,0x646,0x632,2,0x646,0x646,
2,0x64a,0x631,2,0x64a,0x632,2,0x64a,0x646,2,0x628,0x647,2,0x62a,0x647,2,
0x635,0x62e,2,0x644,0x647,2,0x646,0x647,0x2302,0x647,0x670,2,0x64a,0x647,2,0x62b,
0x647,2,0x633,0x647,2,0x634,0x645,2,0x634,0x647,0x2103,0x640,0x64e,0x651,0x2103,0x640,
0x64f,0x651,0x2103,0x640,0x650,0x651,2,0x637,0x649,2,0x637,0x64a,2,0x639,0x649,2,
0x639,0x64a,2,0x63a,0x649,2,0x63a,0x64a,2,0x633,0x649,2,0x633,0x64a,2,0x634,
0x649,2,0x634,0x64a,2,0x62d,0x649,2,0x62d,0x64a,2,0x62c,0x649,2,0x62c,0x64a,
2,0x62e,0x649,2,0x62e,0x64a,2,0x635,0x649,2,0x635,0x64a,2,0x636,0x649,2,
0x636,0x64a,2,0x634,0x62c,2,0x634,0x62d,2,0x634,0x62e,2,0x634,0x631,2,0x633,
0x631,2,0x635,0x631,2,0x636,0x631,0x1b02,0x627,0x64b,3,0x62a,0x62c,0x645,3,0x62a,
0x62d,0x62c,3,0x62a,0x62d,0x645,3,0x62a,0x62e,0x645,3,0x62a,0x645,0x62c,3,0x62a,
0x645,0x62d,3,0x62a,0x645,0x62e,3,0x62c,0x645,0x62d,3,0x62d,0x645,0x64a,3,0x62d,
0x645,0x649,3,0x633,0x62d,0x62c,3,0x633,0x62c,0x62d,3,0x633,0x62c,0x649,3,0x633,
0x645,0x62d,3,0x633,0x645,0x62c,3,0x633,0x645,0x645,3,0x635,0x62d,0x62d,3,0x635,
0x645,0x645,3,0x634,0x62d,0x645,3,0x634,0x62c,0x64a,3,0x634,0x645,0x62e,3,0x634,
0x645,0x645,3,0x636,0x62d,0x649,3,0x636,0x62e,0x645,3,0x637,0x645,0x62d,3,0x637,
0x645,0x645,3,0x637,0x645,0x64a,3,0x639,0x62c,0x645,3,0x639,0x645,0x645,3,0x639,
0x645,0x649,3,0x63a,0x645,0x645,3,0x63a,0x645,0x64a,3,0x63a,0x645,0x649,3,0x641,
0x62e,0x645,3,0x642,0x645,0x62d,3,0x642,0x645,0x645,3,0x644,0x62d,0x645,3,0x644,
0x62d,0x64a,3,0x644,0x62d,0x649,3,0x644,0x62c,0x62c,3,0x644,0x62e,0x645,3,0x644,
0x645,0x62d,3,0x645,0x62d,0x62c,3,0x645,0x62d,0x645,3,0x645,0x62d,0x64a,3,0x645,
0x62c,0x62d,3,0x645,0x62c,0x645,3,0x645,0x62e,0x62c,3,0x645,0x62e,0x645,3,0x645,
0x62c,0x62e,3,0x647,0x645,0x62c,3,0x647,0x645,0x645,3,0x646,0x62d,0x645,3,0x646,
0x62d,0x649,3,0x646,0x62c,0x645,3,0x646,0x62c,0x649,3,0x646,0x645,0x64a,3,0x646,
0x645,0x649,3,0x64a,0x645,0x645,3,0x628,0x62e,0x64a,3,0x62a,0x62c,0x64a,3,0x62a,
0x62c,0x649,3,0x62a,0x62e,0x64a,3,0x62a,0x62e,0x649,3,0x62a,0x645,0x64a,3,0x62a,
0x645,0x649,3,0x62c,0x645,0x64a,3,0x62c,0x62d,0x649,3,0x62c,0x645,0x649,3,0x633,
0x62e,0x649,3,0x635,0x62d,0x64a,3,0x634,0x62d,0x64a,3,0x636,0x62d,0x64a,3,0x644,
0x62c,0x64a,3,0x644,0x645,0x64a,3,0x64a,0x62d,0x64a,3,0x64a,0x62c,0x64a,3,0x64a,
0x645,0x64a,3,0x645,0x645,0x64a,3,0x642,0x645,0x64a,3,0x646,0x62d,0x64a,3,0x639,
0x645,0x64a,3,0x643,0x645,0x64a,3,0x646,0x62c,0x62d,3,0x645,0x62e,0x64a,3,0x644,
0x62c,0x645,3,0x643,0x645,0x645,3,0x62c,0x62d,0x64a,3,0x62d,0x62c,0x64a,3,0x645,
0x62c,0x64a,3,0x641,0x645,0x64a,3,0x628,0x62d,0x64a,3,0x633,0x62e,0x64a,3,0x646,
0x62c,0x64a,3,0x635,0x644,0x6d2,3,0x642,0x644,0x6d2,4,0x627,0x644,0x644,0x647,4,
0x627,0x643,0x628,0x631,4,0x645,0x62d,0x645,0x62f,4,0x635,0x644,0x639,0x645,4,0x631,
0x633,0x648,0x644,4,0x639,0x644,0x64a,0x647,4,0x648,0x633,0x644,0x645,3,0x635,0x644,
0x649,0x12,0x635,0x644,0x649,0x20,0x627,0x644,0x644,0x647,0x20,0x639,0x644,0x64a,0x647,0x20,
0x648,0x633,0x644,0x645,8,0x62c,0x644,0x20,0x62c,0x644,0x627,0x644,0x647,4,0x631,0x6cc,
0x627,0x644,1,0x2c,1,0x3001,1,0x3002,1,0x3a,1,0x21,1,0x3f,1,0x3016,
1,0x3017,0x2026,1,0x43,0x2e,0x2e,0x2e,0x2025,0x42,0x2e,0x2e,1,0x2014,1,0x2013,
1,0x5f,1,0x7b,1,0x7d,1,0x3014,1,0x3015,1,0x3010,1,0x3011,1,0x300a,
1,0x300b,1,0x300c,1,0x300d,1,0x300e,1,0x300f,1,0x5b,1,0x5d,0x203e,0xe642,
0x20,0x305,1,0x23,1,0x26,1,0x2a,1,0x2d,1,0x3c,1,0x3e,1,0x5c,
1,0x24,1,0x25,1,0x40,0x1b02,0x20,0x64b,0x1b02,0x640,0x64b,0x1c02,0x20,0x64c,0x1d02,
0x20,0x64d,0x1e02,0x20,0x64e,0x1e02,0x640,0x64e,0x1f02,0x20,0x64f,0x1f02,0x640,0x64f,0x2002,0x20,
0x650,0x2002,0x640,0x650,0x2102,0x20,0x651,0x2102,0x640,0x651,0x2202,0x20,0x652,0x2202,0x640,0x652,
1,0x621,1,0x627,1,0x628,1,0x629,1,0x62a,1,0x62b,1,0x62c,1,0x62d,
1,0x62e,1,0x62f,1,0x630,1,0x631,1,0x632,1,0x633,1,0x634,1,0x635,
1,0x636,1,0x637,1,0x638,1,0x639,1,0x63a,1,0x641,1,0x642,1,0x643,
1,0x644,1,0x645,1,0x646,1,0x647,1,0x648,1,0x64a,2,0x644,0x627,1,
0x22,1,0x27,1,0x2f,1,0x5e,1,0x7c,1,0x7e,1,0x2985,1,0x2986,1,
0x30fb,1,0x30a1,1,0x30a3,1,0x30a5,1,0x30a7,1,0x30a9,1,0x30e3,1,0x30e5,1,
0x30e7,1,0x30c3,1,0x30fc,1,0x30f3,0x3164,1,0x41,0x1160,0x3131,1,0x41,0x1100,0x3132,
1,0x41,0x1101,0x3134,1,0x41,0x1102,0x3137,1,0x41,0x1103,0x3138,1,0x41,0x1104,0x3139,
1,0x41,0x1105,0x3140,1,0x41,0x111a,0x3141,1,0x41,0x1106,0x3142,1,0x41,0x1107,0x3143,
1,0x41,0x1108,0x3144,1,0x41,0x1121,0x3145,1,0x41,0x1109,0x3146,1,0x41,0x110a,0x3147,
1,0x41,0x110b,0x3148,1,0x41,0x110c,0x3149,1,0x41,0x110d,0x314a,1,0x41,0x110e,0x314b,
1,0x41,0x110f,0x314c,1,0x41,0x1110,0x314d,1,0x41,0x1111,0x314e,1,0x41,0x1112,1,
0xa2,1,0xa3,1,0xac,0xaf,0xe642,0x20,0x304,1,0xa6,1,0xa5,1,0x20a9,1,
0x2502,1,0x2190,1,0x2191,1,0x2192,1,0x2193,1,0x25a0,1,0x25cb,0xd804,0xd834,0xdd57,
0xd834,0xdd65,0xd804,0xd834,0xdd58,0xd834,0xdd65,0xd834,0xdd5f,0xd834,0xdd6e,4,0xd846,0xd834,0xdd58,0xd834,
0xdd65,0xd834,0xdd6e,0xd834,0xdd5f,0xd834,0xdd6f,4,0xd846,0xd834,0xdd58,0xd834,0xdd65,0xd834,0xdd6f,0xd834,
0xdd5f,0xd834,0xdd70,4,0xd846,0xd834,0xdd58,0xd834,0xdd65,0xd834,0xdd70,0xd834,0xdd5f,0xd834,0xdd71,4,
0xd846,0xd834,0xdd58,0xd834,0xdd65,0xd834,0xdd71,0xd834,0xdd5f,0xd834,0xdd72,4,0xd846,0xd834,0xdd58,0xd834,
0xdd65,0xd834,0xdd72,0xd804,0xd834,0xddb9,0xd834,0xdd65,0xd804,0xd834,0xddba,0xd834,0xdd65,0xd834,0xddbb,0xd834,
0xdd6e,4,0xd846,0xd834,0xddb9,0xd834,0xdd65,0xd834,0xdd6e,0xd834,0xddbc,0xd834,0xdd6e,4,0xd846,0xd834,
0xddba,0xd834,0xdd65,0xd834,0xdd6e,0xd834,0xddbb,0xd834,0xdd6f,4,0xd846,0xd834,0xddb9,0xd834,0xdd65,0xd834,
0xdd6f,0xd834,0xddbc,0xd834,0xdd6f,4,0xd846,0xd834,0xddba,0xd834,0xdd65,0xd834,0xdd6f,1,0x131,1,
0x237,1,0x391,1,0x392,1,0x394,1,0x395,1,0x396,1,0x397,1,0x399,1,
0x39a,1,0x39b,1,0x39c,1,0x39d,1,0x39e,1,0x39f,1,0x3a1,0x3f4,1,0x41,
0x398,1,0x3a4,1,0x3a5,1,0x3a6,1,0x3a7,1,0x3a8,1,0x2207,1,0x3b1,1,
0x3b5,1,0x3b6,1,0x3b7,1,0x3ba,1,0x3bb,1,0x3bd,1,0x3be,1,0x3bf,1,
0x3c2,1,0x3c3,1,0x3c4,1,0x3c5,1,0x3c8,1,0x3c9,1,0x2202,0x3f5,1,0x41,
0x3b5,0x3d1,1,0x41,0x3b8,0x3f0,1,0x41,0x3ba,0x3d5,1,0x41,0x3c6,0x3f1,1,0x41,
0x3c1,0x3d6,1,0x41,0x3c0,1,0x3dc,1,0x3dd,1,0x66e,1,0x6a1,1,0x66f,2,
0x30,0x2e,2,0x30,0x2c,2,0x31,0x2c,2,0x32,0x2c,2,0x33,0x2c,2,0x34,
0x2c,2,0x35,0x2c,2,0x36,0x2c,2,0x37,0x2c,2,0x38,0x2c,2,0x39,0x2c,
3,0x28,0x41,0x29,3,0x28,0x42,0x29,3,0x28,0x43,0x29,3,0x28,0x44,0x29,
3,0x28,0x45,0x29,3,0x28,0x46,0x29,3,0x28,0x47,0x29,3,0x28,0x48,0x29,
3,0x28,0x49,0x29,3,0x28,0x4a,0x29,3,0x28,0x4b,0x29,3,0x28,0x4c,0x29,
3,0x28,0x4d,0x29,3,0x28,0x4e,0x29,3,0x28,0x4f,0x29,3,0x28,0x50,0x29,
3,0x28,0x51,0x29,3,0x28,0x52,0x29,3,0x28,0x53,0x29,3,0x28,0x54,0x29,
3,0x28,0x55,0x29,3,0x28,0x56,0x29,3,0x28,0x57,0x29,3,0x28,0x58,0x29,
3,0x28,0x59,0x29,3,0x28,0x5a,0x29,3,0x3014,0x53,0x3015,2,0x43,0x44,2,
0x57,0x5a,2,0x48,0x56,2,0x53,0x44,2,0x53,0x53,3,0x50,0x50,0x56,2,
0x57,0x43,2,0x4d,0x43,2,0x4d,0x44,2,0x44,0x4a,2,0x307b,0x304b,2,0x30b3,
0x30b3,1,0x5b57,1,0x53cc,1,0x591a,1,0x89e3,1,0x4ea4,1,0x6620,1,0x7121,1,
0x524d,1,0x5f8c,1,0x518d,1,0x65b0,1,0x521d,1,0x7d42,1,0x8ca9,1,0x58f0,1,
0x5439,1,0x6f14,1,0x6295,1,0x6355,1,0x904a,1,0x6307,1,0x6253,1,0x7981,1,
0x7a7a,1,0x5408,1,0x6e80,1,0x7533,1,0x5272,1,0x55b6,1,0x914d,3,0x3014,0x672c,
0x3015,3,0x3014,0x4e09,0x3015,3,0x3014,0x4e8c,0x3015,3,0x3014,0x5b89,0x3015,3,0x3014,0x70b9,
0x3015,3,0x3014,0x6253,0x3015,3,0x3014,0x76d7,0x3015,3,0x3014,0x52dd,0x3015,3,0x3014,0x6557,
0x3015,1,0x5f97,1,0x53ef,1,0x4e3d,1,0x4e38,1,0x4e41,2,0xd840,0xdd22,1,0x4f60,
1,0x4fbb,1,0x5002,1,0x507a,1,0x5099,1,0x50cf,1,0x349e,2,0xd841,0xde3a,1,
0x5154,1,0x5164,1,0x5177,2,0xd841,0xdd1c,1,0x34b9,1,0x5167,2,0xd841,0xdd4b,1,
0x5197,1,0x51a4,1,0x4ecc,1,0x51ac,2,0xd864,0xdddf,1,0x5203,1,0x34df,1,0x523b,
1,0x5246,1,0x5277,1,0x3515,1,0x5305,1,0x5306,1,0x5349,1,0x535a,1,0x5373,
1,0x537d,1,0x537f,2,0xd842,0xde2c,1,0x7070,1,0x53ca,1,0x53df,2,0xd842,0xdf63,
1,0x53eb,1,0x53f1,1,0x5406,1,0x549e,1,0x5438,1,0x5448,1,0x5468,1,0x54a2,
1,0x54f6,1,0x5510,1,0x5553,1,0x5563,1,0x5584,1,0x55ab,1,0x55b3,1,0x55c2,
1,0x5716,1,0x5717,1,0x5651,1,0x5674,1,0x58ee,1,0x57ce,1,0x57f4,1,0x580d,
1,0x578b,1,0x5832,1,0x5831,1,0x58ac,2,0xd845,0xdce4,1,0x58f2,1,0x58f7,1,
0x5906,1,0x5922,1,0x5962,2,0xd845,0xdea8,2,0xd845,0xdeea,1,0x59ec,1,0x5a1b,1,
0x5a27,1,0x59d8,1,0x5a66,1,0x36ee,1,0x36fc,1,0x5b08,1,0x5b3e,2,0xd846,0xddc8,
1,0x5bc3,1,0x5bd8,1,0x5bf3,2,0xd846,0xdf18,1,0x5bff,1,0x5c06,1,0x5f53,1,
0x3781,1,0x5c60,1,0x5cc0,1,0x5c8d,2,0xd847,0xdde4,1,0x5d43,2,0xd847,0xdde6,1,
0x5d6e,1,0x5d6b,1,0x5d7c,1,0x5de1,1,0x5de2,1,0x382f,1,0x5dfd,1,0x5e28,1,
0x5e3d,1,0x5e69,1,0x3862,2,0xd848,0xdd83,1,0x387c,1,0x5eb0,1,0x5eb3,1,0x5eb6,
2,0xd868,0xdf92,2,0xd848,0xdf31,1,0x8201,1,0x5f22,1,0x38c7,2,0xd84c,0xdeb8,2,
0xd858,0xddda,1,0x5f62,1,0x5f6b,1,0x38e3,1,0x5f9a,1,0x5fcd,1,0x5fd7,1,0x5ff9,
1,0x6081,1,0x393a,1,0x391c,2,0xd849,0xded4,1,0x60c7,1,0x6148,1,0x614c,1,
0x617a,1,0x61b2,1,0x61a4,1,0x61af,1,0x61de,1,0x6210,1,0x621b,1,0x625d,1,
0x62b1,1,0x62d4,1,0x6350,2,0xd84a,0xdf0c,1,0x633d,1,0x62fc,1,0x6368,1,0x6383,
1,0x63e4,2,0xd84a,0xdff1,1,0x6422,1,0x63c5,1,0x63a9,1,0x3a2e,1,0x6469,1,
0x647e,1,0x649d,1,0x6477,1,0x3a6c,1,0x656c,2,0xd84c,0xdc0a,1,0x65e3,1,0x66f8,
1,0x6649,1,0x3b19,1,0x3b08,1,0x3ae4,1,0x5192,1,0x5195,1,0x6700,1,0x669c,
1,0x80ad,1,0x43d9,1,0x6721,1,0x675e,1,0x6753,2,0xd84c,0xdfc3,1,0x3b49,1,
0x67fa,1,0x6785,1,0x6852,2,0xd84d,0xdc6d,1,0x688e,1,0x681f,1,0x6914,1,0x6942,
1,0x69a3,1,0x69ea,1,0x6aa8,2,0xd84d,0xdea3,1,0x6adb,1,0x3c18,1,0x6b21,2,
0xd84e,0xdca7,1,0x6b54,1,0x3c4e,1,0x6b72,1,0x6b9f,1,0x6bbb,2,0xd84e,0xde8d,2,
0xd847,0xdd0b,2,0xd84e,0xdefa,1,0x6c4e,2,0xd84f,0xdcbc,1,0x6cbf,1,0x6ccd,1,0x6c67,
1,0x6d16,1,0x6d3e,1,0x6d69,1,0x6d78,1,0x6d85,2,0xd84f,0xdd1e,1,0x6d34,1,
0x6e2f,1,0x6e6e,1,0x3d33,1,0x6ec7,2,0xd84f,0xded1,1,0x6df9,1,0x6f6e,2,0xd84f,
0xdf5e,2,0xd84f,0xdf8e,1,0x6fc6,1,0x7039,1,0x701b,1,0x3d96,1,0x704a,1,0x707d,
1,0x7077,1,0x70ad,2,0xd841,0xdd25,1,0x7145,2,0xd850,0xde63,1,0x719c,2,0xd850,
0xdfab,1,0x7228,1,0x7250,2,0xd851,0xde08,1,0x7280,1,0x7295,2,0xd851,0xdf35,2,
0xd852,0xdc14,1,0x737a,1,0x738b,1,0x3eac,1,0x73a5,1,0x3eb8,1,0x7447,1,0x745c,
1,0x7485,1,0x74ca,1,0x3f1b,1,0x7524,2,0xd853,0xdc36,1,0x753e,2,0xd853,0xdc92,
2,0xd848,0xdd9f,1,0x7610,2,0xd853,0xdfa1,2,0xd853,0xdfb8,2,0xd854,0xdc44,1,0x3ffc,
1,0x4008,2,0xd854,0xdcf3,2,0xd854,0xdcf2,2,0xd854,0xdd19,2,0xd854,0xdd33,1,0x771e,
1,0x771f,1,0x778b,1,0x4046,1,0x4096,2,0xd855,0xdc1d,1,0x784e,1,0x40e3,2,
0xd855,0xde26,2,0xd855,0xde9a,2,0xd855,0xdec5,1,0x79eb,1,0x412f,1,0x7a4a,1,0x7a4f,
2,0xd856,0xdd7c,2,0xd856,0xdea7,1,0x7aee,1,0x4202,2,0xd856,0xdfab,1,0x7bc6,1,
0x7bc9,1,0x4227,2,0xd857,0xdc80,1,0x7cd2,1,0x42a0,1,0x7ce8,1,0x7ce3,1,0x7d00,
2,0xd857,0xdf86,1,0x7d63,1,0x4301,1,0x7dc7,1,0x7e02,1,0x7e45,1,0x4334,2,
0xd858,0xde28,2,0xd858,0xde47,1,0x4359,2,0xd858,0xded9,1,0x7f7a,2,0xd858,0xdf3e,1,
0x7f95,1,0x7ffa,2,0xd859,0xdcda,2,0xd859,0xdd23,1,0x8060,2,0xd859,0xdda8,1,0x8070,
2,0xd84c,0xdf5f,1,0x43d5,1,0x80b2,1,0x8103,1,0x440b,1,0x813e,1,0x5ab5,2,
0xd859,0xdfa7,2,0xd859,0xdfb5,2,0xd84c,0xdf93,2,0xd84c,0xdf9c,1,0x8204,1,0x8f9e,1,
0x446b,1,0x8291,1,0x828b,1,0x829d,1,0x52b3,1,0x82b1,1,0x82b3,1,0x82bd,1,
0x82e6,2,0xd85a,0xdf3c,1,0x831d,1,0x8363,1,0x83ad,1,0x8323,1,0x83bd,1,0x83e7,
1,0x8353,1,0x83ca,1,0x83cc,1,0x83dc,2,0xd85b,0xdc36,2,0xd85b,0xdd6b,2,0xd85b,
0xdcd5,1,0x452b,1,0x84f1,1,0x84f3,1,0x8516,2,0xd85c,0xdfca,1,0x8564,2,0xd85b,
0xdf2c,1,0x455d,1,0x4561,2,0xd85b,0xdfb1,2,0xd85c,0xdcd2,1,0x456b,1,0x8650,1,
0x8667,1,0x8669,1,0x86a9,1,0x8688,1,0x870e,1,0x86e2,1,0x8728,1,0x876b,1,
0x8786,1,0x45d7,1,0x87e1,1,0x8801,1,0x45f9,1,0x8860,2,0xd85d,0xde67,1,0x88d7,
1,0x88de,1,0x4635,1,0x88fa,1,0x34bb,2,0xd85e,0xdcae,2,0xd85e,0xdd66,1,0x46be,
1,0x46c7,1,0x8aa0,2,0xd85f,0xdca8,1,0x8cab,1,0x8cc1,1,0x8d1b,1,0x8d77,2,
0xd85f,0xdf2f,2,0xd842,0xdc04,1,0x8dcb,1,0x8dbc,1,0x8df0,2,0xd842,0xdcde,1,0x8ed4,
2,0xd861,0xddd2,2,0xd861,0xdded,1,0x9094,1,0x90f1,1,0x9111,2,0xd861,0xdf2e,1,
0x911b,1,0x9238,1,0x92d7,1,0x92d8,1,0x927c,1,0x93f9,1,0x9415,2,0xd862,0xdffa,
1,0x958b,1,0x4995,1,0x95b7,2,0xd863,0xdd77,1,0x49e6,1,0x96c3,1,0x5db2,1,
0x9723,2,0xd864,0xdd45,2,0xd864,0xde1a,1,0x4a6e,1,0x4a76,1,0x97e0,2,0xd865,0xdc0a,
1,0x4ab2,2,0xd865,0xdc96,1,0x9829,2,0xd865,0xddb6,1,0x98e2,1,0x4b33,1,0x9929,
1,0x99a7,1,0x99c2,1,0x99fe,1,0x4bce,2,0xd866,0xdf30,1,0x9c40,1,0x9cfd,1,
0x4cce,1,0x4ced,1,0x9d67,2,0xd868,0xdcce,1,0x4cf8,2,0xd868,0xdd05,2,0xd868,0xde0e,
2,0xd868,0xde91,1,0x4d56,1,0x9efe,1,0x9f05,1,0x9f0f,1,0x9f16,2,0xd869,0xde00,
0x44,0x17d,2,0xe643,0x44,0x5a,0x30c,0x44,0x17e,2,0xe643,0x44,0x7a,0x30c,0x64,0x17e,
2,0xe643,0x64,0x7a,0x30c,0x3d2,0x301,2,0xe642,0x3a5,0x301,0x3d2,0x308,2,0xe642,0x3a5,
0x308,0x17f,0x307,2,0xe642,0x73,0x307,0x3ac,0xe642,0x3b1,0x301,0x3ad,0xe642,0x3b5,0x301,0x3ae,
0xe642,0x3b7,0x301,0x3af,0xe642,0x3b9,0x301,0x3cc,0xe642,0x3bf,0x301,0x3cd,0xe642,0x3c5,0x301,0x3ce,
0xe642,0x3c9,0x301,0x386,0xe642,0x391,0x301,0x388,0xe642,0x395,0x301,0x389,0xe642,0x397,0x301,0x390,
1,0xe643,0x3b9,0x308,0x301,0x38a,0xe642,0x399,0x301,0x3b0,1,0xe643,0x3c5,0x308,0x301,0x38e,
0xe642,0x3a5,0x301,0x38c,0xe642,0x39f,0x301,0x38f,0xe642,0x3a9,0x301,0xc5,0xe642,0x41,0x30a,4,
0x28,0x1100,0x1161,0x29,4,0x28,0x1102,0x1161,0x29,4,0x28,0x1103,0x1161,0x29,4,0x28,
0x1105,0x1161,0x29,4,0x28,0x1106,0x1161,0x29,4,0x28,0x1107,0x1161,0x29,4,0x28,0x1109,
0x1161,0x29,4,0x28,0x110b,0x1161,0x29,4,0x28,0x110c,0x1161,0x29,4,0x28,0x110e,0x1161,
0x29,4,0x28,0x110f,0x1161,0x29,4,0x28,0x1110,0x1161,0x29,4,0x28,0x1111,0x1161,0x29,
4,0x28,0x1112,0x1161,0x29,4,0x28,0x110c,0x116e,0x29,7,0x28,0x110b,0x1169,0x110c,0x1165,
0x11ab,0x29,6,0x28,0x110b,0x1169,0x1112,0x116e,0x29,2,0x1100,0x1161,2,0x1102,0x1161,2,
0x1103,0x1161,2,0x1105,0x1161,2,0x1106,0x1161,2,0x1107,0x1161,2,0x1109,0x1161,2,0x110b,
0x1161,2,0x110c,0x1161,2,0x110e,0x1161,2,0x110f,0x1161,2,0x1110,0x1161,2,0x1111,0x1161,
2,0x1112,0x1161,5,0x110e,0x1161,0x11b7,0x1100,0x1169,4,0x110c,0x116e,0x110b,0x1174,2,0x110b,
0x116e,0x30a2,0x30d1,0x30fc,0x30c8,4,0x45,0x30a2,0x30cf,0x309a,0x30fc,0x30c8,0x30a2,0x30f3,0x30da,0x30a2,
4,0x45,0x30a2,0x30f3,0x30d8,0x309a,0x30a2,0x30a4,0x30cb,0x30f3,0x30b0,4,0x845,0x30a4,0x30cb,0x30f3,
0x30af,0x3099,0x30a8,0x30b9,0x30af,0x30fc,0x30c9,5,0x846,0x30a8,0x30b9,0x30af,0x30fc,0x30c8,0x3099,0x30ac,
0x44,0x30ab,0x3099,0x30ed,0x30f3,0x30ac,0x44,0x30ab,0x3099,0x30f3,0x30de,0x30ae,0x30ac,2,0x844,0x30ad,
0x3099,0x30ab,0x3099,0x30ae,0x44,0x30ad,0x3099,0x30cb,0x30fc,0x30ae,0x30eb,0x30c0,0x30fc,4,0x46,0x30ad,
0x3099,0x30eb,0x30bf,0x3099,0x30fc,0x30ad,0x30ed,0x30b0,0x30e9,0x30e0,5,0x46,0x30ad,0x30ed,0x30af,0x3099,
0x30e9,0x30e0,0x30b0,0x44,0x30af,0x3099,0x30e9,0x30e0,0x30b0,0x46,0x30af,0x3099,0x30e9,0x30e0,0x30c8,0x30f3,
0x30af,0x30eb,0x30bc,0x30a4,0x30ed,5,0x46,0x30af,0x30eb,0x30bb,0x3099,0x30a4,0x30ed,0x30b3,0x30fc,0x30dd,
3,0x844,0x30b3,0x30fc,0x30db,0x309a,0x30b7,0x30ea,0x30f3,0x30b0,4,0x845,0x30b7,0x30ea,0x30f3,0x30af,
0x3099,0x30c0,0x44,0x30bf,0x3099,0x30fc,0x30b9,0x30c7,0x43,0x30c6,0x3099,0x30b7,0x30c9,0x43,0x30c8,0x3099,
0x30eb,0x30d1,0x46,0x30cf,0x309a,0x30fc,0x30bb,0x30f3,0x30c8,0x30d1,0x44,0x30cf,0x309a,0x30fc,0x30c4,0x30d0,
0x45,0x30cf,0x3099,0x30fc,0x30ec,0x30eb,0x30d4,0x46,0x30d2,0x309a,0x30a2,0x30b9,0x30c8,0x30eb,0x30d4,0x44,
0x30d2,0x309a,0x30af,0x30eb,0x30d4,0x43,0x30d2,0x309a,0x30b3,0x30d3,0x43,0x30d2,0x3099,0x30eb,0x30d5,0x30a1,
0x30e9,0x30c3,0x30c9,5,0x846,0x30d5,0x30a1,0x30e9,0x30c3,0x30c8,0x3099,0x30d6,0x46,0x30d5,0x3099,0x30c3,
0x30b7,0x30a7,0x30eb,0x30da,0x43,0x30d8,0x309a,0x30bd,0x30da,0x44,0x30d8,0x309a,0x30cb,0x30d2,0x30da,0x44,
0x30d8,0x309a,0x30f3,0x30b9,0x30da,0x30fc,0x30b8,3,0x845,0x30d8,0x309a,0x30fc,0x30b7,0x3099,0x30d9,0x44,
0x30d8,0x3099,0x30fc,0x30bf,0x30dd,0x45,0x30db,0x309a,0x30a4,0x30f3,0x30c8,0x30dc,0x44,0x30db,0x3099,0x30eb,
0x30c8,0x30dd,0x30f3,0x30c9,3,0x845,0x30db,0x309a,0x30f3,0x30c8,0x3099,0x30df,0x30ea,0x30d0,0x30fc,0x30eb,
5,0x46,0x30df,0x30ea,0x30cf,0x3099,0x30fc,0x30eb,0x30e1,0x30ac,2,0x843,0x30e1,0x30ab,0x3099,0x30e1,
0x30ac,0x30c8,0x30f3,4,0x45,0x30e1,0x30ab,0x3099,0x30c8,0x30f3,0x30e4,0x30fc,0x30c9,3,0x844,0x30e4,
0x30fc,0x30c8,0x3099,0x30eb,0x30d4,0x30fc,3,0x44,0x30eb,0x30d2,0x309a,0x30fc,0x30eb,0x30fc,0x30d6,0x30eb,
4,0x45,0x30eb,0x30fc,0x30d5,0x3099,0x30eb,0x30ec,0x30f3,0x30c8,0x30b2,0x30f3,5,0x46,0x30ec,0x30f3,
0x30c8,0x30b1,0x3099,0x30f3,0x6c0,0xe642,0x6d5,0x654,0x6d3,0xe642,0x6d2,0x654,0x626,0x43,0x64a,0x654,
0x627,0x626,0x43,0x64a,0x654,0x6d5,0x626,0x43,0x64a,0x654,0x648,0x626,0x43,0x64a,0x654,0x6c7,
0x626,0x43,0x64a,0x654,0x6c6,0x626,0x43,0x64a,0x654,0x6c8,0x626,0x43,0x64a,0x654,0x6d0,0x626,
0x43,0x64a,0x654,0x649,0x626,0x43,0x64a,0x654,0x62c,0x626,0x43,0x64a,0x654,0x62d,0x626,0x43,
0x64a,0x654,0x645,0x626,0x43,0x64a,0x654,0x64a,0x626,0x43,0x64a,0x654,0x631,0x626,0x43,0x64a,
0x654,0x632,0x626,0x43,0x64a,0x654,0x646,0x626,0x43,0x64a,0x654,0x62e,0x626,0x43,0x64a,0x654,
0x647,0x622,0xe642,0x627,0x653,0x623,0xe642,0x627,0x654,0x624,0xe642,0x648,0x654,0x625,0xdc42,0x627,
0x655,0x626,0xe642,0x64a,0x654,0x644,0x622,2,0xe643,0x644,0x627,0x653,0x644,0x623,2,0xe643,
0x644,0x627,0x654,0x644,0x625,2,0xdc43,0x644,0x627,0x655,0x30c7,0x842,0x30c6,0x3099,0xe6e6,0xe681,
0x300,0xe6e6,0xe681,0x301,0xe6e6,0xe681,0x313,0xe6e6,0xe682,0x308,0x301,0x8100,0x8282,0xf71,0xf72,0x8100,
0x8482,0xf71,0xf74,0x8100,0x8282,0xf71,0xf80,1,0x11aa,1,0x11ac,1,0x11ad,1,0x11b0,1,
0x11b1,1,0x11b2,1,0x11b3,1,0x11b4,1,0x11b5,1,0x1161,1,0x1162,1,0x1163,1,
0x1164,1,0x1165,1,0x1166,1,0x1167,1,0x1168,1,0x1169,1,0x116a,1,0x116b,1,
0x116c,1,0x116d,1,0x116e,1,0x116f,1,0x1170,1,0x1171,1,0x1172,1,0x1173,1,
0x1174,1,0x1175,0x800,0x881,0x3099,0x800,0x881,0x309a,0x3133,1,0x41,0x11aa,0x3135,1,0x41,
0x11ac,0x3136,1,0x41,0x11ad,0x313a,1,0x41,0x11b0,0x313b,1,0x41,0x11b1,0x313c,1,0x41,
0x11b2,0x313d,1,0x41,0x11b3,0x313e,1,0x41,0x11b4,0x313f,1,0x41,0x11b5,0x314f,1,0x41,
0x1161,0x3150,1,0x41,0x1162,0x3151,1,0x41,0x1163,0x3152,1,0x41,0x1164,0x3153,1,0x41,
0x1165,0x3154,1,0x41,0x1166,0x3155,1,0x41,0x1167,0x3156,1,0x41,0x1168,0x3157,1,0x41,
0x1169,0x3158,1,0x41,0x116a,0x3159,1,0x41,0x116b,0x315a,1,0x41,0x116c,0x315b,1,0x41,
0x116d,0x315c,1,0x41,0x116e,0x315d,1,0x41,0x116f,0x315e,1,0x41,0x1170,0x315f,1,0x41,
0x1171,0x3160,1,0x41,0x1172,0x3161,1,0x41,0x1173,0x3162,1,0x41,0x1174,0x3163,1,0x41,
0x1175,0
};

static const uint8_t norm2_nfkc_data_smallFCD[256]={
0xe0,0xef,0x43,0x7f,0xdf,0x70,0xcf,0x87,0xc7,0xe6,0x66,0x46,0x64,0x46,0x66,0x5b,
0x12,0,0,4,0,0,0,0x43,0x20,2,0x29,0xae,0xc2,0xc0,0xff,0xff,
0xc3,0x72,0xbf,0,0,0,0,0,0,0,0x40,0,0x80,0x88,0,0,
0xfe,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0x98,0,0xc1,0x66,0xe0,0x80,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0x27,0xdc,2,0x9e,0x90
};

}}}

#endif
