// Copyright (C) 2020 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Warning! This file is autogenerated.
#ifndef BOOST_TEXT_DATA_UND_HPP
#define BOOST_TEXT_DATA_UND_HPP

#include <boost/text/string_view.hpp>


namespace boost { namespace text { namespace data { namespace und {

// Note: The ICU version of emoji tailoring starts with:
// &[before 1]\XFDD1€
// but since the encoding we use is always UTF-8, the U+FDD1 produces a
// replacement character (not what we want!).  Using the first CURRENCY entry in
// the CE table accomplishes the same thing.
inline string_view emoji_collation_tailoring()
{
    return string_view((char const *)
u8"  \n"
u8"& [last primary ignorable]<<*🏻🏼🏽🏾🏿🦰🦱🦳🦲\n"
u8"& [before 1]¤\n"
u8"  <*😀😁😂🤣😃😄😅😆😉😊😋😎😍😘🥰😗😙😚☺🙂🤗🤩\n"
u8"  <*🤔🤨😐😑😶🙄😏😣😥😮🤐😯😪😫😴😌😛😜😝🤤😒😓😔😕🙃🤑😲\n"
u8"  <*☹🙁😖😞😟😤😢😭😦😧😨😩🤯😬😰😱🥵🥶😳🤪😵😡😠🤬\n"
u8"  <*😷🤒🤕🤢🤮🤧\n"
u8"  <*😇🤠🥳🥴🥺🤥🤫🤭🧐🤓\n"
u8"  <*😈👿🤡👹👺💀☠👻👽👾🤖💩\n"
u8"  <*😺😸😹😻😼😽🙀😿😾\n"
u8"  <*🙈🙉🙊\n"
u8"  <*👶🧒👦👧🧑\n"
u8"  <<👱\n"
u8"  <*👨\n"
u8"  < 👱‍♂ << 👱🏻‍♂ << 👱🏼‍♂ << 👱🏽‍♂ << 👱🏾‍♂ << 👱🏿‍♂\n"
u8"  <<🧔\n"
u8"  <*👩\n"
u8"  < 👱‍♀ << 👱🏻‍♀ << 👱🏼‍♀ << 👱🏽‍♀ << 👱🏾‍♀ << 👱🏿‍♀\n"
u8"  <*🧓👴👵\n"
u8"  < 🧑‍⚕ << 🧑🏻‍⚕ << 🧑🏼‍⚕ << 🧑🏽‍⚕ << 🧑🏾‍⚕ << 🧑🏿‍⚕\n"
u8"  < 👨‍⚕ << 👨🏻‍⚕ << 👨🏼‍⚕ << 👨🏽‍⚕ << 👨🏾‍⚕ << 👨🏿‍⚕\n"
u8"  < 👩‍⚕ << 👩🏻‍⚕ << 👩🏼‍⚕ << 👩🏽‍⚕ << 👩🏾‍⚕ << 👩🏿‍⚕\n"
u8"  < 🧑‍🎓 << 🧑🏻‍🎓 << 🧑🏼‍🎓 << 🧑🏽‍🎓 << 🧑🏾‍🎓 << 🧑🏿‍🎓\n"
u8"  < 👨‍🎓 << 👨🏻‍🎓 << 👨🏼‍🎓 << 👨🏽‍🎓 << 👨🏾‍🎓 << 👨🏿‍🎓\n"
u8"  < 👩‍🎓 << 👩🏻‍🎓 << 👩🏼‍🎓 << 👩🏽‍🎓 << 👩🏾‍🎓 << 👩🏿‍🎓\n"
u8"  < 🧑‍🏫 << 🧑🏻‍🏫 << 🧑🏼‍🏫 << 🧑🏽‍🏫 << 🧑🏾‍🏫 << 🧑🏿‍🏫\n"
u8"  < 👨‍🏫 << 👨🏻‍🏫 << 👨🏼‍🏫 << 👨🏽‍🏫 << 👨🏾‍🏫 << 👨🏿‍🏫\n"
u8"  < 👩‍🏫 << 👩🏻‍🏫 << 👩🏼‍🏫 << 👩🏽‍🏫 << 👩🏾‍🏫 << 👩🏿‍🏫\n"
u8"  < 🧑‍⚖ << 🧑🏻‍⚖ << 🧑🏼‍⚖ << 🧑🏽‍⚖ << 🧑🏾‍⚖ << 🧑🏿‍⚖\n"
u8"  < 👨‍⚖ << 👨🏻‍⚖ << 👨🏼‍⚖ << 👨🏽‍⚖ << 👨🏾‍⚖ << 👨🏿‍⚖\n"
u8"  < 👩‍⚖ << 👩🏻‍⚖ << 👩🏼‍⚖ << 👩🏽‍⚖ << 👩🏾‍⚖ << 👩🏿‍⚖\n"
u8"  < 🧑‍🌾 << 🧑🏻‍🌾 << 🧑🏼‍🌾 << 🧑🏽‍🌾 << 🧑🏾‍🌾 << 🧑🏿‍🌾\n"
u8"  < 👨‍🌾 << 👨🏻‍🌾 << 👨🏼‍🌾 << 👨🏽‍🌾 << 👨🏾‍🌾 << 👨🏿‍🌾\n"
u8"  < 👩‍🌾 << 👩🏻‍🌾 << 👩🏼‍🌾 << 👩🏽‍🌾 << 👩🏾‍🌾 << 👩🏿‍🌾\n"
u8"  < 🧑‍🍳 << 🧑🏻‍🍳 << 🧑🏼‍🍳 << 🧑🏽‍🍳 << 🧑🏾‍🍳 << 🧑🏿‍🍳\n"
u8"  < 👨‍🍳 << 👨🏻‍🍳 << 👨🏼‍🍳 << 👨🏽‍🍳 << 👨🏾‍🍳 << 👨🏿‍🍳\n"
u8"  < 👩‍🍳 << 👩🏻‍🍳 << 👩🏼‍🍳 << 👩🏽‍🍳 << 👩🏾‍🍳 << 👩🏿‍🍳\n"
u8"  < 🧑‍🔧 << 🧑🏻‍🔧 << 🧑🏼‍🔧 << 🧑🏽‍🔧 << 🧑🏾‍🔧 << 🧑🏿‍🔧\n"
u8"  < 👨‍🔧 << 👨🏻‍🔧 << 👨🏼‍🔧 << 👨🏽‍🔧 << 👨🏾‍🔧 << 👨🏿‍🔧\n"
u8"  < 👩‍🔧 << 👩🏻‍🔧 << 👩🏼‍🔧 << 👩🏽‍🔧 << 👩🏾‍🔧 << 👩🏿‍🔧\n"
u8"  < 🧑‍🏭 << 🧑🏻‍🏭 << 🧑🏼‍🏭 << 🧑🏽‍🏭 << 🧑🏾‍🏭 << 🧑🏿‍🏭\n"
u8"  < 👨‍🏭 << 👨🏻‍🏭 << 👨🏼‍🏭 << 👨🏽‍🏭 << 👨🏾‍🏭 << 👨🏿‍🏭\n"
u8"  < 👩‍🏭 << 👩🏻‍🏭 << 👩🏼‍🏭 << 👩🏽‍🏭 << 👩🏾‍🏭 << 👩🏿‍🏭\n"
u8"  < 🧑‍💼 << 🧑🏻‍💼 << 🧑🏼‍💼 << 🧑🏽‍💼 << 🧑🏾‍💼 << 🧑🏿‍💼\n"
u8"  < 👨‍💼 << 👨🏻‍💼 << 👨🏼‍💼 << 👨🏽‍💼 << 👨🏾‍💼 << 👨🏿‍💼\n"
u8"  < 👩‍💼 << 👩🏻‍💼 << 👩🏼‍💼 << 👩🏽‍💼 << 👩🏾‍💼 << 👩🏿‍💼\n"
u8"  < 🧑‍🔬 << 🧑🏻‍🔬 << 🧑🏼‍🔬 << 🧑🏽‍🔬 << 🧑🏾‍🔬 << 🧑🏿‍🔬\n"
u8"  < 👨‍🔬 << 👨🏻‍🔬 << 👨🏼‍🔬 << 👨🏽‍🔬 << 👨🏾‍🔬 << 👨🏿‍🔬\n"
u8"  < 👩‍🔬 << 👩🏻‍🔬 << 👩🏼‍🔬 << 👩🏽‍🔬 << 👩🏾‍🔬 << 👩🏿‍🔬\n"
u8"  < 🧑‍💻 << 🧑🏻‍💻 << 🧑🏼‍💻 << 🧑🏽‍💻 << 🧑🏾‍💻 << 🧑🏿‍💻\n"
u8"  < 👨‍💻 << 👨🏻‍💻 << 👨🏼‍💻 << 👨🏽‍💻 << 👨🏾‍💻 << 👨🏿‍💻\n"
u8"  < 👩‍💻 << 👩🏻‍💻 << 👩🏼‍💻 << 👩🏽‍💻 << 👩🏾‍💻 << 👩🏿‍💻\n"
u8"  < 🧑‍🎤 << 🧑🏻‍🎤 << 🧑🏼‍🎤 << 🧑🏽‍🎤 << 🧑🏾‍🎤 << 🧑🏿‍🎤\n"
u8"  < 👨‍🎤 << 👨🏻‍🎤 << 👨🏼‍🎤 << 👨🏽‍🎤 << 👨🏾‍🎤 << 👨🏿‍🎤\n"
u8"  < 👩‍🎤 << 👩🏻‍🎤 << 👩🏼‍🎤 << 👩🏽‍🎤 << 👩🏾‍🎤 << 👩🏿‍🎤\n"
u8"  < 🧑‍🎨 << 🧑🏻‍🎨 << 🧑🏼‍🎨 << 🧑🏽‍🎨 << 🧑🏾‍🎨 << 🧑🏿‍🎨\n"
u8"  < 👨‍🎨 << 👨🏻‍🎨 << 👨🏼‍🎨 << 👨🏽‍🎨 << 👨🏾‍🎨 << 👨🏿‍🎨\n"
u8"  < 👩‍🎨 << 👩🏻‍🎨 << 👩🏼‍🎨 << 👩🏽‍🎨 << 👩🏾‍🎨 << 👩🏿‍🎨\n"
u8"  < 🧑‍✈ << 🧑🏻‍✈ << 🧑🏼‍✈ << 🧑🏽‍✈ << 🧑🏾‍✈ << 🧑🏿‍✈\n"
u8"  < 👨‍✈ << 👨🏻‍✈ << 👨🏼‍✈ << 👨🏽‍✈ << 👨🏾‍✈ << 👨🏿‍✈\n"
u8"  < 👩‍✈ << 👩🏻‍✈ << 👩🏼‍✈ << 👩🏽‍✈ << 👩🏾‍✈ << 👩🏿‍✈\n"
u8"  < 🧑‍🚀 << 🧑🏻‍🚀 << 🧑🏼‍🚀 << 🧑🏽‍🚀 << 🧑🏾‍🚀 << 🧑🏿‍🚀\n"
u8"  < 👨‍🚀 << 👨🏻‍🚀 << 👨🏼‍🚀 << 👨🏽‍🚀 << 👨🏾‍🚀 << 👨🏿‍🚀\n"
u8"  < 👩‍🚀 << 👩🏻‍🚀 << 👩🏼‍🚀 << 👩🏽‍🚀 << 👩🏾‍🚀 << 👩🏿‍🚀\n"
u8"  < 🧑‍🚒 << 🧑🏻‍🚒 << 🧑🏼‍🚒 << 🧑🏽‍🚒 << 🧑🏾‍🚒 << 🧑🏿‍🚒\n"
u8"  < 👨‍🚒 << 👨🏻‍🚒 << 👨🏼‍🚒 << 👨🏽‍🚒 << 👨🏾‍🚒 << 👨🏿‍🚒\n"
u8"  < 👩‍🚒 << 👩🏻‍🚒 << 👩🏼‍🚒 << 👩🏽‍🚒 << 👩🏾‍🚒 << 👩🏿‍🚒\n"
u8"  <*👮\n"
u8"  < 👮‍♂ << 👮🏻‍♂ << 👮🏼‍♂ << 👮🏽‍♂ << 👮🏾‍♂ << 👮🏿‍♂\n"
u8"  < 👮‍♀ << 👮🏻‍♀ << 👮🏼‍♀ << 👮🏽‍♀ << 👮🏾‍♀ << 👮🏿‍♀\n"
u8"  <*🕵\n"
u8"  < 🕵‍♂ = 🕵️‍♂ << 🕵🏻‍♂ << 🕵🏼‍♂ << 🕵🏽‍♂ << 🕵🏾‍♂ << 🕵🏿‍♂\n"
u8"  < 🕵‍♀ = 🕵️‍♀ << 🕵🏻‍♀ << 🕵🏼‍♀ << 🕵🏽‍♀ << 🕵🏾‍♀ << 🕵🏿‍♀\n"
u8"  <*💂\n"
u8"  < 💂‍♂ << 💂🏻‍♂ << 💂🏼‍♂ << 💂🏽‍♂ << 💂🏾‍♂ << 💂🏿‍♂\n"
u8"  < 💂‍♀ << 💂🏻‍♀ << 💂🏼‍♀ << 💂🏽‍♀ << 💂🏾‍♀ << 💂🏿‍♀\n"
u8"  <*👷\n"
u8"  < 👷‍♂ << 👷🏻‍♂ << 👷🏼‍♂ << 👷🏽‍♂ << 👷🏾‍♂ << 👷🏿‍♂\n"
u8"  < 👷‍♀ << 👷🏻‍♀ << 👷🏼‍♀ << 👷🏽‍♀ << 👷🏾‍♀ << 👷🏿‍♀\n"
u8"  <*🤴👸👳\n"
u8"  < 👳‍♂ << 👳🏻‍♂ << 👳🏼‍♂ << 👳🏽‍♂ << 👳🏾‍♂ << 👳🏿‍♂\n"
u8"  < 👳‍♀ << 👳🏻‍♀ << 👳🏼‍♀ << 👳🏽‍♀ << 👳🏾‍♀ << 👳🏿‍♀\n"
u8"  <*👲🧕🤵👰🤰🤱\n"
u8"  <*👼🎅🤶🦸\n"
u8"  < 🦸‍♀ << 🦸🏻‍♀ << 🦸🏼‍♀ << 🦸🏽‍♀ << 🦸🏾‍♀ << 🦸🏿‍♀\n"
u8"  < 🦸‍♂ << 🦸🏻‍♂ << 🦸🏼‍♂ << 🦸🏽‍♂ << 🦸🏾‍♂ << 🦸🏿‍♂\n"
u8"  <*🦹\n"
u8"  < 🦹‍♀ << 🦹🏻‍♀ << 🦹🏼‍♀ << 🦹🏽‍♀ << 🦹🏾‍♀ << 🦹🏿‍♀\n"
u8"  < 🦹‍♂ << 🦹🏻‍♂ << 🦹🏼‍♂ << 🦹🏽‍♂ << 🦹🏾‍♂ << 🦹🏿‍♂\n"
u8"  <*🧙\n"
u8"  < 🧙‍♀ << 🧙🏻‍♀ << 🧙🏼‍♀ << 🧙🏽‍♀ << 🧙🏾‍♀ << 🧙🏿‍♀\n"
u8"  < 🧙‍♂ << 🧙🏻‍♂ << 🧙🏼‍♂ << 🧙🏽‍♂ << 🧙🏾‍♂ << 🧙🏿‍♂\n"
u8"  <*🧚\n"
u8"  < 🧚‍♀ << 🧚🏻‍♀ << 🧚🏼‍♀ << 🧚🏽‍♀ << 🧚🏾‍♀ << 🧚🏿‍♀\n"
u8"  < 🧚‍♂ << 🧚🏻‍♂ << 🧚🏼‍♂ << 🧚🏽‍♂ << 🧚🏾‍♂ << 🧚🏿‍♂\n"
u8"  <*🧛\n"
u8"  < 🧛‍♀ << 🧛🏻‍♀ << 🧛🏼‍♀ << 🧛🏽‍♀ << 🧛🏾‍♀ << 🧛🏿‍♀\n"
u8"  < 🧛‍♂ << 🧛🏻‍♂ << 🧛🏼‍♂ << 🧛🏽‍♂ << 🧛🏾‍♂ << 🧛🏿‍♂\n"
u8"  <*🧜\n"
u8"  < 🧜‍♀ << 🧜🏻‍♀ << 🧜🏼‍♀ << 🧜🏽‍♀ << 🧜🏾‍♀ << 🧜🏿‍♀\n"
u8"  < 🧜‍♂ << 🧜🏻‍♂ << 🧜🏼‍♂ << 🧜🏽‍♂ << 🧜🏾‍♂ << 🧜🏿‍♂\n"
u8"  <*🧝\n"
u8"  < 🧝‍♀ << 🧝🏻‍♀ << 🧝🏼‍♀ << 🧝🏽‍♀ << 🧝🏾‍♀ << 🧝🏿‍♀\n"
u8"  < 🧝‍♂ << 🧝🏻‍♂ << 🧝🏼‍♂ << 🧝🏽‍♂ << 🧝🏾‍♂ << 🧝🏿‍♂\n"
u8"  <*🧞\n"
u8"  < 🧞‍♀\n"
u8"  < 🧞‍♂\n"
u8"  <*🧟\n"
u8"  < 🧟‍♀\n"
u8"  < 🧟‍♂\n"
u8"  <*🙍\n"
u8"  < 🙍‍♂ << 🙍🏻‍♂ << 🙍🏼‍♂ << 🙍🏽‍♂ << 🙍🏾‍♂ << 🙍🏿‍♂\n"
u8"  < 🙍‍♀ << 🙍🏻‍♀ << 🙍🏼‍♀ << 🙍🏽‍♀ << 🙍🏾‍♀ << 🙍🏿‍♀\n"
u8"  <*🙎\n"
u8"  < 🙎‍♂ << 🙎🏻‍♂ << 🙎🏼‍♂ << 🙎🏽‍♂ << 🙎🏾‍♂ << 🙎🏿‍♂\n"
u8"  < 🙎‍♀ << 🙎🏻‍♀ << 🙎🏼‍♀ << 🙎🏽‍♀ << 🙎🏾‍♀ << 🙎🏿‍♀\n"
u8"  <*🙅\n"
u8"  < 🙅‍♂ << 🙅🏻‍♂ << 🙅🏼‍♂ << 🙅🏽‍♂ << 🙅🏾‍♂ << 🙅🏿‍♂\n"
u8"  < 🙅‍♀ << 🙅🏻‍♀ << 🙅🏼‍♀ << 🙅🏽‍♀ << 🙅🏾‍♀ << 🙅🏿‍♀\n"
u8"  <*🙆\n"
u8"  < 🙆‍♂ << 🙆🏻‍♂ << 🙆🏼‍♂ << 🙆🏽‍♂ << 🙆🏾‍♂ << 🙆🏿‍♂\n"
u8"  < 🙆‍♀ << 🙆🏻‍♀ << 🙆🏼‍♀ << 🙆🏽‍♀ << 🙆🏾‍♀ << 🙆🏿‍♀\n"
u8"  <*💁\n"
u8"  < 💁‍♂ << 💁🏻‍♂ << 💁🏼‍♂ << 💁🏽‍♂ << 💁🏾‍♂ << 💁🏿‍♂\n"
u8"  < 💁‍♀ << 💁🏻‍♀ << 💁🏼‍♀ << 💁🏽‍♀ << 💁🏾‍♀ << 💁🏿‍♀\n"
u8"  <*🙋\n"
u8"  < 🙋‍♂ << 🙋🏻‍♂ << 🙋🏼‍♂ << 🙋🏽‍♂ << 🙋🏾‍♂ << 🙋🏿‍♂\n"
u8"  < 🙋‍♀ << 🙋🏻‍♀ << 🙋🏼‍♀ << 🙋🏽‍♀ << 🙋🏾‍♀ << 🙋🏿‍♀\n"
u8"  <*🙇\n"
u8"  < 🙇‍♂ << 🙇🏻‍♂ << 🙇🏼‍♂ << 🙇🏽‍♂ << 🙇🏾‍♂ << 🙇🏿‍♂\n"
u8"  < 🙇‍♀ << 🙇🏻‍♀ << 🙇🏼‍♀ << 🙇🏽‍♀ << 🙇🏾‍♀ << 🙇🏿‍♀\n"
u8"  <*🤦\n"
u8"  < 🤦‍♂ << 🤦🏻‍♂ << 🤦🏼‍♂ << 🤦🏽‍♂ << 🤦🏾‍♂ << 🤦🏿‍♂\n"
u8"  < 🤦‍♀ << 🤦🏻‍♀ << 🤦🏼‍♀ << 🤦🏽‍♀ << 🤦🏾‍♀ << 🤦🏿‍♀\n"
u8"  <*🤷\n"
u8"  < 🤷‍♂ << 🤷🏻‍♂ << 🤷🏼‍♂ << 🤷🏽‍♂ << 🤷🏾‍♂ << 🤷🏿‍♂\n"
u8"  < 🤷‍♀ << 🤷🏻‍♀ << 🤷🏼‍♀ << 🤷🏽‍♀ << 🤷🏾‍♀ << 🤷🏿‍♀\n"
u8"  <*💆\n"
u8"  < 💆‍♂ << 💆🏻‍♂ << 💆🏼‍♂ << 💆🏽‍♂ << 💆🏾‍♂ << 💆🏿‍♂\n"
u8"  < 💆‍♀ << 💆🏻‍♀ << 💆🏼‍♀ << 💆🏽‍♀ << 💆🏾‍♀ << 💆🏿‍♀\n"
u8"  <*💇\n"
u8"  < 💇‍♂ << 💇🏻‍♂ << 💇🏼‍♂ << 💇🏽‍♂ << 💇🏾‍♂ << 💇🏿‍♂\n"
u8"  < 💇‍♀ << 💇🏻‍♀ << 💇🏼‍♀ << 💇🏽‍♀ << 💇🏾‍♀ << 💇🏿‍♀\n"
u8"  <*🚶\n"
u8"  < 🚶‍♂ << 🚶🏻‍♂ << 🚶🏼‍♂ << 🚶🏽‍♂ << 🚶🏾‍♂ << 🚶🏿‍♂\n"
u8"  < 🚶‍♀ << 🚶🏻‍♀ << 🚶🏼‍♀ << 🚶🏽‍♀ << 🚶🏾‍♀ << 🚶🏿‍♀\n"
u8"  <*🏃\n"
u8"  < 🏃‍♂ << 🏃🏻‍♂ << 🏃🏼‍♂ << 🏃🏽‍♂ << 🏃🏾‍♂ << 🏃🏿‍♂\n"
u8"  < 🏃‍♀ << 🏃🏻‍♀ << 🏃🏼‍♀ << 🏃🏽‍♀ << 🏃🏾‍♀ << 🏃🏿‍♀\n"
u8"  <*💃🕺👯\n"
u8"  < 👯‍♂\n"
u8"  < 👯‍♀\n"
u8"  <*🧖\n"
u8"  < 🧖‍♀ << 🧖🏻‍♀ << 🧖🏼‍♀ << 🧖🏽‍♀ << 🧖🏾‍♀ << 🧖🏿‍♀\n"
u8"  < 🧖‍♂ << 🧖🏻‍♂ << 🧖🏼‍♂ << 🧖🏽‍♂ << 🧖🏾‍♂ << 🧖🏿‍♂\n"
u8"  <*🧗\n"
u8"  < 🧗‍♀ << 🧗🏻‍♀ << 🧗🏼‍♀ << 🧗🏽‍♀ << 🧗🏾‍♀ << 🧗🏿‍♀\n"
u8"  < 🧗‍♂ << 🧗🏻‍♂ << 🧗🏼‍♂ << 🧗🏽‍♂ << 🧗🏾‍♂ << 🧗🏿‍♂\n"
u8"  <*🧘\n"
u8"  < 🧘‍♀ << 🧘🏻‍♀ << 🧘🏼‍♀ << 🧘🏽‍♀ << 🧘🏾‍♀ << 🧘🏿‍♀\n"
u8"  < 🧘‍♂ << 🧘🏻‍♂ << 🧘🏼‍♂ << 🧘🏽‍♂ << 🧘🏾‍♂ << 🧘🏿‍♂\n"
u8"  <*🛀🛌🕴🗣👤👥\n"
u8"  <*🤺🏇⛷🏂🏌\n"
u8"  < 🏌‍♂ = 🏌️‍♂ << 🏌🏻‍♂ << 🏌🏼‍♂ << 🏌🏽‍♂ << 🏌🏾‍♂ << 🏌🏿‍♂\n"
u8"  < 🏌‍♀ = 🏌️‍♀ << 🏌🏻‍♀ << 🏌🏼‍♀ << 🏌🏽‍♀ << 🏌🏾‍♀ << 🏌🏿‍♀\n"
u8"  <*🏄\n"
u8"  < 🏄‍♂ << 🏄🏻‍♂ << 🏄🏼‍♂ << 🏄🏽‍♂ << 🏄🏾‍♂ << 🏄🏿‍♂\n"
u8"  < 🏄‍♀ << 🏄🏻‍♀ << 🏄🏼‍♀ << 🏄🏽‍♀ << 🏄🏾‍♀ << 🏄🏿‍♀\n"
u8"  <*🚣\n"
u8"  < 🚣‍♂ << 🚣🏻‍♂ << 🚣🏼‍♂ << 🚣🏽‍♂ << 🚣🏾‍♂ << 🚣🏿‍♂\n"
u8"  < 🚣‍♀ << 🚣🏻‍♀ << 🚣🏼‍♀ << 🚣🏽‍♀ << 🚣🏾‍♀ << 🚣🏿‍♀\n"
u8"  <*🏊\n"
u8"  < 🏊‍♂ << 🏊🏻‍♂ << 🏊🏼‍♂ << 🏊🏽‍♂ << 🏊🏾‍♂ << 🏊🏿‍♂\n"
u8"  < 🏊‍♀ << 🏊🏻‍♀ << 🏊🏼‍♀ << 🏊🏽‍♀ << 🏊🏾‍♀ << 🏊🏿‍♀\n"
u8"  <*⛹\n"
u8"  < ⛹‍♂ = ⛹️‍♂ << ⛹🏻‍♂ << ⛹🏼‍♂ << ⛹🏽‍♂ << ⛹🏾‍♂ << ⛹🏿‍♂\n"
u8"  < ⛹‍♀ = ⛹️‍♀ << ⛹🏻‍♀ << ⛹🏼‍♀ << ⛹🏽‍♀ << ⛹🏾‍♀ << ⛹🏿‍♀\n"
u8"  <*🏋\n"
u8"  < 🏋‍♂ = 🏋️‍♂ << 🏋🏻‍♂ << 🏋🏼‍♂ << 🏋🏽‍♂ << 🏋🏾‍♂ << 🏋🏿‍♂\n"
u8"  < 🏋‍♀ = 🏋️‍♀ << 🏋🏻‍♀ << 🏋🏼‍♀ << 🏋🏽‍♀ << 🏋🏾‍♀ << 🏋🏿‍♀\n"
u8"  <*🚴\n"
u8"  < 🚴‍♂ << 🚴🏻‍♂ << 🚴🏼‍♂ << 🚴🏽‍♂ << 🚴🏾‍♂ << 🚴🏿‍♂\n"
u8"  < 🚴‍♀ << 🚴🏻‍♀ << 🚴🏼‍♀ << 🚴🏽‍♀ << 🚴🏾‍♀ << 🚴🏿‍♀\n"
u8"  <*🚵\n"
u8"  < 🚵‍♂ << 🚵🏻‍♂ << 🚵🏼‍♂ << 🚵🏽‍♂ << 🚵🏾‍♂ << 🚵🏿‍♂\n"
u8"  < 🚵‍♀ << 🚵🏻‍♀ << 🚵🏼‍♀ << 🚵🏽‍♀ << 🚵🏾‍♀ << 🚵🏿‍♀\n"
u8"  <*🏎🏍🤸\n"
u8"  < 🤸‍♂ << 🤸🏻‍♂ << 🤸🏼‍♂ << 🤸🏽‍♂ << 🤸🏾‍♂ << 🤸🏿‍♂\n"
u8"  < 🤸‍♀ << 🤸🏻‍♀ << 🤸🏼‍♀ << 🤸🏽‍♀ << 🤸🏾‍♀ << 🤸🏿‍♀\n"
u8"  <*🤼\n"
u8"  < 🤼‍♂\n"
u8"  < 🤼‍♀\n"
u8"  <*🤽\n"
u8"  < 🤽‍♂ << 🤽🏻‍♂ << 🤽🏼‍♂ << 🤽🏽‍♂ << 🤽🏾‍♂ << 🤽🏿‍♂\n"
u8"  < 🤽‍♀ << 🤽🏻‍♀ << 🤽🏼‍♀ << 🤽🏽‍♀ << 🤽🏾‍♀ << 🤽🏿‍♀\n"
u8"  <*🤾\n"
u8"  < 🤾‍♂ << 🤾🏻‍♂ << 🤾🏼‍♂ << 🤾🏽‍♂ << 🤾🏾‍♂ << 🤾🏿‍♂\n"
u8"  < 🤾‍♀ << 🤾🏻‍♀ << 🤾🏼‍♀ << 🤾🏽‍♀ << 🤾🏾‍♀ << 🤾🏿‍♀\n"
u8"  <*🤹\n"
u8"  < 🤹‍♂ << 🤹🏻‍♂ << 🤹🏼‍♂ << 🤹🏽‍♂ << 🤹🏾‍♂ << 🤹🏿‍♂\n"
u8"  < 🤹‍♀ << 🤹🏻‍♀ << 🤹🏼‍♀ << 🤹🏽‍♀ << 🤹🏾‍♀ << 🤹🏿‍♀\n"
u8"  <*👫👬👭💏\n"
u8"  < 👩‍❤‍💋‍👨 = 👩‍❤️‍💋‍👨\n"
u8"  < 👨‍❤‍💋‍👨 = 👨‍❤️‍💋‍👨\n"
u8"  < 👩‍❤‍💋‍👩 = 👩‍❤️‍💋‍👩\n"
u8"  <*💑\n"
u8"  < 👩‍❤‍👨 = 👩‍❤️‍👨\n"
u8"  < 👨‍❤‍👨 = 👨‍❤️‍👨\n"
u8"  < 👩‍❤‍👩 = 👩‍❤️‍👩\n"
u8"  <*👪\n"
u8"  < 👨‍👩‍👦\n"
u8"  < 👨‍👩‍👧\n"
u8"  < 👨‍👩‍👧‍👦\n"
u8"  < 👨‍👩‍👦‍👦\n"
u8"  < 👨‍👩‍👧‍👧\n"
u8"  < 👨‍👨‍👦\n"
u8"  < 👨‍👨‍👧\n"
u8"  < 👨‍👨‍👧‍👦\n"
u8"  < 👨‍👨‍👦‍👦\n"
u8"  < 👨‍👨‍👧‍👧\n"
u8"  < 👩‍👩‍👦\n"
u8"  < 👩‍👩‍👧\n"
u8"  < 👩‍👩‍👧‍👦\n"
u8"  < 👩‍👩‍👦‍👦\n"
u8"  < 👩‍👩‍👧‍👧\n"
u8"  < 👨‍👦\n"
u8"  < 👨‍👦‍👦\n"
u8"  < 👨‍👧\n"
u8"  < 👨‍👧‍👦\n"
u8"  < 👨‍👧‍👧\n"
u8"  < 👩‍👦\n"
u8"  < 👩‍👦‍👦\n"
u8"  < 👩‍👧\n"
u8"  < 👩‍👧‍👦\n"
u8"  < 👩‍👧‍👧\n"
u8"  <*🤳💪🦵🦶👈👉☝👆🖕👇✌🤞🖖🤘🤙🖐✋👌👍👎✊👊🤛🤜🤚👋🤟✍👏👐🙌🤲🙏🤝💅👂👃👣👀👁\n"
u8"  < 👁‍🗨 = 👁️‍🗨\n"
u8"  <*🧠🦴🦷👅👄\n"
u8"  <*🦰🦱🦳🦲\n"
u8"  <*💋💘💝💖💗💓💞💕💌❣💔❤🧡💛💚💙💜🖤💟💤💢💣💥💦💨💫💬🗨🗯💭🕳\n"
u8"  <*👓🕶🥽🥼👔👕👖🧣🧤🧥🧦👗👘👙👚👛👜👝🛍🎒👞👟🥾🥿👠👡👢👑👒🎩🎓🧢⛑📿💄💍💎\n"
u8"  <*🐵🐒🦍🐶🐕🐩🐺🦊🦝🐱🐈🦁🐯🐅🐆🐴🐎🦄🦓🦌🐮🐂🐃🐄🐷🐖🐗🐽🐏🐑🐐🐪🐫🦙🦒🐘🦏🦛🐭🐁🐀🐹🐰🐇🐿🦔🦇🐻🐨🐼🦘🦡🐾\n"
u8"  <*🦃🐔🐓🐣🐤🐥🐦🐧🕊🦅🦆🦢🦉🦚🦜\n"
u8"  <*🐸\n"
u8"  <*🐊🐢🦎🐍🐲🐉🦕🦖\n"
u8"  <*🐳🐋🐬🐟🐠🐡🦈🐙🐚🦀🦞🦐🦑\n"
u8"  <*🐌🦋🐛🐜🐝🐞🦗🕷🕸🦂🦟🦠\n"
u8"  <*💐🌸💮🏵🌹🥀🌺🌻🌼🌷\n"
u8"  <*🌱🌲🌳🌴🌵🌾🌿☘🍀🍁🍂🍃\n"
u8"  <*🍇🍈🍉🍊🍋🍌🍍🥭🍎🍏🍐🍑🍒🍓🥝🍅🥥\n"
u8"  <*🥑🍆🥔🥕🌽🌶🥒🥬🥦🍄🥜🌰\n"
u8"  <*🍞🥐🥖🥨🥯🥞🧀🍖🍗🥩🥓🍔🍟🍕🌭🥪🌮🌯🥙🥚🍳🥘🍲🥣🥗🍿🧂🥫\n"
u8"  <*🍱🍘🍙🍚🍛🍜🍝🍠🍢🍣🍤🍥🥮🍡🥟🥠🥡\n"
u8"  <*🍦🍧🍨🍩🍪🎂🍰🧁🥧🍫🍬🍭🍮🍯\n"
u8"  <*🍼🥛☕🍵🍶🍾🍷🍸🍹🍺🍻🥂🥃🥤\n"
u8"  <*🥢🍽🍴🥄🔪🏺\n"
u8"  <*🌍🌎🌏🌐🗺🗾🧭\n"
u8"  <*🏔⛰🌋🗻🏕🏖🏜🏝🏞\n"
u8"  <*🏟🏛🏗🧱🏘🏚🏠🏡🏢🏣🏤🏥🏦🏨🏩🏪🏫🏬🏭🏯🏰💒🗼🗽\n"
u8"  <*⛪🕌🕍⛩🕋\n"
u8"  <*⛲⛺🌁🌃🏙🌄🌅🌆🌇🌉♨🌌🎠🎡🎢💈🎪\n"
u8"  <*🚂🚃🚄🚅🚆🚇🚈🚉🚊🚝🚞🚋🚌🚍🚎🚐🚑🚒🚓🚔🚕🚖🚗🚘🚙🚚🚛🚜🚲🛴🛹🛵🚏🛣🛤🛢⛽🚨🚥🚦🛑🚧\n"
u8"  <*⚓⛵🛶🚤🛳⛴🛥🚢\n"
u8"  <*✈🛩🛫🛬💺🚁🚟🚠🚡🛰🚀🛸\n"
u8"  <*🛎🧳\n"
u8"  <*⌛⏳⌚⏰⏱⏲🕰🕛🕧🕐🕜🕑🕝🕒🕞🕓🕟🕔🕠🕕🕡🕖🕢🕗🕣🕘🕤🕙🕥🕚🕦\n"
u8"  <*🌑🌒🌓🌔🌕🌖🌗🌘🌙🌚🌛🌜🌡☀🌝🌞⭐🌟🌠☁⛅⛈🌤🌥🌦🌧🌨🌩🌪🌫🌬🌀🌈🌂☂☔⛱⚡❄☃⛄☄🔥💧🌊\n"
u8"  <*🎃🎄🎆🎇🧨✨🎈🎉🎊🎋🎍🎎🎏🎐🎑🧧🎀🎁🎗🎟🎫\n"
u8"  <*🎖🏆🏅🥇🥈🥉\n"
u8"  <*⚽⚾🥎🏀🏐🏈🏉🎾🥏🎳🏏🏑🏒🥍🏓🏸🥊🥋🥅⛳⛸🎣🎽🎿🛷🥌\n"
u8"  <*🎯🎱🔮🧿🎮🕹🎰🎲🧩🧸♠♥♦♣♟🃏🀄🎴\n"
u8"  <*🎭🖼🎨🧵🧶\n"
u8"  <*🔇🔈🔉🔊📢📣📯🔔🔕\n"
u8"  <*🎼🎵🎶🎙🎚🎛🎤🎧📻\n"
u8"  <*🎷🎸🎹🎺🎻🥁\n"
u8"  <*📱📲☎📞📟📠\n"
u8"  <*🔋🔌💻🖥🖨⌨🖱🖲💽💾💿📀🧮\n"
u8"  <*🎥🎞📽🎬📺📷📸📹📼🔍🔎🕯💡🔦🏮\n"
u8"  <*📔📕📖📗📘📙📚📓📒📃📜📄📰🗞📑🔖🏷\n"
u8"  <*💰💴💵💶💷💸💳🧾💹💱💲\n"
u8"  <*✉📧📨📩📤📥📦📫📪📬📭📮🗳\n"
u8"  <*✏✒🖋🖊🖌🖍📝\n"
u8"  <*💼📁📂🗂📅📆🗒🗓📇📈📉📊📋📌📍📎🖇📏📐✂🗃🗄🗑\n"
u8"  <*🔒🔓🔏🔐🔑🗝\n"
u8"  <*🔨⛏⚒🛠🗡⚔🔫🏹🛡🔧🔩⚙🗜⚖🔗⛓🧰🧲\n"
u8"  <*⚗🧪🧫🧬🔬🔭📡\n"
u8"  <*💉💊\n"
u8"  <*🚪🛏🛋🚽🚿🛁🧴🧷🧹🧺🧻🧼🧽🧯🛒\n"
u8"  <*🚬⚰⚱🗿\n"
u8"  <*🏧🚮🚰♿🚹🚺🚻🚼🚾🛂🛃🛄🛅\n"
u8"  <*⚠🚸⛔🚫🚳🚭🚯🚱🚷📵🔞☢☣\n"
u8"  <*⬆↗➡↘⬇↙⬅↖↕↔↩↪⤴⤵🔃🔄🔙🔚🔛🔜🔝\n"
u8"  <*🛐⚛🕉✡☸☯✝☦☪☮🕎🔯\n"
u8"  <*♈♉♊♋♌♍♎♏♐♑♒♓⛎\n"
u8"  <*🔀🔁🔂▶⏩⏭⏯◀⏪⏮🔼⏫🔽⏬⏸⏹⏺⏏🎦🔅🔆📶📳📴\n"
u8"  <*♀♂⚕♾♻⚜🔱📛🔰⭕✅☑✔✖❌❎➕➖➗➰➿〽✳✴❇‼⁉❓❔❕❗〰©®™\n"
u8"  < '#⃣' = '#️⃣'\n"
u8"  < '*⃣' = '*️⃣'\n"
u8"  < 0⃣ = 0️⃣\n"
u8"  < 1⃣ = 1️⃣\n"
u8"  < 2⃣ = 2️⃣\n"
u8"  < 3⃣ = 3️⃣\n"
u8"  < 4⃣ = 4️⃣\n"
u8"  < 5⃣ = 5️⃣\n"
u8"  < 6⃣ = 6️⃣\n"
u8"  < 7⃣ = 7️⃣\n"
u8"  < 8⃣ = 8️⃣\n"
u8"  < 9⃣ = 9️⃣\n"
u8"  <*🔟\n"
u8"  <*💯🔠🔡🔢🔣🔤🅰🆎🅱🆑🆒🆓ℹ🆔Ⓜ🆕🆖🅾🆗🅿🆘🆙🆚🈁🈂🈷🈶🈯🉐🈹🈚🈲🉑🈸🈴🈳㊗㊙🈺🈵\n"
u8"  <*🔴🔵⚪⚫⬜⬛◼◻◽◾▫▪🔶🔷🔸🔹🔺🔻💠🔘🔲🔳\n"
u8"  <*🏁🚩🎌🏴🏳\n"
u8"  < 🏳‍🌈 = 🏳️‍🌈\n"
u8"  < 🏴‍☠\n"
u8"  <*🇦🇧🇨🇩🇪🇫🇬🇭🇮🇯🇰🇱🇲🇳🇴🇵🇶🇷🇸🇹🇺🇻🇼🇽🇾🇿\n"
u8"  < 🏴󠁧󠁢󠁥󠁮󠁧󠁿\n"
u8"  < 🏴󠁧󠁢󠁳󠁣󠁴󠁿\n"
u8"  < 🏴󠁧󠁢󠁷󠁬󠁳󠁿\n"
u8"  \n");
}

inline string_view eor_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
&a
  <<ᴀ
  <<ⱥ
  <<<Ⱥ
  <<ᶏ
  <<ɐ
  <<<Ɐ
  <<<ᵄ
  <<ɑ
  <<<Ɑ
  <<<ᵅ
  <<ᶐ
  <<ɒ
  <<<Ɒ
  <<<ᶛ
&b
  <<ʙ
  <<ƀ
  <<<Ƀ
  <<ᴯ
  <<ᴃ
  <<ᵬ
  <<ᶀ
  <<ɓ
  <<<Ɓ
  <<ƃ
  <<<Ƃ
&c
  <<ᴄ
  <<ȼ
  <<<Ȼ
  <<ꞓ
  <<<Ꞓ
  <<ƈ
  <<<Ƈ
  <<ɕ
  <<<ᶝ
  <<ↄ
  <<<Ↄ
  <<ꜿ
  <<<Ꜿ
&d
  <<ᴅ
  <<ᴆ
  <<ᵭ
  <<ᶁ
  <<ɖ
  <<<Ɖ
  <<ɗ
  <<<Ɗ
  <<ᶑ
  <<ƌ
  <<<Ƌ
  <<ȡ
  <<ꝱ
  <<ẟ
  <<ƍ
&e
  <<ᴇ
  <<ɇ
  <<<Ɇ
  <<ᶒ
  <<ⱸ
  <<ǝ
  <<<Ǝ
  <<<ᴲ
  <<ⱻ
  <<ə
  <<<Ə
  <<<ᵊ
  <<<ₔ
  <<ᶕ
  <<ɛ
  <<<Ɛ
  <<<ℇ
  <<<ᵋ
  <<ᶓ
  <<ɘ
  <<ɚ
  <<ɜ
  <<<ᶟ
  <<ᶔ
  <<ᴈ
  <<<ᵌ
  <<ɝ
  <<ɞ
  <<ʚ
&f
  <<ꜰ
  <<ᵮ
  <<ᶂ
  <<ƒ
  <<<Ƒ
  <<ⅎ
  <<<Ⅎ
  <<ꟻ
&g
  <<ɡ
  <<<ᶢ
  <<ɢ
  <<<ᷛ
  <<ǥ
  <<<Ǥ
  <<ᶃ
  <<ɠ
  <<<Ɠ
  <<ʛ
  <<ᵷ
  <<ꝿ
  <<<Ꝿ
  <<ɣ
  <<<Ɣ
  <<<ˠ
  <<ɤ
  <<ƣ
  <<<Ƣ
&h
  <<ʜ
  <<ɦ
  <<<Ɦ
  <<<ʱ
  <<ⱨ
  <<<Ⱨ
  <<ⱶ
  <<<Ⱶ
  <<ꜧ
  <<<Ꜧ
  <<ɧ
  <<ɥ
  <<<Ɥ
  <<<ᶣ
  <<ʮ
  <<ʯ
&i
  <<ı
  <<<𝚤
  <<ɪ
  <<<ᶦ
  <<ꟾ
  <<ᴉ
  <<<ᵎ
  <<ɨ
  <<<Ɨ
  <<<ᶤ
  <<ᵻ
  <<<ᶧ
  <<ᶖ
  <<ɩ
  <<<Ɩ
  <<<ᶥ
  <<ᵼ
&j
  <<ȷ
  <<<𝚥
  <<ᴊ
  <<ɉ
  <<<Ɉ
  <<ʝ
  <<<ᶨ
  <<ɟ
  <<<ᶡ
  <<ʄ
&k
  <<ᴋ
  <<ᶄ
  <<ƙ
  <<<Ƙ
  <<ⱪ
  <<<Ⱪ
  <<ꝁ
  <<<Ꝁ
  <<ꝃ
  <<<Ꝃ
  <<ꝅ
  <<<Ꝅ
  <<ĸ
  <<ʞ
&l
  <<ʟ
  <<<ᷞ
  <<<ᶫ
  <<ꝇ
  <<<Ꝇ
  <<ᴌ
  <<ꝉ
  <<<Ꝉ
  <<ƚ
  <<<Ƚ
  <<ⱡ
  <<<Ⱡ
  <<ɫ
  <<<Ɫ
  <<ɬ
  <<ᶅ
  <<<ᶪ
  <<ɭ
  <<<ᶩ
  <<ꞎ
  <<ȴ
  <<ꝲ
  <<ꞁ
  <<<Ꞁ
  <<ƛ
&m
  <<ᴍ
  <<<ᷟ
  <<ᵯ
  <<ᶆ
  <<ɱ
  <<<Ɱ
  <<<ᶬ
  <<ꟽ
  <<ꟿ
  <<ꝳ
  <<ɯ
  <<<Ɯ
  <<<ᵚ
  <<ꟺ
  <<ᴟ
  <<ɰ
  <<<ᶭ
&n
  <<ŉ
  <<ɴ
  <<<ᷡ
  <<<ᶰ
  <<ᴻ
  <<ᴎ
  <<ᵰ
  <<ɲ
  <<<Ɲ
  <<<ᶮ
  <<ƞ
  <<<Ƞ
  <<ꞑ
  <<<Ꞑ
  <<ᶇ
  <<ɳ
  <<<ᶯ
  <<ȵ
  <<ꝴ
  <<ŋ
  <<<Ŋ
  <<<ᵑ
&o
  <<ᴏ
  <<ᴑ
  <<ᴓ
  <<ɔ
  <<<Ɔ
  <<<ᵓ
  <<ᴐ
  <<ᴒ
  <<ᶗ
  <<ꝍ
  <<<Ꝍ
  <<ᴖ
  <<<ᵔ
  <<ᴗ
  <<<ᵕ
  <<ⱺ
  <<ɵ
  <<<Ɵ
  <<<ᶱ
  <<ꝋ
  <<<Ꝋ
  <<ɷ
  <<ȣ
  <<<Ȣ
  <<<ᴽ
  <<ᴕ
&p
  <<ᴘ
  <<ᵽ
  <<<Ᵽ
  <<ꝑ
  <<<Ꝑ
  <<ᵱ
  <<ᶈ
  <<ƥ
  <<<Ƥ
  <<ꝓ
  <<<Ꝓ
  <<ꝕ
  <<<Ꝕ
  <<ꟼ
  <<ɸ
  <<<ᶲ
  <<ⱷ
&q
  <<ꝗ
  <<<Ꝗ
  <<ꝙ
  <<<Ꝙ
  <<ʠ
  <<ɋ
  <<<Ɋ
&r
  <<ʀ
  <<<ᷢ
  <<<Ʀ
  <<ꝛ
  <<<ᷣ
  <<<Ꝛ
  <<ᴙ
  <<ɍ
  <<<Ɍ
  <<ᵲ
  <<ɹ
  <<<ʴ
  <<ᴚ
  <<ɺ
  <<ᶉ
  <<ɻ
  <<<ʵ
  <<ⱹ
  <<ɼ
  <<ɽ
  <<<Ɽ
  <<ɾ
  <<ᵳ
  <<ɿ
  <<ʁ
  <<<ʶ
  <<ꝵ
  <<ꝶ
  <<ꝝ
  <<<Ꝝ
&s
  <<ꜱ
  <<ᵴ
  <<ᶊ
  <<ʂ
  <<<ᶳ
  <<ȿ
  <<<Ȿ
  <<ẜ
  <<ẝ
  <<ʃ
  <<<Ʃ
  <<<ᶴ
  <<ᶋ
  <<ƪ
  <<ʅ
  <<ᶘ
  <<ʆ
&t
  <<ᴛ
  <<ŧ
  <<<Ŧ
  <<ⱦ
  <<<Ⱦ
  <<ᵵ
  <<ƫ
  <<<ᶵ
  <<ƭ
  <<<Ƭ
  <<ʈ
  <<<Ʈ
  <<ȶ
  <<ꝷ
  <<ʇ
&u
  <<ᴜ
  <<<ᶸ
  <<ᴝ
  <<<ᵙ
  <<ᴞ
  <<ʉ
  <<<Ʉ
  <<<ᶶ
  <<ᵾ
  <<ᶙ
  <<ʊ
  <<<Ʊ
  <<<ᶷ
  <<ᵿ
&v
  <<ᴠ
  <<ꝟ
  <<<Ꝟ
  <<ᶌ
  <<ʋ
  <<<Ʋ
  <<<ᶹ
  <<ⱱ
  <<ⱴ
  <<ỽ
  <<<Ỽ
  <<ʌ
  <<<Ʌ
  <<<ᶺ
&w
  <<ᴡ
  <<ⱳ
  <<<Ⱳ
  <<ʍ
  <<ƿ
  <<<Ƿ
&x
  <<ᶍ
&y
  <<ʏ
  <<ɏ
  <<<Ɏ
  <<ƴ
  <<<Ƴ
  <<ỿ
  <<<Ỿ
  <<ʎ
  <<ȝ
  <<<Ȝ
&z
  <<ᴢ
  <<ƶ
  <<<Ƶ
  <<ᵶ
  <<ᶎ
  <<ȥ
  <<<Ȥ
  <<ʐ
  <<<ᶼ
  <<ʑ
  <<<ᶽ
  <<ɀ
  <<<Ɀ
  <<ⱬ
  <<<Ⱬ
  <<ꝣ
  <<<Ꝣ
  <<ʒ
  <<<Ʒ
  <<<ᶾ
  <<ǯ
  <<<Ǯ
  <<ᴣ
  <<ƹ
  <<<Ƹ
  <<ᶚ
  <<ƺ
  <<ʓ
&þ
  <<ꝥ
  <<<Ꝥ
  <<ꝧ
  <<<Ꝧ
&ae<<ᴁ<<ᴂ<<<ᵆ
&dʑ<<ʥ
&dʒ<<ʤ
&hv<<ƕ<<<Ƕ
&lʒ<<ɮ
&oe<<ɶ<<ᴔ
&tɕ<<ʨ
&ue<<ᵫ
&[last tertiary ignorable]
  =ʻ
  =ʽ
  =ꝩ
  =Ꝩ
  =ꝫ
  =Ꝫ
  =ꝭ
  =Ꝭ
  =ꝯ
  =᷒
  =Ꝯ
  =ꝰ
  =ꝸ
  =ƻ
  =ꜫ
  =Ꜫ
  =ꜭ
  =Ꜭ
  =ꜯ
  =Ꜯ
  =ƨ
  =Ƨ
  =ƽ
  =Ƽ
  =ƅ
  =Ƅ
  =ʔ
  =ɂ
  =Ɂ
  =ˀ
  =ʼ
  =ˮ
  =ʾ
  =ꜣ
  =Ꜣ
  =ꞌ
  =Ꞌ
  =ʕ
  =ˤ
  =ʿ
  =ˁ
  =ᴤ
  =ᴥ
  =ᵜ
  =ꜥ
  =Ꜥ
  =ʡ
  =ʢ
  =ʖ
  =ǀ
  =ǁ
  =ǂ
  =ǃ
  =ʗ
  =ʘ
  =ʬ
  =ʭ
&γ
  <<ᴦ
&λ
  <<ᴧ
&π
  <<ᴨ
&ρ
  <<ᴩ
&ψ
  <<ᴪ
&ђ
  <<ѓ
  <<<Ѓ
&й
  <ҋ
  <<<Ҋ
&л
  <<ᴫ
&ћ
  <<ќ
  <<<Ќ
&ք
  <և
  )");
}

inline string_view search_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
[normalization on]
[suppressContractions [เ-ไ ເ-ໄ ꪵ ꪶ ꪹ ꪻ ꪼ\u19B5-\u19B7\u19BA]]
&'='<'≠'
&ا
  <<<ﺎ<<<ﺍ
  <<آ
  <<<ﺂ<<<ﺁ
  <<أ
  <<<ﺄ<<<ﺃ
  <<إ
  <<<ﺈ<<<ﺇ
&و
  <<<ۥ
  <<<ﻮ<<<ﻭ
  <<ؤ
  <<<ﺆ<<<ﺅ
&ي
  <<<ۦ
  <<<ﻳ<<<ﻴ<<<ﻲ<<<ﻱ
  <<ئ
  <<<ﺋ<<<ﺌ<<<ﺊ<<<ﺉ
  <<ى
  <<<ﯨ<<<ﯩ
  <<<ﻰ<<<ﻯ
&ه
  <<<ﻫ<<<ﻬ<<<ﻪ<<<ﻩ
  <<ة
  <<<ﺔ<<<ﺓ
&[last primary ignorable]<<׳
  <<״
  <<ـ
  <<ฺ
&ᄀ
  =ᆨ
&ᄀᄀ
  =ᄁ=ᆩ
&ᄀᄉ
  =ᆪ
&ᄂ
  =ᆫ
&ᄂᄌ
  =ᆬ
&ᄂᄒ
  =ᆭ
&ᄃ
  =ᆮ
&ᄃᄃ
  =ᄄ
&ᄅ
  =ᆯ
&ᄅᄀ
  =ᆰ
&ᄅᄆ
  =ᆱ
&ᄅᄇ
  =ᆲ
&ᄅᄉ
  =ᆳ
&ᄅᄐ
  =ᆴ
&ᄅᄑ
  =ᆵ
&ᄅᄒ
  =ᆶ
&ᄆ
  =ᆷ
&ᄇ
  =ᆸ
&ᄇᄇ
  =ᄈ
&ᄇᄉ
  =ᆹ
&ᄉ
  =ᆺ
&ᄉᄉ
  =ᄊ=ᆻ
&ᄋ
  =ᆼ
&ᄌ
  =ᆽ
&ᄌᄌ
  =ᄍ
&ᄎ
  =ᆾ
&ᄏ
  =ᆿ
&ᄐ
  =ᇀ
&ᄑ
  =ᇁ
&ᄒ
  =ᇂ
&ᅡᅵ
  =ᅢ
&ᅣᅵ
  =ᅤ
&ᅥᅵ
  =ᅦ
&ᅧᅵ
  =ᅨ
&ᅩᅡ
  =ᅪ
&ᅩᅡᅵ
  =ᅫ
&ᅩᅵ
  =ᅬ
&ᅮᅥ
  =ᅯ
&ᅮᅥᅵ
  =ᅰ
&ᅮᅵ
  =ᅱ
&ᅳᅵ
  =ᅴ
  )");
}


}}}}

#endif
