// Copyright (C) 2020 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Warning! This file is autogenerated.
#ifndef BOOST_TEXT_DATA_KO_HPP
#define BOOST_TEXT_DATA_KO_HPP

#include <boost/text/string_view.hpp>


namespace boost { namespace text { namespace data { namespace ko {

inline string_view search_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
  
[normalization on]
[suppressContractions [เ-ไ ເ-ໄ ꪵ ꪶ ꪹ ꪻ ꪼ\u19B5-\u19B7\u19BA]]
&'='<'≠'
&ا
  <<<ﺎ<<<ﺍ
  <<آ
  <<<ﺂ<<<ﺁ
  <<أ
  <<<ﺄ<<<ﺃ
  <<إ
  <<<ﺈ<<<ﺇ
&و
  <<<ۥ
  <<<ﻮ<<<ﻭ
  <<ؤ
  <<<ﺆ<<<ﺅ
&ي
  <<<ۦ
  <<<ﻳ<<<ﻴ<<<ﻲ<<<ﻱ
  <<ئ
  <<<ﺋ<<<ﺌ<<<ﺊ<<<ﺉ
  <<ى
  <<<ﯨ<<<ﯩ
  <<<ﻰ<<<ﻯ
&ه
  <<<ﻫ<<<ﻬ<<<ﻪ<<<ﻩ
  <<ة
  <<<ﺔ<<<ﺓ
&[last primary ignorable]<<׳
  <<״
  <<ـ
  <<ฺ
&ᄀ
  =ᆨ
&ᄀᄀ
  =ᄁ=ᆩ
&ᄀᄉ
  =ᆪ
&ᄂ
  =ᆫ
&ᄂᄌ
  =ᆬ
&ᄂᄒ
  =ᆭ
&ᄃ
  =ᆮ
&ᄃᄃ
  =ᄄ
&ᄅ
  =ᆯ
&ᄅᄀ
  =ᆰ
&ᄅᄆ
  =ᆱ
&ᄅᄇ
  =ᆲ
&ᄅᄉ
  =ᆳ
&ᄅᄐ
  =ᆴ
&ᄅᄑ
  =ᆵ
&ᄅᄒ
  =ᆶ
&ᄆ
  =ᆷ
&ᄇ
  =ᆸ
&ᄇᄇ
  =ᄈ
&ᄇᄉ
  =ᆹ
&ᄉ
  =ᆺ
&ᄉᄉ
  =ᄊ=ᆻ
&ᄋ
  =ᆼ
&ᄌ
  =ᆽ
&ᄌᄌ
  =ᄍ
&ᄎ
  =ᆾ
&ᄏ
  =ᆿ
&ᄐ
  =ᇀ
&ᄑ
  =ᇁ
&ᄒ
  =ᇂ
&ᅡᅵ
  =ᅢ
&ᅣᅵ
  =ᅤ
&ᅥᅵ
  =ᅦ
&ᅧᅵ
  =ᅨ
&ᅩᅡ
  =ᅪ
&ᅩᅡᅵ
  =ᅫ
&ᅩᅵ
  =ᅬ
&ᅮᅥ
  =ᅯ
&ᅮᅥᅵ
  =ᅰ
&ᅮᅵ
  =ᅱ
&ᅳᅵ
  =ᅴ
  
&ᄀᄂ
  =ᇺ
&ᄀᄃ
  =ᅚ
&ᄀᄅ
  =ᇃ
&ᄀᄇ
  =ᇻ
&ᄀᄉᄀ
  =ᇄ
&ᄀᄎ
  =ᇼ
&ᄀᄏ
  =ᇽ
&ᄀᄒ
  =ᇾ
&ᄂᄀ
  =ᄓ=ᇅ
&ᄂᄂ
  =ᄔ=ᇿ
&ᄂᄃ
  =ᄕ=ᇆ
&ᄂᄇ
  =ᄖ
&ᄂᄉ
  =ᅛ=ᇇ
&ᄂᄌ
  =ᅜ
&ᄂᄐ
  =ᇉ
&ᄂᄒ
  =ᅝ
&ᄃᄀ
  =ᄗ=ᇊ
&ᄃᄅ
  =ᅞ=ᇋ
&ᄅᄀᄉ
  =ᇌ
&ᄅᄂ
  =ᄘ=ᇍ
&ᄅᄃ
  =ᇎ
&ᄅᄃᄒ
  =ᇏ
&ᄅᄅ
  =ᄙ=ᇐ
&ᄅᄆᄀ
  =ᇑ
&ᄅᄆᄉ
  =ᇒ
&ᄅᄇᄉ
  =ᇓ
&ᄅᄇᄋ
  =ᇕ
&ᄅᄇᄒ
  =ᇔ
&ᄅᄉᄉ
  =ᇖ
&ᄅᄋ
  =ᄛ
&ᄅᄏ
  =ᇘ
&ᄅᄒ
  =ᄚ
&ᄆᄀ
  =ᇚ
&ᄆᄅ
  =ᇛ
&ᄆᄇ
  =ᄜ=ᇜ
&ᄆᄉ
  =ᇝ
&ᄆᄉᄉ
  =ᇞ
&ᄆᄋ
  =ᄝ=ᇢ
&ᄆᄎ
  =ᇠ
&ᄆᄒ
  =ᇡ
&ᄇᄀ
  =ᄞ
&ᄇᄂ
  =ᄟ
&ᄇᄃ
  =ᄠ
&ᄇᄅ
  =ᇣ
&ᄇᄇᄋ
  =ᄬ
&ᄇᄉ
  =ᄡ
&ᄇᄉᄀ
  =ᄢ
&ᄇᄉᄃ
  =ᄣ
&ᄇᄉᄇ
  =ᄤ
&ᄇᄉᄉ
  =ᄥ
&ᄇᄉᄌ
  =ᄦ
&ᄇᄋ
  =ᄫ=ᇦ
&ᄇᄌ
  =ᄧ
&ᄇᄎ
  =ᄨ
&ᄇᄐ
  =ᄩ
&ᄇᄑ
  =ᄪ=ᇤ
&ᄇᄒ
  =ᇥ
&ᄉᄀ
  =ᄭ=ᇧ
&ᄉᄂ
  =ᄮ
&ᄉᄃ
  =ᄯ=ᇨ
&ᄉᄅ
  =ᄰ=ᇩ
&ᄉᄆ
  =ᄱ
&ᄉᄇ
  =ᄲ=ᇪ
&ᄉᄇᄀ
  =ᄳ
&ᄉᄉᄉ
  =ᄴ
&ᄉᄋ
  =ᄵ
&ᄉᄌ
  =ᄶ
&ᄉᄎ
  =ᄷ
&ᄉᄏ
  =ᄸ
&ᄉᄐ
  =ᄹ
&ᄉᄑ
  =ᄺ
&ᄉᄒ
  =ᄻ
&ᄋᄀ
  =ᅁ=ᇬ
&ᄋᄀᄀ
  =ᇭ
&ᄋᄃ
  =ᅂ
&ᄋᄆ
  =ᅃ
&ᄋᄇ
  =ᅄ
&ᄋᄉ
  =ᅅ
&ᄋᄋ
  =ᅇ=ᇮ
&ᄋᄌ
  =ᅈ
&ᄋᄎ
  =ᅉ
&ᄋᄏ
  =ᇯ
&ᄋᄐ
  =ᅊ
&ᄋᄑ
  =ᅋ
&ᄌᄋ
  =ᅍ
&ᄎᄏ
  =ᅒ
&ᄎᄒ
  =ᅓ
&ᄑᄇ
  =ᅖ=ᇳ
&ᄑᄋ
  =ᅗ=ᇴ
&ᄒᄂ
  =ᇵ
&ᄒᄅ
  =ᇶ
&ᄒᄆ
  =ᇷ
&ᄒᄇ
  =ᇸ
&ᄒᄒ
  =ᅘ
&ᅡᅩ
  =ᅶ
&ᅡᅮ
  =ᅷ
&ᅣᅩ
  =ᅸ
&ᅣᅭ
  =ᅹ
&ᅥᅩ
  =ᅺ
&ᅥᅮ
  =ᅻ
&ᅥᅳ
  =ᅼ
&ᅧᅩ
  =ᅽ
&ᅧᅮ
  =ᅾ
&ᅩᅥ
  =ᅿ
&ᅩᅥᅵ
  =ᆀ
&ᅩᅧᅵ
  =ᆁ
&ᅩᅩ
  =ᆂ
&ᅩᅮ
  =ᆃ
&ᅭᅣ
  =ᆄ
&ᅭᅣᅵ
  =ᆅ
&ᅭᅧ
  =ᆆ
&ᅭᅩ
  =ᆇ
&ᅭᅵ
  =ᆈ
&ᅮᅡ
  =ᆉ
&ᅮᅡᅵ
  =ᆊ
&ᅮᅥᅳ
  =ᆋ
&ᅮᅧᅵ
  =ᆌ
&ᅮᅮ
  =ᆍ
&ᅲᅡ
  =ᆎ
&ᅲᅥ
  =ᆏ
&ᅲᅥᅵ
  =ᆐ
&ᅲᅧ
  =ᆑ
&ᅲᅧᅵ
  =ᆒ
&ᅲᅮ
  =ᆓ
&ᅲᅵ
  =ᆔ
&ᅳᅮ
  =ᆕ
&ᅳᅳ
  =ᆖ
&ᅴᅮ
  =ᆗ
&ᅵᅡ
  =ᆘ
&ᅵᅣ
  =ᆙ
&ᅵᅩ
  =ᆚ
&ᅵᅮ
  =ᆛ
&ᅵᅳ
  =ᆜ
&ᅡᅳ
  =ᆣ
&ᅣᅮ
  =ᆤ
&ᅧᅣ
  =ᆥ
&ᅩᅣ
  =ᆦ
&ᅩᅣᅵ
  =ᆧ
  )");
}

inline string_view searchjl_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
[normalization on]
[suppressContractions [เ-ไ ເ-ໄ ꪵ ꪶ ꪹ ꪻ ꪼ\u19B5-\u19B7\u19BA]]
&ا
  <<<ﺎ<<<ﺍ
  <<آ
  <<<ﺂ<<<ﺁ
  <<أ
  <<<ﺄ<<<ﺃ
  <<إ
  <<<ﺈ<<<ﺇ
&و
  <<<ۥ
  <<<ﻮ<<<ﻭ
  <<ؤ
  <<<ﺆ<<<ﺅ
&ي
  <<<ۦ
  <<<ﻳ<<<ﻴ<<<ﻲ<<<ﻱ
  <<ئ
  <<<ﺋ<<<ﺌ<<<ﺊ<<<ﺉ
  <<ى
  <<<ﯨ<<<ﯩ
  <<<ﻰ<<<ﻯ
&ه
  <<<ﻫ<<<ﻬ<<<ﻪ<<<ﻩ
  <<ة
  <<<ﺔ<<<ﺓ
&[last primary ignorable]<<׳
  <<״
  <<ـ
  <<ฺ
  <<ᅡ
  <<ᅢ
  <<ᅣ
  <<ᅤ
  <<ᅥ
  <<ᅦ
  <<ᅧ
  <<ᅨ
  <<ᅩ
  <<ᅪ
  <<ᅫ
  <<ᅬ
  <<ᅭ
  <<ᅮ
  <<ᅯ
  <<ᅰ
  <<ᅱ
  <<ᅲ
  <<ᅳ
  <<ᅴ
  <<ᅵ
  <<ᆨ
  <<ᆩ
  <<ᆪ
  <<ᆫ
  <<ᆬ
  <<ᆭ
  <<ᆮ
  <<ᆯ
  <<ᆰ
  <<ᆱ
  <<ᆲ
  <<ᆳ
  <<ᆴ
  <<ᆵ
  <<ᆶ
  <<ᆷ
  <<ᆸ
  <<ᆹ
  <<ᆺ
  <<ᆻ
  <<ᆼ
  <<ᆽ
  <<ᆾ
  <<ᆿ
  <<ᇀ
  <<ᇁ
  <<ᇂ
&[first primary ignorable]
  =\u1100|\u1100
  =\u1103|\u1103
  =\u1107|\u1107
  =\u1109|\u1109
  =\u110C|\u110C
&\u1100\u1100=\u1101<<<\u3132
&\u1103\u1103=\u1104<<<\u3138
&\u1107\u1107=\u1108<<<\u3143
&\u1109\u1109=\u110A<<<\u3146
&\u110C\u110C=\u110D<<<\u3149
  )");
}

inline std::string standard_collation_tailoring()
{
    std::string str;
    str += (char const *)u8"  \n";
    str += (char const *)u8"[reorder Hang Hani]\n";
    str += (char const *)u8"[optimize [가-각간갇-갊감-갗같-객갠갤갬-갭갯-갱갸-갹갼걀걋걍걔걘걜거-걱건걷-걸걺검-겁것-겆겉-게겐겔겜-겝겟-겡겨-겪견겯-결겸-겹겻-경곁계곈곌곕곗고-곡곤곧-골곪곬곯-곱곳공-곶과-곽관괄괆괌-괍괏광괘괜괠괩괬-괭괴-괵괸괼굄-굅굇굉교굔굘굡굣구-국군굳-굶굻-굽굿궁-궂궈-궉권궐궜-궝궤궷귀-귁귄귈귐-귑귓규균귤그-극근귿-긁금-급긋긍긔기-긱긴긷-길긺김-깁깃깅-깆깊까-깎깐깔깖깜-깝깟-깡깥깨-깩깬깰깸-깹깻-깽꺄-꺅꺌꺼-꺾껀껄껌-껍껏-껑께-껙껜껨껫껭껴껸껼꼇-꼈꼍꼐꼬-꼭꼰꼲꼴꼼-꼽꼿꽁-꽃꽈-꽉꽐꽜-꽝꽤-꽥꽹꾀꾄꾈꾐-꾑꾕꾜꾸-꾹꾼꿀꿇-꿉꿋꿍-꿎꿔꿜꿨-꿩꿰-꿱꿴꿸뀀-뀁뀄뀌뀐뀔뀜-뀝뀨끄-끅끈끊끌끎끓-끕끗끙끝끼-끽낀낄낌-낍낏낑나-낚난낟-낢남-납낫-낯낱낳-낵낸낼냄-냅냇-냉냐-냑냔냘냠냥너-넉넋-넌널넒-넓넘-넙넛-넝넣-넥넨넬넴-넵넷-넹녀-녁년녈념-녑녔-녕녘녜녠노-녹논놀놂놈-놉놋농높-놔놘놜놨뇌뇐뇔뇜-뇝뇟뇨-뇩뇬뇰뇹뇻뇽누-눅눈눋-눌눔-눕눗눙눠눴눼뉘뉜뉠뉨-뉩뉴-뉵뉼늄-늅늉느-늑는늘-늚늠-늡늣능-늦늪늬늰늴니-닉닌닐닖님-닙닛닝닢다-닦단닫-닯닳-답닷-닻닿-댁댄댈댐-댑댓-댕댜더-덖던덛-덜덞-덟덤-덥덧덩덫덮데-덱덴델뎀-뎁뎃-뎅뎌뎐뎔뎠-뎡뎨뎬도-독돈돋-돌돎돐돔-돕돗동돛돝돠돤돨돼됐되된될됨-됩됫됴두-둑둔둘둠-둡둣둥둬뒀뒈뒝뒤뒨뒬뒵뒷뒹듀듄듈듐듕드-득든듣-들듦듬-듭듯등듸디-딕딘딛-딜딤-딥딧-딪따-딱딴딸땀-땁땃-땅땋-땍땐땔땜-땝땟-땡떠-떡떤떨떪-떫떰-떱떳-떵떻-떽뗀뗄뗌-뗍뗏-뗑뗘뗬또-똑똔똘똥똬똴뙈뙤뙨뚜-뚝뚠뚤뚫-뚬뚱뛔뛰뛴뛸뜀-뜁뜅뜨-뜩뜬뜯-뜰뜸-뜹뜻띄띈띌띔-띕띠띤띨띰-띱띳띵라-락란랄람-랍랏-랒랖-랙랜랠램-랩랫-랭랴-략랸럇량러-럭런럴럼-럽럿-렁렇-렉렌렐렘-렙렛렝려-력련렬렴-렵렷-령례롄롑롓로-록론롤롬-롭롯롱롸롼뢍뢨뢰뢴뢸룀-룁룃룅료룐룔룝룟룡루-룩룬룰룸-룹룻룽뤄뤘뤠뤼-뤽륀륄륌륏륑류-륙륜률륨-륩륫륭르-륵른를름-릅릇릉-릊릍-릎리-릭린릴림-립릿링마-막만많-맒맘-맙맛망-맞맡맣-맥맨맬맴-맵맷-맺먀-먁먈먕머-먹먼멀멂멈-멉멋멍-멎멓-멕멘멜멤-멥멧-멩며-멱면멸몃-명몇몌모-목몫-몬몰몲몸-몹못몽뫄뫈뫘-뫙뫼묀묄묍묏묑묘묜묠묩묫무-묶문묻-묾뭄-뭅뭇뭉뭍뭏-뭐뭔뭘뭡뭣뭬뮈뮌뮐뮤뮨뮬뮴뮷므믄믈믐믓미-믹민믿-밀밂밈-밉밋-밍및밑바-반받-밟밤-밥밧방밭배-백밴밸뱀-뱁뱃-뱅뱉뱌-뱍뱐뱝버-벅번벋-벌벎범-법벗벙-벚베-벡벤벧-벨벰-벱벳-벵벼-벽변별볍볏-병볕볘볜보-볶본볼봄-봅봇봉봐봔봤봬뵀뵈-뵉뵌뵐뵘-뵙뵤뵨부-북분붇-붊붐-붑붓붕붙-붚붜붤붰붸뷔-뷕뷘뷜뷩뷰뷴뷸븀븃븅브-븍븐블븜-븝븟비-빅빈빌빎빔-빕빗빙-빛빠-빡빤빨빪빰-빱빳-빵빻-빽뺀뺄뺌-뺍뺏-뺑뺘-뺙뺨뻐-뻑뻔뻗-뻘뻠뻣-뻥뻬뼁뼈-뼉뼘-뼙뼛-뼝뽀-뽁뽄뽈뽐-뽑뽕뾔뾰뿅뿌-뿍뿐뿔뿜뿟뿡쀼쁑쁘쁜쁠쁨-쁩삐-삑삔삘삠-삡삣삥사-삭삯-산삳-삶삼-삽삿-상샅새-색샌샐샘-샙샛-생샤-샥샨샬샴-샵샷샹섀섄섈섐섕서-선섣-설섦-섧섬-섭섯-성섶세-섹센셀셈-셉셋-셍셔-셕션셜셤-셥셧-셩셰셴셸솅소-솎손솔솖솜-솝솟송솥솨-솩솬솰솽쇄쇈쇌쇔쇗-쇘쇠쇤쇨쇰-쇱쇳쇼-쇽숀숄숌-숍숏숑수-숙순숟-술숨-숩숫숭숯숱-숲숴쉈쉐-쉑쉔쉘쉠쉥쉬-쉭쉰쉴쉼-쉽쉿슁슈-슉슐슘슛슝스-슥슨슬-슭슴-습슷승시-식신싣-실싫-십싯싱싶싸-싹싻-싼쌀쌈-쌉쌌-쌍쌓-쌕쌘쌜쌤-쌥쌨-쌩썅써-썩썬썰썲썸-썹썼-썽쎄쎈쎌쏀쏘-쏙쏜쏟-쏠쏢쏨-쏩쏭쏴-쏵쏸쐈쐐쐤쐬쐰쐴쐼-쐽쑈쑤-쑥쑨쑬쑴-쑵쑹쒀쒔쒜쒸쒼쓩쓰-쓱쓴쓸쓺쓿-씁씌씐씔씜씨-씩씬씰씸-씹씻씽아-악안-않알-앎앓-압앗-앙앝-앞애-액";
    str += (char const *)u8"앤앨앰-앱앳-앵야-약얀얄얇얌-얍얏양얕얗-얘얜얠얩어-억언-얹얻-얾엄-엊엌엎에-엑엔엘엠-엡엣엥여-엮연열엶-엷염-영옅-예옌옐옘-옙옛-옜오-옥온올-옮옰옳-옵옷옹옻와-왁완왈왐-왑왓-왕왜-왝왠왬왯왱외-왹왼욀욈-욉욋욍요-욕욘욜욤-욥욧용우-욱운울-욺움-웁웃웅워-웍원월웜-웝웠-웡웨-웩웬웰웸-웹웽위-윅윈윌윔-윕윗윙유-육윤율윰-윱윳융윷으-윽은을읊음-읍읏응-의읜읠읨읫이-익인일-읾잃-입잇-잊잎자-작잔잖-잘잚잠-잡잣-잦재-잭잰잴잼-잽잿-쟁쟈-쟉쟌쟎쟐쟘쟝쟤쟨쟬저-적전절젊점-접젓정-젖제-젝젠젤젬-젭젯젱져젼졀졈-졉졌-졍졔조-족존졸졺좀-좁좃종-좇좋-좍좔좝좟좡좨좼-좽죄죈죌죔-죕죗죙죠-죡죤죵주-죽준줄-줆줌-줍줏중줘줬줴쥐-쥑쥔쥘쥠-쥡쥣쥬쥰쥴쥼즈-즉즌즐즘-즙즛증지-직진짇-질짊짐-집짓징-짖짙-짚짜-짝짠짢짤짧짬-짭짯-짱째-짹짼쨀쨈-쨉쨋-쨍쨔쨘쨩쩌-쩍쩐쩔쩜-쩝쩟-쩡쩨쩽쪄쪘쪼-쪽쫀쫄쫌-쫍쫏쫑쫓쫘-쫙쫠쫬쫴쬈쬐쬔쬘쬠-쬡쭁쭈-쭉쭌쭐쭘-쭙쭝쭤쭸-쭹쮜쮸쯔쯤쯧쯩찌-찍찐찔찜-찝찡-찢찧-착찬찮찰참-찹찻-찾채-책챈챌챔-챕챗-챙챠챤챦챨챰챵처-척천철첨-첩첫-청체-첵첸첼쳄-쳅쳇쳉쳐쳔쳤쳬쳰촁초-촉촌촐촘-촙촛총촤촨촬촹최쵠쵤쵬-쵭쵯쵱쵸춈추-축춘출춤-춥춧충춰췄췌췐취췬췰췸-췹췻췽츄츈츌츔츙츠-측츤츨츰-츱츳층치-칙친칟-칡침-칩칫칭카-칵칸칼캄-캅캇캉캐-캑캔캘캠-캡캣-캥캬-캭컁커-컥컨컫-컬컴-컵컷-컹케-켁켄켈켐-켑켓켕켜켠켤켬-켭켯-켱켸코-콕콘콜콤-콥콧콩콰-콱콴콸쾀쾅쾌쾡쾨쾰쿄쿠-쿡쿤쿨쿰-쿱쿳쿵쿼퀀퀄퀑퀘퀭퀴-퀵퀸퀼큄-큅큇큉큐큔큘큠크-큭큰클큼-큽킁키-킥킨킬킴-킵킷킹타-탁탄탈-탉탐-탑탓-탕태-택탠탤탬-탭탯-탱탸턍터-턱턴털턺텀-텁텃-텅테-텍텐텔템-텝텟텡텨텬텼톄톈토-톡톤톨톰-톱톳통톺톼퇀퇘퇴퇸툇툉툐투-툭툰툴툼-툽툿퉁퉈퉜퉤튀-튁튄튈튐-튑튕튜튠튤튬튱트-특튼튿-틀틂틈-틉틋틔틘틜틤-틥티-틱틴틸팀-팁팃팅파-팎판팔팖팜-팝팟-팡팥패-팩팬팰팸-팹팻-팽퍄-퍅퍼-퍽펀펄펌-펍펏-펑페-펙펜펠펨-펩펫펭펴편펼폄-폅폈-평폐폘폡폣포-폭폰폴폼-폽폿퐁퐈퐝푀푄표푠푤푭푯푸-푹푼푿-풀풂품-풉풋풍풔풩퓌퓐퓔퓜퓟퓨퓬퓰퓸퓻퓽프픈플픔-픕픗피-픽핀필핌-핍핏핑하-학한할핥함-합핫항해-핵핸핼햄-햅햇-행햐향허-헉헌헐헒험-헙헛헝헤-헥헨헬헴-헵헷헹혀-혁현혈혐-협혓-형혜혠혤혭호-혹혼홀홅홈-홉홋홍홑화-확환활홧황홰-홱홴횃횅회-획횐횔횝횟횡효횬횰횹횻후-훅훈훌훑훔훗훙훠훤훨훰훵훼-훽휀휄휑휘-휙휜휠휨-휩휫휭휴-휵휸휼흄흇흉흐-흑흔흖-흙흠-흡흣흥흩희흰흴흼-흽힁히-힉힌힐힘-힙힛힝]]\n";
    str += (char const *)u8"&가<<*伽佳假價加可呵哥嘉嫁家暇架枷柯歌珂痂稼苛茄街袈訶賈跏軻迦駕仮傢咖哿坷宊斝榎檟珈笳耞舸葭謌\n";
    str += (char const *)u8"&각<<*刻却各恪慤殼珏脚覺角閣卻咯埆搉擱桷\n";
    str += (char const *)u8"&간<<*侃刊墾奸姦干幹懇揀杆柬桿澗癎看磵稈竿簡肝艮艱諫間偘慳栞榦玕秆茛衎赶迀齦\n";
    str += (char const *)u8"&갈<<*乫喝曷渴碣竭葛褐蝎鞨噶楬秸羯蠍鶡\n";
    str += (char const *)u8"&감<<*勘坎堪嵌感憾戡敢柑橄減甘疳監瞰紺邯鑑鑒龕坩埳嵁弇憨撼欿歛泔淦澉矙轗酣鹻\n";
    str += (char const *)u8"&갑<<*匣岬甲胛鉀閘韐\n";
    str += (char const *)u8"&강<<*剛堈姜岡崗康强彊慷江畺疆糠絳綱羌腔舡薑襁講鋼降鱇傋僵壃忼扛杠橿殭矼穅繈罡羗羫茳豇韁\n";
    str += (char const *)u8"&개<<*介价個凱塏愷愾慨改槪漑疥皆盖箇芥蓋鎧開剴匃揩槩玠磕闓\n";
    str += (char const *)u8"&객<<*喀客\n";
    str += (char const *)u8"&갱<<*坑粳羹硜賡鏗\n";
    str += (char const *)u8"&갹<<醵\n";
    str += (char const *)u8"&거<<*倨去居巨拒据據擧渠炬祛距踞遽鉅鋸呿昛秬筥籧胠腒苣莒蕖蘧袪裾駏\n";
    str += (char const *)u8"&건<<*乾件健巾建愆楗腱虔蹇鍵騫揵犍睷褰謇鞬\n";
    str += (char const *)u8"&걸<<*乞傑杰桀乬朅榤\n";
    str += (char const *)u8"&검<<*儉劍劒檢瞼鈐黔撿芡\n";
    str += (char const *)u8"&겁<<*劫怯迲刦刧\n";
    str += (char const *)u8"&게<<*偈憩揭\n";
    str += (char const *)u8"&격<<*擊格檄激膈覡隔挌毄闃骼鬲鴃\n";
    str += (char const *)u8"&견<<*堅牽犬甄絹繭肩見譴遣鵑樫狷畎筧縳繾羂蠲鰹\n";
    str += (char const *)u8"&결<<*抉決潔結缺訣玦觖闋\n";
    str += (char const *)u8"&겸<<*兼慊箝謙鉗鎌傔嗛岒拑歉縑蒹黚鼸\n";
    str += (char const *)u8"&경<<*京俓倞傾儆勁勍卿坰境庚徑慶憬擎敬景暻更梗涇炅烱璟璥瓊痙硬磬竟競絅經耕耿脛莖警輕逕鏡頃頸驚鯨冏剄哽惸憼扃檠煢焭熲畊竸綆顈罄褧謦駉鯁黥\n";
    str += (char const *)u8"&계<<*係啓堺契季屆悸戒桂械棨溪界癸磎稽系繫繼計誡谿階鷄堦烓瘈禊筓綮縘罽葪薊雞髻\n";
    str += (char const *)u8"&고<<*古叩告呱固姑孤尻庫拷攷故敲暠枯槁沽痼皐睾稿羔考股膏苦苽菰藁蠱袴誥辜錮雇顧高鼓估凅刳塙杲栲槀槹櫜牯皋盬瞽稁箍篙糕罟羖翺胯觚詁郜酤鈷靠鴣鷱\n";
    str += (char const *)u8"&곡<<*哭斛曲梏穀谷鵠嚳槲縠觳轂\n";
    str += (char const *)u8"&곤<<*困坤崑昆梱棍滾琨袞鯤堃崐悃捆緄衮裍褌錕閫髡鵾鶤齫\n";
    str += (char const *)u8"&골<<*汨骨搰榾矻鶻\n";
    str += (char const *)u8"&공<<*供公共功孔工恐恭拱控攻珙空蚣貢鞏倥崆悾栱槓箜蛩蛬贛跫釭龔\n";
    str += (char const *)u8"&곶<<串\n";
    str += (char const *)u8"&과<<*寡戈果瓜科菓誇課跨過鍋顆侉堝夥夸撾猓稞窠蝌裹踝銙騍\n";
    str += (char const *)u8"&곽<<*廓槨藿郭椁癨躩霍鞹\n";
    str += (char const *)u8"&관<<*冠官寬慣棺款灌琯瓘管罐菅觀貫關館丱涫爟盥祼窾筦綰輨錧鑵雚顴髖鸛\n";
    str += (char const *)u8"&괄<<*刮恝括适佸栝筈聒髺鴰\n";
    str += (char const *)u8"&광<<*侊光匡壙廣曠洸炚狂珖筐胱鑛恇桄框爌獷磺絖纊茪誆誑\n";
    str += (char const *)u8"&괘<<*卦掛罫咼挂罣詿\n";
    str += (char const *)u8"&괴<<*乖傀塊壞怪愧拐槐魁媿廥恠瑰璝蒯襘\n";
    str += (char const *)u8"&괵<<馘\n";
    str += (char const *)u8"&굉<<*宏紘肱轟浤觥訇閎\n";
    str += (char const *)u8"&교<<*交僑咬喬嬌嶠巧攪敎校橋狡皎矯絞翹膠蕎蛟較轎郊餃驕鮫佼嘄嘐噭嚙姣憍撟晈暞榷磽窖趫蹻鉸骹鵁齩\n";
    str += (char const *)u8"&구<<*丘久九仇俱具勾區口句咎嘔坵垢寇嶇廐懼拘救枸柩構歐毆毬求溝灸狗玖球瞿矩究絿耉臼舅舊苟衢謳購軀逑邱鉤銶駒驅鳩鷗龜佉佝俅傴冓劬匶厹叴坸姤媾嫗屨岣彀戵扣捄搆摳昫榘漚璆甌疚痀癯窛窶篝糗胊蒟蚯裘覯詬遘釦韝韭韮颶駈鬮鷇鸜\n";
    str += (char const *)u8"&국<<*國局菊鞠鞫麴匊掬跼麯\n";
    str += (char const *)u8"&군<<*君窘群裙軍郡捃桾皸\n";
    str += (char const *)u8"&굴<<*堀屈掘窟倔崛淈詘\n";
    str += (char const *)u8"&궁<<*宮弓穹窮芎躬躳\n";
    str += (char const *)u8"&권<<*倦券勸卷圈拳捲權淃眷勌惓棬睠綣蜷\n";
    str += (char const *)u8"&궐<<*厥獗蕨蹶闕\n";
    str += (char const *)u8"&궤<<*机櫃潰詭軌饋佹几劂匱憒撅樻氿簋繢跪闠餽麂\n";
    str += (char const *)u8"&귀<<*晷歸貴鬼\n";
    str += (char const *)u8"&규<<*叫圭奎揆槻珪硅窺竅糾葵規赳逵閨刲嫢嬀巋暌楏樛潙睽糺虬虯跬邽闚頍馗\n";
    str += (char const *)u8"&균<<*勻均畇筠菌鈞囷麏\n";
    str += (char const *)u8"&귤<<橘\n";
    str += (char const *)u8"&극<<*克剋劇戟棘極隙亟尅屐郄\n";
    str += (char const *)u8"&근<<*僅劤勤懃斤根槿瑾筋芹菫覲謹近饉卺厪墐巹廑漌觔跟釿靳\n";
    str += (char const *)u8"&금<<*今妗擒昑檎琴禁禽芩衾衿襟錦唫噤嶔笒黅\n";
    str += (char const *)u8"&급<<*伋及急扱汲級給圾岌皀礏笈芨\n";
    str += (char const *)u8"&긍<<*亘兢矜肯亙殑\n";
    str += (char const *)u8"&기<<*企伎其冀嗜器圻基埼夔奇妓寄岐崎己幾忌技旗旣朞期杞棋棄機欺氣汽沂淇玘琦琪璂璣畸畿碁磯祁祇祈祺箕紀綺羈耆耭肌記譏豈起錡錤飢饑騎騏驥麒僛剞墍屺庋弃忮愭掎攲旂暣曁棊歧炁猉禨綥綦羇肵芪芰蘄虁蜝蟣覉覬跂隑頎鬐鰭黖\n";
    str += (char const *)u8"&긴<<緊\n";
    str += (char const *)u8"&길<<*佶吉拮桔姞蛣\n";
    str += (char const *)u8"&김<<金\n";
    str += (char const *)u8"&끽<<喫\n";
    str += (char const *)u8"&나<<*儺娜懦拏拿那挐挪梛糥糯\n";
    str += (char const *)u8"&낙<<諾\n";
    str += (char const *)u8"&난<<*暖煖難偄煗赧餪\n";
    str += (char const *)u8"&날<<*捏捺\n";
    str += (char const *)u8"&남<<*南枏楠湳男喃柟\n";
    str += (char const *)u8"&납<<*納衲\n";
    str += (char const *)u8"&낭<<*囊娘曩\n";
    str += (char const *)u8"&내<<*乃內奈柰耐匂奶嬭迺鼐\n";
    str += (char const *)u8"&녀<<女\n";
    str += (char const *)u8"&녁<<惄\n";
    str += (char const *)u8"&년<<*年撚秊碾\n";
    str += (char const *)u8"&념<<*念恬拈捻\n";
    str += (char const *)u8"&녕<<*寧寗佞儜嚀濘\n";
    str += (char const *)u8"&노<<*努奴弩怒瑙駑呶孥峱猱笯臑\n";
    str += (char const *)u8"&농<<*濃膿農儂噥穠醲\n";
    str += (char const *)u8"&뇌<<*惱腦餒\n";
    str += (char const *)u8"&뇨<<*尿嫋嬲淖磠裊鐃\n";
    str += (char const *)u8"&누<<*啂耨\n";
    str += (char const *)u8"&눈<<嫩\n";
    str += (char const *)u8"&눌<<*訥吶肭\n";
    str += (char const *)u8"&뉴<<*杻紐忸靵\n";
    str += (char const *)u8"&뉵<<衄\n";
    str += (char const *)u8"&능<<能\n";
    str += (char const *)u8"&니<<*尼泥呢怩柅祢禰膩\n";
    str += (char const *)u8"&닉<<*匿溺昵暱\n";
    str += (char const *)u8"&다<<*多茶爹\n";
    str += (char const *)u8"&단<<*丹亶但單團壇彖斷旦檀段湍短端簞緞蛋袒鄲鍛慱担椴漙癉耑胆腶蜑\n";
    str += (char const *)u8"&달<<*撻澾獺疸達妲怛闥靼韃\n";
    str += (char const *)u8"&담<<*啖坍憺擔曇淡湛潭澹痰聃膽蕁覃談譚錟儋啗噉墰壜毯禫罎薝郯黮黵\n";
    str += (char const *)u8"&답<<*沓畓答踏遝\n";
    str += (char const *)u8"&당<<*唐堂塘幢戇撞棠當糖螳黨倘儻党搪檔溏瑭璫瞠礑蟷襠讜鏜鐺餳餹\n";
    str += (char const *)u8"&대<<*代垈坮大對岱帶待戴擡玳臺袋貸隊黛儓懟旲汏碓鐓\n";
    str += (char const *)u8"&댁<<宅\n";
    str += (char const *)u8"&덕<<*德悳\n";
    str += (char const *)u8"&도<<*倒刀到圖堵塗導屠島嶋度徒悼挑掉搗桃棹櫂淘渡滔濤燾盜睹禱稻萄覩賭跳蹈逃途道都鍍陶韜叨壔弢忉慆掏搯擣檮洮涂稌菟酴闍鞀鞱饕鼗\n";
    str += (char const *)u8"&독<<*毒瀆牘犢獨督禿篤纛讀櫝黷\n";
    str += (char const *)u8"&돈<<*墩惇敦旽暾沌焞燉豚頓弴潡躉\n";
    str += (char const *)u8"&돌<<*乭突咄堗\n";
    str += (char const *)u8"&동<<*仝冬凍動同憧東桐棟洞潼疼瞳童胴董銅侗僮哃垌峒彤朣橦涷艟苳茼蕫蝀錬鮗\n";
    str += (char const *)u8"&두<<*兜斗杜枓痘竇荳豆逗頭抖斁肚脰蚪蠹陡\n";
    str += (char const *)u8"&둔<<*屯臀芚遁遯鈍窀迍\n";
    str += (char const *)u8"&둘<<乧\n";
    str += (char const *)u8"&득<<得\n";
    str += (char const *)u8"&등<<*嶝橙燈登等藤謄鄧騰凳墱滕磴籐縢螣鐙\n";
    str += (char const *)u8"&라<<*喇懶癩羅蘿螺裸邏倮囉曪瘰砢臝鑼騾驘\n";
    str += (char const *)u8"&락<<*洛烙珞絡落酪駱嗠犖\n";
    str += (char const *)u8"&란<<*亂卵欄欒瀾爛蘭鸞嬾幱攔灓襴鑾闌\n";
    str += (char const *)u8"&랄<<*剌辣埒辢\n";
    str += (char const *)u8"&람<<*嵐擥攬欖濫籃纜藍襤覽婪惏\n";
    str += (char const *)u8"&랍<<*拉臘蠟鑞\n";
    str += (char const *)u8"&랑<<*廊朗浪狼琅瑯螂郞榔硠稂莨蜋閬\n";
    str += (char const *)u8"&래<<*來崍徠萊淶騋\n";
    str += (char const *)u8"&랭<<冷\n";
    str += (char const *)u8"&략<<*掠略畧\n";
    str += (char const *)u8"&량<<*亮倆兩凉梁樑粮粱糧良諒輛量喨悢椋涼踉魎\n";
    str += (char const *)u8"&려<<*侶儷勵呂廬慮戾旅櫚濾礪藜蠣閭驢驪麗黎儢厲唳梠癘糲膂臚蠡邌鑢\n";
    str += (char const *)u8"&력<<*力曆歷瀝礫轢靂攊櫟櫪癧轣酈\n";
    str += (char const *)u8"&련<<*憐戀攣漣煉璉練聯蓮輦連鍊孌楝湅臠鏈鰊鰱\n";
    str += (char const *)u8"&렬<<*冽列劣洌烈裂挒捩颲\n";
    str += (char const *)u8"&렴<<*廉斂殮濂簾奩瀲磏\n";
    str += (char const *)u8"&렵<<*獵躐鬣\n";
    str += (char const *)u8"&령<<*令伶囹岺嶺怜玲笭羚翎聆逞鈴零靈領齡另呤姈岭昤欞泠秢苓蛉軨鴒鹷\n";
    str += (char const *)u8"&례<<*例澧禮醴隷隸鱧\n";
    str += (char const *)u8"&로<<*勞撈擄櫓潞瀘爐盧老蘆虜路輅露魯鷺鹵壚滷玈癆窂艪艫轤鐪鑪顱髗鱸鸕\n";
    str += (char const *)u8"&록<<*碌祿綠菉錄鹿麓圥彔淥漉簏轆騄\n";
    str += (char const *)u8"&론<<論\n";
    str += (char const *)u8"&롱<<*壟弄朧瀧瓏籠聾儱攏曨礱蘢隴龎\n";
    str += (char const *)u8"&뢰<<*儡瀨牢磊賂賚賴雷攂礌礧籟纇罍耒蕾誄酹顂\n";
    str += (char const *)u8"&료<<*了僚寮廖料燎療瞭聊蓼遼鬧嘹嫽撩暸潦獠繚膋醪鐐飂飉\n";
    str += (char const *)u8"&룡<<*龍龒\n";
    str += (char const *)u8"&루<<*壘婁屢樓淚漏瘻累縷蔞褸鏤陋僂嘍嶁慺耬螻髏\n";
    str += (char const *)u8"&류<<*劉旒柳榴流溜瀏琉瑠留瘤硫謬類橊縲纍遛鶹\n";
    str += (char const *)u8"&륙<<*六戮陸勠\n";
    str += (char const *)u8"&륜<<*侖倫崙淪綸輪掄\n";
    str += (char const *)u8"&률<<*律慄栗嵂溧\n";
    str += (char const *)u8"&륭<<*隆癃窿\n";
    str += (char const *)u8"&륵<<*勒肋泐\n";
    str += (char const *)u8"&름<<*凜凛廩澟\n";
    str += (char const *)u8"&릉<<*凌楞稜綾菱陵倰蔆\n";
    str += (char const *)u8"&리<<*俚利厘吏唎履悧李梨浬犁狸理璃痢籬罹羸莉裏裡里釐離鯉俐剺哩嫠涖漓离莅蜊螭貍邐魑黐\n";
    str += (char const *)u8"&린<<*吝潾燐璘藺躪隣鱗麟嶙悋獜磷粦粼繗躙轔鄰鏻驎\n";
    str += (char const *)u8"&림<<*林淋琳臨霖痳\n";
    str += (char const *)u8"&립<<*砬立笠粒岦\n";
    str += (char const *)u8"&마<<*摩瑪痲碼磨馬魔麻劘媽螞蟇麽麿\n";
    str += (char const *)u8"&막<<*寞幕漠膜莫邈瞙鏌\n";
    str += (char const *)u8"&만<<*万卍娩巒彎慢挽晩曼滿漫灣瞞萬蔓蠻輓饅鰻墁嫚幔縵謾蹣鏋鏝鬘\n";
    str += (char const *)u8"&말<<*唜抹末沫茉襪靺帕秣\n";
    str += (char const *)u8"&망<<*亡妄忘忙望網罔芒茫莽輞邙惘汒漭莾蟒魍\n";
    str += (char const *)u8"&매<<*埋妹媒寐昧枚梅每煤罵買賣邁魅呆楳沬玫眛苺莓酶霉\n";
    str += (char const *)u8"&맥<<*脈貊陌驀麥脉貃貘\n";
    str += (char const *)u8"&맹<<*孟氓猛盲盟萌儚甍甿虻\n";
    str += (char const *)u8"&멱<<*冪覓幎糸\n";
    str += (char const *)u8"&면<<*免冕勉棉沔眄眠綿緬面麵俛湎糆緜麪\n";
    str += (char const *)u8"&멸<<*滅蔑篾衊\n";
    str += (char const *)u8"&명<<*冥名命明暝椧溟皿瞑茗蓂螟酩銘鳴洺\n";
    str += (char const *)u8"&몌<<袂\n";
    str += (char const *)u8"&모<<*侮冒募姆帽慕摸摹暮某模母毛牟牡瑁眸矛耗芼茅謀謨貌侔姥媢嫫恈旄皃眊粍糢耄蝥蟊鉾髦\n";
    str += (char const *)u8"&목<<*木沐牧目睦穆鶩凩苜\n";
    str += (char const *)u8"&몰<<*歿沒\n";
    str += (char const *)u8"&몽<<*夢朦蒙幪懞曚溕濛瞢矇艨雺鸏\n";
    str += (char const *)u8"&묘<<*卯墓妙廟描昴杳渺猫竗苗錨淼眇藐貓\n";
    str += (char const *)u8"&무<<*務巫憮懋戊拇撫无楙武毋無珷畝繆舞茂蕪誣貿霧鵡儛嘸廡膴騖\n";
    str += (char const *)u8"&묵<<*墨默嘿\n";
    str += (char const *)u8"&문<<*們刎吻問文汶紊紋聞蚊門雯匁悗懣抆捫炆璊\n";
    str += (char const *)u8"&물<<*勿沕物\n";
    str += (char const *)u8"&미<<*味媚尾嵋彌微未梶楣渼湄眉米美薇謎迷靡黴亹娓媄媺弥弭敉瀰獼糜縻苿蘼麋\n";
    str += (char const *)u8"&민<<*岷悶愍憫敏旻旼民泯玟珉緡閔忞忟暋湣緍罠苠閩鰵黽\n";
    str += (char const *)u8"&밀<<*密蜜謐樒滵\n";
    str += (char const *)u8"&박<<*剝博拍搏撲朴樸泊珀璞箔粕縛膊舶薄迫雹駁亳欂牔鎛駮髆\n";
    str += (char const *)u8"&반<<*伴半反叛拌搬攀斑槃泮潘班畔瘢盤盼磐磻礬絆般蟠返頒飯媻扳搫攽朌胖螌頖\n";
    str += (char const *)u8"&발<<*勃拔撥渤潑發跋醱鉢髮魃哱浡脖鈸鵓\n";
    str += (char const *)u8"&방<<*倣傍坊妨尨幇彷房放方旁昉枋榜滂磅紡肪膀舫芳蒡蚌訪謗邦防龐仿厖幫徬搒旊梆牓舽螃鎊髣魴\n";
    str += (char const *)u8"&배<<*倍俳培徘拜排杯湃焙盃背胚裴裵褙賠輩配陪坏坯扒琲蓓\n";
    str += (char const *)u8"&백<<*伯佰帛柏栢白百魄粨\n";
    str += (char const *)u8"&번<<*幡樊煩燔番繁蕃藩飜繙翻膰蘩袢\n";
    str += (char const *)u8"&벌<<*伐筏罰閥橃罸\n";
    str += (char const *)u8"&범<<*凡帆梵氾汎泛犯範范笵訉颿\n";
    str += (char const *)u8"&법<<*法琺\n";
    str += (char const *)u8"&벽<<*僻劈壁擘檗璧癖碧蘗闢霹擗甓疈襞鷿鼊\n";
    str += (char const *)u8"&변<<*卞弁變辨辯邊忭抃籩辮腁賆駢骿鴘\n";
    str += (char const *)u8"&별<<*別瞥鱉鼈彆鷩\n";
    str += (char const *)u8"&병<<*丙倂兵屛幷昞昺柄棅炳甁病秉竝輧餠騈並塀絣缾迸鈵鋲鉼\n";
    str += (char const *)u8"&보<<*保堡報寶普步洑湺潽珤甫菩補褓譜輔俌盙簠葆靌鴇黼\n";
    str += (char const *)u8"&복<<*伏僕匐卜宓復服福腹茯蔔複覆輹輻馥鰒墣幞扑濮箙菔蝠蝮鵩\n";
    str += (char const *)u8"&본<<本\n";
    str += (char const *)u8"&볼<<乶\n";
    str += (char const *)u8"&봉<<*俸奉封峯峰捧棒烽熢琫縫蓬蜂逢鋒鳳丰夆篷綘菶鴌\n";
    str += (char const *)u8"&부<<*不付俯傅剖副否咐埠夫婦孚孵富府扶敷斧浮溥父符簿缶腐腑膚艀芙莩訃負賦賻赴趺部釜阜附駙鳧仆俘媍抔拊掊桴榑涪玞祔筟罘罦胕芣苻蔀蚨蜉袝裒跗鈇頫鮒麩\n";
    str += (char const *)u8"&북<<北\n";
    str += (char const *)u8"&분<<*分吩噴墳奔奮忿憤扮昐汾焚盆粉糞紛芬賁雰体坌帉枌棻棼氛湓濆犇畚砏笨肦膹蕡轒黺鼢\n";
    str += (char const *)u8"&불<<*佛弗彿拂岪祓紱艴茀韍髴黻\n";
    str += (char const *)u8"&붕<<*崩朋棚硼繃鵬堋漰鬅\n";
    str += (char const *)u8"&비<<*丕備匕匪卑妃婢庇悲憊扉批斐枇榧比毖毗毘沸琵痺砒碑秕秘粃緋翡肥脾臂菲蜚裨誹譬費鄙非飛鼻仳俾剕圮埤妣屁庳悱棐椑沘淝淠濞狉狒痞痹睥祕篦紕羆腓芘芾萆蓖蚍貔贔轡邳郫閟陴霏鞴騑騛髀鼙\n";
    str += (char const *)u8"&빈<<*嚬嬪彬斌檳殯浜濱瀕牝玭貧賓頻儐擯矉繽臏蘋豳邠鑌霦顰鬂鬢\n";
    str += (char const *)u8"&빙<<*憑氷聘騁冰凭凴娉\n";
    str += (char const *)u8"&사<<*乍事些仕伺似使俟僿史司唆嗣四士奢娑寫寺射巳師徙思捨斜斯柶査梭死沙泗渣瀉獅砂社祀祠私篩紗絲肆舍莎蓑蛇裟詐詞謝賜赦辭邪飼駟麝傞剚卸咋姒楂榭汜痧皶竢笥缷蜡覗駛魦鯊鰤\n";
    str += (char const *)u8"&삭<<*削朔槊爍蒴鑠\n";
    str += (char const *)u8"&산<<*傘刪山散汕珊産疝算蒜酸霰剷姍孿橵潸澘狻繖訕鏟閊毿\n";
    str += (char const *)u8"&살<<*乷撒殺煞薩\n";
    str += (char const *)u8"&삼<<*三杉森渗芟蔘衫糝釤鬖\n";
    str += (char const *)u8"&삽<<*揷澁鈒颯卅唼歃翣鍤霅霎\n";
    str += (char const *)u8"&상<<*上傷像償商喪嘗孀尙峠常床庠廂想桑橡湘爽牀狀相祥箱翔裳觴詳象賞霜塽徜晌殤甞緗鎟顙鬺\n";
    str += (char const *)u8"&새<<*塞璽賽鰓\n";
    str += (char const *)u8"&색<<*嗇穡索色槭濇瀒\n";
    str += (char const *)u8"&생<<*牲生甥笙眚鉎\n";
    str += (char const *)u8"&서<<*墅壻嶼序庶徐恕抒捿敍暑曙書栖棲犀瑞筮絮緖署胥舒薯西誓逝鋤黍鼠噬婿揟撕湑澨紓耡芧鉏\n";
    str += (char const *)u8"&석<<*夕奭席惜昔晳析汐淅潟石碩蓆釋錫晰矽腊舃蜥鉐鼫\n";
    str += (char const *)u8"&선<<*仙僊先善嬋宣扇敾旋渲煽琁瑄璇璿癬禪線繕羨腺膳船蘚蟬詵跣選銑鐥饍鮮墡嫙尟尠屳愃歚熯筅綫譔譱鏇騸鱓鱻\n";
    str += (char const *)u8"&설<<*卨屑楔泄洩渫舌薛褻設說雪齧偰媟揲暬爇碟稧紲\n";
    str += (char const *)u8"&섬<<*剡暹殲纖蟾贍閃陝孅憸摻睒譫銛韱\n";
    str += (char const *)u8"&섭<<*攝涉燮囁懾灄聶躡鑷顳\n";
    str += (char const *)u8"&성<<*城姓宬性惺成星晟猩珹盛省筬聖聲腥誠醒瑆騂\n";
    str += (char const *)u8"&세<<*世勢歲洗稅笹細貰帨洒繐蛻\n";
    str += (char const *)u8"&소<<*召嘯塑宵小少巢所掃搔昭梳沼消溯瀟炤燒甦疏疎瘙笑篠簫素紹蔬蕭蘇訴逍遡邵銷韶騷佋俏卲嗉埽塐愬捎樔泝筱箾繅翛膆艘蛸踈酥霄魈鮹鰺\n";
    str += (char const *)u8"&속<<*俗屬束涑粟續謖贖速洬遬\n";
    str += (char const *)u8"&손<<*孫巽損蓀遜飡飧飱\n";
    str += (char const *)u8"&솔<<*率窣蟀\n";
    str += (char const *)u8"&송<<*宋悚松淞訟誦送頌柗竦鬆\n";
    str += (char const *)u8"&쇄<<*刷灑碎鎖惢曬瑣\n";
    str += (char const *)u8"&쇠<<*衰釗\n";
    str += (char const *)u8"&수<<*修受嗽囚垂壽嫂守岫峀帥愁戍手授搜收數樹殊水洙漱燧狩獸琇璲瘦睡秀穗竪粹綏綬繡羞脩茱蒐蓚藪袖誰讐輸遂邃酬銖銹隋隧隨雖需須首髓鬚叟售廋晬殳泅溲濉睟睢瞍祟籔脺膄膸讎豎陲颼饈\n";
    str += (char const *)u8"&숙<<*叔塾夙孰宿淑潚熟琡璹肅菽俶倏儵婌橚驌鷫\n";
    str += (char const *)u8"&순<<*巡徇循恂旬栒楯橓殉洵淳珣盾瞬筍純脣舜荀蓴蕣詢諄醇錞順馴侚狥盹眴紃肫駨鬊鶉\n";
    str += (char const *)u8"&술<<*戌術述鉥絉\n";
    str += (char const *)u8"&숭<<*崇崧嵩菘\n";
    str += (char const *)u8"&쉬<<*倅淬焠\n";
    str += (char const *)u8"&슬<<*瑟膝蝨虱\n";
    str += (char const *)u8"&습<<*濕拾習褶襲慴熠隰\n";
    str += (char const *)u8"&승<<*丞乘僧勝升承昇繩蠅陞塍鬙\n";
    str += (char const *)u8"&시<<*侍匙嘶始媤尸屎屍市弑恃施是時枾柴猜矢示翅蒔蓍視試詩諡豕豺偲兕厮啻塒廝枲柹澌緦翤諟諰豉釃鍉顋\n";
    str += (char const *)u8"&식<<*埴寔式息拭植殖湜熄篒蝕識軾食飾喰媳栻\n";
    str += (char const *)u8"&신<<*伸侁信呻娠宸愼新晨燼申神紳腎臣莘薪藎蜃訊身辛迅哂噺囟姺汛矧脤贐頣駪\n";
    str += (char const *)u8"&실<<*失室實悉蟋飋\n";
    str += (char const *)u8"&심<<*審尋心沁深瀋甚芯諶梣潯燖葚鐔鱏\n";
    str += (char const *)u8"&십<<*什十辻\n";
    str += (char const *)u8"&쌍<<雙\n";
    str += (char const *)u8"&씨<<氏\n";
    str += (char const *)u8"&아<<*亞俄兒啞娥峨我牙芽莪蛾衙訝阿雅餓鴉鵝丫哦娿婀峩疴砑笌迓錏鵞\n";
    str += (char const *)u8"&악<<*堊岳嶽幄惡愕握樂渥鄂鍔顎鰐齷偓卾咢喔噩腭萼覨諤鶚齶\n";
    str += (char const *)u8"&안<<*安岸按晏案眼雁鞍顔鮟桉犴贋鴈\n";
    str += (char const *)u8"&알<<*斡謁軋閼嘎戞揠穵訐遏頞鴶\n";
    str += (char const *)u8"&암<<*唵岩巖庵暗癌菴闇啽媕嵓晻腤葊蓭諳頷馣黯\n";
    str += (char const *)u8"&압<<*壓押狎鴨\n";
    str += (char const *)u8"&앙<<*仰央怏昻殃秧鴦卬坱泱盎鞅\n";
    str += (char const *)u8"&애<<*厓哀埃崖愛曖涯碍艾隘靄僾唉啀噯娭崕挨捱欸漄獃皚睚瞹磑礙薆藹靉騃\n";
    str += (char const *)u8"&액<<*厄扼掖液縊腋額呝戹搤阨\n";
    str += (char const *)u8"&앵<<*櫻罌鶯鸚嚶嫈罃鷪\n";
    str += (char const *)u8"&야<<*也倻冶夜惹揶椰爺耶野埜\n";
    str += (char const *)u8"&약<<*弱約若葯蒻藥躍爚禴篛籥鑰鰯鶸龠\n";
    str += (char const *)u8"&양<<*佯壤孃恙揚攘敭暘楊樣洋瀁煬痒瘍禳穰羊襄讓釀陽養徉漾瀼烊癢眻蘘輰鑲颺驤\n";
    str += (char const *)u8"&어<<*圄御於漁瘀禦語馭魚齬圉敔淤飫\n";
    str += (char const *)u8"&억<<*億憶抑檍臆繶\n";
    str += (char const *)u8"&언<<*偃堰彦焉言諺傿匽嫣讞鄢鼴鼹\n";
    str += (char const *)u8"&얼<<*孼蘖臬\n";
    str += (char const *)u8"&엄<<*俺儼嚴奄掩淹崦广曮罨醃閹\n";
    str += (char const *)u8"&업<<*嶪業嶫鄴\n";
    str += (char const *)u8"&에<<*恚曀\n";
    str += (char const *)u8"&엔<<円\n";
    str += (char const *)u8"&여<<*予余如歟汝璵礖與艅茹輿轝餘舁\n";
    str += (char const *)u8"&역<<*亦域役易疫繹譯逆驛嶧懌淢閾\n";
    str += (char const *)u8"&연<<*嚥堧姸娟宴延捐挻椽沇沿涎涓淵演烟然煙燃燕硏硯筵緣縯衍軟鉛鳶兗囦埏嬿悁掾曣櫞渷臙莚蜵蠕讌鷰\n";
    str += (char const *)u8"&열<<*悅涅熱閱噎\n";
    str += (char const *)u8"&염<<*厭染炎焰琰艶苒閻髥鹽冉塩懕扊檿檶灎灩釅饜魘黶\n";
    str += (char const *)u8"&엽<<*曄燁葉曅熀爗靨\n";
    str += (char const *)u8"&영<<*塋嶸影映暎楹榮永泳渶潁濚瀛瀯煐營獰瑛瓔盈穎纓英詠迎鍈霙咏嬴嬰浧濴癭碤縈蠑贏郢韺\n";
    str += (char const *)u8"&예<<*乂倪刈叡曳汭濊猊睿穢芮藝蘂裔詣譽豫銳霓預囈嫛拽掜枘獩睨瞖繄翳苅蕊蕋薉蚋蜺鯢鷖麑\n";
    str += (char const *)u8"&오<<*五伍俉傲午吾吳嗚塢墺奧娛寤悟懊敖旿晤梧汚澳烏熬獒筽蜈誤鰲鼇仵俣唔嗷噁圬媪嫯忤慠捂汙窹聱茣襖謷迃迕遨鏊鏖隩驁鼯\n";
    str += (char const *)u8"&옥<<*屋沃獄玉鈺\n";
    str += (char const *)u8"&온<<*溫瑥瘟穩縕蘊媼慍昷氳熅薀轀醞韞饂鰮\n";
    str += (char const *)u8"&올<<*兀嗢膃\n";
    str += (char const *)u8"&옹<<*壅擁瓮甕癰翁邕雍饔喁廱滃癕禺罋蓊雝顒\n";
    str += (char const *)u8"&와<<*渦瓦窩窪臥蛙蝸訛哇囮婐枙洼猧窊萵譌\n";
    str += (char const *)u8"&완<<*婉完宛梡椀浣玩琓琬碗緩翫脘腕莞豌阮頑刓垸妧岏忨惋涴盌\n";
    str += (char const *)u8"&왈<<曰\n";
    str += (char const *)u8"&왕<<*往旺枉汪王尫瀇迬\n";
    str += (char const *)u8"&왜<<*倭娃歪矮媧\n";
    str += (char const *)u8"&외<<*外嵬巍猥畏偎崴嵔渨煨碨磈聵隗\n";
    str += (char const *)u8"&요<<*僥凹堯夭妖姚寥嶢拗搖撓擾曜橈燿瑤窈窯繇繞耀腰蟯要謠遙邀饒偠喓坳墝嬈幺徭徼殀澆祅穾窅蕘遶鷂\n";
    str += (char const *)u8"&욕<<*慾欲浴縟褥辱溽蓐\n";
    str += (char const *)u8"&용<<*俑傭冗勇埇墉容庸慂榕涌湧溶熔瑢用甬聳茸蓉踊鎔鏞傛宂嵱慵憃槦硧舂蛹踴\n";
    str += (char const *)u8"&우<<*于佑偶優又友右宇寓尤愚憂旴牛玗瑀盂祐禑禹紆羽芋藕虞迂遇郵釪隅雨雩亏亴俁偊吁堣嵎庽杅疣盱竽耦耰謣踽鍝麀麌齲\n";
    str += (char const *)u8"&욱<<*勖彧旭昱栯煜稶郁頊燠\n";
    str += (char const *)u8"&운<<*云橒殞澐熉耘芸蕓運隕雲韻惲沄篔紜霣韵\n";
    str += (char const *)u8"&울<<*蔚鬱亐\n";
    str += (char const *)u8"&웅<<*熊雄\n";
    str += (char const *)u8"&원<<*元原員圓園垣媛嫄寃怨愿援沅洹湲源爰猿瑗苑袁轅遠院願鴛冤圜杬楥猨綩芫薗蜿謜鋺騵鵷黿\n";
    str += (char const *)u8"&월<<*月越鉞刖粤\n";
    str += (char const *)u8"&위<<*位偉僞危圍委威尉慰暐渭爲瑋緯胃萎葦蔿蝟衛褘謂違韋魏喟幃煒熨痿葳衞諉逶闈韙韡餧骪\n";
    str += (char const *)u8"&유<<*乳侑儒兪唯喩孺宥幼幽庾悠惟愈愉揄攸有柔柚楡楢油洧游濡猶猷瑜由癒維臾萸裕誘諛諭踰蹂遊逾遺酉釉鍮冘呦囿壝帷揉斿泑牖瘉瘐窬窳籲糅緌腴莠蕕蕤蚰蚴蝤褕讉逌鞣鮪黝鼬龥\n";
    str += (char const *)u8"&육<<*堉毓肉育儥\n";
    str += (char const *)u8"&윤<<*允奫尹潤玧胤贇鈗閏昀鋆\n";
    str += (char const *)u8"&율<<*聿潏矞\n";
    str += (char const *)u8"&융<<*戎瀜絨融狨\n";
    str += (char const *)u8"&은<<*垠恩慇殷誾銀隱听嚚圁垽憖檼溵狺珢癮訔鄞齗\n";
    str += (char const *)u8"&을<<*乙鳦\n";
    str += (char const *)u8"&음<<*吟淫蔭陰音飮喑崟廕愔霪\n";
    str += (char const *)u8"&읍<<*揖泣邑悒挹浥\n";
    str += (char const *)u8"&응<<*凝應膺鷹\n";
    str += (char const *)u8"&의<<*依倚儀宜意懿擬椅毅疑矣義艤薏蟻衣誼議醫儗凒劓嶷欹漪猗礒螘饐\n";
    str += (char const *)u8"&이<<*二以伊夷姨已弛彛怡爾珥異痍移而耳肄苡荑貽貳邇飴餌咿坨尔彝栮洟珆訑詑迤隶\n";
    str += (char const *)u8"&익<<*瀷益翊翌翼謚弋熤鷁\n";
    str += (char const *)u8"&인<<*人仁刃印咽因姻寅引忍湮絪茵蚓認靭靷仞堙夤婣扨氤洇禋籾芢裀\n";
    str += (char const *)u8"&일<<*一佚佾壹日溢逸鎰馹泆軼\n";
    str += (char const *)u8"&임<<*任壬妊姙恁稔荏賃絍衽銋飪\n";
    str += (char const *)u8"&입<<*入卄廿\n";
    str += (char const *)u8"&잉<<*仍剩孕芿媵\n";
    str += (char const *)u8"&자<<*仔刺咨姉姿子字孜恣慈滋炙煮玆瓷疵磁紫者自茨蔗藉諮資雌呰嬨孖孶柘泚牸眥眦粢耔胾茈茲莿虸觜訾貲赭鎡頿髭鮓鶿鷓\n";
    str += (char const *)u8"&작<<*作勺嚼斫昨灼炸爵綽芍酌雀鵲岝怍斱柞汋焯犳碏\n";
    str += (char const *)u8"&잔<<*孱棧殘潺盞剗戔驏\n";
    str += (char const *)u8"&잠<<*岑暫潛箴簪蠶涔潜濳\n";
    str += (char const *)u8"&잡<<*雜卡囃眨磼襍\n";
    str += (char const *)u8"&장<<*丈仗匠場墻壯奬將帳庄張掌暲杖樟檣欌漿牆獐璋章粧腸臟臧莊葬蔣薔藏裝贓醬長障傽奘妝嬙嶂廧戕漳牂瘴糚羘萇装賬鄣鏘餦麞\n";
    str += (char const *)u8"&재<<*再哉在宰才材栽梓渽滓災縡裁財載齋齎夈崽扗榟灾纔\n";
    str += (char const *)u8"&쟁<<*爭箏諍錚崢猙琤鎗\n";
    str += (char const *)u8"&저<<*佇低儲咀姐底抵杵楮樗沮渚狙猪疽箸紵苧菹著藷詛貯躇這邸雎齟宁岨杼柢氐潴瀦牴罝羝苴蛆袛褚觝詆豬陼\n";
    str += (char const *)u8"&적<<*勣吊嫡寂摘敵滴狄的積笛籍績翟荻謫賊赤跡蹟迪迹適鏑樀磧糴菂覿逖馰\n";
    str += (char const *)u8"&전<<*佃佺傳全典前剪塡塼奠專展廛悛戰栓殿氈澱煎琠田甸畑癲筌箋箭篆纏詮輾轉鈿銓錢鐫電顚顫餞吮囀嫥屇巓戩揃旃栴槇湔澶牋瑱甎畋畠痊癜磚籛羶翦腆膞荃躔輇邅鄽鋑錪靛靦顓飦餰鬋鱣鸇\n";
    str += (char const *)u8"&절<<*切截折浙癤竊節絶岊晢窃\n";
    str += (char const *)u8"&점<<*占岾店漸点粘霑鮎點佔墊玷笘簟苫蔪蛅覘颭黏\n";
    str += (char const *)u8"&접<<*接摺蝶椄楪蜨跕蹀鰈\n";
    str += (char const *)u8"&정<<*丁井亭停偵呈姃定幀庭廷征情挺政整旌晶晸柾楨檉正汀淀淨渟湞瀞炡玎珽町睛碇禎程穽精綎艇訂諪貞鄭酊釘鉦鋌錠霆靖靜頂鼎佂叮婧婷怔掟桯梃棖灯珵疔筳莛証遉酲鋥靚\n";
    str += (char const *)u8"&제<<*制劑啼堤帝弟悌提梯濟祭第臍薺製諸蹄醍除際霽題齊儕娣擠猘瑅睇禔稊緹踶蹏躋鍗隄韲鮧鯷\n";
    str += (char const *)u8"&조<<*俎兆凋助嘲弔彫措操早晁曺曹朝條棗槽漕潮照燥爪璪眺祖祚租稠窕粗糟組繰肇藻蚤詔調趙躁造遭釣阻雕鳥佻傮刁厝嘈噪嬥徂懆找殂澡琱皁祧竈笊糙糶絩絛胙臊艚蔦蜩誂譟鈟銚鋽鯛鵰鼂\n";
    str += (char const *)u8"&족<<*族簇足鏃瘯\n";
    str += (char const *)u8"&존<<*存尊拵\n";
    str += (char const *)u8"&졸<<*卒拙猝\n";
    str += (char const *)u8"&종<<*倧宗從悰慫棕淙琮種終綜縱腫踪踵鍾鐘伀慒柊椶樅瑽瘇粽螽蹤\n";
    str += (char const *)u8"&좌<<*佐坐左座挫剉痤莝髽\n";
    str += (char const *)u8"&죄<<罪\n";
    str += (char const *)u8"&주<<*主住侏做姝胄呪周嗾奏宙州廚晝朱柱株注洲湊澍炷珠疇籌紂紬綢舟蛛註誅走躊輳週酎酒鑄駐丟侜儔尌幬拄硃籒肘腠蔟蛀裯詋賙趎輈遒鉒霌霔鼄\n";
    str += (char const *)u8"&죽<<*竹粥\n";
    str += (char const *)u8"&준<<*俊儁准埈寯峻晙樽浚準濬焌畯竣蠢逡遵雋駿噂埻墫惷撙皴綧罇踆蹲鐏隼餕鱒鵔\n";
    str += (char const *)u8"&줄<<*茁乼\n";
    str += (char const *)u8"&중<<*中仲衆重眾\n";
    str += (char const *)u8"&즉<<*卽即喞\n";
    str += (char const *)u8"&즐<<*櫛騭\n";
    str += (char const *)u8"&즙<<*楫汁葺檝蕺\n";
    str += (char const *)u8"&증<<*增憎曾拯烝甑症繒蒸證贈嶒矰罾\n";
    str += (char const *)u8"&지<<*之只咫地址志持指摯支旨智枝枳止池沚漬知砥祉祗紙肢脂至芝芷蜘誌贄趾遲坻墀扺榰泜痣秪篪舐踟躓軹阯鮨鷙\n";
    str += (char const *)u8"&직<<*直稙稷織職禝\n";
    str += (char const *)u8"&진<<*唇嗔塵振搢晉晋桭榛殄津溱珍瑨璡畛疹盡眞瞋秦縉縝臻蔯袗診賑軫辰進鎭陣陳震侲儘珒稹蓁螴趁鉁鬒\n";
    str += (char const *)u8"&질<<*侄叱姪嫉帙桎瓆疾秩窒膣蛭質跌迭垤絰蒺郅鑕\n";
    str += (char const *)u8"&짐<<*斟朕鴆\n";
    str += (char const *)u8"&집<<*執潗緝輯鏶集咠戢\n";
    str += (char const *)u8"&징<<*徵懲澄澂瀓癥瞪\n";
    str += (char const *)u8"&차<<*且侘借叉嗟嵯差次此磋箚蹉車遮佽偖奓岔徣槎瑳硨\n";
    str += (char const *)u8"&착<<*捉搾着窄錯鑿齪戳擉斲\n";
    str += (char const *)u8"&찬<<*撰澯燦璨瓚竄簒纂粲纘讚贊鑽餐饌儧儹劗巑攢欑爨趲\n";
    str += (char const *)u8"&찰<<*刹察擦札紮扎拶\n";
    str += (char const *)u8"&참<<*僭參塹慘慙懺斬站讒讖儳叅嶄巉慚憯攙槧欃毚譖鏨鑱饞驂黲\n";
    str += (char const *)u8"&창<<*倉倡創唱娼廠彰愴敞昌昶暢槍滄漲猖瘡窓脹艙菖蒼倀傖凔刱悵惝戧搶椙氅瑲窗窻蹌鋹錆閶鬯鶬\n";
    str += (char const *)u8"&채<<*債埰寀寨彩採砦綵菜蔡采釵棌茝\n";
    str += (char const *)u8"&책<<*冊柵策責嘖幘磔笧簀蚱\n";
    str += (char const *)u8"&처<<*凄妻悽處淒萋褄覷郪\n";
    str += (char const *)u8"&척<<*倜剔尺慽戚拓擲斥滌瘠脊蹠陟隻呎坧塉惕捗摭蜴跖躑\n";
    str += (char const *)u8"&천<<*仟千喘天川擅泉淺玔穿舛薦賤踐遷釧闡阡韆俴倩僢儃洊濺瓩祆粁臶芊茜荐蒨蕆蚕辿靝\n";
    str += (char const *)u8"&철<<*凸哲喆徹撤澈綴輟轍鐵剟啜埑惙掇歠銕錣飻餮\n";
    str += (char const *)u8"&첨<<*僉尖沾添甛瞻簽籤詹諂幨忝惉檐櫼瀸簷襜\n";
    str += (char const *)u8"&첩<<*堞妾帖捷牒疊睫諜貼輒倢呫喋怗褺\n";
    str += (char const *)u8"&청<<*廳晴淸聽菁請靑鯖凊圊蜻鶄\n";
    str += (char const *)u8"&체<<*剃替涕滯締諦逮遞體嚏彘棣殢砌蒂蔕蕞軆靆髰\n";
    str += (char const *)u8"&초<<*初剿哨憔抄招梢椒楚樵炒焦硝礁礎秒稍肖艸苕草蕉貂超酢醋醮偢僬劭勦噍嫶岧峭嶕怊悄愀杪燋綃耖誚譙趠軺迢鈔鍫鍬鞘顦髫鷦齠\n";
    str += (char const *)u8"&촉<<*促囑燭矗蜀觸曯爥矚薥躅髑\n";
    str += (char const *)u8"&촌<<*寸忖村邨吋\n";
    str += (char const *)u8"&총<<*叢塚寵悤憁摠總聰蔥銃葱蓯鏦騘驄\n";
    str += (char const *)u8"&촬<<撮\n";
    str += (char const *)u8"&최<<*催崔最嘬摧榱漼璀磪縗脧\n";
    str += (char const *)u8"&추<<*墜抽推椎楸樞湫皺秋芻萩諏趨追鄒酋醜錐錘鎚雛騶鰍僦啾娵帚惆捶揫搥甃瘳龝箒箠簉縋縐蒭陬隹鞦騅魋鰌鵻鶖鶵麄麤\n";
    str += (char const *)u8"&축<<*丑畜祝竺筑築縮蓄蹙蹴軸逐妯舳豖蹜鼀\n";
    str += (char const *)u8"&춘<<*春椿瑃\n";
    str += (char const *)u8"&출<<*出朮黜秫\n";
    str += (char const *)u8"&충<<*充忠沖蟲衝衷冲忡珫\n";
    str += (char const *)u8"&췌<<*悴膵萃贅惴揣疩瘁顇\n";
    str += (char const *)u8"&취<<*取吹嘴娶就炊翠聚脆臭趣醉驟鷲冣橇毳\n";
    str += (char const *)u8"&측<<*側仄厠惻測廁昃\n";
    str += (char const *)u8"&층<<層\n";
    str += (char const *)u8"&치<<*侈値嗤峙幟恥梔治淄熾痔痴癡稚穉緇緻置致蚩輜雉馳齒卮哆寘巵畤痓絺菑薙褫豸跱錙阤鯔鴙鴟鵄\n";
    str += (char const *)u8"&칙<<*則勅飭敕\n";
    str += (char const *)u8"&친<<*親櫬藽襯齔\n";
    str += (char const *)u8"&칠<<*七柒漆\n";
    str += (char const *)u8"&침<<*侵寢枕沈浸琛砧針鍼寖忱椹沉郴鋟駸\n";
    str += (char const *)u8"&칩<<蟄\n";
    str += (char const *)u8"&칭<<*秤稱\n";
    str += (char const *)u8"&쾌<<*快噲夬\n";
    str += (char const *)u8"&타<<*他咤唾墮妥惰打拖朶楕舵陀馱駝佗垞拕柁橢沱詫跎躱駞鮀鴕鼉\n";
    str += (char const *)u8"&탁<<*倬卓啄坼托擢晫柝濁濯琢琸託鐸拆橐沰涿矺籜蘀踔逴\n";
    str += (char const *)u8"&탄<<*呑嘆坦彈憚歎灘炭綻誕憻攤殫癱驒\n";
    str += (char const *)u8"&탈<<*奪脫侻\n";
    str += (char const *)u8"&탐<<*探眈耽貪嗿忐酖\n";
    str += (char const *)u8"&탑<<*塔搭榻傝塌搨\n";
    str += (char const *)u8"&탕<<*宕帑湯蕩燙盪碭蘯\n";
    str += (char const *)u8"&태<<*兌台太怠態殆汰泰笞胎苔跆邰颱埭娧孡抬迨駄駘\n";
    str += (char const *)u8"&택<<*擇澤\n";
    str += (char const *)u8"&탱<<*撑撐牚\n";
    str += (char const *)u8"&터<<攄\n";
    str += (char const *)u8"&토<<*兎吐土討\n";
    str += (char const *)u8"&톤<<*噋噸瓲\n";
    str += (char const *)u8"&통<<*慟桶痛筒統通恫樋筩\n";
    str += (char const *)u8"&퇴<<*堆槌腿褪退頹隤\n";
    str += (char const *)u8"&투<<*偸套妬投透鬪妒渝骰\n";
    str += (char const *)u8"&퉁<<佟\n";
    str += (char const *)u8"&특<<*慝特忒\n";
    str += (char const *)u8"&틈<<闖\n";
    str += (char const *)u8"&파<<*坡婆巴把播擺杷波派爬琶破罷芭跛頗叵妑岥怕灞爸玻皤笆簸耙菠葩鄱\n";
    str += (char const *)u8"&판<<*判坂板版瓣販辦鈑阪汴\n";
    str += (char const *)u8"&팔<<*八叭捌朳汃\n";
    str += (char const *)u8"&패<<*佩唄悖敗沛浿牌狽稗覇貝孛旆珮霈霸\n";
    str += (char const *)u8"&팽<<*彭澎烹膨砰祊蟚蟛\n";
    str += (char const *)u8"&퍅<<愎\n";
    str += (char const *)u8"&편<<*便偏扁片篇編翩遍鞭騙匾徧惼緶艑萹蝙褊諞\n";
    str += (char const *)u8"&폄<<*貶砭窆\n";
    str += (char const *)u8"&평<<*坪平枰萍評怦抨泙苹蓱鮃\n";
    str += (char const *)u8"&폐<<*吠嬖幣廢弊斃肺蔽閉陛敝狴獘癈\n";
    str += (char const *)u8"&포<<*佈包匍匏咆哺圃布怖抛抱捕泡浦疱砲胞脯苞葡蒲袍褒逋鋪飽鮑儤庖晡曓炮炰舖誧鉋鞄餔鯆\n";
    str += (char const *)u8"&폭<<*幅暴曝瀑爆\n";
    str += (char const *)u8"&표<<*俵剽彪慓杓標漂瓢票表豹飇飄驃僄勡嘌嫖摽殍熛縹裱鏢鑣髟鰾\n";
    str += (char const *)u8"&품<<*品稟禀\n";
    str += (char const *)u8"&풍<<*楓諷豊風馮瘋葑\n";
    str += (char const *)u8"&피<<*彼披疲皮被避陂詖辟鞁髲\n";
    str += (char const *)u8"&픽<<腷\n";
    str += (char const *)u8"&필<<*匹弼必泌珌畢疋筆苾馝佖咇滭篳罼蓽觱蹕鞸韠駜鵯\n";
    str += (char const *)u8"&핍<<*乏逼偪\n";
    str += (char const *)u8"&하<<*下何厦夏廈昰河瑕荷蝦賀遐霞鰕呀嚇岈懗煆瘕罅鍜\n";
    str += (char const *)u8"&학<<*壑學虐謔鶴狢瘧皬确郝鷽\n";
    str += (char const *)u8"&한<<*寒恨悍旱汗漢澣瀚罕翰閑閒限韓僩嫺嫻捍暵閈駻鷳鼾\n";
    str += (char const *)u8"&할<<*割轄瞎\n";
    str += (char const *)u8"&함<<*函含咸啣喊檻涵緘艦銜陷鹹莟菡諴轞闞\n";
    str += (char const *)u8"&합<<*合哈盒蛤閤闔陜匌嗑柙榼溘盍郃\n";
    str += (char const *)u8"&항<<*亢伉姮嫦巷恒抗杭桁沆港缸肛航項夯恆炕缿頏\n";
    str += (char const *)u8"&해<<*亥偕咳垓奚孩害懈楷海瀣蟹解該諧邂駭骸咍嶰廨欬獬瑎痎薤醢頦鮭\n";
    str += (char const *)u8"&핵<<*劾核翮覈\n";
    str += (char const *)u8"&행<<*倖幸杏荇行悻\n";
    str += (char const *)u8"&향<<*享向嚮珦鄕響餉饗香薌\n";
    str += (char const *)u8"&허<<*噓墟虛許歔\n";
    str += (char const *)u8"&헌<<*憲櫶獻軒巚幰攇\n";
    str += (char const *)u8"&헐<<歇\n";
    str += (char const *)u8"&험<<*險驗嶮獫玁\n";
    str += (char const *)u8"&혁<<*奕爀赫革弈洫焱鬩\n";
    str += (char const *)u8"&현<<*俔峴弦懸晛泫炫玄玹現眩睍絃絢縣舷衒賢鉉顯儇嬛昡琄痃県繯翾蜆誢鋗駽\n";
    str += (char const *)u8"&혈<<*孑穴血頁絜趐\n";
    str += (char const *)u8"&혐<<嫌\n";
    str += (char const *)u8"&협<<*俠協夾峽挾浹狹脅脇莢鋏頰匧叶埉恊悏愜篋\n";
    str += (char const *)u8"&형<<*亨兄刑型形泂滎瀅灐炯熒珩瑩荊螢衡逈邢鎣馨夐娙詗迥陘\n";
    str += (char const *)u8"&혜<<*兮彗惠慧暳蕙蹊醯鞋傒嘒寭徯槥盻謑譿\n";
    str += (char const *)u8"&호<<*乎互呼壕壺好岵弧戶扈昊晧毫浩淏湖滸澔濠濩灝狐琥瑚瓠皓祜糊縞胡芦葫蒿虎號蝴護豪鎬頀顥儫冱嘷嫭嫮怙沍滈滬犒猢皜皞箎聕醐餬鬍\n";
    str += (char const *)u8"&혹<<*惑或酷\n";
    str += (char const *)u8"&혼<<*婚昏混渾琿魂圂惛溷焜閽\n";
    str += (char const *)u8"&홀<<*忽惚笏囫\n";
    str += (char const *)u8"&홍<<*哄弘汞泓洪烘紅虹訌鴻晎澒篊鉷鬨\n";
    str += (char const *)u8"&화<<*化和嬅樺火畵禍禾花華話譁貨靴俰嘩婲擭畫驊龢\n";
    str += (char const *)u8"&확<<*擴攫確碻穫矍矡礭鑊\n";
    str += (char const *)u8"&환<<*丸喚奐宦幻患換歡晥桓渙煥環紈還驩鰥寰懽擐瓛皖睆絙豢轘鍰鐶鬟\n";
    str += (char const *)u8"&활<<*活滑猾豁闊蛞\n";
    str += (char const *)u8"&황<<*凰幌徨恍惶愰慌晃晄榥況湟滉潢煌璜皇篁簧荒蝗遑隍黃喤媓怳瑝肓貺鎤\n";
    str += (char const *)u8"&회<<*匯回廻徊恢悔懷晦會檜淮澮灰獪繪膾茴蛔誨賄佪栃洄滙盔詼迴頮鱠\n";
    str += (char const *)u8"&획<<*劃獲嚄\n";
    str += (char const *)u8"&횡<<*宖橫鐄澋鈜黌\n";
    str += (char const *)u8"&효<<*哮嚆孝效斅曉梟涍淆爻肴酵驍傚囂崤殽熇皛虓餚\n";
    str += (char const *)u8"&후<<*侯候厚后吼喉嗅帿後朽煦珝逅吽喣垕堠涸猴篌詡譃酗餱\n";
    str += (char const *)u8"&훈<<*勛勳塤壎焄熏燻薰訓暈曛爋獯纁葷鑂\n";
    str += (char const *)u8"&훌<<欻\n";
    str += (char const *)u8"&훙<<薨\n";
    str += (char const *)u8"&훤<<*喧暄煊萱烜諠諼\n";
    str += (char const *)u8"&훼<<*卉喙毁燬芔虫虺\n";
    str += (char const *)u8"&휘<<*彙徽揮暉煇諱輝麾撝翬\n";
    str += (char const *)u8"&휴<<*休携烋畦虧咻擕隳髹鵂\n";
    str += (char const *)u8"&휼<<*恤譎鷸卹\n";
    str += (char const *)u8"&흉<<*兇凶匈洶胸恟胷\n";
    str += (char const *)u8"&흑<<黑\n";
    str += (char const *)u8"&흔<<*昕欣炘痕很忻掀焮訢釁\n";
    str += (char const *)u8"&흘<<*吃屹紇訖仡汔疙迄齕\n";
    str += (char const *)u8"&흠<<*欠欽歆廞\n";
    str += (char const *)u8"&흡<<*吸恰洽翕噏歙潝翖\n";
    str += (char const *)u8"&흥<<興\n";
    str += (char const *)u8"&희<<*僖凞喜噫囍姬嬉希憙憘戱晞曦熙熹熺犧禧稀羲咥唏嘻悕戲暿欷燹爔豨餼\n";
    str += (char const *)u8"&힐<<*詰犵纈襭頡黠\n";
    str += (char const *)u8"  \n";
    return str;
}

inline string_view unihan_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
  
&一=\uFDD0一
&丨=\uFDD0丨
&丶=\uFDD0丶
&丿=\uFDD0丿
&乙=\uFDD0乙
&亅=\uFDD0亅
&二=\uFDD0二
&亠=\uFDD0亠
&人=\uFDD0人
&儿=\uFDD0儿
&入=\uFDD0入
&八=\uFDD0八
&冂=\uFDD0冂
&冖=\uFDD0冖
&冫=\uFDD0冫
&几=\uFDD0几
&凵=\uFDD0凵
&刀=\uFDD0刀
&力=\uFDD0力
&勹=\uFDD0勹
&匕=\uFDD0匕
&匚=\uFDD0匚
&匸=\uFDD0匸
&十=\uFDD0十
&卜=\uFDD0卜
&卩=\uFDD0卩
&厂=\uFDD0厂
&厶=\uFDD0厶
&又=\uFDD0又
&口=\uFDD0口
&囗=\uFDD0囗
&土=\uFDD0土
&士=\uFDD0士
&夂=\uFDD0夂
&夊=\uFDD0夊
&夕=\uFDD0夕
&大=\uFDD0大
&女=\uFDD0女
&子=\uFDD0子
&宀=\uFDD0宀
&寸=\uFDD0寸
&小=\uFDD0小
&尢=\uFDD0尢
&尸=\uFDD0尸
&屮=\uFDD0屮
&山=\uFDD0山
&巛=\uFDD0巛
&工=\uFDD0工
&己=\uFDD0己
&巾=\uFDD0巾
&干=\uFDD0干
&乡=\uFDD0幺
&广=\uFDD0广
&廴=\uFDD0廴
&廾=\uFDD0廾
&弋=\uFDD0弋
&弓=\uFDD0弓
&彐=\uFDD0彐
&彡=\uFDD0彡
&彳=\uFDD0彳
&心=\uFDD0心
&戈=\uFDD0戈
&戶=\uFDD0戶
&手=\uFDD0手
&支=\uFDD0支
&攴=\uFDD0攴
&文=\uFDD0文
&斗=\uFDD0斗
&斤=\uFDD0斤
&方=\uFDD0方
&无=\uFDD0无
&日=\uFDD0日
&曰=\uFDD0曰
&月=\uFDD0月
&木=\uFDD0木
&欠=\uFDD0欠
&止=\uFDD0止
&歹=\uFDD0歹
&殳=\uFDD0殳
&毋=\uFDD0毋
&比=\uFDD0比
&毛=\uFDD0毛
&氏=\uFDD0氏
&气=\uFDD0气
&水=\uFDD0水
&火=\uFDD0火
&爪=\uFDD0爪
&父=\uFDD0父
&爻=\uFDD0爻
&丬=\uFDD0爿
&𬌒=\uFDD0丬
&片=\uFDD0片
&牙=\uFDD0牙
&牛=\uFDD0牛
&犬=\uFDD0犬
&玄=\uFDD0玄
&玉=\uFDD0玉
&瓜=\uFDD0瓜
&瓦=\uFDD0瓦
&甘=\uFDD0甘
&生=\uFDD0生
&用=\uFDD0用
&田=\uFDD0田
&疋=\uFDD0疋
&疒=\uFDD0疒
&癶=\uFDD0癶
&白=\uFDD0白
&皮=\uFDD0皮
&皿=\uFDD0皿
&目=\uFDD0目
&矛=\uFDD0矛
&矢=\uFDD0矢
&石=\uFDD0石
&示=\uFDD0示
&禸=\uFDD0禸
&禾=\uFDD0禾
&穴=\uFDD0穴
&立=\uFDD0立
&竹=\uFDD0竹
&米=\uFDD0米
&糸=\uFDD0糸
&纟=\uFDD0纟
&缶=\uFDD0缶
&网=\uFDD0网
&羊=\uFDD0羊
&羽=\uFDD0羽
&老=\uFDD0老
&而=\uFDD0而
&耒=\uFDD0耒
&耳=\uFDD0耳
&聿=\uFDD0聿
&肉=\uFDD0肉
&臣=\uFDD0臣
&自=\uFDD0自
&至=\uFDD0至
&臼=\uFDD0臼
&舌=\uFDD0舌
&舛=\uFDD0舛
&舟=\uFDD0舟
&艮=\uFDD0艮
&色=\uFDD0色
&艸=\uFDD0艸
&虍=\uFDD0虍
&虫=\uFDD0虫
&血=\uFDD0血
&行=\uFDD0行
&衣=\uFDD0衣
&襾=\uFDD0襾
&見=\uFDD0見
&见=\uFDD0见
&角=\uFDD0角
&言=\uFDD0言
&讠=\uFDD0讠
&谷=\uFDD0谷
&豆=\uFDD0豆
&豕=\uFDD0豕
&豸=\uFDD0豸
&貝=\uFDD0貝
&贝=\uFDD0贝
&赤=\uFDD0赤
&走=\uFDD0走
&足=\uFDD0足
&身=\uFDD0身
&車=\uFDD0車
&车=\uFDD0车
&辛=\uFDD0辛
&辰=\uFDD0辰
&辵=\uFDD0辵
&邑=\uFDD0邑
&酉=\uFDD0酉
&釆=\uFDD0釆
&里=\uFDD0里
&金=\uFDD0金
&钅=\uFDD0钅
&長=\uFDD0長
&长=\uFDD0长
&門=\uFDD0門
&门=\uFDD0门
&阜=\uFDD0阜
&隶=\uFDD0隶
&隹=\uFDD0隹
&雨=\uFDD0雨
&靑=\uFDD0靑
&非=\uFDD0非
&面=\uFDD0面
&革=\uFDD0革
&韋=\uFDD0韋
&韦=\uFDD0韦
&韭=\uFDD0韭
&音=\uFDD0音
&頁=\uFDD0頁
&页=\uFDD0页
&風=\uFDD0風
&风=\uFDD0风
&飛=\uFDD0飛
&飞=\uFDD0飞
&食=\uFDD0食
&饣=\uFDD0饣
&首=\uFDD0首
&香=\uFDD0香
&馬=\uFDD0馬
&马=\uFDD0马
&骨=\uFDD0骨
&高=\uFDD0高
&髟=\uFDD0髟
&鬥=\uFDD0鬥
&鬯=\uFDD0鬯
&鬲=\uFDD0鬲
&鬼=\uFDD0鬼
&魚=\uFDD0魚
&鱼=\uFDD0鱼
&鳥=\uFDD0鳥
&鸟=\uFDD0鸟
&鹵=\uFDD0鹵
&𮭰=\uFDD0卤
&鹿=\uFDD0鹿
&麥=\uFDD0麥
&麦=\uFDD0麦
&麻=\uFDD0麻
&黃=\uFDD0黃
&黍=\uFDD0黍
&黑=\uFDD0黑
&黹=\uFDD0黹
&黽=\uFDD0黽
&黾=\uFDD0黾
&鼎=\uFDD0鼎
&鼓=\uFDD0鼓
&鼠=\uFDD0鼠
&鼻=\uFDD0鼻
&齊=\uFDD0齊
&齐=\uFDD0齐
&齒=\uFDD0齒
&齿=\uFDD0齿
&龍=\uFDD0龍
&龙=\uFDD0龙
&龜=\uFDD0龜
&龟=\uFDD0龟
&龠=\uFDD0龠
  
[reorder Hang Hani]
  )");
}


}}}}

#endif
