// Copyright (C) 2020 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Warning! This file is autogenerated.
#ifndef BOOST_TEXT_DATA_KN_HPP
#define BOOST_TEXT_DATA_KN_HPP

#include <boost/text/string_view.hpp>


namespace boost { namespace text { namespace data { namespace kn {

inline string_view standard_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
[normalization on]
[reorder Knda Deva Beng Guru Gujr Orya Taml Telu Mlym Sinh]
&ಔ<ಂ<ಃ<ೱ<ೲ
  )");
}

inline string_view traditional_collation_tailoring()
{
    return string_view((char const *)
u8"  \n"
u8"[normalization on]\n"
u8"[reorder Knda Deva Beng Guru Gujr Orya Taml Telu Mlym Sinh]\n"
u8"&ಔ<ಂ<ಃ<ೱ<ೲ<ಕ್<ಖ್<ಗ್<ಘ್<ಙ್<ಚ್<ಛ್<ಜ್<ಝ್<ಞ್<ಟ್<ಠ್<ಡ್<ಢ್<ಣ್<ತ್<ಥ್<ದ್<ಧ್<ನ್<ಪ್<ಫ್<ಬ್<ಭ್\n"
u8"  <ಮ್<ಯ್<ರ್<ಱ್<ಲ್<ವ್<ಶ್<ಷ್<ಸ್<ಹ್<ಳ್<ೞ್\n"
u8"&ಕ್ಅ=ಕ\n"
u8"&ಕ್ಆ=ಕಾ\n"
u8"&ಕ್ಇ=ಕಿ\n"
u8"&ಕ್ಈ=ಕೀ\n"
u8"&ಕ್ಉ=ಕು\n"
u8"&ಕ್ಊ=ಕೂ\n"
u8"&ಕ್ಋ=ಕೃ\n"
u8"&ಕ್ೠ=ಕೄ\n"
u8"&ಕ್ಌ=ಕೢ\n"
u8"&ಕ್ೡ=ಕೣ\n"
u8"&ಕ್ಎ=ಕೆ\n"
u8"&ಕ್ಏ=ಕೇ\n"
u8"&ಕ್ಐ=ಕೈ\n"
u8"&ಕ್ಒ=ಕೊ\n"
u8"&ಕ್ಓ=ಕೋ\n"
u8"&ಕ್ಔ=ಕೌ\n"
u8"&ಖ್ಅ=ಖ\n"
u8"&ಖ್ಆ=ಖಾ\n"
u8"&ಖ್ಇ=ಖಿ\n"
u8"&ಖ್ಈ=ಖೀ\n"
u8"&ಖ್ಉ=ಖು\n"
u8"&ಖ್ಊ=ಖೂ\n"
u8"&ಖ್ಋ=ಖೃ\n"
u8"&ಖ್ೠ=ಖೄ\n"
u8"&ಖ್ಌ=ಖೢ\n"
u8"&ಖ್ೡ=ಖೣ\n"
u8"&ಖ್ಎ=ಖೆ\n"
u8"&ಖ್ಏ=ಖೇ\n"
u8"&ಖ್ಐ=ಖೈ\n"
u8"&ಖ್ಒ=ಖೊ\n"
u8"&ಖ್ಓ=ಖೋ\n"
u8"&ಖ್ಔ=ಖೌ\n"
u8"&ಗ್ಅ=ಗ\n"
u8"&ಗ್ಆ=ಗಾ\n"
u8"&ಗ್ಇ=ಗಿ\n"
u8"&ಗ್ಈ=ಗೀ\n"
u8"&ಗ್ಉ=ಗು\n"
u8"&ಗ್ಊ=ಗೂ\n"
u8"&ಗ್ಋ=ಗೃ\n"
u8"&ಗ್ೠ=ಗೄ\n"
u8"&ಗ್ಌ=ಗೢ\n"
u8"&ಗ್ೡ=ಗೣ\n"
u8"&ಗ್ಎ=ಗೆ\n"
u8"&ಗ್ಏ=ಗೇ\n"
u8"&ಗ್ಐ=ಗೈ\n"
u8"&ಗ್ಒ=ಗೊ\n"
u8"&ಗ್ಓ=ಗೋ\n"
u8"&ಗ್ಔ=ಗೌ\n"
u8"&ಘ್ಅ=ಘ\n"
u8"&ಘ್ಆ=ಘಾ\n"
u8"&ಘ್ಇ=ಘಿ\n"
u8"&ಘ್ಈ=ಘೀ\n"
u8"&ಘ್ಉ=ಘು\n"
u8"&ಘ್ಊ=ಘೂ\n"
u8"&ಘ್ಋ=ಘೃ\n"
u8"&ಘ್ೠ=ಘೄ\n"
u8"&ಘ್ಌ=ಘೢ\n"
u8"&ಘ್ೡ=ಘೣ\n"
u8"&ಘ್ಎ=ಘೆ\n"
u8"&ಘ್ಏ=ಘೇ\n"
u8"&ಘ್ಐ=ಘೈ\n"
u8"&ಘ್ಒ=ಘೊ\n"
u8"&ಘ್ಓ=ಘೋ\n"
u8"&ಘ್ಔ=ಘೌ\n"
u8"&ಙ್ಅ=ಙ\n"
u8"&ಙ್ಆ=ಙಾ\n"
u8"&ಙ್ಇ=ಙಿ\n"
u8"&ಙ್ಈ=ಙೀ\n"
u8"&ಙ್ಉ=ಙು\n"
u8"&ಙ್ಊ=ಙೂ\n"
u8"&ಙ್ಋ=ಙೃ\n"
u8"&ಙ್ೠ=ಙೄ\n"
u8"&ಙ್ಌ=ಙೢ\n"
u8"&ಙ್ೡ=ಙೣ\n"
u8"&ಙ್ಎ=ಙೆ\n"
u8"&ಙ್ಏ=ಙೇ\n"
u8"&ಙ್ಐ=ಙೈ\n"
u8"&ಙ್ಒ=ಙೊ\n"
u8"&ಙ್ಓ=ಙೋ\n"
u8"&ಙ್ಔ=ಙೌ\n"
u8"&ಚ್ಅ=ಚ\n"
u8"&ಚ್ಆ=ಚಾ\n"
u8"&ಚ್ಇ=ಚಿ\n"
u8"&ಚ್ಈ=ಚೀ\n"
u8"&ಚ್ಉ=ಚು\n"
u8"&ಚ್ಊ=ಚೂ\n"
u8"&ಚ್ಋ=ಚೃ\n"
u8"&ಚ್ೠ=ಚೄ\n"
u8"&ಚ್ಌ=ಚೢ\n"
u8"&ಚ್ೡ=ಚೣ\n"
u8"&ಚ್ಎ=ಚೆ\n"
u8"&ಚ್ಏ=ಚೇ\n"
u8"&ಚ್ಐ=ಚೈ\n"
u8"&ಚ್ಒ=ಚೊ\n"
u8"&ಚ್ಓ=ಚೋ\n"
u8"&ಚ್ಔ=ಚೌ\n"
u8"&ಛ್ಅ=ಛ\n"
u8"&ಛ್ಆ=ಛಾ\n"
u8"&ಛ್ಇ=ಛಿ\n"
u8"&ಛ್ಈ=ಛೀ\n"
u8"&ಛ್ಉ=ಛು\n"
u8"&ಛ್ಊ=ಛೂ\n"
u8"&ಛ್ಋ=ಛೃ\n"
u8"&ಛ್ೠ=ಛೄ\n"
u8"&ಛ್ಌ=ಛೢ\n"
u8"&ಛ್ೡ=ಛೣ\n"
u8"&ಛ್ಎ=ಛೆ\n"
u8"&ಛ್ಏ=ಛೇ\n"
u8"&ಛ್ಐ=ಛೈ\n"
u8"&ಛ್ಒ=ಛೊ\n"
u8"&ಛ್ಓ=ಛೋ\n"
u8"&ಛ್ಔ=ಛೌ\n"
u8"&ಜ್ಅ=ಜ\n"
u8"&ಜ್ಆ=ಜಾ\n"
u8"&ಜ್ಇ=ಜಿ\n"
u8"&ಜ್ಈ=ಜೀ\n"
u8"&ಜ್ಉ=ಜು\n"
u8"&ಜ್ಊ=ಜೂ\n"
u8"&ಜ್ಋ=ಜೃ\n"
u8"&ಜ್ೠ=ಜೄ\n"
u8"&ಜ್ಌ=ಜೢ\n"
u8"&ಜ್ೡ=ಜೣ\n"
u8"&ಜ್ಎ=ಜೆ\n"
u8"&ಜ್ಏ=ಜೇ\n"
u8"&ಜ್ಐ=ಜೈ\n"
u8"&ಜ್ಒ=ಜೊ\n"
u8"&ಜ್ಓ=ಜೋ\n"
u8"&ಜ್ಔ=ಜೌ\n"
u8"&ಝ್ಅ=ಝ\n"
u8"&ಝ್ಆ=ಝಾ\n"
u8"&ಝ್ಇ=ಝಿ\n"
u8"&ಝ್ಈ=ಝೀ\n"
u8"&ಝ್ಉ=ಝು\n"
u8"&ಝ್ಊ=ಝೂ\n"
u8"&ಝ್ಋ=ಝೃ\n"
u8"&ಝ್ೠ=ಝೄ\n"
u8"&ಝ್ಌ=ಝೢ\n"
u8"&ಝ್ೡ=ಝೣ\n"
u8"&ಝ್ಎ=ಝೆ\n"
u8"&ಝ್ಏ=ಝೇ\n"
u8"&ಝ್ಐ=ಝೈ\n"
u8"&ಝ್ಒ=ಝೊ\n"
u8"&ಝ್ಓ=ಝೋ\n"
u8"&ಝ್ಔ=ಝೌ\n"
u8"&ಞ್ಅ=ಞ\n"
u8"&ಞ್ಆ=ಞಾ\n"
u8"&ಞ್ಇ=ಞಿ\n"
u8"&ಞ್ಈ=ಞೀ\n"
u8"&ಞ್ಉ=ಞು\n"
u8"&ಞ್ಊ=ಞೂ\n"
u8"&ಞ್ಋ=ಞೃ\n"
u8"&ಞ್ೠ=ಞೄ\n"
u8"&ಞ್ಌ=ಞೢ\n"
u8"&ಞ್ೡ=ಞೣ\n"
u8"&ಞ್ಎ=ಞೆ\n"
u8"&ಞ್ಏ=ಞೇ\n"
u8"&ಞ್ಐ=ಞೈ\n"
u8"&ಞ್ಒ=ಞೊ\n"
u8"&ಞ್ಓ=ಞೋ\n"
u8"&ಞ್ಔ=ಞೌ\n"
u8"&ಟ್ಅ=ಟ\n"
u8"&ಟ್ಆ=ಟಾ\n"
u8"&ಟ್ಇ=ಟಿ\n"
u8"&ಟ್ಈ=ಟೀ\n"
u8"&ಟ್ಉ=ಟು\n"
u8"&ಟ್ಊ=ಟೂ\n"
u8"&ಟ್ಋ=ಟೃ\n"
u8"&ಟ್ೠ=ಟೄ\n"
u8"&ಟ್ಌ=ಟೢ\n"
u8"&ಟ್ೡ=ಟೣ\n"
u8"&ಟ್ಎ=ಟೆ\n"
u8"&ಟ್ಏ=ಟೇ\n"
u8"&ಟ್ಐ=ಟೈ\n"
u8"&ಟ್ಒ=ಟೊ\n"
u8"&ಟ್ಓ=ಟೋ\n"
u8"&ಟ್ಔ=ಟೌ\n"
u8"&ಠ್ಅ=ಠ\n"
u8"&ಠ್ಆ=ಠಾ\n"
u8"&ಠ್ಇ=ಠಿ\n"
u8"&ಠ್ಈ=ಠೀ\n"
u8"&ಠ್ಉ=ಠು\n"
u8"&ಠ್ಊ=ಠೂ\n"
u8"&ಠ್ಋ=ಠೃ\n"
u8"&ಠ್ೠ=ಠೄ\n"
u8"&ಠ್ಌ=ಠೢ\n"
u8"&ಠ್ೡ=ಠೣ\n"
u8"&ಠ್ಎ=ಠೆ\n"
u8"&ಠ್ಏ=ಠೇ\n"
u8"&ಠ್ಐ=ಠೈ\n"
u8"&ಠ್ಒ=ಠೊ\n"
u8"&ಠ್ಓ=ಠೋ\n"
u8"&ಠ್ಔ=ಠೌ\n"
u8"&ಡ್ಅ=ಡ\n"
u8"&ಡ್ಆ=ಡಾ\n"
u8"&ಡ್ಇ=ಡಿ\n"
u8"&ಡ್ಈ=ಡೀ\n"
u8"&ಡ್ಉ=ಡು\n"
u8"&ಡ್ಊ=ಡೂ\n"
u8"&ಡ್ಋ=ಡೃ\n"
u8"&ಡ್ೠ=ಡೄ\n"
u8"&ಡ್ಌ=ಡೢ\n"
u8"&ಡ್ೡ=ಡೣ\n"
u8"&ಡ್ಎ=ಡೆ\n"
u8"&ಡ್ಏ=ಡೇ\n"
u8"&ಡ್ಐ=ಡೈ\n"
u8"&ಡ್ಒ=ಡೊ\n"
u8"&ಡ್ಓ=ಡೋ\n"
u8"&ಡ್ಔ=ಡೌ\n"
u8"&ಢ್ಅ=ಢ\n"
u8"&ಢ್ಆ=ಢಾ\n"
u8"&ಢ್ಇ=ಢಿ\n"
u8"&ಢ್ಈ=ಢೀ\n"
u8"&ಢ್ಉ=ಢು\n"
u8"&ಢ್ಊ=ಢೂ\n"
u8"&ಢ್ಋ=ಢೃ\n"
u8"&ಢ್ೠ=ಢೄ\n"
u8"&ಢ್ಌ=ಢೢ\n"
u8"&ಢ್ೡ=ಢೣ\n"
u8"&ಢ್ಎ=ಢೆ\n"
u8"&ಢ್ಏ=ಢೇ\n"
u8"&ಢ್ಐ=ಢೈ\n"
u8"&ಢ್ಒ=ಢೊ\n"
u8"&ಢ್ಓ=ಢೋ\n"
u8"&ಢ್ಔ=ಢೌ\n"
u8"&ಣ್ಅ=ಣ\n"
u8"&ಣ್ಆ=ಣಾ\n"
u8"&ಣ್ಇ=ಣಿ\n"
u8"&ಣ್ಈ=ಣೀ\n"
u8"&ಣ್ಉ=ಣು\n"
u8"&ಣ್ಊ=ಣೂ\n"
u8"&ಣ್ಋ=ಣೃ\n"
u8"&ಣ್ೠ=ಣೄ\n"
u8"&ಣ್ಌ=ಣೢ\n"
u8"&ಣ್ೡ=ಣೣ\n"
u8"&ಣ್ಎ=ಣೆ\n"
u8"&ಣ್ಏ=ಣೇ\n"
u8"&ಣ್ಐ=ಣೈ\n"
u8"&ಣ್ಒ=ಣೊ\n"
u8"&ಣ್ಓ=ಣೋ\n"
u8"&ಣ್ಔ=ಣೌ\n"
u8"&ತ್ಅ=ತ\n"
u8"&ತ್ಆ=ತಾ\n"
u8"&ತ್ಇ=ತಿ\n"
u8"&ತ್ಈ=ತೀ\n"
u8"&ತ್ಉ=ತು\n"
u8"&ತ್ಊ=ತೂ\n"
u8"&ತ್ಋ=ತೃ\n"
u8"&ತ್ೠ=ತೄ\n"
u8"&ತ್ಌ=ತೢ\n"
u8"&ತ್ೡ=ತೣ\n"
u8"&ತ್ಎ=ತೆ\n"
u8"&ತ್ಏ=ತೇ\n"
u8"&ತ್ಐ=ತೈ\n"
u8"&ತ್ಒ=ತೊ\n"
u8"&ತ್ಓ=ತೋ\n"
u8"&ತ್ಔ=ತೌ\n"
u8"&ಥ್ಅ=ಥ\n"
u8"&ಥ್ಆ=ಥಾ\n"
u8"&ಥ್ಇ=ಥಿ\n"
u8"&ಥ್ಈ=ಥೀ\n"
u8"&ಥ್ಉ=ಥು\n"
u8"&ಥ್ಊ=ಥೂ\n"
u8"&ಥ್ಋ=ಥೃ\n"
u8"&ಥ್ೠ=ಥೄ\n"
u8"&ಥ್ಌ=ಥೢ\n"
u8"&ಥ್ೡ=ಥೣ\n"
u8"&ಥ್ಎ=ಥೆ\n"
u8"&ಥ್ಏ=ಥೇ\n"
u8"&ಥ್ಐ=ಥೈ\n"
u8"&ಥ್ಒ=ಥೊ\n"
u8"&ಥ್ಓ=ಥೋ\n"
u8"&ಥ್ಔ=ಥೌ\n"
u8"&ದ್ಅ=ದ\n"
u8"&ದ್ಆ=ದಾ\n"
u8"&ದ್ಇ=ದಿ\n"
u8"&ದ್ಈ=ದೀ\n"
u8"&ದ್ಉ=ದು\n"
u8"&ದ್ಊ=ದೂ\n"
u8"&ದ್ಋ=ದೃ\n"
u8"&ದ್ೠ=ದೄ\n"
u8"&ದ್ಌ=ದೢ\n"
u8"&ದ್ೡ=ದೣ\n"
u8"&ದ್ಎ=ದೆ\n"
u8"&ದ್ಏ=ದೇ\n"
u8"&ದ್ಐ=ದೈ\n"
u8"&ದ್ಒ=ದೊ\n"
u8"&ದ್ಓ=ದೋ\n"
u8"&ದ್ಔ=ದೌ\n"
u8"&ಧ್ಅ=ಧ\n"
u8"&ಧ್ಆ=ಧಾ\n"
u8"&ಧ್ಇ=ಧಿ\n"
u8"&ಧ್ಈ=ಧೀ\n"
u8"&ಧ್ಉ=ಧು\n"
u8"&ಧ್ಊ=ಧೂ\n"
u8"&ಧ್ಋ=ಧೃ\n"
u8"&ಧ್ೠ=ಧೄ\n"
u8"&ಧ್ಌ=ಧೢ\n"
u8"&ಧ್ೡ=ಧೣ\n"
u8"&ಧ್ಎ=ಧೆ\n"
u8"&ಧ್ಏ=ಧೇ\n"
u8"&ಧ್ಐ=ಧೈ\n"
u8"&ಧ್ಒ=ಧೊ\n"
u8"&ಧ್ಓ=ಧೋ\n"
u8"&ಧ್ಔ=ಧೌ\n"
u8"&ನ್ಅ=ನ\n"
u8"&ನ್ಆ=ನಾ\n"
u8"&ನ್ಇ=ನಿ\n"
u8"&ನ್ಈ=ನೀ\n"
u8"&ನ್ಉ=ನು\n"
u8"&ನ್ಊ=ನೂ\n"
u8"&ನ್ಋ=ನೃ\n"
u8"&ನ್ೠ=ನೄ\n"
u8"&ನ್ಌ=ನೢ\n"
u8"&ನ್ೡ=ನೣ\n"
u8"&ನ್ಎ=ನೆ\n"
u8"&ನ್ಏ=ನೇ\n"
u8"&ನ್ಐ=ನೈ\n"
u8"&ನ್ಒ=ನೊ\n"
u8"&ನ್ಓ=ನೋ\n"
u8"&ನ್ಔ=ನೌ\n"
u8"&ಪ್ಅ=ಪ\n"
u8"&ಪ್ಆ=ಪಾ\n"
u8"&ಪ್ಇ=ಪಿ\n"
u8"&ಪ್ಈ=ಪೀ\n"
u8"&ಪ್ಉ=ಪು\n"
u8"&ಪ್ಊ=ಪೂ\n"
u8"&ಪ್ಋ=ಪೃ\n"
u8"&ಪ್ೠ=ಪೄ\n"
u8"&ಪ್ಌ=ಪೢ\n"
u8"&ಪ್ೡ=ಪೣ\n"
u8"&ಪ್ಎ=ಪೆ\n"
u8"&ಪ್ಏ=ಪೇ\n"
u8"&ಪ್ಐ=ಪೈ\n"
u8"&ಪ್ಒ=ಪೊ\n"
u8"&ಪ್ಓ=ಪೋ\n"
u8"&ಪ್ಔ=ಪೌ\n"
u8"&ಫ್ಅ=ಫ\n"
u8"&ಫ್ಆ=ಫಾ\n"
u8"&ಫ್ಇ=ಫಿ\n"
u8"&ಫ್ಈ=ಫೀ\n"
u8"&ಫ್ಉ=ಫು\n"
u8"&ಫ್ಊ=ಫೂ\n"
u8"&ಫ್ಋ=ಫೃ\n"
u8"&ಫ್ೠ=ಫೄ\n"
u8"&ಫ್ಌ=ಫೢ\n"
u8"&ಫ್ೡ=ಫೣ\n"
u8"&ಫ್ಎ=ಫೆ\n"
u8"&ಫ್ಏ=ಫೇ\n"
u8"&ಫ್ಐ=ಫೈ\n"
u8"&ಫ್ಒ=ಫೊ\n"
u8"&ಫ್ಓ=ಫೋ\n"
u8"&ಫ್ಔ=ಫೌ\n"
u8"&ಬ್ಅ=ಬ\n"
u8"&ಬ್ಆ=ಬಾ\n"
u8"&ಬ್ಇ=ಬಿ\n"
u8"&ಬ್ಈ=ಬೀ\n"
u8"&ಬ್ಉ=ಬು\n"
u8"&ಬ್ಊ=ಬೂ\n"
u8"&ಬ್ಋ=ಬೃ\n"
u8"&ಬ್ೠ=ಬೄ\n"
u8"&ಬ್ಌ=ಬೢ\n"
u8"&ಬ್ೡ=ಬೣ\n"
u8"&ಬ್ಎ=ಬೆ\n"
u8"&ಬ್ಏ=ಬೇ\n"
u8"&ಬ್ಐ=ಬೈ\n"
u8"&ಬ್ಒ=ಬೊ\n"
u8"&ಬ್ಓ=ಬೋ\n"
u8"&ಬ್ಔ=ಬೌ\n"
u8"&ಭ್ಅ=ಭ\n"
u8"&ಭ್ಆ=ಭಾ\n"
u8"&ಭ್ಇ=ಭಿ\n"
u8"&ಭ್ಈ=ಭೀ\n"
u8"&ಭ್ಉ=ಭು\n"
u8"&ಭ್ಊ=ಭೂ\n"
u8"&ಭ್ಋ=ಭೃ\n"
u8"&ಭ್ೠ=ಭೄ\n"
u8"&ಭ್ಌ=ಭೢ\n"
u8"&ಭ್ೡ=ಭೣ\n"
u8"&ಭ್ಎ=ಭೆ\n"
u8"&ಭ್ಏ=ಭೇ\n"
u8"&ಭ್ಐ=ಭೈ\n"
u8"&ಭ್ಒ=ಭೊ\n"
u8"&ಭ್ಓ=ಭೋ\n"
u8"&ಭ್ಔ=ಭೌ\n"
u8"&ಮ್ಅ=ಮ\n"
u8"&ಮ್ಆ=ಮಾ\n"
u8"&ಮ್ಇ=ಮಿ\n"
u8"&ಮ್ಈ=ಮೀ\n"
u8"&ಮ್ಉ=ಮು\n"
u8"&ಮ್ಊ=ಮೂ\n"
u8"&ಮ್ಋ=ಮೃ\n"
u8"&ಮ್ೠ=ಮೄ\n"
u8"&ಮ್ಌ=ಮೢ\n"
u8"&ಮ್ೡ=ಮೣ\n"
u8"&ಮ್ಎ=ಮೆ\n"
u8"&ಮ್ಏ=ಮೇ\n"
u8"&ಮ್ಐ=ಮೈ\n"
u8"&ಮ್ಒ=ಮೊ\n"
u8"&ಮ್ಓ=ಮೋ\n"
u8"&ಮ್ಔ=ಮೌ\n"
u8"&ಯ್ಅ=ಯ\n"
u8"&ಯ್ಆ=ಯಾ\n"
u8"&ಯ್ಇ=ಯಿ\n"
u8"&ಯ್ಈ=ಯೀ\n"
u8"&ಯ್ಉ=ಯು\n"
u8"&ಯ್ಊ=ಯೂ\n"
u8"&ಯ್ಋ=ಯೃ\n"
u8"&ಯ್ೠ=ಯೄ\n"
u8"&ಯ್ಌ=ಯೢ\n"
u8"&ಯ್ೡ=ಯೣ\n"
u8"&ಯ್ಎ=ಯೆ\n"
u8"&ಯ್ಏ=ಯೇ\n"
u8"&ಯ್ಐ=ಯೈ\n"
u8"&ಯ್ಒ=ಯೊ\n"
u8"&ಯ್ಓ=ಯೋ\n"
u8"&ಯ್ಔ=ಯೌ\n"
u8"&ರ್ಅ=ರ\n"
u8"&ರ್ಆ=ರಾ\n"
u8"&ರ್ಇ=ರಿ\n"
u8"&ರ್ಈ=ರೀ\n"
u8"&ರ್ಉ=ರು\n"
u8"&ರ್ಊ=ರೂ\n"
u8"&ರ್ಋ=ರೃ\n"
u8"&ರ್ೠ=ರೄ\n"
u8"&ರ್ಌ=ರೢ\n"
u8"&ರ್ೡ=ರೣ\n"
u8"&ರ್ಎ=ರೆ\n"
u8"&ರ್ಏ=ರೇ\n"
u8"&ರ್ಐ=ರೈ\n"
u8"&ರ್ಒ=ರೊ\n"
u8"&ರ್ಓ=ರೋ\n"
u8"&ರ್ಔ=ರೌ\n"
u8"&ಱ್ಅ=ಱ\n"
u8"&ಱ್ಆ=ಱಾ\n"
u8"&ಱ್ಇ=ಱಿ\n"
u8"&ಱ್ಈ=ಱೀ\n"
u8"&ಱ್ಉ=ಱು\n"
u8"&ಱ್ಊ=ಱೂ\n"
u8"&ಱ್ಋ=ಱೃ\n"
u8"&ಱ್ೠ=ಱೄ\n"
u8"&ಱ್ಌ=ಱೢ\n"
u8"&ಱ್ೡ=ಱೣ\n"
u8"&ಱ್ಎ=ಱೆ\n"
u8"&ಱ್ಏ=ಱೇ\n"
u8"&ಱ್ಐ=ಱೈ\n"
u8"&ಱ್ಒ=ಱೊ\n"
u8"&ಱ್ಓ=ಱೋ\n"
u8"&ಱ್ಔ=ಱೌ\n"
u8"&ಲ್ಅ=ಲ\n"
u8"&ಲ್ಆ=ಲಾ\n"
u8"&ಲ್ಇ=ಲಿ\n"
u8"&ಲ್ಈ=ಲೀ\n"
u8"&ಲ್ಉ=ಲು\n"
u8"&ಲ್ಊ=ಲೂ\n"
u8"&ಲ್ಋ=ಲೃ\n"
u8"&ಲ್ೠ=ಲೄ\n"
u8"&ಲ್ಌ=ಲೢ\n"
u8"&ಲ್ೡ=ಲೣ\n"
u8"&ಲ್ಎ=ಲೆ\n"
u8"&ಲ್ಏ=ಲೇ\n"
u8"&ಲ್ಐ=ಲೈ\n"
u8"&ಲ್ಒ=ಲೊ\n"
u8"&ಲ್ಓ=ಲೋ\n"
u8"&ಲ್ಔ=ಲೌ\n"
u8"&ವ್ಅ=ವ\n"
u8"&ವ್ಆ=ವಾ\n"
u8"&ವ್ಇ=ವಿ\n"
u8"&ವ್ಈ=ವೀ\n"
u8"&ವ್ಉ=ವು\n"
u8"&ವ್ಊ=ವೂ\n"
u8"&ವ್ಋ=ವೃ\n"
u8"&ವ್ೠ=ವೄ\n"
u8"&ವ್ಌ=ವೢ\n"
u8"&ವ್ೡ=ವೣ\n"
u8"&ವ್ಎ=ವೆ\n"
u8"&ವ್ಏ=ವೇ\n"
u8"&ವ್ಐ=ವೈ\n"
u8"&ವ್ಒ=ವೊ\n"
u8"&ವ್ಓ=ವೋ\n"
u8"&ವ್ಔ=ವೌ\n"
u8"&ಶ್ಅ=ಶ\n"
u8"&ಶ್ಆ=ಶಾ\n"
u8"&ಶ್ಇ=ಶಿ\n"
u8"&ಶ್ಈ=ಶೀ\n"
u8"&ಶ್ಉ=ಶು\n"
u8"&ಶ್ಊ=ಶೂ\n"
u8"&ಶ್ಋ=ಶೃ\n"
u8"&ಶ್ೠ=ಶೄ\n"
u8"&ಶ್ಌ=ಶೢ\n"
u8"&ಶ್ೡ=ಶೣ\n"
u8"&ಶ್ಎ=ಶೆ\n"
u8"&ಶ್ಏ=ಶೇ\n"
u8"&ಶ್ಐ=ಶೈ\n"
u8"&ಶ್ಒ=ಶೊ\n"
u8"&ಶ್ಓ=ಶೋ\n"
u8"&ಶ್ಔ=ಶೌ\n"
u8"&ಷ್ಅ=ಷ\n"
u8"&ಷ್ಆ=ಷಾ\n"
u8"&ಷ್ಇ=ಷಿ\n"
u8"&ಷ್ಈ=ಷೀ\n"
u8"&ಷ್ಉ=ಷು\n"
u8"&ಷ್ಊ=ಷೂ\n"
u8"&ಷ್ಋ=ಷೃ\n"
u8"&ಷ್ೠ=ಷೄ\n"
u8"&ಷ್ಌ=ಷೢ\n"
u8"&ಷ್ೡ=ಷೣ\n"
u8"&ಷ್ಎ=ಷೆ\n"
u8"&ಷ್ಏ=ಷೇ\n"
u8"&ಷ್ಐ=ಷೈ\n"
u8"&ಷ್ಒ=ಷೊ\n"
u8"&ಷ್ಓ=ಷೋ\n"
u8"&ಷ್ಔ=ಷೌ\n"
u8"&ಸ್ಅ=ಸ\n"
u8"&ಸ್ಆ=ಸಾ\n"
u8"&ಸ್ಇ=ಸಿ\n"
u8"&ಸ್ಈ=ಸೀ\n"
u8"&ಸ್ಉ=ಸು\n"
u8"&ಸ್ಊ=ಸೂ\n"
u8"&ಸ್ಋ=ಸೃ\n"
u8"&ಸ್ೠ=ಸೄ\n"
u8"&ಸ್ಌ=ಸೢ\n"
u8"&ಸ್ೡ=ಸೣ\n"
u8"&ಸ್ಎ=ಸೆ\n"
u8"&ಸ್ಏ=ಸೇ\n"
u8"&ಸ್ಐ=ಸೈ\n"
u8"&ಸ್ಒ=ಸೊ\n"
u8"&ಸ್ಓ=ಸೋ\n"
u8"&ಸ್ಔ=ಸೌ\n"
u8"&ಹ್ಅ=ಹ\n"
u8"&ಹ್ಆ=ಹಾ\n"
u8"&ಹ್ಇ=ಹಿ\n"
u8"&ಹ್ಈ=ಹೀ\n"
u8"&ಹ್ಉ=ಹು\n"
u8"&ಹ್ಊ=ಹೂ\n"
u8"&ಹ್ಋ=ಹೃ\n"
u8"&ಹ್ೠ=ಹೄ\n"
u8"&ಹ್ಌ=ಹೢ\n"
u8"&ಹ್ೡ=ಹೣ\n"
u8"&ಹ್ಎ=ಹೆ\n"
u8"&ಹ್ಏ=ಹೇ\n"
u8"&ಹ್ಐ=ಹೈ\n"
u8"&ಹ್ಒ=ಹೊ\n"
u8"&ಹ್ಓ=ಹೋ\n"
u8"&ಹ್ಔ=ಹೌ\n"
u8"&ಳ್ಅ=ಳ\n"
u8"&ಳ್ಆ=ಳಾ\n"
u8"&ಳ್ಇ=ಳಿ\n"
u8"&ಳ್ಈ=ಳೀ\n"
u8"&ಳ್ಉ=ಳು\n"
u8"&ಳ್ಊ=ಳೂ\n"
u8"&ಳ್ಋ=ಳೃ\n"
u8"&ಳ್ೠ=ಳೄ\n"
u8"&ಳ್ಌ=ಳೢ\n"
u8"&ಳ್ೡ=ಳೣ\n"
u8"&ಳ್ಎ=ಳೆ\n"
u8"&ಳ್ಏ=ಳೇ\n"
u8"&ಳ್ಐ=ಳೈ\n"
u8"&ಳ್ಒ=ಳೊ\n"
u8"&ಳ್ಓ=ಳೋ\n"
u8"&ಳ್ಔ=ಳೌ\n"
u8"&ೞ್ಅ=ೞ\n"
u8"&ೞ್ಆ=ೞಾ\n"
u8"&ೞ್ಇ=ೞಿ\n"
u8"&ೞ್ಈ=ೞೀ\n"
u8"&ೞ್ಉ=ೞು\n"
u8"&ೞ್ಊ=ೞೂ\n"
u8"&ೞ್ಋ=ೞೃ\n"
u8"&ೞ್ೠ=ೞೄ\n"
u8"&ೞ್ಌ=ೞೢ\n"
u8"&ೞ್ೡ=ೞೣ\n"
u8"&ೞ್ಎ=ೞೆ\n"
u8"&ೞ್ಏ=ೞೇ\n"
u8"&ೞ್ಐ=ೞೈ\n"
u8"&ೞ್ಒ=ೞೊ\n"
u8"&ೞ್ಓ=ೞೋ\n"
u8"&ೞ್ಔ=ೞೌ\n"
u8"&ಙ್ಕ<<<ಂಕ\n"
u8"&ಙ್ಖ<<<ಂಖ\n"
u8"&ಙ್ಗ<<<ಂಗ\n"
u8"&ಙ್ಘ<<<ಂಘ\n"
u8"&ಙ್ಙ<<<ಂಙ\n"
u8"&ಞ್ಚ<<<ಂಚ\n"
u8"&ಞ್ಛ<<<ಂಛ\n"
u8"&ಞ್ಜ<<<ಂಜ\n"
u8"&ಞ್ಝ<<<ಂಝ\n"
u8"&ಞ್ಞ<<<ಂಞ\n"
u8"&ಣ್ಟ<<<ಂಟ\n"
u8"&ಣ್ಠ<<<ಂಠ\n"
u8"&ಣ್ಡ<<<ಂಡ\n"
u8"&ಣ್ಢ<<<ಂಢ\n"
u8"&ಣ್ಣ<<<ಂಣ\n"
u8"&ನ್ತ<<<ಂತ\n"
u8"&ನ್ಥ<<<ಂಥ\n"
u8"&ನ್ದ<<<ಂದ\n"
u8"&ನ್ಧ<<<ಂಧ\n"
u8"&ನ್ನ<<<ಂನ\n"
u8"&ಮ್ಪ<<<ಂಪ\n"
u8"&ಮ್ಫ<<<ಂಫ\n"
u8"&ಮ್ಬ<<<ಂಬ\n"
u8"&ಮ್ಭ<<<ಂಭ\n"
u8"&ಮ್ಮ<<<ಂಮ\n"
u8"&ಜ<<<ಜ಼\n"
u8"&ಜಾ<<<ಜ಼ಾ\n"
u8"&ಜಿ<<<ಜ಼ಿ\n"
u8"&ಜೀ<<<ಜ಼ೀ\n"
u8"&ಜು<<<ಜ಼ು\n"
u8"&ಜೂ<<<ಜ಼ೂ\n"
u8"&ಜೃ<<<ಜ಼ೃ\n"
u8"&ಜೄ<<<ಜ಼ೄ\n"
u8"&ಜೢ<<<ಜ಼ೢ\n"
u8"&ಜೣ<<<ಜ಼ೣ\n"
u8"&ಜೆ<<<ಜ಼ೆ\n"
u8"&ಜೇ<<<ಜ಼ೇ\n"
u8"&ಜೈ<<<ಜ಼ೈ\n"
u8"&ಜೊ<<<ಜ಼ೊ\n"
u8"&ಜೋ<<<ಜ಼ೋ\n"
u8"&ಜೌ<<<ಜ಼ೌ\n"
u8"&ಫ<<<ಫ಼\n"
u8"&ಫಾ<<<ಫ಼ಾ\n"
u8"&ಫಿ<<<ಫ಼ಿ\n"
u8"&ಫೀ<<<ಫ಼ೀ\n"
u8"&ಫು<<<ಫ಼ು\n"
u8"&ಫೂ<<<ಫ಼ೂ\n"
u8"&ಫೃ<<<ಫ಼ೃ\n"
u8"&ಫೄ<<<ಫ಼ೄ\n"
u8"&ಫೢ<<<ಫ಼ೢ\n"
u8"&ಫೣ<<<ಫ಼ೣ\n"
u8"&ಫೆ<<<ಫ಼ೆ\n"
u8"&ಫೇ<<<ಫ಼ೇ\n"
u8"&ಫೈ<<<ಫ಼ೈ\n"
u8"&ಫೊ<<<ಫ಼ೊ\n"
u8"&ಫೋ<<<ಫ಼ೋ\n"
u8"&ಫೌ<<<ಫ಼ೌ\n"
u8"  \n");
}


}}}}

#endif
