// Copyright (C) 2020 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Warning! This file is autogenerated.
#ifndef BOOST_TEXT_DATA_JA_HPP
#define BOOST_TEXT_DATA_JA_HPP

#include <boost/text/string_view.hpp>


namespace boost { namespace text { namespace data { namespace ja {

inline string_view standard_collation_tailoring()
{
    return string_view((char const *)
u8"  \n"
u8"  \n"
u8"[strength 3]\n"
u8"[reorder Latn Kana Hani]\n"
u8"&ゝ<<<<ヽ\n"
u8"&[before 3]ぁ\n"
u8"  <<<ぁ|ー=あ|ー=か|ー=ゕ|ー=が|ー=さ|ー=ざ|ー=た|ー=だ|ー=な|ー=は|ー=ば|ー=ぱ|ー=ま|ー=ゃ|ー=や|ー=ら|ー=ゎ|ー=わ|ー\n"
u8"  <<<<ァ|ー=ｧ|ー=ア|ー=ｱ|ー=カ|ー=ｶ|ー=ガ|ー\n"
u8"  =サ|ー=ｻ|ー=ザ|ー=タ|ー=ﾀ|ー=ダ|ー=ナ|ー=ﾅ|ー=ハ|ー=ﾊ|ー=ㇵ|ー=バ|ー=パ|ー\n"
u8"  =マ|ー=ﾏ|ー=ャ|ー=ｬ|ー=ヤ|ー=ﾔ|ー=ラ|ー=ﾗ|ー=ㇻ|ー=ヮ|ー=ワ|ー=ﾜ|ー=ヵ|ー=ヷ|ー\n"
u8"&[before 3]ぃ\n"
u8"  <<<ぃ|ー=い|ー=き|ー=ぎ|ー=し|ー=じ|ー=ち|ー=ぢ|ー=に|ー=ひ|ー=び|ー=ぴ|ー=み|ー=り|ー=ゐ|ー\n"
u8"  <<<<ィ|ー=ｨ|ー=イ|ー=ｲ|ー=キ|ー=ｷ|ー=ギ|ー=シ|ー=ｼ|ー=ㇱ|ー=ジ|ー\n"
u8"  =チ|ー=ﾁ|ー=ヂ|ー=ニ|ー=ﾆ|ー=ヒ|ー=ﾋ|ー=ㇶ|ー=ビ|ー=ピ|ー\n"
u8"  =ミ|ー=ﾐ|ー=リ|ー=ﾘ|ー=ㇼ|ー=ヰ|ー=ヸ|ー\n"
u8"&[before 3]ぅ\n"
u8"  <<<ぅ|ー=う|ー=く|ー=ぐ|ー=す|ー=ず|ー=っ|ー=つ|ー=づ|ー=ぬ|ー=ふ|ー=ぶ|ー=ぷ|ー=む|ー=ゅ|ー=ゆ|ー=る|ー=ゔ|ー\n"
u8"  <<<<ゥ|ー=ｩ|ー=ウ|ー=ｳ|ー=ク|ー=ｸ|ー=ㇰ|ー=グ|ー\n"
u8"  =ス|ー=ｽ|ー=ㇲ|ー=ズ|ー=ッ|ー=ｯ|ー=ツ|ー=ﾂ|ー=ヅ|ー=ヌ|ー=ﾇ|ー=ㇴ|ー\n"
u8"  =フ|ー=ﾌ|ー=ㇷ|ー=ブ|ー=プ|ー=ム|ー=ﾑ|ー=ㇺ|ー=ュ|ー=ｭ|ー=ユ|ー=ﾕ|ー=ル|ー=ﾙ|ー=ㇽ|ー=ヴ|ー\n"
u8"&[before 3]ぇ\n"
u8"  <<<ぇ|ー=え|ー=け|ー=ゖ|ー=げ|ー=せ|ー=ぜ|ー=て|ー=で|ー=ね|ー=へ|ー=べ|ー=ぺ|ー=め|ー=れ|ー=ゑ|ー\n"
u8"  <<<<ェ|ー=ｪ|ー=エ|ー=ｴ|ー=ケ|ー=ｹ|ー=ゲ|ー\n"
u8"  =セ|ー=ｾ|ー=ゼ|ー=テ|ー=ﾃ|ー=デ|ー=ネ|ー=ﾈ|ー=ヘ|ー=ﾍ|ー=ㇸ|ー=ベ|ー=ペ|ー\n"
u8"  =メ|ー=ﾒ|ー=レ|ー=ﾚ|ー=ㇾ|ー=ヱ|ー=ヶ|ー=ヹ|ー\n"
u8"&[before 3]ぉ\n"
u8"  <<<ぉ|ー=お|ー=こ|ー=ご|ー=そ|ー=ぞ|ー=と|ー=ど|ー=の|ー=ほ|ー=ぼ|ー=ぽ|ー=も|ー=ょ|ー=よ|ー=ろ|ー=を|ー\n"
u8"  <<<<ォ|ー=ｫ|ー=オ|ー=ｵ|ー=コ|ー=ｺ|ー=ゴ|ー=ソ|ー=ｿ|ー=ゾ|ー=ト|ー=ﾄ|ー=ㇳ|ー=ド|ー\n"
u8"  =ノ|ー=ﾉ|ー=ホ|ー=ﾎ|ー=ㇹ|ー=ボ|ー=ポ|ー=モ|ー=ﾓ|ー=ョ|ー=ｮ|ー=ヨ|ー=ﾖ|ー\n"
u8"  =ロ|ー=ﾛ|ー=ㇿ|ー=ヲ|ー=ｦ|ー=ヺ|ー\n"
u8"&[before 3]あ\n"
u8"  <<<あ|ゝ=ぁ|ゝ\n"
u8"  <<<<ア|ヽ=ｱ|ヽ=ァ|ヽ=ｧ|ヽ\n"
u8"&[before 3]い\n"
u8"  <<<い|ゝ=ぃ|ゝ\n"
u8"  <<<<イ|ヽ=ｲ|ヽ=ィ|ヽ=ｨ|ヽ\n"
u8"&[before 3]う\n"
u8"  <<<う|ゝ=ぅ|ゝ=ゔ|ゝ=う|ゞ/゙=ぅ|ゞ/゙=ゔ|ゞ/゙\n"
u8"  <<<<ウ|ヽ=ｳ|ヽ=ゥ|ヽ=ｩ|ヽ=ヴ|ヽ=ウ|ヾ/゙=ｳ|ヾ/゙=ゥ|ヾ/゙=ｩ|ヾ/゙=ヴ|ヾ/゙\n"
u8"&[before 3]え\n"
u8"  <<<え|ゝ=ぇ|ゝ\n"
u8"  <<<<エ|ヽ=ｴ|ヽ=ェ|ヽ=ｪ|ヽ\n"
u8"&[before 3]お\n"
u8"  <<<お|ゝ=ぉ|ゝ\n"
u8"  <<<<オ|ヽ=ｵ|ヽ=ォ|ヽ=ｫ|ヽ\n"
u8"&[before 3]か\n"
u8"  <<<か|ゝ=ゕ|ゝ\n"
u8"  <<<<カ|ヽ=ｶ|ヽ=ヵ|ヽ\n"
u8"&[before 3]が\n"
u8"  <<<が|ゝ\n"
u8"  <<<<ガ|ヽ\n"
u8"&[before 3]き\n"
u8"  <<<き|ゝ=ぎ|ゝ=き|ゞ/゙=ぎ|ゞ/゙\n"
u8"  <<<<キ|ヽ=ｷ|ヽ=ギ|ヽ=キ|ヾ/゙=ｷ|ヾ/゙=ギ|ヾ/゙\n"
u8"&[before 3]く\n"
u8"  <<<く|ゝ=ぐ|ゝ=く|ゞ/゙=ぐ|ゞ/゙\n"
u8"  <<<<ク|ヽ=ｸ|ヽ=ㇰ|ヽ=グ|ヽ=ク|ヾ/゙=ｸ|ヾ/゙=ㇰ|ヾ/゙=グ|ヾ/゙\n"
u8"&[before 3]け\n"
u8"  <<<け|ゝ=ゖ|ゝ\n"
u8"  <<<<ケ|ヽ=ｹ|ヽ=ヶ|ヽ\n"
u8"&[before 3]げ\n"
u8"  <<<げ|ゝ\n"
u8"  <<<<ゲ|ヽ\n"
u8"&[before 3]こ\n"
u8"  <<<こ|ゝ=ご|ゝ=こ|ゞ/゙=ご|ゞ/゙\n"
u8"  <<<<コ|ヽ=ｺ|ヽ=ゴ|ヽ=コ|ヾ/゙=ｺ|ヾ/゙=ゴ|ヾ/゙\n"
u8"&[before 3]さ\n"
u8"  <<<さ|ゝ=ざ|ゝ=さ|ゞ/゙=ざ|ゞ/゙\n"
u8"  <<<<サ|ヽ=ｻ|ヽ=ザ|ヽ=サ|ヾ/゙=ｻ|ヾ/゙=ザ|ヾ/゙\n"
u8"&[before 3]し\n"
u8"  <<<し|ゝ=じ|ゝ=し|ゞ/゙=じ|ゞ/゙\n"
u8"  <<<<シ|ヽ=ｼ|ヽ=ㇱ|ヽ=ジ|ヽ=シ|ヾ/゙=ｼ|ヾ/゙=ㇱ|ヾ/゙=ジ|ヾ/゙\n"
u8"&[before 3]す\n"
u8"  <<<す|ゝ=ず|ゝ=す|ゞ/゙=ず|ゞ/゙\n"
u8"  <<<<ス|ヽ=ｽ|ヽ=ㇲ|ヽ=ズ|ヽ=ス|ヾ/゙=ｽ|ヾ/゙=ㇲ|ヾ/゙=ズ|ヾ/゙\n"
u8"&[before 3]せ\n"
u8"  <<<せ|ゝ=ぜ|ゝ=せ|ゞ/゙=ぜ|ゞ/゙\n"
u8"  <<<<セ|ヽ=ｾ|ヽ=ゼ|ヽ=セ|ヾ/゙=ｾ|ヾ/゙=ゼ|ヾ/゙\n"
u8"&[before 3]そ\n"
u8"  <<<そ|ゝ=ぞ|ゝ=そ|ゞ/゙=ぞ|ゞ/゙\n"
u8"  <<<<ソ|ヽ=ｿ|ヽ=ゾ|ヽ=ソ|ヾ/゙=ｿ|ヾ/゙=ゾ|ヾ/゙\n"
u8"&[before 3]た\n"
u8"  <<<た|ゝ=だ|ゝ=た|ゞ/゙=だ|ゞ/゙\n"
u8"  <<<<タ|ヽ=ﾀ|ヽ=ダ|ヽ=タ|ヾ/゙=ﾀ|ヾ/゙=ダ|ヾ/゙\n"
u8"&[before 3]ち\n"
u8"  <<<ち|ゝ=ぢ|ゝ=ち|ゞ/゙=ぢ|ゞ/゙\n"
u8"  <<<<チ|ヽ=ﾁ|ヽ=ヂ|ヽ=チ|ヾ/゙=ﾁ|ヾ/゙=ヂ|ヾ/゙\n"
u8"&[before 3]つ\n"
u8"  <<<つ|ゝ=っ|ゝ=づ|ゝ=つ|ゞ/゙=づ|ゞ/゙=つ|ゝ=っ|ゞ/゙=つ|ゞ/゙\n"
u8"  <<<<ツ|ヽ=ﾂ|ヽ=ッ|ヽ=ｯ|ヽ=ヅ|ヽ=ツ|ヾ/゙=ﾂ|ヾ/゙=ヅ|ヾ/゙=ツ|ヽ=ﾂ|ヽ=ッ|ヾ/゙=ｯ|ヾ/゙=ツ|ヾ/゙=ﾂ|ヾ/゙\n"
u8"&[before 3]て\n"
u8"  <<<て|ゝ=で|ゝ=て|ゞ/゙=で|ゞ/゙\n"
u8"  <<<<テ|ヽ=ﾃ|ヽ=デ|ヽ=テ|ヾ/゙=ﾃ|ヾ/゙=デ|ヾ/゙\n"
u8"&[before 3]と\n"
u8"  <<<と|ゝ=ど|ゝ=と|ゞ/゙=ど|ゞ/゙\n"
u8"  <<<<ト|ヽ=ﾄ|ヽ=ㇳ|ヽ=ド|ヽ=ト|ヾ/゙=ﾄ|ヾ/゙=ㇳ|ヾ/゙=ド|ヾ/゙\n"
u8"&[before 3]な\n"
u8"  <<<な|ゝ\n"
u8"  <<<<ナ|ヽ=ﾅ|ヽ\n"
u8"&[before 3]に\n"
u8"  <<<に|ゝ\n"
u8"  <<<<ニ|ヽ=ﾆ|ヽ\n"
u8"&[before 3]ぬ\n"
u8"  <<<ぬ|ゝ\n"
u8"  <<<<ヌ|ヽ=ﾇ|ヽ=ㇴ|ヽ\n"
u8"&[before 3]ね\n"
u8"  <<<ね|ゝ\n"
u8"  <<<<ネ|ヽ=ﾈ|ヽ\n"
u8"&[before 3]の\n"
u8"  <<<の|ゝ\n"
u8"  <<<<ノ|ヽ=ﾉ|ヽ\n"
u8"&[before 3]は\n"
u8"  <<<は|ゝ=ば|ゝ=は|ゞ/゙=ば|ゞ/゙=ぱ|ゝ=ぱ|ゞ/゙\n"
u8"  <<<<ハ|ヽ=ﾊ|ヽ=ㇵ|ヽ=バ|ヽ=ハ|ヾ/゙=ﾊ|ヾ/゙=ㇵ|ヾ/゙=バ|ヾ/゙=パ|ヽ=パ|ヾ/゙\n"
u8"&[before 3]ひ\n"
u8"  <<<ひ|ゝ=び|ゝ=ひ|ゞ/゙=び|ゞ/゙=ぴ|ゝ=ぴ|ゞ/゙\n"
u8"  <<<<ヒ|ヽ=ﾋ|ヽ=ㇶ|ヽ=ビ|ヽ=ヒ|ヾ/゙=ﾋ|ヾ/゙=ㇶ|ヾ/゙=ビ|ヾ/゙=ピ|ヽ=ピ|ヾ/゙\n"
u8"&[before 3]ふ\n"
u8"  <<<ふ|ゝ=ぶ|ゝ=ふ|ゞ/゙=ぶ|ゞ/゙=ぷ|ゝ=ぷ|ゞ/゙\n"
u8"  <<<<フ|ヽ=ﾌ|ヽ=ㇷ|ヽ=ブ|ヽ=フ|ヾ/゙=ﾌ|ヾ/゙=ㇷ|ヾ/゙=ブ|ヾ/゙=プ|ヽ=プ|ヾ/゙\n"
u8"&[before 3]へ\n"
u8"  <<<へ|ゝ=べ|ゝ=へ|ゞ/゙=べ|ゞ/゙=ぺ|ゝ=ぺ|ゞ/゙\n"
u8"  <<<<ヘ|ヽ=ﾍ|ヽ=ㇸ|ヽ=ベ|ヽ=ヘ|ヾ/゙=ﾍ|ヾ/゙=ㇸ|ヾ/゙=ベ|ヾ/゙=ペ|ヽ=ペ|ヾ/゙\n"
u8"&[before 3]ほ\n"
u8"  <<<ほ|ゝ=ぼ|ゝ=ほ|ゞ/゙=ぼ|ゞ/゙=ぽ|ゝ=ぽ|ゞ/゙\n"
u8"  <<<<ホ|ヽ=ﾎ|ヽ=ㇹ|ヽ=ボ|ヽ=ホ|ヾ/゙=ﾎ|ヾ/゙=ㇹ|ヾ/゙=ボ|ヾ/゙=ポ|ヽ=ポ|ヾ/゙\n"
u8"&[before 3]ま\n"
u8"  <<<ま|ゝ\n"
u8"  <<<<マ|ヽ=ﾏ|ヽ\n"
u8"&[before 3]み\n"
u8"  <<<み|ゝ\n"
u8"  <<<<ミ|ヽ=ﾐ|ヽ\n"
u8"&[before 3]む\n"
u8"  <<<む|ゝ\n"
u8"  <<<<ム|ヽ=ﾑ|ヽ=ㇺ|ヽ\n"
u8"&[before 3]め\n"
u8"  <<<め|ゝ\n"
u8"  <<<<メ|ヽ=ﾒ|ヽ\n"
u8"&[before 3]も\n"
u8"  <<<も|ゝ\n"
u8"  <<<<モ|ヽ=ﾓ|ヽ\n"
u8"&[before 3]や\n"
u8"  <<<や|ゝ=ゃ|ゝ\n"
u8"  <<<<ヤ|ヽ=ﾔ|ヽ=ャ|ヽ=ｬ|ヽ\n"
u8"&[before 3]ゆ\n"
u8"  <<<ゆ|ゝ=ゅ|ゝ\n"
u8"  <<<<ユ|ヽ=ﾕ|ヽ=ュ|ヽ=ｭ|ヽ\n"
u8"&[before 3]よ\n"
u8"  <<<よ|ゝ=ょ|ゝ\n"
u8"  <<<<ヨ|ヽ=ﾖ|ヽ=ョ|ヽ=ｮ|ヽ\n"
u8"&[before 3]ら\n"
u8"  <<<ら|ゝ\n"
u8"  <<<<ラ|ヽ=ﾗ|ヽ=ㇻ|ヽ\n"
u8"&[before 3]り\n"
u8"  <<<り|ゝ\n"
u8"  <<<<リ|ヽ=ﾘ|ヽ=ㇼ|ヽ\n"
u8"&[before 3]る\n"
u8"  <<<る|ゝ\n"
u8"  <<<<ル|ヽ=ﾙ|ヽ=ㇽ|ヽ\n"
u8"&[before 3]れ\n"
u8"  <<<れ|ゝ\n"
u8"  <<<<レ|ヽ=ﾚ|ヽ=ㇾ|ヽ\n"
u8"&[before 3]ろ\n"
u8"  <<<ろ|ゝ\n"
u8"  <<<<ロ|ヽ=ﾛ|ヽ=ㇿ|ヽ\n"
u8"&[before 3]わ\n"
u8"  <<<わ|ゝ=ゎ|ゝ=わ|ゞ/゙=ゎ|ゞ/゙\n"
u8"  <<<<ワ|ヽ=ﾜ|ヽ=ヮ|ヽ=ヷ|ヽ=ワ|ヾ/゙=ﾜ|ヾ/゙=ヷ|ヾ/゙=ヮ|ヾ/゙\n"
u8"&[before 3]ゐ\n"
u8"  <<<ゐ|ゝ=ゐ|ゞ/゙\n"
u8"  <<<<ヰ|ヽ=ヸ|ヽ=ヰ|ヾ/゙=ヸ|ヾ/゙\n"
u8"&[before 3]ゑ\n"
u8"  <<<ゑ|ゝ=ゑ|ゞ/゙\n"
u8"  <<<<ヱ|ヽ=ヹ|ヽ=ヱ|ヾ/゙=ヹ|ヾ/゙\n"
u8"&[before 3]を\n"
u8"  <<<を|ゝ=を|ゞ/゙\n"
u8"  <<<<ヲ|ヽ=ｦ|ヽ=ヺ|ヽ=ヲ|ヾ/゙=ｦ|ヾ/゙=ヺ|ヾ/゙\n"
u8"&[before 3]ん\n"
u8"  <<<ん|ゝ\n"
u8"  <<<<ン|ヽ=ﾝ|ヽ\n"
u8"&ぁ<<<<ァ=ｧ\n"
u8"&あ<<<<ア=ｱ\n"
u8"&ぃ<<<<ィ=ｨ\n"
u8"&い<<<<イ=ｲ\n"
u8"&ぅ<<<<ゥ=ｩ\n"
u8"&う<<<<ウ=ｳ\n"
u8"&ぇ<<<<ェ=ｪ\n"
u8"&え<<<<エ=ｴ\n"
u8"&ぉ<<<<ォ=ｫ\n"
u8"&お<<<<オ=ｵ\n"
u8"&か<<<<カ=ｶ\n"
u8"&き<<<<キ=ｷ\n"
u8"&く<<<<ク=ｸ\n"
u8"&け<<<<ケ=ｹ\n"
u8"&こ<<<<コ=ｺ\n"
u8"&さ<<<<サ=ｻ\n"
u8"&し<<<<シ=ｼ\n"
u8"&す<<<<ス=ｽ\n"
u8"&せ<<<<セ=ｾ\n"
u8"&そ<<<<ソ=ｿ\n"
u8"&た<<<<タ=ﾀ\n"
u8"&ち<<<<チ=ﾁ\n"
u8"&っ<<<<ッ=ｯ\n"
u8"&つ<<<<ツ=ﾂ\n"
u8"&て<<<<テ=ﾃ\n"
u8"&と<<<<ト=ﾄ\n"
u8"&な<<<<ナ=ﾅ\n"
u8"&に<<<<ニ=ﾆ\n"
u8"&ぬ<<<<ヌ=ﾇ\n"
u8"&ね<<<<ネ=ﾈ\n"
u8"&の<<<<ノ=ﾉ\n"
u8"&は<<<<ハ=ﾊ\n"
u8"&ひ<<<<ヒ=ﾋ\n"
u8"&ふ<<<<フ=ﾌ\n"
u8"&へ<<<<ヘ=ﾍ\n"
u8"&ほ<<<<ホ=ﾎ\n"
u8"&ま<<<<マ=ﾏ\n"
u8"&み<<<<ミ=ﾐ\n"
u8"&む<<<<ム=ﾑ\n"
u8"&め<<<<メ=ﾒ\n"
u8"&も<<<<モ=ﾓ\n"
u8"&ゃ<<<<ャ=ｬ\n"
u8"&や<<<<ヤ=ﾔ\n"
u8"&ゅ<<<<ュ=ｭ\n"
u8"&ゆ<<<<ユ=ﾕ\n"
u8"&ょ<<<<ョ=ｮ\n"
u8"&よ<<<<ヨ=ﾖ\n"
u8"&ら<<<<ラ=ﾗ\n"
u8"&り<<<<リ=ﾘ\n"
u8"&る<<<<ル=ﾙ\n"
u8"&れ<<<<レ=ﾚ\n"
u8"&ろ<<<<ロ=ﾛ\n"
u8"&ゎ<<<<ヮ\n"
u8"&わ<<<<ワ=ﾜ\n"
u8"&ゐ<<<<ヰ\n"
u8"&ゑ<<<<ヱ\n"
u8"&を<<<<ヲ=ｦ\n"
u8"&ん<<<<ン=ﾝ\n"
u8"&ゕ<<<<ヵ\n"
u8"&ゖ<<<<ヶ\n"
u8"&より\n"
u8"  <<ゟ\n"
u8"&コト\n"
u8"  <<ヿ\n"
u8"&'\\u0020'=*'\\u3000'￣\n"
u8"&'!'=！\n"
u8"&'\\u0022'=＂\n"
u8"&'\\u0023'=＃\n"
u8"&'$'=＄\n"
u8"&'%'=％\n"
u8"&'&'=＆\n"
u8"&''=＇\n"
u8"&'('=（\n"
u8"&')'=）\n"
u8"&'*'=＊\n"
u8"&'+'=＋\n"
u8"&','=，\n"
u8"&'-'=－\n"
u8"&'.'=．\n"
u8"&'/'=／\n"
u8"&0=０\n"
u8"&1=１\n"
u8"&2=２\n"
u8"&3=３\n"
u8"&4=４\n"
u8"&5=５\n"
u8"&6=６\n"
u8"&7=７\n"
u8"&8=８\n"
u8"&9=９\n"
u8"&':'=：\n"
u8"&';'=；\n"
u8"&'<'=＜\n"
u8"&'='=＝\n"
u8"&'>'=＞\n"
u8"&'?'=？\n"
u8"&'@'=＠\n"
u8"&A=Ａ\n"
u8"&B=Ｂ\n"
u8"&C=Ｃ\n"
u8"&D=Ｄ\n"
u8"&E=Ｅ\n"
u8"&F=Ｆ\n"
u8"&G=Ｇ\n"
u8"&H=Ｈ\n"
u8"&I=Ｉ\n"
u8"&J=Ｊ\n"
u8"&K=Ｋ\n"
u8"&L=Ｌ\n"
u8"&M=Ｍ\n"
u8"&N=Ｎ\n"
u8"&O=Ｏ\n"
u8"&P=Ｐ\n"
u8"&Q=Ｑ\n"
u8"&R=Ｒ\n"
u8"&S=Ｓ\n"
u8"&T=Ｔ\n"
u8"&U=Ｕ\n"
u8"&V=Ｖ\n"
u8"&W=Ｗ\n"
u8"&X=Ｘ\n"
u8"&Y=Ｙ\n"
u8"&Z=Ｚ\n"
u8"&'['=［\n"
u8"&'\\\\'=＼\n"
u8"&']'=］\n"
u8"&'^'=＾\n"
u8"&'_'=＿\n"
u8"&'`'=｀\n"
u8"&a=ａ\n"
u8"&b=ｂ\n"
u8"&c=ｃ\n"
u8"&d=ｄ\n"
u8"&e=ｅ\n"
u8"&f=ｆ\n"
u8"&g=ｇ\n"
u8"&h=ｈ\n"
u8"&i=ｉ\n"
u8"&j=ｊ\n"
u8"&k=ｋ\n"
u8"&l=ｌ\n"
u8"&m=ｍ\n"
u8"&n=ｎ\n"
u8"&o=ｏ\n"
u8"&p=ｐ\n"
u8"&q=ｑ\n"
u8"&r=ｒ\n"
u8"&s=ｓ\n"
u8"&t=ｔ\n"
u8"&u=ｕ\n"
u8"&v=ｖ\n"
u8"&w=ｗ\n"
u8"&x=ｘ\n"
u8"&y=ｙ\n"
u8"&z=ｚ\n"
u8"&'{'=｛\n"
u8"&'|'=｜\n"
u8"&'}'=｝\n"
u8"&'~'=～\n"
u8"&¢=￠\n"
u8"&£=￡\n"
u8"&¥=￥\n"
u8"&¦=￤\n"
u8"&¬=￢\n"
u8"&ᄀ=ﾡ=ㄱ\n"
u8"&ᄁ=ﾢ=ㄲ\n"
u8"&ᄂ=ﾤ=ㄴ\n"
u8"&ᄃ=ﾧ=ㄷ\n"
u8"&ᄄ=ﾨ=ㄸ\n"
u8"&ᄅ=ﾩ=ㄹ\n"
u8"&ᄆ=ﾱ=ㅁ\n"
u8"&ᄇ=ﾲ=ㅂ\n"
u8"&ᄈ=ﾳ=ㅃ\n"
u8"&ᄉ=ﾵ=ㅅ\n"
u8"&ᄊ=ﾶ=ㅆ\n"
u8"&ᄋ=ﾷ=ㅇ\n"
u8"&ᄌ=ﾸ=ㅈ\n"
u8"&ᄍ=ﾹ=ㅉ\n"
u8"&ᄎ=ﾺ=ㅊ\n"
u8"&ᄏ=ﾻ=ㅋ\n"
u8"&ᄐ=ﾼ=ㅌ\n"
u8"&ᄑ=ﾽ=ㅍ\n"
u8"&ᄒ=ﾾ=ㅎ\n"
u8"&ᄚ=ﾰ=ㅀ\n"
u8"&ᄡ=ﾴ=ㅄ\n"
u8"&ᅠ=ﾠ=ㅤ\n"
u8"&ᅡ=ￂ=ㅏ\n"
u8"&ᅢ=ￃ=ㅐ\n"
u8"&ᅣ=ￄ=ㅑ\n"
u8"&ᅤ=ￅ=ㅒ\n"
u8"&ᅥ=ￆ=ㅓ\n"
u8"&ᅦ=ￇ=ㅔ\n"
u8"&ᅧ=ￊ=ㅕ\n"
u8"&ᅨ=ￋ=ㅖ\n"
u8"&ᅩ=ￌ=ㅗ\n"
u8"&ᅪ=ￍ=ㅘ\n"
u8"&ᅫ=ￎ=ㅙ\n"
u8"&ᅬ=ￏ=ㅚ\n"
u8"&ᅭ=ￒ=ㅛ\n"
u8"&ᅮ=ￓ=ㅜ\n"
u8"&ᅯ=ￔ=ㅝ\n"
u8"&ᅰ=ￕ=ㅞ\n"
u8"&ᅱ=ￖ=ㅟ\n"
u8"&ᅲ=ￗ=ㅠ\n"
u8"&ᅳ=ￚ=ㅡ\n"
u8"&ᅴ=ￛ=ㅢ\n"
u8"&ᅵ=ￜ=ㅣ\n"
u8"&ᆪ=ﾣ=ㄳ\n"
u8"&ᆬ=ﾥ=ㄵ\n"
u8"&ᆭ=ﾦ=ㄶ\n"
u8"&ᆰ=ﾪ=ㄺ\n"
u8"&ᆱ=ﾫ=ㄻ\n"
u8"&ᆲ=ﾬ=ㄼ\n"
u8"&ᆳ=ﾭ=ㄽ\n"
u8"&ᆴ=ﾮ=ㄾ\n"
u8"&ᆵ=ﾯ=ㄿ\n"
u8"&₩=￦\n"
u8"&←=￩\n"
u8"&↑=￪\n"
u8"&→=￫\n"
u8"&↓=￬\n"
u8"&│=￨\n"
u8"&■=￭\n"
u8"&○=￮\n"
u8"&、=､\n"
u8"&。=｡\n"
u8"&「=｢\n"
u8"&」=｣\n"
u8"  \n"
u8"&[last regular]<*亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省"
u8"硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉"
u8"愈油癒諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘"
u8"椢椦棡椌棍棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞"
u8"衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠堯槇遙瑤凜熙\n"
u8"  \n");
}

inline string_view unihan_collation_tailoring()
{
    return string_view((char const *)
u8"  \n"
u8"  \n"
u8"&一=\\uFDD0一\n"
u8"&丨=\\uFDD0丨\n"
u8"&丶=\\uFDD0丶\n"
u8"&丿=\\uFDD0丿\n"
u8"&乙=\\uFDD0乙\n"
u8"&亅=\\uFDD0亅\n"
u8"&二=\\uFDD0二\n"
u8"&亠=\\uFDD0亠\n"
u8"&人=\\uFDD0人\n"
u8"&儿=\\uFDD0儿\n"
u8"&入=\\uFDD0入\n"
u8"&八=\\uFDD0八\n"
u8"&冂=\\uFDD0冂\n"
u8"&冖=\\uFDD0冖\n"
u8"&冫=\\uFDD0冫\n"
u8"&几=\\uFDD0几\n"
u8"&凵=\\uFDD0凵\n"
u8"&刀=\\uFDD0刀\n"
u8"&力=\\uFDD0力\n"
u8"&勹=\\uFDD0勹\n"
u8"&匕=\\uFDD0匕\n"
u8"&匚=\\uFDD0匚\n"
u8"&匸=\\uFDD0匸\n"
u8"&十=\\uFDD0十\n"
u8"&卜=\\uFDD0卜\n"
u8"&卩=\\uFDD0卩\n"
u8"&厂=\\uFDD0厂\n"
u8"&厶=\\uFDD0厶\n"
u8"&又=\\uFDD0又\n"
u8"&口=\\uFDD0口\n"
u8"&囗=\\uFDD0囗\n"
u8"&土=\\uFDD0土\n"
u8"&士=\\uFDD0士\n"
u8"&夂=\\uFDD0夂\n"
u8"&夊=\\uFDD0夊\n"
u8"&夕=\\uFDD0夕\n"
u8"&大=\\uFDD0大\n"
u8"&女=\\uFDD0女\n"
u8"&子=\\uFDD0子\n"
u8"&宀=\\uFDD0宀\n"
u8"&寸=\\uFDD0寸\n"
u8"&小=\\uFDD0小\n"
u8"&尢=\\uFDD0尢\n"
u8"&尸=\\uFDD0尸\n"
u8"&屮=\\uFDD0屮\n"
u8"&山=\\uFDD0山\n"
u8"&巛=\\uFDD0巛\n"
u8"&工=\\uFDD0工\n"
u8"&己=\\uFDD0己\n"
u8"&巾=\\uFDD0巾\n"
u8"&干=\\uFDD0干\n"
u8"&乡=\\uFDD0幺\n"
u8"&广=\\uFDD0广\n"
u8"&廴=\\uFDD0廴\n"
u8"&廾=\\uFDD0廾\n"
u8"&弋=\\uFDD0弋\n"
u8"&弓=\\uFDD0弓\n"
u8"&彐=\\uFDD0彐\n"
u8"&彡=\\uFDD0彡\n"
u8"&彳=\\uFDD0彳\n"
u8"&心=\\uFDD0心\n"
u8"&戈=\\uFDD0戈\n"
u8"&戶=\\uFDD0戶\n"
u8"&手=\\uFDD0手\n"
u8"&支=\\uFDD0支\n"
u8"&攴=\\uFDD0攴\n"
u8"&文=\\uFDD0文\n"
u8"&斗=\\uFDD0斗\n"
u8"&斤=\\uFDD0斤\n"
u8"&方=\\uFDD0方\n"
u8"&无=\\uFDD0无\n"
u8"&日=\\uFDD0日\n"
u8"&曰=\\uFDD0曰\n"
u8"&月=\\uFDD0月\n"
u8"&木=\\uFDD0木\n"
u8"&欠=\\uFDD0欠\n"
u8"&止=\\uFDD0止\n"
u8"&歹=\\uFDD0歹\n"
u8"&殳=\\uFDD0殳\n"
u8"&毋=\\uFDD0毋\n"
u8"&比=\\uFDD0比\n"
u8"&毛=\\uFDD0毛\n"
u8"&氏=\\uFDD0氏\n"
u8"&气=\\uFDD0气\n"
u8"&水=\\uFDD0水\n"
u8"&火=\\uFDD0火\n"
u8"&爪=\\uFDD0爪\n"
u8"&父=\\uFDD0父\n"
u8"&爻=\\uFDD0爻\n"
u8"&丬=\\uFDD0爿\n"
u8"&𬌒=\\uFDD0丬\n"
u8"&片=\\uFDD0片\n"
u8"&牙=\\uFDD0牙\n"
u8"&牛=\\uFDD0牛\n"
u8"&犬=\\uFDD0犬\n"
u8"&玄=\\uFDD0玄\n"
u8"&玉=\\uFDD0玉\n"
u8"&瓜=\\uFDD0瓜\n"
u8"&瓦=\\uFDD0瓦\n"
u8"&甘=\\uFDD0甘\n"
u8"&生=\\uFDD0生\n"
u8"&用=\\uFDD0用\n"
u8"&田=\\uFDD0田\n"
u8"&疋=\\uFDD0疋\n"
u8"&疒=\\uFDD0疒\n"
u8"&癶=\\uFDD0癶\n"
u8"&白=\\uFDD0白\n"
u8"&皮=\\uFDD0皮\n"
u8"&皿=\\uFDD0皿\n"
u8"&目=\\uFDD0目\n"
u8"&矛=\\uFDD0矛\n"
u8"&矢=\\uFDD0矢\n"
u8"&石=\\uFDD0石\n"
u8"&示=\\uFDD0示\n"
u8"&禸=\\uFDD0禸\n"
u8"&禾=\\uFDD0禾\n"
u8"&穴=\\uFDD0穴\n"
u8"&立=\\uFDD0立\n"
u8"&竹=\\uFDD0竹\n"
u8"&米=\\uFDD0米\n"
u8"&糸=\\uFDD0糸\n"
u8"&纟=\\uFDD0纟\n"
u8"&缶=\\uFDD0缶\n"
u8"&网=\\uFDD0网\n"
u8"&羊=\\uFDD0羊\n"
u8"&羽=\\uFDD0羽\n"
u8"&老=\\uFDD0老\n"
u8"&而=\\uFDD0而\n"
u8"&耒=\\uFDD0耒\n"
u8"&耳=\\uFDD0耳\n"
u8"&聿=\\uFDD0聿\n"
u8"&肉=\\uFDD0肉\n"
u8"&臣=\\uFDD0臣\n"
u8"&自=\\uFDD0自\n"
u8"&至=\\uFDD0至\n"
u8"&臼=\\uFDD0臼\n"
u8"&舌=\\uFDD0舌\n"
u8"&舛=\\uFDD0舛\n"
u8"&舟=\\uFDD0舟\n"
u8"&艮=\\uFDD0艮\n"
u8"&色=\\uFDD0色\n"
u8"&艸=\\uFDD0艸\n"
u8"&虍=\\uFDD0虍\n"
u8"&虫=\\uFDD0虫\n"
u8"&血=\\uFDD0血\n"
u8"&行=\\uFDD0行\n"
u8"&衣=\\uFDD0衣\n"
u8"&襾=\\uFDD0襾\n"
u8"&見=\\uFDD0見\n"
u8"&见=\\uFDD0见\n"
u8"&角=\\uFDD0角\n"
u8"&言=\\uFDD0言\n"
u8"&讠=\\uFDD0讠\n"
u8"&谷=\\uFDD0谷\n"
u8"&豆=\\uFDD0豆\n"
u8"&豕=\\uFDD0豕\n"
u8"&豸=\\uFDD0豸\n"
u8"&貝=\\uFDD0貝\n"
u8"&贝=\\uFDD0贝\n"
u8"&赤=\\uFDD0赤\n"
u8"&走=\\uFDD0走\n"
u8"&足=\\uFDD0足\n"
u8"&身=\\uFDD0身\n"
u8"&車=\\uFDD0車\n"
u8"&车=\\uFDD0车\n"
u8"&辛=\\uFDD0辛\n"
u8"&辰=\\uFDD0辰\n"
u8"&辵=\\uFDD0辵\n"
u8"&邑=\\uFDD0邑\n"
u8"&酉=\\uFDD0酉\n"
u8"&釆=\\uFDD0釆\n"
u8"&里=\\uFDD0里\n"
u8"&金=\\uFDD0金\n"
u8"&钅=\\uFDD0钅\n"
u8"&長=\\uFDD0長\n"
u8"&长=\\uFDD0长\n"
u8"&門=\\uFDD0門\n"
u8"&门=\\uFDD0门\n"
u8"&阜=\\uFDD0阜\n"
u8"&隶=\\uFDD0隶\n"
u8"&隹=\\uFDD0隹\n"
u8"&雨=\\uFDD0雨\n"
u8"&靑=\\uFDD0靑\n"
u8"&非=\\uFDD0非\n"
u8"&面=\\uFDD0面\n"
u8"&革=\\uFDD0革\n"
u8"&韋=\\uFDD0韋\n"
u8"&韦=\\uFDD0韦\n"
u8"&韭=\\uFDD0韭\n"
u8"&音=\\uFDD0音\n"
u8"&頁=\\uFDD0頁\n"
u8"&页=\\uFDD0页\n"
u8"&風=\\uFDD0風\n"
u8"&风=\\uFDD0风\n"
u8"&飛=\\uFDD0飛\n"
u8"&飞=\\uFDD0飞\n"
u8"&食=\\uFDD0食\n"
u8"&饣=\\uFDD0饣\n"
u8"&首=\\uFDD0首\n"
u8"&香=\\uFDD0香\n"
u8"&馬=\\uFDD0馬\n"
u8"&马=\\uFDD0马\n"
u8"&骨=\\uFDD0骨\n"
u8"&高=\\uFDD0高\n"
u8"&髟=\\uFDD0髟\n"
u8"&鬥=\\uFDD0鬥\n"
u8"&鬯=\\uFDD0鬯\n"
u8"&鬲=\\uFDD0鬲\n"
u8"&鬼=\\uFDD0鬼\n"
u8"&魚=\\uFDD0魚\n"
u8"&鱼=\\uFDD0鱼\n"
u8"&鳥=\\uFDD0鳥\n"
u8"&鸟=\\uFDD0鸟\n"
u8"&鹵=\\uFDD0鹵\n"
u8"&𮭰=\\uFDD0卤\n"
u8"&鹿=\\uFDD0鹿\n"
u8"&麥=\\uFDD0麥\n"
u8"&麦=\\uFDD0麦\n"
u8"&麻=\\uFDD0麻\n"
u8"&黃=\\uFDD0黃\n"
u8"&黍=\\uFDD0黍\n"
u8"&黑=\\uFDD0黑\n"
u8"&黹=\\uFDD0黹\n"
u8"&黽=\\uFDD0黽\n"
u8"&黾=\\uFDD0黾\n"
u8"&鼎=\\uFDD0鼎\n"
u8"&鼓=\\uFDD0鼓\n"
u8"&鼠=\\uFDD0鼠\n"
u8"&鼻=\\uFDD0鼻\n"
u8"&齊=\\uFDD0齊\n"
u8"&齐=\\uFDD0齐\n"
u8"&齒=\\uFDD0齒\n"
u8"&齿=\\uFDD0齿\n"
u8"&龍=\\uFDD0龍\n"
u8"&龙=\\uFDD0龙\n"
u8"&龜=\\uFDD0龜\n"
u8"&龟=\\uFDD0龟\n"
u8"&龠=\\uFDD0龠\n"
u8"  \n"
u8"  \n"
u8"[strength 3]\n"
u8"[reorder Latn Kana Hani]\n"
u8"&ゝ<<<<ヽ\n"
u8"&[before 3]ぁ\n"
u8"  <<<ぁ|ー=あ|ー=か|ー=ゕ|ー=が|ー=さ|ー=ざ|ー=た|ー=だ|ー=な|ー=は|ー=ば|ー=ぱ|ー=ま|ー=ゃ|ー=や|ー=ら|ー=ゎ|ー=わ|ー\n"
u8"  <<<<ァ|ー=ｧ|ー=ア|ー=ｱ|ー=カ|ー=ｶ|ー=ガ|ー\n"
u8"  =サ|ー=ｻ|ー=ザ|ー=タ|ー=ﾀ|ー=ダ|ー=ナ|ー=ﾅ|ー=ハ|ー=ﾊ|ー=ㇵ|ー=バ|ー=パ|ー\n"
u8"  =マ|ー=ﾏ|ー=ャ|ー=ｬ|ー=ヤ|ー=ﾔ|ー=ラ|ー=ﾗ|ー=ㇻ|ー=ヮ|ー=ワ|ー=ﾜ|ー=ヵ|ー=ヷ|ー\n"
u8"&[before 3]ぃ\n"
u8"  <<<ぃ|ー=い|ー=き|ー=ぎ|ー=し|ー=じ|ー=ち|ー=ぢ|ー=に|ー=ひ|ー=び|ー=ぴ|ー=み|ー=り|ー=ゐ|ー\n"
u8"  <<<<ィ|ー=ｨ|ー=イ|ー=ｲ|ー=キ|ー=ｷ|ー=ギ|ー=シ|ー=ｼ|ー=ㇱ|ー=ジ|ー\n"
u8"  =チ|ー=ﾁ|ー=ヂ|ー=ニ|ー=ﾆ|ー=ヒ|ー=ﾋ|ー=ㇶ|ー=ビ|ー=ピ|ー\n"
u8"  =ミ|ー=ﾐ|ー=リ|ー=ﾘ|ー=ㇼ|ー=ヰ|ー=ヸ|ー\n"
u8"&[before 3]ぅ\n"
u8"  <<<ぅ|ー=う|ー=く|ー=ぐ|ー=す|ー=ず|ー=っ|ー=つ|ー=づ|ー=ぬ|ー=ふ|ー=ぶ|ー=ぷ|ー=む|ー=ゅ|ー=ゆ|ー=る|ー=ゔ|ー\n"
u8"  <<<<ゥ|ー=ｩ|ー=ウ|ー=ｳ|ー=ク|ー=ｸ|ー=ㇰ|ー=グ|ー\n"
u8"  =ス|ー=ｽ|ー=ㇲ|ー=ズ|ー=ッ|ー=ｯ|ー=ツ|ー=ﾂ|ー=ヅ|ー=ヌ|ー=ﾇ|ー=ㇴ|ー\n"
u8"  =フ|ー=ﾌ|ー=ㇷ|ー=ブ|ー=プ|ー=ム|ー=ﾑ|ー=ㇺ|ー=ュ|ー=ｭ|ー=ユ|ー=ﾕ|ー=ル|ー=ﾙ|ー=ㇽ|ー=ヴ|ー\n"
u8"&[before 3]ぇ\n"
u8"  <<<ぇ|ー=え|ー=け|ー=ゖ|ー=げ|ー=せ|ー=ぜ|ー=て|ー=で|ー=ね|ー=へ|ー=べ|ー=ぺ|ー=め|ー=れ|ー=ゑ|ー\n"
u8"  <<<<ェ|ー=ｪ|ー=エ|ー=ｴ|ー=ケ|ー=ｹ|ー=ゲ|ー\n"
u8"  =セ|ー=ｾ|ー=ゼ|ー=テ|ー=ﾃ|ー=デ|ー=ネ|ー=ﾈ|ー=ヘ|ー=ﾍ|ー=ㇸ|ー=ベ|ー=ペ|ー\n"
u8"  =メ|ー=ﾒ|ー=レ|ー=ﾚ|ー=ㇾ|ー=ヱ|ー=ヶ|ー=ヹ|ー\n"
u8"&[before 3]ぉ\n"
u8"  <<<ぉ|ー=お|ー=こ|ー=ご|ー=そ|ー=ぞ|ー=と|ー=ど|ー=の|ー=ほ|ー=ぼ|ー=ぽ|ー=も|ー=ょ|ー=よ|ー=ろ|ー=を|ー\n"
u8"  <<<<ォ|ー=ｫ|ー=オ|ー=ｵ|ー=コ|ー=ｺ|ー=ゴ|ー=ソ|ー=ｿ|ー=ゾ|ー=ト|ー=ﾄ|ー=ㇳ|ー=ド|ー\n"
u8"  =ノ|ー=ﾉ|ー=ホ|ー=ﾎ|ー=ㇹ|ー=ボ|ー=ポ|ー=モ|ー=ﾓ|ー=ョ|ー=ｮ|ー=ヨ|ー=ﾖ|ー\n"
u8"  =ロ|ー=ﾛ|ー=ㇿ|ー=ヲ|ー=ｦ|ー=ヺ|ー\n"
u8"&[before 3]あ\n"
u8"  <<<あ|ゝ=ぁ|ゝ\n"
u8"  <<<<ア|ヽ=ｱ|ヽ=ァ|ヽ=ｧ|ヽ\n"
u8"&[before 3]い\n"
u8"  <<<い|ゝ=ぃ|ゝ\n"
u8"  <<<<イ|ヽ=ｲ|ヽ=ィ|ヽ=ｨ|ヽ\n"
u8"&[before 3]う\n"
u8"  <<<う|ゝ=ぅ|ゝ=ゔ|ゝ=う|ゞ/゙=ぅ|ゞ/゙=ゔ|ゞ/゙\n"
u8"  <<<<ウ|ヽ=ｳ|ヽ=ゥ|ヽ=ｩ|ヽ=ヴ|ヽ=ウ|ヾ/゙=ｳ|ヾ/゙=ゥ|ヾ/゙=ｩ|ヾ/゙=ヴ|ヾ/゙\n"
u8"&[before 3]え\n"
u8"  <<<え|ゝ=ぇ|ゝ\n"
u8"  <<<<エ|ヽ=ｴ|ヽ=ェ|ヽ=ｪ|ヽ\n"
u8"&[before 3]お\n"
u8"  <<<お|ゝ=ぉ|ゝ\n"
u8"  <<<<オ|ヽ=ｵ|ヽ=ォ|ヽ=ｫ|ヽ\n"
u8"&[before 3]か\n"
u8"  <<<か|ゝ=ゕ|ゝ\n"
u8"  <<<<カ|ヽ=ｶ|ヽ=ヵ|ヽ\n"
u8"&[before 3]が\n"
u8"  <<<が|ゝ\n"
u8"  <<<<ガ|ヽ\n"
u8"&[before 3]き\n"
u8"  <<<き|ゝ=ぎ|ゝ=き|ゞ/゙=ぎ|ゞ/゙\n"
u8"  <<<<キ|ヽ=ｷ|ヽ=ギ|ヽ=キ|ヾ/゙=ｷ|ヾ/゙=ギ|ヾ/゙\n"
u8"&[before 3]く\n"
u8"  <<<く|ゝ=ぐ|ゝ=く|ゞ/゙=ぐ|ゞ/゙\n"
u8"  <<<<ク|ヽ=ｸ|ヽ=ㇰ|ヽ=グ|ヽ=ク|ヾ/゙=ｸ|ヾ/゙=ㇰ|ヾ/゙=グ|ヾ/゙\n"
u8"&[before 3]け\n"
u8"  <<<け|ゝ=ゖ|ゝ\n"
u8"  <<<<ケ|ヽ=ｹ|ヽ=ヶ|ヽ\n"
u8"&[before 3]げ\n"
u8"  <<<げ|ゝ\n"
u8"  <<<<ゲ|ヽ\n"
u8"&[before 3]こ\n"
u8"  <<<こ|ゝ=ご|ゝ=こ|ゞ/゙=ご|ゞ/゙\n"
u8"  <<<<コ|ヽ=ｺ|ヽ=ゴ|ヽ=コ|ヾ/゙=ｺ|ヾ/゙=ゴ|ヾ/゙\n"
u8"&[before 3]さ\n"
u8"  <<<さ|ゝ=ざ|ゝ=さ|ゞ/゙=ざ|ゞ/゙\n"
u8"  <<<<サ|ヽ=ｻ|ヽ=ザ|ヽ=サ|ヾ/゙=ｻ|ヾ/゙=ザ|ヾ/゙\n"
u8"&[before 3]し\n"
u8"  <<<し|ゝ=じ|ゝ=し|ゞ/゙=じ|ゞ/゙\n"
u8"  <<<<シ|ヽ=ｼ|ヽ=ㇱ|ヽ=ジ|ヽ=シ|ヾ/゙=ｼ|ヾ/゙=ㇱ|ヾ/゙=ジ|ヾ/゙\n"
u8"&[before 3]す\n"
u8"  <<<す|ゝ=ず|ゝ=す|ゞ/゙=ず|ゞ/゙\n"
u8"  <<<<ス|ヽ=ｽ|ヽ=ㇲ|ヽ=ズ|ヽ=ス|ヾ/゙=ｽ|ヾ/゙=ㇲ|ヾ/゙=ズ|ヾ/゙\n"
u8"&[before 3]せ\n"
u8"  <<<せ|ゝ=ぜ|ゝ=せ|ゞ/゙=ぜ|ゞ/゙\n"
u8"  <<<<セ|ヽ=ｾ|ヽ=ゼ|ヽ=セ|ヾ/゙=ｾ|ヾ/゙=ゼ|ヾ/゙\n"
u8"&[before 3]そ\n"
u8"  <<<そ|ゝ=ぞ|ゝ=そ|ゞ/゙=ぞ|ゞ/゙\n"
u8"  <<<<ソ|ヽ=ｿ|ヽ=ゾ|ヽ=ソ|ヾ/゙=ｿ|ヾ/゙=ゾ|ヾ/゙\n"
u8"&[before 3]た\n"
u8"  <<<た|ゝ=だ|ゝ=た|ゞ/゙=だ|ゞ/゙\n"
u8"  <<<<タ|ヽ=ﾀ|ヽ=ダ|ヽ=タ|ヾ/゙=ﾀ|ヾ/゙=ダ|ヾ/゙\n"
u8"&[before 3]ち\n"
u8"  <<<ち|ゝ=ぢ|ゝ=ち|ゞ/゙=ぢ|ゞ/゙\n"
u8"  <<<<チ|ヽ=ﾁ|ヽ=ヂ|ヽ=チ|ヾ/゙=ﾁ|ヾ/゙=ヂ|ヾ/゙\n"
u8"&[before 3]つ\n"
u8"  <<<つ|ゝ=っ|ゝ=づ|ゝ=つ|ゞ/゙=づ|ゞ/゙=つ|ゝ=っ|ゞ/゙=つ|ゞ/゙\n"
u8"  <<<<ツ|ヽ=ﾂ|ヽ=ッ|ヽ=ｯ|ヽ=ヅ|ヽ=ツ|ヾ/゙=ﾂ|ヾ/゙=ヅ|ヾ/゙=ツ|ヽ=ﾂ|ヽ=ッ|ヾ/゙=ｯ|ヾ/゙=ツ|ヾ/゙=ﾂ|ヾ/゙\n"
u8"&[before 3]て\n"
u8"  <<<て|ゝ=で|ゝ=て|ゞ/゙=で|ゞ/゙\n"
u8"  <<<<テ|ヽ=ﾃ|ヽ=デ|ヽ=テ|ヾ/゙=ﾃ|ヾ/゙=デ|ヾ/゙\n"
u8"&[before 3]と\n"
u8"  <<<と|ゝ=ど|ゝ=と|ゞ/゙=ど|ゞ/゙\n"
u8"  <<<<ト|ヽ=ﾄ|ヽ=ㇳ|ヽ=ド|ヽ=ト|ヾ/゙=ﾄ|ヾ/゙=ㇳ|ヾ/゙=ド|ヾ/゙\n"
u8"&[before 3]な\n"
u8"  <<<な|ゝ\n"
u8"  <<<<ナ|ヽ=ﾅ|ヽ\n"
u8"&[before 3]に\n"
u8"  <<<に|ゝ\n"
u8"  <<<<ニ|ヽ=ﾆ|ヽ\n"
u8"&[before 3]ぬ\n"
u8"  <<<ぬ|ゝ\n"
u8"  <<<<ヌ|ヽ=ﾇ|ヽ=ㇴ|ヽ\n"
u8"&[before 3]ね\n"
u8"  <<<ね|ゝ\n"
u8"  <<<<ネ|ヽ=ﾈ|ヽ\n"
u8"&[before 3]の\n"
u8"  <<<の|ゝ\n"
u8"  <<<<ノ|ヽ=ﾉ|ヽ\n"
u8"&[before 3]は\n"
u8"  <<<は|ゝ=ば|ゝ=は|ゞ/゙=ば|ゞ/゙=ぱ|ゝ=ぱ|ゞ/゙\n"
u8"  <<<<ハ|ヽ=ﾊ|ヽ=ㇵ|ヽ=バ|ヽ=ハ|ヾ/゙=ﾊ|ヾ/゙=ㇵ|ヾ/゙=バ|ヾ/゙=パ|ヽ=パ|ヾ/゙\n"
u8"&[before 3]ひ\n"
u8"  <<<ひ|ゝ=び|ゝ=ひ|ゞ/゙=び|ゞ/゙=ぴ|ゝ=ぴ|ゞ/゙\n"
u8"  <<<<ヒ|ヽ=ﾋ|ヽ=ㇶ|ヽ=ビ|ヽ=ヒ|ヾ/゙=ﾋ|ヾ/゙=ㇶ|ヾ/゙=ビ|ヾ/゙=ピ|ヽ=ピ|ヾ/゙\n"
u8"&[before 3]ふ\n"
u8"  <<<ふ|ゝ=ぶ|ゝ=ふ|ゞ/゙=ぶ|ゞ/゙=ぷ|ゝ=ぷ|ゞ/゙\n"
u8"  <<<<フ|ヽ=ﾌ|ヽ=ㇷ|ヽ=ブ|ヽ=フ|ヾ/゙=ﾌ|ヾ/゙=ㇷ|ヾ/゙=ブ|ヾ/゙=プ|ヽ=プ|ヾ/゙\n"
u8"&[before 3]へ\n"
u8"  <<<へ|ゝ=べ|ゝ=へ|ゞ/゙=べ|ゞ/゙=ぺ|ゝ=ぺ|ゞ/゙\n"
u8"  <<<<ヘ|ヽ=ﾍ|ヽ=ㇸ|ヽ=ベ|ヽ=ヘ|ヾ/゙=ﾍ|ヾ/゙=ㇸ|ヾ/゙=ベ|ヾ/゙=ペ|ヽ=ペ|ヾ/゙\n"
u8"&[before 3]ほ\n"
u8"  <<<ほ|ゝ=ぼ|ゝ=ほ|ゞ/゙=ぼ|ゞ/゙=ぽ|ゝ=ぽ|ゞ/゙\n"
u8"  <<<<ホ|ヽ=ﾎ|ヽ=ㇹ|ヽ=ボ|ヽ=ホ|ヾ/゙=ﾎ|ヾ/゙=ㇹ|ヾ/゙=ボ|ヾ/゙=ポ|ヽ=ポ|ヾ/゙\n"
u8"&[before 3]ま\n"
u8"  <<<ま|ゝ\n"
u8"  <<<<マ|ヽ=ﾏ|ヽ\n"
u8"&[before 3]み\n"
u8"  <<<み|ゝ\n"
u8"  <<<<ミ|ヽ=ﾐ|ヽ\n"
u8"&[before 3]む\n"
u8"  <<<む|ゝ\n"
u8"  <<<<ム|ヽ=ﾑ|ヽ=ㇺ|ヽ\n"
u8"&[before 3]め\n"
u8"  <<<め|ゝ\n"
u8"  <<<<メ|ヽ=ﾒ|ヽ\n"
u8"&[before 3]も\n"
u8"  <<<も|ゝ\n"
u8"  <<<<モ|ヽ=ﾓ|ヽ\n"
u8"&[before 3]や\n"
u8"  <<<や|ゝ=ゃ|ゝ\n"
u8"  <<<<ヤ|ヽ=ﾔ|ヽ=ャ|ヽ=ｬ|ヽ\n"
u8"&[before 3]ゆ\n"
u8"  <<<ゆ|ゝ=ゅ|ゝ\n"
u8"  <<<<ユ|ヽ=ﾕ|ヽ=ュ|ヽ=ｭ|ヽ\n"
u8"&[before 3]よ\n"
u8"  <<<よ|ゝ=ょ|ゝ\n"
u8"  <<<<ヨ|ヽ=ﾖ|ヽ=ョ|ヽ=ｮ|ヽ\n"
u8"&[before 3]ら\n"
u8"  <<<ら|ゝ\n"
u8"  <<<<ラ|ヽ=ﾗ|ヽ=ㇻ|ヽ\n"
u8"&[before 3]り\n"
u8"  <<<り|ゝ\n"
u8"  <<<<リ|ヽ=ﾘ|ヽ=ㇼ|ヽ\n"
u8"&[before 3]る\n"
u8"  <<<る|ゝ\n"
u8"  <<<<ル|ヽ=ﾙ|ヽ=ㇽ|ヽ\n"
u8"&[before 3]れ\n"
u8"  <<<れ|ゝ\n"
u8"  <<<<レ|ヽ=ﾚ|ヽ=ㇾ|ヽ\n"
u8"&[before 3]ろ\n"
u8"  <<<ろ|ゝ\n"
u8"  <<<<ロ|ヽ=ﾛ|ヽ=ㇿ|ヽ\n"
u8"&[before 3]わ\n"
u8"  <<<わ|ゝ=ゎ|ゝ=わ|ゞ/゙=ゎ|ゞ/゙\n"
u8"  <<<<ワ|ヽ=ﾜ|ヽ=ヮ|ヽ=ヷ|ヽ=ワ|ヾ/゙=ﾜ|ヾ/゙=ヷ|ヾ/゙=ヮ|ヾ/゙\n"
u8"&[before 3]ゐ\n"
u8"  <<<ゐ|ゝ=ゐ|ゞ/゙\n"
u8"  <<<<ヰ|ヽ=ヸ|ヽ=ヰ|ヾ/゙=ヸ|ヾ/゙\n"
u8"&[before 3]ゑ\n"
u8"  <<<ゑ|ゝ=ゑ|ゞ/゙\n"
u8"  <<<<ヱ|ヽ=ヹ|ヽ=ヱ|ヾ/゙=ヹ|ヾ/゙\n"
u8"&[before 3]を\n"
u8"  <<<を|ゝ=を|ゞ/゙\n"
u8"  <<<<ヲ|ヽ=ｦ|ヽ=ヺ|ヽ=ヲ|ヾ/゙=ｦ|ヾ/゙=ヺ|ヾ/゙\n"
u8"&[before 3]ん\n"
u8"  <<<ん|ゝ\n"
u8"  <<<<ン|ヽ=ﾝ|ヽ\n"
u8"&ぁ<<<<ァ=ｧ\n"
u8"&あ<<<<ア=ｱ\n"
u8"&ぃ<<<<ィ=ｨ\n"
u8"&い<<<<イ=ｲ\n"
u8"&ぅ<<<<ゥ=ｩ\n"
u8"&う<<<<ウ=ｳ\n"
u8"&ぇ<<<<ェ=ｪ\n"
u8"&え<<<<エ=ｴ\n"
u8"&ぉ<<<<ォ=ｫ\n"
u8"&お<<<<オ=ｵ\n"
u8"&か<<<<カ=ｶ\n"
u8"&き<<<<キ=ｷ\n"
u8"&く<<<<ク=ｸ\n"
u8"&け<<<<ケ=ｹ\n"
u8"&こ<<<<コ=ｺ\n"
u8"&さ<<<<サ=ｻ\n"
u8"&し<<<<シ=ｼ\n"
u8"&す<<<<ス=ｽ\n"
u8"&せ<<<<セ=ｾ\n"
u8"&そ<<<<ソ=ｿ\n"
u8"&た<<<<タ=ﾀ\n"
u8"&ち<<<<チ=ﾁ\n"
u8"&っ<<<<ッ=ｯ\n"
u8"&つ<<<<ツ=ﾂ\n"
u8"&て<<<<テ=ﾃ\n"
u8"&と<<<<ト=ﾄ\n"
u8"&な<<<<ナ=ﾅ\n"
u8"&に<<<<ニ=ﾆ\n"
u8"&ぬ<<<<ヌ=ﾇ\n"
u8"&ね<<<<ネ=ﾈ\n"
u8"&の<<<<ノ=ﾉ\n"
u8"&は<<<<ハ=ﾊ\n"
u8"&ひ<<<<ヒ=ﾋ\n"
u8"&ふ<<<<フ=ﾌ\n"
u8"&へ<<<<ヘ=ﾍ\n"
u8"&ほ<<<<ホ=ﾎ\n"
u8"&ま<<<<マ=ﾏ\n"
u8"&み<<<<ミ=ﾐ\n"
u8"&む<<<<ム=ﾑ\n"
u8"&め<<<<メ=ﾒ\n"
u8"&も<<<<モ=ﾓ\n"
u8"&ゃ<<<<ャ=ｬ\n"
u8"&や<<<<ヤ=ﾔ\n"
u8"&ゅ<<<<ュ=ｭ\n"
u8"&ゆ<<<<ユ=ﾕ\n"
u8"&ょ<<<<ョ=ｮ\n"
u8"&よ<<<<ヨ=ﾖ\n"
u8"&ら<<<<ラ=ﾗ\n"
u8"&り<<<<リ=ﾘ\n"
u8"&る<<<<ル=ﾙ\n"
u8"&れ<<<<レ=ﾚ\n"
u8"&ろ<<<<ロ=ﾛ\n"
u8"&ゎ<<<<ヮ\n"
u8"&わ<<<<ワ=ﾜ\n"
u8"&ゐ<<<<ヰ\n"
u8"&ゑ<<<<ヱ\n"
u8"&を<<<<ヲ=ｦ\n"
u8"&ん<<<<ン=ﾝ\n"
u8"&ゕ<<<<ヵ\n"
u8"&ゖ<<<<ヶ\n"
u8"&より\n"
u8"  <<ゟ\n"
u8"&コト\n"
u8"  <<ヿ\n"
u8"&'\\u0020'=*'\\u3000'￣\n"
u8"&'!'=！\n"
u8"&'\\u0022'=＂\n"
u8"&'\\u0023'=＃\n"
u8"&'$'=＄\n"
u8"&'%'=％\n"
u8"&'&'=＆\n"
u8"&''=＇\n"
u8"&'('=（\n"
u8"&')'=）\n"
u8"&'*'=＊\n"
u8"&'+'=＋\n"
u8"&','=，\n"
u8"&'-'=－\n"
u8"&'.'=．\n"
u8"&'/'=／\n"
u8"&0=０\n"
u8"&1=１\n"
u8"&2=２\n"
u8"&3=３\n"
u8"&4=４\n"
u8"&5=５\n"
u8"&6=６\n"
u8"&7=７\n"
u8"&8=８\n"
u8"&9=９\n"
u8"&':'=：\n"
u8"&';'=；\n"
u8"&'<'=＜\n"
u8"&'='=＝\n"
u8"&'>'=＞\n"
u8"&'?'=？\n"
u8"&'@'=＠\n"
u8"&A=Ａ\n"
u8"&B=Ｂ\n"
u8"&C=Ｃ\n"
u8"&D=Ｄ\n"
u8"&E=Ｅ\n"
u8"&F=Ｆ\n"
u8"&G=Ｇ\n"
u8"&H=Ｈ\n"
u8"&I=Ｉ\n"
u8"&J=Ｊ\n"
u8"&K=Ｋ\n"
u8"&L=Ｌ\n"
u8"&M=Ｍ\n"
u8"&N=Ｎ\n"
u8"&O=Ｏ\n"
u8"&P=Ｐ\n"
u8"&Q=Ｑ\n"
u8"&R=Ｒ\n"
u8"&S=Ｓ\n"
u8"&T=Ｔ\n"
u8"&U=Ｕ\n"
u8"&V=Ｖ\n"
u8"&W=Ｗ\n"
u8"&X=Ｘ\n"
u8"&Y=Ｙ\n"
u8"&Z=Ｚ\n"
u8"&'['=［\n"
u8"&'\\\\'=＼\n"
u8"&']'=］\n"
u8"&'^'=＾\n"
u8"&'_'=＿\n"
u8"&'`'=｀\n"
u8"&a=ａ\n"
u8"&b=ｂ\n"
u8"&c=ｃ\n"
u8"&d=ｄ\n"
u8"&e=ｅ\n"
u8"&f=ｆ\n"
u8"&g=ｇ\n"
u8"&h=ｈ\n"
u8"&i=ｉ\n"
u8"&j=ｊ\n"
u8"&k=ｋ\n"
u8"&l=ｌ\n"
u8"&m=ｍ\n"
u8"&n=ｎ\n"
u8"&o=ｏ\n"
u8"&p=ｐ\n"
u8"&q=ｑ\n"
u8"&r=ｒ\n"
u8"&s=ｓ\n"
u8"&t=ｔ\n"
u8"&u=ｕ\n"
u8"&v=ｖ\n"
u8"&w=ｗ\n"
u8"&x=ｘ\n"
u8"&y=ｙ\n"
u8"&z=ｚ\n"
u8"&'{'=｛\n"
u8"&'|'=｜\n"
u8"&'}'=｝\n"
u8"&'~'=～\n"
u8"&¢=￠\n"
u8"&£=￡\n"
u8"&¥=￥\n"
u8"&¦=￤\n"
u8"&¬=￢\n"
u8"&ᄀ=ﾡ=ㄱ\n"
u8"&ᄁ=ﾢ=ㄲ\n"
u8"&ᄂ=ﾤ=ㄴ\n"
u8"&ᄃ=ﾧ=ㄷ\n"
u8"&ᄄ=ﾨ=ㄸ\n"
u8"&ᄅ=ﾩ=ㄹ\n"
u8"&ᄆ=ﾱ=ㅁ\n"
u8"&ᄇ=ﾲ=ㅂ\n"
u8"&ᄈ=ﾳ=ㅃ\n"
u8"&ᄉ=ﾵ=ㅅ\n"
u8"&ᄊ=ﾶ=ㅆ\n"
u8"&ᄋ=ﾷ=ㅇ\n"
u8"&ᄌ=ﾸ=ㅈ\n"
u8"&ᄍ=ﾹ=ㅉ\n"
u8"&ᄎ=ﾺ=ㅊ\n"
u8"&ᄏ=ﾻ=ㅋ\n"
u8"&ᄐ=ﾼ=ㅌ\n"
u8"&ᄑ=ﾽ=ㅍ\n"
u8"&ᄒ=ﾾ=ㅎ\n"
u8"&ᄚ=ﾰ=ㅀ\n"
u8"&ᄡ=ﾴ=ㅄ\n"
u8"&ᅠ=ﾠ=ㅤ\n"
u8"&ᅡ=ￂ=ㅏ\n"
u8"&ᅢ=ￃ=ㅐ\n"
u8"&ᅣ=ￄ=ㅑ\n"
u8"&ᅤ=ￅ=ㅒ\n"
u8"&ᅥ=ￆ=ㅓ\n"
u8"&ᅦ=ￇ=ㅔ\n"
u8"&ᅧ=ￊ=ㅕ\n"
u8"&ᅨ=ￋ=ㅖ\n"
u8"&ᅩ=ￌ=ㅗ\n"
u8"&ᅪ=ￍ=ㅘ\n"
u8"&ᅫ=ￎ=ㅙ\n"
u8"&ᅬ=ￏ=ㅚ\n"
u8"&ᅭ=ￒ=ㅛ\n"
u8"&ᅮ=ￓ=ㅜ\n"
u8"&ᅯ=ￔ=ㅝ\n"
u8"&ᅰ=ￕ=ㅞ\n"
u8"&ᅱ=ￖ=ㅟ\n"
u8"&ᅲ=ￗ=ㅠ\n"
u8"&ᅳ=ￚ=ㅡ\n"
u8"&ᅴ=ￛ=ㅢ\n"
u8"&ᅵ=ￜ=ㅣ\n"
u8"&ᆪ=ﾣ=ㄳ\n"
u8"&ᆬ=ﾥ=ㄵ\n"
u8"&ᆭ=ﾦ=ㄶ\n"
u8"&ᆰ=ﾪ=ㄺ\n"
u8"&ᆱ=ﾫ=ㄻ\n"
u8"&ᆲ=ﾬ=ㄼ\n"
u8"&ᆳ=ﾭ=ㄽ\n"
u8"&ᆴ=ﾮ=ㄾ\n"
u8"&ᆵ=ﾯ=ㄿ\n"
u8"&₩=￦\n"
u8"&←=￩\n"
u8"&↑=￪\n"
u8"&→=￫\n"
u8"&↓=￬\n"
u8"&│=￨\n"
u8"&■=￭\n"
u8"&○=￮\n"
u8"&、=､\n"
u8"&。=｡\n"
u8"&「=｢\n"
u8"&」=｣\n"
u8"  \n"
u8"  \n");
}


}}}}

#endif
