// Copyright (C) 2020 T. Zachary Laine
//
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

// Warning! This file is autogenerated.
#ifndef BOOST_TEXT_DATA_BN_HPP
#define BOOST_TEXT_DATA_BN_HPP

#include <boost/text/string_view.hpp>


namespace boost { namespace text { namespace data { namespace bn {

inline string_view standard_collation_tailoring()
{
    return string_view((char const *)
u8R"(  
[normalization on]
[reorder Beng Deva Guru Gujr Orya Taml Telu Knda Mlym Sinh]
&ঔ<ং<ঃ<ঁ
  )");
}

inline string_view traditional_collation_tailoring()
{
    return string_view((char const *)
u8"  \n"
u8"[normalization on]\n"
u8"[reorder Beng Deva Guru Gujr Orya Taml Telu Knda Mlym Sinh]\n"
u8"&ঔ<ং<ঃ<ঁ<ক্<খ্<গ্<ঘ্<ঙ্<চ্<ছ্<জ্<ঝ্<ঞ্<ট্<ঠ্<ড্<ঢ্<ণ্<ৎ=ত্\\u200D<<ত্<থ্<দ্<ধ্<ন্<প্\n"
u8"  <ফ্<ব্<ভ্<ম্<য্<র্<ৰ্<ল্<ৱ্<শ্<ষ্<স্<হ্\n"
u8"&ক্অ=ক\n"
u8"&ক্আ=কা\n"
u8"&ক্ই=কি\n"
u8"&ক্ঈ=কী\n"
u8"&ক্উ=কু\n"
u8"&ক্ঊ=কূ\n"
u8"&ক্ঋ=কৃ\n"
u8"&ক্ৠ=কৄ\n"
u8"&ক্ঌ=কৢ\n"
u8"&ক্ৡ=কৣ\n"
u8"&ক্এ=কে\n"
u8"&ক্ঐ=কৈ\n"
u8"&ক্ও=কো\n"
u8"&ক্ঔ=কৌ\n"
u8"&খ্অ=খ\n"
u8"&খ্আ=খা\n"
u8"&খ্ই=খি\n"
u8"&খ্ঈ=খী\n"
u8"&খ্উ=খু\n"
u8"&খ্ঊ=খূ\n"
u8"&খ্ঋ=খৃ\n"
u8"&খ্ৠ=খৄ\n"
u8"&খ্ঌ=খৢ\n"
u8"&খ্ৡ=খৣ\n"
u8"&খ্এ=খে\n"
u8"&খ্ঐ=খৈ\n"
u8"&খ্ও=খো\n"
u8"&খ্ঔ=খৌ\n"
u8"&গ্অ=গ\n"
u8"&গ্আ=গা\n"
u8"&গ্ই=গি\n"
u8"&গ্ঈ=গী\n"
u8"&গ্উ=গু\n"
u8"&গ্ঊ=গূ\n"
u8"&গ্ঋ=গৃ\n"
u8"&গ্ৠ=গৄ\n"
u8"&গ্ঌ=গৢ\n"
u8"&গ্ৡ=গৣ\n"
u8"&গ্এ=গে\n"
u8"&গ্ঐ=গৈ\n"
u8"&গ্ও=গো\n"
u8"&গ্ঔ=গৌ\n"
u8"&ঘ্অ=ঘ\n"
u8"&ঘ্আ=ঘা\n"
u8"&ঘ্ই=ঘি\n"
u8"&ঘ্ঈ=ঘী\n"
u8"&ঘ্উ=ঘু\n"
u8"&ঘ্ঊ=ঘূ\n"
u8"&ঘ্ঋ=ঘৃ\n"
u8"&ঘ্ৠ=ঘৄ\n"
u8"&ঘ্ঌ=ঘৢ\n"
u8"&ঘ্ৡ=ঘৣ\n"
u8"&ঘ্এ=ঘে\n"
u8"&ঘ্ঐ=ঘৈ\n"
u8"&ঘ্ও=ঘো\n"
u8"&ঘ্ঔ=ঘৌ\n"
u8"&ঙ্অ=ঙ\n"
u8"&ঙ্আ=ঙা\n"
u8"&ঙ্ই=ঙি\n"
u8"&ঙ্ঈ=ঙী\n"
u8"&ঙ্উ=ঙু\n"
u8"&ঙ্ঊ=ঙূ\n"
u8"&ঙ্ঋ=ঙৃ\n"
u8"&ঙ্ৠ=ঙৄ\n"
u8"&ঙ্ঌ=ঙৢ\n"
u8"&ঙ্ৡ=ঙৣ\n"
u8"&ঙ্এ=ঙে\n"
u8"&ঙ্ঐ=ঙৈ\n"
u8"&ঙ্ও=ঙো\n"
u8"&ঙ্ঔ=ঙৌ\n"
u8"&চ্অ=চ\n"
u8"&চ্আ=চা\n"
u8"&চ্ই=চি\n"
u8"&চ্ঈ=চী\n"
u8"&চ্উ=চু\n"
u8"&চ্ঊ=চূ\n"
u8"&চ্ঋ=চৃ\n"
u8"&চ্ৠ=চৄ\n"
u8"&চ্ঌ=চৢ\n"
u8"&চ্ৡ=চৣ\n"
u8"&চ্এ=চে\n"
u8"&চ্ঐ=চৈ\n"
u8"&চ্ও=চো\n"
u8"&চ্ঔ=চৌ\n"
u8"&ছ্অ=ছ\n"
u8"&ছ্আ=ছা\n"
u8"&ছ্ই=ছি\n"
u8"&ছ্ঈ=ছী\n"
u8"&ছ্উ=ছু\n"
u8"&ছ্ঊ=ছূ\n"
u8"&ছ্ঋ=ছৃ\n"
u8"&ছ্ৠ=ছৄ\n"
u8"&ছ্ঌ=ছৢ\n"
u8"&ছ্ৡ=ছৣ\n"
u8"&ছ্এ=ছে\n"
u8"&ছ্ঐ=ছৈ\n"
u8"&ছ্ও=ছো\n"
u8"&ছ্ঔ=ছৌ\n"
u8"&জ্অ=জ\n"
u8"&জ্আ=জা\n"
u8"&জ্ই=জি\n"
u8"&জ্ঈ=জী\n"
u8"&জ্উ=জু\n"
u8"&জ্ঊ=জূ\n"
u8"&জ্ঋ=জৃ\n"
u8"&জ্ৠ=জৄ\n"
u8"&জ্ঌ=জৢ\n"
u8"&জ্ৡ=জৣ\n"
u8"&জ্এ=জে\n"
u8"&জ্ঐ=জৈ\n"
u8"&জ্ও=জো\n"
u8"&জ্ঔ=জৌ\n"
u8"&ঝ্অ=ঝ\n"
u8"&ঝ্আ=ঝা\n"
u8"&ঝ্ই=ঝি\n"
u8"&ঝ্ঈ=ঝী\n"
u8"&ঝ্উ=ঝু\n"
u8"&ঝ্ঊ=ঝূ\n"
u8"&ঝ্ঋ=ঝৃ\n"
u8"&ঝ্ৠ=ঝৄ\n"
u8"&ঝ্ঌ=ঝৢ\n"
u8"&ঝ্ৡ=ঝৣ\n"
u8"&ঝ্এ=ঝে\n"
u8"&ঝ্ঐ=ঝৈ\n"
u8"&ঝ্ও=ঝো\n"
u8"&ঝ্ঔ=ঝৌ\n"
u8"&ঞ্অ=ঞ\n"
u8"&ঞ্আ=ঞা\n"
u8"&ঞ্ই=ঞি\n"
u8"&ঞ্ঈ=ঞী\n"
u8"&ঞ্উ=ঞু\n"
u8"&ঞ্ঊ=ঞূ\n"
u8"&ঞ্ঋ=ঞৃ\n"
u8"&ঞ্ৠ=ঞৄ\n"
u8"&ঞ্ঌ=ঞৢ\n"
u8"&ঞ্ৡ=ঞৣ\n"
u8"&ঞ্এ=ঞে\n"
u8"&ঞ্ঐ=ঞৈ\n"
u8"&ঞ্ও=ঞো\n"
u8"&ঞ্ঔ=ঞৌ\n"
u8"&ট্অ=ট\n"
u8"&ট্আ=টা\n"
u8"&ট্ই=টি\n"
u8"&ট্ঈ=টী\n"
u8"&ট্উ=টু\n"
u8"&ট্ঊ=টূ\n"
u8"&ট্ঋ=টৃ\n"
u8"&ট্ৠ=টৄ\n"
u8"&ট্ঌ=টৢ\n"
u8"&ট্ৡ=টৣ\n"
u8"&ট্এ=টে\n"
u8"&ট্ঐ=টৈ\n"
u8"&ট্ও=টো\n"
u8"&ট্ঔ=টৌ\n"
u8"&ঠ্অ=ঠ\n"
u8"&ঠ্আ=ঠা\n"
u8"&ঠ্ই=ঠি\n"
u8"&ঠ্ঈ=ঠী\n"
u8"&ঠ্উ=ঠু\n"
u8"&ঠ্ঊ=ঠূ\n"
u8"&ঠ্ঋ=ঠৃ\n"
u8"&ঠ্ৠ=ঠৄ\n"
u8"&ঠ্ঌ=ঠৢ\n"
u8"&ঠ্ৡ=ঠৣ\n"
u8"&ঠ্এ=ঠে\n"
u8"&ঠ্ঐ=ঠৈ\n"
u8"&ঠ্ও=ঠো\n"
u8"&ঠ্ঔ=ঠৌ\n"
u8"&ড্অ=ড\n"
u8"&ড্আ=ডা\n"
u8"&ড্ই=ডি\n"
u8"&ড্ঈ=ডী\n"
u8"&ড্উ=ডু\n"
u8"&ড্ঊ=ডূ\n"
u8"&ড্ঋ=ডৃ\n"
u8"&ড্ৠ=ডৄ\n"
u8"&ড্ঌ=ডৢ\n"
u8"&ড্ৡ=ডৣ\n"
u8"&ড্এ=ডে\n"
u8"&ড্ঐ=ডৈ\n"
u8"&ড্ও=ডো\n"
u8"&ড্ঔ=ডৌ\n"
u8"&ঢ্অ=ঢ\n"
u8"&ঢ্আ=ঢা\n"
u8"&ঢ্ই=ঢি\n"
u8"&ঢ্ঈ=ঢী\n"
u8"&ঢ্উ=ঢু\n"
u8"&ঢ্ঊ=ঢূ\n"
u8"&ঢ্ঋ=ঢৃ\n"
u8"&ঢ্ৠ=ঢৄ\n"
u8"&ঢ্ঌ=ঢৢ\n"
u8"&ঢ্ৡ=ঢৣ\n"
u8"&ঢ্এ=ঢে\n"
u8"&ঢ্ঐ=ঢৈ\n"
u8"&ঢ্ও=ঢো\n"
u8"&ঢ্ঔ=ঢৌ\n"
u8"&ণ্অ=ণ\n"
u8"&ণ্আ=ণা\n"
u8"&ণ্ই=ণি\n"
u8"&ণ্ঈ=ণী\n"
u8"&ণ্উ=ণু\n"
u8"&ণ্ঊ=ণূ\n"
u8"&ণ্ঋ=ণৃ\n"
u8"&ণ্ৠ=ণৄ\n"
u8"&ণ্ঌ=ণৢ\n"
u8"&ণ্ৡ=ণৣ\n"
u8"&ণ্এ=ণে\n"
u8"&ণ্ঐ=ণৈ\n"
u8"&ণ্ও=ণো\n"
u8"&ণ্ঔ=ণৌ\n"
u8"&ত্অ=ত\n"
u8"&ত্আ=তা\n"
u8"&ত্ই=তি\n"
u8"&ত্ঈ=তী\n"
u8"&ত্উ=তু\n"
u8"&ত্ঊ=তূ\n"
u8"&ত্ঋ=তৃ\n"
u8"&ত্ৠ=তৄ\n"
u8"&ত্ঌ=তৢ\n"
u8"&ত্ৡ=তৣ\n"
u8"&ত্এ=তে\n"
u8"&ত্ঐ=তৈ\n"
u8"&ত্ও=তো\n"
u8"&ত্ঔ=তৌ\n"
u8"&থ্অ=থ\n"
u8"&থ্আ=থা\n"
u8"&থ্ই=থি\n"
u8"&থ্ঈ=থী\n"
u8"&থ্উ=থু\n"
u8"&থ্ঊ=থূ\n"
u8"&থ্ঋ=থৃ\n"
u8"&থ্ৠ=থৄ\n"
u8"&থ্ঌ=থৢ\n"
u8"&থ্ৡ=থৣ\n"
u8"&থ্এ=থে\n"
u8"&থ্ঐ=থৈ\n"
u8"&থ্ও=থো\n"
u8"&থ্ঔ=থৌ\n"
u8"&দ্অ=দ\n"
u8"&দ্আ=দা\n"
u8"&দ্ই=দি\n"
u8"&দ্ঈ=দী\n"
u8"&দ্উ=দু\n"
u8"&দ্ঊ=দূ\n"
u8"&দ্ঋ=দৃ\n"
u8"&দ্ৠ=দৄ\n"
u8"&দ্ঌ=দৢ\n"
u8"&দ্ৡ=দৣ\n"
u8"&দ্এ=দে\n"
u8"&দ্ঐ=দৈ\n"
u8"&দ্ও=দো\n"
u8"&দ্ঔ=দৌ\n"
u8"&ধ্অ=ধ\n"
u8"&ধ্আ=ধা\n"
u8"&ধ্ই=ধি\n"
u8"&ধ্ঈ=ধী\n"
u8"&ধ্উ=ধু\n"
u8"&ধ্ঊ=ধূ\n"
u8"&ধ্ঋ=ধৃ\n"
u8"&ধ্ৠ=ধৄ\n"
u8"&ধ্ঌ=ধৢ\n"
u8"&ধ্ৡ=ধৣ\n"
u8"&ধ্এ=ধে\n"
u8"&ধ্ঐ=ধৈ\n"
u8"&ধ্ও=ধো\n"
u8"&ধ্ঔ=ধৌ\n"
u8"&ন্অ=ন\n"
u8"&ন্আ=না\n"
u8"&ন্ই=নি\n"
u8"&ন্ঈ=নী\n"
u8"&ন্উ=নু\n"
u8"&ন্ঊ=নূ\n"
u8"&ন্ঋ=নৃ\n"
u8"&ন্ৠ=নৄ\n"
u8"&ন্ঌ=নৢ\n"
u8"&ন্ৡ=নৣ\n"
u8"&ন্এ=নে\n"
u8"&ন্ঐ=নৈ\n"
u8"&ন্ও=নো\n"
u8"&ন্ঔ=নৌ\n"
u8"&প্অ=প\n"
u8"&প্আ=পা\n"
u8"&প্ই=পি\n"
u8"&প্ঈ=পী\n"
u8"&প্উ=পু\n"
u8"&প্ঊ=পূ\n"
u8"&প্ঋ=পৃ\n"
u8"&প্ৠ=পৄ\n"
u8"&প্ঌ=পৢ\n"
u8"&প্ৡ=পৣ\n"
u8"&প্এ=পে\n"
u8"&প্ঐ=পৈ\n"
u8"&প্ও=পো\n"
u8"&প্ঔ=পৌ\n"
u8"&ফ্অ=ফ\n"
u8"&ফ্আ=ফা\n"
u8"&ফ্ই=ফি\n"
u8"&ফ্ঈ=ফী\n"
u8"&ফ্উ=ফু\n"
u8"&ফ্ঊ=ফূ\n"
u8"&ফ্ঋ=ফৃ\n"
u8"&ফ্ৠ=ফৄ\n"
u8"&ফ্ঌ=ফৢ\n"
u8"&ফ্ৡ=ফৣ\n"
u8"&ফ্এ=ফে\n"
u8"&ফ্ঐ=ফৈ\n"
u8"&ফ্ও=ফো\n"
u8"&ফ্ঔ=ফৌ\n"
u8"&ব্অ=ব\n"
u8"&ব্আ=বা\n"
u8"&ব্ই=বি\n"
u8"&ব্ঈ=বী\n"
u8"&ব্উ=বু\n"
u8"&ব্ঊ=বূ\n"
u8"&ব্ঋ=বৃ\n"
u8"&ব্ৠ=বৄ\n"
u8"&ব্ঌ=বৢ\n"
u8"&ব্ৡ=বৣ\n"
u8"&ব্এ=বে\n"
u8"&ব্ঐ=বৈ\n"
u8"&ব্ও=বো\n"
u8"&ব্ঔ=বৌ\n"
u8"&ভ্অ=ভ\n"
u8"&ভ্আ=ভা\n"
u8"&ভ্ই=ভি\n"
u8"&ভ্ঈ=ভী\n"
u8"&ভ্উ=ভু\n"
u8"&ভ্ঊ=ভূ\n"
u8"&ভ্ঋ=ভৃ\n"
u8"&ভ্ৠ=ভৄ\n"
u8"&ভ্ঌ=ভৢ\n"
u8"&ভ্ৡ=ভৣ\n"
u8"&ভ্এ=ভে\n"
u8"&ভ্ঐ=ভৈ\n"
u8"&ভ্ও=ভো\n"
u8"&ভ্ঔ=ভৌ\n"
u8"&ম্অ=ম\n"
u8"&ম্আ=মা\n"
u8"&ম্ই=মি\n"
u8"&ম্ঈ=মী\n"
u8"&ম্উ=মু\n"
u8"&ম্ঊ=মূ\n"
u8"&ম্ঋ=মৃ\n"
u8"&ম্ৠ=মৄ\n"
u8"&ম্ঌ=মৢ\n"
u8"&ম্ৡ=মৣ\n"
u8"&ম্এ=মে\n"
u8"&ম্ঐ=মৈ\n"
u8"&ম্ও=মো\n"
u8"&ম্ঔ=মৌ\n"
u8"&য্অ=য\n"
u8"&য্আ=যা\n"
u8"&য্ই=যি\n"
u8"&য্ঈ=যী\n"
u8"&য্উ=যু\n"
u8"&য্ঊ=যূ\n"
u8"&য্ঋ=যৃ\n"
u8"&য্ৠ=যৄ\n"
u8"&য্ঌ=যৢ\n"
u8"&য্ৡ=যৣ\n"
u8"&য্এ=যে\n"
u8"&য্ঐ=যৈ\n"
u8"&য্ও=যো\n"
u8"&য্ঔ=যৌ\n"
u8"&র্অ=র\n"
u8"&র্আ=রা\n"
u8"&র্ই=রি\n"
u8"&র্ঈ=রী\n"
u8"&র্উ=রু\n"
u8"&র্ঊ=রূ\n"
u8"&র্ঋ=রৃ\n"
u8"&র্ৠ=রৄ\n"
u8"&র্ঌ=রৢ\n"
u8"&র্ৡ=রৣ\n"
u8"&র্এ=রে\n"
u8"&র্ঐ=রৈ\n"
u8"&র্ও=রো\n"
u8"&র্ঔ=রৌ\n"
u8"&ৰ্অ=ৰ\n"
u8"&ৰ্আ=ৰা\n"
u8"&ৰ্ই=ৰি\n"
u8"&ৰ্ঈ=ৰী\n"
u8"&ৰ্উ=ৰু\n"
u8"&ৰ্ঊ=ৰূ\n"
u8"&ৰ্ঋ=ৰৃ\n"
u8"&ৰ্ৠ=ৰৄ\n"
u8"&ৰ্ঌ=ৰৢ\n"
u8"&ৰ্ৡ=ৰৣ\n"
u8"&ৰ্এ=ৰে\n"
u8"&ৰ্ঐ=ৰৈ\n"
u8"&ৰ্ও=ৰো\n"
u8"&ৰ্ঔ=ৰৌ\n"
u8"&ল্অ=ল\n"
u8"&ল্আ=লা\n"
u8"&ল্ই=লি\n"
u8"&ল্ঈ=লী\n"
u8"&ল্উ=লু\n"
u8"&ল্ঊ=লূ\n"
u8"&ল্ঋ=লৃ\n"
u8"&ল্ৠ=লৄ\n"
u8"&ল্ঌ=লৢ\n"
u8"&ল্ৡ=লৣ\n"
u8"&ল্এ=লে\n"
u8"&ল্ঐ=লৈ\n"
u8"&ল্ও=লো\n"
u8"&ল্ঔ=লৌ\n"
u8"&ৱ্অ=ৱ\n"
u8"&ৱ্আ=ৱা\n"
u8"&ৱ্ই=ৱি\n"
u8"&ৱ্ঈ=ৱী\n"
u8"&ৱ্উ=ৱু\n"
u8"&ৱ্ঊ=ৱূ\n"
u8"&ৱ্ঋ=ৱৃ\n"
u8"&ৱ্ৠ=ৱৄ\n"
u8"&ৱ্ঌ=ৱৢ\n"
u8"&ৱ্ৡ=ৱৣ\n"
u8"&ৱ্এ=ৱে\n"
u8"&ৱ্ঐ=ৱৈ\n"
u8"&ৱ্ও=ৱো\n"
u8"&ৱ্ঔ=ৱৌ\n"
u8"&শ্অ=শ\n"
u8"&শ্আ=শা\n"
u8"&শ্ই=শি\n"
u8"&শ্ঈ=শী\n"
u8"&শ্উ=শু\n"
u8"&শ্ঊ=শূ\n"
u8"&শ্ঋ=শৃ\n"
u8"&শ্ৠ=শৄ\n"
u8"&শ্ঌ=শৢ\n"
u8"&শ্ৡ=শৣ\n"
u8"&শ্এ=শে\n"
u8"&শ্ঐ=শৈ\n"
u8"&শ্ও=শো\n"
u8"&শ্ঔ=শৌ\n"
u8"&ষ্অ=ষ\n"
u8"&ষ্আ=ষা\n"
u8"&ষ্ই=ষি\n"
u8"&ষ্ঈ=ষী\n"
u8"&ষ্উ=ষু\n"
u8"&ষ্ঊ=ষূ\n"
u8"&ষ্ঋ=ষৃ\n"
u8"&ষ্ৠ=ষৄ\n"
u8"&ষ্ঌ=ষৢ\n"
u8"&ষ্ৡ=ষৣ\n"
u8"&ষ্এ=ষে\n"
u8"&ষ্ঐ=ষৈ\n"
u8"&ষ্ও=ষো\n"
u8"&ষ্ঔ=ষৌ\n"
u8"&স্অ=স\n"
u8"&স্আ=সা\n"
u8"&স্ই=সি\n"
u8"&স্ঈ=সী\n"
u8"&স্উ=সু\n"
u8"&স্ঊ=সূ\n"
u8"&স্ঋ=সৃ\n"
u8"&স্ৠ=সৄ\n"
u8"&স্ঌ=সৢ\n"
u8"&স্ৡ=সৣ\n"
u8"&স্এ=সে\n"
u8"&স্ঐ=সৈ\n"
u8"&স্ও=সো\n"
u8"&স্ঔ=সৌ\n"
u8"&হ্অ=হ\n"
u8"&হ্আ=হা\n"
u8"&হ্ই=হি\n"
u8"&হ্ঈ=হী\n"
u8"&হ্উ=হু\n"
u8"&হ্ঊ=হূ\n"
u8"&হ্ঋ=হৃ\n"
u8"&হ্ৠ=হৄ\n"
u8"&হ্ঌ=হৢ\n"
u8"&হ্ৡ=হৣ\n"
u8"&হ্এ=হে\n"
u8"&হ্ঐ=হৈ\n"
u8"&হ্ও=হো\n"
u8"&হ্ঔ=হৌ\n"
u8"&ক<<<ক়\n"
u8"&কা<<<ক়া\n"
u8"&কি<<<ক়ি\n"
u8"&কী<<<ক়ী\n"
u8"&কু<<<ক়ু\n"
u8"&কূ<<<ক়ূ\n"
u8"&কৃ<<<ক়ৃ\n"
u8"&কৄ<<<ক়ৄ\n"
u8"&কৢ<<<ক়ৢ\n"
u8"&কৣ<<<ক়ৣ\n"
u8"&কে<<<ক়ে\n"
u8"&কৈ<<<ক়ৈ\n"
u8"&কো<<<ক়ো\n"
u8"&কৌ<<<ক়ৌ\n"
u8"&ক্<<<ক়্\n"
u8"&খ<<<খ়\n"
u8"&খা<<<খ়া\n"
u8"&খি<<<খ়ি\n"
u8"&খী<<<খ়ী\n"
u8"&খু<<<খ়ু\n"
u8"&খূ<<<খ়ূ\n"
u8"&খৃ<<<খ়ৃ\n"
u8"&খৄ<<<খ়ৄ\n"
u8"&খৢ<<<খ়ৢ\n"
u8"&খৣ<<<খ়ৣ\n"
u8"&খে<<<খ়ে\n"
u8"&খৈ<<<খ়ৈ\n"
u8"&খো<<<খ়ো\n"
u8"&খৌ<<<খ়ৌ\n"
u8"&খ্<<<খ়্\n"
u8"&গ<<<গ়\n"
u8"&গা<<<গ়া\n"
u8"&গি<<<গ়ি\n"
u8"&গী<<<গ়ী\n"
u8"&গু<<<গ়ু\n"
u8"&গূ<<<গ়ূ\n"
u8"&গৃ<<<গ়ৃ\n"
u8"&গৄ<<<গ়ৄ\n"
u8"&গৢ<<<গ়ৢ\n"
u8"&গৣ<<<গ়ৣ\n"
u8"&গে<<<গ়ে\n"
u8"&গৈ<<<গ়ৈ\n"
u8"&গো<<<গ়ো\n"
u8"&গৌ<<<গ়ৌ\n"
u8"&গ্<<<গ়্\n"
u8"&জ<<<জ়\n"
u8"&জা<<<জ়া\n"
u8"&জি<<<জ়ি\n"
u8"&জী<<<জ়ী\n"
u8"&জু<<<জ়ু\n"
u8"&জূ<<<জ়ূ\n"
u8"&জৃ<<<জ়ৃ\n"
u8"&জৄ<<<জ়ৄ\n"
u8"&জৢ<<<জ়ৢ\n"
u8"&জৣ<<<জ়ৣ\n"
u8"&জে<<<জ়ে\n"
u8"&জৈ<<<জ়ৈ\n"
u8"&জো<<<জ়ো\n"
u8"&জৌ<<<জ়ৌ\n"
u8"&জ্<<<জ়্\n"
u8"&ড<<<ড়\n"
u8"&ডা<<<ড়া\n"
u8"&ডি<<<ড়ি\n"
u8"&ডী<<<ড়ী\n"
u8"&ডু<<<ড়ু\n"
u8"&ডূ<<<ড়ূ\n"
u8"&ডৃ<<<ড়ৃ\n"
u8"&ডৄ<<<ড়ৄ\n"
u8"&ডৢ<<<ড়ৢ\n"
u8"&ডৣ<<<ড়ৣ\n"
u8"&ডে<<<ড়ে\n"
u8"&ডৈ<<<ড়ৈ\n"
u8"&ডো<<<ড়ো\n"
u8"&ডৌ<<<ড়ৌ\n"
u8"&ড্<<<ড়্\n"
u8"&ঢ<<<ঢ়\n"
u8"&ঢা<<<ঢ়া\n"
u8"&ঢি<<<ঢ়ি\n"
u8"&ঢী<<<ঢ়ী\n"
u8"&ঢু<<<ঢ়ু\n"
u8"&ঢূ<<<ঢ়ূ\n"
u8"&ঢৃ<<<ঢ়ৃ\n"
u8"&ঢৄ<<<ঢ়ৄ\n"
u8"&ঢৢ<<<ঢ়ৢ\n"
u8"&ঢৣ<<<ঢ়ৣ\n"
u8"&ঢে<<<ঢ়ে\n"
u8"&ঢৈ<<<ঢ়ৈ\n"
u8"&ঢো<<<ঢ়ো\n"
u8"&ঢৌ<<<ঢ়ৌ\n"
u8"&ঢ্<<<ঢ়্\n"
u8"&ফ<<<ফ়\n"
u8"&ফা<<<ফ়া\n"
u8"&ফি<<<ফ়ি\n"
u8"&ফী<<<ফ়ী\n"
u8"&ফু<<<ফ়ু\n"
u8"&ফূ<<<ফ়ূ\n"
u8"&ফৃ<<<ফ়ৃ\n"
u8"&ফৄ<<<ফ়ৄ\n"
u8"&ফৢ<<<ফ়ৢ\n"
u8"&ফৣ<<<ফ়ৣ\n"
u8"&ফে<<<ফ়ে\n"
u8"&ফৈ<<<ফ়ৈ\n"
u8"&ফো<<<ফ়ো\n"
u8"&ফৌ<<<ফ়ৌ\n"
u8"&ফ্<<<ফ়্\n"
u8"&ব<<<ব়\n"
u8"&বা<<<ব়া\n"
u8"&বি<<<ব়ি\n"
u8"&বী<<<ব়ী\n"
u8"&বু<<<ব়ু\n"
u8"&বূ<<<ব়ূ\n"
u8"&বৃ<<<ব়ৃ\n"
u8"&বৄ<<<ব়ৄ\n"
u8"&বৢ<<<ব়ৢ\n"
u8"&বৣ<<<ব়ৣ\n"
u8"&বে<<<ব়ে\n"
u8"&বৈ<<<ব়ৈ\n"
u8"&বো<<<ব়ো\n"
u8"&বৌ<<<ব়ৌ\n"
u8"&ব্<<<ব়্\n"
u8"&য<<<য়\n"
u8"&যা<<<য়া\n"
u8"&যি<<<য়ি\n"
u8"&যী<<<য়ী\n"
u8"&যু<<<য়ু\n"
u8"&যূ<<<য়ূ\n"
u8"&যৃ<<<য়ৃ\n"
u8"&যৄ<<<য়ৄ\n"
u8"&যৢ<<<য়ৢ\n"
u8"&যৣ<<<য়ৣ\n"
u8"&যে<<<য়ে\n"
u8"&যৈ<<<য়ৈ\n"
u8"&যো<<<য়ো\n"
u8"&যৌ<<<য়ৌ\n"
u8"&য্<<<য়্\n"
u8"  \n");
}


}}}}

#endif
